<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use DB;
class ordenes_trabajos extends Model
{
    use HasFactory;


    public static function OrdenesAll()
    {


         $data = ordenes_trabajos::select(
            "estado_orden_trabajo.descripcion as descripcionestado",
         DB::raw("CONCAT(personas.nombre, ' ', personas.apellido) as nombre_completo"),
         "clientes.rut",
         "clientes.razon_social",
         "ordenes_trabajos.id","ordenes_trabajos.fecha_ingreso","ordenes_trabajos.fecha_entrega")
        ->join("clientes","clientes.id","=","ordenes_trabajos.clientes_id")
        ->join("users","users.id","=","ordenes_trabajos.operario_id")
        ->join("personas","personas.id","=","users.personas_id")
        ->join("estado_orden_trabajo","estado_orden_trabajo.id","=","ordenes_trabajos.estado_orden_trabajo_id")
           
            ->get();
  
        return $data;

    }

    public static function OrdenesShow($numeroOt = "")
    {


         $data = ordenes_trabajos::select(
            "estado_orden_trabajo.descripcion as descripcionestado",
         DB::raw("CONCAT(personas.nombre, ' ', personas.apellido) as nombre_completo"),
         "clientes.rut",
         "clientes.correo",
         "clientes.telefono",

         "clientes.razon_social",
         "ordenes_trabajos.id",
         "ordenes_trabajos.observacion",
         "ordenes_trabajos.fecha_ingreso",

         "ordenes_trabajos.fecha_entrega")
        ->join("clientes","clientes.id","=","ordenes_trabajos.clientes_id")
        ->join("users","users.id","=","ordenes_trabajos.operario_id")
        ->join("personas","personas.id","=","users.personas_id")
        ->join("estado_orden_trabajo","estado_orden_trabajo.id","=","ordenes_trabajos.estado_orden_trabajo_id")
        ->where("ordenes_trabajos.id","=",$numeroOt)
            ->get();
  
        return $data;

    }
}
