<?php

namespace App\Http\Controllers\Ordendetrabajo;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Crypt;
use App\Models\clientes;
use App\Models\servicios;
use App\Models\ordenes_trabajos;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\repuestos;
use App\Models\medios_pagos;
use App\Models\pagos;
use App\Models\repuestos_solicitados;
use App\Models\servicios_ordenes;
use DB;
use App\Models\ejecutar_servicios;
use App\Models\historial_ot_servicios;
use App\Models\equipos;
use App\Models\combustibles;
use Redirect;



use App\Models\tecnicos;






class ordendetrabajoController extends Controller
{
    /** 
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    { 
        $ordenesdetrabajo = ordenes_trabajos::OrdenesAll();

        return view('ordenesdetrabajo/ordenesdetrabajo',compact("ordenesdetrabajo"));
    }

    public function iniciar(Request $request){ 

        $ordenes_trabajos =  ordenes_trabajos::where('id', $request->idot)->firstOrFail();
        $ordenes_trabajos->estado_orden_trabajo_id = 2; //procesando
        $ordenes_trabajos->timestamps = false;
        $ordenes_trabajos->save();
        return redirect::back()->with('mensaje', 'Ot Iniciada!');

}
public function finalizar(Request $request){ 

    $ordenes_trabajos =  ordenes_trabajos::where('id', $request->idot)->firstOrFail();
    $ordenes_trabajos->estado_orden_trabajo_id = 3; //finalizado
    $ordenes_trabajos->timestamps = false;
    $ordenes_trabajos->save();
    return redirect::back()->with('mensaje', 'Ot Iniciada!');

}
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($idCliente)
    {

        

        try {
            $idCliente = Crypt::decryptString($idCliente);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
  
        $servicios =   servicios::todosLosServicios();

        $cliente =   clientes::datosDelCliente($idCliente);
        $operarios =   User::datosOperarios();
        $repuestos =   repuestos::all();
        $medios_pagos =   medios_pagos::all();
        $equipos = equipos::where("clientes_id","=",$idCliente)->get();
        $combustibles = combustibles::all();

        return view('ordenesdetrabajo/createandedit',compact("combustibles","equipos","medios_pagos","idCliente","cliente",'servicios','operarios','repuestos'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        return DB::transaction(function () use ($request) {

        
        $user = Auth::user();

//    return $request->arrayDatosTabla;
    
        $dataPrecios= $this->cacularPrecios($request->arrayDatosTabla);


    
        $fechaActualSinFormato = Carbon::now();
        
        $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');
        $descuento = ($dataPrecios["neto"] * $request->input_descuento) / 100;


        $ordenes_trabajos = new ordenes_trabajos;
        $ordenes_trabajos->fecha_ingreso	  =$fechaActual;
        $ordenes_trabajos->fecha_entrega	  =$request->fecha_entrega;
        $ordenes_trabajos->eliminado	  =0;
        $ordenes_trabajos->abono	  =$request->input_abono;
        $ordenes_trabajos->neto	  =$dataPrecios["neto"];;
        $ordenes_trabajos->iva	  =$dataPrecios["iva"];;
        $ordenes_trabajos->total	  =$dataPrecios["total"];;
        $ordenes_trabajos->descuento_pesos	  =$descuento;
        $ordenes_trabajos->descuento_porcentaje	  =$request->input_descuento;
        $ordenes_trabajos->observacion	  =$request->comentario;
        $ordenes_trabajos->fecha_creacion_registro	  ==$fechaActual;
        $ordenes_trabajos->clientes_id	  =$request->id_cliente;
        $ordenes_trabajos->estado_orden_trabajo_id	  =1; //Ingresada
        $ordenes_trabajos->sucursales_id	  =$user->sucursales_id;
        $ordenes_trabajos->users_registra_id	  =$user->id;
        $ordenes_trabajos->operario_id	  =$request->operario;
        $ordenes_trabajos->equipos_id	  =$request->seleccionaequipo;

        
         $ordenes_trabajos->timestamps = false;
        $ordenes_trabajos->save();


        $pagos = new pagos;
        $pagos->fecha		  =$fechaActual;
        $pagos->motivo		  ="abono";
        $pagos->total		  =$request->input_abono;
        $pagos->ordenes_trabajos_id	  =$ordenes_trabajos->id;
        if($request->input_abono == 0){
            $pagos->medios_pagos_id  =1; //como es cero, lo dejamos como que pagaron con efectivo

        }else{
            $pagos->medios_pagos_id  =$request->input_metodopago;

        }
        // $pagos->medios_pagos_id  =$request->input_metodopago;
        $pagos->timestamps = false;
       $pagos->save();



       $repuestos = json_decode($request->arrayDatosTablaRepuestos, true);

            // Verificar si el arreglo está vacío o contiene datos
            if (empty($repuestos)) {
            } else {
                // echo "ID: " . $repuesto['id'] . "<br>";
               
                // Recorrer el arreglo de repuestos
                foreach ($repuestos as $repuesto) {

                    $repuestos_solicitados = new repuestos_solicitados;
                    $repuestos_solicitados->recibido		  ="no";
                    $repuestos_solicitados->repuestos_id		  =$repuesto['id'];
                    $repuestos_solicitados->cantidad		  =$repuesto['cantidad'];
                    // $repuestos_solicitados->fecha_recibida	  =$ordenes_trabajos->id;
                    $repuestos_solicitados->fecha_solicitada	  =$fechaActual;
                    $repuestos_solicitados->comentario = "";
                    $repuestos_solicitados->ordenes_trabajos_id =$ordenes_trabajos->id;
                    $repuestos_solicitados->timestamps = false;
                    $repuestos_solicitados->save();
                   
                }
            }
            



            $servicios = json_decode($request->arrayDatosTabla, true);

            // Verificar si el arreglo está vacío o contiene datos
            if (empty($servicios)) {
            } else {
                // echo "ID: " . $repuesto['id'] . "<br>";
               
                // Recorrer el arreglo de servicios
                foreach ($servicios as $servicio) {

                    $servicios_ordenes = new servicios_ordenes;
                    $servicios_ordenes->servicios_id		  =$servicio['id'];
                    $servicios_ordenes->cantidad		  =$servicio['cantidad'];
                    $servicios_ordenes->fecha_solicitado	  =$fechaActual;
                    $servicios_ordenes->ordentes_trabajos_id =$ordenes_trabajos->id;
                    $servicios_ordenes->finalizado ="no";

                    $servicios_ordenes->timestamps = false;
                    $servicios_ordenes->save();


                    
                    $ejecutar_servicios = new ejecutar_servicios;
                    $ejecutar_servicios->descripcion		  ="solicitud ingresada";
                    $ejecutar_servicios->estado		  =0;
                    $ejecutar_servicios->servicios_ordenes_id	  =$servicios_ordenes->id;
                    $ejecutar_servicios->tecnicos_id =1; //lo agregamos a un tecnico invisble
                    $ejecutar_servicios->fecha_ingreso	  =$fechaActual;
                    
                    // $ejecutar_servicios->fecha_ejecucion ="no";
                    // $ejecutar_servicios->fecha_finalzado ="no";
                    $ejecutar_servicios->estado_ejecucion_id =1; // ingresada

                    
                    $ejecutar_servicios->timestamps = false;
                    $ejecutar_servicios->save();


                    $historial_ot_servicios = new historial_ot_servicios;
                    $historial_ot_servicios->fecha_ingresado =  $fechaActual;
                    $historial_ot_servicios->descripcion ="solicitud ingresada";
                    $historial_ot_servicios->servicios_ordenes_id  =$servicios_ordenes->id;
                
                    $historial_ot_servicios->timestamps = false;
                    $historial_ot_servicios->save();
                }
            }

            
            return redirect()->route('ordendetrabajo')->with('mensaje', 'Operación exitosa!');

       
        }, 5);
// return $ordenes_trabajos;




        // $ordenes_trabajos->comunas_id	 =$request->comuna;
        // $ordenes_trabajos->tipo	  = "usuario";
        // $ordenes_trabajos->timestamps = false;
        // $ordenes_trabajos->save();
        // return $request->arrayDatosTabla;
       



        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


     public function cacularPrecios($servicios){


        $data = json_decode($servicios, true);
         $total =   0; 
         $neto =   0; 


// Verificar si la decodificación fue exitosa
if ($data !== null) {
    // Recorrer el arreglo
    foreach ($data as $item) {
    
       // echo "Precio neto: " . $item['precio_neto'] . "<br>";
       // echo "Cantidad: " . $item['cantidad'] . "<br>";
        //echo "Total: " . $item['total'] . "<br>";
        $total = $total + $item['total'];
        $neto = $neto + ( $item['precio_neto'] * $item['cantidad']);

    }
} else {
    echo "Error al decodificar JSON.";
}

        return [
            'total'=> $total,
            'neto'=> $neto,
            'iva'=> 0,
        ];
     }

    public function show($id)
    {

        $servicios =   servicios::todosLosServicios();
        $numeroOt = $id;
        $ordenes_trabajos = ordenes_trabajos::OrdenesShow($id);
        // $cliente =   clientes::datosDelCliente($idCliente);
        $operarios =   User::datosOperarios();
        $repuestos =   repuestos::all();
        $medios_pagos =   medios_pagos::all();

        $servicios_ordenes = servicios_ordenes::showOrdenesServicios($id);
        $tecnicos = User::datosTecnicoUserAll();

         $repuestos_solicitados = repuestos_solicitados::showOrdenesRepuestos($id);



        return view('ordenesdetrabajo/showot',compact("repuestos_solicitados","tecnicos","servicios_ordenes","numeroOt","ordenes_trabajos","medios_pagos",'servicios','operarios','repuestos'));

        
        return  $id;
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
