<?php

namespace App\Http\Controllers\Clientes;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\direcciones;
use App\Models\clientes;
use App\Models\regions;
use App\Models\combustibles;
use App\Models\equipos;


use DB;

class clientesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      $clientes =   clientes::todosLosClientes();
       
        return view('clientes/clientes',compact("clientes"));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         //regiones

         $regiones =          regions::orderBy('des_region', 'asc')->get();
         $combustibles = combustibles::all();

        return view('clientes/createandedit',compact("combustibles","regiones"));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $req)
    {

   
          

        $rules = [
          
            "rut" => 'required',
            "razon_social" => 'required',
            "giro" => 'required',
            "telefono" => 'required',
            "correo" => 'required',
            "direccion" => 'required',
            "region" => 'required',
            "comuna" => 'required',
            "observacion" => 'required',
        ];
        $messages = [

            "rut" => 'campo requerido',
            "razon_social" => 'campo requerido',
            "giro" => 'campo requerido',
            "telefono" => 'campo requerido',
            "correo" => 'campo requerido',
            "direccion" => 'campo requerido',
            "region" => 'campo requerido',
            "comuna" => 'campo requerido',
            "observacion" => 'campo requerido',


        ];
        $this->validate($req, $rules,$messages);


        return DB::transaction(function () use ($req) {





            $dataDirecciones=[
                // 'name' => $data['name'],
                'nombre' => $req->direccion,
                'estado' => 0,
                'regions_id' => 1,
                'tipo' => "cliente",
                'comuna'=>$req->comuna
                
            ];

            $insertDirecciones=  direcciones::crearDireccion($dataDirecciones);

            
             $clientes = new clientes;
             $clientes->razon_social	 = $req->razon_social;
             $clientes->rut	  = $req->rut;
             $clientes->giro	  = $req->giro;
             $clientes->telefono	  = $req->telefono;
             $clientes->correo	  = $req->correo;
             $clientes->sucursales_id	  = 1;
             $clientes->eliminado	  = 0;

             $clientes->direcciones_id	  = $insertDirecciones;
             
             $clientes->timestamps = false;
             $clientes->save();
             
               

                $equipos = new equipos;
                $equipos->descripcion	  =$req->descripcion_equipo;
                $equipos->modelo	  =$req->modelo_equipo;
                $equipos->marca	   =$req->marca_equipo;
                $equipos->motor	  =$req->motor_equipo;
                $equipos->ano	   =$req->ano_equipo;
                $equipos->serie	   =$req->serie_equipo;;;
                $equipos->combustible_id	  =$req->combustible;
                $equipos->clientes_id	  =$clientes->id;
             
                 $equipos->timestamps = false;
                $equipos->save();
// return "ok";

            // $camiones = new camiones;
            // $camiones->stock_actual	  = 0;
            // $camiones->patente	  = $req->patente;
            // $camiones->capacidad	  = $req->cantidad;
            // $camiones->descripcion	  = $req->descripcion;
            // $camiones->codigo	  = $req->codigo;
            // $camiones->id_chofer_actual	  = $req->chofer_asignado;
            // $camiones->timestamps = false;
            // $camiones->save();


            return redirect()->route('clientes')->with('mensaje', 'Operación exitosa!');


        }, 5);
        //

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
