<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tabla con Filtros</title>
    <!-- Bootstrap CSS -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

    <!-- Custom CSS -->
    <style>
        body {
            background-color: #f8f9fa;
        }
        
        .containerpro {
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            margin: 15px;
        }
        
        .table-original thead th {
            background-color: #343a40;
            color: #fff;
        }
        
        .table-striped tbody tr:nth-of-type(odd) {
            background-color: rgba(0, 0, 0, 0.05);
        }
        /* Estilo para las sugerencias de clientes */
        
        .sugerencias-clientes {
            max-height: 250px;
            /* Limita la altura de la lista para hacerla desplazable si es demasiado larga */
            overflow-y: auto;
            /* Agrega barras de desplazamiento vertical si es necesario */
        }
        /* Estilo para cada sugerencia individual */
        
        .sugerenciaCliente {
            padding: 8px 12px;
            /* Espaciado interno */
            border-bottom: 1px solid rgba(0, 0, 0, 0.1);
            /* Línea de separación con color suave y poca opacidad */
            cursor: pointer;
            /* Cursor de puntero al pasar por encima */
            transition: background-color 0.3s ease;
            /* Transición suave del color de fondo */
            width: 300px;
            /* Ancho máximo de la sugerencia */
            min-width: 200px;
            /* Ancho mínimo de la sugerencia */
        }
        /* Estilo para resaltar las sugerencias al pasar el ratón por encima */
        
        .sugerenciaCliente:hover {
            background-color: rgba(0, 0, 0, 0.05);
            /* Color de fondo suave al pasar el ratón por encima */
        }
    </style>


</head>

<body>
    <?php

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $sucursal = isset($_GET['sucursal']) ? $_GET['sucursal'] : 'sinvalor';
    $fecha = isset($_GET['customDateRange']) ? $_GET['customDateRange'] : 'sinvalor';
    $tipo_documento = isset($_GET['tipo_documento']) ? $_GET['tipo_documento'] : 'sinvalor';
    $cliente = isset($_GET['cliente']) ? $_GET['cliente'] : 'sinvalor';
    $rut = isset($_GET['rut']) ? $_GET['rut'] : 'sinvalor';
    if($sucursal==""){ $sucursal="sinvalor";}
    if($fecha==""){ $fecha="sinvalor";}
    if($tipo_documento==""){ $tipo_documento="sinvalor";}
    if($cliente==""){ $cliente="sinvalor";}
    if($rut==""){ $rut="sinvalor";}

                        // Construir los parámetros de la URL codificados en Base64
    $sucursalEncoded = base64_encode($sucursal);
    $fechaEncoded = base64_encode($fecha);
    $tipo_documentoEncoded = base64_encode($tipo_documento);
    $clienteEncoded = base64_encode($cliente);
    $rutEncoded = base64_encode($rut);

    // echo $customDateRange;
    // Construir la URL de la solicitud a la API con los parámetros codificados en Base64
    $apiUrl = "http://localhost:5800/cargarventasagrupadas/{$sucursalEncoded}/{$tipo_documentoEncoded}/{$rutEncoded}/{$fechaEncoded}/{$clienteEncoded}";
// echo $apiUrl ;


        // Realizar la solicitud GET a la API
        $json = @file_get_contents($apiUrl); // El '@' suprime los warnings
        if ($json === false) {
            // Si la solicitud falla, manejar el error
            // echo "Error: No se pudo conectar a la API.";
        } else {
            // La solicitud fue exitosa, procedemos a decodificar los datos
            $getData = json_decode($json, true);

            // Verificar si los datos están vacíos o si hay algún otro problema
            if ($getData === null) {
                echo "Error: No se pudieron decodificar los datos JSON.";
            } else {

                         if (!empty($getData["dataOt"])) {
                             $otGet  = $getData["dataOt"];
                         }
            }
        }

    // // Realizar la solicitud GET a la API
    // // $context = stream_context_create(['http' => ['method' => 'GET']]);
    // $json = file_get_contents($apiUrl);
    // $getData = json_decode($json, true);
 
    
    
    // if (!empty($getData["dataOt"])) {
    //     $otGet  = $getData["dataOt"];
    // }

    // echo  $sucursal;
    // echo  $fecha;
    // Aquí deberías incluir la lógica para recuperar y mostrar los datos filtrados en la tabla.
}
?>
        <div class="containerpro mt-4">
            <h2 class="text-center">Tabla con Filtros</h2>
            <div id="resultados"></div>

            <!-- Filtros -->
            <form method="GET" action="">
                <div class="row">
                    <div class="col-md-3 col-lg-2 mb-3 mb-lg-0">
                        <select class="form-control" id="selectSucursales" name="sucursal">
                        <!-- Opciones de sucursales -->
                        <option value="sinvalor">Todas</option>

                        <?php
                // Cargar los datos iniciales
                $url = "http://localhost:5700";
                $json = file_get_contents($url);
                $data = json_decode($json, true);

                $sucursales = $data["sucursales"];
                $medios_pago = $data["medios_pago"];
                $clientes = $data["clientes"];
                
                foreach ($sucursales as $item) {
                    $selected = ($item['id'] == ($_GET['sucursal'] ?? '')) ? 'selected' : '';
                    echo "<option value='{$item['id']}' $selected>{$item['descripcion']}</option>";
                }
                ?>
                    </select>
                    </div>
                    <div class="form-group col-md-3">
                        <!-- <label for="dateRangeSelect">Rango de Fecha</label> -->
                        <input type="text" class="form-control" id="customDateRange" name="customDateRange" value="<?php echo htmlspecialchars($_GET['customDateRange'] ?? ''); ?>">
                    </div>
                    <!-- <div class="col-md-3 col-lg-2 mb-3 mb-lg-0"> -->
                    <!-- <select class="form-control" id="selectMediosPago" name="medio_pago">
                <?php
                // foreach ($medios_pago as $item) {
                //     $selected = ($item['id'] == ($_GET['medio_pago'] ?? '')) ? 'selected' : '';
                //     echo "<option value='{$item['id']}' $selected>{$item['descripcion']}</option>";
                // }
                ?>
            </select> -->
                    <!-- </div> -->
                    <div class="col-md-3 col-lg-2 mb-3 mb-lg-0">
                        <select class="form-control" name="tipo_documento">
                        <option value="sinvalor">Todos</option>
                        <option value="factura"
                            <?= (isset($_GET['tipo_documento']) && $_GET['tipo_documento'] == 'factura') ? 'selected' : '' ?>>
                            Factura</option>
                        <option value="boleta"
                            <?= (isset($_GET['tipo_documento']) && $_GET['tipo_documento'] == 'boleta') ? 'selected' : '' ?>>
                            Boleta</option>
                        <!-- Agrega más opciones según sea necesario -->
                    </select>
                    </div>
                    <div class="col-md-3 col-lg-2 mb-3 mb-lg-0">
                        <input type="text" class="form-control" placeholder="Cliente" name="cliente" value="<?= $_GET['cliente'] ?? '' ?>" id="clienteInput">
                        <div id="sugerenciasClientes" style="cursor:pointer"></div>
                    </div>
                    <div class="col-md-3 col-lg-2">
                        <input type="text" class="form-control" placeholder="Rut" name="rut" value="<?= $_GET['rut'] ?? '' ?>">
                    </div>
                    <div class="col-md-1">
                        <button type="submit" class="btn btn-primary">Filtrar</button>
                    </div>
                </div>
            </form>


            <div class="row " style="margin-bottom:30px;margin-top:30px">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table " id="" style="background-color: #f8f9fa !important;">
                            <thead>
                                <tr>
                                    <th>Tipo Documento</th>
                                    <th>Cantidad</th>
                                    <th>Descuento</th>
                                    <th>Neto</th>
                                    <th>Iva</th>
                                    <th>Total</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php
                    // Inicializar contadores
                    $cantidadFacturas = 0;
                    $cantidadBoletas = 0;
                    $cantidadSinDocumentos = 0;

                    //BOLETAS 
                    $impuestoBoletas = 0; $descuentoBoletas = 0; $totalBoletas= 0; $subTotalBoletas= 0;
                    //FACTURAS
                    $impuestoFacturas = 0; $descuentoFacturas = 0; $totalFacturas= 0; $subTotalFacturas= 0;
                    //SIN DOCUMENTOS
                    $impuestoSdoc = 0; $descuentoSdoc = 0; $totalSdoc= 0; $subTotalSdoc= 0;


                    if (isset($otGet) && !empty($otGet)) {
                        foreach ($otGet as $item) {
                            if ($item['factura'] == 1) {
                                $impuestoFacturas = $impuestoFacturas+ $item['iva'];
                                $descuentoFacturas = $descuentoFacturas+ $item['descuento_pesos'];
                                $totalFacturas = $totalFacturas+ $item['total'];
                                $subTotalFacturas = $subTotalFacturas+ $item['sub_total'];
                                $cantidadFacturas++;
                            } elseif ($item['boleta'] == 1) {
                                $impuestoBoletas = $impuestoBoletas+ $item['iva'];
                                $descuentoBoletas = $descuentoBoletas+ $item['descuento_pesos'];
                                $totalBoletas = $totalBoletas+ $item['total'];
                                $subTotalBoletas = $subTotalBoletas+ $item['sub_total'];
                                $cantidadBoletas++;
                            } else {
                                $impuestoSdoc  = $impuestoSdoc + $item['iva'];
                                $descuentoSdoc  = $descuentoSdoc + $item['descuento_pesos'];
                                $totalSdoc  = $totalSdoc + $item['total'];
                                $subTotalSdoc  = $subTotalSdoc + $item['sub_total'];
                                $cantidadSinDocumentos++;
                            }
                        }
                    }

    // Calcular el total de documentos emitidos
    $totalDocumentos = $cantidadFacturas + $cantidadBoletas + $cantidadSinDocumentos;
    $totalImpuesto = $impuestoFacturas + $impuestoBoletas + $impuestoSdoc;
    $totalDescuento = $descuentoFacturas + $descuentoBoletas + $descuentoSdoc;
    $totalSubTotal = $subTotalFacturas + $subTotalBoletas + $subTotalSdoc;
    $totalTotal = $totalFacturas + $totalBoletas + $totalSdoc;
    ?>

                                    <tr>
                                        <td>Boleta</td>
                                        <td>
                                            <?php echo  number_format($cantidadBoletas, 0, ',', '.') ?>
                                        </td>
                                        <td>
                                            <?php echo "$". number_format($descuentoBoletas, 0, ',', '.') ?>
                                        </td>
                                        <td>
                                            <?php echo "$". number_format($subTotalBoletas, 0, ',', '.') ?>
                                        </td>
                                        <td>
                                            <?php echo "$". number_format($impuestoBoletas, 0, ',', '.') ?>
                                        </td>
                                        <td>
                                            <?php echo "$". number_format($totalBoletas, 0, ',', '.') ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Factura</td>
                                        <td>
                                            <?php echo $cantidadFacturas ?>
                                        </td>
                                        <td>
                                            <?php echo "$". number_format($descuentoFacturas, 0, ',', '.') ?>
                                        </td>
                                        <td>
                                            <?php echo "$". number_format($subTotalFacturas, 0, ',', '.') ?>
                                        </td>
                                        <td>
                                            <?php echo "$". number_format($impuestoFacturas, 0, ',', '.') ?>
                                        </td>
                                        <td>
                                            <?php echo "$". number_format($totalFacturas, 0, ',', '.') ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>S/D</td>
                                        <td>
                                            <?php echo $cantidadSinDocumentos ?>
                                        </td>
                                        <td>
                                            <?php echo "$". number_format($descuentoSdoc , 0, ',', '.') ?>
                                        </td>
                                        <td>
                                            <?php echo "$". number_format($subTotalSdoc , 0, ',', '.') ?>
                                        </td>
                                        <td>
                                            <?php echo "$". number_format($impuestoSdoc , 0, ',', '.') ?>
                                        </td>
                                        <td>
                                            <?php echo "$". number_format($totalSdoc , 0, ',', '.') ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Total</td>
                                        <td>
                                            <?php echo  number_format($totalDocumentos , 0, ',', '.')."</b>" ?>
                                        </td>
                                        <td>
                                            <?php echo "<b>$". number_format($totalDescuento , 0, ',', '.')."</b>" ?></td>
                                        <td>
                                            <?php echo "<b>$". number_format($totalSubTotal , 0, ',', '.')."</b>" ?></td>
                                        <td>
                                            <?php echo "<b>$". number_format($totalImpuesto , 0, ',', '.')."</b>" ?></td>
                                        <td>
                                            <?php echo "<b>$". number_format($totalTotal , 0, ',', '.')."</b>" ?></td>
                                    </tr>
                            </tbody>

                        </table>
                    </div>
                </div>
            </div>

            <!-- Tabla -->
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-original table-striped" id="resultTable">
                            <thead>
                                <tr>
                                    <th>Nº OT</th>
                                    <th>Sucursal</th>
                                    <th>Fecha</th>
                                    <!-- <th>Medio de Pago</th> -->
                                    <th>Tipo de Documento</th>
                                    <th>Cliente</th>
                                    <th>Rut</th>
                                    <th>Monto Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                    $totalMonto = 0; // Variable para almacenar la suma total de montos
                    if (isset($otGet) && !empty($otGet)) {
                        foreach ($otGet as $item) {
                            echo "<tr>";
                            echo "<td>" . $item['numero_ot'] ?? '' . "</td>";
                            echo "<td>" . $item['nombre_sucursal'] ?? '' . "</td>";
                            echo "<td>" . date('d-m-Y', strtotime($item['fecha_facturada'])) . "</td>";

                            if ($item['factura'] == 1) {
                                echo "<td>" . "Ver Factura" . "</td>";
                            } else if ($item['boleta'] == 1) {
                                echo "<td>" . "Ver Boleta" . "</td>";
                            } else {
                                echo "<td>" . "Sin Documento" . "</td>";
                            }

                            echo "<td>" . $item['razon_social_cliente'] . "</td>";
                            echo "<td>" . $item['rut_cliente'] . "</td>";
                            echo "<td><b>" . '$' . number_format($item['total'], 0, ',', '.') . "</b></td>";
                            $totalMonto += $item['total']; // Agregar el monto actual al total
                            echo "</tr>";
                        }
                    }
                    ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


            <!-- Total -->
            <div class="row" style="text-align: right;">
                <div class="col-md-12">
                    <h4>Total: $
                        <?php echo number_format($totalMonto, 0, ',', '.'); ?>
                    </h4>
                </div>
            </div>

            <!-- jQuery -->
            <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
            <!-- Popper.js -->
            <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
            <!-- Bootstrap JS -->
            <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
            <!-- Daterangepicker JS -->
            <script src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
            <!-- DataTables JS -->
            <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
            <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap4.min.js"></script>

            <script>
                $(function() {
                    $('input[name="customDateRange"]').daterangepicker({
                        opens: 'left',
                        locale: {
                            format: 'DD-MM-YYYY',
                            applyLabel: 'Aplicar',
                            cancelLabel: 'Cancelar',
                            fromLabel: 'Desde',
                            toLabel: 'Hasta',
                            customRangeLabel: 'Personalizado',
                            daysOfWeek: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sa'],
                            monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio',
                                'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'
                            ],
                            firstDay: 1
                        },
                        ranges: {
                            'Hoy': [moment(), moment()],
                            'Esta Semana': [moment().startOf('isoWeek'), moment().endOf('isoWeek')],
                            'Este Mes': [moment().startOf('month'), moment().endOf('month')],
                            'Mes Pasado': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1,
                                'month').endOf('month')]
                        }
                    });

                    // Inicializar DataTables
                    $('#resultTable').DataTable();
                });
            </script>



            <script>
                // Obtener los datos de clientes desde PHP y convertirlos a JavaScript
                const clientes = < ? = json_encode(array_column($clientes, 'razon_social')) ? > ;

                // Obtener referencia al campo de entrada y al contenedor de sugerencias
                const clienteInput = document.getElementById('clienteInput');
                const sugerenciasClientes = document.getElementById('sugerenciasClientes');

                // Función para mostrar las sugerencias de clientes mientras se escribe
                clienteInput.addEventListener('input', function() {
                    const valorInput = this.value.trim().toLowerCase();

                    // Limpiar el contenedor de sugerencias
                    sugerenciasClientes.innerHTML = '';

                    // Verificar si el valor del campo de entrada no está vacío ni es nulo
                    if (valorInput !== null && valorInput !== undefined && valorInput !== '') {
                        // Filtrar los clientes que coinciden con el valor del campo de entrada y limitar a 10 registros
                        const sugerencias = clientes.filter(cliente => cliente && cliente.toLowerCase().includes(
                            valorInput)).slice(0, 5);

                        // Mostrar las sugerencias
                        sugerenciasClientes.innerHTML = sugerencias.map(sugerencia =>
                            `<div class="sugerenciaCliente">${sugerencia}</div>`).join('');

                        // Agregar controlador de eventos para el clic en las sugerencias
                        document.querySelectorAll('.sugerenciaCliente').forEach(sugerencia => {
                            sugerencia.addEventListener('click', function() {
                                // Copiar el valor de la sugerencia al input
                                clienteInput.value = this.textContent;
                                // Limpiar el contenedor de sugerencias después de seleccionar una sugerencia
                                sugerenciasClientes.innerHTML = '';
                            });
                        });
                    }
                });
            </script>