const express = require('express');
const mysql = require('mysql2');
// const cors = require('cors'); // Importa el middleware cors

const app = express();

// Habilita CORS para todas las solicitudes
// app.use(cors());

// Crear una conexión a MySQL
function createConnection() {
    return mysql.createConnection({
        host: 'localhost', // Cambia esto según tu configuración
        user: 'systemnebiolo', // Cambia esto según tu configuración
        password: 'Tn9YeBuQFQJdsps', // Cambia esto según tu configuración
        database: "system_nebiolo"
    });
}

// Ruta para cargar ventas agrupadas según el parámetro de sucursal
app.get('/cargarventasagrupadas/:sucursal/:tipodocumento/:rutcliente/:fecha/:cliente/:mediopago', (req, res) => {
    const sucursal = atob(req.params.sucursal);
    var tipodocumento = atob(req.params.tipodocumento);
    const rutcliente = atob(req.params.rutcliente);
    const fechas = atob(req.params.fecha);
    const cliente = atob(req.params.cliente);
    const mediopago = atob(req.params.mediopago);

    // Crea una conexión a la base de datos
    const connection = createConnection();

    // Consulta SQL base

    let sqlTemplate = `
     SELECT
     sucursales.descripcion AS nombre_sucursal,
     pagos.fecha as fechaAbono,
     pagos.total as totalAbono,
     medios_pagos.descripcion as descripcion_medio_pago,
     medios_pagos.contabiliza,
     ordenes_trabajos.numero_ot,
     ordenes_trabajos.total_con_descuentos as sub_total,
     clientes.rut AS rut_cliente,
     clientes.razon_social AS razon_social_cliente,
     ot_facturadas.factura,
      ot_facturadas.url_dte_factura,
       ot_facturadas.boleta,
       ot_facturadas.id_ot_facturada,

      ot_facturadas.url_dte_boleta
     
 FROM
     pagos
 INNER JOIN medios_pagos ON medios_pagos.id = pagos.medios_pagos_id
 
 INNER JOIN ordenes_trabajos on   ordenes_trabajos.numero_ot =  pagos.numero_ot 
 LEFT JOIN ot_facturadas on ordenes_trabajos.numero_ot = ot_facturadas.numero_ot
 LEFT JOIN clientes on clientes.id = ot_facturadas.id_cliente
 LEFT JOIN sucursales  ON ordenes_trabajos.sucursales_id = sucursales.id
 WHERE
 pagos.total != 0  and    ordenes_trabajos.historial_ot  = 'activo' and  ordenes_trabajos.eliminado = 0  and  ot_facturadas.estado = 0 `;
    //     let sqlTemplate = `
    //     SELECT
    //     sucursales.descripcion AS nombre_sucursal,
    //     pagos.fecha as fechaAbono,
    //     pagos.total as totalAbono,
    //     medios_pagos.descripcion as descripcion_medio_pago,
    //     ordenes_trabajos.numero_ot,
    //     ordenes_trabajos.sub_total,
    //     clientes.rut AS rut_cliente,
    //     clientes.razon_social AS razon_social_cliente,
    //     ot_facturadas.factura,
    //      ot_facturadas.url_dte_factura,
    //       ot_facturadas.boleta,
    //      ot_facturadas.url_dte_boleta

    // FROM
    //     pagos
    // INNER JOIN medios_pagos ON medios_pagos.id = pagos.medios_pagos_id

    // INNER JOIN ordenes_trabajos on   ordenes_trabajos.numero_ot =  pagos.numero_ot 
    // INNER JOIN ot_facturadas on ordenes_trabajos.numero_ot = ot_facturadas.numero_ot
    // INNER JOIN clientes on clientes.id = ot_facturadas.id_cliente
    // INNER JOIN sucursales  ON ordenes_trabajos.sucursales_id = sucursales.id
    // WHERE
    // pagos.total != 0`;
    // Condiciones adicionales según los parámetros recibidos
    const conditions = [];
    const params = [];


    if (fechas !== 'sinvalor') {
        // Dividir la cadena de fechas en fecha de inicio y fecha de fin
        // let [fechaInicio, fechaFin] = fechas.split(" - ");
        // Dividir el rango de fechas en fecha de inicio y fecha de fin y convertirlas al formato YYYY-MM-DD
        let [fechaInicio, fechaFin] = fechas.split(' - ').map(date => {
            const [day, month, year] = date.split('-');
            return `${year}-${month}-${day}`;
        });

        // Ajustar el formato de las fechas para que coincida con el de la base de datos
        fechaInicio += " 00:00:00";
        fechaFin += " 23:59:59";

        // Agregar la condición para el rango de fechas
        conditions.push("pagos.fecha  BETWEEN ? AND ?");
        params.push(fechaInicio);
        params.push(fechaFin);
    }

    if (cliente !== 'sinvalor') {
        conditions.push("clientes.razon_social = ?");
        params.push(cliente);
    }

    if (mediopago !== 'sinvalor') {
        conditions.push("pagos.medios_pagos_id = ?");
        params.push(mediopago);
    }


    if (sucursal !== 'sinvalor') {
        conditions.push("ordenes_trabajos.sucursales_id = ?");
        params.push(sucursal);
    }

    if (tipodocumento !== 'sinvalor') {

        if (tipodocumento == "boleta") {
            tipodocumento = "1";
            conditions.push("ot_facturadas.boleta = ?");
            params.push(tipodocumento);
        } else if (tipodocumento == "factura") {
            tipodocumento = "1";

            conditions.push("ot_facturadas.factura = ?");
            params.push(tipodocumento);
        } else {
            tipodocumento = "0";
            conditions.push("ot_facturadas.factura = ?");
            params.push(tipodocumento);
            conditions.push("ot_facturadas.boleta = ?");
            params.push(tipodocumento);
        }

    }

    if (rutcliente !== 'sinvalor') {
        conditions.push("clientes.rut = ?");
        params.push(rutcliente);
    }

    // Agregar las condiciones a la consulta base
    if (conditions.length > 0) {
        sqlTemplate += " AND " + conditions.join(" AND ");
    } else if (conditions.length == 0) {


        // Obtener la fecha actual en formato YYYY-MM-DD HH:mm:ss
        const today = new Date();
        const year = today.getFullYear();
        const month = String(today.getMonth() + 1).padStart(2, '0');
        const day = String(today.getDate()).padStart(2, '0');
        const currentDate = `${year}-${month}-${day} 00:00:00`;
        const endOfDay = `${year}-${month}-${day} 23:59:59`;

        // Agregar la condición para el rango de fechas que incluye solo la fecha actual
        conditions.push("pagos.fecha  BETWEEN ? AND ?");
        params.push(currentDate);
        params.push(endOfDay);

        sqlTemplate += " AND " + conditions.join(" AND ");


    }

    // Imprime la consulta en la consola
    console.log('Consulta SQL:', mysql.format(sqlTemplate, params));

    // Ejecuta la consulta SQL
    connection.query(sqlTemplate, params, (error, results, fields) => {
        // Cierra la conexión a la base de datos
        connection.end();

        // Si hay un error, envía un mensaje de error al cliente
        if (error) {
            return res.status(500).json({ error: 'Error al recuperar las sucursales.', details: error });
        }

        // Si no hay resultados, envía un mensaje al cliente indicando que no se encontraron sucursales
        if (!results.length) {
            return res.status(404).json({ message: 'No se encontraron sucursales.', query: sqlTemplate });
        }

        // Si hay resultados, envía los datos de las sucursales al cliente
        res.status(200).json({ dataOt: results, query: sqlTemplate });
    });
});


// Escucha en el puerto 5800
const PORT = process.env.PORT || 5902;
app.listen(PORT, () => {
    console.log(`Servidor escuchando en el puerto ${PORT}`);
});