<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use App\Models\User;
use App\Models\tecnicos;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email', 
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];



    public static function todosLosUsuarios()
    {
       
        
        // $data = clientes::select("comunas.des_comuna","regions.des_region","clientes.id","clientes.razon_social","clientes.rut","clientes.telefono","clientes.correo","direcciones.nombre as nombre_direccion")
        // ->join("direcciones","direcciones.id","=","clientes.direcciones_id")
        // ->join("regions","regions.id","=","direcciones.regions_id")
        // ->join("comunas","comunas.id_region","=","regions.id")->get();

        $data = User::select('users.id as id_usuariio',"personas.*","comunas.des_comuna","regions.des_region")
        ->join("personas","personas.id","=","users.personas_id")
        // ->join("nacionalidades","nacionalidades.id","=","personas.nacionalidades_id")
        ->join("direcciones","direcciones.id","=","personas.direcciones_id")
          ->join("comunas","comunas.id","=","direcciones.comunas_id")
         ->join("regions","regions.id","=","comunas.id_region")->get();
        return $data;
    }
     public static function validarRutUser($req)
    {
       
        return $req;
    }

    public static function validarCorreoUser($req)
    {
       
        return $req;
    }

    public static function datosChofer()
    {
        $data = User::select("personas.nombre","personas.apellido","users.id as id_user")
    
       ->join("personas","personas.id","=","users.personas_id")->where("users.tipos_usuarios_id","=",5)->where("users.eliminado","=",0)->get();
        return $data;

    }


    public static function datosOperarios()
    {
        $data = User::select("personas.nombre","personas.apellido","users.id as id_user")
    
       ->join("personas","personas.id","=","users.personas_id")->where("users.tipos_usuarios_id","=",3)->where("users.eliminado","=",0)->get();
        return $data;

    }

    public static function datosTecnicoUser($idTecnico)
    {
        
        $data = tecnicos::select("personas.nombre","personas.apellido","users.id as id_user")
        ->join("users","users.id","=","tecnicos.users_id")
       ->join("personas","personas.id","=","users.personas_id")->where("users.tipos_usuarios_id","=",4)->where("users.eliminado","=",0)->where("tecnicos.id","=",$idTecnico)->get(); //4 que son los tecnicos
        return $data[0]->nombre. " ".$data[0]->apellido ;

    }
    public static function datosTecnicoUserAll()
    {
        
        $data = tecnicos::select("personas.nombre","personas.apellido","users.id as id_user","tecnicos.id as id_tecnico")
        ->join("users","users.id","=","tecnicos.users_id")
       ->join("personas","personas.id","=","users.personas_id")->where("users.tipos_usuarios_id","=",4)->where("users.id",">",1)->where("users.eliminado","=",0)->get(); //4 que son los tecnicos
        return $data;

    }
}
