<?php

namespace App\Http\Controllers\Usuarios;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\direcciones;
use App\Models\clientes;
use App\Models\regions;
use App\Models\nacionalidades;
use App\Models\tipos_usuarios;
use App\Models\sucursales;
use App\Models\personas;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;


use DB;

class usuariosController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response 
     */
    public function index()
    {
        $usuarios =   User::todosLosUsuarios();

        return view('usuarios/usuarios',compact('usuarios'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //ret
       
        $regiones =          regions::orderBy('des_region', 'asc')->get();
        $nacionalidades= nacionalidades::all();
        $tipos_usuarios= tipos_usuarios::where("eliminado","=","0")->orderBy('descripcion', 'asc')->get();
        $sucursales= sucursales::where("eliminado","=","0")->orderBy('descripcion', 'asc')->get();

        return view('usuarios/createandedit',compact("regiones","nacionalidades","sucursales","tipos_usuarios"));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        // return $request;
        return DB::transaction(function () use ($request) {


        if($request->admin_encargado == "on"){
            $request->admin_encargado =1;
        }else{
            $request->admin_encargado =0;

        }
        
        //
        $direcciones = new direcciones;
        $direcciones->nombre	  =$request->direccion;
        $direcciones->estado	  =1;
        $direcciones->comunas_id	 =$request->comuna;
        $direcciones->tipo	  = "usuario";
        $direcciones->timestamps = false;
        $direcciones->save();

  
        
        $personas = new personas;
        $personas->nombre	  =$request->nombre;
        $personas->apellido	   =$request->apellido;
        $personas->rut	 =$request->comuna;
        $personas->fecha_nacimiento	 =$request->comuna;
        $personas->direcciones_id	 =$direcciones->id;
        $personas->telefono	 =$request->telefono;
        $personas->nacionalidades_id	  =$request->nacionalidad;
        $personas->timestamps = false;
        $personas->save();

        $correo =  "sincorreo";
        $pass =  "sinpass";
        $encargado =0;

            if ($request->correo != null){
                $correo  = $request->correo ;
            }


            if ($request->password != null){
                $pass  = Hash::make($request->password);
            }

            if ($request->has('admin_encargado') && $request->admin_encargado !== null) {
                // El parámetro 'admin_encargado' existe en la solicitud y no es nulo.
                $encargado = 1;
            } else {
                // El parámetro 'admin_encargado' no está presente o es nulo.
             $encargado = 0;
            }

        $user = new User;
        $user->email	  =$correo;
        $user->password	  = $pass;
        $user->eliminado	 =0;
        $user->sucursales_id	 =$request->sucursal;
        $user->tipos_usuarios_id	 =$request->tipos_usuarios;
        $user->encargado_sucursal	 =$encargado;
        $user->personas_id	 =$personas->id;

        
        $user->timestamps = false;
        $user->save();

        return redirect()->route('usuarios')->with('mensaje', 'Operación exitosa!');

    }, 5);
        // 'password' => Hash::make($request->password),


     



        // {"_token":"wDmN3dsndeNmyUEzNwd4824lKEJV0WyUbggxmhJz"
        //     "nombre":"ariel"
        //     "apellido":"vvalenzuela"
        //     "nacionalidad":"1"
        //     "rut":"18795022-8"
        //     "telefono":"53248056"
        //     "fecha_nacimiento":"2023-09-02"
        //     "direccion":"talca"
        //     "region":"4"
        //     "comuna":"21"
        //     "tipos_usuarios":"1"
        //     "sucursal":"1","admin_encargado":"on"
        //     "correo":"ariel@gmailc.om"
         //   "password":"123123123"}

  


          
        return $request;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
