<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\ordenesmasservicios;
use DB;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class servicios_ordenes extends Model
{
    use HasFactory;


    public static function showOrdenesServiciosAll($numeroOt = "")
    { 
        // $data = ordenes_trabajos::select("ordenes_trabajos.numero_ot","ordenes_trabajos.id as idOT")
        // ->where("ordenes_trabajos.historial_ot", "=", 'activo')
        // ->get();



        $getData = ordenes_trabajos::select(
            "estado_orden_trabajo.descripcion as descripcionestado",
         DB::raw("CONCAT(personas.nombre, ' ', personas.apellido) as nombre_completo"),
         "clientes.rut",
         "clientes.razon_social",
         "ordenes_trabajos.id"
         ,"ordenes_trabajos.fecha_ingreso"
         ,"ordenes_trabajos.numero_ot"
         ,"ordenes_trabajos.id as idOT",
         DB::raw("(SELECT descripcion FROM sucursales WHERE id = ordenes_trabajos.sucursales_id) as nombre_sucursal")
         
         ,"ordenes_trabajos.fecha_entrega")
        ->join("clientes","clientes.id","=","ordenes_trabajos.clientes_id")
        ->join("users","users.id","=","ordenes_trabajos.operario_id")
        ->join("personas","personas.id","=","users.personas_id")
        ->join("estado_orden_trabajo","estado_orden_trabajo.id","=","ordenes_trabajos.estado_orden_trabajo_id")
        ->orderByDesc('ordenes_trabajos.id')
        ->where("ordenes_trabajos.estado_orden_trabajo_id","!=",3) //no muestra las finalizadadas
        ->where("ordenes_trabajos.eliminado","=",0)

        ->where("ordenes_trabajos.historial_ot","=",'activo')
        ;

   //filtrar por usuarios
   $tipoUsuario = User::tipoUsuario();

   if(strtolower($tipoUsuario) != "admin" && strtolower($tipoUsuario) != "superadmin" && strtolower($tipoUsuario) != "operario" ){
    $getData->where("ordenes_trabajos.sucursales_id","=", Auth::user()->sucursales_id);

}

    //filtrar por usuarios
    if(strtolower($tipoUsuario) == "operario" ){

        $getData->where("ordenes_trabajos.operario_id","=", Auth::user()->id);

    }

        $tipoUsuario = User::tipoUsuario();
        //filtrar por usuarios
        // if(strtolower($tipoUsuario) != "admin" && strtolower($tipoUsuario) != "superadmin"){
        //     $data->where("ordenes_trabajos.sucursales_id","=", Auth::user()->sucursales_id);

        // };
       $data = $getData->paginate(20);
 $servicios_ordenes=[];

        foreach ($data as $ordenTrabajo) {
            $numeroOT = $ordenTrabajo->numero_ot;
            $idOT = $ordenTrabajo->idOT;

            $rutCont  = $ordenTrabajo->rut;
            $rutRaz  = $ordenTrabajo->razon_social;
            $nombre_sucursal  = $ordenTrabajo->nombre_sucursal;

            


        
            // Realiza la otra consulta utilizando el modelo DetalleOrdenTrabajo
            $detallesOT =  ordenesmasservicios::select(

                "servicios_ordenes.fecha_solicitado",
                "servicios_ordenes.id as  id_servicio_orden",
                "ejecutar_servicios.id as id_ejecucion_servicio",
                "categorias.nombre as categoria",
                "ordenesmasservicios.cantidad_servicios as  cantidad",
                "servicios_ordenes.fecha_solicitado",
                "servicios_ordenes.finalizado",
                "estado_ejecuciones.descripcion as estado_ejecucion", 
               //  "servicios_ordenes.cantidad", 
                "servicios.sku", 
                   "servicios.id",
                "servicios.nombre_servicio",
                "servicios.descripcion",
                "ejecutar_servicios.tecnicos_id",
                "ordenesmasservicios.precio_unidad",
                "ordenesmasservicios.precio_neto_total",
                "ordenesmasservicios.precio_total",
         "ordenesmasservicios.descripcion as descripcionservicio",
                
                )
                ->join("servicios_ordenes","servicios_ordenes.id","=","ordenesmasservicios.servicios_ordenes_id")
               ->join("ejecutar_servicios","ejecutar_servicios.servicios_ordenes_id","=","servicios_ordenes.id")
               ->join("estado_ejecuciones","estado_ejecuciones.id","=","ejecutar_servicios.estado_ejecucion_id")
               ->join("servicios","servicios.id","=","servicios_ordenes.servicios_id")
               ->join("categorias","categorias.id","=","servicios.categorias_id")
        ->orderBy('servicios_ordenes.id', 'asc')

               ->where("ordenesmasservicios.ordenes_trabajos_id","=",$idOT)->get();
        
            // Agrega al array de resultados
            $servicios_ordenes[] = [
                // $rutCont  = $ordenTrabajo->rut;
            // $rutRaz 
                'numero_ot' => $numeroOT,
                'id_ot' => $idOT,
                'rutcon' => $rutCont, 
                'razcon' => $rutRaz, 
                'nombre_sucursal' => $nombre_sucursal, 

                
                'detalles_ot' => $detallesOT,
            ];
        }
        // dd($servicios_ordenes);

        return  $servicios_ordenes ;

        //  $data = servicios_ordenes::select(
            $data = ordenesmasservicios::select(

         "servicios_ordenes.fecha_solicitado",
         "servicios_ordenes.id as  id_servicio_orden",
         "ejecutar_servicios.id as id_ejecucion_servicio",
         "categorias.nombre as categoria",
         "ordenesmasservicios.cantidad_servicios as  cantidad",
         "servicios_ordenes.fecha_solicitado",
         "servicios_ordenes.finalizado",
         "estado_ejecuciones.descripcion as estado_ejecucion", 
        //  "servicios_ordenes.cantidad", 
         "servicios.sku", 
            "servicios.id",
         "servicios.nombre_servicio",
         "servicios.descripcion",
         "ejecutar_servicios.tecnicos_id",
         "ordenesmasservicios.precio_unidad",
         "ordenesmasservicios.precio_neto_total",
         "ordenesmasservicios.precio_total",
         )
         ->join("servicios_ordenes","servicios_ordenes.id","=","ordenesmasservicios.servicios_ordenes_id")
        ->join("ejecutar_servicios","ejecutar_servicios.servicios_ordenes_id","=","servicios_ordenes.id")
        ->join("estado_ejecuciones","estado_ejecuciones.id","=","ejecutar_servicios.estado_ejecucion_id")
        ->join("servicios","servicios.id","=","servicios_ordenes.servicios_id")
        ->join("categorias","categorias.id","=","servicios.categorias_id")
        ->orderBy('servicios_ordenes.id', 'asc')

        ->where("ordenesmasservicios.ordenes_trabajos_id","=",$numeroOt)->get();

        return $data;

    }

    public static function EditOrdenesServicios($numeroOt = "")
    { 


        //  $data = servicios_ordenes::select(
            $data = ordenesmasservicios::select(
         
         "servicios_ordenes.fecha_solicitado",
         "servicios_ordenes.id as  id_servicio_orden",
         "ejecutar_servicios.id as id_ejecucion_servicio",
         "categorias.nombre as nombre_categoria",
         "ordenesmasservicios.cantidad_servicios as  cantidad",
         "ordenesmasservicios.descripcion as descripcionservicio",

         "servicios_ordenes.fecha_solicitado",
         "servicios_ordenes.finalizado",
         "estado_ejecuciones.descripcion as estado_ejecucion", 
        //  "servicios_ordenes.cantidad", 
         "servicios.sku", 
        //  "servicios.precio_bruto",  
        //  "servicios.precio_neto", 

        

        "ordenesmasservicios.precio_unidad as  precio_neto",
        // "ordenesmasservicios.precio_neto_total as  precio_neto",


         "servicios.precio_editable", 
         "servicios.id",

         "servicios.nombre_servicio",
         "servicios.descripcion",
         "ejecutar_servicios.tecnicos_id"
         
            
         )

         
         ->join("servicios_ordenes","servicios_ordenes.id","=","ordenesmasservicios.servicios_ordenes_id")

        ->join("ejecutar_servicios","ejecutar_servicios.servicios_ordenes_id","=","servicios_ordenes.id")
        ->join("estado_ejecuciones","estado_ejecuciones.id","=","ejecutar_servicios.estado_ejecucion_id")
        ->join("servicios","servicios.id","=","servicios_ordenes.servicios_id")
        ->join("categorias","categorias.id","=","servicios.categorias_id")

        ->orderBy('servicios_ordenes.id', 'asc')
        ->where("ordenesmasservicios.ordenes_trabajos_id","=",$numeroOt)->get();
        // ->where("servicios_ordenes.estado_servicio_historial","=","activo")->get();

  
        return $data;

    }

    public static function showOrdenesServicios($numeroOt = "")
    { 


        //  $data = servicios_ordenes::select(
            $data = ordenesmasservicios::select(

         "servicios_ordenes.fecha_solicitado",
         "servicios_ordenes.id as  id_servicio_orden",
         "ejecutar_servicios.id as id_ejecucion_servicio",
         "categorias.nombre as categoria",
         "ordenesmasservicios.cantidad_servicios as  cantidad",
         "servicios_ordenes.fecha_solicitado",
         "servicios_ordenes.finalizado",
         "estado_ejecuciones.descripcion as estado_ejecucion", 
        //  "servicios_ordenes.cantidad", 
         "servicios.sku", 
            "servicios.id",
         "servicios.nombre_servicio",
         "servicios.descripcion",
         "ejecutar_servicios.tecnicos_id",
         "ordenesmasservicios.precio_unidad",
         "ordenesmasservicios.precio_neto_total",
         "ordenesmasservicios.precio_total",
         "ordenesmasservicios.descripcion as descripcionservicio",

         
         
         )

         
         ->join("servicios_ordenes","servicios_ordenes.id","=","ordenesmasservicios.servicios_ordenes_id")

        ->join("ejecutar_servicios","ejecutar_servicios.servicios_ordenes_id","=","servicios_ordenes.id")
        ->join("estado_ejecuciones","estado_ejecuciones.id","=","ejecutar_servicios.estado_ejecucion_id")
        ->join("servicios","servicios.id","=","servicios_ordenes.servicios_id")
        ->join("categorias","categorias.id","=","servicios.categorias_id")
        // ->orderByDesc('servicios_ordenes.id')
        ->orderBy('servicios_ordenes.id', 'asc')

        ->where("ordenesmasservicios.ordenes_trabajos_id","=",$numeroOt)->get();

        // ->where("servicios_ordenes.ordentes_trabajos_id","=",$numeroOt)
        // ->where("servicios_ordenes.estado_servicio_historial","=","activo")->get();
  
        return $data;

    }



    public static function showOrdenesServiciosPrint($idOt = "")
    { 

       $datos_ot  = ordenes_trabajos::select(
        "estado_orden_trabajo.descripcion as descripcionestado",
     DB::raw("CONCAT(personas.nombre, ' ', personas.apellido) as nombre_completo"),
     "clientes.rut",
     "clientes.razon_social",
     "ordenes_trabajos.id"
     ,"ordenes_trabajos.fecha_ingreso"
     ,"ordenes_trabajos.numero_ot"

     ,"ordenes_trabajos.fecha_entrega")
    ->join("clientes","clientes.id","=","ordenes_trabajos.clientes_id")
    ->join("users","users.id","=","ordenes_trabajos.operario_id")
    ->join("personas","personas.id","=","users.personas_id")
    ->join("estado_orden_trabajo","estado_orden_trabajo.id","=","ordenes_trabajos.estado_orden_trabajo_id")
    ->orderByDesc('ordenes_trabajos.id')
    ->where("ordenes_trabajos.id","=",$idOt)->limit(1)

        ->get();
        //  $data = servicios_ordenes::select(
            $data = ordenesmasservicios::select(

         "servicios_ordenes.fecha_solicitado",
         "servicios_ordenes.id as  id_servicio_orden",
         "ejecutar_servicios.id as id_ejecucion_servicio",
         "categorias.nombre as categoria",
         "ordenesmasservicios.cantidad_servicios as  cantidad",
         "servicios_ordenes.fecha_solicitado",
         "servicios_ordenes.finalizado",
         "estado_ejecuciones.descripcion as estado_ejecucion", 
        //  "servicios_ordenes.cantidad", 
         "servicios.sku", 
            "servicios.id",
         "servicios.nombre_servicio",
         "servicios.descripcion",
         "ejecutar_servicios.tecnicos_id",
         "ordenesmasservicios.precio_unidad",
         "ordenesmasservicios.precio_neto_total",
         "ordenesmasservicios.precio_total",
         "ordenesmasservicios.descripcion as descripcionservicio",

         
         
         )

         
         ->join("servicios_ordenes","servicios_ordenes.id","=","ordenesmasservicios.servicios_ordenes_id")

        ->join("ejecutar_servicios","ejecutar_servicios.servicios_ordenes_id","=","servicios_ordenes.id")
        ->join("estado_ejecuciones","estado_ejecuciones.id","=","ejecutar_servicios.estado_ejecucion_id")
        ->join("servicios","servicios.id","=","servicios_ordenes.servicios_id")
        ->join("categorias","categorias.id","=","servicios.categorias_id")
        ->orderBy('servicios_ordenes.id', 'asc')

        ->where("ordenesmasservicios.ordenes_trabajos_id","=",$idOt)->get();

        // ->where("servicios_ordenes.ordentes_trabajos_id","=",$numeroOt)
        // ->where("servicios_ordenes.estado_servicio_historial","=","activo")->get();
  
        // Agrega al array de resultados
       return [
            // $rutCont  = $ordenTrabajo->rut;
        // $rutRaz 
            'data' => $data,
            'ordenes_trabajos' => $datos_ot,

            
            
        ];

    }



}
