<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class clientes extends Model
{
    use HasFactory;


    public static function todosLosClientes()
    {
       
        
        $data = clientes::select("comunas.des_comuna","regions.des_region","clientes.id as id_cliente","clientes.razon_social","clientes.rut","clientes.telefono","clientes.correo","direcciones.nombre as nombre_direccion")
        ->join("direcciones","direcciones.id","=","clientes.direcciones_id")
        ->join("comunas","comunas.id","=","direcciones.comunas_id")
       ->join("regions","regions.id","=","comunas.id_region")->where("eliminado","=",0)->limit(50)->paginate();
        return $data;
    } 
    public static function todosLosClientesAll()
    {
       
        
        $data = clientes::select("comunas.des_comuna","regions.des_region","clientes.id as id_cliente","clientes.razon_social","clientes.rut","clientes.telefono","clientes.correo","direcciones.nombre as nombre_direccion")
        ->join("direcciones","direcciones.id","=","clientes.direcciones_id")
        ->join("comunas","comunas.id","=","direcciones.comunas_id")
       ->join("regions","regions.id","=","comunas.id_region")->where("eliminado","=",0)->get();
        return $data;
    } 
    public static function datosDelCliente($idCliente = "")
    {
        
        
        $data = clientes::select("comunas.des_comuna","regions.des_region","regions.id as idregion","comunas.id as idcomuna","clientes.id as id_cliente","clientes.razon_social","clientes.rut","clientes.telefono","clientes.giro","clientes.rut","clientes.correo","direcciones.nombre as nombre_direccion")
        ->join("direcciones","direcciones.id","=","clientes.direcciones_id")
        ->join("comunas","comunas.id","=","direcciones.comunas_id")
       ->join("regions","regions.id","=","comunas.id_region")
       ->where("clientes.id","=",$idCliente)->get();
        return $data;
    } 

    public static function validarRutCliente($rut,$idCliente="")
    {
       
        
        $rutexiste = clientes::where("rut","=",$rut)->exists();

        if($rutexiste){

            if($idCliente != ""){

                 $selectClientes = clientes::where("id","=",$idCliente)->get();

                if( $selectClientes[0]->rut == $rut ){
                  return 0;

                }else{
                  return 1;

                }

            }else{

            return 1;

            }

            return 1;
        }else{

            return 0;
        }



    }
    public static function getRutCliente($rut)
    {
       
      
        $rutexiste =   clientes::select("comunas.id_region","direcciones.comunas_id","comunas.des_comuna","regions.des_region","clientes.id as id_cliente","clientes.razon_social","clientes.rut","clientes.telefono","clientes.correo","clientes.giro","direcciones.nombre as nombre_direccion")
        ->join("direcciones","direcciones.id","=","clientes.direcciones_id")
        ->join("comunas","comunas.id","=","direcciones.comunas_id")
       ->join("regions","regions.id","=","comunas.id_region")
       ->where("rut","=",$rut)->get();
        return $rutexiste;
    }
    public static function validarCorreoCliente($correo)
    {
        $correoexiste = clientes::where("correo","=",$correo)->exists();
        return $correoexiste;
    }
}
