<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use App\Models\User;
use App\Models\tecnicos;
use App\Models\sucursales;
use App\Models\tipos_usuarios;
use App\Models\personas;
use App\Models\chofer_equipos;

use DB;


use Illuminate\Support\Facades\Auth;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email', 
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


    public static function datosUserID($idUser)
    {
       
        
        // $data = clientes::select("comunas.des_comuna","regions.des_region","clientes.id","clientes.razon_social","clientes.rut","clientes.telefono","clientes.correo","direcciones.nombre as nombre_direccion")
        // ->join("direcciones","direcciones.id","=","clientes.direcciones_id")
        // ->join("regions","regions.id","=","direcciones.regions_id")
        // ->join("comunas","comunas.id_region","=","regions.id")->get();

        $data = User::select('direcciones.nombre as nombredireccion'
        ,'users.tipos_usuarios_id'
        ,'users.sucursales_id'
        ,'users.email'
        ,'users.id_saluds'
        ,'users.id_previsions'
        ,'users.tipos_usuarios_id'
        
        ,'users.encargado_sucursal'
        
        ,'comunas.id as idcomuna'
        ,'regions.id as idregion'
        ,'users.id as id_usuariio'
        ,"personas.*"
        ,"comunas.des_comuna","regions.des_region")
        ->join("personas","personas.id","=","users.personas_id")
        // ->join("nacionalidades","nacionalidades.id","=","personas.nacionalidades_id")
        ->join("direcciones","direcciones.id","=","personas.direcciones_id")
          ->join("comunas","comunas.id","=","direcciones.comunas_id")
         ->join("regions","regions.id","=","comunas.id_region")
         ->where("users.id","=",$idUser)
         ->get();
        return $data;
    }
    public static function todosLosUsuariosAll()
    {
       
        
        // $data = clientes::select("comunas.des_comuna","regions.des_region","clientes.id","clientes.razon_social","clientes.rut","clientes.telefono","clientes.correo","direcciones.nombre as nombre_direccion")
        // ->join("direcciones","direcciones.id","=","clientes.direcciones_id")
        // ->join("regions","regions.id","=","direcciones.regions_id")
        // ->join("comunas","comunas.id_region","=","regions.id")->get();

        $data = User::select('direcciones.nombre as nombredireccion',
        'users.tipos_usuarios_id',
        'users.sucursales_id',
        'users.id as id_usuariio',
        "personas.*",
        "comunas.des_comuna",
        DB::raw("(SELECT descripcion FROM tipos_usuarios WHERE id = users.tipos_usuarios_id) as nombre_tipo_user"),
        DB::raw("(SELECT descripcion FROM sucursales WHERE id = users.sucursales_id) as nombre_sucursal"),

        "regions.des_region")
        ->join("personas","personas.id","=","users.personas_id")
        // ->join("nacionalidades","nacionalidades.id","=","personas.nacionalidades_id")
        ->join("direcciones","direcciones.id","=","personas.direcciones_id")
          ->join("comunas","comunas.id","=","direcciones.comunas_id")
         ->join("regions","regions.id","=","comunas.id_region")
         ->where("users.eliminado","=",0)
         ->get();
        return $data;
    }

    public static function todosLosUsuarios()
    {
       
        
        // $data = clientes::select("comunas.des_comuna","regions.des_region","clientes.id","clientes.razon_social","clientes.rut","clientes.telefono","clientes.correo","direcciones.nombre as nombre_direccion")
        // ->join("direcciones","direcciones.id","=","clientes.direcciones_id")
        // ->join("regions","regions.id","=","direcciones.regions_id")
        // ->join("comunas","comunas.id_region","=","regions.id")->get();

        $data = User::select('direcciones.nombre as nombredireccion','users.tipos_usuarios_id','users.sucursales_id','users.id as id_usuariio',"personas.*","comunas.des_comuna","regions.des_region")
        ->join("personas","personas.id","=","users.personas_id")
        // ->join("nacionalidades","nacionalidades.id","=","personas.nacionalidades_id")
        ->join("direcciones","direcciones.id","=","personas.direcciones_id")
          ->join("comunas","comunas.id","=","direcciones.comunas_id")
         ->join("regions","regions.id","=","comunas.id_region")
         ->where("users.eliminado","=",0)
         ->paginate(50);
        return $data;
    }
     public static function validarRutUser($req,$idusuario)
    {
        $data = personas::where("rut","=",$req)->count();


        if($data >= 1){

            if($idusuario != ""){
                $getidusuario = personas::select("rut")->where("id","=",$idusuario)->get();

                if ($getidusuario[0]->rut == $req){
                        return 0;
                } else{
                    return 1;

                }
            }else{
                return 1;

            }
            
            

        }else{

                return 0;
        }

    }

    public static function validarCorreoUser($req,$idusuario)
    {
       
       
        $data = User::where("email","=",$req)->count();

        
        if($data >= 1){

            if($idusuario !=""){
                $getidusuario = User::select("email")->where("id","=",$idusuario)->get();

                if ($getidusuario[0]->email == $req){
                    return 0;
            } else{
                return 1;

            }

            }else{

                return 1;

            }


           

        }else{

return 0;
        }
    }

    public static function datosChofer($idSucursal = "")
    {

        if($idSucursal == ""){
            $idSucursal = Auth::user()->sucursales_id;

        }
        $data = User::select("personas.nombre","personas.apellido","users.id as id_user")
    
       ->join("personas","personas.id","=","users.personas_id")
       ->where("users.tipos_usuarios_id","=",5)
       ->where("users.sucursales_id","=",$idSucursal)
       ->where("users.eliminado","=",0)->get();
        return $data;

    }

    public static function datosdelusaurio()
    {
       
       
       
         $data = User::select("personas.nombre","personas.apellido","users.id as id_user")
    
       ->join("personas","personas.id","=","users.personas_id")->where("users.eliminado","=",0)->where("users.id","=",Auth::user()->id)->get();


        return $data[0]->nombre." ".$data[0]->apellido ;

    }

    public static function datosdelusaurioSeparados()
    {
       
       
       
        $data = User::select("personas.nombre","personas.apellido","users.id as id_user","users.sucursales_id")
    
       ->join("personas","personas.id","=","users.personas_id")->where("users.eliminado","=",0)->where("users.id","=",Auth::user()->id)->get();


        return $data ;

    }

    public static function datosOperarios()
    {

        if(User::tipoUsuario() == "superadmin" || User::tipoUsuario() == "admin"){

            $data = User::select("personas.nombre","personas.apellido","users.id as id_user")
    
            ->join("personas","personas.id","=","users.personas_id")->where("users.tipos_usuarios_id","=",3)->where("users.eliminado","=",0)->get();

        }else{
            $data = User::select("personas.nombre","personas.apellido","users.id as id_user")
    
            ->join("personas","personas.id","=","users.personas_id")->where("users.tipos_usuarios_id","=",3)->where("users.sucursales_id","=",Auth::user()->sucursales_id)->where("users.eliminado","=",0)->get();
        }
     
        return $data;

    }

    public static function datosOperarioSucursal($idsucursal)
    {

      
            $data = User::select("personas.nombre","personas.apellido","users.id as id_user")
    
            ->join("personas","personas.id","=","users.personas_id")->where("users.tipos_usuarios_id","=",3)->where("users.sucursales_id","=",$idsucursal)->where("users.eliminado","=",0)->get();
    
     
        return $data;

    }
    public static function GetChoferData($numero_ot)
    {
        
        $data =chofer_equipos::where("numero_ot","=",$numero_ot)->get();

        if ($data->isEmpty()) {
            // If $data is empty, return an empty string
            return "";
        }
        $dataChofer =  User::select("personas.nombre","personas.apellido","users.id as id_user")
    
        ->join("personas","personas.id","=","users.personas_id")->where("users.id","=",$data[0]->users_id)->get();



        return $dataChofer[0]->nombre." ".$dataChofer[0]->apellido ;
    }

    public static function datosTecnicoUser($idTecnico)
    {
        
        $data = tecnicos::select("personas.nombre","personas.apellido","users.id as id_user")
        ->join("users","users.id","=","tecnicos.users_id")
       ->join("personas","personas.id","=","users.personas_id")->where("users.tipos_usuarios_id","=",4)->where("users.eliminado","=",0)->where("tecnicos.id","=",$idTecnico)->get(); //4 que son los tecnicos
        return $data[0]->nombre. " ".$data[0]->apellido ;

    }
    public static function datosTecnicoUserAllSucursal($idSucursal)
    {
        
        $data = tecnicos::select("personas.nombre","personas.apellido","users.id as id_user","tecnicos.id as id_tecnico")
        ->join("users","users.id","=","tecnicos.users_id")
       ->join("personas","personas.id","=","users.personas_id")->where("users.tipos_usuarios_id","=",4)
       ->where("users.id",">",1)
       ->where("users.eliminado","=",0)
       ->where("users.sucursales_id","=",$idSucursal)
       ->orderBy("personas.nombre") // Order by the personas.nombre column

       ->get(); //4 que son los tecnicos
        return $data;

    }
    public static function datosTecnicoUserAll()
    {
        
        $data = tecnicos::select("personas.nombre","personas.apellido","users.id as id_user","tecnicos.id as id_tecnico")
        ->join("users","users.id","=","tecnicos.users_id")
       ->join("personas","personas.id","=","users.personas_id")
       ->where("users.tipos_usuarios_id","=",4)
       ->where("users.id",">",1)
       ->where("users.eliminado","=",0)
       ->orderBy("personas.nombre") // Order by the personas.nombre column

       ->get(); //4 que son los tecnicos
        return $data;

    }
    public static function tipoUsuario()
    {

        $tipos_usuarios_id = Auth::user()->tipos_usuarios_id;

        
        $data = tipos_usuarios::select("tipos_usuarios.descripcion")
        ->join("users","users.tipos_usuarios_id","=","tipos_usuarios.id")
        ->where("users.tipos_usuarios_id","=",$tipos_usuarios_id)->where("users.id",">",1)->where("users.eliminado","=",0)->get(); //4 que son los tecnicos
        return $data[0]->descripcion;

    }
    public static function nameBranch()
    {

        $tipos_usuarios_id = Auth::user()->tipos_usuarios_id;

        
        $data = sucursales::select("descripcion")->where("sucursales.id","=",Auth::user()->sucursales_id)->get(); //4 que son los tecnicos
        return $data[0]->descripcion;

    }

    public static function nameBranchId($id)
    {

      

        
        $data = sucursales::select("descripcion")->where("sucursales.id","=",$id)->get(); //4 que son los tecnicos
        return $data[0]->descripcion;

    }
    public static function nameBranchUserList($idSuc)
    {

        

        
        $data = sucursales::select("descripcion")->where("sucursales.id","=",$idSuc)->get(); //4 que son los tecnicos
        return $data[0]->descripcion;

    }


    public static function tiposUserList($idTipUser)
    {

        

        
        $data = tipos_usuarios::select("descripcion")->where("tipos_usuarios.id","=",$idTipUser)->get(); //4 que son los tecnicos
        return $data[0]->descripcion;

    }
}
