<?php

namespace App\Http\Controllers\Usuarios;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\direcciones;
use App\Models\clientes;
use App\Models\regions;
use App\Models\nacionalidades;
use App\Models\tipos_usuarios;
use App\Models\sucursales;
use App\Models\personas;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\tecnicos;
use App\Models\previsions;
use App\Models\saluds;
use App\Models\comunas;





use DB;

class usuariosController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response 
     */
    public function index()
    {
        $usuarios =   User::todosLosUsuarios();
        $usuariosAll =   User::todosLosUsuariosAll();
        $sucursales= sucursales::where("eliminado","=","0")->orderBy('descripcion', 'asc')->get();
        $tipos_usuarios= tipos_usuarios::where("eliminado","=","0")->orderBy('descripcion', 'asc')->get();


        return view('usuarios/usuarios',compact('usuarios',"usuariosAll","sucursales","tipos_usuarios"));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //ret
       
        $regiones =          regions::orderBy('des_region', 'asc')->get();
        $nacionalidades= nacionalidades::all();
        $tipos_usuarios= tipos_usuarios::where("eliminado","=","0")->orderBy('descripcion', 'asc')->get();
        $sucursales= sucursales::where("eliminado","=","0")->orderBy('descripcion', 'asc')->get();

        $previsions= previsions::all();
        $saluds= saluds::all();

        
        
        return view('usuarios/createandedit',compact("saluds","previsions","regiones","nacionalidades","sucursales","tipos_usuarios"));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
     $idUser = $request->idusuario;
        if($idUser == ""){

        

                // return $request;
                return DB::transaction(function () use ($request) {


                if($request->admin_encargado == "on"){
                    $request->admin_encargado =1;
                }else{
                    $request->admin_encargado =0;

                }
                
                //
                $direcciones = new direcciones;
                $direcciones->nombre	  =$request->direccion;
                $direcciones->estado	  =1;
                $direcciones->comunas_id	 =$request->comuna;
                $direcciones->tipo	  = "usuario";
                $direcciones->timestamps = false;
                $direcciones->save();

        
                
                $personas = new personas;
                $personas->nombre	  =$request->nombre;
                $personas->apellido	   =$request->apellido;
                $personas->rut	 =$request->rut;
            $personas->fecha_nacimiento	 =$request->fecha_nacimiento;
                $personas->direcciones_id	 =$direcciones->id;
                $personas->telefono	 =$request->telefono;
                $personas->telefono_emergencia	 =$request->telefono_emergencia;

                $personas->nacionalidades_id	  =$request->nacionalidad;
                $personas->timestamps = false;
                $personas->save();

                $correo =  "sincorreo";
                $pass =  "sinpass";
                $encargado =0;

                    if ($request->correo != null){
                        $correo  = $request->correo ;
                    }


                    if ($request->password != null){
                        $pass  = Hash::make($request->password);
                    }

                    if ($request->has('admin_encargado') && $request->admin_encargado !== null) {
                        // El parámetro 'admin_encargado' existe en la solicitud y no es nulo.
                        $encargado = 1;
                    } else {
                        // El parámetro 'admin_encargado' no está presente o es nulo.
                    $encargado = 0;
                    }

                $user = new User;
                $user->email	  =$correo;
                $user->password	  = $pass;
                $user->eliminado	 =0;
                $user->sucursales_id	 =$request->sucursal;
                $user->tipos_usuarios_id	 =$request->tipos_usuarios;
                $user->encargado_sucursal	 =$encargado;
                $user->personas_id	 =$personas->id;
                
                $user->id_saluds	 =$request->salud;
                $user->id_previsions	 =$request->previsions;

                
                $user->timestamps = false;
                $user->save();


                if($request->tipos_usuarios == 4){

                    $tecnicos = new tecnicos;
                    $tecnicos->tipo_trabajador	  ="tecnico";
                    $tecnicos->eliminado	  = 0;
                    $tecnicos->users_id	  = $user->id;       
                    $tecnicos->timestamps = false;
                    $tecnicos->save();
                    
                }

                return redirect()->route('usuarios')->with('mensaje', 'Operación exitosa!');

            }, 5);
       

            //COMIENZA LA EDICION
        }else{

            return DB::transaction(function () use ($request,$idUser) {

                if($request->admin_encargado == "on"){
                    $request->admin_encargado =1;
                }else{
                    $request->admin_encargado =0;

                }


                if ($request->correo != null){
                    $correo  = $request->correo ;
                }

                if ($request->has('admin_encargado') && $request->admin_encargado !== null) {
                    // El parámetro 'admin_encargado' existe en la solicitud y no es nulo.
                    $encargado = 1;
                } else {
                    // El parámetro 'admin_encargado' no está presente o es nulo.
                $encargado = 0;
                }




                $user =  User::where('id', "=",$idUser)->firstOrFail();



                $user->email	  =$correo;
                $user->sucursales_id	 =$request->sucursal;
                $user->tipos_usuarios_id	 =$request->tipos_usuarios;
                $user->encargado_sucursal	 =$encargado;
                $user->id_saluds	 =$request->salud;
                $user->id_previsions	 =$request->previsions;
                $user->timestamps = false;

                if ($request->exists('cambiar_pass')) {
                    if ($request->password != null){
                        $pass  = Hash::make($request->password);
                $user->password	  = $pass;

                    }
                }
                $user->save();

                
                // $user =  User::where('id', "=",$idUser)->firstOrFail();

                // $direcciones->nombre	  =$request->direccion;
                // $direcciones->estado	  =1;
                // $direcciones->comunas_id	 =$request->comuna;
                // $direcciones->tipo	  = "usuario";
                // $direcciones->timestamps = false;
                // $direcciones->save();

        
                $personas =  personas::where('id', "=",$user->personas_id)->firstOrFail();

                $personas->nombre	  =$request->nombre;
                $personas->apellido	   =$request->apellido;
                $personas->rut	 =$request->rut;
               $personas->fecha_nacimiento	 =$request->fecha_nacimiento;
                $personas->telefono	 =$request->telefono;
                $personas->telefono_emergencia	 =$request->telefono_emergencia;

                $personas->nacionalidades_id	  =$request->nacionalidad;
                $personas->timestamps = false;
                $personas->save();

                $direcciones =  direcciones::where('id', "=",$personas->direcciones_id)->firstOrFail();
                 $direcciones->nombre	  =$request->direccion;
                 $direcciones->comunas_id	 =$request->comuna;
                 $direcciones->timestamps = false;
                 $direcciones->save();



                return redirect()->route('usuarios')->with('mensaje', 'Operación exitosa!');

            }, 5);


        }

  


          
        return $request;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delet(request $req)
    {
        //
        $user =  User::where('id', "=",$req->iduserdelet)->firstOrFail();

        $user->eliminado	 =1;
        $user->password	 ="eliminado";
        $user->timestamps = false;
        $user->save();
        
        return redirect()->route('usuarios')->with('mensaje', 'Operación exitosa!');


    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function editar($id)
    {
        //

      $getDataUser =   User::datosUserID($id);


      $regiones =          regions::orderBy('des_region', 'asc')->get();
      $comunas =          comunas::orderBy('des_comuna', 'asc')->get();

      $nacionalidades= nacionalidades::all();
      $tipos_usuarios= tipos_usuarios::where("eliminado","=","0")->orderBy('descripcion', 'asc')->get();
      $sucursales= sucursales::where("eliminado","=","0")->orderBy('descripcion', 'asc')->get();
      $previsions= previsions::all();
      $saluds= saluds::all();

      

      return view('usuarios/createandedit',compact("id","comunas","saluds","previsions","regiones","nacionalidades","sucursales","tipos_usuarios","getDataUser"));




    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
