<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ordenes_trabajos;
use Illuminate\Support\Facades\Http;
use Carbon\Carbon;
use App\Models\User;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
       $countOtEnproceso = ordenes_trabajos::getCountOt("INICIADA");
       $countOtRecepcionada = ordenes_trabajos::getCountOt("RECEPCIONADA");
       $countOtPendientes = ordenes_trabajos::getCountOt("Activa");

       $countOtPendientesRepuestos = ordenes_trabajos::getCountOtRepuestos();
       $countOtPendientesDePago = ordenes_trabajos::countOtPendientesDePago();

       $countOtDistinct = ordenes_trabajos::getCountOt("DISTINCT");
       /***********************************************************/
       // Obtener el primer día del mes actual
       $primerDiaDelMes = Carbon::now()->startOfMonth()->format('d-m-Y');

       // Obtener el último día del mes actual
       $ultimoDiaDelMes = Carbon::now()->endOfMonth()->format('d-m-Y');// Formato 'Y-m-d'

       $response = Http::get('http://nebiolo.cl:5905/estadosordenesot/'.base64_encode(1).'/'.base64_encode($primerDiaDelMes.' - '.$ultimoDiaDelMes));

       
    //    $dataOt = $response->json()['dataOt'];
    $dataOt = $response->json()['dataOt'] ?? null;

if ($dataOt !== null) {
    // Aquí puedes usar $dataOt de manera segura
} else {
    // Manejar el caso donde 'dataOt' no está presente en el array
}
       /***********************************************************/


       return view('home',compact("countOtPendientesDePago","countOtDistinct","countOtEnproceso",'countOtRecepcionada','countOtPendientes','countOtPendientesRepuestos','dataOt'));

    }

    public function gohomeinformes(request $req )
     
    { 
       return view('informes/homeinformes');

       
   }


   public function gohomeiframe($url)
     
   { 
$urlIframe ="";
$botonvolver ="si";
    $opcion  = base64_decode($url);

    if($opcion == "cajadiaria"){
        $fecha_actual = date('Y-m-d');

        $fxd = base64_encode($fecha_actual);
        $urlIframe =  "https://nebiolo.cl/informes/cajadiaria?fxr=".$fxd;

    }else if($opcion == "gastos"){
        $urlIframe =  "https://iretail.cl/gastos/informes/?cl=bmViaW8x&n=QWx2YXJv&a=TmViaW9sbw==";

    }
    else if($opcion == "dte"){
        $urlIframe =  "https://iretail.cl/emision_dte/facturacion/control_dte/pages/documentos/bboletas.php?c=cnBvc2NsX25lYmlvMQ==";

    }else if($opcion == "pagos"){
        $fecha_actual = date('Y-m-d');

        $fxd = base64_encode($fecha_actual);
        $urlIframe =  "https://nebiolo.cl/informes/informedepagos?fxr=".$fxd;
        // https://nebiolo.cl/informes/informedepagos/?fxr=MjAyNC0wNi0yNw==
       // https://sistema.nebiolo.cl/gohomeiframe/cGFnb3M=
    }else if($opcion == "agregargasto"){
        // return "aa";

        $botonvolver ="no";

        $getDataUser = User::datosdelusaurioSeparados();
        // echo $getDataUser[0]->nombre;
        $nombre =base64_encode($getDataUser[0]->nombre);
        $apellido = base64_encode($getDataUser[0]->apellido);
        $nebio1 = base64_encode("nebio1"); 
        $getSucursal =User::nameBranchId($getDataUser[0]->sucursales_id);
        $sucursal = base64_encode($getSucursal);

     
        $urlIframe =  "https://iretail.cl/gastos/?cl=".$nebio1."&n=".$nombre."&a=".$apellido."&s=".$sucursal;
        // https://nebiolo.cl/informes/informedepagos/?fxr=MjAyNC0wNi0yNw==
       // https://sistema.nebiolo.cl/gohomeiframe/cGFnb3M=
    }
      return view('informes/homeiframe', compact("urlIframe","botonvolver"));

      
  }
}
  