@extends('menu/menu')
<style>
	.mostrar {
		display: none;
	}

	@media (max-width: 768px) {
		.mostrar {
			display: block;
		}
	}

	.selectBox {
		position: relative;
	}

	.overSelect {
		position: absolute;
		left: 0;
		right: 0;
		top: 0;
		bottom: 0;
	}

	#checkboxes2 {
		display: none;
		border: 1px #dadada solid;
		background-color: white;
	}

	#checkboxes2 label {
		display: block;
	}

	#checkboxes2 label:hover {
		background-color: #1e90ff;
	}

	/* canvas {
		width: 250px;
		height: 250px;
		background-color: #fff;
	}

	@media screen and (max-width: 768px) {
		canvas {
			width: 250px;
			height: 250px;
			z-index: 99999;
			float: center;
			background-color: #fff;
		}
	} */
</style>

<script src="{{ asset('js/jquery-3.4.1.min.js')  ?? ''}}"></script>
{{-- <script src="https://html2canvas.hertzen.com/dist/html2canvas.js"></script> --}}
<script src="{{ asset('js/html2canvas.js')  ?? ''}}"></script>
@section('content')
@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif
@if ( session('mensaje_error') )
<div class="alert alert-danger">{{ session('mensaje_error') }}</div>
@endif

<!-- body code goes here -->
<div class="mostrar" style="text-align: right">
	<a href="javascript: history.go(-1)"><img src="img/volver.png"></a>
</div>

<!-- body code goes here -->
<div class="container mt-5">
	<div class="title-vista mt-4">Checklist Servicios</div>
</div>

<div class="container my-5">
	@if ( $asignacion_solicitudes[0]->estado_interno  !=  "INICIADO"  and $asignacion_solicitudes[0]->estado_interno  !=  "INICIADO"  and $asignacion_solicitudes[0]->estado_interno  !=  "RECHAZADO" )
		<a class="dropdown-item text-center" href="{{route('iniciando.checklist.servicios',Crypt::encryptString($asignacion_solicitudes[0]->idAsig)) ?? ''}}">
			<button class="btn btn-prim w-25">Iniciar Check</button>
		</a>
	@endif
	<form action="{{route('finalizar.checklist.servicios',Crypt::encryptString($asignacion_solicitudes[0]->idAsig)) }}" method="POST" class="needs-validation" novalidate>
					@csrf
					<!-- Fila 1 ------------------------------------------------------>
					<div class="seccion-filtro">Asignación</div> 
					<hr class="separador">
					<div class="row">
						<input type="hidden" value="{{$accion ?? ''}}" name="acc">
						<div class="col-sm-6 form-group ali">
						<label for="">Proyecto asociado</label>
						<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" placeholder="" value="{{$apiSolicitud[0]->nombre ?? ''}}">
					</div>
                    <div class="col-sm-3 form-group">
                        <label for="">SC</label>
                        <input type="text" required class="form-control mayuscula" id=""  style="pointer-events: none" readonly="readonly" placeholder="" name="numeroOT" value="{{$asignacion_solicitudes[0]->sSC ?? 'sin serie'}}" >

                    </div>
					</div>
					<!-- Fila 2 ------------------------------------------------------>
					<div class="seccion-filtro mt-2">Detalla del cliente</div> 
					<hr class="separador">
					<div class="row">
						<div class="col-sm-3 form-group">
							<label for="">Cliente</label>
							<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$apiSolicitud[0]->razon_social ?? ''}}">
						</div>
						<div class="col-sm-3 form-group">
							<label for="">Fecha</label>
							<input type="" class="form-control mayuscula" id="" placeholder="FECHA" name="" style="pointer-events: none" readonly="readonly" value="{{Carbon\Carbon::createFromDate($asignacion_solicitudes[0]->fecha ?? '')->format('d-m-Y') ?? ''}}" name="">
						</div>
						<div class="col-sm-3 form-group">
							<label for="">Dirección</label>
							<input type="" class="form-control mayuscula"  id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->sDireccion ?? ''}}" name="">
						</div>
						<div class="col-sm-3 form-group">
							<label for="">Comuna</label>
							<input type="" class="form-control mayuscula"  id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->sComuna ?? ''}}" name="">
						</div>
						<!-- Fila 3 ------------------------------------------------------>
						<div class="col-sm-6 form-group">
							<label for="">Contacto</label>
							<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->sContacto ?? ''}}" name="">
						</div>
						<div class="col-sm-3 form-group">
							<label for="">Telefono</label>
							<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->sTelefono ?? ''}}" name="">
						</div>
					
					</div>

					<!-- Fila 4 ------------------------------------------------------>
					<div class="seccion-filtro mt-2">Detalle de equipamiento</div> 
					<hr class="separador">
					<div class="row">
                        <div class="col-sm-3 form-group">
							<label for="">Modelo</label>
							<input type="" class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->sModelo ?? ''}}" name="">
						</div>
						<div class="col-sm-3 form-group">
							<label for="">Contadores B/N (*)</label>
							<input type="" required class="form-control mayuscula" id="" placeholder="" name="contadorBN" value="{{@old('contadorBN')}}">
						</div>
                        <div class="col-sm-3 form-group">
							<label for="">Contadores Color (*)</label>
							<input type="" required class="form-control mayuscula" id="" placeholder="" name="ContadorColor"  value="{{@old('ContadorColor')}}" name="">
						</div>
						<div class="col-sm-3 form-group">
							<label for="">Serie</label>
							<input type="" required  class="form-control mayuscula" id="" placeholder="" name="" style="pointer-events: none" readonly="readonly" value="{{$asignacion_solicitudes[0]->sSerie ?? ''}}" name="">
						</div>
						<div class="col-sm-3 form-group">
							<label for="">IP (*)</label>
							<input type="" required class="form-control mayuscula" id="" placeholder="" name="ip"  value="{{@old('ip')}}" name="">
						</div>
                        <div class="col-sm-3 form-group">
							<label for="">USB (*)</label>
							<!-- <input type="" required class="form-control mayuscula" id="" placeholder="usb" name="usb"  value="{{@old('usb')}}" name=""> -->
							<select name="usb"id="" class="form-control mayuscula">
								<option value="usb">USB</option>
								<option value="red">RED</option>
							</select>
						</div>
                        
						
						<!-- Fila 5 ------------------------------------------------------>
						
						<!-- Fila 6 ------------------------------------------------------>
					
						<!-- Fila 7 ------------------------------------------------------>
					
					</div>

					<!-- Fila 9 - Accesorios ----------------------------------------------------->
					<div class="row">
						<div class="col-sm-12">
							<div class="seccion-filtro mt-2">Reporte del Cliente</div> 
							<hr class="separador">
							<div class="row">
								<!-- FILA 9.1 -->
								<div class="col-md-12 form-group ">
									<div class="">
										<label class="" for="">Descripcion</label>	
                                        <textarea class="form-control mayuscula"  required name="descripcionApiServicios"  style="pointer-events: none" readonly="readonly" id="" cols="30" rows="10">{{$asignacion_solicitudes[0]->sDescripcion ?? 'No Informado'}}"</textarea>
									</div>
								</div>
							
								<!-- FILA 9.2 -->
							
							
								<!-- FILA 9.3 -->
						
							
								<!-- FILA 8.4 -->
							
							</div>
						</div>
						<div class="col-sm-6">
							{{-- para diferenciar si es manual  o no  --}}
							@if(!empty($manual))
							<input type="text" id="tipo_instalacion" name="tipo_instalacion" style="display:none" value="{{$manual  ?? '' ?? ''}}">
							@else
							<input type="text" id="tipo_instalacion" name="tipo_instalacion" style="display:none" value="no">
							@endif

						</div>
					</div>

					<div class="seccion-filtro mt-2">Solicitud de accesorios</div> 
					<hr class="separador">
					<!-- Fila 13 ------------------>
					<div class="row bg-destacar py-3">
						<div class="col-sm-12 form-group checkbox d-flex">
							<label class="mr-3" for="">Solicitar accesorios</label>
							<div class="custom-control custom-checkbox mr-3">
								<input type="checkbox" class="custom-control-input" id="accesorios_si" name="accesorios_si" onchange="javascript:showContent2(); javascript:changeCheckNo2()">
								<label class="custom-control-label" for="accesorios_si">Si</label>
							</div>
							<div class="custom-control custom-checkbox mr-3">
								<input type="checkbox" class="custom-control-input" checked id="accesorios_no" name="accesorios_no" onchange="javascript:showContent2(); javascript:changeCheckSi2()">
								<label class="custom-control-label" for="accesorios_no" >No</label>
							</div>
						</div>

						<!--MOTIVOS-->
						<div class="col-sm-12 form-group checkbox" id="motivos" style="display:none">
							<label for="" class="mr-3">Motivo</label>
							<div class=" d-flex flex-wrap">
								<div class="custom-control custom-checkbox mr-3">
									<input type="checkbox" class="custom-control-input" id="motivo_1" name="motivo_1" onchange="javascript:showContent3(); javascript:changeCheckMotivo1();">
									<label class="custom-control-label" for="motivo_1">Fin de vida util</label>
								</div>
								<div class="custom-control custom-checkbox mr-3">
									<input type="checkbox" class="custom-control-input" id="motivo_2" name="motivo_2" onchange="javascript:showContent4(); javascript:changeCheckMotivo2();">
									<label class="custom-control-label" for="motivo_2">Garantia</label>
								</div>
								
								<div class="custom-control custom-checkbox mr-3">
									<input type="checkbox" class="custom-control-input" id="motivo_3" name="motivo_3" onchange="javascript:showContent3(); javascript:changeCheckMotivo3();">
									<label class="custom-control-label" for="motivo_3">Daño de usuario</label>
								</div>
							</div>
						</div>

						<!--FOTOS-->
						<div class="container" id="fotos_accesorios" style="display:none">
							<button class="btn btn-ter w-25 asignarimagenes" type="button">Subir imagenes</button>
						</div>

						<!--ACCESORIOS DAÑADOS-->
						<div class="container" id="div_accesorios_danados" style="display:none">
							<div class="row">
								<div class="col-sm-12 seccion-filtro mt-2">Accesorios Dañados</div>
								<hr class="container mx-3 separador">

								<div class="col-sm-6 form-group">
									<label for="">Nombre de la pieza1</label>
									<input type="" class="form-control mayuscula" id="keywords2" placeholder="Nombre de la pieza" name="" value="" oninput="myFunction2()">
								</div>
								<!--<div class="col-sm-4 form-group">
									<label for="">ID</label>
									<input type="" class="form-control mayuscula" id="id_accesorio2" placeholder="ID" name="" value="" oninput="myFunction2()">
								</div>-->
								<div class="col-sm-6 form-group">
									<label for="">Número de la pieza</label>
									<input type="" class="form-control mayuscula" id="articulo2" placeholder="Número de la pieza" name="" value="" oninput="myFunction2()">
								</div>
								<div class="container mx-3 mb-2" id="" style="max-height: 300px; border: 1px solid #ddd; border-radius: 6px; background: #ffffff; overflow-y: scroll;">
									<table class="table table-hover">
										<tbody id="accesorios2"></tbody>
									</table>
								</div>
								<div class="col-sm-12">
									<table class="table table-hover">
										<thead class="bg-light">
											<th scope="col">Nombre de la pieza</th>
											<th scope="col">Numero de parte</th>
											<th scope="col">S/N parte</th>
											<th scope="col">Cantidad</th>
											<th scope="col">Acciones</th>
										</thead>
										<tbody id="agregar_accesorios2"></tbody>
									</table>
								</div>
							</div>
						</div>

						<!--ACCESORIOS A SOLICITAR-->
						<div class="container" id="div_accesorios_solicitados" style="display:none">
							<div class="row">
								<div class="col-sm-12 seccion-filtro mt-2">Seleccione Accesorios a solicitar</div>
								<hr class="container mx-3 separador">

								<div class="col-sm-6 form-group">
									<label for="">Nombre de la pieza</label>
									<input type="" class="form-control mayuscula" id="keywords" placeholder="Nombre de la pieza" name="" value="" oninput="myFunction()">
								</div>
								<!--<div class="col-sm-4 form-group">
									<label for="">ID</label>
									<input type="" class="form-control mayuscula" id="id_accesorio" placeholder="ID" name="" value="" oninput="myFunction()">
								</div>-->
								<div class="col-sm-6 form-group">
									<label for="">Número de la pieza</label>
									<input type="" class="form-control mayuscula" id="articulo" placeholder="Número de la pieza" name="" value="" oninput="myFunction()">
								</div>
								<div class="container mx-3 mb-2" id="" style="max-height: 300px; border: 1px solid #ddd; border-radius: 6px; background: #ffffff; overflow-y: scroll;">
									<table class="table table-hover">
										<tbody id="accesorios"></tbody>
									</table>
								</div>
								<div class="col-sm-12">
									<table class="table table-hover">
										<thead class="bg-light">
											<th scope="col">Nombre de la pieza</th>
											<th scope="col">Numero de parte</th>
											<th scope="col">S/N parte</th>
											<th scope="col">Cantidad</th>
											<th scope="col">Acciones</th>
										</thead>
										<tbody id="agregar_accesorios"></tbody>
									</table>
								</div>
							</div>
						</div>
					</div>

					<!-- Fila 10 - ----------------------------------------------------->
					<div class="seccion-filtro mt-2">Nº de serie, Componentes sustituidos</div> 
					<hr class="separador">

					<div class="row bg-destacar pt-3">
						<div class="col-sm-12 form-group checkbox d-flex">
							<label class="mr-3" for="">Tipo</label>
							<div class="custom-control custom-checkbox mr-3">
								<input type="checkbox" class="custom-control-input" id="maquina_b_n" name="maquina_b_n" checked onchange="javascript:showContent(); javascript:changeCheckNo()">
								<label class="custom-control-label" for="maquina_b_n">B/N</label>
							</div>
							<div class="custom-control custom-checkbox">
								<input  type="checkbox" class="custom-control-input" id="maquina_color" name="maquina_color" onchange="javascript:showContent(); javascript:changeCheckSi()">
								<label class="custom-control-label" for="maquina_color">Color</label>
							</div>
						</div>

						<div class="col-sm-12" id="equipo_de_remplazo" style="display:">
							<div class="container">
								<div class="row">
									<div class="col-sm-12 seccion-filtro mt-2">Detalle del equipamiento</div>
									<hr class="container mx-3 separador">

									<!-- Fila 11 ------>
								
									<div class="col-sm-2 form-group id_color"  style="display:none ;" >
										<label for="">LK</label>
										<input type="" oninput="buscarAcessorios(1)" id="buscaasesorio1" class="form-control mayuscula id_color "  placeholder="LK" name="lk"  value="{{@old('lk')}}">
										<table class="table table-hover">
                                            <tbody id="laccesorios1"></tbody>
                                        </table>
                                        <div class="invalid-feedback">Este campo es requerido!</div>
									</div>
                                    <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                        <label for="">Nombre de Pieza</label>
                                        <input type=""  class="form-control mayuscula id_color" id="desc1" placeholder="DESCRIPCION" name="desLK" value="{{@old('desLK')}}">
                                        <div class="invalid-feedback">Este campo es requerido!</div>
                                    </div>
                                    <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                        <label for="">Numero de Parte</label>
                                        <input type=""  class="form-control mayuscula id_color" id="part1"  placeholder="NUMERO DE PARTE" name="parteLK" value="{{@old('parteLK')}}">
                                        <div class="invalid-feedback">Este campo es requerido!</div>
                                    </div>
                                    <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                        <label for="">S/N parte</label>
                                        <input type=""  class="form-control mayuscula id_color" id="snp1"  placeholder="S/N parte" name="snparteLK" value="{{@old('snparteLK')}}">
                                        <div class="invalid-feedback">Este campo es requerido!</div>
                                    </div>
                                    <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                        <label for="">cantidad</label><br>
                                        <button class="btn btn-light" type="button" onclick="sumarCantidaes('idCantidadLk')">+</button> 
                                        <input type="hidden" name="cantidadLk" class="idCantidadLk" value="1"  >
                                        <span class="mx-2 id_idCantidadLk"  >1</span> 
                                        <button class="btn btn-light" type="button" onclick="restarCantidaes('idCantidadLk')">-</button> 
                                    </div>
                                  

                                    <!-- FK -->
                                    <div class="col-sm-2 form-group id_bn"  style="display: ;" >
										<label for="">FK</label>
										<input  type="" required class="form-control mayuscula id_bn" oninput="buscarAcessorios(2)" id="buscaasesorio2"  placeholder="FK" name="fk" value="{{@old('fk')}}">
                                        <table class="table table-hover">
                                            <tbody id="laccesorios2"></tbody>
                                        </table>
                                        <div class="invalid-feedback">Este campo es requerido!</div>
									</div>
                                    <div class="col-sm-3 form-group id_bn"  style="display: ;">
                                        <label for="">Nombre de Pieza</label>
                                        <input type="" required class="form-control mayuscula id_bn" id="desc2" placeholder="DESCRIPCION" name="desFK" value="{{@old('desFK')}}">
                                        <div class="invalid-feedback">Este campo es requerido!</div>
                                    </div>
                                    <div class="col-sm-3 form-group id_bn"  style="display: ;">
                                        <label for="">Numero de Parte</label>
                                        <input type=""  class="form-control mayuscula id_bn" id="part2" placeholder="NUMERO DE PARTE" name="parteFK" value="{{@old('parteFK')}}">
                                        <div class="invalid-feedback">Este campo es requerido!</div>
                                    </div>
                                    <div class="col-sm-2 form-group id_bn"  style="display: ;">
                                        <label for="">S/N parte</label>
                                        <input type=""  class="form-control mayuscula id_bn" id="snp2"  placeholder="S/N parte" name="snparteFK" value="{{@old('snparteFK')}}">
                                        <div class="invalid-feedback">Este campo es requerido!</div>
                                    </div>
                                    <div class="col-sm-2 form-group id_bn"  style="display: ;">
                                        <label for="">cantidad</label><br>
                                        <button class="btn btn-light" type="button" onclick="sumarCantidaes('idCantidadFk')">+</button> 
                                        <input type="hidden" name="CantidadFk" class="idCantidadFk" value="1"  >
                                        <span class="mx-2 id_idCantidadFk"  >1</span> 
                                        <button class="btn btn-light" type="button" onclick="restarCantidaes('idCantidadFk')">-</button> 
                                    </div>

                               
									

                                    <div class="col-sm-12 form-group">
                                        
                                           <div class="row">
                                            <div class="col-sm-12 seccion-filtro mt-2">DV - UN Revelado(s)</div>
                                            <hr class="container mx-3 separador">
                                                <div class="col-sm-2 form-group id_bn"  style="display: ;">
                                                    <label for="">K</label>
                                                    <input type="" required class="form-control mayuscula id_bn" oninput="buscarAcessorios(3)" id="buscaasesorio3" id="" placeholder="K" name="K" value="{{@old('K')}}">
                                                    <table class="table table-hover">
                                                        <tbody id="laccesorios3"></tbody>
                                                    </table>
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-3 form-group id_bn"  style="display: ;">
                                                    <label for="">Nombre de Pieza</label>
                                                    <input type="" required class="form-control mayuscula id_bn"  id="desc3" placeholder="DESCRIPCION" name="desK" value="{{@old('desK')}}">
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-3 form-group id_bn"  style="display: ;">
                                                    <label for="">Numero de Parte</label>
                                                    <input type=""  class="form-control mayuscula id_bn" id="part3" placeholder="NUMERO DE PARTE" name="parteK" value="{{@old('parteK')}}">
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-2 form-group id_bn"  style="display: ;">
                                                    <label for="">S/N parte</label>
                                                    <input type=""  class="form-control mayuscula id_bn" id="snp3"  placeholder="S/N parte" name="snparteK" value="{{@old('snparteK')}}">
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-2 form-group id_bn"  style="display: ;">
                                                    <label for="">cantidad</label><br>
                                                    <button class="btn btn-light" type="button" onclick="sumarCantidaes('idCantidadK')">+</button> 
                                                    <input type="hidden" name="CantidadK" class="idCantidadK" value="1"  >
                                                    <span class="mx-2 id_idCantidadK"  >1</span> 
                                                    <button class="btn btn-light" type="button" onclick="restarCantidaes('idCantidadK')">-</button> 
                                                </div>

                                                <!-- B -->
                                                <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                    <label for="">C</label>
                                                    <input type=""  class="form-control mayuscula id_color" oninput="buscarAcessorios(4)" id="buscaasesorio4" placeholder="C" name="c" value="{{@old('c')}}">
                                                    <table class="table table-hover">
                                                        <tbody id="laccesorios4"></tbody>
                                                    </table>
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                                    <label for="">Nombre de Pieza</label>
                                                    <input type=""  class="form-control mayuscula id_color" id="desc4" placeholder="DESCRIPCION" name="desC" value="{{@old('desC')}}">
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                                    <label for="">Numero de Parte</label>
                                                    <input type=""  class="form-control mayuscula id_color" id="part4" placeholder="NUMERO DE PARTE" name="parteC" value="{{@old('parteC')}}">
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                    <label for="">S/N parte</label>
                                                    <input type=""  class="form-control mayuscula id_color" id="snp4"  placeholder="S/N parte" name="snparteC" value="{{@old('snparteC')}}">
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                    <label for="">cantidad</label><br>
                                                    <button class="btn btn-light" type="button" onclick="sumarCantidaes('idCantidadC')">+</button> 
                                                    <input type="hidden" name="CantidadC" class="idCantidadC" value="1"  >
                                                    <span class="mx-2 id_idCantidadC"  >1</span> 
                                                    <button class="btn btn-light" type="button" onclick="restarCantidaes('idCantidadC')">-</button> 
                                                </div>
 
                                                <!-- C -->
                                                <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                    <label for="">M</label>
                                                    <input type=""  class="form-control mayuscula id_color" oninput="buscarAcessorios(5)" id="buscaasesorio5" placeholder="M" name="m" value="{{@old('m')}}">
                                                    <table class="table table-hover">
                                                        <tbody id="laccesorios5"></tbody>
                                                    </table>
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                                    <label for="">Nombre de Pieza</label>
                                                    <input type=""  class="form-control mayuscula id_color" id="desc5" placeholder="DESCRIPCION" name="desM" value="{{@old('desM')}}">
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                                    <label for="">Numero de Parte</label>
                                                    <input type=""  class="form-control mayuscula id_color" id="part5" placeholder="NUMERO DE PARTE" name="parteM" value="{{@old('parteM')}}">
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                    <label for="">S/N parte</label>
                                                    <input type=""  class="form-control mayuscula id_color" id="snp5"  placeholder="S/N parte" name="snparteM" value="{{@old('snparteM')}}">
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                    <label for="">cantidad</label><br>
                                                    <button class="btn btn-light" type="button" onclick="sumarCantidaes('idCantidadM')">+</button> 
                                                    <input type="hidden" name="CantidadM" class="idCantidadM" value="1"  >
                                                    <span class="mx-2 id_idCantidadM"  >1</span> 
                                                    <button class="btn btn-light" type="button" onclick="restarCantidaes('idCantidadM')">-</button> 
                                                </div>  
                                                 <!-- D -->
                                                 <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                    <label for="">Y</label>
                                                    <input type=""  class="form-control mayuscula id_color" oninput="buscarAcessorios(6)" id="buscaasesorio6" placeholder="Y" name="y" value="{{@old('y')}}">
                                                    <table class="table table-hover">
                                                        <tbody id="laccesorios6"></tbody>
                                                    </table>
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                                    <label for="">Nombre de Pieza</label>
                                                    <input type=""  class="form-control mayuscula id_color" id="desc6" placeholder="DESCRIPCION" name="desY" value="{{@old('desY')}}">
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                                    <label for="">Numero de Parte</label>
                                                    <input type=""  class="form-control mayuscula id_color" id="part6" placeholder="NUMERO DE PARTE" name="parteY" value="{{@old('parteY')}}">
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                    <label for="">S/N parte</label>
                                                    <input type=""  class="form-control mayuscula id_color" id="snp6"  placeholder="S/N parte" name="snparteY" value="{{@old('snparteY')}}">
                                                    <div class="invalid-feedback">Este campo es requerido!</div>
                                                </div>
                                                <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                    <label for="">cantidad</label><br>
                                                    <button class="btn btn-light" type="button" onclick="sumarCantidaes('idCantidadY')">+</button> 
                                                    <input type="hidden" name="CantidadY" class="idCantidadY" value="1"  >
                                                    <span class="mx-2 id_idCantidadY"  >1</span> 
                                                    <button class="btn btn-light" type="button" onclick="restarCantidaes('idCantidadY')">-</button> 
                                                </div>                                                                                        
                                           </div>

                                           <!-- CILINDRO -->
                                          

                                           <div class="row">
                                            <div class="col-sm-12 seccion-filtro mt-2">DK - UN Cilindro(s)</div>
                                            <hr class="container mx-3 separador">
                                            <div class="col-sm-2 form-group id_bn"  style="display: ;">
                                                <label for="">K</label>
                                                <input type="" required class="form-control mayuscula id_bn" oninput="buscarAcessorios(7)" id="buscaasesorio7" placeholder="K" name="k2" value="{{@old('k2')}}">
                                                <table class="table table-hover">
                                                    <tbody id="laccesorios7"></tbody>
                                                </table>
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-3 form-group id_bn"  style="display: ;">
                                                <label for="">Nombre de Pieza</label>
                                                <input type="" required class="form-control mayuscula id_bn" id="desc7" placeholder="DESCRIPCION" name="desK2" value="{{@old('desK2')}}">
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-3 form-group id_bn"  style="display: ;">
                                                <label for="">Numero de Parte</label>
                                                <input type=""  class="form-control mayuscula id_bn" id="part7" placeholder="NUMERO DE PARTE" name="parteK2" value="{{@old('parteK2')}}">
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-2 form-group id_bn"  style="display: ;">
                                                <label for="">S/N parte</label>
                                                <input type=""  class="form-control mayuscula id_bn" id="snp7"  placeholder="S/N parte" name="snparteK2" value="{{@old('snparteK2')}}">
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-2 form-group id_bn"  style="display: ;">
                                                <label for="">cantidad</label><br>
                                                <button class="btn btn-light" type="button" onclick="sumarCantidaes('idCantidadK_2')">+</button> 
                                                <input type="hidden" name="CantidadK_2" class="idCantidadK_2" value="1"  >
                                                <span class="mx-2 id_idCantidadK_2"  >1</span> 
                                                <button class="btn btn-light" type="button" onclick="restarCantidaes('idCantidadK_2')">-</button> 
                                            </div>

                                            <!-- B -->
                                            <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                <label for="">C</label>
                                                <input type=""  class="form-control mayuscula id_color" oninput="buscarAcessorios(8)" id="buscaasesorio8" placeholder="C" name="c2" value="{{@old('c2')}}">
                                                <table class="table table-hover">
                                                    <tbody id="laccesorios8"></tbody>
                                                </table>
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                                <label for="">Nombre de Pieza</label>
                                                <input type=""  class="form-control mayuscula id_color" id="desc8" placeholder="DESCRIPCION" name="desC2" value="{{@old('desC2')}}">
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                                <label for="">Numero de Parte</label>
                                                <input type=""  class="form-control mayuscula id_color" id="part8" placeholder="NUMERO DE PARTE" name="parteC2" value="{{@old('parteC2')}}">
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                <label for="">S/N parte</label>
                                                <input type=""  class="form-control mayuscula id_color" id="snp8"  placeholder="S/N parte" name="snparteC2" value="{{@old('snparteC2')}}">
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                <label for="">cantidad</label><br>
                                                <button class="btn btn-light" type="button" onclick="sumarCantidaes('idCantidadC_2')">+</button> 
                                                <input type="hidden" name="CantidadC_2" class="idCantidadC_2" value="1"  >
                                                <span class="mx-2 id_idCantidadC_2"  >1</span> 
                                                <button class="btn btn-light" type="button" onclick="restarCantidaes('idCantidadC_2')">-</button> 
                                            </div>

                                            <!-- C -->
                                            <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                <label for="">M</label>
                                                <input type=""  class="form-control mayuscula id_color" oninput="buscarAcessorios(9)" id="buscaasesorio9" placeholder="M" name="m2" value="{{@old('m2')}}">
                                                <table class="table table-hover">
                                                    <tbody id="laccesorios9"></tbody>
                                                </table>
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                                <label for="">Nombre de Pieza</label>
                                                <input type=""  class="form-control mayuscula id_color" id="desc9" placeholder="DESCRIPCION" name="desM2" value="{{@old('desM2')}}">
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                                <label for="">Numero de Parte</label>
                                                <input type=""  class="form-control mayuscula id_color" id="part9" placeholder="NUMERO DE PARTE" name="parteM2" value="{{@old('parteM2')}}">
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                <label for="">S/N parte</label>
                                                <input type=""  class="form-control mayuscula id_color" id="snp9"  placeholder="S/N parte" name="snparteM2" value="{{@old('snparteM2')}}">
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                <label for="">cantidad</label><br>
                                                <button class="btn btn-light" type="button" onclick="sumarCantidaes('idCantidadM_2')">+</button> 
                                                <input type="hidden" name="CantidadM_2" class="idCantidadM_2" value="1"  >
                                                <span class="mx-2 id_idCantidadM_2"  >1</span> 
                                                <button class="btn btn-light" type="button" onclick="restarCantidaes('idCantidadM_2')">-</button> 
                                            </div>  

                                             <!-- D -->
                                             <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                <label for="">Y</label>
                                                <input type=""  class="form-control mayuscula id_color" oninput="buscarAcessorios(10)" id="buscaasesorio10" placeholder="Y" name="y2" value="{{@old('y2')}}">
                                                <table class="table table-hover">
                                                    <tbody id="laccesorios10"></tbody>
                                                </table>
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                                <label for="">Nombre de Pieza</label>
                                                <input type=""  class="form-control mayuscula id_color" id="desc10" placeholder="DESCRIPCION" name="desY2" value="{{@old('desY2')}}">
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-3 form-group id_color"  style="display:none ;">
                                                <label for="">Numero de Parte</label>
                                                <input type=""  class="form-control mayuscula id_color" id="part10" placeholder="NUMERO DE PARTE" name="parteY2" value="{{@old('parteY2')}}">
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                <label for="">S/N parte</label>
                                                <input type=""  class="form-control mayuscula id_color" id="snp10"  placeholder="S/N parte" name="snparteY2" value="{{@old('snparteY2')}}">
                                                <div class="invalid-feedback">Este campo es requerido!</div>
                                            </div>
                                            <div class="col-sm-2 form-group id_color"  style="display:none ;">
                                                <label for="">cantidad</label><br>
                                                <button class="btn btn-light" type="button" onclick="sumarCantidaes('idCantidadY_2')">+</button> 
                                                <input type="hidden" name="CantidadY_2" class="idCantidadY_2" value="1"  >
                                                <span class="mx-2 id_idCantidadY_2"  >1</span> 
                                                <button class="btn btn-light" type="button" onclick="restarCantidaes('idCantidadY_2')">-</button> 
                                            </div>                                                                                          
                                       </div>

                                           


                                          
									</div>


                                    

								</div>
							</div>
						</div>
					</div>

				

					<div class="seccion-filtro mt-2">Equipo operativo</div> 
					<hr class="separador">

					<div class="row">
				
						<div class="col-sm-12 form-group checkbox">
							<label for="cambio">Observaciones</label>
							<textarea required class="form-control mayuscula" id="cambio" name="obsercaviones" rows="4" name="observaciones">{{@old('obsercaviones')}}</textarea>
							<div class="invalid-feedback">Este campo es requerido!</div>
						</div>
					</div>

					<div class="seccion-filtro mt-2">Datos</div> 
					<hr class="separador">

					<div class="row">
						<div class="col-md-6">
							<div class="row">
								<div class="col-sm-12 form-group">
									<label for="">Datos del Técnico</label>
								</div>
							</div>
						</div>
						<div class="col-md-6">
							<div class="row">
								<div class="col-sm-12 form-group">
									<label for="">Datos del Contacto</label>
									<input  required type="text" class="form-control mayuscula" placeholder="DATOS DEL CONTACTO" name="contacto_firma" value="{{ $asignacion_solicitudes[0]->Cscontacto  ?? ''}}">
								</div>

								<div class="col-sm-12 form-group">
									<label for="">Firma Contacto</h2>
								</div>
								
								@php
								$hora_actual = Carbon\Carbon::now();
								$date = $hora_actual->toTimeString();
								$hora_salida = "20:00:00";
								$hora_entrada = "08:00:00";
								@endphp
								@if ( $asignacion_solicitudes[0]->estado_interno == "INICIADO" ||  $asignacion_solicitudes[0]->estado_interno == "INICIADO"  || $asignacion_solicitudes[0]->estado_interno == "RECHAZADO"  )
									<div class="col-sm-12 form-group checkbox check-space">
										<div class="custom-control custom-checkbox">
											<input type="checkbox" class="custom-control-input" id="no_firma_cliente" name="no_firma_cliente" value="si">
											<label class="custom-control-label" for="no_firma_cliente">Cliente se niega a firmar</label>
										</div>
									</div>

									
									<div class="col-sm-12 form-group">
										<div id="contenido" class="container text-center bg-destacar mb-3" id='formCanvas'>
											 <!-- <form id='formCanvas' method='post' action="{{route('guardandofotosprueba')}} " enctype='multipart/form-data'> -->
												<!-- @csrf -->
												<div class="container py-3 d-flex flex-wrap">
													<div class="mx-auto mb-3">
														{{-- Pizarra --}}
														<canvas class="rounded-lg" id="pizarra" name="img_firma" width="250" height="250"></canvas>
													</div>
													<div class="col-md">
														<input type="text" style="display: none" id="imagen_firma" value="" name="imagen_firma">
														<input type="text" style="display:none" id="check" value="{{Crypt::encryptString($asignacion_solicitudes[0]->idAsig ?? '') }}" name="check">											
														<button class="btn btn-prim btn-block" type='button' onclick="firmar()" id="enviar_firma">Guardar</button>
														<button class="btn btn-secundario btn-block" type='button' id="borrars" onclick="borrar()">Borrar</button>
														<button class="btn btn-secundario btn-block" type="button">Firma masiva</button>										
													</div>
												</div>
												@if($asignacion_solicitudes[0]->url_firma != "")
												<label for="">( Firma ya Registrada) </label>
												@endif
												<input type='hidden' name='imagen' id='imagen' />
											<!-- </form> -->
										</div>
										{{-- <div class="form-group">
											<div class="multiselect">
												<div class="selectBox" onclick="showCheckBoxes2()">
													<select class="form-control">
														<option>Seleccionar checks</option>
													</select>
													<div class="overSelect"></div>
												</div>
												<div id="checkboxes2">
													<label for="one">
														@if(!empty($datos_instalacion))
														@foreach ($datos_instalacion as $checks)
														<div><input type="checkbox" id="jerarquia" name="jerarquia[]" value="{{$checks->idcheck ?? ''}}">{{strtoupper($checks->Csdireccion)}} - {{strtoupper($checks->Cscliente)}} - {{$checks->CsSerie ?? 'Sin serie'}}</div>
														@endforeach
														@endif
													</label>
												</div>
											</div>
										</div> --}}
									</div>
								@endif
							</div>
						</div>
					</div>
						
					<div class="seccion-filtro mt-2">Imágenes</div> 
					<hr class="separador">
					<div class="row">
						<div class="col-sm-12 form-group">
							<label class="d-block" for="">Subir imágenes</label>
							@if("cantidad_fotos" != 0)
								(El siguiente Check, ya tiene imagenes asociadas)<br>
							@endif
							<div class="text-center modo-escritorio">
								<button class="btn btn-secundario asignarimagen col-sm-3" type="button">IMAGENES</button>
								<!-- <button type="button" class="btn btn-secundario col-sm-3" data-toggle="modal" data-target="#modal_fotos_android">Android</button>
								<button type="button" class="btn btn-secundario col-sm-3" data-toggle="modal" data-target="#modal_fotos_email">Email</button> -->
							</div>
							<div class="text-center modo-mobil">
								<button class="btn btn-secundario asignarimagen btn-block" type="button">IMAGENES</button>
								<!-- <button type="button" class="btn btn-secundario btn-block" data-toggle="modal" data-target="#modal_fotos_android">Android</button>
								<button type="button" class="btn btn-secundario btn-block" data-toggle="modal" data-target="#modal_fotos_email">Email</button> -->
							</div>
						</div>
					</div>
					<hr class="separador">

					<div class="row">
						<div class="col-sm-4 form-group ">
							<label for="">Estado</label>
							<select name="estado_finalizado" required__* class="custom-select mayuscula col-mb-3" id="estado">
							<option value="terminado">TERMINADO</option>
							<option value="esp.repuesto">ESP. REPUESTO</option>
							<option value="con.por.horario">CONT. POR HORARIO</option>
							<option value="requieres.sup">REQUIERE SUP</option>
							<option value="visita.cortesia">VISITA CORTESIA</option>
							<option value="supervision">SUPERVISIÓN</option>
							</select>
							@error('estado')
							<div class="alert alert-danger">{{ $message }}</div>
							@enderror
						</div>
						<div class="col-sm-4 form-group ">
							
						</div>
							@if ( $asignacion_solicitudes[0]->estado_interno  ==  "INICIADO"  || $asignacion_solicitudes[0]->estado_interno  ==  "INICIADO" || $asignacion_solicitudes[0]->estado_interno  ==  "RECHAZADO" )

								<div class="col-sm-4 form-group d-flex">
									<button class="btn btn-prim btn-block align-self-end" type="submit">GUARDAR</button>
								</div>
							@endif
					</div>
			</div>
	</form>
</div>
<!-- FIN BARRA DE BUSQUEDA -->


<!--MODAL CARGA DE IMÁGENES DE ACCESORIOS-->
<div class="modal fade" id="modal_fotos_accesorios" role="dialog">
	<div class="modal-dialog modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<h4>Ingrese las fotos de accesorios</h4>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">
			<div class="modal-body">
				<div class="container">
					<!-- CARGA DE IMÁGENES DE ACCESORIOS -->
					<div class="seccion-filtro mt-2">Adjunte las imágenes que se solicita a continuación</div>
					<div class="row">
						<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
						<div class="col-12">
							<label style="color:red" ; id="mensaje-text" for=""></label>
						</div>
						<div id="carouselExampleControls" class="carousel slide" data-interval="false">
							<div class="carousel-inner">
								<!-- 1 -->
								<div class="carousel-item active">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<label for="cargafotoa1" class="espacio_carga_img">Fotografía 1</label>
											<input type="file" required id="cargafotoa1" name="cargafotoa1" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 2 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
										<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<label for="cargafotoa2" class="espacio_carga_img">Fotografía 2</label>
											<input type="file" id="cargafotoa2" name="cargafotoa2">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 3 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
										<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<label for="cargafotoa3" class="espacio_carga_img">Fotografía 3</label>
											<input type="file" id="cargafotoa3" name="cargafotoa3">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 4 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
										<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 4</label>
											<input type="file" id="cargafotoa4" name="cargafotoa4">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 5 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
										<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 5</label>
											<input type="file" id="cargafotoa5" name="cargafotoa5">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 6 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
										<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 6</label>
											<input type="file" id="cargafotoa6" name="cargafotoa6">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 7 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
										<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 7</label>
											<input type="file" id="cargafotoa7" name="cargafotoa7">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 8 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
										<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 8</label>
											<input type="file" id="cargafotoa8" name="cargafotoa8">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 9 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
										<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 9</label>
											<input type="file" id="cargafotoa9" name="cargafotoa9">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<!-- 10 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
										<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 10</label>
											<input type="file" id="cargafotoa10" name="cargafotoa10">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
                 
                                <!-- 11 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
										<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 11</label>
											<input type="file" id="cargafotoa11" name="cargafotoa11">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
                                <!-- 12 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
										<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 12</label>
											<input type="file" id="cargafotoa12" name="cargafotoa12">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
                                 <!-- 13 -->
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadaccesorios" method="post">
										@csrf
										<div class="col-sm-12 form-group">
										<input type="text" style="display:none" name="idAsig" id="idchecklist" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">

											<label for="cargafoto3" class="espacio_carga_img">Fotografía 13</label>
											<input type="file" id="cargafotoa13" name="cargafotoa13">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
							</div>
						</div>
						<div class="text-center mb-2">
							<a class="carousel-control-prev previus_carrusel" style="display:none" href="#carouselExampleControls" role="button" data-slide="prev">
								<span class="material-icons" style="color:black">
									arrow_back_ios
								</span>
							</a>
						</div>
						<div class="container wrapper2 wrap2 mt-2 w-75" style="display: none">
							<div class="progress progress_wrapper">
								<div class="progress-bar progbar2 progress-bar-striped bg-info progress-bar-animated progress_bar" role="progressbar" style="width: 0%">
									0%
								</div>
							</div>
						</div>
					</div>
					<!-- FIN CARGA DE IMÁGENES DE INSTALACIÓN -->
					<div class="modal-footer d-flex justify-content-center">
						<button class="btn btn-prim" type="button" data-dismiss="modal">Guardar</button>
						<button class="btn btn-secundario" type="button" data-dismiss="modal">Cancelar</button>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>




<!--MODAL CARGA DE IMÁGENES DE ACCESORIOS-->
{{-- <div class="modal fade" id="modal_fotos_accesorios" role="dialog">
	<div class="modal-dialog">
		<div class="modal-content">

			<div class="modal-header">
				<h4>Ingrese las fotos de accesorios</h4>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4"> 

			<div class="modal-body">
				<div class="container">
					<form enctype="multipart/form-data" id="formuploadservicios" method="post">
						@csrf
						
							<!-- CARGA DE IMÁGENES DE ACCESORIOS -->
							<div class="seccion-filtro mt-2" id="title_123" style="display:">Adjunte las imágenes de la Maquina</div> 
							<div class="row">
								<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
								<div class="col-12">
									<label style="color:red" ; id="mensaje-text" for=""></label>
								</div>
                                
                                <!-- 1.1 -->
								<div class="col-sm-12 form-group" id="cargafotoa1_1">
									<label  style="color:red" for="cargafotoa1" class="espacio_carga_img">Fotografía 1.1</label>
									<input class="float-right" type="file"   style="display: ;" name="cargafotoa1">
								</div>
                                <!-- 1.2 -->
								<div class="col-sm-12 form-group" id="cargafotoa1_2">
									<label  style="color:red" for="cargafotoa1" class="espacio_carga_img">Fotografía 1.2</label>
									<input class="float-right" type="file"  style="display: ;" name="cargafotoa1">
								</div>
                                <!-- 1.3 -->
								<div class="col-sm-12 form-group" id="cargafotoa1_3">
									<label style="color:red"  for="cargafotoa1" class="espacio_carga_img">Fotografía 1.3</label>
									<input class="float-right" type="file"  style="display: ;" name="cargafotoa1">
								</div>
                                <div style="margin-left: 3px;" class="seccion-filtro mt-2">Adjunte las imágenes que se solicita a continuación</div> 
                                <br><br>
								<!-- 1 -->
								<div class="col-sm-12 form-group">
									<label for="cargafotoa1" class="espacio_carga_img">Fotografía 1</label>
									<input class="float-right" type="file" id="cargafotoa1" name="cargafotoa1">
								</div>
								<!-- 2 -->
								<div class="col-sm-12 form-group">
									<label for="cargafotoa2" class="espacio_carga_img">Fotografía 2</label>
									<input class="float-right" type="file"  id="cargafotoa2" name="cargafotoa2">
								</div>
								<!-- 3 -->
								<div class="col-sm-12 form-group">
									<label for="cargafotoa3" class="espacio_carga_img">Fotografía 3</label>
									<input class="float-right" type="file"  id="cargafotoa3" name="cargafotoa3">
								</div>
								<!-- 4 -->
								<div class="col-sm-12 form-group">
									<label for="cargafoto3" class="espacio_carga_img">Fotografía 4</label>
									<input class="float-right" type="file"  id="cargafotoa4" name="cargafotoa4">
								</div>
								<!-- 5 -->
								<div class="col-sm-12 form-group">
									<label for="cargafoto3" class="espacio_carga_img">Fotografía 5</label>
									<input class="float-right" type="file"  id="cargafotoa5" name="cargafotoa5">
								</div>
								<!-- 6 -->
								<div class="col-sm-12 form-group">
									<label for="cargafoto3" class="espacio_carga_img">Fotografía 6</label>
									<input class="float-right" type="file"  id="cargafotoa6" name="cargafotoa6">
								</div>
								<!-- 7 -->
								<div class="col-sm-12 form-group">
									<label for="cargafoto3" class="espacio_carga_img">Fotografía 7</label>
									<input class="float-right" type="file"  id="cargafotoa7" name="cargafotoa7">
								</div>
								<!-- 8 -->
								<div class="col-sm-12 form-group">
									<label for="cargafoto3" class="espacio_carga_img">Fotografía 8</label>
									<input class="float-right" type="file"  id="cargafotoa8" name="cargafotoa8">
								</div>
								<!-- 9 -->
								<div class="col-sm-12 form-group">
									<label for="cargafoto3" class="espacio_carga_img">Fotografía 9</label>
									<input class="float-right" type="file"  id="cargafotoa9" name="cargafotoa9">
								</div>
								<!-- 10 -->
								<div class="col-sm-12 form-group">
									<label for="cargafoto3" class="espacio_carga_img">Fotografía 10</label>
									<input class="float-right" type="file"  id="cargafotoa10" name="cargafotoa10">
								</div>
							</div>
							<!-- FIN CARGA DE IMÁGENES DE INSTALACIÓN -->
						
						<div class="modal-footer d-flex justify-content-center">
							<button class="btn btn-prim" type="submit">Subir imágenes</button>
							<button class="btn btn-secundario" type="button" data-dismiss="modal">Cancelar</button>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div> --}}
<!--FIN MODAL FOTOS ACCESORIOS-->



<!-- MODAL IMAGENES -->
<div class="modal fade" id="modal_historial_retiros" role="dialog">
	<div class="modal-dialog  modal-lg">
		<div class="modal-content">
			<div class="modal-header">
				<div class="seccion-modal">Ingresar el siguiente ID en la Aplicacción</div>
				<button type="button" class="cancel_image close">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<div class="modal-body">
				<div class="container">
					<!-- CARGA DE IMÁGENES DE INSTALACIÓN -->
					<div class="seccion-filtro mt-2">Adjunte las imágenes que se solicita a continuación</div>
					<div class="row">
						<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
						<div class="col-sm-12">
							<label style="color:red" id="mensaje-text" for="" class="mensaje_validacion"></label>
						</div>
						<!-- 1 -->
						<div id="carouselExampleControls2" class="carousel slide" data-interval="false">
							<div class="carousel-inner">
								<div class="carousel-item active">
									<form enctype="multipart/form-data" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<img src="{{ asset('img/p1.png') }}" width="30" height="30" class="espacio_carga_img" alt="" />
											<label for="cargafoto1" class="espacio_carga_img">Fotografía de la página de estado</label>
											<input type="file" required id="cargafoto1" name="cargafoto1" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<img src="{{ asset('img/p2.png') }}" width="30" height="30" class="espacio_carga_img" alt="" />
											<label for="cargafoto2" class="espacio_carga_img">Fotografía del panel de la máquina</label>
											<input type="file" required id="cargafoto2" name="cargafoto2" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax3" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<img src="{{ asset('img/p3.png') }}" width="30" height="30" class="espacio_carga_img" alt="" />
											<label for="cargafoto3" class="espacio_carga_img">Fotografía a 2 metros del equipo</label>
											<input type="file" required id="cargafoto3" name="cargafoto3" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax4" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<label for="cargafoto4" class="espacio_carga_img">Fotografía 4 </label>
											<input type="file" required id="cargafoto4" name="cargafoto4" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax5" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<label for="cargafoto5" class="espacio_carga_img">Fotografía 5 </label>
											<input type="file" required id="cargafoto5" name="cargafoto5" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax6" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<label for="cargafoto6" class="espacio_carga_img">Fotografía 6 </label>
											<input type="file" required id="cargafoto6" name="cargafoto6" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax7" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<label for="cargafoto7" class="espacio_carga_img">Fotografía 7 </label>
											<input type="file" required id="cargafoto7" name="cargafoto7" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax8" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<label for="cargafoto8" class="espacio_carga_img">Fotografía 8 </label>
											<input type="file" required id="cargafoto8" name="cargafoto8" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax9" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<label for="cargafoto9" class="espacio_carga_img">Fotografía 9 </label>
											<input type="file" required id="cargafoto9" name="cargafoto9" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax10" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<label for="cargafoto10" class="espacio_carga_img">Fotografía 10 </label>
											<input type="file" required id="cargafoto10" name="cargafoto10" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax11" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<label for="cargafoto11" class="espacio_carga_img">Fotografía 11 </label>
											<input type="file" required id="cargafoto11" name="cargafoto11" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax12" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<label for="cargafoto12" class="espacio_carga_img">Fotografía 12 </label>
											<input type="file" required id="cargafoto12" name="cargafoto12" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
								<div class="carousel-item">
									<form enctype="multipart/form-data" id="formuploadajax13" class="formuploadajax" method="post">
										@csrf
										<div class="col-sm-12 form-group">
											<input type="text" style="display:none" name="idAsig" id="" value="{{$asignacion_solicitudes[0]->idAsig ?? ''}}">
											<label for="cargafoto4" class="espacio_carga_img">Fotografía 13</label>
											<input type="file" required id="cargafoto13" name="cargafoto13" accept="image/*">
											<button class="btn btn-prim" type="submit">Subir imágen</button>
										</div>
									</form>
								</div>
							</div>
						</div>
						<div class="container text-center mb-2">
							<a class="carousel-control-prev previus_carrusel2" style="display:none" href="#carouselExampleControls2" role="button" data-slide="prev">
								<span class="material-icons" style="color:black">
									arrow_back_ios
								</span>
							</a>
							<!--<a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
								<span class="carousel-control-next-icon" aria-hidden="true"></span>
								<span class="material-icons" style="color:black">
									arrow_forward_ios
								</span>
							</a>-->
						</div>
						<div class="container wrapper mt-5" style="display: none">
							<div class="progress progress_wrapper">
								<div class="progress-bar progress-bar-striped bg-info progress-bar-animated progress_bar" role="progressbar" style="width: 0%">
									0%
								</div>
							</div>
						</div>
						<div class="container form-group text-center my-4">
							<button class="btn btn-secundario cancel_image" type="button">Cancelar</button>
							<button class="btn btn-prim save_image  "data-dismiss="modal" type="button">Guardar</button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

<!-- MODAL IMAGENES -->
<div class="modal fade" id="modal_fotos_email" role="dialog">
	<div class="modal-dialog  modal-lg">
		<div class="modal-content">
			
			<div class="modal-header">
				<div class="seccion-modal">Ingresar 3 Fotos</div>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<div class="modal-body">
				<div class="container text-center">
					<!-- CARGA DE IMÁGENES DE INSTALACIÓN -->
					<a class="btn btn-ter w-25 border rounded-lg py-2" href="mailto:ayaing@retailmax.cl?subject=<?php echo $asignacion_solicitudes[0]->idAsig; ?>">Subir Fotos</a>
				</div>

				<!-- FIN CARGA DE IMÁGENES DE INSTALACIÓN -->	
				<div class="container form-group text-center my-4">
					<a class="btn btn-prim w-25" href="http://globati.com/ayaingenieria/index.php?id=<?php echo $asignacion_solicitudes[0]->idAsig; ?>" target="_blank">Confirmar</a>
					<button class="btn btn-secundario w-25 " type="button" data-dismiss="modal">Cancelar</button>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- MODAL IMAGENES -->
<div class="modal fade" id="modal_fotos_android" role="dialog">
	<div class="modal-dialog  modal-lg">
		<div class="modal-content">

			<div class="modal-header">
				<div class="seccion-modal">Ingresar el siguiente ID en la Aplicacción</div>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>
			<hr class="separador ml-4 mr-4">

			<div class="modal-body">
				<div class="container">
					<!-- CARGA DE IMÁGENES DE INSTALACIÓN -->
					<div class="text-center">
						<h1 class="border rounded-lg py-3">ID = {{$asignacion_solicitudes[0]->idAsig}}</h1>
					</div>
					<!-- FIN CARGA DE IMÁGENES DE INSTALACIÓN -->
				</div>	
				<div class="container form-group text-center my-4">
					<button class="btn btn-prim w-25" type="button" data-dismiss="modal">CANCELAR</button>
				</div>
			</div>
		</div>
	</div>
</div>


<div class="modal fade" id="modalfirma" tabindex="-1" role="dialog" aria-labelledby="modalfirma" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">

			<div class="modal-header">
				<div class="seccion-modal" id="exampleModalLabel">Ingrese Firma</div>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<div class="modal-body">
			</div>

			<div class="modal-footer">
				<button type="button" class="btn btn-primary">Guardar Firma</button>
				<button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
			</div>
		</div>
	</div>
</div>
@endsection



<script>

function sumarCantidaes(identificador){

    acumulador = $("."+identificador).val();
    suma = parseFloat(acumulador) + parseFloat(1);
    $("."+identificador).val(suma);
    $(".id_"+identificador).text(suma);
// id_cantidadLk
}
function restarCantidaes(identificador){
    acumulador = $("."+identificador).val();
    resta = parseFloat(acumulador) - parseFloat(1);
    if(resta >= 1){
        $("."+identificador).val(resta);
         $(".id_"+identificador).text(resta);
    }
   

}


	function firmar(){
	

		 url_img = document.getElementById("pizarra").toDataURL('image/png');
		 console.log(check);
			$("#imagen_firma").val(url_img);
		// 	e.preventDefault();
		// 	var f = $(this);
		// pizarra
		// imagen_firma
		// check

		var formData = new FormData();
		formData.append("pizarra", $("#pizarra").val());
		formData.append("imagen_firma", url_img);
		formData.append("check", $("#check").val());

	 	// var formData = new FormData(document.getElementById("formCanvas"));
			var a = document.getElementById("jerarquia");
			$.ajax({
				headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
					url: "{{ route('guardandofotosservicios')  ?? ''}}",
					type: "post",
					dataType: "html",
					data: formData,
					a,
					cache: false,
					contentType: false,
					processData: false,
					success: function(response) {
						alert(response);
					},
					error: function(xhr, status) {
						alert('Disculpe, ha ocurrido un problema, intente mas tarde');
					}
				})
			.done(function(res) {});



	}
	var lineas = [];

	function borrar() {

		// Creamos nuestro canvas
		var canvas = document.getElementById("pizarra");
		var ctx = canvas.getContext("2d");

		

		// Borramos el ÃƒÂ¡rea que nos interese
		ctx.clearRect(0, 0, canvas.width, canvas.height);
		//	console.log(lineas);
		lineas = [];
	}

	$(function() {

		var element = $("#pizarra"); // global variable
		var getCanvas; // global variable

		function downloadURI(uri, name) {
			var link = document.createElement("a");
			link.download = name;
			link.href = uri;
		}
		html2canvas(element, {
			onrendered: function(canvas) {
				getCanvas = canvas;
			}
		});

		//======================================================================
		// VARIABLES
		//======================================================================
		let miCanvas = document.querySelector('#pizarra');

		let correccionX = 0;
		let correccionY = 0;
		let pintarLinea = false;

		let posicion = miCanvas.getBoundingClientRect()
		correccionX = posicion.x;
		correccionY = posicion.y;

		miCanvas.width = 250;
		miCanvas.height = 250;

		//======================================================================
		// FUNCIONES
		//======================================================================

		//borrar	

		/**
		 * Funcion que empieza a dibujar la linea
		 */
		function empezarDibujo() {
			pintarLinea = true;
			lineas.push([]);
		};

		/**
		 * Funcion dibuja la linea
		 */
		function dibujarLinea(event) {
			event.preventDefault();
			if (pintarLinea) {
				let ctx = miCanvas.getContext('2d')
				// Estilos de linea
				ctx.lineJoin = ctx.lineCap = 'round';
				ctx.lineWidth = 5;
				// Color de la linea
				ctx.strokeStyle = '#000';


				
				// Marca el nuevo punto
				let nuevaPosicionX = 0;
				let nuevaPosicionY = 0;
				if (event.changedTouches == undefined) {
					// Versión ratón
					nuevaPosicionX = event.layerX;
					nuevaPosicionY = event.layerY;
				} else {
					// Versión touch, pantalla tactil
					nuevaPosicionX = event.changedTouches[0].pageX - correccionX;
					nuevaPosicionY = event.changedTouches[0].pageY - correccionY;
				}
				// Guarda la linea
				lineas[lineas.length - 1].push({
					x: nuevaPosicionX,
					y: nuevaPosicionY
				});
				// Redibuja todas las lineas guardadas
				ctx.beginPath();
				lineas.forEach(function(segmento) {
					ctx.moveTo(segmento[0].x, segmento[0].y);
					segmento.forEach(function(punto, index) {
						ctx.lineTo(punto.x, punto.y);
					});
				});
				ctx.stroke();
			}
		}

		/**
		 * Funcion que deja de dibujar la linea
		 */
		function pararDibujar() {
			pintarLinea = false;
		}

		//======================================================================
		// EVENTOS
		//======================================================================

		// Eventos raton
		miCanvas.addEventListener('mousedown', empezarDibujo, false);
		miCanvas.addEventListener('mousemove', dibujarLinea, false);
		miCanvas.addEventListener('mouseup', pararDibujar, false);

		// Eventos pantallas táctiles
		miCanvas.addEventListener('touchstart', empezarDibujo, false);
		miCanvas.addEventListener('touchmove', dibujarLinea, false);

		////////////////////////////////////////

       

		// $("#formuploadajax").on("submit", function(e) {
		// 	e.preventDefault();
		// 	var f = $(this);
		// 	var formData = new FormData(document.getElementById("formuploadajax"));
		// 	formData.append("dato", "valor");
		// 	//formData.append(f.attr("name"), $(this)[0].files[0]);
		// 	$.ajax({
		// 			url: "{{ route('save.save_imagen_servicios_tres')  ?? ''}}",
		// 			type: "post",
		// 			dataType: "html",
		// 			data: formData,
		// 			cache: false,
		// 			contentType: false,
		// 			processData: false,
		// 			beforeSend: function() {
		// 				$("#loader").text("Subiendo Imágenes.....");
		// 			},
		// 			success: function(response) {
		// 				alert(response);
		// 				alert(response);
		// 				$("#loader").text("");
		// 				console.log(response);
		// 				$("#mensaje-text").text("Imagenes Guardadas");
		// 				alert("imagenes guardadas");
		// 				$("#modal_historial_retiros").modal('hide');
		// 			}
		// 		})
		// 		.done(function(res) {
		// 			$("#mensaje").html("Respuesta: " + res);
		// 		});
		// });
		// $("#formuploadservicios").on("submit", function(e) {
		// 	e.preventDefault();
		// 	var aaa = $(this);
		// 	var formData = new FormData(document.getElementById("formuploadservicios"));
		// 	formData.append("dato", "valor");
		// 	$.ajax({
		// 		
		// 			type: "post",
		// 			dataType: "html",
		// 			data: formData,
		// 			cache: false,
		// 			contentType: false,
		// 			processData: false,
		// 			beforeSend: function() {
		// 				$("#loader").text("Subiendo Imágenes.....");
		// 			},
		// 			success: function(response) {
		// 				$("#loader").text("");
		// 				console.log(response);
		// 				$("#mensaje-text").text("Imagenes Guardadas");
		// 				alert("imagenes guardadas");
		// 				$("#modal_fotos_accesorios").modal('hide');
		// 			}
		// 		})
		// 		.done(function(res) {
		// 			$("#mensaje").html("Respuesta: " + res);
		// 		});
		// });
		//fin de la fucn
	});

	$(document).ready(function() {
		//funcion para poder cambiar las opciones del finalizar
		$('#estado').change(function() {
			buscar_opciones($("#estado option:selected").val(), "#detalle");
		})

		//enviar for firma
		$("#formCanvas").on("submit", function(e) {
			url_img = document.getElementById("pizarra").toDataURL('image/png');
			$("#imagen_firma").val(url_img);
			e.preventDefault();
			var f = $(this);
			var formData = new FormData(document.getElementById("formCanvas"));
			var a = document.getElementById("jerarquia");
			$.ajax({
					url: "{{ route('guardandofotosprueba')  ?? ''}}",
					type: "post",
					dataType: "html",
					data: formData,
					a,
					cache: false,
					contentType: false,
					processData: false,
					success: function(response) {
						alert(response);
					},
					error: function(xhr, status) {
						alert('Disculpe, ha ocurrido un problema, intente mas tarde');
					}
				})
				.done(function(res) {});
		});

		//modal imagenes
		$('.asignarimagen').click(function() {
			$("#modal_historial_retiros").modal('show');
		});
		//mueble
		$("#mueble").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'mueble');
		});
		$("#kit_lector").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'kit_lector');
		});
		$("#memoria_sd").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'memoria_sd');
		});
		$("#cable_poder").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'cable_poder');
		});
		$("#cable_red").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'cable_red');
		});
		$("#conexion_electrica").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'conexion_electrica');
		});
		$("#servidor_impresion").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'servidor_impresion');
		});
		$("#conf_smb").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'conf_smb');
		});
		$("#conf_email").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'conf_email');
		});
		$("#modo_U253").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'modo_U253');
		});
		$("#ins_driver").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'ins_driver');
		});
		$("#equipo_operativo").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'equipo_operativo');
		});
		$('#no_firma_cliente').on('click', function() {
			if ($(this).is(':checked')) {
				// Hacer algo si el checkbox ha sido seleccionado
				//    alert("El checkbox con valor " + $(this).val() + " ha sido seleccionado");
				$("#contenido").css("display", "none")
			} else {
				$("#contenido").css("display", "")
			}
		});
	}); //fin del onclick

	function tres_estados(el, id_chec) {

		switch (el.data('checked')) {
			case 0: //cehckeado
				el.data('checked', 1);
				el.prop('indeterminate', false);
				el.prop('checked', true);
				var valor2 = id_chec;
				var valor = $("#cambio").val();
				$("#" + id_chec).val("si");
				break;

			case 1:
				el.data('checked', 2);
				el.prop('indeterminate', true);
				el.prop('checked', true);
				var valor2 = id_chec;
				var valor = $("#cambio").val();
				valor += " sin " + valor2 + ',';
				$("#" + id_chec).val("no");
				break;

			default:
				el.data('checked', 0);
				el.prop('indeterminate', false);
				el.prop('checked', false);
				var valor2 = id_chec;
				var valor = $("#cambio").val();
				$("#" + id_chec).val("");
		}
	}

	function buscar_opciones(id_estado, id_detalle, direccion = "") {
		//el parametro direccion, es por si mandan la solicitud desde un punto que no conincide con toda la raiz. (../) 
		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			type: 'POST',
			url: "{{ route('buscar_opciones')  ?? ''}}",
			data: {
				'id': id_estado
			},
			success: function(data) {
				$("#detalle").empty();
				$.each(data, function(id, dato) {
					sin_espacio = dato.replace(/\s+/g, "_");
					$("#detalle").append("<option value=" + sin_espacio + ">" + dato + "</option>");
				});
			},
			error: function(xhr, status) {
				alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
			}
		});
	}

	function soloNumeros(e) {
		var key = window.Event ? e.which : e.keyCode
		return (key >= 48 && key <= 57)
	}
</script>
<?php
// comprovamos si se envió la imagen
if (isset($_POST['imagen'])) {

	// mostrar la imagen
	echo '<img src="' . $_POST['imagen'] . '" border="1">';

	// funcion para gusrfdar la imagen base64 en el servidor
	// el nombre debe tener la extension
	function uploadImgBase64($base64, $name)
	{
		// decodificamos el base64
		$datosBase64 = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $base64));
		// definimos la ruta donde se guardara en el server
		$path = $_SERVER['DOCUMENT_ROOT'] . '/firmas/' . $name;
		// guardamos la imagen en el server
		if (!file_put_contents($path, $datosBase64)) {
			// retorno si falla
			return false;
		} else {
			// retorno si todo fue bien
			return true;
		}
	}
	// llamamos a la funcion uploadImgBase64( img_base64, nombre_fina.png)
	uploadImgBase64($_POST['imagen'], 'mi_imagen_' . date('d_m_Y_H_i_s') . '.png');
}
?>
<script>
	function rellenar(id) {
		if ($("#" + id).val() == "no") {
			$("#" + id).prop('indeterminate', true);
			$("#" + id).prop('checked', true);
		} else if ($("#" + id).val() == "si") {
			$("#" + id).prop('indeterminate', false);
			$("#" + id).prop('checked', true);
		}

	}
</script>

<script>
	$(function() {
		var idCheck = ["equipo_operativo", "ins_driver", "modo_U253", "conf_email", "conf_smb", "servidor_impresion", "conexion_electrica", "cable_red", "cable_poder", "mueble", "kit_lector", "memoria_sd", ];

		for (let i = 0; i < idCheck.length; i++) {
			rellenar(idCheck[i]);
		}

		$("#mueble").data('checked', 0).on('click', function() {
			el = $(this);
			tres_estados(el, 'mueble');
		});

		// $("#estado").change(function() {
		// 	var selecion = $(this).val();
		// 	if (selecion == "Pendiente") {
		// 		$('#Software').removeAttr("required__*");
		// 		$('#tipo_equipo').removeAttr("required__*");
		// 		$('#mueble').removeAttr("required__*");
		// 		$('#kit_lector').removeAttr("required__*");
		// 		$('#memoria_sd').removeAttr("required__*");
		// 		$('#cable_red').removeAttr("required__*");
		// 		$('#cable_poder').removeAttr("required__*");
		// 		$('#tipo_conexion').removeAttr("required__*");
		// 		$('#conexion_electrica').removeAttr("required__*");
		// 		$('#servidores').removeAttr("required__*");
		// 		$('#servidor_impresion').removeAttr("required__*");
		// 		$('#conf_smb').removeAttr("required__*");
		// 		$('#conf_email').removeAttr("required__*");
		// 		$('#modo_U253').removeAttr("required__*");
		// 		$('#ins_driver').removeAttr("required__*");
		// 		$('#cantidad_usuarios').removeAttr("required__*");
		// 		$('#equipo_operativo').removeAttr("required__*");
		// 		$('#cambio').removeAttr("required__*");
		// 	} else if (selecion == "Cancelar") {
		// 		$('#Software').removeAttr("required__*");
		// 		$('#tipo_equipo').removeAttr("required__*");
		// 		$('#mueble').removeAttr("required__*");
		// 		$('#kit_lector').removeAttr("required__*");
		// 		$('#memoria_sd').removeAttr("required__*");
		// 		$('#cable_red').removeAttr("required__*");
		// 		$('#cable_poder').removeAttr("required__*");
		// 		$('#tipo_conexion').removeAttr("required__*");
		// 		$('#conexion_electrica').removeAttr("required__*");
		// 		$('#servidores').removeAttr("required__*");
		// 		$('#servidor_impresion').removeAttr("required__*");
		// 		$('#conf_smb').removeAttr("required__*");
		// 		$('#conf_email').removeAttr("required__*");
		// 		$('#modo_U253').removeAttr("required__*");
		// 		$('#ins_driver').removeAttr("required__*");
		// 		$('#cantidad_usuarios').removeAttr("required__*");
		// 		$('#equipo_operativo').removeAttr("required__*");
		// 		$('#cambio').removeAttr("required__*");
		// 	}
		// });
	});
</script>
<script>
	element = document.getElementById("equipo_de_remplazo");

	function showContent() {
		element = document.getElementById("equipo_de_remplazo");
		check = document.getElementById("maquina_b_n");
		check2 = document.getElementById("maquina_color");

		if (check.checked) {
			// element.style.display = '';
		} else if (check2.checked) {
			// element.style.display = 'none';
		} else {
			// element.style.display = 'none';
		}
	}

	function changeCheckNo() {
		($('#maquina_color')).prop('checked', false);
        $(".id_color").css("display","none");
		$(".id_color").prop("required", false);
		// $(".id_bn").prop("required", true);
	}

	function changeCheckSi() {
		// element.style.display = 'none';
     
        $(".id_color").css("display","");
		// $(".id_bn").prop("required", false);
		$(".id_color").prop("required", true);
		($('#maquina_b_n')).prop('checked', false);
	}
</script>
<script>
	function desabilitar() {
		cambio = document.getElementById("cambio_serie");
		serie = document.getElementById("serie_remplazo");
		modelo = document.getElementById("modelo_remplazo");
		if (cambio.checked) {
			serie.removeAttribute('disabled');
			modelo.removeAttribute('disabled');
		} else {
			serie.setAttribute('disabled', 'disabled');
			modelo.setAttribute('disabled', 'disabled');
		}
	}
</script>
<script>
	// Example starter JavaScript for disabling form submissions if there are invalid fields
	(function() {
		'use strict'
		window.addEventListener('load', function() {
			// Fetch all the forms we want to apply custom Bootstrap validation styles to
			var forms = document.querySelectorAll('.needs-validation')

			// Loop over them and prevent submission
			Array.prototype.slice.call(forms).forEach(function(form) {
				form.addEventListener('submit', function(event) {
					if (!form.checkValidity()) {
						event.preventDefault()
						event.stopPropagation()
					}
					form.classList.add('was-validated')
				}, false)
			})
		})
	})()
</script>
<script>
	var expanded = false;

	function showCheckBoxes2() {
		checkboxes = document.getElementById("checkboxes2");
		if (!expanded) {
			checkboxes.style.display = "block";
			expanded = true;
		} else {
			checkboxes.style.display = "none";
			expanded = false;
		}
	}
</script>
<script>
	var aux = 1;
	var aux2 = 1;

	function myFunction() {
		descripcion = $('#keywords').val();
		id = $('#id_accesorio').val();
		articulo = $('#articulo').val();
		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			type: 'POST',
			url: "{{ route('go.search_accesorios')  ?? ''}}",
			data: {
				'id': id,
				'articulo': articulo,
				'descripcion': descripcion
			},
			success: function(data) {
				$('#accesorios').empty();
				$(data).each(function(i, v) {
					$('#accesorios').append(
						'<tr><td class="agregar" onclick="agregar(' + v.id + ')">' + v.descripcion + '</td></tr');
				})
			},
			error: function(xhr, status) {
				alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
			}
		});
	};
	function buscarAcessorios(opt) {
        descripcion = $('#buscaasesorio'+opt).val();
		id = $('#id_accesorio2').val();
		 articulo = $('#buscaasesorio'+opt).val();
        // alert(descripcion);
        $.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			type: 'POST',
			url: "{{ route('go.search_accesorios')  ?? ''}}",
			data: {
				'id': id,
				'articulo': articulo,
				'descripcion': descripcion,
                'opciones': "servicio"
			},
			success: function(data) {
                console.log(data);
				$('#laccesorios'+opt).empty();
				$(data).each(function(i, v) {
					$('#laccesorios'+opt).append(
						'<tr><td class="agregar" onclick="agregarAccesorios(' + v.id +','+opt+')">' + v.descripcion + '</td></tr');
				})
			},
			error: function(xhr, status) {
				alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
			}
		});
    }
    function agregarAccesorios(id,opt){

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: "{{ route('go.agregar_accesorio')  ?? ''}}",
            data: {
                'id': id
            },
            success: function(data) {
               // alert(data[0].articulo);

                // 0: Object { id: 8564, articulo: "1902LC0UN0", descripcion: "WT-860 TA-3500I/4500I/5500I/3501I/4501I/5501", … }
                $('#desc'+opt).val(data[0].descripcion);
                $('#part'+opt).val(data[0].articulo);
//                 desc1
                $('#laccesorios'+opt).empty();
// 
              //  console.log(data);
                
               // limpiar();
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        });

    }
	function myFunction2() {
		descripcion = $('#keywords2').val();
		id = $('#id_accesorio2').val();
		articulo = $('#articulo2').val();
		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			type: 'POST',
			url: "{{ route('go.search_accesorios')  ?? ''}}",
			data: {
				'id': id,
				'articulo': articulo,
				'descripcion': descripcion
			},
			success: function(data) {
				$('#accesorios2').empty();
				$(data).each(function(i, v) {
					$('#accesorios2').append(
						'<tr><td class="agregar" onclick="agregar2(' + v.id + ')">' + v.descripcion + '</td></tr');
				})
			},
			error: function(xhr, status) {
				alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
			}
		});
	};


	function agregar(id) {
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: "{{ route('go.agregar_accesorio')  ?? ''}}",
            data: {
                'id': id
            },
            success: function(data) {
                $(data).each(function(i, v) {
					if(v.serie_parte == "undefined" || v.serie_parte == null){
						v.serie_parte == "";
					}
                    $('#agregar_accesorios').append(
                        '<tr class="eliminar' + aux + '">' +
                        '<td>' +
                        '<input name="descripcion_accesorio[]" value="' + v.id + '" type="hidden">' + v.descripcion +
                        '</td>' +
                        '<td>'+ v.articulo +'</td>' +
                        '<td> <input type="text" name="serie_parte[]" class="form-control" placeholder="Serie de parte" onkeyup="this.value=Numeros(this.value)"' + v.serie_parte + '"> </td>' +
                        '<td>' +
							'<button class="btn btn-light" type="button" onclick="sumalo(' + aux + ')">+</button>' +
								'<input type="hidden" name="cantidad[]" value="1" class="resultados' + aux + '" id="resultados' + aux + '">' +
								'<span class="mx-2 resultado' + aux + '" id="resultado' + aux + '">1</span>' +
							'<button class="btn btn-light" type="button" onclick="restalo(' + aux + ')">-</button>' +
                        '</td>' +
                        '<td class="text-center" onclick="eliminalo(' + aux + ')">'+
							'<a class="btn-icon btn-icon-dd ver_historial_retiros">'+
								'<span class="material-icons-round">'+
									'delete'+
								'</span>'+
							'</a>'+
						'</td>' +
                        '</tr');
                })
                aux++;
                limpiar();
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        });
    };

    function agregar2(id) {
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: "{{ route('go.agregar_accesorio')  ?? ''}}",
            data: {
                'id': id
            },
            success: function(data) {
                $(data).each(function(i, v) {
					if(v.serie_parte == undefined || v.serie_parte == null){
						v.serie_parte = "";
					}
                    $('#agregar_accesorios2').append(
                        '<tr class="2eliminar' + aux2 + '">' +
                        '<td>' +
                        '<input name="descripcion_accesorio2[]" value="' + v.id + '" type="hidden">' + v.descripcion +
                        '</td>' +
                        '<td>'+ v.articulo +'</td>' +
                        '<td> <input type="text" name="serie_parte2[]" class="form-control" placeholder="Serie de parte" onkeyup="this.value=Numeros(this.value)" value="' + v.serie_parte + '" > </td>' +
                        '<td>' +
                        '<button class="btn btn-light" type="button" onclick="sumalo2(' + aux2 + ')">+</button>' +
                        '<input type="hidden" name="cantidad2[]" value="1" class="2resultados' + aux2 + '" id="2resultados' + aux2 + '">' +
                        '<span class="mx-2 2resultado' + aux2 + '" id="2resultado' + aux2 + '">1</span>' +
                        '<button class="btn btn-light" type="button" onclick="restalo2(' + aux2 + ')">-</button>' +
                        '</td>' +
                        '<td class="text-center" onclick="eliminalo2(' + aux2 + ')">'+
							'<a class="btn-icon btn-icon-dd ver_historial_retiros">'+
								'<span class="material-icons-round">'+
									'delete'+
								'</span>'+
							'</a>'+
						'</td>' +
                        '</tr');
                })
                aux2++;
                limpiar2();
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        });
    };

	function limpiar() {
		$('#keywords').val("");
		$('#id_accesorio').val("");
		$('#articulo').val("");
		$('#accesorios').empty();
	}
	function limpiar2() {
		$('#keywords2').val("");
		$('#id_accesorio2').val("");
		$('#articulo2').val("");
		$('#accesorios2').empty();
	}

	function eliminalo(params) {
		$(".eliminar" + params).remove();
	}
	function eliminalo2(params) {
		$(".2eliminar" + params).remove();
	}

	function sumalo(params) {
		x = document.getElementById("resultado" + params).innerText;
		x++;
		document.getElementById("resultado" + params).innerText = x;
		document.getElementById("resultados" + params).value = x;
	}
	function sumalo2(params) {
		x = document.getElementById("2resultado" + params).innerText;
		x++;
		document.getElementById("2resultado" + params).innerText = x;
		document.getElementById("2resultados" + params).value = x;
	}

	function restalo(params) {
		x = document.getElementById("resultado" + params).innerText;
		x--;
		if (x < 1) {} else {
			document.getElementById("resultado" + params).innerText = x;
			document.getElementById("resultados" + params).value = x;
		}
	}
	function restalo2(params) {
		x = document.getElementById("2resultado" + params).innerText;
		x--;
		if (x < 1) {} else {
			document.getElementById("2resultado" + params).innerText = x;
			document.getElementById("2resultados" + params).value = x;
		}
	}
</script>
<script>
	function showContent2() {
		element2 = document.getElementById("motivos");
		check = document.getElementById("accesorios_si");
		check2 = document.getElementById("accesorios_no");
		if (check.checked) {
			element2.style.display = '';
		} else if (check2.checked) {
			element2.style.display = 'none';
		} else {
			element2.style.display = 'none';
		}
	}

	function changeCheckNo2() {
		($('#accesorios_no')).prop('checked', false);
	}

	function changeCheckSi2() {
		element2 = document.getElementById("motivos");
		element_div_danados = document.getElementById("div_accesorios_danados");
		element_div_solicitados = document.getElementById("div_accesorios_solicitados");
		element2.style.display = 'none';
		element_div_danados.style.display = 'none';
		element_div_solicitados.style.display = 'none';
		($('#accesorios_si')).prop('checked', false);
	}

	function showContent3() {
		element3 = document.getElementById("div_accesorios_solicitados");
		element4 = document.getElementById("div_accesorios_danados");
		check = document.getElementById("motivo_1");
		check2 = document.getElementById("motivo_2");
		check3 = document.getElementById("motivo_3");

       
		if (check.checked || check3.checked) {
			element3.style.display = '';
			element4.style.display = '';
		} else if (check2.checked) {
			element3.style.display = 'none';
			element4.style.display = '';
		} else {
			element3.style.display = 'none';
			element4.style.display = 'none';
		}
	}

	function changeCheckMotivo1() {
		($('#motivo_2')).prop('checked', false);
		($('#motivo_3')).prop('checked', false);
		element4 = document.getElementById("fotos_accesorios");
	    //element4.style.display = 'none';
        element4.style.display = '';
	}

	function changeCheckMotivo2() {
		element3 = document.getElementById("div_accesorios_solicitados");
		element4 = document.getElementById("div_accesorios_danados");
		element3.style.display = '';
		element4.style.display = 'none';
        element44 = document.getElementById("fotos_accesorios");
	    //element4.style.display = 'none';
        element44.style.display = '';
		($('#motivo_1')).prop('checked', false);
		($('#motivo_3')).prop('checked', false);
	}

	function changeCheckMotivo3() {
		element4 = document.getElementById("fotos_accesorios");
        element4.style.display = '';
		//element4.style.display = 'none';
		($('#motivo_1')).prop('checked', false);
		($('#motivo_2')).prop('checked', false);
	}

	function showContent4() {
		element4 = document.getElementById("fotos_accesorios");
		check = document.getElementById("motivo_1");
		check2 = document.getElementById("motivo_2");
		check3 = document.getElementById("motivo_3");
   
		div_accesorios_solicitados = document.getElementById("div_accesorios_solicitados");
		if (check2.checked) {
			element4.style.display = '';
		} else {
			element4.style.display = 'none';
			div_accesorios_solicitados.style.display = 'none';
		}
	}
</script>
<script>
	$(document).ready(function() {
		$('.asignarimagenes').click(function() {


			check = document.getElementById("motivo_1");
			check2 = document.getElementById("motivo_2");
			check3 = document.getElementById("motivo_3");

		if (check3.checked) {

		
				$("#cargafotoa1_1").css("display","");
				$("#cargafotoa1_2").css("display","");
				$("#cargafotoa1_3").css("display","");
				$("#title_123").css("display","");
			
		} else {
		
			$("#cargafotoa1_1").css("display","none");
			$("#cargafotoa1_2").css("display","none");
			$("#cargafotoa1_3").css("display","none");
			$("#title_123").css("display","none");
		}
			

			$("#modal_fotos_accesorios").modal('show');
		});
	})
</script>
<script>

$(document).ready(() => {
$(".formuploadajax").on("submit", function(e) {
				e.preventDefault();
				let form = $(this),
					wrapper = $('.wrapper'),
					progress_bar = $('.progress-bar'),
					data = new FormData(form.get(0));
                    console.log("aa");
                    console.log(data);
				progress_bar.removeClass('bg-success bg-danger').addClass('bg-info')
				progress_bar.css('width', '0%');
				progress_bar.html('Preparando...');
				wrapper.fadeIn();

				$.ajax({
					xhr: function() {
						let xhr = new window.XMLHttpRequest();
						xhr.upload.addEventListener("progress", function(e) {
							if (e.lengthComputable) {
								let percentComplete = Math.floor((e.loaded / e.total) * 100);
								progress_bar.css('width', percentComplete + '%');
								progress_bar.html(percentComplete + '%');
							}
						}, false);
						return xhr;
					},
                    url: "{{ route('save.save_imagen_servicios_tres')  ?? ''}}",
					type: "post",
					dataType: "json",
					data: data,
					cache: false,
					contentType: false,
					processData: false,
					beforeSend: () => {
						$("button", form).attr('disabled', true);
					}
				}).done(res => {
                    console.log(res);
					if (res.status === 200) {
						progress_bar.removeClass('bg-info').addClass('bg-success');
						progress_bar.html('Subida exitosa!');
						setTimeout(() => {
							wrapper.fadeOut;
							progress_bar.removeClass('bg-success bg-danger').addClass('bg-info');
							progress_bar.css('width', '0%');
						}, 1500);
						setTimeout(() => {
							$("#carouselExampleControls2").carousel("next");
							$(".previus_carrusel2").css("display", "")
						}, 2000);
					} else {
						alert(res.msg);
						progress_bar.css('width', '100%');
						progress_bar.html(res.msg);
					}
				}).fail(err => {
					progress_bar.removeClass('bg-success bg-info').addClass('bg-danger');
					progress_bar.html('Hubo un error!');
				}).always(() => {
					$('button', form).attr('disabled', false);
				})
			});


			$(".cancel_image").click(function() {
				id = $('#idchecklist').val();
				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					type: 'POST',
					url: "{{ route('go.cancelarfotoschecklistServicios') }}",
					data: {
						'id': id,
					},
					success: function(data) {
						console.log(data);
						$("#modal_historial_retiros").modal('hide');
					},
					error: function(xhr, status) {
						alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
					}
				});
			});

// 7
$(".formuploadaccesorios").on("submit", function(e) {
				e.preventDefault();
				let form = $(this),
					wrapper2 = $('.wrap2'),
					progress_bar2 = $('.progbar2'),
					data = new FormData(form.get(0));
				progress_bar2.removeClass('bg-success bg-danger').addClass('bg-info')
				progress_bar2.css('width', '0%');
				progress_bar2.html('Preparando...');
				wrapper2.fadeIn();
				$.ajax({
					xhr: function() {
						let xhr = new window.XMLHttpRequest();
						xhr.upload.addEventListener("progress", function(e) {
							if (e.lengthComputable) {
								let percentComplete = Math.floor((e.loaded / e.total) * 100);
								progress_bar2.css('width', percentComplete + '%');
								progress_bar2.html(percentComplete + '%');
							}
						}, false);
						return xhr;
					},
					url: "{{ route('save.imagen_accesorios_servicios') }}",
					type: "post",
					dataType: "json",
					data: data,
					cache: false,
					contentType: false,
					processData: false,
				}).done(res => {
                    console.log(res);
					console.log("res");
					if (res.status === 200) {
						progress_bar2.removeClass('bg-info').addClass('bg-success');
						progress_bar2.html('Subida exitosa!');
						setTimeout(() => {
							wrapper2.fadeOut;
							progress_bar2.removeClass('bg-success bg-danger').addClass('bg-info');
							progress_bar2.css('width', '0%');
						}, 1500);
						setTimeout(() => {
							$("#carouselExampleControls").carousel("next");
							$(".previus_carrusel").css("display", "")
						}, 2000);
					} else {
						alert(res.msg);
						progress_bar2.css('width', '100%');
						progress_bar2.html(res.msg);
					}
				}).fail(err => {
					progress_bar2.removeClass('bg-success bg-info').addClass('bg-danger');
					progress_bar2.html('Hubo un error!');
				}).always(() => {
					$('button', form).attr('disabled', false);
				})
			});


            //
        });
</script>