@extends('menu/menu')
<style>
	.iniciado {
		background-color: #e6a925;
		text-align: center;
	}
</style>
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js%22%3E</script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>
{{-- <link  href="{{ asset('css/a&a_style.css') }}" href="a&a_style.css" rel="stylesheet" type="text/css"> --}}



@section('content')

@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

<div class="container mt-5">
	<div class="title-vista mt-4 d-flex justify-content-between">
		Servicios
		<div class="mostrar-contenido">
			<a href="javascript: history.go(-1)">
				<span class="material-icons-round icon-midle">arrow_{bac}k</span>
				Volver
			</a>
		</div>
	</div>
</div>
<div class="container mt-4"></div>
<form action="{{route('filtro_tecnico')}}" method="GET" hidden>
	<div class="container mt-4">

		<div class="seccion-filtro">Firltrar por</div>
		<hr class="separador">

		<div class="row">
			<div class="col-sm-3 form-group">
				<label for="fecha">Fecha (obligatorio)</label>
				<input type="date" class="form-control mayuscula" id="fecha" name="fecha">
			</div>

			<div class="col-sm-3 form-group">
				<label for="email">Comuna</label>
				<select name="comuna" class="custom-select">
					<option selected disabled>seleccionar</option>
					@if (!empty($comuna_retiros))
					@foreach ($comuna_retiros as $comuna_retiros_)
					@if ($comuna_retiros_->Cscomuna != null)
					<option value="{{ $comuna_retiros_->Cscomuna }}">{{ucfirst(strtolower($comuna_retiros_->Cscomuna))}}
						@endif
						@endforeach
						@endif
				</select>
			</div>

			<div class="col-sm-3 form-group">
				<label for="email">Asignación</label>
				<select name="asignacion" class="custom-select">
					<option selected disabled>seleccionar</option>
					@if (!empty($asignaciones))
					@foreach ($asignaciones as $asignaciones_)
					@if ($asignaciones_->tipo != null)
					<option value="{{ $asignaciones_->tipo }}">{{ucfirst(strtolower($asignaciones_->tipo))}}
						@endif
						@endforeach
						@endif
				</select>
			</div>

			<div class="col-sm-3 form-group">
				<label for="serie">Nº serie</label>
				<input type="" class="form-control mayuscula" id="" placeholder="Nº de Serie" name="serie">
			</div>

			<div class="col-sm-3 form-group">
				<label for="estado">Estado</label>
				<select name="estado" class="custom-select">
					<option selected disabled>seleccionar</option>
					@if (!empty($estado_retiros))
					@foreach ($estado_retiros as $estado_retiros)
					@if ($estado_retiros->estado_asignacion != null)
					@if($estado_retiros->estado_asignacion == "tarea_asignada")
					<option value="{{ $estado_retiros->estado_asignacion }}">Tarea Asignada
						@else
					<option value="{{ $estado_retiros->estado_asignacion }}">{{ucfirst(strtolower($estado_retiros->estado_asignacion))}}
						@endif
						@endif
						@endforeach
						@endif
				</select>
			</div>
		</div>

		<!-- FIN BARRA DE BUSQUEDA -->
		<div class="text-center mb-5 mt-5">
			<button type="buscar" class="btn btn-prim w-25">Buscar</button>
		</div>
	</div>
</form>


<!-- TABLA DE RESULTADOS DE BUSQUEDA -->
<div class="container table-responsive mb-5 p-sm-0">
	<table class="table table-striped table-hover">
		<!-- ENCABEZADO -->
		<thead class="color-head">
			<tr>
				<th class="th-head border-th separador-v" colspan="1">Fecha (Visita)</th>
				<th class="th-head border-th separador-v" colspan="1">Comuna</th>
				<th class="th-head border-th separador-v" colspan="1">Dirección y Cliente</th>
				<th class="th-head border-th separador-v" colspan="1">Estado</th>
				<th class="th-head border-th separador-v" colspan="1">Estado dos</th>
				<th class="th-head border-th separador-v" colspan="1">Marca</th>

				<th class="th-head border-th separador-v" colspan="1">Serie</th>
				<th class="th-head border-th separador-v" colspan="1">Ssc</th>
				<th class="th-head border-th separador-v" colspan="1">Asignación</th>
				<th class="th-head border-th separador-v" colspan="1">Observación</th>
				<th class="th-head border-th"><span class="material-icons">settings</span></th>
			</tr>
		</thead>
		<!-- FIN ENCABEZADO -->

		<!-- RESULTADOS -->
		<tbody>
	
			@if(!empty($asignacion_solicitudes))
			@for($i=0;$i<count($asignacion_solicitudes);$i++)
			@foreach ($asignacion_solicitudes[$i] as $los_datos)
			<tr>
				<td class="td-val">{{Carbon\Carbon::createFromDate($los_datos->fecha )->format('d-m-Y')}}</td>
				{{--
					<td>{{$los_datos->Csdireccion}} ({{$los_datos->Cscliente}} )</td>

				@if($los_datos->estado_asignacion == "pendiente")
				<td class="pendiente">{{$los_datos->estado_asignacion}}</td>
				@elseif($los_datos->estado_asignacion == "finalizado")
				<td class="finalizado">{{$los_datos->estado_asignacion}}</td>
				@elseif($los_datos->estado_asignacion == "rechazado")
				<td class="rechazado">{{$los_datos->estado_asignacion}}</td>
				@else
				<td>{{$los_datos->estado_asignacion}}</td>
				@endif --}}
				<td class="td-val">{{$los_datos->sComuna ?? ''}}</td>
				<td class="td-val">{{$los_datos->sDireccion ?? ''}} ({{$los_datos->sCliente ?? ''}} )</td>
				{{-- @if($los_datos->estado_asignacion == "pendiente") --}}
				@if($los_datos->estado_interno == "tarea_asignada")
				<td class="pendiente td-val" style="text-transform: ">Tarea Asignada</td>
				@elseif($los_datos->estado_interno == "pendiente")
				<td class="pendiente td-val" style="text-transform: ">{{ucfirst($los_datos->estado_interno)}}</td>
				@elseif($los_datos->estado_interno == "finalizado")
				<td class="finalizado td-val" style="text-transform: ">{{ucfirst($los_datos->estado_interno)}}</td>
				@elseif($los_datos->estado_interno == "RECHAZADO")
				<td class="rechazado td-val" style="text-transform: ">{{ucfirst($los_datos->estado_interno)}}</td>
				@elseif($los_datos->estado_interno == "INICIADO")
				<td class="iniciado">{{$los_datos->estado_interno}}</td>
				@endif

				<!-- Estado Externo -->
				@if($los_datos->estado_externo == "ASIGNADO")
				<td class="td-val" style="text-transform: ">Tarea Asignada</td>
				@elseif($los_datos->estado_externo == "EN TRANSITO")
				<td>En Transito</td>
				@elseif($los_datos->estado_externo == "ESPERANDO")
				<td>En Espera</td>
				@elseif($los_datos->estado_externo == "INICIADO")
				<td>Iniciado</td>
				@else
				<td></td>
				@endif
				<td class="td-val" style="text-transform: ">{{ucfirst($los_datos->Smarca ?? '')}}</td>

				<td class="td-val" style="text-transform: ">{{ucfirst($los_datos->sSerie ?? '')}}</td>
				<td class="td-val" style="text-transform: ">{{ucfirst($los_datos->sSC ?? '')}}</td>
				<td class="td-val" style="text-transform: ">{{ucfirst($los_datos->tipo ?? 'SERVICIO')}}</td>
				<td class="td-val" style="text-transform: ">{{ucfirst($los_datos->sDescripcion ?? '')}}</td>

				<td class="td-val">
					<div class="dropdown dropleft" style="text-align: center">
						<button type="button" class="btn-dropdown" data-toggle="dropdown">
							<span class="material-icons">more_vert</span>
						</button>

						<div class="dropdown-menu mostrar shadow">
							<div class="d-flex justify-content-around">
								{{-- preguntamos si el estado que viene, esta finalizado --}}

								@if($los_datos->estado_externo == "ASIGNADO")
								<form action="{{route('iniciando.checklist.servicios_en_transito')}}" method="GET">
									<input type="hidden" name="proveedor" value="{{$los_datos->proveedor_servicio}}">
									<input type="hidden" name="idAsig" value="{{Crypt::encryptString($los_datos->idAsig)}}">
									<button class="btn"><span class="material-icons-round">local_shipping</span></button>
								</form>
								@elseif($los_datos->estado_externo == "EN TRANSITO")
								<form action="{{route('iniciando.checklist.servicios_en_espera')}}" method="GET">
									<input type="hidden" name="proveedor" value="{{$los_datos->proveedor_servicio}}">
									<input type="hidden" name="idAsig" value="{{Crypt::encryptString($los_datos->idAsig)}}">
									<button class="btn"><span class="material-icons-round">factory</span></button>
								</form>

								@elseif($los_datos->estado_externo == "ESPERANDO" || $los_datos->estado_externo == "INICIADO" || $los_datos->estado_interno== "RECHAZADO" || $los_datos->sSC== "SC149914")
								<!--a role="button" title="Revisar" class="btn-icon btn-icon-dd">
									<span class="material-icons">visibility</span>
								</a-->
								<form action="{{route('go.iniciarchecservicio')}}" method="GET">
									<input type="hidden" name="proveedor" value="{{$los_datos->proveedor_servicio}}">
									<input type="hidden" name="idAsig" value="{{Crypt::encryptString($los_datos->idAsig)}}">
									<button class="btn"><span class="material-icons-round">play_arrow</span></button>
									@if($los_datos->estado_externo == "RECHAZADO")
									<a href="#" class="motivo_rechazo" data-motivo="{{$los_datos->motivo_rechazo}}" role="button" title="Motivo"><img src="{{ asset('Botones/Botones/advertir.png') }}" alt="" style="margin: 2px 0px" /></a>
									@endif
								</form>
								@endif
							</div>
						</div>
					</div>
				</td>
			</tr>
			@endforeach
			@endfor
			@endif

		</tbody>
		<!-- FIN RESULTADOS -->
	</table>


</div>

<!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->

</div>


<!--Modal  -->
<div class="modal" id="modalRechazo">
	<div class="modal-dialog">
		<div class="modal-content">

			<!-- Modal Header -->
			<div class="modal-header">
				<h4 class="modal-title"> Observaciones</h4>
				<button type="button" class="close" data-dismiss="modal">&times;</button>
			</div>

			<div class="modal-body">
				<label for="cambio">
					<h3>Observaciones</h3>
				</label>
				<textarea class="form-control" style="pointer-events: none" readonly="readonly" name="motivorechazado" value="" rows="4" id="motivo">

										</textarea>
			</div>

		</div>
	</div>
</div>


@endsection

<script>
	$(document).ready(function() {

		$('.motivo_rechazo').click(function() {

			//alert($(this).attr("data-motivo"));
			//
			$("#motivo").text($(this).attr("data-motivo"));
			$("#modalRechazo").modal('show');
		});
	})
</script>