@extends('menu/menu')
@section('content')
@if ( session('mensaje') )
<div class="alert alert-danger">{{ session('mensaje') }}</div>
@endif
<div class="container col-sm-6 form-group" style="  text-align: center;  " ><br><br><br><br><br><br>
  <label for="clientes"><h2>Seleccionar Proveedor </h2></label><br>
  <select  class="custom-select mb-3 opcionesSele2" id="proveedor" name="proveedor" required>
    <option  selected  disabled>Seleccionar</option>
    @if (!empty($carga_selectProveedor))
      @foreach ($carga_selectProveedor as $proveedor)            
        <option  value="{{ $proveedor->proveedor_nombre }}">{{ucfirst(strtolower($proveedor->proveedor_nombre ))}}
        </option> 
      @endforeach
    @endif
  </select>
</div>
<div class="container col-sm-6 form-group" style="  text-align: center;  " ><br>
  <label for="clientes"><h2>Seleccionar Cliente </h2></label><br>
  <select  class="custom-select mb-3 opcionesSele" id="clientes" name="clientes" required>
    <option  selected  disabled>Seleccionar</option>
    {{-- @if (!empty($carga_selectClientes))
      @foreach ($carga_selectClientes as $clientes)            
        @if( $clientes->id  != 4)
        <option  value="{{ $clientes->id }}">{{ucfirst(strtolower($clientes->razon_social ))}}
        @endif
        </option> 
      @endforeach
    @endif--}}
  </select>
</div>

<form action="{{route('go.allchecklist')}}" method="GET">
  <div class="container col-sm-6 form-group" style="  text-align: center;  " ><br>
  <label for="proyectosSeleccionado"><h2>Proyectos Asociados </h2></label><br>
  <select  class="custom-select mb-3" id="detalle" name="proyectosSeleccionado" required>
  <option  selected  disabled>Seleccionar</option>

  </select>
  <input type="submit" class="btn btn-danger"  value="Siguiente">
  </div>
</form>





@endsection
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
<script src="http://code.jquery.com/jquery-1.10.2.min.js"></script>
<script>
  $(document).ready(function() {
    $(".opcionesSele2").change(function(e) { 
      var idClientes = $(this).val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
        url:"{{ route('obtenerClientesAsociados2') }}",
        type: "post",
        data: {'idClientes': idClientes},
        success: function(response) {
          $("#clientes").empty();
          $("#clientes").append("<option value='0'>" + "Seleccionar"+ "</option>");
          $.each(response, function( index, value ) {             
                $("#clientes").append("<option value="+value.id+">" + value.razon_social+ "</option>");
          });
          },
          error: function(xhr, status) {
            alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      })
    })    
    $(".opcionesSele").change(function(e) { 
      var idClientes = $(this).val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
        url:"{{ route('obtenerProyectosAsociados') }}",
        type: "post",
        data: {'idClientes': idClientes},
        success: function(response) {
          $("#detalle").empty();
          $("#detalle").append("<option value='0'>" + "Seleccionar"+ "</option>");
          $.each(response, function( index, value ) {             
                $("#detalle").append("<option value="+value.id+">" + value.nombre+ "</option>");
          });
          },
          error: function(xhr, status) {
            alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      })
    })    
  })
</script>