<?php

namespace App\Http\Controllers\pdfs;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App;
use Crypt;
use Carbon\Carbon;
use Auth;
use DB;


class PdfInstalacionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
        $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');

        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $direccion = $request->direccion;
        $Serie = $request->Serie;
        $sc = $request->sc;

        if (!empty($request->datepicker)) {
            //FILTRO 1 Y 2
            if (!empty($request->datepicker) && !empty($request->clientes)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->whereDate('asignacion_instalacions.fecha_instalacion', '>=', $fecha)
                    ->whereDate('asignacion_instalacions.fecha_instalacion', '<=', $fecha2)
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } else if (!empty($request->datepicker) && !empty($request->region)) {

                //creamos el metodo para traer a todas las asignaciones con ruta pdf
                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->whereDate('asignacion_instalacions.fecha_instalacion', '>=', $fecha)
                    ->whereDate('asignacion_instalacions.fecha_instalacion', '<=', $fecha2)
                    ->where('instalacions.sRegion', '=', $region)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            }
            //FILTRO 1, 4
            else if (!empty($request->datepicker) && !empty($request->comuna)) {
                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->whereDate('asignacion_instalacions.fecha_instalacion', '>=', $fecha)
                    ->whereDate('asignacion_instalacions.fecha_instalacion', '<=', $fecha2)
                    ->where('instalacions.sComuna', '=', $comuna)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } //FILTRO 1, 5
            else if (!empty($request->datepicker) && !empty($request->Serie)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->whereDate('asignacion_instalacions.fecha_instalacion', '>=', $fecha)
                    ->whereDate('asignacion_instalacions.fecha_instalacion', '<=', $fecha2)
                    ->where('instalacions.sSerie', '=', $Serie)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } //FILTRO 1, 6
            else if (!empty($request->datepicker) && !empty($request->sc)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->whereDate('asignacion_instalacions.fecha_instalacion', '>=', $fecha)
                    ->whereDate('asignacion_instalacions.fecha_instalacion', '<=', $fecha2)
                    ->where('instalacions.sSc', '=', $sc)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } else {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->whereDate('asignacion_instalacions.fecha_instalacion', '>=', $fecha)
                    ->whereDate('asignacion_instalacions.fecha_instalacion', '<=', $fecha2)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            }
        } else if (!empty($request->clientes)) {
            //FILTRO 2, 3
            if (!empty($request->clientes) && !empty($request->region)) {


                //creamos el metodo para traer a todas las asignaciones con ruta pdf
                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->where('instalacions.sRegion', '=', $region)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } else
             if (!empty($request->clientes) && !empty($request->comuna)) {


                //creamos el metodo para traer a todas las asignaciones con ruta pdf
                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->where('instalacions.sComuna', '=', $comuna)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } //FILTRO 2, 4
            else if (!empty($request->clientes) && !empty($request->direccion)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->where('instalacions.sDireccion', '=', $direccion)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } //FILTRO 2,5
            else if (!empty($request->clientes) && !empty($request->sc)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->where('instalacions.sCui', '=', $sc)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.id', 'desc')
                    ->get();
            }
            //FILTRO 2, 6
            else if (!empty($request->clientes) && !empty($request->Serie)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->where('instalacions.sSerie', '=', $Serie)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } else {
                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sCliente', '=', $clientes)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            }
        } else if (!empty($request->region)) {
            //FILTRO 2, 3
            if (!empty($request->region) && !empty($request->comuna)) {


                //creamos el metodo para traer a todas las asignaciones con ruta pdf
                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sRegion', '=', $region)
                    ->where('instalacions.sComuna', '=', $comuna)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } //FILTRO 2, 4
            else if (!empty($request->region) && !empty($request->direccion)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sRegion', '=', $region)
                    ->where('instalacions.sDireccion', '=', $direccion)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } //FILTRO 2,5
            else if (!empty($request->region) && !empty($request->sc)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sRegion', '=', $region)
                    ->where('instalacions.sCui', '=', $sc)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            }
            //FILTRO 2, 6
            else if (!empty($request->region) && !empty($request->Serie)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sRegion', '=', $region)
                    ->where('instalacions.sSerie', '=', $Serie)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } else {
                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sRegion', '=', $region)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            }
        } else if (!empty($request->comuna)) {
            //FILTRO 3, 4 ,5
            if (!empty($request->comuna) && !empty($request->direccion)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sComuna', '=', $comuna)
                    ->where('instalacions.sDireccion', '=', $direccion)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } else if (!empty($request->comuna) && !empty($request->sc)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sComuna', '=', $comuna)
                    ->where('instalacions.sCui', '=', $sc)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            }
            //FILTRO 3, 6
            else if (!empty($request->comuna) && !empty($request->Serie)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sComuna', '=', $comuna)
                    ->where('instalacions.sSerie', '=', $Serie)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } else {
                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sComuna', '=', $comuna)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            }
        } else if (!empty($request->direccion)) {
            //FILTRO 4, 5,
            if (!empty($request->direccion) && !empty($request->sc)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sDireccion', '=', $direccion)
                    ->where('instalacions.sCui', '=', $sc)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } else if (!empty($request->direccion) && !empty($request->Serie)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sDireccion', '=', $direccion)
                    ->where('instalacions.sSerie', '=', $Serie)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } else {
                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sDireccion', '=', $direccion)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            }
        }
        //FILTRO 5
        else if (!empty($request->sc)) {
            //FILTRO 5, 6
            if (!empty($request->sc) && !empty($request->Serie)) {

                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sSerie', '=', $request->Serie)
                    ->where('instalacions.sCui', '=', $request->sc)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            } else {
                $rutapdf = DB::table('asignacion_instalacions')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                    ->where('asignacion_instalacions.url_pdf', '!=', "null")
                    ->where('instalacions.sCui', '=', $sc)
                    ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                    ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                    ->get();
            }
        } else if (!empty($request->Serie)) {
            //FILTRO 6
            $rutapdf = DB::table('asignacion_instalacions')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select('asignacion_instalacions.id', 'asignacion_instalacions.url_pdf', 'instalacions.sDireccion', 'instalacions.sCui', 'asignacion_instalacions.fecha_instalacion', 'instalacions.sRegion', 'instalacions.sCliente', 'instalacions.sComuna', 'instalacions.sSerie')
                ->where('asignacion_instalacions.url_pdf', '!=', "null")
                ->where('instalacions.sSerie', '=', $Serie)
                ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                ->get();
        } else {
            //creamos el metodo para traer a todas las asignaciones con ruta pdf
            $rutapdf = DB::table('asignacion_instalacions')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id',
                    'asignacion_instalacions.url_pdf',
                    'asignacion_instalacions.fecha_instalacion',
                    'instalacions.sRegion',
                    'instalacions.sCliente',
                    'instalacions.sComuna',
                    'instalacions.sSerie',
                    'instalacions.sDireccion',
                    'instalacions.sCui'
                )
                ->where('asignacion_instalacions.url_pdf', '!=', "null")
                ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
                ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
                ->get();
        }





        /*FILTROS PDF'S INSTALACION */
        //Cargar Select proyectos
        /*  $proyectos = DB::table('proyectos')
        ->join('clientes','clientes.id','=','proyectos.clientes_id')
        ->where('proyectos.estado','=','1')
        ->where('proyectos.id','!=','1')
        ->select('proyectos.nombre','clientes.razon_social','proyectos.id as id_proyecto')
        ->orderBy('proyectos.id', 'asc')
        ->get(); */

        //Cargar Select clientes
        $carga_selectClientes = DB::table('asignacion_instalacions')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select('instalacions.sCliente')
            ->where('asignacion_instalacions.url_pdf', '!=', "null")
            ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();

        //Cargar Select regiones
        $regiones = DB::table('asignacion_instalacions')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select('instalacions.sRegion')
            ->where('asignacion_instalacions.url_pdf', '!=', "null")
            ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->orderBy('instalacions.sRegion', 'asc')
            ->distinct()
            ->get();


        //Cargar Select Comuna
        $comunas = DB::table('asignacion_instalacions')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select('instalacions.sComuna')
            ->where('asignacion_instalacions.url_pdf', '!=', "null")
            ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->orderBy('instalacions.sComuna', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Direccion
        $direccion = DB::table('asignacion_instalacions')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select('instalacions.sDireccion')
            ->where('asignacion_instalacions.url_pdf', '!=', "null")
            ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->orderBy('instalacions.sDireccion', 'asc')
            ->distinct()
            ->get();




        return view('portal.pdfs_instalacion', compact('carga_selectClientes', 'regiones', 'comunas', 'direccion', 'rutapdf'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }


    public function filtros_instalacionKyocera(request $request)
    {
        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sc = $request->sc;
        $proyectos = $request->proyectos;
        $mostrarMenu = "";

        if ($clientes == "IM OSORNO") {
            $clientes =  "MUNICIPALIDAD DE OSORNO";
        }

        if (($clientes != "" and  $region != "") || ($request->datepicker != "" and  $request->datepicker2 != "")) {
            $mostrarMenu = "si";
        } else {
            $mostrarMenu = "no";
        }

        $instalaciones = DB::table('instalacions')
            //  ->Join('asignacion_solicitudes','asignacion_solicitudes.api_solicitudes_id','=','api_solicitudes.id')
            ->select(
                "instalacions.sEstado_instalacion",
                "instalacions.fecha_instalacion_coordinadora",
                "instalacions.id",
                "instalacions.dFecha_instalacion",
                "instalacions.fecha_registrado",
                "instalacions.sEstado_despacho",
                "instalacions.sCliente",
                "instalacions.sRegion",
                "instalacions.sComuna",
                "instalacions.sSerie",
                "instalacions.Csserie_remplazo",
                "instalacions.Csserie_es",
                "instalacions.sDireccion",
                "proyectos.nombre",
                "instalacions.sSC",
                "instalacions.proveedor_instalacion",

            )

            ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->where("tracker.tipo_tracker", "=", "instalacion")
            ->Join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->Join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id');

            


        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $instalaciones->whereBetween('instalacions.fecha_instalacion_coordinadora', [$fecha, $fecha2]);
        }
        if ($estado != "") {
            $instalaciones->where("instalacions.sEstado_instalacion", "=", $estado);
        }
        if ($clientes != "") {
            $instalaciones->where("instalacions.sCliente", "=", $clientes);
        }
        if ($proyectos != "") {
            $instalaciones->where("proyectos.id", "=", $proyectos);
        }
        if ($region != "") {
            $instalaciones->where("instalacions.sRegion", "=", $region);
        }
        if ($comuna != "") {
            $instalaciones->where("instalacions.sComuna", "=", $comuna);
        }
        if ($serie != "") {
            //$where = $where." and  instalacions.sSerie  = "."'".$serie."'";
            $consulta = DB::table('instalacions')
                ->where('instalacions.sSerie', '=', $serie)
                ->get();

            if (!empty($consulta[0]->sSerie)) {

                $instalaciones->where("instalacions.sSerie", "=", $serie);
            } else {
                $instalaciones->where("instalacions.Csserie_remplazo", "=", $serie);
            }
        }
        if ($sc != "") {
            $instalaciones->where("instalacions.sSC", "=", $sc);
        }
        $instalaciones->orderBy('instalacions.fecha_instalacion_coordinadora', 'DESC');

        $instalaciones = $instalaciones->get();



        $totalInstalaciones = count($instalaciones);


        //Cargar Select Estado
        $carga_selectEstado = DB::table('instalacions')
            ->select('instalacions.sEstado_instalacion')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)

            ->orderBy('instalacions.sEstado_instalacion', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Clientes
        $carga_selectClientes = DB::table('instalacions')
            ->select('instalacions.sCliente')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)


            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('instalacions')
            ->select('instalacions.sRegion')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->where('sCliente', '=', $clientes)


            ->where('instalacions.sRegion', '!=', null)
            ->orderByRaw(DB::raw("FIELD(instalacions.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))
            ->distinct()
            ->get();

        //Cargar Select Comuna
        $carga_selectComuna = DB::table('instalacions')
            ->select('instalacions.sComuna')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->where('sRegion', '=', $region)
            ->where('sCliente', '=',  $clientes)

            ->orderBy('instalacions.sComuna', 'asc')
            ->distinct()
            ->get();

        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
            ->orderBy('personas.nombre_uno', 'asc')
            /* ->where("personas.id","=",$id_persona)   */
            ->distinct()
            ->get();

        $urls = "";

        $carga_selectProyectos = DB::table('proyectos')
            ->select('proyectos.id', 'proyectos.nombre')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('clientes.proveedor_nombre', '=', Auth::user()->nombre_proveedor)
            ->where('clientes.razon_social', '=', $clientes)
            ->get();

            $carga_selectSucursales = DB::table('instalacions')
            ->select('instalacions.sTipo_sucursal')
            ->orderBy('instalacions.sTipo_sucursal', 'asc')
            ->where('sComuna', '=', $comuna)


            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->distinct()
            ->get();

        // foreach ($instalaciones as $items) {
        //     if ($items->url_pdf != NULL) {
        //         $urls .= $items->url_pdf . "**";
        //     }
        // }
        $urls = NULL;
        if ($urls == NULL) {
            $urls = "vacio";
        }

        return view('portal.ver_instalacionesKyocera', compact('carga_selectSucursales','totalInstalaciones','proyectos', 'carga_selectProyectos', 'comuna', 'region', 'clientes', 'mostrarMenu', 'urls', 'instalaciones', 'carga_selectEstado', 'carga_selectClientes', 'carga_selectComuna', 'tecnico', 'carga_selectRegion', 'serie'));
    }
    public function filtros_instalacionKyocera_olf(request $request)
    {
        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sc = $request->sc;
        $proyectos = $request->proyectos;
        $mostrarMenu = "";

        if ($clientes == "IM OSORNO") {
            $clientes =  "MUNICIPALIDAD DE OSORNO";
        }

        if (($clientes != "" and  $region != "") || ($request->datepicker != "" and  $request->datepicker2 != "")) {
            $mostrarMenu = "si";
        } else {
            $mostrarMenu = "no";
        }
        /*  $usuario_empresas = 0; */

        //    and instalacions.proveedor_instalacion = "'.Auth::user()->nombre_proveedor.'" )');
        //$where  = "instalacions.sEstado_despacho != "."'"."estoesparapasarlosdemasparametros"."'";
        $where = "";
        $where  = $where . " and instalacions.proveedor_instalacion = " . "'" . Auth::user()->nombre_proveedor . "'";
        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $where = $where . " and instalacions.fecha_instalacion_coordinadora" . " BETWEEN " . "'" . $fecha . "'" . " and " . "'" . $fecha2 . "'";
        }
        if ($estado != "") {
            $where = $where . " and instalacions.sEstado_instalacion" . " = " . "'" . $estado . "'";
        }
        if ($clientes != "") {
            $where = $where . " and instalacions.sCliente = " . "'" . $clientes . "'";
        }
        if ($proyectos != "") {
            $where = $where . " and proyectos.id = " . "'" . $proyectos . "'";
        }
        if ($region != "") {
            $where = $where . " and  instalacions.sRegion  = " . "'" . $region . "'";
        }
        if ($comuna != "") {
            $where = $where . " and  instalacions.sComuna  = " . "'" . $comuna . "'";
        }

        if ($serie != "") {
            //$where = $where." and  instalacions.sSerie  = "."'".$serie."'";
            $consulta = DB::table('instalacions')
                ->where('instalacions.sSerie', '=', $serie)
                ->get();

            if (!empty($consulta[0]->sSerie)) {
                $where = $where . " and  instalacions.sSerie  = " . "'" . $serie . "'";
            } else {
                $where = $where . " and  instalacions.Csserie_remplazo  = " . "'" . $serie . "'";
            }
        }
        if ($sc != "") {
            $where = $where . " and  instalacions.sSC  = " . "'" . $sc . "'";
        }


        // $instalaciones = DB::select('select asignacion_instalacions.url_pdf,instalacions.sEstado_instalacion,instalacions.fecha_instalacion_coordinadora,instalacions.id,instalacions.dFecha_instalacion,instalacions.fecha_registrado,instalacions.sEstado_despacho
        // ,instalacions.sCliente,instalacions.sComuna,instalacions.sSerie,instalacions.sDireccion from asignacion_instalacions inner join  instalacions on asignacion_instalacions.lista_instalacion_id = instalacions.id where '.$where . " group by  instalacions.sSerie order by instalacions.dFecha_instalacion asc ");

        $instalaciones = DB::select('SELECT DISTINCT
        asignacion_instalacions.id,
        asignacion_instalacions.url_pdf,
        proyectos.nombre,
        instalacions.sEstado_instalacion,
        instalacions.fecha_instalacion_coordinadora,
        instalacions.id,
        instalacions.dFecha_instalacion,
        instalacions.fecha_registrado,
        instalacions.sEstado_despacho,
        instalacions.sCliente,
        instalacions.sRegion,
        instalacions.sComuna,
        instalacions.sSerie,
        instalacions.Csserie_remplazo,
        instalacions.Csserie_es,
        instalacions.sDireccion
    FROM
        instalacions
    INNER JOIN
        asignacion_instalacions
    ON
        asignacion_instalacions.lista_instalacion_id = instalacions.id
    INNER JOIN
        tracker
    ON
        tracker.id = instalacions.tracker_idtracker
    INNER JOIN
        proyectos
    ON
        proyectos.id = tracker.proyecto_id
    WHERE
        instalacions.id =(
        SELECT
            MAX(
                asignacion_instalacions.lista_instalacion_id
            )
        FROM
            asignacion_instalacions
        WHERE
            asignacion_instalacions.lista_instalacion_id = instalacions.id
        ) 
    AND 
        asignacion_instalacions.numero_visita=(
        SELECT
            MAX(
                asignacion_instalacions.numero_visita
            )
        FROM
            asignacion_instalacions
        WHERE
            asignacion_instalacions.lista_instalacion_id = instalacions.id
        ) 
    ' . " " . $where . 'ORDER BY instalacions.fecha_instalacion_coordinadora DESC');



        //Cargar Select Estado
        $carga_selectEstado = DB::table('instalacions')
            ->select('instalacions.sEstado_instalacion')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)

            ->orderBy('instalacions.sEstado_instalacion', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Clientes
        $carga_selectClientes = DB::table('instalacions')
            ->select('instalacions.sCliente')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)


            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('instalacions')
            ->select('instalacions.sRegion')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->where('sCliente', '=', $clientes)


            ->where('instalacions.sRegion', '!=', null)
            ->orderByRaw(DB::raw("FIELD(instalacions.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))
            ->distinct()
            ->get();

        //Cargar Select Comuna
        $carga_selectComuna = DB::table('instalacions')
            ->select('instalacions.sComuna')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->where('sRegion', '=', $region)

            ->orderBy('instalacions.sComuna', 'asc')
            ->distinct()
            ->get();

        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
            ->orderBy('personas.nombre_uno', 'asc')
            /* ->where("personas.id","=",$id_persona)   */
            ->distinct()
            ->get();

        $urls = "";

        $carga_selectProyectos = DB::table('proyectos')
            ->select('proyectos.id', 'proyectos.nombre')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('clientes.proveedor_nombre', '=', Auth::user()->nombre_proveedor)
            ->where('clientes.razon_social', '=', $clientes)
            ->get();


        foreach ($instalaciones as $items) {
            if ($items->url_pdf != NULL) {
                $urls .= $items->url_pdf . "**";
            }
        }

        if ($urls == NULL) {
            $urls = "vacio";
        }

        return view('portal.ver_instalacionesKyocera', compact('proyectos', 'carga_selectProyectos', 'comuna', 'region', 'clientes', 'mostrarMenu', 'urls', 'instalaciones', 'carga_selectEstado', 'carga_selectClientes', 'carga_selectComuna', 'tecnico', 'carga_selectRegion', 'serie'));
    }
    public function verInstalacionesKyocera()
    {
        $instalaciones = DB::table('instalacions')
            //  ->Join('asignacion_solicitudes','asignacion_solicitudes.api_solicitudes_id','=','api_solicitudes.id')
            ->select(
                "instalacions.sEstado_instalacion",
                "instalacions.fecha_instalacion_coordinadora",
                "instalacions.id",
                "instalacions.dFecha_instalacion",
                "instalacions.fecha_registrado",
                "instalacions.sEstado_despacho",
                "instalacions.sCliente",
                "instalacions.sRegion",
                "instalacions.sComuna",
                "instalacions.sSerie",
                "instalacions.Csserie_remplazo",
                "instalacions.Csserie_es",
                "instalacions.sDireccion",
                "instalacions.sSC",
                "instalacions.proveedor_instalacion",

                
                "proyectos.nombre",
            )
            ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->Join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->orderBy('instalacions.fecha_instalacion_coordinadora', 'DESC')
            ->Join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')->get();

                $totalInstalaciones = count($instalaciones);
        $carga_selectEstado = DB::table('instalacions')
            ->select('instalacions.sEstado_instalacion')
            ->orderBy('instalacions.sEstado_instalacion', 'asc')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->distinct()
            ->get();

        //Cargar Select Clientes
        $carga_selectClientes = DB::table('instalacions')
            ->select('instalacions.sCliente')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();

            $carga_selectSucursales = DB::table('instalacions')
            ->select('instalacions.sTipo_sucursal')
            ->orderBy('instalacions.sTipo_sucursal', 'asc')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->distinct()
            ->get();

        //Cargar Select Proyectos
        $carga_selectProyectos = DB::table('proyectos')
            ->select('proyectos.id', 'proyectos.nombre')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('clientes.proveedor_nombre', '=', Auth::user()->nombre_proveedor)
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('instalacions')
            ->select('instalacions.sRegion')
            ->where('instalacions.sRegion', '!=', null)
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->orderByRaw(DB::raw("FIELD(instalacions.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))
            ->distinct()
            ->get();

        //Cargar Select Comuna
        $carga_selectComuna = DB::table('instalacions')
            ->select('instalacions.sComuna')
            ->orderBy('instalacions.sComuna', 'asc')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->distinct()
            ->get();

        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
            ->orderBy('personas.nombre_uno', 'asc')
            ->distinct()
            ->get();
        /*  $usuario_empresas = 0;  */

        $urls = "sinfiltro";
        $clientes = "";
        $region = "";
        $comuna = "";
        $proyectos = "";
        $serie = "";

        return view('portal.ver_instalacionesKyocera', compact('carga_selectSucursales','totalInstalaciones','proyectos', 'carga_selectProyectos', 'comuna', 'serie', 'region', 'clientes', 'urls', 'instalaciones', 'carga_selectEstado', 'carga_selectClientes', 'carga_selectComuna', 'tecnico', 'carga_selectRegion'));
    }
    public function verInstalacionesKyocera_old()
    {


        $instalaciones = DB::select('SELECT DISTINCT
        asignacion_instalacions.id,
        asignacion_instalacions.url_pdf,
        proyectos.nombre,
        instalacions.sEstado_instalacion,
        instalacions.fecha_instalacion_coordinadora,
        instalacions.id,
        instalacions.dFecha_instalacion,
        instalacions.fecha_registrado,
        instalacions.sEstado_despacho,
        instalacions.sCliente,
        instalacions.sRegion,
        instalacions.sComuna,
        instalacions.sSerie,
        instalacions.Csserie_remplazo,
        instalacions.Csserie_es,
        instalacions.sDireccion
    FROM
        instalacions
    INNER JOIN
        asignacion_instalacions
    ON
        asignacion_instalacions.lista_instalacion_id = instalacions.id
    INNER JOIN
        tracker
    ON
        tracker.id = instalacions.tracker_idtracker
    INNER JOIN
        proyectos
    ON
        proyectos.id = tracker.proyecto_id
    WHERE
        instalacions.id =(
        SELECT
            MAX(
                asignacion_instalacions.lista_instalacion_id
            )
        FROM
            asignacion_instalacions
        WHERE
            asignacion_instalacions.lista_instalacion_id = instalacions.id
    ) AND asignacion_instalacions.numero_visita=(
    SELECT
        MAX(
            asignacion_instalacions.numero_visita
        )
    FROM
        asignacion_instalacions
    WHERE
        asignacion_instalacions.lista_instalacion_id = instalacions.id and instalacions.proveedor_instalacion = "' . Auth::user()->nombre_proveedor . '" )
    ORDER BY instalacions.fecha_instalacion_coordinadora DESC
    ');


        // $instalaciones =  DB::table('asignacion_instalacions')
        // ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')

        //     ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
        //     ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
        //     ->select('instalacions.id', 'instalacions.dFecha_instalacion','instalacions.fecha_registrado', 'instalacions.sEstado_despacho', 
        //     'instalacions.sCliente', 'instalacions.sComuna','asignacion_instalacions.url_pdf', 'instalacions.sSerie','instalacions.sDireccion','instalacions.fecha_registrado','instalacions.sEstado_instalacion','instalacions.fecha_instalacion_coordinadora')
        //     ->where("instalacions.sEstado_instalacion","<>","asignado")
        //     ->where("instalacions.sEstado_instalacion","<>","asignado")
        //     ->orderBy('instalacions.fecha_registrado', 'desc' )
        //     ->orderBy('instalacions.sComuna', 'desc')

        //     ->get();

        //Cargar Select Estado
        $carga_selectEstado = DB::table('instalacions')
            ->select('instalacions.sEstado_instalacion')
            ->orderBy('instalacions.sEstado_instalacion', 'asc')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->distinct()
            ->get();

        //Cargar Select Clientes
        $carga_selectClientes = DB::table('instalacions')
            ->select('instalacions.sCliente')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Proyectos
        $carga_selectProyectos = DB::table('proyectos')
            ->select('proyectos.id', 'proyectos.nombre')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('clientes.proveedor_nombre', '=', Auth::user()->nombre_proveedor)
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('instalacions')
            ->select('instalacions.sRegion')
            ->where('instalacions.sRegion', '!=', null)
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)

            ->orderByRaw(DB::raw("FIELD(instalacions.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))

            ->distinct()
            ->get();

        //Cargar Select Comuna
        $carga_selectComuna = DB::table('instalacions')
            ->select('instalacions.sComuna')
            ->orderBy('instalacions.sComuna', 'asc')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)

            ->distinct()
            ->get();



        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
            ->orderBy('personas.nombre_uno', 'asc')
            ->distinct()
            ->get();
        /*  $usuario_empresas = 0;  */



        $urls = "sinfiltro";
        $clientes = "";
        $region = "";
        $comuna = "";
        $proyectos = "";
        $serie = "";

        return view('portal.ver_instalacionesKyocera', compact('proyectos', 'carga_selectProyectos', 'comuna', 'serie', 'region', 'clientes', 'urls', 'instalaciones', 'carga_selectEstado', 'carga_selectClientes', 'carga_selectComuna', 'tecnico', 'carga_selectRegion'));
    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }




    //ver pdf's
    public function ir_pdfs_generados()
    {
        /*FILTROS PDF'S INSTALACION */
        //Cargar Select proyectos
        /* $proyectos = DB::table('proyectos')
        ->join('clientes','clientes.id','=','proyectos.clientes_id')
        ->where('proyectos.estado','=','1')
        ->where('proyectos.id','!=','1')
        ->select('proyectos.nombre','clientes.razon_social','proyectos.id as id_proyecto')
        ->orderBy('proyectos.id', 'asc')
        ->get(); */

        //Cargar Select clientes
        $carga_selectClientes = DB::table('asignacion_instalacions')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select('instalacions.sCliente')
            ->where('asignacion_instalacions.url_pdf', '!=', "null")
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->orderBy('instalacions.sCliente', 'asc')
            ->distinct()
            ->get();

        //Cargar Select regiones
        $regiones = DB::table('asignacion_instalacions')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select('instalacions.sRegion')
            ->where('asignacion_instalacions.url_pdf', '!=', "null")
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->orderBy('instalacions.sRegion', 'asc')
            ->distinct()
            ->get();


        //Cargar Select Comuna
        $comunas = DB::table('asignacion_instalacions')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select('instalacions.sComuna')
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->where('asignacion_instalacions.url_pdf', '!=', "null")
            ->orderBy('instalacions.sComuna', 'asc')
            ->distinct()
            ->get();

        //Cargar Select Direccion
        $direccion = DB::table('asignacion_instalacions')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select('instalacions.sDireccion')
            ->where('asignacion_instalacions.url_pdf', '!=', "null")
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->orderBy('instalacions.sDireccion', 'asc')
            ->distinct()
            ->get();




        //creamos el metodo para traer a todas las asignaciones con ruta pdf
        $rutapdf = DB::table('asignacion_instalacions')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->select(
                'asignacion_instalacions.id',
                'asignacion_instalacions.url_pdf',
                'asignacion_instalacions.fecha_instalacion',
                'instalacions.sRegion',
                'instalacions.sCliente',
                'instalacions.sComuna',
                'instalacions.sSerie',
                'instalacions.sDireccion',
                'instalacions.sCui'
            )
            ->where('proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            //->where('asignacion_instalacions.url_pdf','!=',"null")
            ->orderBy('asignacion_instalacions.fecha_instalacion', 'desc')
            ->get();



        return view('portal.pdfs_instalacion', compact('carga_selectClientes', 'regiones', 'comunas', 'direccion', 'rutapdf'));
    }

    //funcion para descargar los pdf asociados a un id de asignacion
    public function getDownload($url_pdf)
    {
        $porciones = explode("mitad", $url_pdf);
        $url = $porciones[0]; //mitadporción1
        $serie = $porciones[1]; // porción2



        $file = storage_path('app/public/pdfinstalacion/') . $url;

        return response()->download($file, $serie . ".pdf");
    }

    public function excel_instalacion($url)
    {
        try {
            $url = Crypt::decryptString($url);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        $buscando = strpos($url, "/filtrosinstalacion?");

        if ($buscando === false) {
            $resultado = str_replace("/verinstalaciones", "/proveesinstalacionexport?", $url);
            //return "sinfiltro";
        } else {
            $resultado = str_replace("/filtrosinstalacion?", "/filtrosinstalacionexport?", $url);
            //return "confiltro";
        }
        return redirect($resultado);
    }

    public function excel_instalacion_check($url)
    {

        // return "hola";
        try {
            $url = Crypt::decryptString($url);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }


   
        $buscando = strpos($url, "/filtrosinstalacion?");


        if ($buscando === false) {
            $resultado = str_replace("/verinstalaciones", "/proveesinstalacionexportcheck?", $url);
            //return "sinfiltro";
        } else {
            $resultado = str_replace("/filtrosinstalacion?", "/filtroproveesinstalacionexportcheck?", $url);
            //return "confiltro";
            // return "llueguee";
        }
        return redirect($resultado);
    }
    public function filtroproveesinstalacionExport_check(request $request)
    {
        
        $comuna = $request->comuna;
        $estado = $request->estado;
        $proyecto = $request->proyectos;
        $region = $request->region;
        $serie = $request->serie;
        $sc = $request->sc;
        $clientes =  $request->clientes;


        $rutapdf = DB::table('instalacions')
        ->leftjoin('asignacion_instalacions','asignacion_instalacions.lista_instalacion_id','=','instalacions.id')
        ->Join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
        ->Join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
        ->select(
            
            "instalacions.sEstado_instalacion",
            "instalacions.fecha_instalacion_coordinadora",
            "instalacions.id",
            "instalacions.dFecha_instalacion",
            "instalacions.fecha_registrado",
            "instalacions.sEstado_despacho",
            "instalacions.sCliente",
            "instalacions.sRegion",
            "instalacions.sComuna",
            "instalacions.sSerie",
            "instalacions.Csserie_remplazo",
            "instalacions.Csserie_es",
            "instalacions.sDireccion",
            "proyectos.nombre",
        )
        ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
        // ->Join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
        ->orderBy('instalacions.fecha_instalacion_coordinadora', 'DESC');
        
        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $rutapdf->whereBetween('instalacions.fecha_instalacion_coordinadora', [$fecha, $fecha2]);
        }
        if ($estado != "") {
            $rutapdf->where("instalacions.sEstado_instalacion", "=", $estado);
        }
        if ($clientes != "") {
            $rutapdf->where("instalacions.sCliente", "=", $clientes);
        }
        if ($proyecto != "") {
            $rutapdf->where("proyectos.id", "=", $proyecto);
        }
        if ($region != "") {
            $rutapdf->where("instalacions.sRegion", "=", $region);
        }
        if ($comuna != "") {
            $rutapdf->where("instalacions.sComuna", "=", $comuna);
        }
        if ($serie != "") {
            //$where = $where." and  instalacions.sSerie  = "."'".$serie."'";
            $consulta = DB::table('instalacions')
                ->where('instalacions.sSerie', '=', $serie)
                ->get();

            if (!empty($consulta[0]->sSerie)) {
                $rutapdf->where("instalacions.sSerie", "=", $serie);
            } else {
                $rutapdf->where("instalacions.Csserie_remplazo", "=", $serie);
            }
        }
        if ($sc != "") {
            $rutapdf->where("instalacions.sSC", "=", $sc);
        }
        $rutapdf->orderBy('instalacions.fecha_instalacion_coordinadora', 'DESC');
        $rutapdf = $rutapdf->get();

        
        return view('portal.excel.excel_instalacion', compact('rutapdf'));

    }
    public function proveesinstalacionExport_check(request $request)
    {
        // return "wenaa";

        $rutapdf = DB::table('instalacions')
        ->leftjoin('asignacion_instalacions','asignacion_instalacions.lista_instalacion_id','=','instalacions.id')
        ->Join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
        ->Join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
        ->select(
            
            "instalacions.sEstado_instalacion",
            "instalacions.fecha_instalacion_coordinadora",
            "instalacions.id",
            "instalacions.dFecha_instalacion",
            "instalacions.fecha_registrado",
            "instalacions.sEstado_despacho",
            "instalacions.sCliente",
            "instalacions.sRegion",
            "instalacions.sComuna",
            "instalacions.sSerie",
            "instalacions.Csserie_remplazo",
            "instalacions.Csserie_es",
            "instalacions.sDireccion",
            "proyectos.nombre",
        )
        ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
        // ->Join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
        ->orderBy('instalacions.fecha_instalacion_coordinadora', 'DESC')
        ->get();

        
        return view('portal.excel.excel_instalacion', compact('rutapdf'));

    }

    public function proveesinstalacionexport(request $request)
    {

        $rutapdf = DB::table('instalacions')
        //  ->Join('asignacion_solicitudes','asignacion_solicitudes.api_solicitudes_id','=','api_solicitudes.id')
        ->select(
            "instalacions.sEstado_instalacion",
            "instalacions.fecha_instalacion_coordinadora",
            "instalacions.id",
            "instalacions.dFecha_instalacion",
            "instalacions.fecha_registrado",
            "instalacions.sEstado_despacho",
            "instalacions.sCliente",
            "instalacions.sRegion",
            "instalacions.sComuna",
            "instalacions.sSerie",
            "instalacions.Csserie_remplazo",
            "instalacions.Csserie_es",
            "instalacions.sDireccion",
            "instalacions.sSC",

            
            "proyectos.nombre",
        )
        ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
        ->Join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
        ->orderBy('instalacions.fecha_instalacion_coordinadora', 'DESC')
        ->Join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')->get();

        
        return view('portal.excel.excel_instalacion', compact('rutapdf'));

    }



    public function filtrosinstalacionExport(request $request)
    {
      
        $comuna = $request->comuna;
        $estado = $request->estado;
        $proyecto = $request->proyectos;
        $region = $request->region;
        $serie = $request->serie;
        $sc = $request->sc;
        $clientes =  $request->clientes;


         $rutapdf = DB::table('instalacions')
        //  ->Join('asignacion_solicitudes','asignacion_solicitudes.api_solicitudes_id','=','api_solicitudes.id')
        ->select(
            
            "instalacions.sEstado_instalacion",
            "instalacions.fecha_instalacion_coordinadora",
            "instalacions.id",
            "instalacions.dFecha_instalacion",
            "instalacions.fecha_registrado",
            "instalacions.sEstado_despacho",
            "instalacions.sCliente",
            "instalacions.sRegion",
            "instalacions.sComuna",
            "instalacions.sSerie",
            "instalacions.Csserie_remplazo",
            "instalacions.Csserie_es",
            "instalacions.sDireccion",
            "proyectos.nombre",
            'instalacions.area',
            'instalacions.modelo48dn',
            'instalacions.selectnubeprint',
            'instalacions.selectmonitowe',
            
        )
        ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
        ->Join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
        ->orderBy('instalacions.fecha_instalacion_coordinadora', 'DESC')
        ->Join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id');

        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $rutapdf->whereBetween('instalacions.fecha_instalacion_coordinadora', [$fecha, $fecha2]);
        }
        if ($estado != "") {
            $rutapdf->where("instalacions.sEstado_instalacion", "=", $estado);
        }
        if ($clientes != "") {
            $rutapdf->where("instalacions.sCliente", "=", $clientes);
        }
        if ($proyecto != "") {
            $rutapdf->where("proyectos.id", "=", $proyecto);
        }
        if ($region != "") {
            $rutapdf->where("instalacions.sRegion", "=", $region);
        }
        if ($comuna != "") {
            $rutapdf->where("instalacions.sComuna", "=", $comuna);
        }
        if ($serie != "") {
            //$where = $where." and  instalacions.sSerie  = "."'".$serie."'";
            $consulta = DB::table('instalacions')
                ->where('instalacions.sSerie', '=', $serie)
                ->get();

            if (!empty($consulta[0]->sSerie)) {
                $rutapdf->where("instalacions.sSerie", "=", $serie);
            } else {
                $rutapdf->where("instalacions.Csserie_remplazo", "=", $serie);
            }
        }
        if ($sc != "") {
            $rutapdf->where("instalacions.sSC", "=", $sc);
        }
        $rutapdf->orderBy('instalacions.fecha_instalacion_coordinadora', 'DESC');
        $rutapdf = $rutapdf->get();
        return view('portal.excel.excel_instalacion', compact('rutapdf'));

    }
    public function filtrosinstalacionExport_old(request $request)
    {

        return "h";
        // return $request;
        $clientes =  $request->clientes;



        $comuna = $request->comuna;
        $estado = $request->estado;
        $proyecto = $request->proyectos;
        $region = $request->region;
        $serie = $request->serie;
        $sc = $request->sc;

        if ($clientes == "" &&  $estado == ""  &&  $proyecto == "" &&  $region == "" &&  $comuna == ""  && $serie == "" &&  $sc == "" &&  $request->datepicker == "" && $request->datepicker2 == "") {

          

            $rutapdf = DB::table('instalacions')
            ->leftjoin('asignacion_instalacions','asignacion_instalacions.lista_instalacion_id','=','instalacions.id')
            ->Join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->Join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->select(
                "instalacions.sEstado_instalacion",
                "instalacions.fecha_instalacion_coordinadora",
                "instalacions.id",
                "instalacions.dFecha_instalacion",
                "instalacions.fecha_registrado",
                "instalacions.sEstado_despacho",
                "instalacions.sCliente",
                "instalacions.sRegion",
                "instalacions.sComuna",
                "instalacions.sSerie",
                "instalacions.Csserie_remplazo",
                "instalacions.Csserie_es",
                "instalacions.sDireccion",
                "instalacions.sCui",
                "proyectos.nombre",
                "asignacion_instalacions.id as id_asig",
                "asignacion_instalacions.url_pdf",
            )
            ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->where("tracker.tipo_tracker", "=", "instalacion")
            ->get();
            // return "entrerr";
        }else{
            $rutapdf =DB::table('instalacions')
            ->leftjoin('asignacion_instalacions','asignacion_instalacions.lista_instalacion_id','=','instalacions.id')
            ->Join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->Join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->select(
                "instalacions.sEstado_instalacion",
                "instalacions.fecha_instalacion_coordinadora",
                "instalacions.id",
                "instalacions.dFecha_instalacion",
                "instalacions.fecha_registrado",
                "instalacions.sEstado_despacho",
                "instalacions.sCliente",
                "instalacions.sRegion",
                "instalacions.sComuna",
                "instalacions.sSerie",
                "instalacions.Csserie_remplazo",
                "instalacions.Csserie_es",
                "instalacions.sDireccion",
                "instalacions.sCui",
                "proyectos.nombre",
                "asignacion_instalacions.id as id_asig",
                "asignacion_instalacions.url_pdf",
            )
            ->where('instalacions.proveedor_instalacion', '=', Auth::user()->nombre_proveedor)
            ->where("tracker.tipo_tracker", "=", "instalacion");
            if ($request->datepicker != "" && $request->datepicker2 != "") {
                $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
                $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
                $rutapdf->whereBetween('instalacions.fecha_instalacion_coordinadora', [$fecha, $fecha2]);
            }
            if ($estado != "") {
                $rutapdf->where("instalacions.sEstado_instalacion", "=", $estado);
            }
            if ($clientes != "") {
                $rutapdf->where("instalacions.sCliente", "=", $clientes);
            }
            if ($proyecto != "") {
                $rutapdf->where("proyectos.id", "=", $proyecto);
            }
            if ($region != "") {
                $rutapdf->where("instalacions.sRegion", "=", $region);
            }
            if ($comuna != "") {
                $rutapdf->where("instalacions.sComuna", "=", $comuna);
            }
            if ($serie != "") {
                //$where = $where." and  instalacions.sSerie  = "."'".$serie."'";
                $consulta = DB::table('instalacions')
                    ->where('instalacions.sSerie', '=', $serie)
                    ->get();
    
                if (!empty($consulta[0]->sSerie)) {
                    $rutapdf->where("instalacions.sSerie", "=", $serie);
                } else {
                    $rutapdf->where("instalacions.Csserie_remplazo", "=", $serie);
                }
            }
            if ($sc != "") {
                $rutapdf->where("instalacions.sSC", "=", $sc);
            }
            $rutapdf->orderBy('instalacions.fecha_instalacion_coordinadora', 'DESC');
            $rutapdf = $rutapdf->get();
            //return $rutapdf;
        }
        
        // return $rutapdf;Z
        return view('portal.excel.excel_instalacion', compact('rutapdf'));
    }

    public function getallDownload($url_pdf)
    {

        if ($url_pdf == "sinfiltro") {

            $urlpdf = "";

            $pdfs = DB::table('asignacion_instalacions')
                ->select('url_pdf')
                ->where('url_pdf', '!=', 'null')
                ->orderBy('id')
                ->get();

            $zipname = 'pdfsintalacions.zip';
            $zip = new \ZipArchive;
            $zip->open($zipname, \ZipArchive::CREATE);

            foreach ($pdfs as $item) {
                $urlpdf = $item->url_pdf;
                $allfileinstalacion = $urlpdf;
                $zip->addFile(storage_path('app/public/pdfinstalacion/') . $allfileinstalacion, $allfileinstalacion);
            }

            $zip->close();
            return response()->download($zipname)->deleteFileAfterSend(true);
        } elseif ($url_pdf == "vacio") {

            return redirect()->route('go.verinstalacionesKyocera');
        } else {
            $unificarUrls  = "";
            $urlpdfs = "";

            $unificarUrls  = explode("**", $url_pdf);
            $total_urls  =  count($unificarUrls);

            $zipname = 'pdfsinstalacionfiltros.zip';
            $zip = new \ZipArchive;
            $zip->open($zipname, \ZipArchive::CREATE);
            //$dir = 'miDirectorio';
            //$zip->addEmptyDir($dir);

            for ($i = 0; $i < $total_urls; $i++) {

                if ($unificarUrls[$i] != "") {

                    $urlpdfs = $unificarUrls[$i];

                    $allfileinstalacion = $urlpdfs;

                    $zip->addFile(storage_path('app/public/pdfinstalacion/') . $allfileinstalacion, $allfileinstalacion);
                    //echo $unificarUrls[$i]."<br>";

                }
            }
            $zip->close();
            return response()->download($zipname)->deleteFileAfterSend(true);
        }
    }
}
