@extends('menu/menu')
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>
@section('content')

<div class="container mt-5">
  <div class="title-vista mt-4">RESUMEN DE RETIROS</div>
</div>

<form action="{{route('filtros_historial_retiro')}}" method="GET">
  <div class="container mt-5">
    <div class="seccion-filtro">Firltrar por</div> 
    <hr class="separador">

    <div class="row">
      <!--AQUI SE CARGA EL SELECT DEL CLIENTE-->
      <div class="col-sm-3 form-group">
        <label for="clientes">Cliente</label>
        <select name="clientes"  class="custom-select mayuscula" id="clientes">
          <option selected >Seleccionar</option>
          @foreach ($carga_selectCliente as $clientesDatos)
            @if ($clientesDatos->nombre != null) 
              @if($clientesDatos->id == $clientes) 
                <option selected value="{{$clientesDatos->id}}">{{ucfirst(strtolower($clientesDatos->nombre))}}</option>
              @else
                <option value="{{$clientesDatos->id}}">{{ucfirst(strtolower($clientesDatos->nombre))}}</option>
              @endif
            @endif
          @endforeach
        </select>     
      </div>
      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-3 form-group">
        <label for="comuna">Comuna</label>
        @if(!empty($disable))
        <select name="comuna" class="custom-select mayuscula" id="comuna">
        @else 
        <select name="comuna" disabled class="custom-select" id="comuna">
        @endif
          <option selected disabled>Seleccionar</option>
          <option selected  value ="" >Todos</option>
          @foreach ($carga_selectComuna as $comunasDatos)
            @if ($comunasDatos->comuna != null) 
              @if($comunasDatos->comuna == $comuna) 
                <option selected value="{{$comunasDatos->comuna}}">{{ucfirst(strtolower($comunasDatos->comuna))}}</option>
              @else
                <option value="{{$comunasDatos->comuna}}">{{ucfirst(strtolower($comunasDatos->comuna))}}</option>
              @endif
            @endif
          @endforeach
        </select>      
      </div>
      <!--AQUI SE CARGA EL SELECT DIRECCION-->
      <div class="col-sm-3 form-group">
        <label for="direccion">Dirección</label>
        @if(!empty($disable))
        <select name="direccion" class="custom-select mayuscula" id="direccion">
        @else 
        <select name="direccion" disabled class="custom-select" id="direccion">
        @endif
          <option selected disabled>Seleccionar</option>
          <option selected  value ="">Todos</option>
          @foreach ($carga_selectDireccion as $direcciones)
            @if ($direcciones->direccion != null) 
              @if($direcciones->direccion == $direccion) 
                <option selected value="{{$direcciones->direccion}}">{{ucfirst(strtolower($direcciones->direccion))}}</option>
              @else
                <option value="{{$direcciones->direccion}}">{{ucfirst(strtolower($direcciones->direccion))}}</option>
              @endif
            @endif
          @endforeach
        </select>
      </div>
      <div class="col-sm-3 form-group">
        <label for="cuisucursal">CUI</label>
        @if(!empty($disable))
        <select name="cuisucursal" class="custom-select mayuscula" id="cuisucursal">
        @else 
        <select name="cuisucursal" disabled class="custom-select" id="cuisucursal">
        @endif                                                        
          <option selected disabled>Seleccionar</option>
          <option selected  value ="">Todos</option>
          @foreach ($carga_selectSucursal as $sucursales)
            @if ($sucursales->cuisucursal != null) 
              @if($sucursales->cuisucursal == $cuisucursal) 
                <option selected value="{{$sucursales->cuisucursal}}">{{ucfirst(strtolower($sucursales->cuisucursal))}}</option>
              @else
                <option  value="{{$sucursales->cuisucursal}}">{{ucfirst(strtolower($sucursales->cuisucursal))}}</option>
              @endif
            @endif
          @endforeach
        </select>
      </div>
    </div>
  </div>

  {{-- BOTON BUSCAR --}}
  <div class="text-center mb-5 mt-5">
    <button type="buscar" class="btn btn-pill btn-prim w-25">Buscar</button>  
  </div>
</form>

{{          session(['url_retiro' => url()->full()])     }}

<div class="container mt-5">
  {{-- EXPORTAR --}}
  <ul class="nav bg-export">
    <li class="clas-item">
      <a class="btn btn-ter" target="_blank" href="{{route('ir_vista_excel_historial',Crypt::encryptString(url()->full()))}})}}">
        Exportar excel
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-excel-fill" viewBox="0 0 16 16">
          <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM5.884 6.68 8 9.219l2.116-2.54a.5.5 0 1 1 .768.641L8.651 10l2.233 2.68a.5.5 0 0 1-.768.64L8 10.781l-2.116 2.54a.5.5 0 0 1-.768-.641L7.349 10 5.116 7.32a.5.5 0 1 1 .768-.64z"/>
        </svg>
      </a>
    </li>
  </ul>
</div>

{{-- TABLA DE RESULTADOS --}}
<div class="container table-responsive mb-5">
  <table class="table table-striped table-hover" id="mitable">
    <!-- ENCABEZADO -->
    <thead class="color-head">
      <tr>
        <th class="th-head border-th separador-v" colspan="1">Fecha de resumen</th>
        <th class="th-head border-th separador-v" colspan="1">Equipos embalados</th>
        <th class="th-head border-th separador-v" colspan="1">Equipos sin embalados</th>
        <th class="th-head border-th separador-v" colspan="1">Cantidad de bultos</th>
        <th class="th-head border-th separador-v" colspan="1">Cliente</th>
        <th class="th-head border-th separador-v" colspan="1">Comuna</th>
        <th class="th-head border-th separador-v" colspan="1">Dirección</th>
        <th class="th-head border-th separador-v" colspan="1">CUI</th>
        <th class="th-head border-th separador-v" colspan="1">Comentario </th>
        <th class="th-head border-th"><span class="material-icons">
          settings
          </span></th>
      </tr>
    </thead>
    <!-- FIN ENCABEZADO -->
    <!-- RESULTADOS -->
    @if(!empty($datosretiro))
    @foreach ($datosretiro   as $los_datos)
    <tr>
      <td>
        {{Carbon\Carbon::createFromDate($los_datos->fecha_resumen)->format('d-m-Y')}}
      </td>
      <td>{{$los_datos->suma_embalados}}</td>
      <td>{{$los_datos->suma_sinembalar}}</td>
      <td>{{$los_datos->cantidad_bultos}}</td>
      <td>{{$los_datos->cliente}}</td>
      <td>{{$los_datos->comuna}}</td>
      <td>{{$los_datos->direccion}}</td>
      <td>{{$los_datos->cuisucursal}}</td>
      <td>{{$los_datos->descripcion_motivo}}</td>                      
      <td class="td-val">
        <div class="dropdown dropleft" style="text-align: center;">
          <button type="button" class="btn-dropdown" data-toggle="dropdown">
            <span class="material-icons">more_vert</span>
          </button>
          <div class="dropdown-menu mostrar shadow">
            <div class="d-flex justify-content-around">
          <form target="_blank" action="{{route ('go.verdatosresumenretiro_coordinadora')}}" method="GET" style="margin-bottom: 0;">
           <!--{{$los_datos->id}}-->
            <button type="submit" style="border:0px;border-color:transparent;background-color:transparent;">
              <input type="text" style="display:none "  id="check" value="{{$los_datos->id}}" name="check">
              <a href="" role="button" class="btn-icon btn-icon-dd ver_historial" title="Ver Resumen"><span class="material-icons">visibility</span></a>
            </button>
          </form>
        </div>
          </div>
        </div>
      </td>
    </tr>
    @endforeach
    @endif
  </table>
</div>







  <script>


    
    
      
$(document).ready(function(){

  $("#clientes").change(function(){      
    cliente = $('select[id=clientes]').val();
    var _token = $('input[name="_token"]').val(); 
    $.ajax({
      method:"POST",
      url:"{{ route('comunasResumentesRetiros') }}",
      data: {  _token:_token,'cliente':cliente},
      success: function(data) {
        console.log(data);
        $("#comuna").empty();
        $("#direccion").empty();
        $("#cuisucursal").empty();      
        $("#comuna").append('<option value="">Seleccionar</option>');
        $("#direccion").append('<option value="">Seleccionar</option>');
        $("#cuisucursal").append('<option value="">Seleccionar</option>');   
        $(data).each(function(i, v){ // indice, valor
        //if(v.sComuna != null || v.sComuna != "null"  ){ 
          $("#comuna").append('<option value="' + v.comuna + '">' + v.comuna + '</option>');
        })
        // }
        $('#comuna').prop('disabled', false);
      },
      error: function(xhr, status) {
        alert('Disculpe, ha ocurrido un problema, intente mas tarde');
      }
    });
  });

  $("#comuna").change(function(){
    comuna = $('select[id=comuna]').val();
    var _token = $('input[name="_token"]').val();
    $.ajax({
      method:"POST",
      url:"{{ route('direccionesResumentesRetiros') }}",
      data: { 'comuna': comuna,  _token:_token, 'cliente':$("#clientes").val()},
      success: function(data) {
        $("#direccion").empty();
        $("#cuisucursal").empty();
        $("#direccion").append('<option value="">Seleccionar</option>');
        $("#cuisucursal").append('<option value="">Seleccionar</option>');
        $(data).each(function(i, v){ // indice, valor
        //if(v.sdireccion != null || v.sdireccion != "null"  ){ 
          $("#direccion").append('<option value="' + v.direccion + '">' + v.direccion + '</option>');
        })
        // }
        $('#direccion').prop('disabled', false);
      },            
      error: function(xhr, status) {
        alert('Disculpe, ha ocurrido un problema, intente mas tarde');
      }
    });
  });

  $("#direccion").change(function(){
    direccion = $('select[id=direccion]').val();
    var _token = $('input[name="_token"]').val();
    $.ajax({
      method:"POST",
      url:"{{ route('sucursalessResumentesRetiros') }}",
      data: { 'direccion': direccion,  _token:_token, 'cliente':$("#clientes").val()},
      success: function(data) {
        $("#cuisucursal").empty();
        $("#cuisucursal").append('<option value="">Seleccionar</option>');
        $(data).each(function(i, v){ // indice, valor
          //if(v.ssucursal != null || v.ssucursal != "null"  ){ 
          $("#cuisucursal").append('<option value="' + v.cuisucursal + '">' + v.cuisucursal + '</option>');
        })
        // }
        $('#cuisucursal').prop('disabled', false);
      },             
      error: function(xhr, status) {
        alert('Disculpe, ha ocurrido un problema, intente mas tarde');
      }
    });
  });
});
  </script>


<!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
<!-- <script src="./Untitled Document_files/jquery-3.4.1.min.js.descarga"></script> -->

<!-- Include all compiled plugins (below), or include individual files as needed -->
<!-- <script src="./Untitled Document_files/popper.min.js.descarga"></script>
<script src="./Untitled Document_files/bootstrap-4.4.1.js.descarga"></script> -->
@endsection
