<script src="<?php echo e(asset('js/jquery-3.4.1.min.js')); ?>"></script>
<?php $__env->startSection('content'); ?>
<?php if( session('mensaje_error') ): ?>
<div class="alert alert-danger"><?php echo e(session('mensaje_error')); ?></div>
<?php endif; ?>
<div class="container mt-5">
  <div class="title-vista mt-4">Usuarios registrados</div>
</div>
<div class="container mb-5">
  <form action="<?php echo e(route('filtro_see_trabajador')); ?>" method="GET">

    <div class="row">
      <div class="col-md-6 form-group w-50 mx-auto">
        <label for="">Nombre trabajador</label>
        <input type="text" name="nombre_trabajador" value="<?php echo e(@old('nombre_trabajador')); ?>" class="form-control mayuscula" id="nombre_trabajador" placeholder="...">
      </div>
      <div class="col-sm-12 text-center ">
        <button class="btn btn-prim w-25" type="submit">
          <?php if($opcion != "1"): ?>
          Buscar
          <?php else: ?>
          Todos
          <?php endif; ?>
        </button>
      </div>
    </div>
  </form>
</div>


<div class="container table-responsive mb-5">
  <div class="">
    <table class="table table-striped table-hover">

      <thead class="color-head">
        <tr>
          <th class="th-head border-th separador-v" colspan="3">Datos personales</th>
          <th class="th-head border-th separador-v" colspan="2">Billetera virtual</th>
          <th class="th-head border-th separador-v" colspan="1">Administrar cuenta bancaria</th>
          <th class="th-head border-th" colspan="1">
            <span class="material-icons">settings</span>
          </th>
        </tr>

        <tr>
          <th class="th-subhead border-th">Nombre</th>
          <th class="th-subhead border-th">Teléfonos</th>
          <th class="th-subhead border-th separador-v">Correos</th>
          <th class="th-subhead border-th">Cuenta</th>
          <th class="th-subhead border-th separador-v">F. Actualizado</th>
          <th class="th-subhead border-th separador-v">Total Billetera</th>
          <th class="th-subhead border-th"></th>
        </tr>

      </thead>

      <tbody>
        <?php $__currentLoopData = $trabajadores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $los_datos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
          <td class="td-val"><?php echo e($los_datos->nombre_uno); ?> <?php echo e($los_datos->apellido_uno); ?> <?php echo e($los_datos->apellido_dos); ?></td>
          <td class="td-val"><?php echo e($los_datos->telefono1); ?> - <?php echo e($los_datos->telefono2); ?></td>
          <td class="td-val"><?php echo e($los_datos->correo1); ?> - <?php echo e($los_datos->correo2); ?></td>
          <td class="td-val">$<?php echo e(number_format($los_datos->total_acumulado,0,',','.')); ?> <br> $<?php echo e(number_format($los_datos->total_gastos,0,',','.')); ?></td>
          <td class="td-val"><?php echo e(Carbon\Carbon::createFromDate($los_datos->fecha_actualizado_acumulado ?? '')->format('d-m-Y')); ?> <br> <?php echo e(Carbon\Carbon::createFromDate($los_datos->fecha_actualizado_gasto ?? '')->format('d-m-Y')); ?></td>

          <td class="td-val">
            <span class="v-left">$<?php echo e(number_format($los_datos->total_acumulado -  $los_datos->total_gastos,0,',','.')); ?></span>
            <span class="v-right">
              <a class="billetera_modal btn-icon btn-icon-dd" data-id_trabajador="<?php echo e($los_datos->id_trabajador); ?>">
                <span class="material-icons-round">edit</span>
              </a>
            </span>
          </td>

          <td class="td-val">
            <form>
              <div class="dropdown dropleft" style="text-align: center;">
                <button type="button" data-toggle="dropdown" class="btn-dropdown">
                  <span class="material-icons">more_vert</span>
                </button>
                <div class="dropdown-menu mostrar shadow">
                  <div class="d-flex justify-content-around">
                    <a title="Editar" class="btn-icon btn-icon-dd editar_cliente" href="<?php echo e(route('update.trabajador',$los_datos->id_trabajador)); ?>">
                      <span class="material-icons">edit</span>
                    </a>
                    <a title="Agregar" class="show-modal-versucursales btn-icon btn-icon-dd" href="<?php echo e(route('go.add_suc_trabajador',$los_datos->id_trabajador)); ?>">
                      <span class="material-icons-round">add_circle</span>
                    </a>
                    <a title="Eliminar" class="btn-icon btn-icon-dd" href="<?php echo e(route('eliminar.trabajador',$los_datos->id_trabajador)); ?>" onclick="return confirm('¿Desea eliminar el registro?')">
                      <span class="material-icons">delete</span>
                    </a>
                  </div>
                </div>
              </div>
            </form>
          </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </tbody>
    </table>
  </div>
</div>



<div class="container">
  <div class="d-flex justify-content-center">
    <?php if(!empty($trabajadores)): ?>
    <?php echo e($trabajadores->appends(request()->query())->links()); ?>

    <?php endif; ?>
  </div>
</div>





<!-- Modal -->
<div class="modal fade" id="modal_banco" role="dialog">
  <div class="modal-dialog modal-lg">
    <div class="modal-content pb-4">

      <div class="modal-header">
        <div class="seccion-modal">Agregar cuenta</div>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador ml-4 mr-4">

      <div class="modal-body">
        <div class="container">

          
          <div class="text-center mb-5">
            <button class="agregar btn btn-prim w-25">Agregar cuenta</button>
          </div>
          <div style="display:none" id="ocultar_agrega">
            <form action="<?php echo e(route('create.mi_cuenta')); ?>" method="POST">
              <?php echo csrf_field(); ?>
              <div class="row">
                <div class="col-sm-4 form-group">
                  <label for="">Bancos</label>
                  <select class="form-control mayuscula" name="bancos" id="sucursal_bancos">
                    <option value="">Seleccionar</option>
                    <?php if($bancos == "" ): ?>

                    <?php else: ?>
                    <?php $__currentLoopData = $bancos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banco): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($banco->id); ?>" <?php echo e((old('region')==$banco->id)? 'selected':''); ?>><?php echo e($banco->nombre_banco); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                  </select>
                  <?php $__errorArgs = ['bancos'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                  <div class="alert alert-danger"><?php echo e($message); ?></div>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <input style="display:none" type="text" name="id_trabajador" id="id_trabajador" value="">

                <div class="col-sm-4 form-group">
                  <label for="tipo_cuenta" class="">Tipo cuenta</label>
                  <select class="form-control mayuscula" name="tipo_cuenta" id="tipo_cuentas">
                    <?php $__currentLoopData = $tipos_cuentas_bancos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo_cuenta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($tipo_cuenta->id); ?>" <?php echo e((old('region')==$tipo_cuenta->id)? 'selected':''); ?>><?php echo e($tipo_cuenta->tipo_cuenta); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                  <?php $__errorArgs = ['tipo_cuenta'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                  <div class="alert alert-danger"><?php echo e($message); ?></div>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="col-sm-4 form-group">
                  <label for="numero_cuenta" class="">Número cuenta</label>
                  <input type="text" class="form-control mayuscula" value="<?php echo e(@old('numero_cuenta')); ?>" name="numero_cuenta" id="numero_cuenta" placeholder="Número Cuenta">
                  <?php $__errorArgs = ['numero_cuenta'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                  <div class="alert alert-danger"><?php echo e($message); ?></div>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
              </div>

              <div class="row">
                <div class="col-sm-4 form-group">
                  <label for="nombre_cliente" class="">Nombre (dueño cuenta)</label>
                  <input type="text" class="form-control mayuscula" value="<?php echo e(@old('nombre_cliente')); ?>" name="nombre_cliente" id="nombre_cliente" placeholder="Nombre">
                  <?php $__errorArgs = ['nombre_cliente'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                  <div class="alert alert-danger"><?php echo e($message); ?></div>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="col-sm-4 form-group">
                  <label for="apellido_cliente" class="">Apellido (dueño cuenta)</label>
                  <input type="text" class="form-control mayuscula" value="<?php echo e(@old('apellido_cliente')); ?>" name="apellido_cliente" id="apellido_cliente" placeholder="Apellido">
                  <?php $__errorArgs = ['apellido_cliente'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                  <div class="alert alert-danger"><?php echo e($message); ?></div>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="col-sm-4 form-group">
                  <label for="correo_bancario" class="">Correo bancario</label>
                  <input type="email" class="form-control mayuscula" value="<?php echo e(@old('correo_bancario')); ?>" name="correo_bancario" id="correo_bancario" placeholder="Correo">
                  <?php $__errorArgs = ['correo_bancario'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                  <div class="alert alert-danger"><?php echo e($message); ?></div>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
              </div>

              <div class="text-center mt-3">
                <button type="submit" class="btn btn-prim w-25 agregar_cuenta ">Guardar</button>
              </div>
            </form>
          </div>

          <table class="table table-hover" id="tabla_sucursal">
            <thead>
              <th>Cuenta</th>
              <th>Número</th>
            </thead>
            <tbody>

            </tbody>

          </table>

        </div>
      </div>
    </div>
  </div>
</div>
</div>







<?php $__env->stopSection(); ?>





<script>
  function eliminar_cuenta(id) {

    // alert(id);

    var result = confirm("¿Desea eliminar?");
    if (result) {
      //Logic to delete the item
      location.href = 'eliminar_cuenta_/' + id;


    }

  }

  $(document).ready(function() {



    $(".agregar").click(function() {

      $('#ocultar_agrega').css('display', '')

    });

    $(".billetera_modal").click(function() {

      $('#ocultar_agrega').css('display', 'none')

      var id_trabajado = $(this).attr("data-id_trabajador");
      // alert(id_trabajado);
      modal_villetera(id_trabajado);
    }); //fin de la funcion


    $('#sucursal_bancos').change(function() {

      id_selec = "#tipo_cuenta";
      // alert($("#sucursal_bancos option:selected").val()); 
      buscar_sucursales_banco($("#sucursal_bancos option:selected").val(), id_selec);
      //  buscar_comuna($("#region_empresa option:selected").val(),"#comuna_empresa","../");  
    })

  });

  function confirmation()

  {

    if (confirm("¿Desea continuar?"))

    {

      return true;

    } else

    {

      return false;

    }

  }
</script>
<?php echo $__env->make('menu/menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sistema/sistemacaja/resources/views/auth/ver_usuarios.blade.php ENDPATH**/ ?>