

<?php $__env->startSection('content'); ?>

<div class="container mt-5">
    <div class="title-vista mt-4">SERVICIOS</div>
</div>


<form action="<?php echo e(route('go.filtrarFechaServicio')); ?>" method="GET">
    <div class="container mt-5 mb-5">
        <!-- BARRA DE BUSQUEDA -->
        <div class="seccion-filtro">Filtrar por</div>
        <hr class="separador">
        <div class="row">
            <div class="container col-sm-6 form-group">
                <label for="datepicker">Fecha inicio</label>
                <input type="date" class="form-control" id="datepicker" name="datepicker">
            </div>
            <div class="container col-sm-6 form-group ">
                <label for="datepicker2">Fecha fin</label>
                <input type="date" class="form-control" id="datepicker2" name="datepicker2">
            </div>
            <div class="col-sm-12 text-center mt-5">
                <button type="buscar" class="btn btn-prim w-25">Buscar</button>
            </div>
        </div>
    </div>
</form>
<div class="container">
    <h1></h1>
    <hr class="separador">
</div>

<div class="container mt-5 p-0">
    <ul class="nav bg-export d-flex justify-content-between">
        <li class="clas-item">
            <label class="pl-3 pt-2" for=""><strong><?php echo e(count($servicios)); ?> Registros</strong></label>
        </li>
        <li class="clas-item m-auto">
            <i>Para ver toda la información, deslice a la derecha</i>
            <span class="material-icons-round icon-midle">trending_flat</span>
        </li>
        <li class="clas-item">
            <?php if(Route::current()->getName()=='go.filtrarFechaServicio'): ?>
            <form action="<?php echo e(route('go.vistapreviaServicio')); ?>" method="GET">
                <input type="hidden" value="<?php echo e($fechaWhere ?? ''); ?>" name="fecha">
                <button type="submit" class="btn btn-ter">
                    <span class="material-icons-round icon-midle">preview</span>Ver vista previa
                </button>
            </form>
            <?php endif; ?>
        </li>
    </ul>
</div>

<div class="container table-responsive mb-5 p-sm-0">
    <table class="table table-sm table-bordered table-striped table-hover">
        <!--ENCABEZADO-->
        <thead class="color-head">
            <tr>
                <th class="th-head border-th separador-v" colspan="1">Cliente</th>
                <th class="th-head border-th separador-v" colspan="1">T&eacute;cnico</th>
                <th class="th-head border-th separador-v" colspan="1">Fecha de Instalaci&oacute;n</th>
                <th class="th-head border-th separador-v" colspan="1">Fecha Finalizado</th>
                <th class="th-head border-th separador-v" colspan="1">Estado Final</th>
                <th class="th-head border-th separador-v" colspan="1">Estado Check</th>
                <th class="th-head border-th separador-v" colspan="1">Región</th>
                <th class="th-head border-th separador-v" colspan="1">Comuna</th>
                <th class="th-head border-th separador-v" colspan="1">Direcci&oacute;n | CUI</th>
                <th class="th-head border-th separador-v" colspan="1">Marca</th>
                <th class="th-head border-th separador-v" colspan="1">Modelo</th>

                <th class="th-head border-th separador-v" colspan="1">N&deg; de serie</th>
                <th class="th-head border-th separador-v" colspan="1">sSc</th>
            </tr>
        </thead>
        <!--FIN ENCABEZADO-->
        <!--RESULTADOS-->
        <tbody>
            <?php if(!empty($servicios)): ?>
            <?php $__currentLoopData = $servicios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $los_datos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($los_datos->sCliente ?? ''); ?></td>
                <td><?php echo e(strtoupper($los_datos->nombre_uno ?? '')); ?> <?php echo e(strtoupper($los_datos->apellido_uno ?? '')); ?></td>
                <?php if($los_datos->fecha_instalacion != ""): ?>
                <td><?php echo e(Carbon\Carbon::createFromDate($los_datos->fecha_instalacion)->format('d-m-Y H:i:s')); ?></td>
                <?php else: ?>
                <td>SIN FECHA</td>
                <?php endif; ?>
                <?php if($los_datos->fecha_termino != ""): ?>
                <td><?php echo e(Carbon\Carbon::createFromDate($los_datos->fecha_termino)->format('d-m-Y H:i:s')); ?></td>
                <?php else: ?>
                <td>SIN FECHA</td>
                <?php endif; ?>
                <td><?php echo e(strtoupper($los_datos->estado_final ?? '')); ?></td>
                <td><?php echo e(strtoupper($los_datos->estado_asignacion ?? '')); ?></td>
                <td><?php echo e($los_datos->sRegion ?? ''); ?></td>
                <td><?php echo e($los_datos->sComuna ?? ''); ?></td>
                <td><?php echo e($los_datos->sDireccion ?? ''); ?></td>
                <td><?php echo e($los_datos->Smarca ?? ''); ?></td>
                <td><?php echo e($los_datos->sModelo ?? ''); ?></td>

                <td><?php echo e($los_datos->sSerie ?? ''); ?></td>
                <td><?php echo e($los_datos->sSC ?? ''); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('menu/menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sistema/sistemacaja/resources/views/solicitudes_servicios/ver_todoschecklistservicios.blade.php ENDPATH**/ ?>