<?php $__env->startSection('content'); ?>
<?php if( session('mensaje') ): ?>
<div class="alert alert-success"><?php echo e(session('mensaje')); ?></div>
<?php endif; ?>

<div class="container mt-5">
    <div class="title-vista mt-4 d-flex justify-content-between">
        Capacitaciones
        <div class="mostrar-contenido">
            <a class="btn" href="javascript: history.go(-1)">
                <span class="material-icons-round icon-midle">arrow_back</span>
                Volver
            </a>
        </div>
    </div>
</div>
<div class="container mt-5">
    <!-- TABLA DE RESULTADOS DE BUSQUEDA -->
    <div class="container table-responsive mb-5 p-sm-0">
        <table class="table table-striped table-hover">
            <!-- ENCABEZADO -->
            <thead class="color-head">
                <tr>
                    <th class="th-head border-th separador-v" colspan="1">CUI</th>
                    <th class="th-head border-th separador-v" colspan="1">Fecha capacitación</th>
                    <th class="th-head border-th separador-v" colspan="1">Estado</th>
                    <th class="th-head border-th separador-v" colspan="1">Cliente</th>
                    <th class="th-head border-th separador-v" colspan="1">Comuna</th>
                    <th class="th-head border-th separador-v" colspan="1">Dirección</th>
                    <th class="th-head border-th"><span class="material-icons">settings</span></th>
                </tr>
            </thead>
            <!-- FIN ENCABEZADO -->
            <!-- RESULTADOS -->
            <tbody>
                <?php for($i=0;$i<$cont;$i++): ?> <?php if(!empty($capas[$i])): ?> <?php $__currentLoopData = $capas[$i]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $capacitacion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <tr>
                    <td class="td-val"><?php echo e($capacitacion->cui); ?></td>
                    <td class="td-val"><?php echo e(Carbon\Carbon::createFromDate($capacitacion->fecha_capacitacion)->format('d-m-Y')); ?></td>
                    <td class="td-val"><?php echo e($capacitacion->estado_capa); ?></td>
                    <td class="td-val"><?php echo e($capacitacion->cliente); ?></td>
                    <td class="td-val"><?php echo e($capacitacion->comuna); ?></td>
                    <td class="td-val"><?php echo e($capacitacion->direccion); ?></td>
                    <td class="td-val">
                        <div class="dropdown dropleft" style="text-align: center">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown">
                                <span class="material-icons">more_vert</span>
                            </button>

                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <div style="text-align: center">
                                        <!--<a href="<?php echo e(route('go.asignaciontecnico',Crypt::encryptString($capacitacion->id))); ?>" role="button" title="Editar" class="btn-icon btn-icon-dd"><span class="material-icons">edit</span></a>-->
                                        <form action="<?php echo e(route('go.asignaciontecnico')); ?>" method="GET">
                                            <input type="hidden" name="proveedor" value="<?php echo e($capacitacion->nombre_proveedor); ?>">
                                            <input type="hidden" name="idasig" value="<?php echo e(Crypt::encryptString($capacitacion->id)); ?>">
                                            <button class="btn"><span class="material-icons-round">edit</span></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <?php endfor; ?>
            </tbody>
            <!-- FIN RESULTADOS -->
        </table>
    </div>
    <!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('menu/menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sistema/sistemacaja/resources/views/check/historial_capacitacion.blade.php ENDPATH**/ ?>