<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- CSRF Token -->
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <title>SUIVI</title>
  <!-- Scripts -->
  <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>
  <script src="<?php echo e(asset('js/funciones.js')); ?>" defer></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.css">
<script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.js"></script>
  <!-- Fonts -->
  <link rel="dns-prefetch" href="//fonts.gstatic.com">
  <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Lato:wght@100;300;400;700&display=swap" rel="stylesheet">
  <!-- Styles -->
  <link href="<?php echo e(asset('css/bootstrap-4.4.1.css')); ?>" rel="stylesheet">
  
  <link href="<?php echo e(asset('css/css.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset('css/a&a_style.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset('css/a&a_btns_icons_style.css')); ?>" rel="stylesheet">
  <!-- Google icons -->
  <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Material+Icons+Round" rel="stylesheet">
  
  <link href="<?php echo e(asset('css/aya_style_2.0.css')); ?>" rel="stylesheet">
  <!-- Referencias a las bibliotecas -->


</head>
<body>
  <?php
  $nombre_DB = DB::connection()->getDatabaseName();
  $nombre_proveedores = DB::table('config_usuarios')
    ->select('id', 'nombre_proveedor', 'name_bd')
    ->where('estado', '=', 1)
    ->get();
  ?>
  <nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
    <a class="navbar-brand" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('../sistemacaja/public/synergy-shop-logo.png')); ?>" alt="Logotipo A&A Ingeniería" width="100" height="50">
    </a>
    <div class="container">
      <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="navbarSupportedContent">
        <ul class="navbar-nav mr-auto">
          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(route('home')); ?>">Inicio</a>
          </li>
          <?php if(Auth::user()->tipo_usuario == "administrador"): ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Usuarios
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <a class="dropdown-item" href="<?php echo e(route('go_add_traba')); ?>">Agregar usuario</a>
              <a class="dropdown-item" href="<?php echo e(route('go_see_traba')); ?>">Usuarios registrados</a>
            </div>
          </li>
          <?php endif; ?>
          <?php if(Auth::user()->tipo_usuario == "administrador" || Auth::user()->tipo_usuario == "coordinador"): ?>
          
          <?php endif; ?>
          <li class="nav-item dropdown">
            <?php if(Auth::user()->tipo_usuario == "trabajadoress"): ?>
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Reembolsos y Gastos
            </a>
            <?php endif; ?>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <?php if(Auth::user()->tipo_usuario == "trabajador"): ?>
              <a class="dropdown-item" href="<?php echo e(route('go_add_gastos')); ?>">Agregar gasto</a>
              <?php endif; ?>
              <?php if(Auth::user()->tipo_usuario == "trabajador"): ?>
              <a class="dropdown-item" href="<?php echo e(route('go_see_gastos')); ?>"> Mis gastos</a>
              <a class="dropdown-item" href="<?php echo e(route('mis_depositos')); ?>"> Mis depósitos</a>
              <?php endif; ?>
              <?php if(Auth::user()->tipo_usuario == "administrador"): ?>
              <?php endif; ?>
            </div>
          </li>

          <?php if(Auth::user()->tipo_usuario == "administrador"): ?>
          <!--<li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Depósitos
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <a class="dropdown-item" href="<?php echo e(route('go_add.deposito')); ?>">Depositar</a>
              <a class="dropdown-item" href="<?php echo e(route('goadd_cuenta')); ?>">Mantenedor bancos</a>
            </div>
          </li>-->
          <?php endif; ?>

          <?php if(Auth::user()->tipo_usuario == "administrador"): ?>
          <!--<li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Reportes
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <a class="dropdown-item" href="<?php echo e(route('filtro_deposito_rut')); ?>"> Depósitos</a>
              <a class="dropdown-item" href="<?php echo e(route('go_see_solicitud')); ?>"> Reembolsos pendientes</a>
              <a class="dropdown-item" href="<?php echo e(route('go_see_solicitud_persona')); ?>">Reembolsos </a>
              <a class="dropdown-item" href="<?php echo e(route('go_gastos_reembolsos')); ?>"> Gastos/Reembolsos</a>
              <a class="dropdown-item" href="<?php echo e(route('go.solicitudes_pendientes')); ?>"> Solicitudes días pendientes</a>
              <a class="dropdown-item" href="<?php echo e(route('go.solicitudes_pendientes_por_persona')); ?>"> Solicitudes días</a>
            </div>
          </li>-->
          <?php endif; ?>

          <?php if(Auth::user()->tipo_usuario == "trabajador"): ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Tareas
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              
              
              
              
              <a class="dropdown-item" href="<?php echo e(route('check.tecnico_servicios')); ?>">Servicios</a>
            </div>
          </li>
          <?php endif; ?>

          <?php if(Auth::user()->tipo_usuario == "trabajadoress"): ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Informes
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <a class="dropdown-item" href="<?php echo e(route('go.sol_dia')); ?>">Solicitar días</a>
              <a class="dropdown-item" href="<?php echo e(route('go.mis_solici')); ?>">Solicitudes enviadas</a>
              <a class="dropdown-item" href="<?php echo e(route('go.mis_dias_utilizados')); ?>">Días utilizados</a>
            </div>
          </li>
          <?php endif; ?>

          

          <?php if(Auth::user()->tipo_usuario == "Kyocera" || Auth::user()->tipo_usuario == "Banco" || Auth::user()->tipo_usuario == "externo"): ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              PORTAL
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              
              <a class="dropdown-item" href="<?php echo e(route('go.verserviciosKyocera')); ?>">Dashboard de estados</a>
              <a class="dropdown-item" href="<?php echo e(route('go.informesSla')); ?>">Dashboard de Calidad de Gestión</a>

              
              
              
              
              
              
              
              
              <a class="dropdown-item" href="<?php echo e(route('go.slazonas')); ?>">Sla Zonas</a>



            </div>
         

          <?php endif; ?>

        </li>


        <?php if(Auth::user()->coord_is_remoto == 1): ?>

          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(route('homeremote')); ?>">Tec. Remoto</a>
          </li>
        <?php endif; ?>

       
        <?php if(Auth::user()->coord_is_tecnico == 1): ?>
            <li class="nav-item">
              <a class="nav-link" href="<?php echo e(route('homeinterno')); ?>">Tec. Terreno</a>
            </li>
        <?php endif; ?>

       
       
        <?php if(Auth::user()->coord_is_coord == 1): ?>

            <li class="nav-item">
              <a class="nav-link" href="<?php echo e(route('homecoordinador')); ?>">Coordinador</a>
            </li>
        <?php endif; ?>


        </ul>

        <span style="color:white" class="username"> Bienvenido : <?php echo e(Auth::user()->usuario); ?> | </span>
        <?php if(auth()->guard()->guest()): ?>
        <?php else: ?>
        <a style=" padding:10px" class="btn text-white btn-sm" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                document.getElementById('logout-form').submit();">
          Salir
        </a>
       <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
          <?php echo csrf_field(); ?>
        </form>
         
        
        <?php endif; ?>
      </div>
    </div>

  </nav>
  <!-- Texto debajo del menú -->
  <div class="modo-contenedor">
    <div class="modo-texto">Modo: <?php echo e(\App\User::datosdelusaurio()); ?></div>
  </div>

  
  <div id="app">
    <?php echo $__env->yieldContent('content'); ?>
  </div>
  
  <!--Modal Historial instalacion-->
  <div class="modal" id="modal_setdb">
    <div class="modal-dialog">
      <div class="modal-content">
        <!-- Modal Header -->
        <div class="modal-header">
          <div class="seccion-modal">Cambio de base de datos</div>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <hr class="separador mx-4">
        <div class="modal-body">
          <div class="container">
            <select name="proveedor" id="seleccionarproveedores" class="custom-select mb-3 mayuscula opcionesSelect">
              <!-- <option value="" selected>Seleccionar</option>
              <?php if(Auth::user()->nombre_proveedor != ""): ?>
              <option value="<?php echo e(Auth::user()->nombre_proveedor); ?>"><?php echo e(Auth::user()->nombre_proveedor); ?></option>
              <?php else: ?>
              <?php $__currentLoopData = $nombre_proveedores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($datos->name_bd); ?>"><?php echo e($datos->nombre_proveedor); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?> -->
            </select>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
<?php echo $__env->yieldContent('graficos'); ?>
<?php echo $__env->yieldContent('scrypt'); ?>
</html>
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
<script src="https://code.jquery.com/jquery-1.10.2.min.js"></script>
<script>
  $(document).ready(function() {
    cargarProveedores();

    $('.set_db').click(function() {
      $("#modal_setdb").modal('show')
    })
    $(".opcionesSelect").change(function(e) {
      var proveedor = $(this).val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url: "<?php echo e(route('identificacion_confirmacion')); ?>",
        type: "get",
        data: {
          'proveedor': proveedor
        },
        success: function(response) {
          alert("Logeado correctamente");
          $("#modal_setdb").modal('hide')
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      })
    })
  });

  function cargarProveedores(){


var _token = $('input[name="_token"]').val();
  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    url: "https://www.suivi.cl/sistema/rendicion/api/getproveedores",
    type: "get",
    data: {
    },
    success: function(response) {
      console.log(response);
      
      $('#seleccionarproveedores').empty();
       $('#seleccionarproveedores').append(response);
    },
    error: function(xhr, status) {
      alert('Disculpe, ha ocurrido un problema, intente mas tarde');
    }
  })


}
</script>

<style>
.modo-contenedor {
  position: absolute; /* Fijar el elemento en la pantalla */
  top: 75px; /* Distancia desde la parte superior de la ventana del navegador */
  right:  0; /* Alinear a la izquierda */
  z-index: 999; /* Valor alto para asegurar que esté encima de otros elementos */
  padding: 10px; /* Espacio alrededor del texto */
}

.modo-texto {
  color: white; /* Color del texto */
  font-size: 14px; /* Tamaño de fuente */
  background-color: rgba(0, 0, 0, 0.7); /* Fondo oscuro con opacidad */
  padding: 10px; /* Espacio alrededor del texto */
  border-radius: 5px; /* Borde redondeado */
}

@media  only screen and (max-width: 480px) {
  .modo-contenedor {
    left: 50%; /* Mover hacia la mitad de la pantalla */
  top: 65px; /* Distancia desde la parte superior de la ventana del navegador */

  }
}
</style><?php /**PATH /var/www/html/sistema/sistemacaja/resources/views/menu/menu.blade.php ENDPATH**/ ?>