<script src="<?php echo e(asset('js/jquery-3.4.1.min.js')); ?>" ></script>
<?php $__env->startSection('content'); ?>

<div class="container mt-5">
  <div class="title-vista mt-4">RESUMEN DE RETIROS</div>
</div>

<form action="<?php echo e(route('filtros_historial_retiro')); ?>" method="GET">
  <div class="container mt-5">
    <div class="seccion-filtro">Firltrar por</div> 
    <hr class="separador">

    <div class="row">
      <!--AQUI SE CARGA EL SELECT DEL CLIENTE-->
      <div class="col-sm-3 form-group">
        <label for="clientes">Cliente</label>
        <select name="clientes"  class="custom-select mayuscula" id="clientes">
          <option selected >Seleccionar</option>
          <?php $__currentLoopData = $carga_selectCliente; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $clientesDatos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($clientesDatos->nombre != null): ?> 
              <?php if($clientesDatos->id == $clientes): ?> 
                <option selected value="<?php echo e($clientesDatos->id); ?>"><?php echo e(ucfirst(strtolower($clientesDatos->nombre))); ?></option>
              <?php else: ?>
                <option value="<?php echo e($clientesDatos->id); ?>"><?php echo e(ucfirst(strtolower($clientesDatos->nombre))); ?></option>
              <?php endif; ?>
            <?php endif; ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>     
      </div>
      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-3 form-group">
        <label for="comuna">Comuna</label>
        <?php if(!empty($disable)): ?>
        <select name="comuna" class="custom-select mayuscula" id="comuna">
        <?php else: ?> 
        <select name="comuna" disabled class="custom-select" id="comuna">
        <?php endif; ?>
          <option selected disabled>Seleccionar</option>
          <option selected  value ="" >Todos</option>
          <?php $__currentLoopData = $carga_selectComuna; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comunasDatos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($comunasDatos->comuna != null): ?> 
              <?php if($comunasDatos->comuna == $comuna): ?> 
                <option selected value="<?php echo e($comunasDatos->comuna); ?>"><?php echo e(ucfirst(strtolower($comunasDatos->comuna))); ?></option>
              <?php else: ?>
                <option value="<?php echo e($comunasDatos->comuna); ?>"><?php echo e(ucfirst(strtolower($comunasDatos->comuna))); ?></option>
              <?php endif; ?>
            <?php endif; ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>      
      </div>
      <!--AQUI SE CARGA EL SELECT DIRECCION-->
      <div class="col-sm-3 form-group">
        <label for="direccion">Dirección</label>
        <?php if(!empty($disable)): ?>
        <select name="direccion" class="custom-select mayuscula" id="direccion">
        <?php else: ?> 
        <select name="direccion" disabled class="custom-select" id="direccion">
        <?php endif; ?>
          <option selected disabled>Seleccionar</option>
          <option selected  value ="">Todos</option>
          <?php $__currentLoopData = $carga_selectDireccion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $direcciones): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($direcciones->direccion != null): ?> 
              <?php if($direcciones->direccion == $direccion): ?> 
                <option selected value="<?php echo e($direcciones->direccion); ?>"><?php echo e(ucfirst(strtolower($direcciones->direccion))); ?></option>
              <?php else: ?>
                <option value="<?php echo e($direcciones->direccion); ?>"><?php echo e(ucfirst(strtolower($direcciones->direccion))); ?></option>
              <?php endif; ?>
            <?php endif; ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-sm-3 form-group">
        <label for="cuisucursal">CUI</label>
        <?php if(!empty($disable)): ?>
        <select name="cuisucursal" class="custom-select mayuscula" id="cuisucursal">
        <?php else: ?> 
        <select name="cuisucursal" disabled class="custom-select" id="cuisucursal">
        <?php endif; ?>                                                        
          <option selected disabled>Seleccionar</option>
          <option selected  value ="">Todos</option>
          <?php $__currentLoopData = $carga_selectSucursal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sucursales): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($sucursales->cuisucursal != null): ?> 
              <?php if($sucursales->cuisucursal == $cuisucursal): ?> 
                <option selected value="<?php echo e($sucursales->cuisucursal); ?>"><?php echo e(ucfirst(strtolower($sucursales->cuisucursal))); ?></option>
              <?php else: ?>
                <option  value="<?php echo e($sucursales->cuisucursal); ?>"><?php echo e(ucfirst(strtolower($sucursales->cuisucursal))); ?></option>
              <?php endif; ?>
            <?php endif; ?>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
    </div>
  </div>

  
  <div class="text-center mb-5 mt-5">
    <button type="buscar" class="btn btn-pill btn-prim w-25">Buscar</button>  
  </div>
</form>

<?php echo e(session(['url_retiro' => url()->full()])); ?>


<div class="container mt-5">
  
  <ul class="nav bg-export">
    <li class="clas-item">
      <a class="btn btn-ter" target="_blank" href="<?php echo e(route('ir_vista_excel_historial',Crypt::encryptString(url()->full()))); ?>)}}">
        Exportar excel
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-excel-fill" viewBox="0 0 16 16">
          <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM5.884 6.68 8 9.219l2.116-2.54a.5.5 0 1 1 .768.641L8.651 10l2.233 2.68a.5.5 0 0 1-.768.64L8 10.781l-2.116 2.54a.5.5 0 0 1-.768-.641L7.349 10 5.116 7.32a.5.5 0 1 1 .768-.64z"/>
        </svg>
      </a>
    </li>
  </ul>
</div>


<div class="container table-responsive mb-5">
  <table class="table table-striped table-hover" id="mitable">
    <!-- ENCABEZADO -->
    <thead class="color-head">
      <tr>
        <th class="th-head border-th separador-v" colspan="1">Fecha de resumen</th>
        <th class="th-head border-th separador-v" colspan="1">Equipos embalados</th>
        <th class="th-head border-th separador-v" colspan="1">Equipos sin embalados</th>
        <th class="th-head border-th separador-v" colspan="1">Cantidad de bultos</th>
        <th class="th-head border-th separador-v" colspan="1">Cliente</th>
        <th class="th-head border-th separador-v" colspan="1">Comuna</th>
        <th class="th-head border-th separador-v" colspan="1">Dirección</th>
        <th class="th-head border-th separador-v" colspan="1">CUI</th>
        <th class="th-head border-th separador-v" colspan="1">Comentario </th>
        <th class="th-head border-th"><span class="material-icons">
          settings
          </span></th>
      </tr>
    </thead>
    <!-- FIN ENCABEZADO -->
    <!-- RESULTADOS -->
    <?php if(!empty($datosretiro)): ?>
    <?php $__currentLoopData = $datosretiro; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $los_datos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
      <td>
        <?php echo e(Carbon\Carbon::createFromDate($los_datos->fecha_resumen)->format('d-m-Y')); ?>

      </td>
      <td><?php echo e($los_datos->suma_embalados); ?></td>
      <td><?php echo e($los_datos->suma_sinembalar); ?></td>
      <td><?php echo e($los_datos->cantidad_bultos); ?></td>
      <td><?php echo e($los_datos->cliente); ?></td>
      <td><?php echo e($los_datos->comuna); ?></td>
      <td><?php echo e($los_datos->direccion); ?></td>
      <td><?php echo e($los_datos->cuisucursal); ?></td>
      <td><?php echo e($los_datos->descripcion_motivo); ?></td>                      
      <td class="td-val">
        <div class="dropdown dropleft" style="text-align: center;">
          <button type="button" class="btn-dropdown" data-toggle="dropdown">
            <span class="material-icons">more_vert</span>
          </button>
          <div class="dropdown-menu mostrar shadow">
            <div class="d-flex justify-content-around">
          <form target="_blank" action="<?php echo e(route ('go.verdatosresumenretiro_coordinadora')); ?>" method="GET" style="margin-bottom: 0;">
           <!--<?php echo e($los_datos->id); ?>-->
            <button type="submit" style="border:0px;border-color:transparent;background-color:transparent;">
              <input type="text" style="display:none "  id="check" value="<?php echo e($los_datos->id); ?>" name="check">
              <a href="" role="button" class="btn-icon btn-icon-dd ver_historial" title="Ver Resumen"><span class="material-icons">visibility</span></a>
            </button>
          </form>
        </div>
          </div>
        </div>
      </td>
    </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
  </table>
</div>







  <script>


    
    
      
$(document).ready(function(){

  $("#clientes").change(function(){      
    cliente = $('select[id=clientes]').val();
    var _token = $('input[name="_token"]').val(); 
    $.ajax({
      method:"POST",
      url:"<?php echo e(route('comunasResumentesRetiros')); ?>",
      data: {  _token:_token,'cliente':cliente},
      success: function(data) {
        console.log(data);
        $("#comuna").empty();
        $("#direccion").empty();
        $("#cuisucursal").empty();      
        $("#comuna").append('<option value="">Seleccionar</option>');
        $("#direccion").append('<option value="">Seleccionar</option>');
        $("#cuisucursal").append('<option value="">Seleccionar</option>');   
        $(data).each(function(i, v){ // indice, valor
        //if(v.sComuna != null || v.sComuna != "null"  ){ 
          $("#comuna").append('<option value="' + v.comuna + '">' + v.comuna + '</option>');
        })
        // }
        $('#comuna').prop('disabled', false);
      },
      error: function(xhr, status) {
        alert('Disculpe, ha ocurrido un problema, intente mas tarde');
      }
    });
  });

  $("#comuna").change(function(){
    comuna = $('select[id=comuna]').val();
    var _token = $('input[name="_token"]').val();
    $.ajax({
      method:"POST",
      url:"<?php echo e(route('direccionesResumentesRetiros')); ?>",
      data: { 'comuna': comuna,  _token:_token, 'cliente':$("#clientes").val()},
      success: function(data) {
        $("#direccion").empty();
        $("#cuisucursal").empty();
        $("#direccion").append('<option value="">Seleccionar</option>');
        $("#cuisucursal").append('<option value="">Seleccionar</option>');
        $(data).each(function(i, v){ // indice, valor
        //if(v.sdireccion != null || v.sdireccion != "null"  ){ 
          $("#direccion").append('<option value="' + v.direccion + '">' + v.direccion + '</option>');
        })
        // }
        $('#direccion').prop('disabled', false);
      },            
      error: function(xhr, status) {
        alert('Disculpe, ha ocurrido un problema, intente mas tarde');
      }
    });
  });

  $("#direccion").change(function(){
    direccion = $('select[id=direccion]').val();
    var _token = $('input[name="_token"]').val();
    $.ajax({
      method:"POST",
      url:"<?php echo e(route('sucursalessResumentesRetiros')); ?>",
      data: { 'direccion': direccion,  _token:_token, 'cliente':$("#clientes").val()},
      success: function(data) {
        $("#cuisucursal").empty();
        $("#cuisucursal").append('<option value="">Seleccionar</option>');
        $(data).each(function(i, v){ // indice, valor
          //if(v.ssucursal != null || v.ssucursal != "null"  ){ 
          $("#cuisucursal").append('<option value="' + v.cuisucursal + '">' + v.cuisucursal + '</option>');
        })
        // }
        $('#cuisucursal').prop('disabled', false);
      },             
      error: function(xhr, status) {
        alert('Disculpe, ha ocurrido un problema, intente mas tarde');
      }
    });
  });
});
  </script>


<!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
<!-- <script src="./Untitled Document_files/jquery-3.4.1.min.js.descarga"></script> -->

<!-- Include all compiled plugins (below), or include individual files as needed -->
<!-- <script src="./Untitled Document_files/popper.min.js.descarga"></script>
<script src="./Untitled Document_files/bootstrap-4.4.1.js.descarga"></script> -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('menu/menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sistema/sistemacaja/resources/views/check/historial_retiro_coordinadora.blade.php ENDPATH**/ ?>