<!DOCTYPE html>
<html lang="es">
<?php $mes = date('d/m/Y');
header('Content-type: application/vnd.ms-excel charset=utf-8');
header("Content-Disposition: attachment; filename=InformecheckInstalacionesfecha$mes.xls");
header("Pragma: no-cache");
header("Expires: 0");  ?>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>

<body>
    <table class="table table-bordered table-responsive-lg table-striped table-hover" style="margin: 0" id="gridData">
        <!-- ENCABEZADO -->
        <thead>
            <tr>
                <th class="container-2">
                    <h3>Cliente</h3>
                </th>
                <th class="container-1">
                    <h3>Proyecto Asociado</h3>
                </th>
                <?php if(Auth::user()->tipo_usuario == "administrador" || Auth::user()->tipo_usuario == "coordinador"): ?>
                <th class="container-1">
                    <h3>Tecnico</h3>
                </th>
                <?php endif; ?>
                <th class="container-1">
                    <h3>Asignaci&#243;n cordinadora</h3>
                </th>
                <th class="container-1">
                    <h3>Fecha inicio</h3>
                </th>
                <th class="container-1">
                    <h3>Fecha fin</h3>
                </th>
                <th class="container-2">
                    <h3>Estado Despacho</h3>
                </th>
                <th class="container-2">
                    <h3>Estado Final</h3>
                </th>
                <th class="container-2">
                    <h3>Estado check</h3>
                </th>
                <th class="container-2">
                    <h3>Cantidad de Usuarios</h3>
                </th>
                <th class="container-2">
                    <h3>Region</h3>
                </th>
                <th class="container-2">
                    <h3>Comuna</h3>
                </th>
                <th class="container-2">
                    <h3>Sucursal</h3>
                </th>
                <th class="container-2">
                    <h3>Id sala</h3>
                </th>
                <th class="container-2">
                    <h3>Direcci&#243;n | CUI</h3>
                </th><?php /*?>Agregue una nueva columna  - FITO<?php */ ?>
                <th class="container-2">
                    <h3>Nº de serie</h3>
                </th>
                <th class="container-2">
                    <h3>Marca</h3>
                </th>
                <th class="container-2">
                    <h3>Modelo equipo</h3>
                </th>
                <th class="container-2">
                    <h3>Ip</h3>
                </th>
                <th class="container-2">
                    <h3>Contador</h3>
                </th>
                <th class="container-2">
                    <h3>Contador Color</h3>
                </th>
                <th class="container-2">
                    <h3>Nº de serie saliente</h3>
                </th>
                <th class="container-2">
                    <h3>Modelo equipo saliente</h3>
                </th>
                <th class="container-2">
                    <h3>Marca equipo saliente</h3>
                </th>   
                <th class="container-2">
                    <h3>Observaci&#243;n</h3>
                </th>
                <th class="container-2">
                    <h3>Estados Opci&#243;n</h3>
                </th>
                <th class="container-2">
                    <h3>Respuestos solicitados</h3>
                </th>
                <th class="container-2">
                    <h3>Nombre de parte</h3>
                </th>
                <th class="container-2">
                    <h3>S/N</h3>
                </th>
                <th class="container-2">
                    <h3>Cantidad</h3>
                </th>
            </tr>
        </thead>
        <!-- FIN ENCABEZADO -->
        <!-- RESULTADOS -->
        <tbody>
            <?php if(!empty($instalaciones)): ?>
            <?php $__currentLoopData = $instalaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $los_datos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($los_datos->sCliente ?? ''); ?></td>
                <?php if($los_datos->nombre == "Global"): ?>
                <td>No Asignado</td>
                <?php else: ?>
                <td><?php echo e($los_datos->nombre ?? ''); ?></td>
                <?php endif; ?>
                <?php if(Auth::user()->tipo_usuario == "administrador" || Auth::user()->tipo_usuario == "coordinador"): ?>
                <td><?php echo e($los_datos->nombre_uno ?? ''); ?> <?php echo e($los_datos->apellido_uno ?? ''); ?></td>
                <?php endif; ?>
                <td><?php echo e(Carbon\Carbon::createFromDate($los_datos->fecha_instalacion)->format('d-m-Y')); ?></td>
                <?php
                $fechas = DB::table('asignacion_instalacions')
                ->join("checklist_instalacions","checklist_instalacions.asignacion_instalacion_retiro_id","=","asignacion_instalacions.id")
                ->select('checklist_instalacions.fecha_inicio','checklist_instalacions.fecha_fin')
                ->where('asignacion_instalacions.id','=',$los_datos->id_asig)
                ->orderBy('checklist_instalacions.id', 'desc')
                ->get();

                $fecha_inicio = "";
                $fecha_fin = "";
                if(count($fechas) != 0){
                if($fechas[0]->fecha_inicio != "" || $fechas[0]->fecha_fin != "" ){
                $fecha_inicio = Carbon\Carbon::createFromDate($fechas[0]->fecha_inicio)->format('d-m-Y H:i:s');
                $fecha_fin = Carbon\Carbon::createFromDate($fechas[0]->fecha_fin)->format('d-m-Y H:i:s');
                }
                }
                ?>
                <td><?php echo e($fecha_inicio); ?></td>
                <td><?php echo e($fecha_fin); ?></td>
                <?php if($los_datos->sEstado_despacho != null || $los_datos->sEstado_despacho != ""): ?>
                <td style="text-transform: uppercase"> <?php echo e(ucfirst($los_datos->sEstado_despacho ?? '')); ?></td>
                <?php else: ?>
                <td></td>
                <?php endif; ?>
                <?php if($los_datos->sEstado_instalacion != null || $los_datos->sEstado_instalacion != ""): ?>
                <td style="text-transform: uppercase"> <?php echo e(ucfirst($los_datos->sEstado_instalacion ?? '')); ?></td>
                <?php else: ?>
                <td></td>
                <?php endif; ?>
                <td> <?php echo e(ucfirst($los_datos->estado_asignacion ?? '')); ?></td>
                <td style="text-transform: uppercase"> <?php echo e(ucfirst($los_datos->Cscantidad_usuarios ?? '')); ?></td>
                <td><?php echo e($los_datos->sRegion ?? ''); ?></td>
                <td><?php echo e(($los_datos->sComuna)); ?></td>
                <td><?php echo e($los_datos->Cstipo_sucursal ?? ''); ?></td>
                <?php if($los_datos->idSala != null || $los_datos->idSala != ""): ?>
                <td><?php echo e($los_datos->idSala ?? ''); ?></td>
                <?php else: ?>
                <td></td>
                <?php endif; ?>
                <td><?php echo e($los_datos->sDireccion ?? ''); ?></td>
                <?php if($los_datos->remplazo != null || $los_datos->remplazo != ""): ?>
                <td><?php echo e($los_datos->remplazo?? ''); ?></td>
                <?php else: ?>
                <td><?php echo e($los_datos->sSerie ?? ''); ?></td>
                <?php endif; ?>
                <td><?php echo e($los_datos->Csmarca ?? ''); ?></td>

                <td><?php echo e($los_datos->CsModelo ?? ''); ?></td>
                <td><?php echo e($los_datos->CsIP ?? ''); ?></td>
                <td><?php echo e($los_datos->CnContador ?? ''); ?></td>
                <td><?php echo e($los_datos->CnContador_color ?? ''); ?></td>
                <!--SALIENTE-->
                <td><?php echo e($los_datos->CsSerie_es ?? ''); ?></td>
                <td><?php echo e($los_datos->CsModelo_es ?? ''); ?></td>
                <td><?php echo e($los_datos->CsMarca_es ?? ''); ?></td>

                <td><?php echo e($los_datos->observacion ?? ''); ?></td>
                <td><?php echo e($los_datos->opcion_estado_instalacion ?? ''); ?></td>
                <?php
                $accesorios = DB::table('checklist_accesorios')
                ->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios.id_accesorio')
                ->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_accesorios.cantidad', 'accesorios.id as ID', 'checklist_accesorios.serie_parte')
                ->where('checklist_accesorios.id_checklist_instalacion', '=', $los_datos->id_checklist)
                ->get();
                ?>
                <td>
                    <?php $__currentLoopData = $accesorios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $solicitados): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($key+1); ?> - <?php echo e($solicitados->descripcion); ?> <br>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
                <td>
                    <?php $__currentLoopData = $accesorios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $solicitados): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($key+1); ?> - <?php echo e($solicitados->articulo); ?> <br>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
                <td>
                    <?php $__currentLoopData = $accesorios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $solicitados): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($key+1); ?> - <?php echo e($solicitados->serie_parte); ?> <br>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
                <td>
                    <?php $__currentLoopData = $accesorios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $solicitados): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo e($key+1); ?> => <?php echo e($solicitados->cantidad); ?> <br>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </tbody>
        <!-- FIN RESULTADOS -->
    </table>
</body>

</html><?php /**PATH /var/www/html/sistema/sistemacaja/resources/views/check/excel/excel_instalacioncheckcordinadora.blade.php ENDPATH**/ ?>