@extends('menu/menu')
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js"></script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>

 

@section('content') 
 
<div class="container mt-5">
  <div class="title-vista mt-4">AGREGAR CLIENTES</div>
</div>




<div class="container mt-4">

  
    {{-- {{route('crear.usuario')}} --}}
    <form action="{{route('create.client')}}" method="POST">
      {{-- <form action="" method="POST"> --}}
        @csrf
         
        <div class="seccion-filtro">Datos del cliente</div> 
        <hr class="separador">
        <div class="row">

          <div class="col-sm-3 form-group">
            <label for="razon_social">Razón social</label>
            <input type="text" class="form-control mayuscula" name="razon_social" id="razon_social" value="{{@old('razon_social')}}"   placeholder="Razón Social">
              @error('razon_social')
                <div class="alert alert-danger">{{ $message }}</div>
              @enderror
          </div>
          <div class="col-sm-3 form-group">
            <label for="rut">RUT</label>
            <input type="text"  name="rut" id="rut" class="form-control mayuscula" maxlength="10" value=""  change="guion,v_rut"  placeholder="Rut">
            @error('rut')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror
          </div>
          <div class="col-sm-3 form-group">
            <label for="telefono">Teléfono</label>
            <input type="tel" class="form-control mayuscula" value="{{@old('telefono')}}" id="telefono"  name="telefono"  placeholder="Teléfono">
            @error('telefono')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror
          </div>
          <div class="col-sm-3 form-group">
            <label for="correo">Correo</label>
            <input type="email" class="form-control mayuscula" name="correo" id="correo" value="{{@old('correo')}}"   change="correo"  placeholder="Correo">
            @error('correo')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror
          </div>
          <div class="col-sm-3">
            <label for="rut" class="" >Proveedor</label>
            <select required class="custom-select mb-3 mayuscula" name="nombre_proveedor" id="nombre_proveedor">
              <option value="" selected>Seleccionar</option>
              @foreach($proveedores as $datos)
              <option value="{{$datos->nombre_proveedor }}">{{$datos->nombre_proveedor}}</option>
              @endforeach
          </select>
          </div>
        </div>


        <div class="seccion-filtro">Dirección</div> 
        <hr class="separador">

        <div class="row">
          <div class="col-sm-3 form-group">
            <label for="">Región</label>
            <select class="custom-select mayuscula" name="region" id="region_usuario">
              <option value="">Seleccionar</option>
              @foreach($regiones as $region)
                <option value="{{$region->id}}" {{(old('region')==$region->id)? 'selected':''}}>{{$region->des_region}}</option>
              @endforeach
            </select>
            @error('region')
              <div class="alert alert-danger">{{ $message }}</div>
            @enderror
            
          </div>
          <div class="col-sm-3 form-group">
            <label for="">Comuna</label>
            <div class="input-group d-flex">
              <select class="custom-select mayuscula" name="comuna" id="comuna_usuarios">
                <option value="">Seleccionar</option>
                @foreach($comunas as $comuna)
                  <option value="{{$comuna->id}}" {{(old('comuna')==$comuna->id)? 'selected':''}}>{{$comuna->des_comuna}}</option>
                @endforeach            
              </select>
              <div class="input-group-append">
                <a id="nueva_comuna" class="btn app-color">
                  <span class="material-icons-round">add</span>
                </a>
              </div>
            </div>
          </div>
          <div class="col-sm-6 form-group">
            <label for="">Dirección</label>
            <input type="text" name="calle" class="form-control mayuscula" value="{{@old('calle')}}"    placeholder="Calle">
              @error('calle')
                <div class="alert alert-danger">{{ $message }}</div>
              @enderror
          </div>
        </div>

      {{-- Botón guardar --}}
      <div class="text-center mb-5 mt-5">
        <button type="submit" class="btn btn-pill btn-prim w-25">Guardar</button>  
      </div>
      
      
    
    
    
    
    </form>
    
    @if ( session('mensaje') )
    <div class="alert alert-exito"><span class="material-icons mr-2">task_alt</span>{{ session('mensaje') }}</div>
    <div class="text-center">
      <a href="{{route('go_see_clien')}}">
        <button class="btn btn-secundario btn-pill w-25">Ver Clientes</button>
      </a>
    </div>
     

    </div>
    

@endif
    
@endsection
<div class="container">

  <!-- The Modal -->
  <div class="modal fade" id="modal_comuna">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <div class="seccion-modal">AGREGAR COMUNA</div> 
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>

        <hr class="separador ml-4 mr-4">
        <!-- Modal body -->
        <div class="modal-body">
          <div class="col-sm-12 form-group" >
                <label for="">Región</label>
                <select class="form-control mayuscula" name="" id="regiones_modal">
                        @foreach($regiones as $region)
                        <option value="{{$region->id}}">{{$region->des_region}}</option>
                        @endforeach
                </select>
          </div>   
          <div class="col-sm-12 form-group" >
              <label for="">Nombre comuna</label>
              <input type="text" class="form-control mayuscula" value="{{@old('comunas_modal')}}" id="comunas_modal"  name="comunas_modal"  placeholder="Comuna">
          </div>              
        </div>
        
        <!-- Modal footer -->
        <div class="text-center mb-5 mt-5">
          <button type="button" class="btn btn-secundario btn-pill pl-5 pr-5" data-dismiss="modal">Cancelar</button>
          <button type="button" class="btn btn-pill btn-prim pl-5 pr-5">Agregar comuna</button>
        </div>
        
      </div>
    </div>
  </div>
  
</div>
<script>



  $(document).ready(function(){

    $('#save').click(function() {    //para guardar en el modal de comuna
        
        var regiones_modal = $("#regiones_modal").val()
        var  comunas_modal = $("#comunas_modal").val()
        //  alert(comunas_modal);
 
         agregar_comuna(regiones_modal,comunas_modal);
      })

    $("#nueva_comuna").click(function(){
        $('#modal_comuna').modal('show');
         //removemos el atributo de selecion
        $("#region_usuario").removeAttr("selected")
        //limpiamos las comunas_empresa
        $("#comuna_usuarios").empty();  
        //agregamos el select de escoger
        $("#region_persona option[value='escoger_persona']").attr("selected",true); 
        
        });
//********************************************************

    $('#region_usuario').change(function() {    
         buscar_comuna($("#region_usuario option:selected").val(),"#comuna_usuarios");  
        // alert("hols");
     })
// ************************RUT*****************************************
    //validar rut  
    $("#rut").change(function(){
      checkRut( $("#rut").val());
    });
    //agregar digito al rut
    $('#rut').on('input', function() {
      var valor = $("#rut").val().replace('.','');
     valor = valor.replace('-','');
     cuerpo = valor.slice(0,-1);
     dv = valor.slice(-1).toUpperCase();
     rut= cuerpo + '-'+ dv;
     $("#rut").val(rut);
     });

     
     $('#correo').change(function() {
    
      validarEmail($("#correo").val());
     });
  
  });

  function validarEmail(valor) {
  if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3,4})+$/.test(valor)){
  //  alert("La dirección de email " + valor + " es correcta.");
  console.log("listo");
  } else {
  //  alert("La dirección de email es incorrecta." + valor);
  //  $("#correo").val("");
  }
}

  function checkRut(rut) {
    // Despejar Puntos
    var valor = rut.replace('.','');
    // Despejar Guión
    valor = valor.replace('-','');
    
    // Aislar Cuerpo y Dígito Verificador
    cuerpo = valor.slice(0,-1);
    dv = valor.slice(-1).toUpperCase();
    
    // Formatear RUN
    rut.value = cuerpo + '-'+ dv
    
    // Si no cumple con el mínimo ej. (n.nnn.nnn)
    if(cuerpo.length < 7) { 
        alert("Rut Incorrecto");
        $("#rut").val('');
      }else{
    
    // Calcular Dígito Verificador
    suma = 0;
    multiplo = 2;
    
    // Para cada dígito del Cuerpo
    for(i=1;i<=cuerpo.length;i++) {
    
        // Obtener su Producto con el Múltiplo Correspondiente
        index = multiplo * valor.charAt(cuerpo.length - i);
        
        // Sumar al Contador General
        suma = suma + index;
        
        // Consolidar Múltiplo dentro del rango [2,7]
        if(multiplo < 7) { multiplo = multiplo + 1; } else { multiplo = 2; }
  
    }
    
    // Calcular Dígito Verificador en base al Módulo 11
    dvEsperado = 11 - (suma % 11);
    
    // Casos Especiales (0 y K)
    dv = (dv == 'K')?10:dv;
    dv = (dv == 0)?11:dv;
    
    // Validar que el Cuerpo coincide con su Dígito Verificador
    if(dvEsperado != dv) {
      alert("Rut incorrecto");
      $("#rut").val('');
    }
  }
  
}
  </script>
