@extends('menu/menu')

<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>

<meta name="viewport" content="width=device-width, initial-scale=1">
@section('content')
@if ( session('mensaje') )
    <div class="alert alert-success">{{ session('mensaje') }}</div>
    <a class="dropdown-item" href="{{route('go_see_traba')}}" style="text-align: right">
      <button class="btn btn-prim w-25">Trabajadores</button>
    </a> 
@endif

<div class="container mt-5">
  <div class="title-vista mt-4">Agregar usuario</div>
</div>

<div class="container">
  <form action="{{route('crear.usuario')}}" method="POST">
  @csrf
    <div class="seccion-filtro">Datos Personales</div> 
    <hr class="separador">

      <div class="row" > 
        <div class="col-sm-3 form-group">
          <label for="primer_nombre">Primer nombre</label>
          <input type="text" class="form-control mayuscula" name="primer_nombre" id="primer_nombre" value="{{@old('primer_nombre')}}"   placeholder="Primer Nombre">
          @error('primer_nombre')
            <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>
        <div class="col-sm-3 form-group">
          <label for="segundo_nombre">Segundo nombre</label>
          <input type="text" class="form-control mayuscula" name="segundo_nombre" id="segundo_nombre" value="{{@old('segundo_nombre')}}"   placeholder="Segundo Nombre">
          @error('segundo_nombre')
            <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div> 
        <div class="col-sm-3 form-group">
          <label for="apellido_paterno">Apellido paterno</label>
          <input type="text" class="form-control mayuscula" value="{{@old('apellido_paterno')}}"   name="apellido_paterno"  id="apellido_paterno" placeholder="Apellido Paterno">
          @error('apellido_paterno')
            <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>
        <div class="col-sm-3 form-group">
          <label for="apellido_materno">Apellido materno</label>
          <input type="text" class="form-control mayuscula" value="{{@old('apellido_materno')}}"  id="apellido_materno"  name="apellido_materno"  placeholder="Apellido Materno">
          @error('apellido_materno')
            <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>
        <div class="col-sm-3">
          <label for="rut">Rut</label>
          <input type="text"  name="rut" id="rut" class="form-control mayuscula" maxlength="10" value=""  change="guion,v_rut"  placeholder="Rut">
          @error('rut')
          <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>
      </div>

    <div class="seccion-filtro">Datos Contacto</div> 
    <hr class="separador">

      <div class="row">
        <div class="col-sm-3 form-group" >
          <label for="telefono">Teléfono</label>
          <input type="tel" class="form-control mayuscula" value="{{@old('telefono')}}" id="telefono"  name="telefono"  placeholder="Telefono">
          @error('telefono')
            <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>
        <div class="col-sm-3 form-group" >
          <label for="telefono_opcional">Teléfono (Opcional)</label>
          <input type="tel" class="form-control mayuscula" value="{{@old('telefono_opcional')}}"   name="telefono_opcional"  id="telefono_opcional" placeholder="Telefono Opcional">
          @error('telefono_opcional')
            <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>
        <div class="col-sm-3 form-group" >
          <label for="correo">Correo</label>
          <input type="email" class="form-control mayuscula" name="correo" id="correo" value="{{@old('correo')}}"   change="correo"  placeholder="Correo">
          @error('correo')
            <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>
        <div class="col-sm-3 form-group" >
          <label for="correo_opcional">Correo (Opcional)</label>
          <input type="email" class="form-control mayuscula" name="correo_opcional" id="correo_opcional" value="{{@old('correo_opcional')}}"  change="correo_opcional"  placeholder="Correo Opcional">
          @error('correo_opcional')
            <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>
      </div>
              
    <div class="seccion-filtro">Dirección</div> 
    <hr class="separador">
        
      <div class="row">
        <div class="col-sm-3">
          <label for="">Región</label>
          <select class="form-control mayuscula" name="region" id="region_usuario">
            <option value="">Seleccionar</option>
            @foreach($regiones as $region)
              <option value="{{$region->id}}" {{(old('region')==$region->id)? 'selected':''}}>{{$region->des_region}}</option>
              @endforeach
            </select>
              @error('region')
              <div class="alert alert-danger">{{ $message }}</div>
              @enderror
        </div>

        <div class="col-sm-3">
            {{-- <a style="color:blue;cursor:pointer"  id="nueva_comuna">+</a>
              <label for="">Comuna</label>
              <select class="form-control mayuscula" name="comuna" id="comuna_usuarios">
                <option value="">Seleccionar</option>
                @foreach($comunas as $comuna)
                <option value="{{$comuna->id}}" {{(old('comuna')==$comuna->id)? 'selected':''}}>{{$comuna->des_comuna}}</option>
                @endforeach            
              </select> --}}

          <label for="">Comuna</label>
          <div class="input-group d-flex">
            <select name="comuna" id="comuna_usuarios" class="custom-select mayuscula">
              <option value="">Seleccionar</option>
              @foreach($comunas as $comuna)
                <option value="{{$comuna->id}}" {{(old('comuna')==$comuna->id)? 'selected':''}}>{{$comuna->des_comuna}}</option>
              @endforeach 
            </select> 
            <div class="input-group-append">
              <a id="nueva_comuna" class="btn app-color">
                <span class="material-icons-round">add</span>
              </a>
            </div>
          </div>
          @error('comuna')
            <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>

        <div class="col-sm-6">
          <label for="">Calle</label>
          <input type="text" class="form-control mayuscula" name="calle" class="form-control" value="{{@old('calle')}}"    placeholder="Calle">
          @error('calle')
          <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>
      </div>

    <div class="seccion-filtro">Login</div> 
    <hr class="separador">

      <div class="row">
        <div class="col-sm-3 form-group" style="display:">
          <label for="">Tipo Usuario</label>
         <select class="form-control mayuscula" name="tipo_usu" id="tipos_usuarios">
            <option class="mayuscula" value="Comun">Tecnico</option>
            <option class="mayuscula" value="Coordinador">Coodinador</option>
            <option class="mayuscula" value="remoto">Tecnico Remoto</option>

         </select>
           @error('tipo_usu')
           <div class="alert alert-danger">{{ $message }}</div>
           @enderror           
        </div>

        <div class="col-sm-3 form-group" style="display:">
          <label for="">Zona Usuario</label>
         <select class="form-control mayuscula" name="userzona" id="zonausuario">
          <option class="mayuscula" value="interno">Interno</option>

            <option class="mayuscula" value="norte">Norte</option>
            <option class="mayuscula" value="centro">Centro</option>
            <option class="mayuscula" value="sur">Sur</option>

         </select>
           @error('userzona')
           <div class="alert alert-danger">{{ $message }}</div>
           @enderror           
        </div>


        <div class="col-sm-3 form-group" id="" style="display:">
        {{-- <div class="col-sm-3 form-group" id="div_permisosExtras" style="display:none"> --}}

          <label for="">Permisos Extras</label>
         
         <div>
          {{-- <input type="checkbox" name="coord_remoto" id="coord_remoto"  style="display:"  value="si"> Remoto --}}
          <div id="coord_remoto" style="display: inline-block;">
            <input type="checkbox" name="coord_remoto" id="coord_remoto_cb" value="si"> 
            <label for="coord_remoto_cb">Remoto</label>
        </div>
        <div id="coord_tecnico" style="display: none;">
            <input type="checkbox" name="coord_tecnico" id="coord_tecnico_cb" value="si"> Tecnico
        </div>
  
        </div>
      </div>
      </div>

      

      <!-- <div class="row">
       
      </div> -->

      <div class="row">
        <div class="col-sm-3 form-group" >
          <label for="">Usuario</label>
          <input type="text" class="form-control mayuscula" value="{{@old('usuario')}}"   name="usuario" placeholder="Usuario">
          @error('usuario')
          <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>
        <div class="col-sm-3 form-group" >
          <label for="">Password</label>
          <input type="password" class="form-control mayuscula" value="{{@old('password')}}"   name="password"  placeholder="Password">
          @error('password')
          <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>
        <div class="col-sm-3 form-group" >
          <label for="">Repita Password</label>
          <input type="password" class="form-control mayuscula" value="{{@old('password_2')}}"  name="password_2" placeholder="Password">
          @error('password_2')
          <div class="alert alert-danger">{{ $message }}</div>
          @enderror
      </div> 
      <div class="col-sm-3" style="display:">
        <label for="" style="display:" id="label_region">Región Trabajador</label>
        <select class="form-control mayuscula " name="region_trabajo" id="region_trabajo" >
          <option value="">Seleccionar</option>
          @foreach($regiones_clientes as $regiones_clientes_)
            <option value="{{$regiones_clientes_->id}}" {{(old('region_trabajo')==$regiones_clientes_->id)? 'selected':''}}>{{$regiones_clientes_->des_region}}</option>
          @endforeach
        </select>
        <span id="opciones_dos">
          @error('selecionados')
            <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        <input type="text" class="form-control" value="" name="" id="opcionuno_otro" style="display: none;">
        @error('region_trabajo')
          <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
    </div>
    <div class="row">
      <div class="col-sm-12 text-center mt-4 mb-5">
          <button type="submit" class="btn btn-prim w-25">Guardar</button>  
      </div>
    </div>
        
  </form>
</div>
    
@endsection

<div class="container">

  <!-- The Modal -->
  <div class="modal" id="modal_comuna">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Agregar comuna</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <hr class="separador ml-4 mr-4">
        
        <!-- Modal body -->
        <div class="modal-body">
          <div class="col-sm-12 form-group" >
            <label for="">Región</label>
            <select class="custom-select mayuscula" name="" id="regiones_modal">
              @foreach($regiones as $region)
                <option value="{{$region->id}}">{{$region->des_region}}</option>
              @endforeach
            </select>
          </div>   
          <div class="col-sm-12 form-group" >
            <label for="">Nombre comuna</label>
            <input type="text" class="form-control mayuscula" value="{{@old('comunas_modal')}}" id="comunas_modal"  name="comunas_modal"  placeholder="Comuna">
          </div>              
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer mx-auto">
          <button type="button" class="btn btn-secundario px-5">Guardar</button>
          <button type="button" class="btn btn-prim px-5" data-dismiss="modal">Cancelar</button>
        </div>
        
      </div>
    </div>
  </div>
  
</div>
<script>
         $(function(){
           $('#region_trabajo').on('change',function(){
                                   var valor =  $('#region_trabajo option:selected').val();
                              
                                   var texto = $('#region_trabajo option:selected').text();
                                   var texto = '<label id='+valor+"-"+valor+'>'+texto+'</label>';
             $('#opciones_dos').append('<input type="checkbox"  checked id="'+valor+'" name="selecionados[]" value="'+valor+'">' +texto+'<br> ');
             console.log(valor, texto);
             $("#region_trabajo").find("option[value='"+valor+"']").remove();
           });


           $(document).on('change','input[type="checkbox"]',function(e){

              
              if(this.checked == false){


                $('#region_trabajo').append('<option value="'+this.value+'" >'+ $("#"+this.value+"-"+this.value+"").text()+'</option>');


                $("#"+this.value+"").remove();
                $("#"+this.value+"-"+this.value+"").text("");
                  $('checkbox[value="'+this.value+'"]').remove();
                

              }

          });
        });

       $(function(){
           $('#tipos_usuarios').on('change',function(){
                          var valor =  $('#tipos_usuarios option:selected').val();
                          (valor);

                          // alert(valor);


                          if(valor == "Comun"){
                            $('#region_trabajo').css('display','');
                            $('#label_region').css('display','');
                            $('#coord_remoto').css('display','');
                            $('#coord_tecnico').css('display','none');

                          }else if(valor == "remoto"){
                            $('#coord_remoto').css('display','none');
                            $('#coord_tecnico').css('display','');
                          } else{
                            $('#region_trabajo').css('display','none');
                            $('#label_region').css('display','none');

                          }

                          if(valor == "Coordinador" && valor != "Comun"){
                            $('#coord_remoto').css('display','inline-block');
                            $('#coord_tecnico').css('display','inline-block');
                            
                            
                          
                          }else{
                            $('#div_permisosExtras').css('display','none');

                          }


          });
      });
       </script>
<script>



  $(document).ready(function(){


    $('#save').click(function() {    //para guardar en el modal de comuna
        
        var regiones_modal = $("#regiones_modal").val()
        var  comunas_modal = $("#comunas_modal").val()
        //  alert(comunas_modal);
 
         agregar_comuna(regiones_modal,comunas_modal);
      })

    $("#nueva_comuna").click(function(){
        $('#modal_comuna').modal('show');
         //removemos el atributo de selecion
        $("#region_usuario").removeAttr("selected")
        //limpiamos las comunas_empresa
        $("#comuna_usuarios").empty();  
        //agregamos el select de escoger
        $("#region_persona option[value='escoger_persona']").attr("selected",true); 
        
});



    $('#region_usuario').change(function() {    
         buscar_comuna($("#region_usuario option:selected").val(),"#comuna_usuarios");  
        // alert("hols");
     })
// ************************RUT*****************************************
    //validar rut  
    $("#rut").change(function(){
      checkRut( $("#rut").val());
    });
    //agregar digito al rut
    $('#rut').on('input', function() {
      var valor = $("#rut").val().replace('.','');
     valor = valor.replace('-','');
     cuerpo = valor.slice(0,-1);
     dv = valor.slice(-1).toUpperCase();
     rut= cuerpo + '-'+ dv;
     $("#rut").val(rut);
     });

     
     $('#correo').change(function() {
    
      validarEmail($("#correo").val());
     });
  
  });

  function validarEmail(valor) {
  if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3,4})+$/.test(valor)){
  //  alert("La dirección de email " + valor + " es correcta.");
  console.log("listo");
  } else {
  //  alert("La dirección de email es incorrecta." + valor);
  //  $("#correo").val("");
  }
}


  function checkRut(rut) {
    // Despejar Puntos
    var valor = rut.replace('.','');
    // Despejar Guión
    valor = valor.replace('-','');
    
    // Aislar Cuerpo y Dígito Verificador
    cuerpo = valor.slice(0,-1);
    dv = valor.slice(-1).toUpperCase();
    
    // Formatear RUN
    rut.value = cuerpo + '-'+ dv
    
    // Si no cumple con el mínimo ej. (n.nnn.nnn)
    if(cuerpo.length < 7) { 
        alert("Rut Incorrecto");
        $("#rut").val('');
      }else{
    
    // Calcular Dígito Verificador
    suma = 0;
    multiplo = 2;
    
    // Para cada dígito del Cuerpo
    for(i=1;i<=cuerpo.length;i++) {
    
        // Obtener su Producto con el Múltiplo Correspondiente
        index = multiplo * valor.charAt(cuerpo.length - i);
        
        // Sumar al Contador General
        suma = suma + index;
        
        // Consolidar Múltiplo dentro del rango [2,7]
        if(multiplo < 7) { multiplo = multiplo + 1; } else { multiplo = 2; }
  
    }
    
    // Calcular Dígito Verificador en base al Módulo 11
    dvEsperado = 11 - (suma % 11);
    
    // Casos Especiales (0 y K)
    dv = (dv == 'K')?10:dv;
    dv = (dv == 0)?11:dv;
    
    // Validar que el Cuerpo coincide con su Dígito Verificador
    if(dvEsperado != dv) {
      alert("Rut incorrecto");
      $("#rut").val('');
    }
  }
  
}
  </script>
