<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGastosHistorialsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gastos_historials', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('titulo');
            $table->text('descripcion_pago');
            $table->integer('estado');
            $table->integer('estado_eliminado');
            $table->date('fecha_eliminado');
            $table->timestamp('fecha_registrado');
            $table->date('fecha_comprado');
            $table->double('total');	
            $table->unsignedBigInteger('id_trabajador'); // Relación 
            $table->foreign('id_trabajador')->references('id')->on('trabajadors');
            $table->unsignedBigInteger('id_sucursal'); // Relación 
            $table->foreign('id_sucursal')->references('id')->on('sucursals');
           	
          
            // $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gastos_historials');
    }
}
