<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGirosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('giros', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('derscripcion');
            $table->date('fecha_realizado');
            $table->string('total');
            $table->unsignedBigInteger('id_administrado'); // Relación 
            $table->foreign('id_administrado')->references('id')->on('administradors');
            $table->unsignedBigInteger('id_solicitud_reembolsos'); // Relación 
            $table->foreign('id_solicitud_reembolsos')->references('id')->on('solicitudes_reembolsos');
            $table->unsignedBigInteger('id_billetera'); // Relación 
            $table->foreign('id_billetera')->references('id')->on('billetera_virtuals');

            // $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('giros');
    }
}
