<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrabajadorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {


        Schema::create('billetera_virtuals', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('total_acumulado',30);
            $table->date('fecha_actualizado_acumulado');
            $table->string('total_gastos',30);
            $table->date('fecha_actualizado_gasto');

            // $table->timestamps();
        });
  Schema::create('administradors', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('estado');
            $table->unsignedBigInteger('id_persona'); // Relación 
            $table->foreign('id_persona')->references('id')->on('personas');
            $table->unsignedBigInteger('id_login'); // Relación 
            $table->foreign('id_login')->references('id')->on('users');
        });
        Schema::create('trabajadors', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('estado');
            $table->unsignedBigInteger('id_persona'); // Relación 
            $table->foreign('id_persona')->references('id')->on('personas');
            $table->unsignedBigInteger('id_login'); // Relación 
            $table->foreign('id_login')->references('id')->on('users');
            $table->unsignedBigInteger('id_billetera'); // Relación 
            $table->foreign('id_billetera')->references('id')->on('billetera_virtuals');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('billetera_virtuals');
        Schema::dropIfExists('administradors');
        Schema::dropIfExists('trabajadors');
    }
}
