<?php

namespace App\Http\Controllers\solicitudes;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
use Crypt;
use App;
use App\check_accesorios_servicios;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use App\direccion;
use App\persona;
use App\User;
use App\checklist_instalacions;
use App\fotos_checks_accesorios;
use App\fotos_checks_servicios;
use App\asignacion_solicitudes;
use App\Accesorios;
use Auth;
use Session;
use DB;
use DateTime;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Mail;
use App\Mail\TestMail;
use App\Mail\EmailAsignacion;
use App\Mail\correoPdfServicioFinalizadoRemoto;

use Illuminate\Support\Facades\Config;
use Carbon\Carbon;
use Illuminate\Support\Facades\Redirect;

class checkController extends Controller
{


public function envioCorreoAsignado($api_solicitudes){
    $arrayCorreos = [];




    array_push($arrayCorreos,"ariel@globati.com");
    array_push($arrayCorreos,"cristobal@globati.com");


     $getDataZona =  App\sla_zonas::select('horas')
    ->join("sla_des_zonas","sla_des_zonas.id","=","sla_zonas.id_tipo_zona")
    ->where("sla_des_zonas.descripcion","=",$api_solicitudes->zona_geoge)
    ->where("sla_zonas.tipo","=",$api_solicitudes->tipo_of_sinergy )
    ->get();

    Mail::to($arrayCorreos)->send(new EmailAsignacion($api_solicitudes,$getDataZona[0]->horas,"c"));

    return "ok";

}




    public function sendEmail($h_Inicio, $client, $contacto, $direccion, $comuna, $region, $tipoVisita, $descripcionCliente, $sc, $nSerie, $modelo, $contadorBn, $contadorC, $estadoOpcion, $estadoInstalacion, $observacionTecnico, $proveedor, $size, $idasig, $correo_contacto,$idProyecto= "",$idRemoto ="")
    {


        $correos_formularios =   App\admin_correos::select('correo')->where('estado', 0)->where("proyecto_asociado",$idProyecto)->where('proveedor', strtoupper($proveedor))->get();
        $resultadosArray = $correos_formularios->toArray();
        $concatenado = "";
        $arrayCorreos = [];

        array_push($arrayCorreos,"ariel@globati.com");
         array_push($arrayCorreos,"cristobal@globati.com");
         array_push($arrayCorreos,"jalfaro@synergy.cl");
         

         if ($correo_contacto != "") {
              array_push($arrayCorreos,$correo_contacto);

           }

        // foreach ($resultadosArray as $resultado) {
        //   //   $concatenado .= '"'.implode(',', $resultado).'"' . ',';
        //   array_push($arrayCorreos,implode(',', $resultado));
        // }

        // $envio  = "si";
        $details = [
            'hora_inicio' =>  $h_Inicio,
            'idRemoto' =>  $idRemoto,
            'cliente' => $client,
            'contacto' => $contacto,
            'direccion' => $direccion,
            'comuna' => $comuna,
            'region' => $region,
            'tipo_visita' => $tipoVisita,
            'descripcion_cliente' => $descripcionCliente,
            'sc' => $sc,
            'numero_serie' => $nSerie,
            'modelo' => $modelo,
            'contador_bn' => $contadorBn,
            'contador_color' => $contadorC,
            'estado_opcion' => $estadoOpcion,
            'estado_instalacion' => $estadoInstalacion,
            'observacion_tecnico' => $observacionTecnico,
            'proveedor' => $proveedor,
            'size' => $size,
            'idasig' => $idasig
        ];


        Mail::to($arrayCorreos)->send(new TestMail($details, $sc, $nSerie, $size,$idRemoto,$h_Inicio));



        return "ok";

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }
    public function verserviciosKyocera()
    {

        $Api_solicitudes = DB::table('api_solicitudes')
            //  ->Join('asignacion_solicitudes','asignacion_solicitudes.api_solicitudes_id','=','api_solicitudes.id')
            ->select(
                "api_solicitudes.dFechaCreacion",
                // 'asignacion_solicitudes.estado_externo',
                // 'asignacion_solicitudes.estado_interno',
                // api_solicitudes
                'api_solicitudes.fecha_asignado as fecha_asignada',
                'api_solicitudes.dFechaCreacion as fecha_recepcion',
                'api_solicitudes.sComuna',
                'api_solicitudes.sRegion',
                'api_solicitudes.sCliente',
                'api_solicitudes.sSC',
                'api_solicitudes.id',
                'api_solicitudes.sDireccion',
                'api_solicitudes.sSerie',
                'api_solicitudes.estado_interno',
                'api_solicitudes.estado_externo',
                'api_solicitudes.Smarca',
                'api_solicitudes.sProveedor',
                'api_solicitudes.zona_geoge',
                'api_solicitudes.id_solicitudes_remotas',


            )

            // ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
            ->orderBy('api_solicitudes.dFechaCreacion', 'DESC')

            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)
            ->paginate(150);


         $Api_solicitudes =    $this->agregarnuevoscamos($Api_solicitudes);

        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
            ->orderBy('personas.nombre_uno', 'asc')
            ->distinct()
            ->get();
        //Cargar Select Estado
        $carga_selectEstado = DB::table('api_solicitudes')
            ->select('api_solicitudes.estado_externo')
            ->orderBy('api_solicitudes.estado_externo', 'asc')
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)
            ->distinct()
            ->get();
        //Cargar Select Clientes
        $carga_selectClientes = DB::table('api_solicitudes')
            ->select('api_solicitudes.sCliente')
            ->orderBy('api_solicitudes.sCliente', 'asc')
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)

            ->distinct()
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('api_solicitudes')
            ->select('api_solicitudes.sRegion')
            ->where('api_solicitudes.sRegion', '!=', null)
            //->orderByRaw("CAST(api_solicitudes.sRegion as UNSIGNED) ASC")
            ->orderByRaw(DB::raw("FIELD(api_solicitudes.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)

            ->distinct()
            ->get();
        //Cargar Select Comuna
        $carga_selectComuna = DB::table('api_solicitudes')
            ->select('api_solicitudes.sComuna')
            ->orderBy('api_solicitudes.sComuna', 'asc')
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)

            ->distinct()
            ->get();

        //Cargar Select direccion
        $direccionTemporal = DB::table('api_solicitudes')
            ->select('api_solicitudes.sDireccion as descripcion_direccion')
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)

            ->distinct()
            ->get();

        $id_persona = "";
        $direccion = "";
        $sucursal = "";
        $sc = "";
        $serie = "";
        $comuna = "";
        $region = "";
        $estado = "";
        $cliente = "";




        return view('portal.vista_proveedor_servicio', compact('direccionTemporal', 'carga_selectComuna', 'carga_selectRegion', 'cliente', 'carga_selectClientes', 'carga_selectEstado', 'direccion', 'sucursal', 'sc', 'serie', 'comuna', 'region', 'estado', 'id_persona', 'tecnico', 'Api_solicitudes'));
    }


    public function agregarnuevoscamos($Api_solicitudes){
        // Ahora puedes recorrer $Api_solicitudes para agregar nuevos campos o transformar los existentes
                $Api_solicitudes->each(function ($item) {
                    // Ejemplo: Agregar un nuevo campo 'nuevo_campo'

                    $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                    ->where('solicitudes_remotas.id', $item->id_solicitudes_remotas)->get();

                    $GetFecha = App\solicitudes_remotas::select("solicitudes_remotas.fecha_finalizada")->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                ->where('solicitudes_remotas.id', $item->id_solicitudes_remotas)->get();

                $getDataSla = App\sla_zonas::calcularSlaZonas($identificador,"si",$GetFecha[0]->fecha_finalizada,$item->estado_interno);
                    // Ejemplo: Transformar un campo existente
                    // $item->fecha_asignada = Carbon\Carbon::parse($item->fecha_asignada)->format('Y-m-d');

                    // Puedes agregar más lógica aquí según tus necesidades
                    $item->minutosTotales = $getDataSla["minutosTotales"];
                    $item->tiempoTranscurrido = $getDataSla["tiempoTranscurrido"];
                    $item->minutos_restantes = $getDataSla["minutos_restantes"];

                    return $item;
                });
                return    $Api_solicitudes;
    }

    public function verserviciosKyocera__()
    {



        $Api_solicitudes = DB::table('api_solicitudes')
            ->Join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select(
                "api_solicitudes.dFechaCreacion",
                'api_solicitudes.fecha_asignado as fecha_asignada',
                'api_solicitudes.dFechaCreacion as fecha_recepcion',
                'api_solicitudes.sComuna',
                'api_solicitudes.sRegion',
                'api_solicitudes.sCliente',
                'api_solicitudes.sSC',
                'asignacion_solicitudes.id as idAsignacion',
                'api_solicitudes.sDireccion',
                'api_solicitudes.sSerie',
                'api_solicitudes.estado_interno',
                'api_solicitudes.estado_externo',
                'api_solicitudes.sProveedor',



            )

            ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
            ->where('asignacion_solicitudes.estado_externo', '=', Auth::user()->nombre_proveedor)
            ->get();

        //obtener trabajadores asociados a checklist
        $tecnico = DB::table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.estado', '=', '1')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.id')
            ->orderBy('personas.nombre_uno', 'asc')
            ->distinct()
            ->get();
        //Cargar Select Estado
        $carga_selectEstado = DB::table('api_solicitudes')
            ->select('api_solicitudes.estado_externo')
            ->orderBy('api_solicitudes.estado_externo', 'asc')
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)
            ->distinct()
            ->get();
        //Cargar Select Clientes
        $carga_selectClientes = DB::table('api_solicitudes')
            ->select('api_solicitudes.sCliente')
            ->orderBy('api_solicitudes.sCliente', 'asc')
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)

            ->distinct()
            ->get();

        //Cargar Select Region
        $carga_selectRegion = DB::table('api_solicitudes')
            ->select('api_solicitudes.sRegion')
            ->where('api_solicitudes.sRegion', '!=', null)
            //->orderByRaw("CAST(api_solicitudes.sRegion as UNSIGNED) ASC")
            ->orderByRaw(DB::raw("FIELD(api_solicitudes.sRegion,  1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17) ASC"))
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)

            ->distinct()
            ->get();
        //Cargar Select Comuna
        $carga_selectComuna = DB::table('api_solicitudes')
            ->select('api_solicitudes.sComuna')
            ->orderBy('api_solicitudes.sComuna', 'asc')
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)

            ->distinct()
            ->get();

        //Cargar Select direccion
        $direccionTemporal = DB::table('api_solicitudes')
            ->select('api_solicitudes.sDireccion as descripcion_direccion')
            ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor)

            ->distinct()
            ->get();


        $id_persona = "";
        $direccion = "";
        $sucursal = "";
        $sc = "";
        $serie = "";
        $comuna = "";
        $region = "";
        $estado = "";
        $cliente = "";
        return view('portal.vista_proveedor_servicio', compact('direccionTemporal', 'carga_selectComuna', 'carga_selectRegion', 'cliente', 'carga_selectClientes', 'carga_selectEstado', 'direccion', 'sucursal', 'sc', 'serie', 'comuna', 'region', 'estado', 'id_persona', 'tecnico', 'Api_solicitudes'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id, Request $request)
    {

        if (strtoupper($request->extadoexternozonas) == "SOLICITAR REPUESTOS") {

        return DB::transaction(function () use ($request, $id) {


                    $FechaHoraActual  = Carbon::now();
                    $FechaHoraActual = $FechaHoraActual->toDateTimeString();
                        // return $request."id:".$id;

                        $asignacion_banco_api_solis = App\asignacion_banco_api_solis::where('id_solicitud_remota', '=', $request->idsolicitudremota)->first();
                        $asignacion_banco_api_solis->estado = "asignado tecnico";
                        $asignacion_banco_api_solis->timestamps = false;
                        $asignacion_banco_api_solis->save();

                        $solicitudes_remotas = App\solicitudes_remotas::where('id', '=', $request->idsolicitudremota)->first();
                        $solicitudes_remotas->estado = "asignado tecnico";
                        $solicitudes_remotas->timestamps = false;
                        $solicitudes_remotas->save();


                        try {
                            // IDAPISOLICITUD
                                $id_solicitud = Crypt::decryptString($id);
                            } catch (DecryptException $e) {
                                //
                                return "No Puede Realizar Esta Accion";
                            }
                        $datos_trabajador = DB::table('trabajadors')
                    ->where('trabajadors.id_login', '=', Auth::user()->id)
                    ->get();

                    $id_tecnico = $request->tecnico;
                    $cambioTecnico = $request->cambioTecnico;

                    $info_tracker = DB::table('tracker')
                    ->where('tracker.tipo_tracker', '=', "servicios")
                    ->where('tracker.proyecto_id', '=', $request->proyectos)
                    ->get();

                    $FechaHoraActual  = Carbon::now();
                    $FechaHoraActual = $FechaHoraActual->toDateTimeString();

                    $api_solicitudes =  App\api_solicitudes::findOrfail($id_solicitud);
                    $api_solicitudes->tracker_idtracker = 12;
                    $api_solicitudes->estado_interno = "tarea_asignada";
                    $api_solicitudes->estado_externo = "ASIGNADO";
                    $api_solicitudes->fecha_asignado = $request->fecha_servicio;
                    $api_solicitudes->timestamps = false;
                    $api_solicitudes->save();

                    $solicitud = DB::table('api_solicitudes')
                        ->where('api_solicitudes.id', '=', $id_solicitud)
                        ->get();

                    $check_solicitud = new App\check_formulario_solicitudes;
                    $check_solicitud->descripcion = $solicitud[0]->sDescripcion;
                    $check_solicitud->numero_ot = $solicitud[0]->sSC;
                    $check_solicitud->nId_OT = $solicitud[0]->nId_OT;
                    $check_solicitud->sSC = $solicitud[0]->sSC;
                    $check_solicitud->sProveedor = $solicitud[0]->sProveedor;
                    $check_solicitud->sPrioridad = $solicitud[0]->sPrioridad;
                    $check_solicitud->dFecha = $solicitud[0]->dFecha;
                    $check_solicitud->sCliente = $solicitud[0]->sCliente;
                    $check_solicitud->sTelefono = $solicitud[0]->sTelefono;
                    $check_solicitud->sContacto = $solicitud[0]->sContacto;
                    $check_solicitud->sDireccion = $solicitud[0]->sDireccion;
                    $check_solicitud->sComuna = $solicitud[0]->sComuna;
                    $check_solicitud->sRegion = $solicitud[0]->sRegion;
                    $check_solicitud->sTipoLlamada = $solicitud[0]->sTipoLlamada;
                    $check_solicitud->sDescripcion = $solicitud[0]->sDescripcion;
                    $check_solicitud->sQR = $solicitud[0]->sQR;
                    $check_solicitud->sSerie = $solicitud[0]->sSerie;
                    $check_solicitud->sModelo = $solicitud[0]->sModelo;
                    $check_solicitud->sUbicacion = $solicitud[0]->sUbicacion;
                    $check_solicitud->dFecCre = $solicitud[0]->dFecCre;
                    $check_solicitud->sTipoContrato = $solicitud[0]->sTipoContrato;
                    $check_solicitud->nId_EstadoOT = $solicitud[0]->nId_EstadoOT;
                    $check_solicitud->dFechaEstadoOT = $solicitud[0]->dFechaEstadoOT;
                    $check_solicitud->nId_Tecnico = $solicitud[0]->nId_Tecnico;
                    $check_solicitud->sObs = $solicitud[0]->sObs;
                    $check_solicitud->dFechaFab = $solicitud[0]->dFechaFab;
                    $check_solicitud->dFechaCreacion = $solicitud[0]->dFechaCreacion;
                    $check_solicitud->dFechaModif = $solicitud[0]->dFechaModif;
                    $check_solicitud->bDeleted = $solicitud[0]->bDeleted;
                    $check_solicitud->sUsuario = $solicitud[0]->sUsuario;
                    $check_solicitud->equipos = $solicitud[0]->equipos;
                    $check_solicitud->Smarca = $solicitud[0]->Smarca;
                    $check_solicitud->ip = $api_solicitudes->sIP;


                    $check_solicitud->timestamps = false;
                    $check_solicitud->save();

                    $asignacion = new App\asignacion_solicitudes;
                    $asignacion->fecha = $request->fecha_servicio;

                    $asignacion->id_solicitud_remota =  $api_solicitudes->id_solicitudes_remotas;
                    $asignacion->numero_visita = $request->numero_visita;
                    $asignacion->estado_interno = "tarea_asignada";
                    $asignacion->estado_externo = "ASIGNADO";
                    $asignacion->api_solicitudes_id = $id_solicitud;
                    $asignacion->trabajadors_id = $id_tecnico;
                    $asignacion->check_formulario_solicitudes_id = $check_solicitud->id;
                    $asignacion->trabajadors_id_coordinadora = $datos_trabajador[0]->id;
                    $asignacion->fecha_asignacion = $FechaHoraActual;

                    $asignacion->timestamps = false;
                    $asignacion->save();


                        return redirect('home')->with('mensaje', 'Checklist Solicitud ASIGNADO');


        }, 5);
    }


        // EREASIGNAR
        if($request->reasignar == "si"){

            $FechaHoraActual  = Carbon::now();
                  $FechaHoraActual = $FechaHoraActual->toDateTimeString();
            // return $request."id:".$id;

             $asignacion_banco_api_solis = App\asignacion_banco_api_solis::where('id_solicitud_remota', '=', $request->idsolicitudremota)->first();
             $asignacion_banco_api_solis->estado = "asignado tecnico";
             $asignacion_banco_api_solis->timestamps = false;
             $asignacion_banco_api_solis->save();

             $solicitudes_remotas = App\solicitudes_remotas::where('id', '=', $request->idsolicitudremota)->first();
             $solicitudes_remotas->estado = "asignado tecnico";
             $solicitudes_remotas->timestamps = false;
             $solicitudes_remotas->save();


             try {
                // IDAPISOLICITUD
                     $id_solicitud = Crypt::decryptString($id);
                 } catch (DecryptException $e) {
                     //
                     return "No Puede Realizar Esta Accion";
                 }
            $datos_trabajador = DB::table('trabajadors')
           ->where('trabajadors.id_login', '=', Auth::user()->id)
           ->get();

           $id_tecnico = $request->tecnico;
           $cambioTecnico = $request->cambioTecnico;

           $info_tracker = DB::table('tracker')
           ->where('tracker.tipo_tracker', '=', "servicios")
           ->where('tracker.proyecto_id', '=', $request->proyectos)
           ->get();


           $api_solicitudes =  App\api_solicitudes::findOrfail($id_solicitud);
               $api_solicitudes->tracker_idtracker = 12;
              $api_solicitudes->tipo_asignacion_interna= 1;

           $api_solicitudes->estado_interno = "tarea_asignada";
           $api_solicitudes->asignado_aya = "NO";
           $api_solicitudes->estado_externo = "ASIGNADO";
           $api_solicitudes->fecha_asignado = $request->fecha_servicio;
           $api_solicitudes->timestamps = false;
           $api_solicitudes->save();

           $this->envioCorreoAsignado($api_solicitudes);


            // VAMOS A CONSULTAR SI EXISTE UNA SOLICITUD CREADA
            $lastAsignacion = asignacion_solicitudes::where('api_solicitudes_id', '=', $id_solicitud)->orderBy('id', 'desc')->first();

            if ($lastAsignacion !== null) {
                $lastAsignacion = $lastAsignacion->id;



                $asignacion = asignacion_solicitudes::where('id', '=', $lastAsignacion)->orderBy('id', 'desc')->first();
                    $asignacion->fecha = $request->fecha_servicio;
                    // $asignacion->numero_visita = $request->numero_visita;
                    $asignacion->estado_interno = "tarea_asignada";
                    $asignacion->estado_externo = "ASIGNADO";
                    $asignacion->trabajadors_id = $id_tecnico;
                    $asignacion->trabajadors_id_coordinadora = $datos_trabajador[0]->id;
                    $asignacion->fecha_asignacion = $FechaHoraActual;
                    $asignacion->timestamps = false;
                    $asignacion->save();
            } else {

            }

            return redirect('home')->with('mensaje', 'Checklist Solicitud Reasignado');





                    return redirect('home')->with('mensaje', 'Checklist Solicitud Reasignado');

        }


        // ASIGNAR



        return DB::transaction(function () use ($request, $id) {


            if ($request->has('idsolicitudremota') && $request->idsolicitudremota !== '' && $request->idsolicitudremota != 0) {

                         $asignacion_banco_api_solis = App\asignacion_banco_api_solis::where('id_solicitud_remota', '=', $request->idsolicitudremota)->first();
                         $asignacion_banco_api_solis->estado = "asignado tecnico";
                         $asignacion_banco_api_solis->timestamps = false;
                         $asignacion_banco_api_solis->save();
                         $solicitudes_remotas = App\solicitudes_remotas::where('id', '=', $request->idsolicitudremota)->first();
                         $solicitudes_remotas->estado = "asignado tecnico";
                         $solicitudes_remotas->timestamps = false;
                         $solicitudes_remotas->save();
            }

            // return  Auth::user()->id;
            $datos_trabajador = DB::table('trabajadors')
                ->where('trabajadors.id_login', '=', Auth::user()->id)
                ->get();

            $id_tecnico = $request->tecnico;
            $cambioTecnico = $request->cambioTecnico;

            //Estados
            //1 asginar
            //2 reasignar
            //3solicitud de repuestos
            //5 cerrado
            //    //return  $this->wsCambio_estado(1,$id_tecnico,212);

            try {
                $id_solicitud = Crypt::decryptString($id);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }

            if (!empty($cambioTecnico)) {
                $lastAsignacion = asignacion_solicitudes::where('api_solicitudes_id', '=', $id_solicitud)->orderBy('id', 'desc')->first();
                $lastAsignacion = $lastAsignacion->id;
                $cambioEstado = asignacion_solicitudes::where('id', '=', $lastAsignacion)->update(['estado_interno' => "CAMBIO_TECNICO", 'estado_externo' => "CAMBIO_TECNICO"]);
            }

            $rules = [
                'proyectos' => 'required',
                'tecnico' => 'required|max:10',
                'fecha_servicio' => 'required|max:30',
            ];

            $this->validate($request, $rules);

            $info_tracker = DB::table('tracker')
                ->where('tracker.tipo_tracker', '=', "servicios")
                ->where('tracker.proyecto_id', '=', $request->proyectos)
                ->get();

            if (count($info_tracker) == 0) {
                return redirect('ver_api_solicitudes')->with('mensaje', 'Error Conexión con WS Kyocera, Comunicarse con Soporte');
            }

            $FechaHoraActual  = Carbon::now();
            $FechaHoraActual = $FechaHoraActual->toDateTimeString();

            $api_solicitudes =  App\api_solicitudes::findOrfail($id_solicitud);
            $api_solicitudes->tracker_idtracker = 12;
            $api_solicitudes->estado_interno = "tarea_asignada";
            $api_solicitudes->estado_externo = "ASIGNADO";
            $api_solicitudes->fecha_asignado = $request->fecha_servicio;
            $api_solicitudes->timestamps = false;
            $api_solicitudes->save();

            $solicitud = DB::table('api_solicitudes')
                ->where('api_solicitudes.id', '=', $id_solicitud)
                ->get();

            $check_solicitud = new App\check_formulario_solicitudes;
            $check_solicitud->descripcion = $solicitud[0]->sDescripcion;
            $check_solicitud->numero_ot = $solicitud[0]->sSC;
            $check_solicitud->nId_OT = $solicitud[0]->nId_OT;
            $check_solicitud->sSC = $solicitud[0]->sSC;
            $check_solicitud->sProveedor = $solicitud[0]->sProveedor;
            $check_solicitud->sPrioridad = $solicitud[0]->sPrioridad;
            $check_solicitud->dFecha = $solicitud[0]->dFecha;
            $check_solicitud->sCliente = $solicitud[0]->sCliente;
            $check_solicitud->sTelefono = $solicitud[0]->sTelefono;
            $check_solicitud->sContacto = $solicitud[0]->sContacto;
            $check_solicitud->sDireccion = $solicitud[0]->sDireccion;
            $check_solicitud->sComuna = $solicitud[0]->sComuna;
            $check_solicitud->sRegion = $solicitud[0]->sRegion;
            $check_solicitud->sTipoLlamada = $solicitud[0]->sTipoLlamada;
            $check_solicitud->sDescripcion = $solicitud[0]->sDescripcion;
            $check_solicitud->sQR = $solicitud[0]->sQR;
            $check_solicitud->sSerie = $solicitud[0]->sSerie;
            $check_solicitud->sModelo = $solicitud[0]->sModelo;
            $check_solicitud->sUbicacion = $solicitud[0]->sUbicacion;
            $check_solicitud->dFecCre = $solicitud[0]->dFecCre;
            $check_solicitud->sTipoContrato = $solicitud[0]->sTipoContrato;
            $check_solicitud->nId_EstadoOT = $solicitud[0]->nId_EstadoOT;
            $check_solicitud->dFechaEstadoOT = $solicitud[0]->dFechaEstadoOT;
            $check_solicitud->nId_Tecnico = $solicitud[0]->nId_Tecnico;
            $check_solicitud->sObs = $solicitud[0]->sObs;
            $check_solicitud->dFechaFab = $solicitud[0]->dFechaFab;
            $check_solicitud->dFechaCreacion = $solicitud[0]->dFechaCreacion;
            $check_solicitud->dFechaModif = $solicitud[0]->dFechaModif;
            $check_solicitud->bDeleted = $solicitud[0]->bDeleted;
            $check_solicitud->sUsuario = $solicitud[0]->sUsuario;
            $check_solicitud->equipos = $solicitud[0]->equipos;
            $check_solicitud->Smarca = $solicitud[0]->Smarca;
            $check_solicitud->ip = $api_solicitudes->sIP;


            $check_solicitud->timestamps = false;
            $check_solicitud->save();

            $asignacion = new App\asignacion_solicitudes;
            $asignacion->fecha = $request->fecha_servicio;

            $asignacion->id_solicitud_remota =  $api_solicitudes->id_solicitudes_remotas;
            $asignacion->numero_visita = $request->numero_visita;
            $asignacion->estado_interno = "tarea_asignada";
            $asignacion->estado_externo = "ASIGNADO";
            $asignacion->api_solicitudes_id = $id_solicitud;
            $asignacion->trabajadors_id = $id_tecnico;
            $asignacion->check_formulario_solicitudes_id = $check_solicitud->id;
            $asignacion->trabajadors_id_coordinadora = $datos_trabajador[0]->id;
            $asignacion->fecha_asignacion = $FechaHoraActual;

            $asignacion->timestamps = false;
            $asignacion->save();

            $datosTrabajador2 = DB::table('trabajadors')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->where('trabajadors.id', '=', $id_tecnico)
                ->get();

            //obtener ssc de la instalacion


            // Modificar esado en webservice
            $nombreTecnico = $datosTrabajador2[0]->nombre_uno . " " . $datosTrabajador2[0]->apellido_uno;


            $estado = 1; //Finalizado
            $nombreTecnico = $nombreTecnico;
            $ssc = $solicitud[0]->sSC;
            $obs = "";
            $ent = "";
            $sal = "";
            $cont = "";
            $col = "";
            $t1 = 0;
            $t2 = 0;
            $t3 = 0;
            $rep = "";
            $estado_interno = "asignado";
            $idAsignacion = "";
           // $respuesta =  $this->wsCambio_estado($idAsignacion, $estado, $nombreTecnico, $ssc, $obs, $ent, $sal, $cont, $col, $t1, $t2, $t3, $rep, $estado_interno);
             $respuesta = "OK";


             $this->envioCorreoAsignado($api_solicitudes);



            if ($respuesta == "OK") {
                return redirect('home')->with('mensaje', 'Checklist Solicitud ASIGNADO');
            } else {
                return redirect('home')->with('mensaje', 'Checklist Solicitud ASIGNADO');
            }
        }, 5);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }
    public function solicitudes_asociados_proveedor(Request $r)
    {
        try {
            $idSolicitudServicio = Crypt::decryptString($r->id_solicitud);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $datos_asignacion = DB::table('asignacion_solicitudes')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_solicitudes.api_solicitudes_id', '=', $idSolicitudServicio)
            ->select('asignacion_solicitudes.finalizado_remoto','asignacion_solicitudes.id_solicitud_remota','asignacion_solicitudes.id', 'personas.nombre_uno', 'personas.apellido_uno', 'asignacion_solicitudes.estado_interno', 'asignacion_solicitudes.fecha')
            ->orderBy('asignacion_solicitudes.id', 'desc')
            ->get();

        $tbody = "";
        $i = 1;
        $totoal = count($datos_asignacion);
        $totoal = $totoal + 1;
        if (count($datos_asignacion) > 0) {
            foreach ($datos_asignacion as $row) {

                $j = $i++;

                $tbody .= "<tr>";
                $tbody .= "<td>" . $idSolicitudServicio . "</td>";
                $tbody .= "<td>" . ($totoal - $j) . "</td>";
                $tbody .= "<td> " . $row->nombre_uno . " " . $row->apellido_uno . "</td>";
                if ($row->estado_interno == "PENDIENTE" || $row->estado_interno == "PENDIENTE") {
                    $tbody .= '<td class="PENDIENTE">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "CANCELADO" || $row->estado_interno == "CANCELADO") {
                    $tbody .= '<td class="CANCELADO">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "REASIGNAR" || $row->estado_interno == "REASIGNAR") {
                    $tbody .= '<td class="CANCELADO">' . "REASIGNAR" . "</td>";
                } else if ($row->estado_interno == "FINALIZADO" || $row->estado_interno == "FINALIZADO") {
                    $tbody .= '<td class="FINALIZADO">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "ASIGNADO" || $row->estado_interno == "ASIGNADO") {
                    $tbody .= '<td class="ASIGNADO">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "REVISAR" || $row->estado_interno == "revisar") {
                    $tbody .= '<td class="revisado">' . "REVISAR" . "</td>";
                } else if ($row->estado_interno == "RECHAZADO" || $row->estado_interno == "RECHAZADO") {
                    $tbody .= '<td class="RECHAZADO">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "tarea_asignada" || $row->estado_interno == "Tarea_asignada") {
                    $tbody .= '<td class="PENDIENTE">' . "Tarea Asignada" . "</td>";
                } else {
                    $tbody .= '<td class="PENDIENTE">' . $row->estado_interno . "</td>";
                }

                //boton editar
                $tbody .= "<td>";
                $tbody .= '<a href="#" role="button" title="Editar">';
                $tbody .= "</a>";

                //boton historial para la coordinadora

                // <a class="btn-icon btn-icon-dd" href="{{route('generar.pdfProveedorServicios',Crypt::encryptString($los_datos->idAsignacion ?? ''))}}"><span class="material-icons-round">picture_as_pdf</span></a>

                // if ($row->estado_interno != "REVISAR" && $row->estado_interno != "revisar" && $row->estado_interno != "FINALIZADO" && $row->estado_interno && "FINALIZADO") {
                //boton finalizar



                if($row->finalizado_remoto == 0){
                    $tbody .= "<a target='_blank' href='" . route('generar.pdfProveedorServicios', Crypt::encryptString($row->id)) . "' role='button' title='Ver PDF'>";
                    $tbody .= "<span class='material-icons-round'>picture_as_pdf</span>";
                    $tbody .= "</a>";
                }else{
                    $tbody .= "<a target='_blank' href='" . route('go.pdfremoto', ['idremoto' => encrypt($row->id_solicitud_remota)]) . "' role='button' title='PDF'>";
                    $tbody .= "<span class='material-icons-round'>picture_as_pdf</span>";
                    $tbody .= "</a>";
                    // finalizado_remoto

                }

                // }

                $tbody .= "</td>";
                $tbody .= "</tr>";
            }
        } else {
            $tbody .= "<tr>";
            $tbody .= "<td>Sin Datos</td>";
            $tbody .= "</tr>";
        }

        return $tbody;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function solicitudes_asociados(Request $r)
    {
        try {
            $idSolicitudServicio = Crypt::decryptString($r->id_solicitud);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $datos_asignacion = DB::table('asignacion_solicitudes')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_solicitudes.api_solicitudes_id', '=', $idSolicitudServicio)
            ->select('id_solicitud_remota','asignacion_solicitudes.id', 'personas.nombre_uno', 'personas.apellido_uno', 'asignacion_solicitudes.estado_interno', 'asignacion_solicitudes.fecha')
            ->orderBy('asignacion_solicitudes.id', 'desc')
            ->get();

        $tbody = "";
        if (count($datos_asignacion) > 0) {
            foreach ($datos_asignacion as $row) {
                $tbody .= "<tr>";
                $tbody .= "<td>" . $idSolicitudServicio . "</td>";
                $tbody .= "<td>" . date('d-m-Y', strtotime($row->fecha)) . "</td>";
                $tbody .= "<td> " . $row->nombre_uno . " " . $row->apellido_uno . "</td>";
                if ($row->estado_interno == "PENDIENTE" || $row->estado_interno == "PENDIENTE") {
                    $tbody .= '<td class="PENDIENTE">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "CANCELADO" || $row->estado_interno == "CANCELADO") {
                    $tbody .= '<td class="CANCELADO">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "REASIGNAR" || $row->estado_interno == "REASIGNAR") {
                    $tbody .= '<td class="CANCELADO">' . "REASIGNAR" . "</td>";
                } else if ($row->estado_interno == "FINALIZADO" || $row->estado_interno == "FINALIZADO") {
                    $tbody .= '<td class="FINALIZADO">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "ASIGNADO" || $row->estado_interno == "ASIGNADO") {
                    $tbody .= '<td class="ASIGNADO">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "REVISAR" || $row->estado_interno == "revisar") {
                    $tbody .= '<td class="revisado">' . "REVISAR" . "</td>";
                } else if ($row->estado_interno == "RECHAZADO" || $row->estado_interno == "RECHAZADO") {
                    $tbody .= '<td class="RECHAZADO">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "tarea_asignada" || $row->estado_interno == "Tarea_asignada") {
                    $tbody .= '<td class="PENDIENTE">' . "Tarea Asignada" . "</td>";
                } else {
                    $tbody .= '<td class="PENDIENTE">' . $row->estado_interno . "</td>";
                }

                //boton editar
                $tbody .= "<td>";
                $tbody .= '<a href="#" role="button" title="Editar">';
                $tbody .= "</a>";

                //boton historial para la coordinadora
                $tbody .= "<a  target='_blank' href='" . route('go.ver_check_solicitud_cordinadora', Crypt::encryptString($row->id)) . "' role='button' title='REVISAR'>";
                $tbody .= "<img class='' src='" . asset('Botones/Botones/revisar_m.png') . "'   alt='' style='margin: 2px 0px'/>";
                $tbody .= "</a>";

                if ($row->estado_interno != "REVISAR" && $row->estado_interno != "revisar" && $row->estado_interno != "FINALIZADO" && $row->estado_interno && "FINALIZADO") {
                    //boton finalizar
                    $tbody .= "<a target='_blank' href='" . route('go.finalizamanualservicios', Crypt::encryptString($row->id)) . "' role='button' title='Finalizar Manual'>";
                    $tbody .= "<img  class='' src='" . asset('Botones/Botones/Finalizar_manual.png') . "'   alt='' style='margin: 2px 0px'/>";
                    $tbody .= "</a>";
                }
                $tbody .= "</td>";
                $tbody .= "</tr>";
            }
        } else {
            $tbody .= "<tr>";
            $tbody .= "<td>Sin Datos</td>";
            $tbody .= "</tr>";
        }

        return [

            "tbody" => $tbody,
            "id_solicitud_remota" => $datos_asignacion[0]->id_solicitud_remota,

        ];
    }

    public function asignar_check_servicios()
    {
        try {
            $idSolicitud = Crypt::decryptString($_GET['idSolicitud']);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->join('users', 'users.id', '=', 'trabajadors.id_login')
            ->where('trabajadors.estado', '=', '1')
            ->where('users.zona', '=', Auth::user()->zona)
            ->where('users.tipo_usuario', '=', 'trabajador')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id')
            ->orderby('personas.nombre_uno', 'ASC')

            ->get();

        $proyectos = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('proyectos.estado', '=', '1')
            ->where('proyectos.id', '!=', '1')
            ->where('clientes.razon_social', '=', 'SERVICIOS')
            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
            ->get();

        $servicio = DB::table('api_solicitudes')
            ->where('api_solicitudes.id', '=', $idSolicitud)
            ->get();

        $datos_asignacion = DB::table('asignacion_solicitudes')
            ->where('asignacion_solicitudes.api_solicitudes_id', '=', $idSolicitud)
            ->get();

        if (count($datos_asignacion) == 0) {
            $total_dias = 1;
        } else {
            $total_dias = count($datos_asignacion) + 1;
        }

        return view('solicitudes_servicios.asignar_solicitud_servicio', compact('total_dias', 'trabajadores', 'proyectos', 'servicio'));
    }
    public function asignar_check_servicios_sinvisita()
    {

        try {
            $idSolicitud = Crypt::decryptString($_GET['idSolicituds']);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->join('users', 'users.id', '=', 'trabajadors.id_login')
            ->where('trabajadors.estado', '=', '1')
            ->where('users.zona', '=', Auth::user()->zona)
            ->where('users.tipo_usuario', '=', 'trabajador')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id')
            ->get();

        $proyectos = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('proyectos.estado', '=', '1')
            ->where('proyectos.id', '!=', '1')
            // ->where('proyectos.nombre', '=', 'SERVICIOS')
            ->where('clientes.razon_social', '=', 'SERVICIOS')

            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
            ->get();

        $servicio = DB::table('api_solicitudes')
            ->where('api_solicitudes.id', '=', $idSolicitud)
            ->get();

        $datos_asignacion = DB::table('asignacion_solicitudes')
            ->where('asignacion_solicitudes.api_solicitudes_id', '=', $idSolicitud)
            ->orderby('asignacion_solicitudes.id', 'DESC')
            ->get();

        if (count($datos_asignacion) == 0) {
            $total_dias = 1;
        } else {
            $total_dias = $datos_asignacion[0]->numero_visita;
        }

        $cambioTecnico = "si";

        return view('solicitudes_servicios.asignar_solicitud_servicio', compact('total_dias', 'trabajadores', 'proyectos', 'servicio', 'cambioTecnico'));
    }

    public function ver_checklistservicio_coordinadora($idasig)
    {

        try {
            $id_asignacion = Crypt::decryptString($idasig);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $mi_asignacion = DB::table('asignacion_solicitudes')
            ->where('asignacion_solicitudes.id', '=', $id_asignacion)
            ->get();

        $id_trabajador = $mi_asignacion[0]->trabajadors_id;
        $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
        $trabajadors_id = $mi_asignacion[0]->trabajadors_id;
         $obtenerFechaIngreso = DB::table('api_solicitudes')
        ->where('api_solicitudes.id', '=', $idApiSolicitud)
        ->get();

     $fechaIngreso=  $obtenerFechaIngreso[0]->dFecha;

        $asignacion_solicitudes = DB::table('asignacion_solicitudes')
            ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_solicitudes.id', '=', $id_asignacion)
            ->orderBy('asignacion_solicitudes.id', 'desc')
            ->select(
                'asignacion_solicitudes.id as idAsig',
                'check_formulario_solicitudes.sComuna',
                'asignacion_solicitudes.fecha',
                'asignacion_solicitudes.estado_externo',
                'asignacion_solicitudes.url_firma',
                'check_formulario_solicitudes.sProveedor',
                'check_formulario_solicitudes.sRegion',
                'check_formulario_solicitudes.Smarca',

                'asignacion_solicitudes.fecha_asignacion',
                'asignacion_solicitudes.fecha_revision',

                'asignacion_solicitudes.estado_interno',
                'asignacion_solicitudes.estado_interno',
                'check_formulario_solicitudes.sDireccion',
                'check_formulario_solicitudes.sSerie',
                'check_formulario_solicitudes.sContacto',
                'check_formulario_solicitudes.sTelefono',
                'check_formulario_solicitudes.sModelo',
                'check_formulario_solicitudes.numero_ot',
                'check_formulario_solicitudes.contador_bn',
                'check_formulario_solicitudes.contador_color',
                'check_formulario_solicitudes.ip',
                'check_formulario_solicitudes.usb',
                'check_formulario_solicitudes.descripcion',
                'check_formulario_solicitudes.tipo_componente',
                'check_formulario_solicitudes.solicita_acessorios',
                'check_formulario_solicitudes.observaciones',
                'check_formulario_solicitudes.nombre_contacto_firma',
                'check_formulario_solicitudes.firma_contacto',
                'check_formulario_solicitudes.estado_seleccionado',
                'check_formulario_solicitudes.correo_contacto',
                'check_formulario_solicitudes.motivo_accesorio',
                'check_formulario_solicitudes.t_uno',
                'check_formulario_solicitudes.t_dos',
                'check_formulario_solicitudes.t_tres',
                'check_formulario_solicitudes.validador',
                'check_formulario_solicitudes.sCliente',
                'asignacion_solicitudes.fecha_inicio',
                'asignacion_solicitudes.fecha_fin',
                'asignacion_solicitudes.fecha_local',
                'asignacion_solicitudes.fecha_transito',
                'check_formulario_solicitudes.equipos'

            )
            ->get();

 //SLA Y DEPARTAMENTO
 $getDataApisol = DB::table('api_solicitudes')
 ->select("departamento","tipo_of_sinergy")
 ->where('api_solicitudes.id', '=', $idApiSolicitud)

 ->get();
        //datos del usuario
        $datosTrabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.id', '=', $trabajadors_id)
            ->get();
        $firmaTrabajador = DB::table('firma_clientes')
            ->where('id_tecnico', '=', $trabajadors_id)
            ->get();
        //obtener nombre del proyecto
        //tracket proyecto_id
        $apiSolicitud = DB::table('api_solicitudes')
            ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('api_solicitudes.id', '=', $idApiSolicitud)
            ->get();

        // tipo_equipamientos
        $tipo_equipamientos_dvRevelado = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "DV - UN Revelado(s)")
            ->get();

        $tipo_equipamientos_dkCilindro = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "DK - UN Cilindro(s)")
            ->get();

        $tipo_equipamientos_detalleEquipamiento = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "Detalle del equipamiento")
            ->get();

        $fotos = DB::table('fotos_checks_servicios')
            ->where('fotos_checks_servicios.id_servicios', '=', $id_asignacion)
            ->get();

        $acceDanos = DB::table('check_accesorios_danados_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_danados_servicios.id_accesorio')
            ->where('check_accesorios_danados_servicios.id_asig_serv', '=', $id_asignacion)
            ->get();
        $acceSoli = DB::table('check_accesorios_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_servicios.id_accesorio')

            ->where('check_accesorios_servicios.id_asig_servicio', '=', $id_asignacion)
            ->get();
        //estas son las tres imagenes
        $fotos_servicios_cheks = DB::table('fotos_servicios_cheks')
            ->where('fotos_servicios_cheks.checklist_asignacion_id', '=', $id_asignacion)
            ->get();

        $accesorios_manuales = DB::table('accesorios_manuales_servicios')
            ->where('id_checklist_instalacion', '=', $id_asignacion)
            ->get();

        $instalacion_accesorios = DB::table('checklist_instalacion_accesorios_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios_servicios.id_accesorio')
            ->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios_servicios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios_servicios.serie_parte')
            ->where('id_asig_servicio', '=', $id_asignacion)
            ->get();
        $instalacion_accesorios_manuales = DB::table('instalacion_accesorios_manuales_servicios')
            ->where('id_checklist_instalacion', '=', $id_asignacion)
            ->get();

        return view('solicitudes_servicios.ver_checklistservicio_coordinadora', compact('getDataApisol','idApiSolicitud','fechaIngreso','instalacion_accesorios', 'instalacion_accesorios_manuales', 'accesorios_manuales', 'datosTrabajador', 'apiSolicitud', 'fotos_servicios_cheks', 'acceSoli', 'acceDanos', 'fotos', 'tipo_equipamientos_detalleEquipamiento', 'tipo_equipamientos_dkCilindro', 'tipo_equipamientos_dvRevelado', 'asignacion_solicitudes', 'firmaTrabajador'));
    }
    public function InicarCheckSolicitudes(request $request)
    {

        try {
            $id_asignacion = Crypt::decryptString($request->idAsig);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }



        // return  $fotos_servicios_cheks;
        $mi_asignacion = DB::table('asignacion_solicitudes')
            ->where('asignacion_solicitudes.id', '=', $id_asignacion)
            ->get();


        $id_trabajador = $mi_asignacion[0]->trabajadors_id;
        $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
        $trabajadors_id = $mi_asignacion[0]->trabajadors_id;
        //datos del usuario
        $datosTrabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.id', '=', $trabajadors_id)
            ->get();

        $apiSolicitud = DB::table('api_solicitudes')
            ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('api_solicitudes.id', '=', $idApiSolicitud)
            ->get();

        $asignacion_solicitudes     = DB::table('asignacion_solicitudes')
            ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
            ->select(
                'asignacion_solicitudes.id as idAsig',
                'check_formulario_solicitudes.sComuna',
                'asignacion_solicitudes.fecha',
                'asignacion_solicitudes.estado_externo',
                'asignacion_solicitudes.url_firma',
                'check_formulario_solicitudes.sSC',
                'check_formulario_solicitudes.sProveedor',
                'asignacion_solicitudes.estado_interno',
                'check_formulario_solicitudes.sDireccion',
                'check_formulario_solicitudes.sSerie',
                'check_formulario_solicitudes.Smarca',

                'check_formulario_solicitudes.sContacto',
                'check_formulario_solicitudes.sTelefono',
                'check_formulario_solicitudes.sModelo',
                'check_formulario_solicitudes.sDescripcion',
                'check_formulario_solicitudes.sCliente',
                'check_formulario_solicitudes.equipos',
         /////cambio 4agosto

                'check_formulario_solicitudes.contador_bn',
                'check_formulario_solicitudes.contador_color',
                'check_formulario_solicitudes.ip',
                'check_formulario_solicitudes.usb',
                'check_formulario_solicitudes.t_uno',
                'check_formulario_solicitudes.t_dos',
                'check_formulario_solicitudes.t_tres',
                'check_formulario_solicitudes.motivo_accesorio',

                'check_formulario_solicitudes.nombre_contacto_firma',
                'check_formulario_solicitudes.correo_contacto',
                'check_formulario_solicitudes.firma_contacto',
                'check_formulario_solicitudes.observaciones',
                'check_formulario_solicitudes.solicita_acessorios'

            )
            ->where("asignacion_solicitudes.id", "=", $id_asignacion)
            ->get();

            $fotos_servicios_cheks = DB::table('fotos_servicios_cheks')
            ->where('fotos_servicios_cheks.checklist_asignacion_id', '=', $id_asignacion)
            ->get();

                //datos del usuario
        $datosTrabajador = DB::table('trabajadors')
        ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
        ->where('trabajadors.id', '=', $trabajadors_id)
        ->get();
    $firmaTrabajador = DB::table('firma_clientes')
        ->where('id_tecnico', '=', $trabajadors_id)
        ->get();

        $cantidad_fotos = count($fotos_servicios_cheks);
        $manual = "no";
         /////cambio 4agosto

        $acceSoli = DB::table('check_accesorios_servicios')
        ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_servicios.id_accesorio')

        ->where('check_accesorios_servicios.id_asig_servicio', '=', $id_asignacion)
        ->get();

          //estas son las tres imagenes
        $fotos_servicios_cheks = DB::table('fotos_servicios_cheks')
            ->where('fotos_servicios_cheks.checklist_asignacion_id', '=', $id_asignacion)
            ->get();

        $accesorios_manuales = DB::table('accesorios_manuales_servicios')
            ->where('id_checklist_instalacion', '=', $id_asignacion)
            ->get();

        $instalacion_accesorios = DB::table('checklist_instalacion_accesorios_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios_servicios.id_accesorio')
            ->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios_servicios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios_servicios.serie_parte')
            ->where('id_asig_servicio', '=', $id_asignacion)
            ->get();
        $instalacion_accesorios_manuales = DB::table('instalacion_accesorios_manuales_servicios')
            ->where('id_checklist_instalacion', '=', $id_asignacion)
            ->get();

            $acceDanos = DB::table('check_accesorios_danados_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_danados_servicios.id_accesorio')
            ->where('check_accesorios_danados_servicios.id_asig_serv', '=', $id_asignacion)
            ->get();
        // return view('check.asignar_checklist',compact('trabajadores','tipos_visitas','proyectos','api_instalaciones','total_dias'));
        //return $mi_asignacion;

  $idSolicitudRemota = $apiSolicitud[0]->id_solicitudes_remotas;

  $getDataSolRemota = App\solicitudes_remotas::where('id', '=', $idSolicitudRemota)->first();
  $comentarioCoordinador= $getDataSolRemota->comentario_coordinador;



        return view('solicitudes_servicios.iniciar_check_servicio', compact('comentarioCoordinador','firmaTrabajador','datosTrabajador','fotos_servicios_cheks','acceDanos','instalacion_accesorios_manuales','instalacion_accesorios','accesorios_manuales','fotos_servicios_cheks','acceSoli','manual', 'apiSolicitud', 'asignacion_solicitudes', 'cantidad_fotos'));
    }


    public function  finalizar_check_servicios(request $request, $id_asignacion)
    {

        return DB::transaction(function () use ($request, $id_asignacion) {

            try {
                $idAsignacion = Crypt::decryptString($id_asignacion);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }


            $lista = App\fotos_servicios_cheks::where('checklist_asignacion_id', $idAsignacion)->get();
            if (count($lista) == 0) {
                return back()->with('mensaje_error', 'Ingrese las fotos')->withInput($request->input());
            }
            $marca = $request->marca;

            $numeroOT = $request->numeroOT;
            $contadorBN = $request->contadorBN;
            $ContadorColor = $request->ContadorColor;
            $ip = $request->ip;
            $usb = $request->usb;
            $descripcionApiServicios = $request->descripcionApiServicios;

            //pueden ser on
            $maquina_b_n = $request->maquina_b_n;
            $maquina_color = $request->maquina_color;
            ////
            //color
            $lk = $request->lk;
            $desLK = $request->desLK;
            $cantidadLk = $request->cantidadLk;
            $parteLK = $request->parteLK;
            $snparteLK = $request->snparteLK;

            $fk = $request->fk;
            $desFK = $request->desFK;
            $CantidadFk = $request->CantidadFk;
            $parteFK = $request->parteFK;
            $snparteFK = $request->snparteFK;

            $K = $request->K;
            $desK = $request->desK;
            $CantidadK = $request->CantidadK;
            $parteK = $request->parteK;
            $snparteK = $request->snparteK;

            $c = $request->c;
            $desC = $request->desC;
            $CantidadC = $request->CantidadC;
            $parteC = $request->parteC;
            $snparteC = $request->snparteC;

            $m = $request->m;
            $desM = $request->desM;
            $CantidadM = $request->CantidadM;
            $parteM = $request->parteM;
            $snparteM = $request->snparteM;

            $y = $request->y;
            $desY = $request->desY;
            $CantidadY = $request->CantidadY;
            $parteY = $request->parteY;
            $snparteY = $request->snparteY;

            //CILINDRO
            $k2 = $request->k2;
            $desK2 = $request->desK2;
            $CantidadK_2 = $request->CantidadK_2;
            $parteK2 = $request->parteK2;
            $snparteK2 = $request->snparteK2;

            $c2 = $request->c2;
            $desC2 = $request->desC2;
            $CantidadC_2 = $request->CantidadC_2;
            $parteC2 = $request->parteC2;
            $snparteC2 = $request->snparteC2;

            $m2 = $request->m2;
            $desM2 = $request->desM2;
            $CantidadM_2 = $request->CantidadM_2;
            $parteM2 = $request->parteM2;
            $snparteM2 = $request->snparteM2;

            $y2 = $request->y2;
            $desY2 = $request->desY2;
            $CantidadY_2 = $request->CantidadY_2;
            $parteY2 = $request->parteY2;
            $snparteY2 = $request->snparteY2;

            //solicitar accesorios
            $accesorios_si = $request->accesorios_si;
            $accesorios_no = $request->accesorios_no;

            //MOTIVOSS
            //vidaUtil
            $motivo_1 = $request->motivo_1;
            //Garantia
            $motivo_2 = $request->motivo_2;
            //dañoUsuarios
            $motivo_3 = $request->motivo_3;

            //obsercaviones
            $obsercaviones = $request->obsercaviones;
            $no_firma_cliente = $request->no_firma_cliente;
            $estado_finalizado = $request->estado_finalizado;
            $nombre_contacto_firma = $request->contacto_firma;
            $contacto_correo = str_replace(" ", "", $request->contacto_correo);
            // el si, significa que viene checkeado, y eso quiere dercir que se niega a firmar
            if ($no_firma_cliente == "si") {
                $no_firma_cliente = "no";
            } else {
                $no_firma_cliente = "si";
                $validarFirma = DB::table('asignacion_solicitudes')
                    ->select('url_firma')
                    ->where('asignacion_solicitudes.id', '=', $idAsignacion)
                    ->get();
                $validarFirma = $validarFirma[0]->url_firma;
                if ($validarFirma == "" || $validarFirma == null) {
                    return back()->with('mensaje_error', 'Seleccione Cliente se niega a firmar')->withInput($request->input());
                }
            }

            //capturar los toner
            $t_uno = $request->t_uno;
            $t_dos = $request->t_dos;
            $t_tres = $request->t_tres;

            //accesorios
            $requiereAccesorio = "";
            $motivo = "";

            $observacion_manual = "";

            $manual = $request->manual;
            //tipo de componwnte
            $tipoComponente = "";


// return $request->accesorios_instalacion_mantener;
// return "";
            if ($request->has('accesorios_mantener') && $request->accesorios_mantener  === 'on') {

            }else
            {

                //eliminamos lo que hay en las tablas para no duplicar la informacion
                App\check_accesorios_servicios::where('id_asig_servicio',  $idAsignacion)->delete();
                App\check_accesorios_danados_servicios::where('id_asig_serv',  $idAsignacion)->delete();

                App\accesorios_manuales_servicios::where('id_checklist_instalacion',  $idAsignacion)->delete();
                            // $accesorios->id_checklist_instalacion = $idAsignacion;
                App\checklist_instalacion_accesorios_servicios::where('id_asig_servicio',  $idAsignacion)->delete();




                    if ($request->accesorios_si == "on") {
                        $requiereAccesorio = "si";
                        if ($request->motivo_1 != "" || $request->motivo_2 != "" || $request->motivo_3 != "") {
                            if ($request->motivo_1 != "") {
                                $motivo = "Fin de vida util";
                            } else if ($request->motivo_2 != "") {
                                $motivo = "Garantia";
                            } else if ($request->motivo_3 != "") {
                                $motivo = "Daño de usuario";
                            } else {
                                $motivo = "";
                            }
                        } else {
                            return back()->with('mensaje_error', 'Ingrese Motivo')->withInput($request->input());
                        }
                    } else {
                        $requiereAccesorio = "no";
                        $motivo = "";
                    }


                    if ($request->accesorios_instalacion_si == "on") {
                        if ($request->instalacion_accesorios_manual_si == "") {
                            if ($request->cantidad4 == "") {
                                return back()->with('mensaje_error', 'Ingrese accesorios instalados')->withInput($request->input());
                            }
                        }
                    }
                    //ACCESORIOS
                    if ($motivo == "Fin de vida util" || $motivo == "Daño de usuario") {
                        if ($request->accesorios_manual_si == "") {
                            if ($request->cantidad == "" && $request->cantidad2 == "") {
                                return back()->with('mensaje_error', 'Ingrese accessorios')->withInput($request->input());
                            }
                        }
                        if ($request->cantidad != "") {
                            for ($i = 0; $i < count($request->cantidad); $i++) {
                                $accesorios = new App\check_accesorios_servicios;
                                $accesorios->id_asig_servicio = $idAsignacion;
                                $accesorios->id_accesorio = $request->descripcion_accesorio[$i];
                                $accesorios->serie_parte = $request->serie_parte[$i];
                                $accesorios->cantidad = $request->cantidad[$i];
                                $accesorios->timestamps = false;
                                $accesorios->save();
                            }
                        }
                        if ($request->cantidad2 != "") {
                            for ($i = 0; $i < count($request->cantidad2); $i++) {
                                $accesorios = new App\check_accesorios_danados_servicios;
                                $accesorios->id_asig_serv     = $idAsignacion;
                                $accesorios->id_accesorio = $request->descripcion_accesorio2[$i];
                                $accesorios->serie_parte = $request->serie_parte2[$i];
                                $accesorios->cantidad = $request->cantidad2[$i];
                                $accesorios->timestamps = false;
                                $accesorios->save();
                            }
                        }
                        if ($request->accesorios_manual_si == "on") {
                            for ($i = 0; $i < count($request->cantidad3); $i++) {
                                $accesorios = new App\accesorios_manuales_servicios;
                                $accesorios->id_checklist_instalacion = $idAsignacion;
                                $accesorios->nombre_parte = $request->nombre_pieza3[$i];
                                $accesorios->numero_parte = $request->numero_parte3[$i];
                                $accesorios->serie_parte = $request->serie_parte3[$i];
                                $accesorios->cantidad = $request->cantidad3[$i];
                                $accesorios->observacion = $request->observacion3[$i];
                                $accesorios->timestamps = false;
                                $accesorios->save();

                                $observacion_manual .= $request->nombre_pieza3[$i] . ' ' . $request->numero_parte3[$i] . ' ' . $request->cantidad3[$i] . '
                                ';
                            }
                        }
                    }

                    if ($motivo == "Garantia") {
                        if ($request->accesorios_manual_si == "") {
                            if ($request->cantidad == "") {
                                return back()->with('mensaje_error', 'Ingrese Acessorios')->withInput($request->input());
                            }
                        }
                        if ($request->cantidad != "") {
                            for ($i = 0; $i < count($request->cantidad); $i++) {
                                $accesorios = new App\check_accesorios_servicios;
                                $accesorios->id_asig_servicio = $idAsignacion;
                                $accesorios->id_accesorio = $request->descripcion_accesorio[$i];
                                $accesorios->serie_parte = $request->serie_parte[$i];
                                $accesorios->cantidad = $request->cantidad[$i];
                                $accesorios->timestamps = false;
                                $accesorios->save();
                            }
                        }
                        if ($request->accesorios_manual_si == "on") {
                            for ($i = 0; $i < count($request->cantidad3); $i++) {
                                $accesorios = new App\accesorios_manuales_servicios;
                                $accesorios->id_checklist_instalacion = $idAsignacion;
                                $accesorios->nombre_parte = $request->nombre_pieza3[$i];
                                $accesorios->numero_parte = $request->numero_parte3[$i];
                                $accesorios->serie_parte = $request->serie_parte3[$i];
                                $accesorios->cantidad = $request->cantidad3[$i];
                                $accesorios->observacion = $request->observacion3[$i];
                                $accesorios->timestamps = false;
                                $accesorios->save();
                            }
                        }
                    }
            } //fin del if de los acessorios de arriba
                //Se instalan los accesorios

        if ($request->has('accesorios_instalacion_mantener') && $request->accesorios_mantener  === 'on') {

        }else
        {



                if ($request->accesorios_instalacion_si == "on") {

                    if ($request->cantidad4 != "") {
                        for ($i = 0; $i < count($request->cantidad4); $i++) {
                            $accesorios = new App\checklist_instalacion_accesorios_servicios;
                            $accesorios->id_asig_servicio = $idAsignacion;
                            $accesorios->id_accesorio = $request->descripcion_accesorio4[$i];
                            $accesorios->serie_parte = $request->serie_parte4[$i];
                            $accesorios->cantidad = $request->cantidad4[$i];
                            $accesorios->timestamps = false;
                            $accesorios->save();
                        }
                    }
                    if ($request->instalacion_accesorios_manual_si == "on") {
                        for ($i = 0; $i < count($request->cantidad5); $i++) {
                            $accesorios = new App\instalacion_accesorios_manuales_servicios;
                            $accesorios->id_checklist_instalacion = $idAsignacion;
                            $accesorios->nombre_parte = $request->nombre_pieza5[$i];
                            $accesorios->numero_parte = $request->numero_parte5[$i];
                            $accesorios->serie_parte = $request->serie_parte5[$i];
                            $accesorios->cantidad = $request->cantidad5[$i];
                            $accesorios->observacion = $request->observacion5[$i];
                            $accesorios->timestamps = false;
                            $accesorios->save();
                        }
                    }
                }


                //insercion al tipo de maquina
                if ($request->componentes_si == "on") {
                    if ($maquina_b_n == "on") {
                        $tipoComponente = "blanco y negro";
                        // n-sn
                        // Detalle del equipamiento
                        $this->insertarDatos("bn", "fk", "Detalle del equipamiento", $fk, $desFK, $CantidadFk, $idAsignacion, $parteFK, $snparteFK);
                        //  DV - UN Revelado(s)
                        $this->insertarDatos("bn", "k", "DV - UN Revelado(s)", $K, $desK, $CantidadK, $idAsignacion, $parteK, $snparteK);
                        // DK - UN Cilindro(s)
                        $this->insertarDatos("bn", "k", "DK - UN Cilindro(s)", $k2, $desK2, $CantidadK_2, $idAsignacion, $parteK2, $snparteK2);
                    } else if ($maquina_color == "on") {
                        // Detalle del equipamiento
                        $this->insertarDatos("color", "fk", "Detalle del equipamiento", $fk, $desFK, $CantidadFk, $idAsignacion, $parteFK,  $snparteFK);
                        $this->insertarDatos("color", "lk", "Detalle del equipamiento", $lk, $desLK, $cantidadLk, $idAsignacion, $parteLK,  $snparteLK);
                        //  DV - UN Revelado(s)
                        $this->insertarDatos("color", "K", "DV - UN Revelado(s)", $K, $desK, $CantidadK, $idAsignacion, $parteK, $snparteK);
                        $this->insertarDatos("color", "c", "DV - UN Revelado(s)", $c, $desC, $CantidadC, $idAsignacion, $parteC, $snparteC);
                        $this->insertarDatos("color", "m", "DV - UN Revelado(s)", $m, $desM, $CantidadM, $idAsignacion, $parteM, $snparteM);
                        $this->insertarDatos("color", "y", "DV - UN Revelado(s)", $y, $desY, $CantidadY, $idAsignacion, $parteY, $snparteY);
                        //  DK - UN Cilindro(s)
                        $this->insertarDatos("color", "K", "DK - UN Cilindro(s)", $k2, $desK2, $CantidadK_2, $idAsignacion, $parteK2, $snparteK2);
                        $this->insertarDatos("color", "c", "DK - UN Cilindro(s)", $c2, $desC2, $CantidadC_2, $idAsignacion, $parteC2, $snparteC2);
                        $this->insertarDatos("color", "m", "DK - UN Cilindro(s)", $m2, $desM2, $CantidadM_2, $idAsignacion, $parteM2, $snparteM2);
                        $this->insertarDatos("color", "y", "DK - UN Cilindro(s)", $y2, $desY2, $CantidadY_2, $idAsignacion, $parteY2, $snparteY2);

                        $tipoComponente = "color";
                    } else {
                    }
                }

        }


            $asignacion_solicitudes = DB::table('asignacion_solicitudes')
                ->where('asignacion_solicitudes.id', '=', $idAsignacion)
                ->get();
            $check_formulario_solicitudes_id =  $asignacion_solicitudes[0]->check_formulario_solicitudes_id;
            $api_solicitudes_id =  $asignacion_solicitudes[0]->api_solicitudes_id;

            // //modificar el estado
            $checkFormulario =  App\check_formulario_solicitudes::findOrfail($check_formulario_solicitudes_id);
            $checkFormulario->numero_ot = $numeroOT;
            $checkFormulario->Smarca = $marca;

            $checkFormulario->contador_bn = $contadorBN;
            $checkFormulario->contador_color = $ContadorColor;
            $checkFormulario->ip = $ip;
            $checkFormulario->usb = $usb;
            $checkFormulario->descripcion = $descripcionApiServicios;

            if ($request->has('accesorios_mantener') && $request->accesorios_mantener  === 'on') {
            }else{
            $checkFormulario->solicita_acessorios = $requiereAccesorio;
            $checkFormulario->motivo_accesorio = $motivo;


            }
            $checkFormulario->tipo_componente = $tipoComponente;
            $checkFormulario->observaciones = $observacion_manual . $obsercaviones;
            $checkFormulario->nombre_contacto_firma =  $nombre_contacto_firma;
            $checkFormulario->correo_contacto =  $contacto_correo;
            $checkFormulario->firma_contacto = $no_firma_cliente;
            $checkFormulario->estado_seleccionado = $estado_finalizado;
            $checkFormulario->t_uno = $t_uno;
            $checkFormulario->t_dos = $t_dos;
            $checkFormulario->t_tres = $t_tres;
            $checkFormulario->validador = $request->validador;
            $checkFormulario->timestamps = false;
            $checkFormulario->save();

            $mi_asignacion = DB::table('asignacion_solicitudes')
                ->where('asignacion_solicitudes.id', '=', $idAsignacion)
                ->get();

            $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
            $trabajadors_id = $mi_asignacion[0]->trabajadors_id;

            $FechaHoraActual  = Carbon::now();
            $FechaHoraActual = $FechaHoraActual->toDateTimeString();
            //modificar el estado
            $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($idAsignacion);
            $asigSolicitudes->estado_interno = "REVISAR";
            $asigSolicitudes->estado_externo  = "VISITA TERMINADA";
            $asigSolicitudes->finalizado_manual  = $manual;
            $asigSolicitudes->fecha_fin = $FechaHoraActual;
            $asigSolicitudes->timestamps = false;
            $asigSolicitudes->save();


            $FechaHoraActual  = Carbon::now();
            $FechaHoraActual = $FechaHoraActual->toDateTimeString();
            //modificar el estado
            //modificar el estado
            $api_solicitudes =  App\api_solicitudes::findOrfail($idApiSolicitud);
            $api_solicitudes->fecha_estado = Carbon::now()->toDateString();
            $api_solicitudes->estado_interno = "REVISAR";
            // $api_solicitudes->fecha_finalizada_tecnico = Carbon::now()->toDateString();
        $api_solicitudes->fecha_finalizada_tecnico = $FechaHoraActual;


            $api_solicitudes->estado_externo = "VISITA TERMINADA";
            $api_solicitudes->timestamps = false;
            $api_solicitudes->save();



            $FechaHoraActual  = Carbon::now();
            $FechaHoraActual = $FechaHoraActual->toDateTimeString();


            $solicitudes_remotas = App\solicitudes_remotas::where('id', '=', $api_solicitudes->id_solicitudes_remotas)->first();
            $solicitudes_remotas->estado = "Revision por Cordinador";
            $solicitudes_remotas->fecha_finalizada = $FechaHoraActual;

            $solicitudes_remotas->timestamps = false;
            $solicitudes_remotas->save();

            //datos del usuario
            $datosTrabajador = DB::table('trabajadors')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->where('trabajadors.id', '=', $trabajadors_id)
                ->get();

            //obtener ssc de la instalacion
            $api_solicitudes = DB::table('api_solicitudes')
                ->where('api_solicitudes.id', '=', $idApiSolicitud)
                ->get();

            // Modificar esado en webservice
            $nombreTecnico = $datosTrabajador[0]->nombre_uno . " " . $datosTrabajador[0]->apellido_uno;
            $ssc = $api_solicitudes[0]->sSC;
            $estado_interno   = "REVISAR";
            $this->cambio_estado_interno($nombreTecnico, $ssc, $estado_interno, "");

            return redirect('chekstecnicoservcios')->with('mensaje', 'Checklist Actualizado');
        }, 5);
    }

    public function insertarDatos($opcion_color_bn, $tipo, $opcion, $serie, $descripcion, $cantidad, $id_asig, $numero_parte, $sn_parte)
    {

        $tipo_equipamientos = new App\tipo_equipamientos;

        $tipo_equipamientos->opcion_color_bn = $opcion_color_bn;
        $tipo_equipamientos->tipo = $tipo;
        $tipo_equipamientos->opcion = $opcion;
        $tipo_equipamientos->descripcion = $descripcion;
        $tipo_equipamientos->cantidad = $cantidad;
        $tipo_equipamientos->id_asig = $id_asig;
        $tipo_equipamientos->serie = $serie;
        $tipo_equipamientos->numero_parte = $numero_parte;
        $tipo_equipamientos->sn_parte = $sn_parte;
        $tipo_equipamientos->timestamps = false;
        $tipo_equipamientos->save();
    }

    public function iniciar_check_servicio_transito($id_asignacion)
    {


        return DB::transaction(function () use ($id_asignacion) {

            try {
                $idAsignacion = Crypt::decryptString($id_asignacion);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }

            $asignacion_solicitudes = DB::table('asignacion_solicitudes')
                ->where('asignacion_solicitudes.id', '=', $idAsignacion)
                ->get();

            $FechaHoraActual  = Carbon::now();
            $FechaHoraActual = $FechaHoraActual->toDateTimeString();
            $idSolicitudApi =  $asignacion_solicitudes[0]->api_solicitudes_id;
            $trabajadors_id = $asignacion_solicitudes[0]->trabajadors_id;
            //modificar el estado
            $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($idAsignacion);
            $asigSolicitudes->fecha_transito = $FechaHoraActual;
            $asigSolicitudes->estado_externo = "EN TRANSITO";
            $asigSolicitudes->timestamps = false;
            $asigSolicitudes->save();

            $this->modificarEsadoApiServicio($idSolicitudApi, "EN TRANSITO", 1);

            //datos del usuario
            $datosTrabajador = DB::table('trabajadors')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->where('trabajadors.id', '=', $trabajadors_id)
                ->get();

            //obtener ssc de la instalacion
            $api_solicitudes = DB::table('api_solicitudes')
                ->where('api_solicitudes.id', '=', $idSolicitudApi)
                ->get();

            // Modificar esado en webservice
            $nombreTecnico = $datosTrabajador[0]->nombre_uno . " " . $datosTrabajador[0]->apellido_uno;
            $ssc = $api_solicitudes[0]->sSC;
            $estado_interno   = "EN TRANSITO";
            $this->cambio_estado_interno($nombreTecnico, $ssc, $estado_interno, "");

            return back()->with('mensaje', 'Tecnico en transito');
        }, 5);
    }
    public function iniciar_check_servicio_espera($id_asignacion)
    {

        return DB::transaction(function () use ($id_asignacion) {
            try {
                $idAsignacion = Crypt::decryptString($id_asignacion);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }
            $FechaHoraActual  = Carbon::now();
            $FechaHoraActual = $FechaHoraActual->toDateTimeString();
            $asignacion_solicitudes = DB::table('asignacion_solicitudes')
                ->where('asignacion_solicitudes.id', '=', $idAsignacion)
                ->get();
            $idSolicitudApi =  $asignacion_solicitudes[0]->api_solicitudes_id;

            //modificar el estado
            $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($idAsignacion);
            //   $asigSolicitudes->fecha_inicio	 = $FechaHoraActual;
            $asigSolicitudes->estado_interno = "EN ESPERA";
            $asigSolicitudes->timestamps = false;
            $asigSolicitudes->save();

            return back()->with('mensaje', 'Tecnico en espera');
        }, 5);
    }
    public function iniciar_check_servicio($id_asignacion)
    {

        return DB::transaction(function () use ($id_asignacion) {
            try {
                $idAsignacion = Crypt::decryptString($id_asignacion);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }

            $asignacion_solicitudes = DB::table('asignacion_solicitudes')
                ->where('asignacion_solicitudes.id', '=', $idAsignacion)
                ->get();
            $FechaHoraActual  = Carbon::now();
            $FechaHoraActual = $FechaHoraActual->toDateTimeString();
            $idSolicitudApi =  $asignacion_solicitudes[0]->api_solicitudes_id;
            $trabajadors_id = $asignacion_solicitudes[0]->trabajadors_id;
            //modificar el estado
            $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($idAsignacion);
            $asigSolicitudes->estado_interno = "INICIADO";
            $asigSolicitudes->estado_externo = "INICIADO";
            $asigSolicitudes->fecha_inicio = $FechaHoraActual;
            $asigSolicitudes->timestamps = false;
            $asigSolicitudes->save();



            $this->modificarEsadoApiServicio($idSolicitudApi, "INICIADO", 2);

            //datos del usuario
            $datosTrabajador = DB::table('trabajadors')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->where('trabajadors.id', '=', $trabajadors_id)
                ->get();

            //obtener ssc de la instalacion
            $api_solicitudes = DB::table('api_solicitudes')
                ->where('api_solicitudes.id', '=', $idSolicitudApi)
                ->get();

            // Modificar esado en webservice
            $nombreTecnico = $datosTrabajador[0]->nombre_uno . " " . $datosTrabajador[0]->apellido_uno;
            $ssc = $api_solicitudes[0]->sSC;
            $estado_interno   = "INICIADO";
            $this->cambio_estado_interno($nombreTecnico, $ssc, $estado_interno, "");

            return back()->with('mensaje', 'Check Iniciado');
        }, 5);
    }

    public function iniciar_check_servicio_en_transito(request $request)
    {

        return DB::transaction(function () use ($request) {
            try {
                $idAsignacion = Crypt::decryptString($request->idAsig);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }
            $FechaHoraActual  = Carbon::now();
            $FechaHoraActual = $FechaHoraActual->toDateTimeString();

            $asignacion_solicitudes = DB::table('asignacion_solicitudes')
                ->where('asignacion_solicitudes.id', '=', $idAsignacion)
                ->get();
            $idSolicitudApi =  $asignacion_solicitudes[0]->api_solicitudes_id;
            $trabajadors_id = $asignacion_solicitudes[0]->trabajadors_id;
            //modificar el estado
            $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($idAsignacion);
            $asigSolicitudes->estado_externo = "EN TRANSITO";
            $asigSolicitudes->fecha_transito = $FechaHoraActual;

            $asigSolicitudes->timestamps = false;
            $asigSolicitudes->save();



            $this->modificarEsadoApiServicio($idSolicitudApi, "EN TRANSITO", 1);


            //datos del usuario
            $datosTrabajador = DB::table('trabajadors')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->where('trabajadors.id', '=', $trabajadors_id)
                ->get();

            //obtener ssc de la instalacion
            $api_solicitudes = DB::table('api_solicitudes')
                ->where('api_solicitudes.id', '=', $idSolicitudApi)
                ->get();

            // Modificar esado en webservice
            $nombreTecnico = $datosTrabajador[0]->nombre_uno . " " . $datosTrabajador[0]->apellido_uno;
            $ssc = $api_solicitudes[0]->sSC;
            $estado_interno   = "EN TRANSITO";
            $this->cambio_estado_interno($nombreTecnico, $ssc, $estado_interno, "");


            return back()->with('mensaje', 'Check en transito');
        }, 5);
    }
    public function iniciar_check_servicio_en_espera(request $request)
    {

        return DB::transaction(function () use ($request) {

            try {
                $idAsignacion = Crypt::decryptString($request->idAsig);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }

            $asignacion_solicitudes = DB::table('asignacion_solicitudes')
                ->where('asignacion_solicitudes.id', '=', $idAsignacion)
                ->get();
            $idSolicitudApi =  $asignacion_solicitudes[0]->api_solicitudes_id;
            $trabajadors_id = $asignacion_solicitudes[0]->trabajadors_id;
            $FechaHoraActual  = Carbon::now();
            $FechaHoraActual = $FechaHoraActual->toDateTimeString();

            //modificar el estado
            $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($idAsignacion);
            $asigSolicitudes->estado_externo = "ESPERANDO";
            $asigSolicitudes->fecha_local     = $FechaHoraActual;
            $asigSolicitudes->timestamps = false;
            $asigSolicitudes->save();

            $this->modificarEsadoApiServicio($idSolicitudApi, "EN ESPERA", 1);

            //datos del usuario
            $datosTrabajador = DB::table('trabajadors')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->where('trabajadors.id', '=', $trabajadors_id)
                ->get();

            //obtener ssc de la instalacion
            $api_solicitudes = DB::table('api_solicitudes')
                ->where('api_solicitudes.id', '=', $idSolicitudApi)
                ->get();

            // Modificar esado en webservice
            $nombreTecnico = $datosTrabajador[0]->nombre_uno . " " . $datosTrabajador[0]->apellido_uno;
            $ssc = $api_solicitudes[0]->sSC;
            $estado_interno   = "EN ESPERA";
            $this->cambio_estado_interno($nombreTecnico, $ssc, $estado_interno, $asigSolicitudes->fecha_local);

            return back()->with('mensaje', 'Check en espera');
        }, 5);
    }
    // para guardar las fotos
    public function funguardandofotosservicios(request $request)
    {


        //echo '<img src="'.$request->imagen_firma.'" border="1">';
        return DB::transaction(function () use ($request) {

            if (isset($request->imagen_firma)) {

                // mostrar la imagen



                try {
                    $idAsignacion = Crypt::decryptString($request->check);
                } catch (DecryptException $e) {
                    //
                    return "No Puede Realizar Esta Accion";
                }

                $nombre_guardar = "firmacheckservicios" . $idAsignacion . ".png";

                // echo '<img src="'.$request->imagen_firma.'" border="1">';

                // funcion para gusrfdar la imagen base64 en el servidor
                // el nombre debe tener la extension
                function uploadImgBase64($base64, $name)
                {


                    $datosBase64 = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $base64));
                    //optimixar para poder subir imagenes
                    $path = $_SERVER['DOCUMENT_ROOT'] . '/sistema/rendicion/fotos/fotos_firmas/' . $name;
                    // guardamos la imagen en el server
                    if (!file_put_contents($path, $datosBase64)) {
                        // retorno si falla
                        return "0";
                    } else {
                        // retorno si todo fue bien
                        return "1";
                    }
                }
                // llamamos a la funcion uploadImgBase64( img_base64, nombre_fina.png)
                $resultado = uploadImgBase64($request->imagen_firma, $nombre_guardar);


                if ($resultado == "0") {
                    return "Intente nuevamente";
                } else {

                    $asignacion_solicitudes =  App\asignacion_solicitudes::findOrfail($idAsignacion);
                    $asignacion_solicitudes->url_firma = "fotos_firmas/" . $nombre_guardar;
                    $asignacion_solicitudes->timestamps = false;
                    $asignacion_solicitudes->save();
                    return "Firma Guardada con Exito";
                }
            } else {

                return "Intente Nuevamente";
            }
        }, 5);
    }

    public function save_imagen_servicios(request $request)
    {
        // $deletedRows = App\fotos_checks_servicios::where('id_servicios', $request->idAsig)->delete();
        return DB::transaction(function () use ($request) {
            $numeroRandom = rand();

            //foto1
            if ($request->file('cargafotoa1') != "") {
                $file = $request->file('cargafotoa1');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                //sacamos la exxtencion por medio de _
                $extencionArray = explode("_", $extencion);
                $nombreGuardar1 = "fa1_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));

                $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fa1_".'%')->where("id_servicios","=",$request->idAsig)->delete();

                $fotos_check_instalacions = new App\fotos_checks_servicios;
                $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
                $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
                $fotos_check_instalacions->id_servicios   = $request->idAsig;
                $fotos_check_instalacions->timestamps = false;
                $fotos_check_instalacions->save();
            }
            //foto2
            if ($request->file('cargafotoa2') != "") {
                $file = $request->file('cargafotoa2');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                //sacamos la exxtencion por medio de _
                $extencionArray = explode("_", $extencion);
                $nombreGuardar1 = "fa2_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
                $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fa2_".'%')->where("id_servicios","=",$request->idAsig)->delete();

                $fotos_check_instalacions = new App\fotos_checks_servicios;
                $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
                $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
                $fotos_check_instalacions->id_servicios   = $request->idAsig;
                $fotos_check_instalacions->timestamps = false;
                $fotos_check_instalacions->save();
            }
            //foto3
            if ($request->file('cargafotoa3') != "") {
                $file = $request->file('cargafotoa3');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                //sacamos la exxtencion por medio de _
                $extencionArray = explode("_", $extencion);
                $nombreGuardar1 = "fa3_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
                $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fa3_".'%')->where("id_servicios","=",$request->idAsig)->delete();

                $fotos_check_instalacions = new App\fotos_checks_servicios;
                $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
                $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
                $fotos_check_instalacions->id_servicios   = $request->idAsig;
                $fotos_check_instalacions->timestamps = false;
                $fotos_check_instalacions->save();
            }
            //foto4
            if ($request->file('cargafotoa4') != "") {
                $file = $request->file('cargafotoa4');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                //sacamos la exxtencion por medio de _
                $extencionArray = explode("_", $extencion);
                $nombreGuardar1 = "fa4_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
                $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fa4_".'%')->where("id_servicios","=",$request->idAsig)->delete();

                $fotos_check_instalacions = new App\fotos_checks_servicios;
                $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
                $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
                $fotos_check_instalacions->id_servicios   = $request->idAsig;
                $fotos_check_instalacions->timestamps = false;
                $fotos_check_instalacions->save();
            }
            //foto5
            if ($request->file('cargafotoa5') != "") {
                $file = $request->file('cargafotoa5');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                //sacamos la exxtencion por medio de _
                $extencionArray = explode("_", $extencion);
                $nombreGuardar1 = "fa5_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
                $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fa5_".'%')->where("id_servicios","=",$request->idAsig)->delete();

                $fotos_check_instalacions = new App\fotos_checks_servicios;
                $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
                $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
                $fotos_check_instalacions->id_servicios   = $request->idAsig;
                $fotos_check_instalacions->timestamps = false;
                $fotos_check_instalacions->save();
            }
            //foto6
            if ($request->file('cargafotoa6') != "") {
                $file = $request->file('cargafotoa6');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                //sacamos la exxtencion por medio de _
                $extencionArray = explode("_", $extencion);
                $nombreGuardar1 = "fa6_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
                $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fa6_".'%')->where("id_servicios","=",$request->idAsig)->delete();

                $fotos_check_instalacions = new App\fotos_checks_servicios;
                $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
                $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
                $fotos_check_instalacions->id_servicios   = $request->idAsig;
                $fotos_check_instalacions->timestamps = false;
                $fotos_check_instalacions->save();
            } //foto7
            if ($request->file('cargafotoa7') != "") {
                $file = $request->file('cargafotoa7');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                //sacamos la exxtencion por medio de _
                $extencionArray = explode("_", $extencion);
                $nombreGuardar1 = "fa7_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
                $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fa7_".'%')->where("id_servicios","=",$request->idAsig)->delete();

                $fotos_check_instalacions = new App\fotos_checks_servicios;
                $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
                $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
                $fotos_check_instalacions->id_servicios   = $request->idAsig;
                $fotos_check_instalacions->timestamps = false;
                $fotos_check_instalacions->save();
            }
            //foto8
            if ($request->file('cargafotoa8') != "") {
                $file = $request->file('cargafotoa8');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                //sacamos la exxtencion por medio de _
                $extencionArray = explode("_", $extencion);
                $nombreGuardar1 = "fa8_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
                $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fa8_".'%')->where("id_servicios","=",$request->idAsig)->delete();

                $fotos_check_instalacions = new App\fotos_checks_servicios;
                $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
                $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
                $fotos_check_instalacions->id_servicios   = $request->idAsig;
                $fotos_check_instalacions->timestamps = false;
                $fotos_check_instalacions->save();
            }
            //foto9
            if ($request->file('cargafotoa9') != "") {
                $file = $request->file('cargafotoa9');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                //sacamos la exxtencion por medio de _
                $extencionArray = explode("_", $extencion);
                $nombreGuardar1 = "fa9_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
                $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fa9_".'%')->where("id_servicios","=",$request->idAsig)->delete();

                $fotos_check_instalacions = new App\fotos_checks_servicios;
                $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
                $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
                $fotos_check_instalacions->id_servicios   = $request->idAsig;
                $fotos_check_instalacions->timestamps = false;
                $fotos_check_instalacions->save();
            }
            //foto10
            if ($request->file('cargafotoa10') != "") {
                $file = $request->file('cargafotoa10');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                //sacamos la exxtencion por medio de _
                $extencionArray = explode("_", $extencion);
                $nombreGuardar1 = "fa10_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
                $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fa10_".'%')->where("id_servicios","=",$request->idAsig)->delete();

                $fotos_check_instalacions = new App\fotos_checks_servicios;
                $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
                $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
                $fotos_check_instalacions->id_servicios   = $request->idAsig;
                $fotos_check_instalacions->timestamps = false;
                $fotos_check_instalacions->save();
            }

            return "true";
        }, 5);
    }
    public function save_imagen_servicios_tres(request $request)
    {


        return DB::transaction(function () use ($request) {



            $numeroRandom = rand();


            if (!empty($request->file('cargafoto1'))) {
                $file = $request->file('cargafoto1');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                //sacamos la exxtencion por medio de _
                $extencionArray = explode("_", $extencion);
                if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
                } else {
                    return [
                        'status' => 400,
                        'msg' => "Solo se permiten imagenes",
                    ];
                }
                $nombreGuardar1 = "f1_".$numeroRandom. $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
            }

            //foto2
            if (!empty($request->file('cargafoto2'))) {
                $file = $request->file('cargafoto2');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                $extencionArray = explode("_", $extencion);
                if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
                } else {
                    return [
                        'status' => 400,
                        'msg' => "Solo se permiten imagenes",
                    ];
                }
                $nombreGuardar2 = "f2_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar2,  \File::get($file));
            }
            //foto3
            if (!empty($request->file('cargafoto3'))) {
                $file = $request->file('cargafoto3');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                $extencionArray = explode("_", $extencion);
                if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
                } else {
                    return [
                        'status' => 400,
                        'msg' => "Solo se permiten imagenes",
                    ];
                }
                $nombreGuardar3 = "f3_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar3,  \File::get($file));
            }
            //FOTO 4
            if (!empty($request->file('cargafoto4'))) {
                $file = $request->file('cargafoto4');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                $extencionArray = explode("_", $extencion);
                if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
                } else {
                    return [
                        'status' => 400,
                        'msg' => "Solo se permiten imagenes",
                    ];
                }
                $nombreGuardar4 = "f4_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar4,  \File::get($file));
            }
            //FOTO 5
            if (!empty($request->file('cargafoto5'))) {
                $file = $request->file('cargafoto5');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                $extencionArray = explode("_", $extencion);
                if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
                } else {
                    return [
                        'status' => 400,
                        'msg' => "Solo se permiten imagenes",
                    ];
                }
                $nombreGuardar5 = "f5_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar5,  \File::get($file));
            }
            //FOTO 6
            if (!empty($request->file('cargafoto6'))) {
                $file = $request->file('cargafoto6');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                $extencionArray = explode("_", $extencion);
                if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
                } else {
                    return [
                        'status' => 400,
                        'msg' => "Solo se permiten imagenes",
                    ];
                }
                $nombreGuardar6 = "f6_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar6,  \File::get($file));
            }
            //FOTO 7
            if (!empty($request->file('cargafoto7'))) {
                $file = $request->file('cargafoto7');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                $extencionArray = explode("_", $extencion);
                if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
                } else {
                    return [
                        'status' => 400,
                        'msg' => "Solo se permiten imagenes",
                    ];
                }
                $nombreGuardar7 = "f7_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar7,  \File::get($file));
            }
            //FOTO 8
            if (!empty($request->file('cargafoto8'))) {
                $file = $request->file('cargafoto8');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                $extencionArray = explode("_", $extencion);
                if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
                } else {
                    return [
                        'status' => 400,
                        'msg' => "Solo se permiten imagenes",
                    ];
                }
                $nombreGuardar8 = "f8_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar8,  \File::get($file));
            }
            //FOTO 9
            if (!empty($request->file('cargafoto9'))) {
                $file = $request->file('cargafoto9');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                $extencionArray = explode("_", $extencion);
                if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
                } else {
                    return [
                        'status' => 400,
                        'msg' => "Solo se permiten imagenes",
                    ];
                }
                $nombreGuardar9 = "f9_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar9,  \File::get($file));
            }
            //FOTO 10
            if (!empty($request->file('cargafoto10'))) {
                $file = $request->file('cargafoto10');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                $extencionArray = explode("_", $extencion);
                if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
                } else {
                    return [
                        'status' => 400,
                        'msg' => "Solo se permiten imagenes",
                    ];
                }
                $nombreGuardar10 = "f10_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar10,  \File::get($file));
            }
            //FOTO 11
            if (!empty($request->file('cargafoto11'))) {
                $file = $request->file('cargafoto11');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                $extencionArray = explode("_", $extencion);
                if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
                } else {
                    return [
                        'status' => 400,
                        'msg' => "Solo se permiten imagenes",
                    ];
                }
                $nombreGuardar11 = "f11_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar11,  \File::get($file));
            }
            //FOTO 12
            if (!empty($request->file('cargafoto12'))) {
                $file = $request->file('cargafoto12');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                $extencionArray = explode("_", $extencion);
                if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
                } else {
                    return [
                        'status' => 400,
                        'msg' => "Solo se permiten imagenes",
                    ];
                }
                $nombreGuardar12 = "f12_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar12,  \File::get($file));
            }
            //FOTO 13
            if (!empty($request->file('cargafoto13'))) {
                $file = $request->file('cargafoto13');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                $extencionArray = explode("_", $extencion);
                if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
                } else {
                    return [
                        'status' => 400,
                        'msg' => "Solo se permiten imagenes",
                    ];
                }
                $nombreGuardar13 = "f13_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar13,  \File::get($file));
            }
            //   $deletedRows = App\fotos_servicios_cheks::where('checklist_asignacion_id', $request->idAsig)->delete();

            if (!empty($request->file('cargafoto1'))) {
              //  $deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f1_'.$numeroRandom . $request->idAsig . '.png')->delete();
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f1_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
                $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f1_".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

                $fotos_servicios_cheks = new App\fotos_servicios_cheks;
                $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar1;
                $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar1;
                $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
                $fotos_servicios_cheks->timestamps = false;
                $fotos_servicios_cheks->save();
            }
            if (!empty($request->file('cargafoto2'))) {
              //  $deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f2_'.$numeroRandom . $request->idAsig . '.png')->delete();
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f2_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
                $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f2".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

                $fotos_servicios_cheks = new App\fotos_servicios_cheks;
                $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar2;
                $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar2;
                $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
                $fotos_servicios_cheks->timestamps = false;
                $fotos_servicios_cheks->save();
            }
            if (!empty($request->file('cargafoto3'))) {

                $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f3_".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

                $fotos_servicios_cheks = new App\fotos_servicios_cheks;
              //  $deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f3_'.$numeroRandom . $request->idAsig . '.png')->delete();
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f3_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
                $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar3;
                $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar3;
                $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
                $fotos_servicios_cheks->timestamps = false;
                $fotos_servicios_cheks->save();
            }

            if (!empty($request->file('cargafoto4'))) {
                $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f4_".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

                $fotos_servicios_cheks = new App\fotos_servicios_cheks;
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f4_'.$numeroRandom . $request->idAsig . '.png')->delete();
               // $deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f4_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
                $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar4;
                $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar4;
                $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
                $fotos_servicios_cheks->timestamps = false;
                $fotos_servicios_cheks->save();
            }

            if (!empty($request->file('cargafoto5'))) {

                $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f5_".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

                $fotos_servicios_cheks = new App\fotos_servicios_cheks;
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f5_'.$numeroRandom . $request->idAsig . '.png')->delete();
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f5_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
                $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar5;
                $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar5;
                $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
                $fotos_servicios_cheks->timestamps = false;
                $fotos_servicios_cheks->save();
            }

            if (!empty($request->file('cargafoto6'))) {

                $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f6_".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

                $fotos_servicios_cheks = new App\fotos_servicios_cheks;
               // $deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f6_'.$numeroRandom . $request->idAsig . '.png')->delete();
               // $deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f6_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
                $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar6;
                $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar6;
                $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
                $fotos_servicios_cheks->timestamps = false;
                $fotos_servicios_cheks->save();
            }

            if (!empty($request->file('cargafoto7'))) {

                $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f7_".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

                $fotos_servicios_cheks = new App\fotos_servicios_cheks;
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f7_'.$numeroRandom . $request->idAsig . '.png')->delete();
               // $deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f7_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
                $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar7;
                $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar7;
                $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
                $fotos_servicios_cheks->timestamps = false;
                $fotos_servicios_cheks->save();
            }

            if (!empty($request->file('cargafoto8'))) {

                $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f8_".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

                $fotos_servicios_cheks = new App\fotos_servicios_cheks;
               // $deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f8_'.$numeroRandom . $request->idAsig . '.png')->delete();
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f8_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
                $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar8;
                $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar8;
                $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
                $fotos_servicios_cheks->timestamps = false;
                $fotos_servicios_cheks->save();
            }

            if (!empty($request->file('cargafoto9'))) {

                $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f9_".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

                $fotos_servicios_cheks = new App\fotos_servicios_cheks;
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f9_'.$numeroRandom . $request->idAsig . '.png')->delete();
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f9_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
                $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar9;
                $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar9;
                $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
                $fotos_servicios_cheks->timestamps = false;
                $fotos_servicios_cheks->save();
            }

            if (!empty($request->file('cargafoto10'))) {

                $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f10_".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

                $fotos_servicios_cheks = new App\fotos_servicios_cheks;
               // $deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f10_'.$numeroRandom . $request->idAsig . '.png')->delete();
              //  $deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f10_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
                $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar10;
                $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar10;
                $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
                $fotos_servicios_cheks->timestamps = false;
                $fotos_servicios_cheks->save();
            }

            if (!empty($request->file('cargafoto11'))) {
                $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f11_".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

                $fotos_servicios_cheks = new App\fotos_servicios_cheks;
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f11_'.$numeroRandom . $request->idAsig . '.png')->delete();
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f11_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
                $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar11;
                $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar11;
                $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
                $fotos_servicios_cheks->timestamps = false;
                $fotos_servicios_cheks->save();
            }

            if (!empty($request->file('cargafoto12'))) {
                $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f12_".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

                $fotos_servicios_cheks = new App\fotos_servicios_cheks;
              //  $deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f12_'.$numeroRandom . $request->idAsig . '.png')->delete();
            //    $deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f12_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
                $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar12;
                $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar12;
                $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
                $fotos_servicios_cheks->timestamps = false;
                $fotos_servicios_cheks->save();
            }

            if (!empty($request->file('cargafoto13'))) {
                $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f13_".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

                $fotos_servicios_cheks = new App\fotos_servicios_cheks;
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f13_'.$numeroRandom . $request->idAsig . '.png')->delete();
                //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f13_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
                $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar13;
                $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar13;
                $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
                $fotos_servicios_cheks->timestamps = false;
                $fotos_servicios_cheks->save();
            }

            if (!empty($request->file('cargafoto14'))) {
                $this->subirnuevaimagen($request,14,$numeroRandom);
                }
               if (!empty($request->file('cargafoto15'))) {
                $this->subirnuevaimagen($request,15,$numeroRandom);
                }
                if (!empty($request->file('cargafoto16'))) {
                    $this->subirnuevaimagen($request,16,$numeroRandom);
               }
                if (!empty($request->file('cargafoto17'))) {
                        $this->subirnuevaimagen($request,17,$numeroRandom);
                        }
                if (!empty($request->file('cargafoto18'))) {
                            $this->subirnuevaimagen($request,18,$numeroRandom);
                            }
                if (!empty($request->file('cargafoto19'))) {
                                $this->subirnuevaimagen($request,19,$numeroRandom);
                                }
                 if (!empty($request->file('cargafoto20'))) {
                                    $this->subirnuevaimagen($request,20,$numeroRandom);
                                    }
                if (!empty($request->file('cargafoto21'))) {
                                        $this->subirnuevaimagen($request,21,$numeroRandom);
                                        }
                if (!empty($request->file('cargafoto22'))) {
                                            $this->subirnuevaimagen($request,22,$numeroRandom);
                                            }
                if (!empty($request->file('cargafoto23'))) {
                                                $this->subirnuevaimagen($request,23,$numeroRandom);
                                                }
                if (!empty($request->file('cargafoto24'))) {
                         $this->subirnuevaimagen($request,24,$numeroRandom);
                    }
                if (!empty($request->file('cargafoto25'))) {
                      $this->subirnuevaimagen($request,25,$numeroRandom);
                }

            return [
                'status' => 200,
            ];
        }, 5);
    }

       public function subirnuevaimagen($request,$posicion,$numeroRandom){

        $file = $request->file('cargafoto'.$posicion);
        //obtenemos el nombre del archivo
        $nombre =  time() . "_" . $file->getClientOriginalName();
        $extencion =  time() . "_" . $file->getClientOriginalExtension();
        $extencionArray = explode("_", $extencion);
        if ($extencionArray[1] == "jpg" || $extencionArray[1] == "jpeg" || $extencionArray[1] == "png" || $extencionArray[1] == "jfif") {
        } else {
          return "error";
        }
        $nombreGuardar_ = "f".$posicion."_".$numeroRandom . $request->idAsig . "." . $extencionArray[1];
        //indicamos que queremos guardar un nuevo archivo en el disco local
        \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar_,  \File::get($file));

        $deletedRows = App\fotos_servicios_cheks::where('url', 'LIKE', '%'."foto_servicios/f".$posicion."_".'%')->where("checklist_asignacion_id","=",$request->idAsig)->delete();

        $fotos_servicios_cheks = new App\fotos_servicios_cheks;
        //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f13_'.$numeroRandom . $request->idAsig . '.png')->delete();
        //$deletedRows = App\fotos_servicios_cheks::where('url', 'foto_servicios/f13_'.$numeroRandom . $request->idAsig . '.jpg')->delete();
        $fotos_servicios_cheks->descripcion_foto  = $nombreGuardar_;
        $fotos_servicios_cheks->url  = "foto_servicios/" . $nombreGuardar_;
        $fotos_servicios_cheks->checklist_asignacion_id   = $request->idAsig;
        $fotos_servicios_cheks->timestamps = false;
        $fotos_servicios_cheks->save();
        return "ok";;

    }

    public function GenerarpdfIntalacionProveServicios($idasig)
    {
        try {
            $id_asignacion = Crypt::decryptString($idasig);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $mi_asignacion = DB::table('asignacion_solicitudes')
            ->where('asignacion_solicitudes.id', '=', $id_asignacion)
            ->get();

        $id_trabajador = $mi_asignacion[0]->trabajadors_id;
        $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
        $trabajadors_id = $mi_asignacion[0]->trabajadors_id;

        //datos del usuario
        $datosTrabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.id', '=', $trabajadors_id)
            ->get();

        $firmatrabajador = DB::table('firma_clientes')
            ->where('firma_clientes.id_tecnico', '=', $trabajadors_id)
            ->get();
        //obtener nombre del proyecto
        //tracket proyecto_id
        $apiSolicitud = DB::table('api_solicitudes')
            ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('api_solicitudes.id', '=', $idApiSolicitud)
            ->get();

        // tipo_equipamientos
        $tipo_equipamientos_dvRevelado = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "DV - UN Revelado(s)")
            ->get();

        $tipo_equipamientos_dkCilindro = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "DK - UN Cilindro(s)")
            ->get();

        $tipo_equipamientos_detalleEquipamiento = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "Detalle del equipamiento")
            ->get();

        $fotos = DB::table('fotos_checks_servicios')
            ->where('fotos_checks_servicios.id_servicios', '=', $id_asignacion)
            ->get();


        $acceDanos = DB::table('check_accesorios_danados_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_danados_servicios.id_accesorio')
            ->where('check_accesorios_danados_servicios.id_asig_serv', '=', $id_asignacion)
            ->get();

        $acceManu = DB::table('accesorios_manuales_servicios')
            ->where('accesorios_manuales_servicios.id_checklist_instalacion', '=', $id_asignacion)
            ->get();
        $acceSoli = DB::table('check_accesorios_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_servicios.id_accesorio')
            ->where('check_accesorios_servicios.id_asig_servicio', '=', $id_asignacion)
            ->get();
        //estas son las tres imagenes
        $fotos_servicios_cheks = DB::table('fotos_servicios_cheks')
            ->where('fotos_servicios_cheks.checklist_asignacion_id', '=', $id_asignacion)
            ->get();
        $compressedImagePaths = [];

    // Array para almacenar las rutas de las imágenes comprimidas
$rutaBase = '/var/www/html/sistema/rendicion/fotos/';

// Recorrer las imágenes obtenidas y comprimirlas
foreach ($fotos_servicios_cheks as $key => $foto) {
    // Ruta de la imagen original y nueva ruta para la imagen comprimida
    $sourceImagePath = $rutaBase . $foto->url;

    // Obtener el tipo de imagen (extensión del archivo)
    $extension = pathinfo($sourceImagePath, PATHINFO_EXTENSION);

    // Comprimir la imagen original según su tipo
    switch (strtolower($extension)) {
        case 'jpg':
        case 'jpeg':
            $sourceImage = imagecreatefromjpeg($sourceImagePath);
            imagejpeg($sourceImage, $sourceImagePath, 80); // Sobrescribe la imagen original con calidad 80
            break;
        case 'png':
            $sourceImage = imagecreatefrompng($sourceImagePath);
            imagepng($sourceImage, $sourceImagePath, 9); // Sobrescribe la imagen original con nivel de compresión 9
            break;
        // Agregar más casos según sea necesario para otros formatos de imagen
        default:
            // Manejo para otros formatos de imagen si es necesario
            continue;
    }

    // Liberar la memoria utilizada por la imagen
    imagedestroy($sourceImage);
}

        $asignacion_solicitudes = DB::table('asignacion_solicitudes')
            ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_solicitudes.id', '=', $id_asignacion)
            ->orderBy('asignacion_solicitudes.id', 'desc')
            ->select(
                'asignacion_solicitudes.id as idAsig',
                'check_formulario_solicitudes.sComuna',
                'asignacion_solicitudes.fecha',
                'asignacion_solicitudes.estado_externo',
                'asignacion_solicitudes.url_firma',
                'asignacion_solicitudes.estado_interno',
                'asignacion_solicitudes.fecha_inicio',
                'asignacion_solicitudes.fecha_fin',
                'asignacion_solicitudes.fecha_local',
                'asignacion_solicitudes.fecha_transito',
                'check_formulario_solicitudes.sComuna',
                'check_formulario_solicitudes.sRegion',
                'check_formulario_solicitudes.sDireccion',
                'check_formulario_solicitudes.sSerie',
                'check_formulario_solicitudes.sContacto',
                'check_formulario_solicitudes.sTelefono',
                'check_formulario_solicitudes.sModelo',
                'check_formulario_solicitudes.numero_ot',
                'check_formulario_solicitudes.contador_bn',
                'check_formulario_solicitudes.contador_color',
                'check_formulario_solicitudes.ip',
                'check_formulario_solicitudes.usb',
                'check_formulario_solicitudes.descripcion',
                'check_formulario_solicitudes.tipo_componente',
                'check_formulario_solicitudes.solicita_acessorios',
                'check_formulario_solicitudes.observaciones',
                'check_formulario_solicitudes.nombre_contacto_firma',
                'check_formulario_solicitudes.correo_contacto',
                'check_formulario_solicitudes.firma_contacto',
                'check_formulario_solicitudes.estado_seleccionado',
                'check_formulario_solicitudes.motivo_accesorio',
                'check_formulario_solicitudes.sCliente',
                'check_formulario_solicitudes.validador',
                'check_formulario_solicitudes.dFecCre as fecha_check',
                'check_formulario_solicitudes.sSC',
                'check_formulario_solicitudes.Smarca',
                'check_formulario_solicitudes.equipos',

                'check_formulario_solicitudes.sProveedor',

            )
            ->get();

             //SLA Y DEPARTAMENTO
    $getDataApisol = DB::table('api_solicitudes')
    ->select("departamento","tipo_of_sinergy")
    ->where('api_solicitudes.id', '=', $idApiSolicitud)

    ->get();

        $inicio = new DateTime($asignacion_solicitudes[0]->fecha_inicio);
        $fin = new DateTime($asignacion_solicitudes[0]->fecha_fin);

        $interval = $inicio->diff($fin);
        $dias = $interval->format("%d");
        $horas = $interval->format("%h");
        $minutos = $interval->format("%i");
        $mes = $interval->format("%m");
        $ano = $interval->format("%y");

        if ($dias == "0") {
            if ($horas == "0") {
                if ($minutos  == "0") {
                    $hrspublicaciones = $interval->format('%s segundos');
                } else {
                    $hrspublicaciones = $interval->format('%i minutos ');
                }
            } else {
                $hrspublicaciones = $interval->format('%h Horas ');
            }
        } else {
            $hrspublicaciones = $interval->format('%d Dias');
            if ($mes >= "1") {
                if ($ano >= "1") {
                    $hrspublicaciones = $interval->format('%d/%d/%Y');
                } else {
                    $hrspublicaciones = $interval->format('%d/%d');
                }
            } else {
                $hrspublicaciones = $interval->format('%d Dias');
            }
        }

        $fecha_asignada = date_create($asignacion_solicitudes[0]->fecha);
        $fecha_asignada = date_format($fecha_asignada, "d-m-Y");

        $fecha_inicio = date_create($asignacion_solicitudes[0]->fecha_inicio);
        $fecha_inicio = date_format($fecha_inicio, "d-m-Y H:i:s");

        $fecha_fin = date_create($asignacion_solicitudes[0]->fecha_fin);
        $fecha_fin = date_format($fecha_fin, "d-m-Y H:i:s");

        $fecha_local = date_create($asignacion_solicitudes[0]->fecha_fin);
        $fecha_local = date_format($fecha_local, "d-m-Y H:i:s");

        $fecha_transito = date_create($asignacion_solicitudes[0]->fecha_transito);
        $fecha_transito = date_format($fecha_transito, "d-m-Y H:i:s");


        $instalacion_accesorios = DB::table('checklist_instalacion_accesorios_servicios')
        ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios_servicios.id_accesorio')
        ->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios_servicios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios_servicios.serie_parte')
        ->where('id_asig_servicio', '=', $id_asignacion)
        ->get();


        return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('solicitudes_servicios/pdf.pdfSolicitudProveedor', compact('idApiSolicitud','getDataApisol','instalacion_accesorios','acceManu', 'fecha_transito', 'fecha_local', 'firmatrabajador', 'hrspublicaciones', 'fecha_fin', 'fecha_inicio', 'fecha_asignada', 'datosTrabajador', 'apiSolicitud', 'fotos_servicios_cheks', 'acceSoli', 'acceDanos', 'fotos', 'tipo_equipamientos_detalleEquipamiento', 'tipo_equipamientos_dkCilindro', 'tipo_equipamientos_dvRevelado', 'asignacion_solicitudes'))
            ->download($asignacion_solicitudes[0]->sSC . '.pdf');
        // download
    }
    public function GenerarpdfIntalacionCordinServicios($idasig)
    {
        try {
            $id_asignacion = Crypt::decryptString($idasig);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $mi_asignacion = DB::table('asignacion_solicitudes')
            ->where('asignacion_solicitudes.id', '=', $id_asignacion)
            ->get();

        $id_trabajador = $mi_asignacion[0]->trabajadors_id;
        $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
        $trabajadors_id = $mi_asignacion[0]->trabajadors_id;

        //datos del usuario
        $datosTrabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.id', '=', $trabajadors_id)
            ->get();

        $firmatrabajador = DB::table('firma_clientes')
            ->where('firma_clientes.id_tecnico', '=', $trabajadors_id)
            ->get();
        //obtener nombre del proyecto
        //tracket proyecto_id
        $apiSolicitud = DB::table('api_solicitudes')
            ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('api_solicitudes.id', '=', $idApiSolicitud)
            ->get();

    //SLA Y DEPARTAMENTO
    $getDataApisol = DB::table('api_solicitudes')
    ->select("departamento","tipo_of_sinergy")
    ->where('api_solicitudes.id', '=', $idApiSolicitud)

    ->get();
            $obtenerFechaIngreso = DB::table('api_solicitudes')
            ->where('api_solicitudes.id', '=', $idApiSolicitud)
            ->get();

         $fechaIngreso=  $obtenerFechaIngreso[0]->dFecha;



        // tipo_equipamientos
        $tipo_equipamientos_dvRevelado = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "DV - UN Revelado(s)")
            ->get();

        $tipo_equipamientos_dkCilindro = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "DK - UN Cilindro(s)")
            ->get();

        $tipo_equipamientos_detalleEquipamiento = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "Detalle del equipamiento")
            ->get();

        $fotos = DB::table('fotos_checks_servicios')
            ->where('fotos_checks_servicios.id_servicios', '=', $id_asignacion)
            ->get();

        $acceDanos = DB::table('check_accesorios_danados_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_danados_servicios.id_accesorio')
            ->where('check_accesorios_danados_servicios.id_asig_serv', '=', $id_asignacion)
            ->get();

        $acceManu = DB::table('accesorios_manuales_servicios')
            ->where('accesorios_manuales_servicios.id_checklist_instalacion', '=', $id_asignacion)
            ->get();
        $acceSoli = DB::table('check_accesorios_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_servicios.id_accesorio')
            ->where('check_accesorios_servicios.id_asig_servicio', '=', $id_asignacion)
            ->get();
        //estas son las tres imagenes
        $fotos_servicios_cheks = DB::table('fotos_servicios_cheks')
            ->where('fotos_servicios_cheks.checklist_asignacion_id', '=', $id_asignacion)
            ->get();


            $instalacion_accesorios = DB::table('checklist_instalacion_accesorios_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios_servicios.id_accesorio')
            ->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios_servicios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios_servicios.serie_parte')
            ->where('id_asig_servicio', '=', $id_asignacion)
            ->get();

        $asignacion_solicitudes = DB::table('asignacion_solicitudes')
            ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_solicitudes.id', '=', $id_asignacion)
            ->orderBy('asignacion_solicitudes.id', 'desc')
            ->select(
                'asignacion_solicitudes.id as idAsig',
                'check_formulario_solicitudes.sComuna',
                'asignacion_solicitudes.fecha',
                'asignacion_solicitudes.estado_externo',
                'asignacion_solicitudes.url_firma',
                'asignacion_solicitudes.estado_interno',
                'asignacion_solicitudes.fecha_inicio',
                'asignacion_solicitudes.fecha_fin',
                'asignacion_solicitudes.fecha_asignacion',
                'asignacion_solicitudes.fecha_local',
                'asignacion_solicitudes.fecha_transito',
                'check_formulario_solicitudes.sComuna',
                'check_formulario_solicitudes.sRegion',
                'check_formulario_solicitudes.sDireccion',
                'check_formulario_solicitudes.sSerie',
                'check_formulario_solicitudes.sContacto',
                'check_formulario_solicitudes.sTelefono',
                'check_formulario_solicitudes.sModelo',
                'check_formulario_solicitudes.numero_ot',
                'check_formulario_solicitudes.contador_bn',
                'check_formulario_solicitudes.contador_color',
                'check_formulario_solicitudes.ip',
                'check_formulario_solicitudes.usb',
                'asignacion_solicitudes.fecha_revision',

                'check_formulario_solicitudes.descripcion',
                'check_formulario_solicitudes.tipo_componente',
                'check_formulario_solicitudes.solicita_acessorios',
                'check_formulario_solicitudes.observaciones',
                'check_formulario_solicitudes.nombre_contacto_firma',
                'check_formulario_solicitudes.correo_contacto',
                'check_formulario_solicitudes.firma_contacto',
                'check_formulario_solicitudes.estado_seleccionado',
                'check_formulario_solicitudes.motivo_accesorio',
                'check_formulario_solicitudes.sCliente',
                'check_formulario_solicitudes.validador',
                'check_formulario_solicitudes.dFecCre as fecha_check',
                'check_formulario_solicitudes.ip',
                'check_formulario_solicitudes.Smarca',

                'check_formulario_solicitudes.usb',
                'check_formulario_solicitudes.sSC',
                'check_formulario_solicitudes.sProveedor',
                'check_formulario_solicitudes.equipos'
            )
            ->get();

        $inicio = new DateTime($asignacion_solicitudes[0]->fecha_inicio);
        $fin = new DateTime($asignacion_solicitudes[0]->fecha_fin);

        $interval = $inicio->diff($fin);
        $dias = $interval->format("%d");
        $horas = $interval->format("%h");
        $minutos = $interval->format("%i");
        $mes = $interval->format("%m");
        $ano = $interval->format("%y");

        if ($dias == "0") {
            if ($horas == "0") {
                if ($minutos  == "0") {
                    $hrspublicaciones = $interval->format('%s segundos');
                } else {
                    $hrspublicaciones = $interval->format('%i minutos ');
                }
            } else {
                $hrspublicaciones = $interval->format('%h Horas ');
            }
        } else {
            $hrspublicaciones = $interval->format('%d Dias');
            if ($mes >= "1") {
                if ($ano >= "1") {
                    $hrspublicaciones = $interval->format('%d/%d/%Y');
                } else {
                    $hrspublicaciones = $interval->format('%d/%d');
                }
            } else {
                $hrspublicaciones = $interval->format('%d Dias');
            }
        }
        $fecha_asignada = "";
        $fecha_inicio = "";
        $fecha_fin = "";
        $fecha_local = "";
        $fecha_transito = "";

        if ($asignacion_solicitudes[0]->fecha != "") {
            $fecha_asignada = date_create($asignacion_solicitudes[0]->fecha);
            $fecha_asignada = date_format($fecha_asignada, "d-m-Y");
        }
        if ($asignacion_solicitudes[0]->fecha_inicio != "") {
            $fecha_inicio = date_create($asignacion_solicitudes[0]->fecha_inicio);
            $fecha_inicio = date_format($fecha_inicio, "d-m-Y H:i:s");
        }
        if ($asignacion_solicitudes[0]->fecha_fin != "") {
            $fecha_fin = date_create($asignacion_solicitudes[0]->fecha_fin);
            $fecha_fin = date_format($fecha_fin, "d-m-Y H:i:s");
        }
        if ($asignacion_solicitudes[0]->fecha_local != "") {
            $fecha_local = date_create($asignacion_solicitudes[0]->fecha_local);
            $fecha_local = date_format($fecha_local, "d-m-Y H:i:s");
        }
        if ($asignacion_solicitudes[0]->fecha_transito != "") {
            $fecha_transito = date_create($asignacion_solicitudes[0]->fecha_transito);
            $fecha_transito = date_format($fecha_transito, "d-m-Y H:i:s");
        }
        return \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('solicitudes_servicios.pdf.pdfSolicitudCoordinadora', compact('idApiSolicitud','getDataApisol','instalacion_accesorios','fechaIngreso','acceManu', 'fecha_transito', 'fecha_local', 'firmatrabajador', 'hrspublicaciones', 'fecha_fin', 'fecha_inicio', 'fecha_asignada', 'datosTrabajador', 'apiSolicitud', 'fotos_servicios_cheks', 'acceSoli', 'acceDanos', 'fotos', 'tipo_equipamientos_detalleEquipamiento', 'tipo_equipamientos_dkCilindro', 'tipo_equipamientos_dvRevelado', 'asignacion_solicitudes'))
            ->stream($asignacion_solicitudes[0]->sSC . '.pdf');
    }
    function checklisRechazarServicio(request $request, $idAsignacion)
    {

        return DB::transaction(function () use ($request, $idAsignacion) {
            try {
                $idAsig = Crypt::decryptString($idAsignacion);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }

            $mi_asignacion = DB::table('asignacion_solicitudes')
                ->where('asignacion_solicitudes.id', '=', $idAsig)
                ->get();
                $FechaHoraActual  = Carbon::now();
                $FechaHoraActual = $FechaHoraActual->toDateTimeString();

            $id_trabajador = $mi_asignacion[0]->trabajadors_id;
            $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
            $trabajadors_id = $mi_asignacion[0]->trabajadors_id;

            //modificar el estado
            $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($idAsig);
            $asigSolicitudes->estado_interno = "RECHAZADO";
            $asigSolicitudes->estado_externo = "RECHAZADO";
            $asigSolicitudes->motivo_rechazo = $request->motivorechazado;
            $asigSolicitudes->fecha_revision  = $FechaHoraActual;

            $asigSolicitudes->timestamps = false;
            $asigSolicitudes->save();

            //modificar el estado
            $api_solicitudes =  App\api_solicitudes::findOrfail($idApiSolicitud);
            $api_solicitudes->estado_interno = "RECHAZADO";
            $api_solicitudes->estado_externo = "RECHAZADO";
            $api_solicitudes->timestamps = false;
            $api_solicitudes->save();

            // $url =session('url_cordinadora');
//cambio ariel
return redirect('home')->with('mensaje', 'Checklist Rechazado');

            // return redirect()->route('go.api_solicitudes')->with('mensaje', 'Checklist Rechazado');

            // return back()->with('mensaje', 'Checklist Rechazado');
        }, 5);
        // return redirect($url)->with('mensaje', 'Checklist Rechazado');

    }




    public function modificarEsadoApiServicio($idApi, $estado, $op)
    {
        //modificar el estado
        $api_solicitudes =  App\api_solicitudes::findOrfail($idApi);
        // $api_solicitudes->estado_interno = $estado;
        $api_solicitudes->estado_externo = $estado;
        if ($op == 2) {
            $api_solicitudes->estado_interno = $estado;
        }
        // $api_solicitudes->estado_externo = "RECHAZADO";
        //modificar el estado
        $api_solicitudes->fecha_estado = Carbon::now()->toDateString();
        $api_solicitudes->timestamps = false;
        $api_solicitudes->save();
    }

    function checklisReasignarServicio(request $request, $idAsignacion)
    {
        return DB::transaction(function () use ($request, $idAsignacion) {
            try {
                $idAsig = Crypt::decryptString($idAsignacion);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }

            $mi_asignacion = DB::table('asignacion_solicitudes')
                ->where('asignacion_solicitudes.id', '=', $idAsig)
                ->get();

            $id_trabajador = $mi_asignacion[0]->trabajadors_id;
            $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
            $trabajadors_id = $mi_asignacion[0]->trabajadors_id;

            //modificar el estado
            $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($idAsig);
            $asigSolicitudes->estado_interno = "REASIGNAR";
            // $asigSolicitudes->estado_externo = "RECHAZADO";
            $asigSolicitudes->motivo_reasignacion = $request->motivorechazado;
            $asigSolicitudes->timestamps = false;
            $asigSolicitudes->save();

            //modificar el estado
            $api_solicitudes =  App\api_solicitudes::findOrfail($idApiSolicitud);
            $api_solicitudes->estado_interno = "REASIGNAR";
            // $api_solicitudes->estado_externo = "RECHAZADO";
            $api_solicitudes->timestamps = false;
            $api_solicitudes->save();

            // $url =session('url_cordinadora');

            return back()->with('mensaje', 'Checklist Reasignar');
            // return redirect($url)->with('mensaje', 'Checklist Rechazado');
        }, 5);
    }


    public function cambio_estado_interno($nombreTecnico, $ssc, $estado_interno, $fecha_inicio)
    {

        $estado = 1; //asignado
        $nombreTecnico = $nombreTecnico;
        $ssc = $ssc;
        $obs = "";
        $ent = $fecha_inicio;
        $sal = "";
        $cont = "";
        $col = "";
        $t1 = 0;
        $t2 = 0;
        $t3 = 0;
        $rep = "";
        $estado_interno = $estado_interno;
        $idAsignacion = "";
        return  $this->wsCambio_estado($idAsignacion, $estado, $nombreTecnico, $ssc, $obs, $ent, $sal, $cont, $col, $t1, $t2, $t3, $rep, $estado_interno);
    }
    public function probarapi()
    {

        $estado = 3; //Finalizado
        $nombreTecnico = 9;
        $ssc = "SC148428";
        $obs = "";
        $ent = "";
        $sal = "";
        $cont = "";
        $col = "";
        $t1 = 0;
        $t2 = 0;
        $t3 = 0;
        $rep = "";
        $estado_interno = "asignado";
        $idAsignacion = "";

        return  $this->wsCambio_estado($idAsignacion, $estado, $nombreTecnico, $ssc, $obs, $ent, $sal, $cont, $col, $t1, $t2, $t3, $rep, $estado_interno);
    }


    //cambiar el estado en kyocera


    public function wsCambio_estado($idAsignacion, $estado, $nombreTecnico, $ssc, $obs, $ent, $sal, $cont, $col, $t1, $t2, $t3, $rep, $estado_interno)
    {
        // return "ok";
        $nombre_DB = DB::connection()->getDatabaseName();
        if ($nombre_DB == "KYOCERA") {
            // public function probarapi(){
            $url = 'http://190.153.241.162:3017/wsaya/UpdateSC';
            $apikey = 'v3r1z0l4ll3v4';

            $client = new Client([
                // Base URI is used with relative requests
                'base_uri' => $url,
                // You can set any number of default request options.
                'timeout'  => 2.0,
            ]);
            $estado = $estado;
            $nombreTecnico = $nombreTecnico; //nombre mas apellido
            $ssc = $ssc;
            $obs  =   $obs;
            $ent  =   $ent;
            $sal  =   $sal;
            $cont =   $cont;
            $col  =  $col;
            $t1   =  $t1;
            $t2   =  $t2;
            $t3   =  $t3;

            try {
                $client = new Client([
                    // Base URI is used with relative requests
                    'base_uri' => $url,
                    // You can set any number of default request options.
                    'timeout'  => 2.0,
                ]);
                ////////////ESTADOS 1,2,5////////
                if ($estado == 1 || $estado == 2 || $estado == 5) {
                    if ($ent == null || $ent == 0 || $ent == "") {
                        $ent = "";
                    } else {
                        $f1 = Carbon::parse($ent);
                        $ent =   $f1->format('Ymd h:i:s');
                    }

                    if ($sal == null || $sal == 0 || $sal == "") {
                        $sal = "";
                    } else {
                        $f2 = Carbon::parse($sal);
                        $sal =  $f2->format('Ymd h:i:s');
                    }
                    $val = "";
                    // 20211221 15:02:20
                    $items_p = [
                        "sSC" => $ssc,
                        "nId_EstadoOT" => $estado,
                        "tec" => $nombreTecnico,
                        "obs" =>  $obs,
                        "ent" =>  $ent,
                        "sal" =>  $sal,
                        "cont" =>  $cont,
                        "col" => $col,
                        "t1" => $t1,
                        "t2" => $t2,
                        "t3" => $t3,
                        "val" => $val,
                        "estado_interno" => $estado_interno
                    ];
                } else {

                    $check_accesorios_servicios = DB::table('check_accesorios_servicios')
                        ->join("accesorios", "accesorios.id", "=", "check_accesorios_servicios.id_accesorio")
                        ->where('check_accesorios_servicios.id_asig_servicio', '=', $idAsignacion)
                        ->get();

                    $validadors = DB::table('check_formulario_solicitudes')
                        ->join('asignacion_solicitudes', 'asignacion_solicitudes.check_formulario_solicitudes_id', 'check_formulario_solicitudes.id')
                        ->where('asignacion_solicitudes.id', '=', $idAsignacion)
                        ->get();

                    $val = $validadors[0]->validador;

                    // return $check_accesorios_servicios;
                    $total  = 0;
                    $item[] = "";
                    foreach ($check_accesorios_servicios as $row) {
                        $item[] = [
                            "codigo" => $row->articulo,
                            "q" => $row->cantidad,
                        ];
                        $total =  $total  + $row->cantidad;
                    }

                    $tipo_equipamientos = DB::table('tipo_equipamientos')
                        ->where('tipo_equipamientos.id_asig', '=', $idAsignacion)
                        ->get();

                    foreach ($tipo_equipamientos as $row) {
                        $item[] = [
                            "codigo" => $row->numero_parte,
                            "q" => $row->cantidad,
                        ];
                        $total =  $total  + $row->cantidad;
                    }
                    // $total = 4; //debe de venir del total de accesorios solicitados
                    $tipo_equipamientos_manuales = DB::table('accesorios_manuales_servicios')
                        ->where('accesorios_manuales_servicios.id_checklist_instalacion', '=', $idAsignacion)
                        ->get();

                    foreach ($tipo_equipamientos_manuales as $row) {
                        $total =  $total  + $row->cantidad;
                    }

                    $items_p = [
                        "sSC" => $ssc,
                        "nId_EstadoOT" => $estado,
                        "tec" => $nombreTecnico,
                        "obs" =>  $obs,
                        "ent" =>  $ent,
                        "sal" =>  $sal,
                        "cont" =>  $cont,
                        "col" => $col,
                        "t1" => $t1,
                        "t2" => $t2,
                        "t3" => $t3,
                        "val" => $val,
                        "estado_interno" => $estado_interno,
                        "rep" => [
                            "total" => $total,
                            "item" => $item,
                        ]
                    ];
                }
                //estado 1 y 2
                $response = $client->request('GET', 'UpdateSC', [
                    'form_params' => [
                        'api_key' => $apikey,
                        "data" => $items_p,
                    ]
                ]);

                if ($response->getBody()) {
                    $response = json_decode($response->getBody(), true);
                    if (!empty($response['status'])) {
                        return $response['status'];
                    } else {
                        return $response;;
                    }
                } else {
                    return "error";
                }
            } catch (\InvalidArgumentException $e) {
                throw $e;
            } catch (\Exception $e) {
                return "Error Conexión con WS Kyocera, Comunicarse con Soporte";
            }
        }
    }

    //desarrollo
    public function wsCambio_estado_desarrollo($idAsignacion, $estado, $nombreTecnico, $ssc, $obs, $ent, $sal, $cont, $col, $t1, $t2, $t3, $rep, $estado_interno)
    {
        // return "ok";
        $nombre_DB = DB::connection()->getDatabaseName();
        if ($nombre_DB == "KYOCERA") {
            // public function probarapi(){
            $url = 'http://190.153.241.162:3017/wsaya/UrpdateSC';
            $apikey = 'v3r1z0l4ll3vr4';

            $client = new Client([
                // Base URI is used with relative requests
                'base_uri' => $url,
                // You can set any number of default request options.
                'timeout'  => 2.0,
            ]);
            $estado = $estado;
            $nombreTecnico = $nombreTecnico; //nombre mas apellido
            $ssc = $ssc;
            $obs  =   $obs;
            $ent  =   $ent;
            $sal  =   $sal;
            $cont =   $cont;
            $col  =  $col;
            $t1   =  $t1;
            $t2   =  $t2;
            $t3   =  $t3;

            try {
                $client = new Client([
                    // Base URI is used with relative requests
                    'base_uri' => $url,
                    // You can set any number of default request options.
                    'timeout'  => 2.0,
                ]);
                ////////////ESTADOS 1,2,5////////
                if ($estado == 1 || $estado == 2 || $estado == 5) {
                    if ($ent == null || $ent == 0 || $ent == "") {
                        $ent = "";
                    } else {
                        $f1 = Carbon::parse($ent);
                        $ent =   $f1->format('Ymd h:i:s');
                    }

                    if ($sal == null || $sal == 0 || $sal == "") {
                        $sal = "";
                    } else {
                        $f2 = Carbon::parse($sal);
                        $sal =  $f2->format('Ymd h:i:s');
                    }
                    $val = "";
                    // 20211221 15:02:20
                    $items_p = [
                        "sSC" => $ssc,
                        "nId_EstadoOT" => $estado,
                        "tec" => $nombreTecnico,
                        "obs" =>  $obs,
                        "ent" =>  $ent,
                        "sal" =>  $sal,
                        "cont" =>  $cont,
                        "col" => $col,
                        "t1" => $t1,
                        "t2" => $t2,
                        "t3" => $t3,
                        "val" => $val,
                        "estado_interno" => $estado_interno
                    ];
                } else {

                    $check_accesorios_servicios = DB::table('check_accesorios_servicios')
                        ->join("accesorios", "accesorios.id", "=", "check_accesorios_servicios.id_accesorio")
                        ->where('check_accesorios_servicios.id_asig_servicio', '=', $idAsignacion)
                        ->get();

                    $validadors = DB::table('check_formulario_solicitudes')
                        ->join('asignacion_solicitudes', 'asignacion_solicitudes.check_formulario_solicitudes_id', 'check_formulario_solicitudes.id')
                        ->where('asignacion_solicitudes.id', '=', $idAsignacion)
                        ->get();

                    $val = $validadors[0]->validador;

                    // return $check_accesorios_servicios;
                    $total  = 0;
                    $item[] = "";
                    foreach ($check_accesorios_servicios as $row) {
                        $item[] = [
                            "codigo" => $row->articulo,
                            "q" => $row->cantidad,
                        ];
                        $total =  $total  + $row->cantidad;
                    }

                    $tipo_equipamientos = DB::table('tipo_equipamientos')
                        ->where('tipo_equipamientos.id_asig', '=', $idAsignacion)
                        ->get();

                    foreach ($tipo_equipamientos as $row) {
                        $item[] = [
                            "codigo" => $row->numero_parte,
                            "q" => $row->cantidad,
                        ];
                        $total =  $total  + $row->cantidad;
                    }
                    // $total = 4; //debe de venir del total de accesorios solicitados
                    $tipo_equipamientos_manuales = DB::table('accesorios_manuales_servicios')
                        ->where('accesorios_manuales_servicios.id_checklist_instalacion', '=', $idAsignacion)
                        ->get();

                    foreach ($tipo_equipamientos_manuales as $row) {
                        $total =  $total  + $row->cantidad;
                    }

                    $items_p = [
                        "sSC" => $ssc,
                        "nId_EstadoOT" => $estado,
                        "tec" => $nombreTecnico,
                        "obs" =>  $obs,
                        "ent" =>  $ent,
                        "sal" =>  $sal,
                        "cont" =>  $cont,
                        "col" => $col,
                        "t1" => $t1,
                        "t2" => $t2,
                        "t3" => $t3,
                        "val" => $val,
                        "estado_interno" => $estado_interno,
                        "rep" => [
                            "total" => $total,
                            "item" => $item,
                        ]
                    ];
                }
                //estado 1 y 2
                // $response = $client->request('GET', 'UpdateSC', [
                //     'form_params' => [
                //         'api_key' => $apikey,
                //         "data" => $items_p,
                //     ]
                // ]);

                // if ($response->getBody()) {
                //     $response = json_decode($response->getBody(), true);
                //     if (!empty($response['status'])) {
                //         return $response['status'];
                //     } else {
                //         return $response;;
                //     }
                // } else {
                //     return "error";
                // }
                return "ok";
            } catch (\InvalidArgumentException $e) {
                throw $e;
            } catch (\Exception $e) {
                return "Error Conexión con WS Kyocera, Comunicarse con Soporte";
            }
        }
    }

    public function SolicitarRepuestosCheckCoordinadora($idasig)
    {
        return DB::transaction(function () use ($idasig) {
            try {
                $id_asignacion = Crypt::decryptString($idasig);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }

            $mi_asignacion = DB::table('asignacion_solicitudes')
                ->where('asignacion_solicitudes.id', '=', $id_asignacion)
                ->get();

            $id_trabajador = $mi_asignacion[0]->trabajadors_id;
            $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
            $trabajadors_id = $mi_asignacion[0]->trabajadors_id;

            //datos del usuario
            $datosTrabajador = DB::table('trabajadors')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->where('trabajadors.id', '=', $trabajadors_id)
                ->get();
            $firmatrabajador = DB::table('firma_clientes')
                ->where('firma_clientes.id_tecnico', '=', $trabajadors_id)
                ->get();

            //tracket proyecto_id
            $apiSolicitud = DB::table('api_solicitudes')
                ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->where('api_solicitudes.id', '=', $idApiSolicitud)
                ->get();
                $apiSolicitud_id_pro = DB::table('api_solicitudes')
                ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->where('api_solicitudes.id', '=', $idApiSolicitud)
                ->select('proyectos.id as proyecto_id')
                ->get();
            // tipo_equipamientos
            $tipo_equipamientos_dvRevelado = DB::table('tipo_equipamientos')
                ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
                ->where('tipo_equipamientos.opcion', '=', "DV - UN Revelado(s)")
                ->get();
            $tipo_equipamientos_dkCilindro = DB::table('tipo_equipamientos')
                ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
                ->where('tipo_equipamientos.opcion', '=', "DK - UN Cilindro(s)")
                ->get();
            $tipo_equipamientos_detalleEquipamiento = DB::table('tipo_equipamientos')
                ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
                ->where('tipo_equipamientos.opcion', '=', "Detalle del equipamiento")
                ->get();
            $fotos = DB::table('fotos_checks_servicios')
                ->where('fotos_checks_servicios.id_servicios', '=', $id_asignacion)
                ->get();
            $acceDanos = DB::table('check_accesorios_danados_servicios')
                ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_danados_servicios.id_accesorio')
                ->where('check_accesorios_danados_servicios.id_asig_serv', '=', $id_asignacion)
                ->get();
            $acceSoli = DB::table('check_accesorios_servicios')
                ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_servicios.id_accesorio')
                ->where('check_accesorios_servicios.id_asig_servicio', '=', $id_asignacion)
                ->get();
            //estas son las tres imagenes
            $fotos_servicios_cheks = DB::table('fotos_servicios_cheks')
                ->where('fotos_servicios_cheks.checklist_asignacion_id', '=', $id_asignacion)
                ->get();
            $acceManu = DB::table('accesorios_manuales_servicios')
                ->where('accesorios_manuales_servicios.id_checklist_instalacion', '=', $id_asignacion)
                ->get();

            $asignacion_solicitudes = DB::table('asignacion_solicitudes')
                ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
                ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_solicitudes.id', '=', $id_asignacion)
                ->orderBy('asignacion_solicitudes.id', 'desc')
                ->select(
                    'asignacion_solicitudes.id as idAsig',
                    'check_formulario_solicitudes.sComuna',
                    'asignacion_solicitudes.fecha',
                    'asignacion_solicitudes.estado_externo',
                    'asignacion_solicitudes.url_firma',
                    'asignacion_solicitudes.fecha_inicio',
                    'asignacion_solicitudes.fecha_local as fechadellocal',
                    'asignacion_solicitudes.fecha_fin',
                    'asignacion_solicitudes.estado_interno',
                    'check_formulario_solicitudes.sRegion',
                    'check_formulario_solicitudes.sDireccion',
                    'check_formulario_solicitudes.sSerie',
                    'check_formulario_solicitudes.sSC',
                    'check_formulario_solicitudes.sProveedor',
                    'check_formulario_solicitudes.sContacto',
                    'check_formulario_solicitudes.sTelefono',
                    'check_formulario_solicitudes.sModelo',
                    'check_formulario_solicitudes.numero_ot',
                    'check_formulario_solicitudes.contador_bn',
                    'check_formulario_solicitudes.contador_color',
                    'check_formulario_solicitudes.ip',
                    'check_formulario_solicitudes.usb',
                    'check_formulario_solicitudes.descripcion',
                    'check_formulario_solicitudes.tipo_componente',
                    'check_formulario_solicitudes.solicita_acessorios',
                    'check_formulario_solicitudes.observaciones',
                    'check_formulario_solicitudes.nombre_contacto_firma',
                    'check_formulario_solicitudes.correo_contacto',
                    'check_formulario_solicitudes.firma_contacto',
                    'check_formulario_solicitudes.estado_seleccionado',
                    'check_formulario_solicitudes.motivo_accesorio',
                    'check_formulario_solicitudes.t_uno',
                    'check_formulario_solicitudes.t_dos',
                    'check_formulario_solicitudes.t_tres',
                    'check_formulario_solicitudes.sCliente',
                    'check_formulario_solicitudes.Smarca',
                    'check_formulario_solicitudes.equipos',

                    'check_formulario_solicitudes.dFecCre as fecha_check',
                    'check_formulario_solicitudes.validador'
                )
                ->get();
            // $cantidadSolicitado = count($acceSoli);
            $cantidadSolicitado =  5;
            $solicitaAccesorio = "no";
            // $solicitaAccesorio = $asignacion_solicitudes[0]->solicita_acessorios;
            $solicitaAccesorio = "si";
            $rep  = "";
            // $items = [];
            // if ($solicitaAccesorio == "si" || $solicitaAccesorio == "SI") {

            //     for ($i = 0; $i <= 5; $i++) {

            //         $items[$i] = [
            //             "codigo " => "302LV31440",
            //             "q  " => " 1",
            //         ];
            //     }

            //     $rep = [
            //         "rep" => [

            //             "total" => $cantidadSolicitado,
            //             "item" => [
            //                 $items,
            //             ],

            //         ]
            //     ];
            // }


            $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
            $trabajadors_id = $mi_asignacion[0]->trabajadors_id;

            $mi_asignacion = DB::table('asignacion_solicitudes')
                ->where('asignacion_solicitudes.id', '=', $id_asignacion)
                ->get();



    //SLA Y DEPARTAMENTO
    $getDataApisol = DB::table('api_solicitudes')
    ->select("departamento","tipo_of_sinergy")
    ->where('api_solicitudes.id', '=', $idApiSolicitud)

    ->get();

            $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
            $trabajadors_id = $mi_asignacion[0]->trabajadors_id;

            $FechaHoraActual  = Carbon::now();
            $FechaHoraActual = $FechaHoraActual->toDateTimeString();
            //modificar el estado
            $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($id_asignacion);
            $asigSolicitudes->estado_interno = "Solicitar Repuestos";
            $asigSolicitudes->estado_externo  = "Solicitar Repuestos";
            // $asigSolicitudes->fecha_fin  = $FechaHoraActual;
            $asigSolicitudes->fecha_revision  = $FechaHoraActual;

            $asigSolicitudes->timestamps = false;
            $asigSolicitudes->save();

            //modificar el estado
            //modificar el estado
            $api_solicitudes =  App\api_solicitudes::findOrfail($idApiSolicitud);
            $api_solicitudes->fecha_estado = Carbon::now()->toDateString();
            $api_solicitudes->estado_interno = "Solicitar Repuestos";
            $api_solicitudes->estado_externo = "Solicitar Repuestos";
            $api_solicitudes->timestamps = false;
            $api_solicitudes->save();

            $datosTrabajador2 = DB::table('trabajadors')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->where('trabajadors.id', '=', $trabajadors_id)
                ->get();

            //obtener ssc de la instalacion


            // Modificar esado en webservice
            $nombreTecnico = $datosTrabajador2[0]->nombre_uno . " " . $datosTrabajador2[0]->apellido_uno;


            $estado = 3; //Finalizado
            $nombreTecnico = $nombreTecnico;
            $ssc = $asignacion_solicitudes[0]->sSC;
            $obs = $asignacion_solicitudes[0]->observaciones;
            $ent = $asignacion_solicitudes[0]->fechadellocal;
            $sal = $FechaHoraActual;
            // $ent = "";
            // $sal = "";
            $cont = $asignacion_solicitudes[0]->contador_bn;
            $col = $asignacion_solicitudes[0]->contador_color;
            $t1 = $asignacion_solicitudes[0]->t_uno;
            $t2 = $asignacion_solicitudes[0]->t_dos;
            $t3 = $asignacion_solicitudes[0]->t_tres;
            $estado_interno = "Solicitar Repuestos";


            $respuesta = $this->wsCambio_estado($id_asignacion, $estado, $nombreTecnico, $ssc, $obs, $ent, $sal, $cont, $col, $t1, $t2, $t3, $rep, $estado_interno);
            /**DATOS CORREO */
            $client = $asignacion_solicitudes[0]->sCliente;
            $contacto = $asignacion_solicitudes[0]->nombre_contacto_firma;
            $direccion = $asignacion_solicitudes[0]->sDireccion;
            $comuna = $asignacion_solicitudes[0]->sComuna;
            $region = $asignacion_solicitudes[0]->sRegion;
            $tipo_visita = "SERVICIO";
            $descripcionCliente = $asignacion_solicitudes[0]->descripcion;
            $sc = $asignacion_solicitudes[0]->sSC;
            $nSerie = $asignacion_solicitudes[0]->sSerie;
            $modelo = $asignacion_solicitudes[0]->sModelo;
            $contadorBn = $asignacion_solicitudes[0]->contador_bn;
            $contadorC = $asignacion_solicitudes[0]->contador_color;
            $estadoOpcion = $asignacion_solicitudes[0]->estado_seleccionado;
            $estadoInstalacion = "SOLICITAR REPUESTO";
            $observacionTecnico = $asignacion_solicitudes[0]->observaciones;
            $fecha_inicio = date_create($asignacion_solicitudes[0]->fecha_inicio);
            $fecha_inicio = date_format($fecha_inicio, "d-m-Y H:i:s");
            $fecha_fin = date_create($asignacion_solicitudes[0]->fecha_fin);
            $fecha_fin = date_format($fecha_fin, "d-m-Y H:i:s");
            $proveedor = DB::connection()->getDatabaseName();
            $correo_contacto = $asignacion_solicitudes[0]->correo_contacto;
            $idasig = $id_asignacion;


            $instalacion_accesorios = DB::table('checklist_instalacion_accesorios_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios_servicios.id_accesorio')
            ->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios_servicios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios_servicios.serie_parte')
            ->where('id_asig_servicio', '=', $id_asignacion)
            ->get();


            \PDF::setOptions((['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true]))
                ->loadView('solicitudes_servicios/pdf.pdfSolicitudProveedor', compact('idApiSolicitud','getDataApisol','instalacion_accesorios','acceManu', 'firmatrabajador', 'fecha_fin', 'fecha_inicio', 'datosTrabajador', 'fotos_servicios_cheks', 'acceSoli', 'acceDanos', 'fotos', 'tipo_equipamientos_detalleEquipamiento', 'tipo_equipamientos_dkCilindro', 'tipo_equipamientos_dvRevelado', 'asignacion_solicitudes'))
                ->save(storage_path('app/public/pdfServicio/') . $sc . 'servicio.pdf')
                ->stream();
            $size = Storage::size('public/pdfServicio/' . $sc . 'servicio.pdf');
            //  $correo = $this->sendEmail($fecha_inicio, $client, $contacto, $direccion, $comuna, $region, $tipo_visita, $descripcionCliente, $sc, $nSerie, $modelo, $contadorBn, $contadorC, $estadoOpcion, $estadoInstalacion, $observacionTecnico, $proveedor, $size, $idasig, $correo_contacto ,$apiSolicitud_id_pro[0]->proyecto_id);
            Storage::delete('/public/pdfServicio/' . $sc . 'servicio.pdf');
            if ($respuesta == "OK") {
                // return redirect('ver_api_solicitudes')->with('mensaje', 'Partes  Solicitados');
                return redirect('home')->with('mensaje', 'Partes  Solicitados');
            } else {
                // return redirect('ver_api_solicitudes')->with('mensaje', 'Partes  Solicitados');
                return redirect('home')->with('mensaje', 'Partes  Solicitados');
            }
        }, 5);
    }


    public function finalizarCheckCoordinadora($idasig)
    {


        return DB::transaction(function () use ($idasig) {
            try {
                $id_asignacion = Crypt::decryptString($idasig);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }

            $mi_asignacion = DB::table('asignacion_solicitudes')
                ->where('asignacion_solicitudes.id', '=', $id_asignacion)
                ->get();

            $id_trabajador = $mi_asignacion[0]->trabajadors_id;
            $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
            $trabajadors_id = $mi_asignacion[0]->trabajadors_id;

            //datos del usuario
            $datosTrabajador = DB::table('trabajadors')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->where('trabajadors.id', '=', $trabajadors_id)
                ->get();
            $firmatrabajador = DB::table('firma_clientes')
                ->where('firma_clientes.id_tecnico', '=', $trabajadors_id)
                ->get();

            //tracket proyecto_id
            $apiSolicitud = DB::table('api_solicitudes')
                ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->where('api_solicitudes.id', '=', $idApiSolicitud)
                ->get();
                $apiSolicitud_id_pro = DB::table('api_solicitudes')
                ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->where('api_solicitudes.id', '=', $idApiSolicitud)
                ->select('proyectos.id as proyecto_id')
                ->get();
            // tipo_equipamientos
            $tipo_equipamientos_dvRevelado = DB::table('tipo_equipamientos')
                ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
                ->where('tipo_equipamientos.opcion', '=', "DV - UN Revelado(s)")
                ->get();
            $tipo_equipamientos_dkCilindro = DB::table('tipo_equipamientos')
                ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
                ->where('tipo_equipamientos.opcion', '=', "DK - UN Cilindro(s)")
                ->get();
            $tipo_equipamientos_detalleEquipamiento = DB::table('tipo_equipamientos')
                ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
                ->where('tipo_equipamientos.opcion', '=', "Detalle del equipamiento")
                ->get();
            $fotos = DB::table('fotos_checks_servicios')
                ->where('fotos_checks_servicios.id_servicios', '=', $id_asignacion)
                ->get();
            $acceDanos = DB::table('check_accesorios_danados_servicios')
                ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_danados_servicios.id_accesorio')
                ->where('check_accesorios_danados_servicios.id_asig_serv', '=', $id_asignacion)
                ->get();
            $acceSoli = DB::table('check_accesorios_servicios')
                ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_servicios.id_accesorio')
                ->where('check_accesorios_servicios.id_asig_servicio', '=', $id_asignacion)
                ->get();
            //estas son las tres imagenes
            $fotos_servicios_cheks = DB::table('fotos_servicios_cheks')
                ->where('fotos_servicios_cheks.checklist_asignacion_id', '=', $id_asignacion)
                ->get();
            $acceManu = DB::table('accesorios_manuales_servicios')
                ->where('accesorios_manuales_servicios.id_checklist_instalacion', '=', $id_asignacion)
                ->get();

            $asignacion_solicitudes = DB::table('asignacion_solicitudes')
                ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
                ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_solicitudes.id', '=', $id_asignacion)
                ->orderBy('asignacion_solicitudes.id', 'desc')
                ->select(
                    'asignacion_solicitudes.id as idAsig',
                    'check_formulario_solicitudes.sComuna',
                    'asignacion_solicitudes.fecha',
                    'asignacion_solicitudes.estado_externo',
                    'asignacion_solicitudes.url_firma',
                    'asignacion_solicitudes.fecha_inicio',
                    'asignacion_solicitudes.fecha_local as fechadellocal',
                    'asignacion_solicitudes.fecha_fin',
                    'asignacion_solicitudes.estado_interno',
                    'check_formulario_solicitudes.sRegion',
                    'check_formulario_solicitudes.sDireccion',
                    'check_formulario_solicitudes.sSerie',
                    'check_formulario_solicitudes.sSC',
                    'check_formulario_solicitudes.sProveedor',
                    'check_formulario_solicitudes.sContacto',
                    'check_formulario_solicitudes.sTelefono',
                    'check_formulario_solicitudes.sModelo',
                    'check_formulario_solicitudes.numero_ot',
                    'check_formulario_solicitudes.contador_bn',
                    'check_formulario_solicitudes.contador_color',
                    'check_formulario_solicitudes.ip',
                    'check_formulario_solicitudes.usb',
                    'check_formulario_solicitudes.descripcion',
                    'check_formulario_solicitudes.tipo_componente',
                    'check_formulario_solicitudes.solicita_acessorios',
                    'check_formulario_solicitudes.observaciones',
                    'check_formulario_solicitudes.nombre_contacto_firma',
                    'check_formulario_solicitudes.correo_contacto',
                    'check_formulario_solicitudes.firma_contacto',
                    'check_formulario_solicitudes.estado_seleccionado',
                    'check_formulario_solicitudes.motivo_accesorio',
                    'check_formulario_solicitudes.t_uno',
                    'check_formulario_solicitudes.t_dos',
                    'check_formulario_solicitudes.t_tres',
                    'check_formulario_solicitudes.sCliente',
                    'check_formulario_solicitudes.dFecCre as fecha_check',
                    'check_formulario_solicitudes.validador',
                    'check_formulario_solicitudes.equipos',
                    'check_formulario_solicitudes.Smarca',
                    'check_formulario_solicitudes.equipos'

                )
                ->get();
            // $cantidadSolicitado = count($acceSoli);
            $cantidadSolicitado =  5;
            $solicitaAccesorio = "no";
            // $solicitaAccesorio = $asignacion_solicitudes[0]->solicita_acessorios;
            $solicitaAccesorio = "si";
            $rep  = "";
            $items = [];
            if ($solicitaAccesorio == "si" || $solicitaAccesorio == "SI") {

                for ($i = 0; $i <= 5; $i++) {

                    $items[$i] = [
                        "codigo " => "302LV31440",
                        "q  " => " 1",
                    ];
                }

                $rep = [
                    "rep" => [

                        "total" => $cantidadSolicitado,
                        "item" => [
                            $items,
                        ],

                    ]
                ];
            }


            $mi_asignacion = DB::table('asignacion_solicitudes')
                ->where('asignacion_solicitudes.id', '=', $id_asignacion)
                ->get();

                $FechaHoraActual  = Carbon::now();
                $FechaHoraActual = $FechaHoraActual->toDateTimeString();

            $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
            $trabajadors_id = $mi_asignacion[0]->trabajadors_id;

            $FechaHoraActual  = Carbon::now();
            $FechaHoraActual = $FechaHoraActual->toDateTimeString();
            //modificar el estado
            $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($id_asignacion);
            $asigSolicitudes->estado_interno = "FINALIZADO";
            $asigSolicitudes->estado_externo  = "FINALIZADO";
            $asigSolicitudes->fecha_revision  = $FechaHoraActual;

            // $asigSolicitudes->fecha_fin  = $FechaHoraActual;
            $asigSolicitudes->timestamps = false;
            $asigSolicitudes->save();

            //modificar el estado
            //modificar el estado
            $api_solicitudes =  App\api_solicitudes::findOrfail($idApiSolicitud);
            $api_solicitudes->fecha_estado = Carbon::now()->toDateString();
            $api_solicitudes->estado_interno = "FINALIZADO";
            $api_solicitudes->estado_externo = "FINALIZADO";
            $api_solicitudes->timestamps = false;
            $api_solicitudes->save();

            $datosTrabajador2 = DB::table('trabajadors')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->where('trabajadors.id', '=', $trabajadors_id)
                ->get();

            //obtener ssc de la instalacion


            // Modificar esado en webservice
            $nombreTecnico = $datosTrabajador2[0]->nombre_uno . " " . $datosTrabajador2[0]->apellido_uno;


            $estado = 5; //Finalizado
            $nombreTecnico = $nombreTecnico;
            $ssc = $asignacion_solicitudes[0]->sSC;
            $obs = $asignacion_solicitudes[0]->observaciones;
            $ent = $asignacion_solicitudes[0]->fechadellocal;
            $sal = $asignacion_solicitudes[0]->fecha_fin;
            // $ent = "";asigSolicitudes
            // $sal = "";
            $cont = $asignacion_solicitudes[0]->contador_bn;
            $col = $asignacion_solicitudes[0]->contador_color;
            $t1 = $asignacion_solicitudes[0]->t_uno;
            $t2 = $asignacion_solicitudes[0]->t_dos;
            $t3 = $asignacion_solicitudes[0]->t_tres;
            $estado_interno = "FINALIZADO";

            $idAsignacion = "";
      //      $respuesta = $this->wsCambio_estado($idAsignacion, $estado, $nombreTecnico, $ssc, $obs, $ent, $sal, $cont, $col, $t1, $t2, $t3, $rep, $estado_interno);
            //$respuesta = "OK";

            /**DATOS CORREO */
            $client = $asignacion_solicitudes[0]->sCliente;
            $contacto = $asignacion_solicitudes[0]->nombre_contacto_firma;
            $direccion = $asignacion_solicitudes[0]->sDireccion;
            $comuna = $asignacion_solicitudes[0]->sComuna;
            $region = $asignacion_solicitudes[0]->sRegion;
            $tipo_visita = "SERVICIO";
            $descripcionCliente = $asignacion_solicitudes[0]->descripcion;
            $sc = $asignacion_solicitudes[0]->sSC;
            $nSerie = $asignacion_solicitudes[0]->sSerie;
            $modelo = $asignacion_solicitudes[0]->sModelo;
            $contadorBn = $asignacion_solicitudes[0]->contador_bn;
            $contadorC = $asignacion_solicitudes[0]->contador_color;
            $estadoOpcion = $asignacion_solicitudes[0]->estado_seleccionado;
            $estadoInstalacion = "FINALIZADO";
            $observacionTecnico = $asignacion_solicitudes[0]->observaciones;
            $fecha_inicio = date_create($asignacion_solicitudes[0]->fecha_inicio);
            $fecha_inicio = date_format($fecha_inicio, "d-m-Y H:i:s");
            $fecha_fin = date_create($asignacion_solicitudes[0]->fecha_fin);
            $fecha_fin = date_format($fecha_fin, "d-m-Y H:i:s");
            $proveedor = DB::connection()->getDatabaseName();
            $correo_contacto = $asignacion_solicitudes[0]->correo_contacto;
            $idasig = $id_asignacion;

            $getDataApisol = DB::table('api_solicitudes')
            ->select("departamento","tipo_of_sinergy")
            ->where('api_solicitudes.id', '=', $idApiSolicitud)

            ->get();

            $instalacion_accesorios = DB::table('checklist_instalacion_accesorios_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios_servicios.id_accesorio')
            ->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios_servicios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios_servicios.serie_parte')
            ->where('id_asig_servicio', '=', $id_asignacion)
            ->get();


            // $updateSolRemota = App\solicitudes_remotas::where('id', '=', $idSolicitudRemota)->first();
            // $updateSolRemota->estado = "FINALIZADO";
            // $updateSolRemota->fecha_finalizada = $FechaHoraActual;
            // $updateSolRemota->timestamps = false;
            // $updateSolRemota->save();


            $FechaHoraActual  = Carbon::now();
            $FechaHoraActual = $FechaHoraActual->toDateTimeString();

            $solicitudes_remotas = App\solicitudes_remotas::where('id', '=', $api_solicitudes->id_solicitudes_remotas)->first();
            $solicitudes_remotas->estado = "FINALIZADO";
            // $solicitudes_remotas->fecha_finalizada = $FechaHoraActual;

            $solicitudes_remotas->timestamps = false;
            $solicitudes_remotas->save();

            $banco_api_solicitudes = App\banco_api_solicitudes::findOrfail($solicitudes_remotas->id_api_banco_solicitud);
            $banco_api_solicitudes->estado_atencion_remota = 0;
            $banco_api_solicitudes->timestamps = false;
            $banco_api_solicitudes->save();


            $idRemoto = $api_solicitudes->id_solicitudes_remotas;

            \PDF::setOptions((['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true]))
                ->loadView('solicitudes_servicios/pdf.pdfSolicitudProveedor', compact('idApiSolicitud','getDataApisol','instalacion_accesorios','acceManu', 'firmatrabajador', 'fecha_fin', 'fecha_inicio', 'datosTrabajador', 'fotos_servicios_cheks', 'acceSoli', 'acceDanos', 'fotos', 'tipo_equipamientos_detalleEquipamiento', 'tipo_equipamientos_dkCilindro', 'tipo_equipamientos_dvRevelado', 'asignacion_solicitudes'))
                ->save(storage_path('app/public/pdfServicio/') . $sc . 'servicio.pdf')
                ->stream();
            $size = Storage::size('public/pdfServicio/' . $sc . 'servicio.pdf');
             $this->sendEmail($fecha_inicio, $client, $contacto, $direccion, $comuna, $region, $tipo_visita, $descripcionCliente, $sc, $nSerie, $modelo, $contadorBn, $contadorC, $estadoOpcion, $estadoInstalacion, $observacionTecnico, $proveedor, $size, $idasig, $correo_contacto ,$apiSolicitud_id_pro[0]->proyecto_id,$idRemoto);
            Storage::delete('/public/pdfServicio/' . $sc . 'servicio.pdf');


            return redirect('home')->with('mensaje', 'Checklist Solicitud FINALIZADO');
            // return redirect('verservicios')->with('mensaje', 'Checklist Solicitud FINALIZADO');

            // return redirect('ver_api_solicitudes')->with('mensaje', 'Checklist Solicitud FINALIZADO');

            // if ($respuesta == "OK") {
            //     return redirect('ver_api_solicitudes')->with('mensaje', 'Checklist Solicitud FINALIZADO');
            // } else {
            //     return redirect('ver_api_solicitudes')->with('mensaje', 'Checklist Solicitud Finalizado');
            // }
        }, 5);
    }




    public function cancelar_imagenes_servicios(request $request)
    {

        $validar = DB::table('fotos_servicios_cheks')->where('checklist_asignacion_id', $request->idAsig)->get();
        if ($validar != "") {
            if (count($validar) < 3) {
                $deletedRows = App\fotos_servicios_cheks::where('checklist_asignacion_id', $request->idAsig)->delete();
                return count($validar);
            } else {
                return "ok";
            }
        }
    }

    public function save_imagen_accesorios_servicios(request $request)
    {

        $numeroRandom = rand();
        // $deletedRows = App\fotos_checks_servicios::where('id_servicios', $request->idAsig)->delete();
        //foto1
        if ($request->file('cargafotoa1') != "") {
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa1_' . $request->idAsig . '.jpeg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa1_' . $request->idAsig . '.jpg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa1_' . $request->idAsig . '.png')->delete();
            $file = $request->file('cargafotoa1');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fas1_". $numeroRandom . $request->idAsig . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));

            $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fas1_".'%')->where("id_servicios","=",$request->idAsig)->delete();

            $fotos_check_instalacions = new App\fotos_checks_servicios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
            $fotos_check_instalacions->id_servicios   = $request->idAsig;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }


        //foto2
        if ($request->file('cargafotoa2') != "") {
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa2_' . $request->idAsig . '.jpeg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa2_' . $request->idAsig . '.jpg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa2_' . $request->idAsig . '.png')->delete();
            $file = $request->file('cargafotoa2');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fas2_". $numeroRandom . $request->idAsig . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
            $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fas2_".'%')->where("id_servicios","=",$request->idAsig)->delete();

            $fotos_check_instalacions = new App\fotos_checks_servicios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
            $fotos_check_instalacions->id_servicios   = $request->idAsig;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto3
        if ($request->file('cargafotoa3') != "") {
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa3_' . $request->idAsig . '.jpeg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa3_' . $request->idAsig . '.jpg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa3_' . $request->idAsig . '.png')->delete();
            $file = $request->file('cargafotoa3');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fas3_". $numeroRandom . $request->idAsig . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
            $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fas3_".'%')->where("id_servicios","=",$request->idAsig)->delete();

            $fotos_check_instalacions = new App\fotos_checks_servicios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
            $fotos_check_instalacions->id_servicios   = $request->idAsig;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto4
        if ($request->file('cargafotoa4') != "") {
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa4_' . $request->idAsig . '.jpeg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa4_' . $request->idAsig . '.jpg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa4_' . $request->idAsig . '.png')->delete();
            $file = $request->file('cargafotoa4');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fas4_". $numeroRandom . $request->idAsig . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
            $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fas4_".'%')->where("id_servicios","=",$request->idAsig)->delete();

            $fotos_check_instalacions = new App\fotos_checks_servicios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
            $fotos_check_instalacions->id_servicios   = $request->idAsig;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto5
        if ($request->file('cargafotoa5') != "") {
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa5_' . $request->idAsig . '.jpeg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa5_' . $request->idAsig . '.jpg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa5_' . $request->idAsig . '.png')->delete();
            $file = $request->file('cargafotoa5');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fas5_". $numeroRandom . $request->idAsig . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
            $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fas5_".'%')->where("id_servicios","=",$request->idAsig)->delete();

            $fotos_check_instalacions = new App\fotos_checks_servicios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
            $fotos_check_instalacions->id_servicios   = $request->idAsig;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto6
        if ($request->file('cargafotoa6') != "") {
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa6_' . $request->idAsig . '.jpeg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa6_' . $request->idAsig . '.jpg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa6_' . $request->idAsig . '.png')->delete();
            $file = $request->file('cargafotoa6');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fas6_". $numeroRandom . $request->idAsig . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
            $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fas6_".'%')->where("id_servicios","=",$request->idAsig)->delete();

            $fotos_check_instalacions = new App\fotos_checks_servicios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
            $fotos_check_instalacions->id_servicios   = $request->idAsig;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        } //foto7
        if ($request->file('cargafotoa7') != "") {
            $file = $request->file('cargafotoa7');
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa7_' . $request->idAsig . '.jpeg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa7_' . $request->idAsig . '.jpg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa7_' . $request->idAsig . '.png')->delete();
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fas7_". $numeroRandom . $request->idAsig . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
            $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fas7_".'%')->where("id_servicios","=",$request->idAsig)->delete();

            $fotos_check_instalacions = new App\fotos_checks_servicios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
            $fotos_check_instalacions->id_servicios   = $request->idAsig;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto8
        if ($request->file('cargafotoa8') != "") {
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa8_' . $request->idAsig . '.jpeg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa8_' . $request->idAsig . '.jpg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa8_' . $request->idAsig . '.png')->delete();
            $file = $request->file('cargafotoa8');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fas8_". $numeroRandom . $request->idAsig . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
            $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fas8_".'%')->where("id_servicios","=",$request->idAsig)->delete();

            $fotos_check_instalacions = new App\fotos_checks_servicios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
            $fotos_check_instalacions->id_servicios   = $request->idAsig;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto9
        if ($request->file('cargafotoa9') != "") {
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa9_' . $request->idAsig . '.jpeg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa9_' . $request->idAsig . '.jpg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa9_' . $request->idAsig . '.png')->delete();
            $file = $request->file('cargafotoa9');

            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fas9_". $numeroRandom . $request->idAsig . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
            $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fas9_".'%')->where("id_servicios","=",$request->idAsig)->delete();

            $fotos_check_instalacions = new App\fotos_checks_servicios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
            $fotos_check_instalacions->id_servicios   = $request->idAsig;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto10
        if ($request->file('cargafotoa10') != "") {
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa10_' . $request->idAsig . '.jpeg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa10_' . $request->idAsig . '.jpg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa10_' . $request->idAsig . '.png')->delete();
            $file = $request->file('cargafotoa10');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fas10_". $numeroRandom . $request->idAsig . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
            $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fas10_".'%')->where("id_servicios","=",$request->idAsig)->delete();

            $fotos_check_instalacions = new App\fotos_checks_servicios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
            $fotos_check_instalacions->id_servicios   = $request->idAsig;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto11
        if ($request->file('cargafotoa11') != "") {
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa11_' . $request->idAsig . '.jpeg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa11_' . $request->idAsig . '.jpg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa11_' . $request->idAsig . '.png')->delete();
            $file = $request->file('cargafotoa11');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fas11_". $numeroRandom . $request->idAsig . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
            $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fas11_".'%')->where("id_servicios","=",$request->idAsig)->delete();

            $fotos_check_instalacions = new App\fotos_checks_servicios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
            $fotos_check_instalacions->id_servicios   = $request->idAsig;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto12
         if ($request->file('cargafotoa12') != "") {
        //     $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa12_' . $request->idAsig . '.jpeg')->delete();
        //     $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa12_' . $request->idAsig . '.jpg')->delete();
        //     $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa12_' . $request->idAsig . '.png')->delete();
            $file = $request->file('cargafotoa12');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fas12_". $numeroRandom . $request->idAsig . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
            $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fas12_".'%')->where("id_servicios","=",$request->idAsig)->delete();

            $fotos_check_instalacions = new App\fotos_checks_servicios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
            $fotos_check_instalacions->id_servicios   = $request->idAsig;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }
        //foto13
        if ($request->file('cargafotoa13') != "") {
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa13_' . $request->idAsig . '.jpeg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa13_' . $request->idAsig . '.jpg')->delete();
            // $deletedRows = App\fotos_checks_servicios::where('descripcion_foto', 'fa13_' . $request->idAsig . '.png')->delete();
            $file = $request->file('cargafotoa13');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = "fas13_". $numeroRandom . $request->idAsig . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_sistema_check')->put("foto_servicios/" . $nombreGuardar1,  \File::get($file));
            $deletedRows = App\fotos_checks_servicios::where('url', 'LIKE', '%'."foto_servicios/fas13_".'%')->where("id_servicios","=",$request->idAsig)->delete();

            $fotos_check_instalacions = new App\fotos_checks_servicios;
            $fotos_check_instalacions->descripcion_foto  = $nombreGuardar1;
            $fotos_check_instalacions->url  = "foto_servicios/" . $nombreGuardar1;
            $fotos_check_instalacions->id_servicios   = $request->idAsig;
            $fotos_check_instalacions->timestamps = false;
            $fotos_check_instalacions->save();
        }

        return [
            'status' => 200,
        ];
    }
    public function ver_checklistservicio_coordinadora_home(request $request)
    {

        $id_asignacion = $request->id;

        $mi_asignacion = DB::table('asignacion_solicitudes')
            ->where('asignacion_solicitudes.id', '=', $id_asignacion)
            ->get();

        $id_trabajador = $mi_asignacion[0]->trabajadors_id;
        $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
        $trabajadors_id = $mi_asignacion[0]->trabajadors_id;

            $obtenerFechaIngreso = DB::table('api_solicitudes')
        ->where('api_solicitudes.id', '=', $idApiSolicitud)
        ->get();

     $fechaIngreso=  $obtenerFechaIngreso[0]->dFecha;



        $asignacion_solicitudes = DB::table('asignacion_solicitudes')
            ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_solicitudes.id', '=', $id_asignacion)
            ->orderBy('asignacion_solicitudes.id', 'desc')
            ->select(
                'asignacion_solicitudes.id as idAsig',
                'check_formulario_solicitudes.sComuna',
                'asignacion_solicitudes.fecha',
                'asignacion_solicitudes.estado_externo',
                'asignacion_solicitudes.url_firma',
                'asignacion_solicitudes.estado_interno',
                'asignacion_solicitudes.estado_interno',
                'check_formulario_solicitudes.sDireccion',
                'check_formulario_solicitudes.sProveedor',
                'check_formulario_solicitudes.sRegion',
                'check_formulario_solicitudes.Smarca',


                'asignacion_solicitudes.fecha_asignacion',
                'asignacion_solicitudes.fecha_revision',
                'check_formulario_solicitudes.sSerie',
                'check_formulario_solicitudes.sContacto',
                'check_formulario_solicitudes.equipos',
                'check_formulario_solicitudes.sTelefono',
                'check_formulario_solicitudes.sModelo',
                'check_formulario_solicitudes.numero_ot',
                'check_formulario_solicitudes.contador_bn',
                'check_formulario_solicitudes.contador_color',
                'check_formulario_solicitudes.ip',
                'check_formulario_solicitudes.usb',
                'check_formulario_solicitudes.descripcion',
                'check_formulario_solicitudes.tipo_componente',
                'check_formulario_solicitudes.solicita_acessorios',
                'check_formulario_solicitudes.observaciones',
                'check_formulario_solicitudes.nombre_contacto_firma',
                'check_formulario_solicitudes.correo_contacto',
                'check_formulario_solicitudes.firma_contacto',
                'check_formulario_solicitudes.estado_seleccionado',
                'check_formulario_solicitudes.motivo_accesorio',
                'check_formulario_solicitudes.t_uno',
                'check_formulario_solicitudes.t_dos',
                'check_formulario_solicitudes.t_tres',
                'check_formulario_solicitudes.sCliente',
                'asignacion_solicitudes.fecha_inicio',
                'asignacion_solicitudes.fecha_fin',
                'asignacion_solicitudes.fecha_local',
                'check_formulario_solicitudes.validador',
                'asignacion_solicitudes.fecha_transito',
                'check_formulario_solicitudes.motivo_accesorio',

            )
            ->get();

            //SLA Y DEPARTAMENTO
            $getDataApisol = DB::table('api_solicitudes')
            ->select("departamento","tipo_of_sinergy")
            ->where('api_solicitudes.id', '=', $idApiSolicitud)

            ->get();

        //datos del usuario
        $datosTrabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.id', '=', $trabajadors_id)
            ->get();
        $firmaTrabajador = DB::table('firma_clientes')
            ->where('id_tecnico', '=', $trabajadors_id)
            ->get();
        //obtener nombre del proyecto
        //tracket proyecto_id
        $apiSolicitud = DB::table('api_solicitudes')
            ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('api_solicitudes.id', '=', $idApiSolicitud)
            ->get();

        // tipo_equipamientos
        $tipo_equipamientos_dvRevelado = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "DV - UN Revelado(s)")
            ->get();

        $tipo_equipamientos_dkCilindro = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "DK - UN Cilindro(s)")
            ->get();

        $tipo_equipamientos_detalleEquipamiento = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "Detalle del equipamiento")
            ->get();

        $fotos = DB::table('fotos_checks_servicios')
            ->where('fotos_checks_servicios.id_servicios', '=', $id_asignacion)
            ->get();

        $acceDanos = DB::table('check_accesorios_danados_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_danados_servicios.id_accesorio')
            ->where('check_accesorios_danados_servicios.id_asig_serv', '=', $id_asignacion)
            ->get();
        $acceSoli = DB::table('check_accesorios_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_servicios.id_accesorio')

            ->where('check_accesorios_servicios.id_asig_servicio', '=', $id_asignacion)
            ->get();
        //estas son las tres imagenes
        $fotos_servicios_cheks = DB::table('fotos_servicios_cheks')
            ->where('fotos_servicios_cheks.checklist_asignacion_id', '=', $id_asignacion)
            ->get();

        $accesorios_manuales = DB::table('accesorios_manuales_servicios')
            ->where('id_checklist_instalacion', '=', $id_asignacion)
            ->get();

        $instalacion_accesorios = DB::table('checklist_instalacion_accesorios_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios_servicios.id_accesorio')
            ->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios_servicios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios_servicios.serie_parte')
            ->where('id_asig_servicio', '=', $id_asignacion)
            ->get();
        $instalacion_accesorios_manuales = DB::table('instalacion_accesorios_manuales_servicios')
            ->where('id_checklist_instalacion', '=', $id_asignacion)
            ->get();

        return view('solicitudes_servicios.ver_checklistservicio_coordinadora', compact('idApiSolicitud','getDataApisol','fechaIngreso','instalacion_accesorios', 'instalacion_accesorios_manuales', 'accesorios_manuales', 'datosTrabajador', 'apiSolicitud', 'fotos_servicios_cheks', 'acceSoli', 'acceDanos', 'fotos', 'tipo_equipamientos_detalleEquipamiento', 'tipo_equipamientos_dkCilindro', 'tipo_equipamientos_dvRevelado', 'asignacion_solicitudes', 'firmaTrabajador'));
    }


    function insertarSolicitud($data,$idSolicitudRemota){

        // solicitudes_remotas


        $getDataRemota = App\solicitudes_remotas::where('id', '=', $idSolicitudRemota)->first();


         $Api_solicitudes = App\api_solicitudes::where('id_solicitudes_remotas', '=', $idSolicitudRemota)->first();

         if ($Api_solicitudes) {
         }else{
            $Api_solicitudes = new App\api_solicitudes;
         }
        $Api_solicitudes->nId_OT = $data[0]->nId_OT;
        // $Api_solicitudes->sSC = $data[0]->sSC;
         $Api_solicitudes->sSC = $getDataRemota->Ssc;
         $Api_solicitudes->inc = $getDataRemota->inc;


        $Api_solicitudes->sProveedor = $data[0]->sProveedor;
        $Api_solicitudes->sPrioridad = $data[0]->sPrioridad;
        $Api_solicitudes->dFecha = $data[0]->dFecha;
        $Api_solicitudes->sCliente = $data[0]->sCliente;
        $Api_solicitudes->sTelefono = $data[0]->sTelefono;
        $Api_solicitudes->sContacto = $data[0]->sContacto;
        $Api_solicitudes->sDireccion = $data[0]->sDireccion;
        $Api_solicitudes->sComuna = $data[0]->sComuna;
        $Api_solicitudes->sRegion = $data[0]->sRegion;
        $Api_solicitudes->sTipoLlamada = $data[0]->sTipoLlamada;
        // $Api_solicitudes->sDescripcion = $data[0]->sDescripcion;
        $Api_solicitudes->sQR = $data[0]->sQR;
        $Api_solicitudes->sSerie = $data[0]->sSerie;
        $Api_solicitudes->sModelo = $data[0]->sModelo;
        $Api_solicitudes->sUbicacion = $data[0]->sUbicacion;
        $Api_solicitudes->sTelefono = $data[0]->sTelefono;
        $Api_solicitudes->dFecCre = $data[0]->dFecCre;
        $Api_solicitudes->sTipoContrato = $data[0]->sTipoContrato;
        $Api_solicitudes->nId_EstadoOT = $data[0]->nId_EstadoOT;
        $Api_solicitudes->dFechaEstadoOT = $data[0]->dFechaEstadoOT;
        $Api_solicitudes->nId_Tecnico = $data[0]->nId_Tecnico;
        $Api_solicitudes->sObs = $data[0]->sObs;
        $Api_solicitudes->dFechaCreacion = $data[0]->dFechaCreacion;
        $Api_solicitudes->dFechaModif = $data[0]->dFechaModif;
        $Api_solicitudes->bDeleted = $data[0]->bDeleted;
        $Api_solicitudes->dFechaFab = $data[0]->dFechaFab;
        $Api_solicitudes->sUsuario = $data[0]->sUsuario;
         $Api_solicitudes->proveedor_servicio = "SYNERGY";


        // $Api_solicitudes->area= $data[0]->area;
        $Api_solicitudes->Smarca= $data[0]->Smarca;
         $Api_solicitudes->sIP	= $data[0]->sIP;
        $Api_solicitudes->estado_externo= $data[0]->estado_externo;
        $Api_solicitudes->zona_geoge= $data[0]->zona_geoge;
        $Api_solicitudes->correlativo= $data[0]->correlativo;
        $Api_solicitudes->tipo_of_sinergy= $data[0]->tipo_of_sinergy;
        $Api_solicitudes->email_contacto= $data[0]->email_contacto;
        $Api_solicitudes->sCiudad= $data[0]->sCiudad;
        $Api_solicitudes->area= $data[0]->area;
        $Api_solicitudes->cod_of= $data[0]->cod_of;
        $Api_solicitudes->num_guia_despacho= $data[0]->num_guia_despacho;



        $Api_solicitudes->estado_interno= $data[0]->estado_interno;
        $Api_solicitudes->tipo_asignacion_interna= 1;


        //agregamos
        $Api_solicitudes->estado_atencion_remota     =  $data[0]->estado_atencion_remota;
        $Api_solicitudes->id_solicitudes_remotas     = $data[0]->idSolicitudRemota;
        $Api_solicitudes->sDescripcion     =$data[0]->sDescripcion.",...  Asunto: ".$data[0]->descripcion_asuntos.", Observacion: " . $data[0]->observaciones;


        $Api_solicitudes->timestamps = false;

        $Api_solicitudes->save();

return $Api_solicitudes->id;
    }


    public function remotoaya(request $req)
    {




        return DB::transaction(function () use ($req) {



    // Field 'externo' is present in the request
            // Your code here
            $idSolicitudRemota = $req->finalizarremoto;

            $dataSolicitudRemota  =   App\solicitudes_remotas::select("asignacion_banco_api_solis.id_tecnico as id_user","solicitudes_remotas.id as idSolicitudRemota","asignacion_banco_api_solis.solucionado","asignacion_banco_api_solis.observacion_tecnico as   observacionTecnico","banco_api_solicitudes.*","solicitudes_remotas.*","asuntos.descripcion as descripcion_asuntos")
        ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
        ->join("banco_api_solicitudes","banco_api_solicitudes.id","=","solicitudes_remotas.id_api_banco_solicitud")
        ->join("asignacion_banco_api_solis","asignacion_banco_api_solis.id_solicitud_remota","=","solicitudes_remotas.id")

        ->where('solicitudes_remotas.id', $idSolicitudRemota)
        ->get();



        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();

        $updateSolRemota = App\solicitudes_remotas::where('id', '=', $idSolicitudRemota)->first();
        $updateSolRemota->estado = "FINALIZADO";
        $updateSolRemota->fecha_finalizada = $FechaHoraActual;
        $updateSolRemota->timestamps = false;
        $updateSolRemota->save();


        $updateBancoSoli = App\banco_api_solicitudes::where('id', '=', $updateSolRemota->id_api_banco_solicitud)->first();
        $updateBancoSoli->estado_atencion_remota = 0;
        $updateBancoSoli->timestamps = false;
        $updateBancoSoli->save();




        $datos_trabajador = DB::table('trabajadors')
        ->where('trabajadors.id_login', '=', $dataSolicitudRemota[0]->id_user)
        ->get();


        $getAppsoli = App\api_solicitudes::where('id_solicitudes_remotas', '=', $idSolicitudRemota)->first();
        $id_solicitud= $getAppsoli->id;

        // $id_solicitud=  $this->insertarSolicitud($dataSolicitudRemota,$idSolicitudRemota);



        $api_solicitudes =  App\api_solicitudes::findOrfail($id_solicitud);
        $api_solicitudes->tracker_idtracker = 12; //el numero 12 es de servicios
        $api_solicitudes->estado_interno = "FINALIZADO";
        $api_solicitudes->estado_externo = "FINALIZADO";

        // $api_solicitudes->fecha_asignado = $request->fecha_servicio;
        $api_solicitudes->timestamps = false;
        $api_solicitudes->save();



        $solicitud = DB::table('api_solicitudes')
        ->where('api_solicitudes.id', '=', $id_solicitud)
        ->get();


        $check_solicitud = new App\check_formulario_solicitudes;
            $check_solicitud->descripcion = $solicitud[0]->sDescripcion;
            $check_solicitud->numero_ot = $solicitud[0]->sSC;
            $check_solicitud->nId_OT = $solicitud[0]->nId_OT;
            $check_solicitud->sSC = $solicitud[0]->sSC;
            $check_solicitud->sProveedor = $solicitud[0]->sProveedor;
            $check_solicitud->sPrioridad = $solicitud[0]->sPrioridad;
            $check_solicitud->dFecha = $solicitud[0]->dFecha;
            $check_solicitud->sCliente = $solicitud[0]->sCliente;
            $check_solicitud->sTelefono = $solicitud[0]->sTelefono;
            $check_solicitud->sContacto = $solicitud[0]->sContacto;
            $check_solicitud->sDireccion = $solicitud[0]->sDireccion;
            $check_solicitud->sComuna = $solicitud[0]->sComuna;
            $check_solicitud->sRegion = $solicitud[0]->sRegion;
            $check_solicitud->sTipoLlamada = $solicitud[0]->sTipoLlamada;
            $check_solicitud->sDescripcion = $solicitud[0]->sDescripcion;
            $check_solicitud->sQR = $solicitud[0]->sQR;
            $check_solicitud->sSerie = $solicitud[0]->sSerie;
            $check_solicitud->sModelo = $solicitud[0]->sModelo;
            $check_solicitud->sUbicacion = $solicitud[0]->sUbicacion;
            $check_solicitud->dFecCre = $solicitud[0]->dFecCre;
            $check_solicitud->sTipoContrato = $solicitud[0]->sTipoContrato;
            $check_solicitud->nId_EstadoOT = $solicitud[0]->nId_EstadoOT;
            $check_solicitud->dFechaEstadoOT = $solicitud[0]->dFechaEstadoOT;
            $check_solicitud->nId_Tecnico = $solicitud[0]->nId_Tecnico;
            $check_solicitud->sObs = $solicitud[0]->sObs;
            $check_solicitud->dFechaFab = $solicitud[0]->dFechaFab;
            $check_solicitud->dFechaCreacion = $solicitud[0]->dFechaCreacion;
            $check_solicitud->dFechaModif = $solicitud[0]->dFechaModif;
            $check_solicitud->bDeleted = $solicitud[0]->bDeleted;
            $check_solicitud->sUsuario = $solicitud[0]->sUsuario;
            $check_solicitud->equipos = $solicitud[0]->equipos;
            $check_solicitud->Smarca = $solicitud[0]->Smarca;
            $check_solicitud->ip = $api_solicitudes->sIP;


            $check_solicitud->timestamps = false;
            $check_solicitud->save();



  //guardarpdf


            $idremoto =$idSolicitudRemota;

            $updateAsiganacionBanco = App\asignacion_banco_api_solis::where('id_solicitud_remota', '=', $idremoto)->first();
            $updateAsiganacionBanco->estado = "FINALIZADO";
            $updateAsiganacionBanco->timestamps = false;
            $updateAsiganacionBanco->save();

            $solicitudes_remotas = App\solicitudes_remotas::where('id', '=', $idremoto)->first();
            $banco_api_solicitudes = App\banco_api_solicitudes::find($solicitudes_remotas->id_api_banco_solicitud);
            $asignacion_banco_api_solis = App\asignacion_banco_api_solis::where('id_solicitud_remota', '=', $idremoto)->first();


            $numeroRandom = rand();


            $nombrePdf= "remoto_".$solicitud[0]->sSC."_".$numeroRandom. 'servicio.pdf';
            \PDF::setOptions((['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true]))
            ->loadView('solicitudes_servicios.remote.pdfSolicitudRemota', compact('banco_api_solicitudes',"solicitudes_remotas",'asignacion_banco_api_solis'))
            ->save(storage_path('app/public/pdfServicio/') .$nombrePdf)
            ->stream();





            $asignacion = new App\asignacion_solicitudes;
            // $asignacion->fecha = $request->fecha_servicio;
            $asignacion->numero_visita = 1; // le dejare uno por que ya viene finalizado, solo uso esta funcion para mostrar los demas datos
            $asignacion->estado_interno = "FINALIZADO";
        $asignacion->finalizado_remoto = 1;
        $asignacion->id_solicitud_remota = $idSolicitudRemota;

            $asignacion->estado_externo = "FINALIZADO";
            $asignacion->api_solicitudes_id = $id_solicitud;
            $asignacion->trabajadors_id = $datos_trabajador[0]->id; //falta arreglar
            $asignacion->check_formulario_solicitudes_id = $check_solicitud->id;
            $asignacion->trabajadors_id_coordinadora = 1; //falta arreglar
            $asignacion->fecha_asignacion = $FechaHoraActual;
            $asignacion->url_pdf_remoto = "app/public/pdfServicio/".$nombrePdf;


            $asignacion->timestamps = false;
            $asignacion->save();











                // $solicitudesremotas = "solicitudesremotas";
                // return   \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
                // ->loadView('solicitudes_servicios.remote.pdfSolicitudRemota', compact('banco_api_solicitudes',"solicitudes_remotas",'asignacion_banco_api_solis'))
                // ->stream("remote∂" . '.pdf');





            $arrayCorreos = [];

            array_push($arrayCorreos,"valen.slimming@gmail.com");


           $destinatario = ["ariel@globati.com","cristobal@globati.com"];

           Mail::to($destinatario)
               ->send(new correoPdfServicioFinalizadoRemoto($idremoto,$nombrePdf));


               return  redirect('/home')->with('mensaje', 'Check Finalizado');

        }, 5);

    }
    function conectarEliminarData($datos){


        $fields_string = http_build_query($datos);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "http://35.232.42.155/produccionespejo/rendicion/api/eliminar_solicitud_api_synergy?");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string );
        $data = curl_exec($ch);
        curl_close($ch);
    //     echo $data;
    // return 1;
    return;
    }

    public function asignar_check_servicios_home(request $request)
    {


        return DB::transaction(function () use ($request) {

        if (isset($request->externo)) {
            // Field 'externo' is present in the request
            // Your code here
            $idSolicitudRemota = $request->issolicitudremota;

            $dataSolicitudRemota  =   App\solicitudes_remotas::select("solicitudes_remotas.id as idSolicitudRemota"
            ,"asignacion_banco_api_solis.solucionado"
            ,"asignacion_banco_api_solis.observacion_tecnico as   observacionTecnico"
            ,"banco_api_solicitudes.*","solicitudes_remotas.*"
            ,"solicitudes_remotas.estado as estado_solicitud_remota"
            ,"solicitudes_remotas.Ssc as nuevasc"
            ,"solicitudes_remotas.inc"

                ,"asuntos.descripcion as descripcion_asuntos")
            ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
            ->join("banco_api_solicitudes","banco_api_solicitudes.id","=","solicitudes_remotas.id_api_banco_solicitud")
            ->join("asignacion_banco_api_solis","asignacion_banco_api_solis.id_solicitud_remota","=","solicitudes_remotas.id")

            ->where('solicitudes_remotas.id', $idSolicitudRemota)
            ->get();

          $inc= $dataSolicitudRemota[0]->inc;



          if (strtoupper($dataSolicitudRemota[0]->estado_solicitud_remota) == strtoupper("ASIGNADO AYA")) {


            $fields = array(
                "api_key" => "qrywgthj",

                "Ssc"=> $dataSolicitudRemota[0]->nuevasc,
            );


                $this->conectarEliminarData($fields);

            }






            // $idSolicitud=  $this->insertarSolicitud($dataSolicitudRemota,$idSolicitudRemota);
            $getAppsoli = App\api_solicitudes::where('id_solicitudes_remotas', '=', $idSolicitudRemota)->first();
            $idSolicitud= $getAppsoli->id;

            // return $dataSolicitudRemota;
        }else{
            $idSolicitud = $request->id;

            $getDaraSolic = App\api_solicitudes::where('id', '=', $idSolicitud)->get();

          $inc= $getDaraSolic[0]->inc;


        }




        if(Auth::user()->ver_todo_solicitud == "1"){

            $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->join('users', 'users.id', '=', 'trabajadors.id_login')
            ->where('trabajadors.estado', '=', 1)
            ->where('users.tipo_usuario', '=', 'trabajador')
            ->where('users.tipo', '=', 'interno')
            ->orWhere('users.coord_is_tecnico', '=', 1)
            ->where('trabajadors.estado', '=', 1)

            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id')
            ->get();

            // $trabajadores = DB::table('personas')
            // ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            // ->join('users', 'users.id', '=', 'trabajadors.id_login')
            // ->where('trabajadors.estado', '=', '1')
            // //  ->where('users.zona', '=', Auth::user()->zona)
            // ->where('users.tipo_usuario', '=', 'trabajador')
            // ->where('users.tipo', '=', 'interno')


            // ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id')
            // ->get();
        }else{
            $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->join('users', 'users.id', '=', 'trabajadors.id_login')
            ->where('trabajadors.estado', '=', 1)
             ->where('users.zona', '=', Auth::user()->zona)
            ->where('users.tipo_usuario', '=', 'trabajador')

            ->select('personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id')
            ->get();
        }


        $proyectos = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('proyectos.estado', '=', '1')
            ->where('proyectos.id', '!=', '1')
            // ->where('proyectos.nombre', '=', 'SERVICIOS')
            ->where('clientes.razon_social', '=', 'SERVICIOS')

            ->select('proyectos.nombre', 'clientes.razon_social', 'proyectos.id as id_proyecto')
            ->get();

        $servicio = DB::table('api_solicitudes')
            ->where('api_solicitudes.id', '=', $idSolicitud)
            ->get();


            if (empty($request->issolicitudremota)) {
                // El valor de $request->issolicitudremota está vacío o no está establecido
                   $idSolicitudRemota = $servicio[0]->id_solicitudes_remotas;

            }

        $datos_asignacion = DB::table('asignacion_solicitudes')
            ->where('asignacion_solicitudes.api_solicitudes_id', '=', $idSolicitud)
            ->get();

        if (count($datos_asignacion) == 0) {
            $total_dias = 1;
        } else {
            $total_dias = count($datos_asignacion) + 1;
        }

        $reasignar = $request->reasignar;
        $extadoexternozonas = $request->extadoexternozonas;


        // if (isset($request->externo)) {
        //     return Redirect::to('/home');

        //     }

        return view('solicitudes_servicios.asignar_solicitud_servicio', compact('extadoexternozonas','inc','reasignar','idSolicitudRemota','total_dias', 'trabajadores', 'proyectos', 'servicio'));
    }, 5);

    }


    // ecportar proveedo

       public function excel_proveedor_servicio($url)
    {

        try {
            $url = Crypt::decryptString($url);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        // return $url;
        $buscando = strpos($url, "/filtros_solicitudes_proveedor?");

        if ($buscando === false) {
            $resultado = str_replace("/verservicios", "/servicioExport_proveedor?", $url);
        } else {
            $resultado = str_replace("/filtros_solicitudes_proveedor?", "/servicioExport_proveedor?", $url);
        }
        return redirect($resultado);
    }


    public function excel_proveedor_servicio_checklist($url)
    {

        try {
            $url = Crypt::decryptString($url);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        // return $url;
        $buscando = strpos($url, "/filtros_solicitudes_proveedor?");

        if ($buscando === false) {
            $resultado = str_replace("/verservicios", "/checkfiltros_servicioexport?", $url);
        } else {
            $resultado = str_replace("/filtros_solicitudes_proveedor?", "/checkfiltros_servicioexport?", $url);
        }
        return redirect($resultado);
    }




    public function servicioExport_proveedor_checklist(request $request)
    {
        //  return "vipa";

        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sSC = $request->sSC;
        $direccion = $request->direccion;
        $cliente_seleccionado = $request->clientes;
        $fecha = "";
        $fecha2 = "";

        // $Api_solicitudesAcumulador = DB::table('api_solicitudes')
        //     ->select(
        //         "api_solicitudes.dFechaCreacion",
        //         'api_solicitudes.fecha_asignado as fecha_asignada',
        //         'api_solicitudes.dFechaCreacion as fecha_recepcion',
        //         'api_solicitudes.sComuna',
        //         'api_solicitudes.sRegion',
        //         'api_solicitudes.sCliente',
        //         'api_solicitudes.sSC',
        //         'api_solicitudes.sSerie',
        //         'api_solicitudes.id',
        //         'api_solicitudes.sDireccion',
        //         'api_solicitudes.estado_interno',
        //         'api_solicitudes.estado_externo',
        //         'api_solicitudes.sObs',
        //         'api_solicitudes.sDescripcion',
        //         'api_solicitudes.sModelo',


        //     );


        $Api_solicitudes = DB::table('api_solicitudes')
          ->Join('asignacion_solicitudes','asignacion_solicitudes.api_solicitudes_id','=','api_solicitudes.id')
        ->select(
            "api_solicitudes.dFechaCreacion",
            // 'asignacion_solicitudes.estado_externo',
            // 'asignacion_solicitudes.estado_interno',
            // api_solicitudes
            'api_solicitudes.fecha_asignado as fecha_asignada',
            'api_solicitudes.dFechaCreacion as fecha_recepcion',
            'api_solicitudes.sComuna',
            'api_solicitudes.sRegion',
            'api_solicitudes.sCliente',
            'api_solicitudes.sSC',
            'api_solicitudes.id',
            'api_solicitudes.sDireccion',
            'api_solicitudes.sSerie',
            'api_solicitudes.estado_interno',
            'api_solicitudes.estado_externo',
            'api_solicitudes.sObs',
            'api_solicitudes.sDescripcion',
            'api_solicitudes.sModelo'
        )

        // ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
        ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor);

        if ($id_persona != "") {
            $id_trabajador =  DB::table('trabajadors')
                ->select('trabajadors.id')
                ->where('trabajadors.id_persona', '=', $id_persona)
                ->get();
            $Api_solicitudes->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id');
            $Api_solicitudes->where("asignacion_solicitudes.trabajadors_id", "=", $id_trabajador[0]->id);
        }

        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $Api_solicitudes->whereBetween('fecha_asignado', [$fecha, $fecha2]);
        }

        if ($direccion != "") {
            $Api_solicitudes->where("api_solicitudes.sDireccion", "=", $direccion);
        }
        if ($region != "") {
            $Api_solicitudes->where("api_solicitudes.sRegion", "=", $region);
        }
        if ($comuna != "") {
            $Api_solicitudes->where("api_solicitudes.sComuna", "=", $comuna);
        }
        if ($estado != "") {
            $Api_solicitudes->where("api_solicitudes.estado_externo", "=", $estado);
        }
        if ($comuna != "") {
            $Api_solicitudes->where("api_solicitudes.sComuna", "=", $comuna);
        }
        if ($serie != "") {
            $Api_solicitudes->where("api_solicitudes.sSerie", "=", $serie);
        }
        if ($sSC != "") {
            $Api_solicitudes->where("api_solicitudes.sSC", "=", $sSC);
        }
        if ($clientes != "") {
            $Api_solicitudes->where("api_solicitudes.sCliente", "=", $clientes);
        }




        $Api_solicitudes = $Api_solicitudes->get();

        return view('check.excel.excel_serviciocordinadora', compact('Api_solicitudes'));
    }



    public function servicioExport_proveedor(request $request)
    {
        //  return "vip ";

        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sSC = $request->sSC;
        $direccion = $request->direccion;
        $cliente_seleccionado = $request->clientes;
        $fecha = "";
        $fecha2 = "";

        // $Api_solicitudesAcumulador = DB::table('api_solicitudes')
        //     ->select(
        //         "api_solicitudes.dFechaCreacion",
        //         'api_solicitudes.fecha_asignado as fecha_asignada',
        //         'api_solicitudes.dFechaCreacion as fecha_recepcion',
        //         'api_solicitudes.sComuna',
        //         'api_solicitudes.sRegion',
        //         'api_solicitudes.sCliente',
        //         'api_solicitudes.sSC',
        //         'api_solicitudes.sSerie',
        //         'api_solicitudes.id',
        //         'api_solicitudes.sDireccion',
        //         'api_solicitudes.estado_interno',
        //         'api_solicitudes.estado_externo',
        //         'api_solicitudes.sObs',
        //         'api_solicitudes.sDescripcion',
        //         'api_solicitudes.sModelo',


        //     );


        $Api_solicitudes = DB::table('api_solicitudes')
        //  ->Join('asignacion_solicitudes','asignacion_solicitudes.api_solicitudes_id','=','api_solicitudes.id')
        ->select(
            "api_solicitudes.dFechaCreacion",
            // 'asignacion_solicitudes.estado_externo',
            // 'asignacion_solicitudes.estado_interno',
            // api_solicitudes
            'api_solicitudes.fecha_asignado as fecha_asignada',
            'api_solicitudes.dFechaCreacion as fecha_recepcion',
            'api_solicitudes.sComuna',
            'api_solicitudes.sRegion',
            'api_solicitudes.sCliente',
            'api_solicitudes.sSC',
            'api_solicitudes.id',
            'api_solicitudes.sDireccion',
            'api_solicitudes.sSerie',
            'api_solicitudes.estado_interno',
            'api_solicitudes.estado_externo',
            'api_solicitudes.sObs',
            'api_solicitudes.sDescripcion',
            'api_solicitudes.sModelo'
        )

        // ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
        ->where('api_solicitudes.proveedor_servicio', '=', Auth::user()->nombre_proveedor);

        if ($id_persona != "") {
            $id_trabajador =  DB::table('trabajadors')
                ->select('trabajadors.id')
                ->where('trabajadors.id_persona', '=', $id_persona)
                ->get();
            $Api_solicitudes->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id');
            $Api_solicitudes->where("asignacion_solicitudes.trabajadors_id", "=", $id_trabajador[0]->id);
        }

        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $Api_solicitudes->whereBetween('fecha_asignado', [$fecha, $fecha2]);
        }

        if ($direccion != "") {
            $Api_solicitudes->where("api_solicitudes.sDireccion", "=", $direccion);
        }
        if ($region != "") {
            $Api_solicitudes->where("api_solicitudes.sRegion", "=", $region);
        }
        if ($comuna != "") {
            $Api_solicitudes->where("api_solicitudes.sComuna", "=", $comuna);
        }
        if ($estado != "") {
            $Api_solicitudes->where("api_solicitudes.estado_externo", "=", $estado);
        }
        if ($comuna != "") {
            $Api_solicitudes->where("api_solicitudes.sComuna", "=", $comuna);
        }
        if ($serie != "") {
            $Api_solicitudes->where("api_solicitudes.sSerie", "=", $serie);
        }
        if ($sSC != "") {
            $Api_solicitudes->where("api_solicitudes.sSC", "=", $sSC);
        }
        if ($clientes != "") {
            $Api_solicitudes->where("api_solicitudes.sCliente", "=", $clientes);
        }




        $Api_solicitudes = $Api_solicitudes->get();

        return view('check.excel.excel_serviciocordinadora', compact('Api_solicitudes'));
    }


    public function excel_coordinadora_servicio($url)
    {
        try {
            $url = Crypt::decryptString($url);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        $buscando = strpos($url, "/filtros_solicitudes?");

        if ($buscando === false) {
            $resultado = str_replace("/ver_api_servicios", "/filtros_servicioexport?", $url);
        } else {
            $resultado = str_replace("/filtros_solicitudes?", "/filtros_servicioexport?", $url);
        }
        return redirect($resultado);
    }
    public function filtros_servicioExport(request $request)
    {

        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sSC = $request->sSC;
        $direccion = $request->direccion;
        $cliente_seleccionado = $request->clientes;
        $fecha = "";
        $fecha2 = "";

        $Api_solicitudesAcumulador = DB::table('api_solicitudes')
            ->select(
                "api_solicitudes.dFechaCreacion",
                'api_solicitudes.fecha_asignado as fecha_asignada',
                'api_solicitudes.dFechaCreacion as fecha_recepcion',
                'api_solicitudes.sComuna',
                'api_solicitudes.sRegion',
                'api_solicitudes.sCliente',
                'api_solicitudes.sSC',
                'api_solicitudes.sSerie',
                'api_solicitudes.id',
                'api_solicitudes.sDireccion',
                'api_solicitudes.estado_interno',
                'api_solicitudes.estado_externo',
                'api_solicitudes.sObs',
                'api_solicitudes.sDescripcion',
                'api_solicitudes.sModelo',


            );

        if ($id_persona != "") {
            $id_trabajador =  DB::table('trabajadors')
                ->select('trabajadors.id')
                ->where('trabajadors.id_persona', '=', $id_persona)
                ->get();
            $Api_solicitudesAcumulador->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id');
            $Api_solicitudesAcumulador->where("asignacion_solicitudes.trabajadors_id", "=", $id_trabajador[0]->id);
        }

        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $Api_solicitudesAcumulador->whereBetween('fecha_asignado', [$fecha, $fecha2]);
        }

        if ($direccion != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sDireccion", "=", $direccion);
        }
        if ($region != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sRegion", "=", $region);
        }
        if ($comuna != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sComuna", "=", $comuna);
        }
        if ($estado != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.estado_externo", "=", $estado);
        }
        if ($comuna != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sComuna", "=", $comuna);
        }
        if ($serie != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sSerie", "=", $serie);
        }
        if ($sSC != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sSC", "=", $sSC);
        }
        if ($clientes != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sCliente", "=", $clientes);
        }

        $Api_solicitudesAcumulador->orderBy(DB::raw('FIELD(api_solicitudes.estado_interno, "REVISAR","INICIADO","ENTREGADO","POR ASIGNAR","REASIGNAR","RECHAZADO","PENDIENTE","CANCELADO","FINALIZADO")'));

        $Api_solicitudes = $Api_solicitudesAcumulador->get();

        return view('check.excel.excel_serviciocordinadora', compact('Api_solicitudes'));
    }
    public function serviciochecklistExport($url)
    {
        try {
            $url = Crypt::decryptString($url);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        $buscando = strpos($url, "/filtros_solicitudes?");

        if ($buscando === false) {
            $resultado = str_replace("/ver_api_servicios", "/checkfiltros_servicioexport?", $url);
        } else {
            $resultado = str_replace("/filtros_solicitudes?", "/checkfiltros_servicioexport?", $url);
        }
        return redirect($resultado);
    }
    public function checkfiltros_servicioexport(request $request)
    {

        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sSC = $request->sSC;
        $direccion = $request->direccion;
        $cliente_seleccionado = $request->clientes;
        $fecha = "";
        $fecha2 = "";

        $Api_solicitudesAcumulador = DB::table('api_solicitudes')
            ->select(

                "api_solicitudes.sModelo",
                "check_formulario_solicitudes.Smarca",


                "api_solicitudes.dFechaCreacion",
                'api_solicitudes.fecha_asignado as fecha_asignada',
                'api_solicitudes.dFechaCreacion as fecha_recepcion',
                'api_solicitudes.sComuna',
                'api_solicitudes.sRegion',
                'api_solicitudes.sCliente',
                'api_solicitudes.sSC',
                'api_solicitudes.sSerie',
                'api_solicitudes.id',
                'api_solicitudes.sDireccion',
                'api_solicitudes.estado_interno',
                'api_solicitudes.estado_externo',
                'asignacion_solicitudes.id as id_asig',
                                'api_solicitudes.sDescripcion',


                                'check_formulario_solicitudes.observaciones',

                'check_formulario_solicitudes.estado_seleccionado'
            )
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id');
        if ($id_persona != "") {
            $id_trabajador =  DB::table('trabajadors')
                ->select('trabajadors.id')
                ->where('trabajadors.id_persona', '=', $id_persona)
                ->get();
            $Api_solicitudesAcumulador->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id');
            $Api_solicitudesAcumulador->where("asignacion_solicitudes.trabajadors_id", "=", $id_trabajador[0]->id);
        }

        if ($request->datepicker != "" && $request->datepicker2 != "") {
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $Api_solicitudesAcumulador->whereBetween('fecha_asignado', [$fecha, $fecha2]);
        }

        if ($direccion != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sDireccion", "=", $direccion);
        }
        if ($region != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sRegion", "=", $region);
        }
        if ($comuna != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sComuna", "=", $comuna);
        }
        if ($estado != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.estado_externo", "=", $estado);
        }
        if ($comuna != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sComuna", "=", $comuna);
        }
        if ($serie != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sSerie", "=", $serie);
        }
        if ($sSC != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sSC", "=", $sSC);
        }
        if ($clientes != "") {
            $Api_solicitudesAcumulador->where("api_solicitudes.sCliente", "=", $clientes);
        }

        $Api_solicitudesAcumulador->orderBy(DB::raw('FIELD(api_solicitudes.estado_interno, "REVISAR","INICIADO","ENTREGADO","POR ASIGNAR","REASIGNAR","RECHAZADO","PENDIENTE","CANCELADO","FINALIZADO")'));

        $Api_solicitudes = $Api_solicitudesAcumulador->get();

        return view('check.excel.excel_serviciocheckcordinadora', compact('Api_solicitudes'));
    }
    public function check_historial_servicio(Request $request)
    {
        try {
            $id = Crypt::decryptString($request->id);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $historial = DB::table('check_formulario_solicitudes')
            ->select(
                'check_formulario_solicitudes.id',
                'check_formulario_solicitudes.sSC',
                'check_formulario_solicitudes.sSerie',
                'check_formulario_solicitudes.observaciones',
                'check_formulario_solicitudes.sDireccion',
                'check_formulario_solicitudes.sCliente',
                'check_formulario_solicitudes.contador_bn',
                'check_formulario_solicitudes.contador_color',
               'asignacion_solicitudes.fecha as fecha_asignado',
               'check_formulario_solicitudes.Smarca',

                'personas.nombre_uno',
                'personas.apellido_uno',
                'check_formulario_solicitudes.sModelo',
                'check_formulario_solicitudes.sRegion',
                'check_formulario_solicitudes.sComuna',
                'check_formulario_solicitudes.estado_seleccionado',
                'asignacion_solicitudes.id as idasig'
            )
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.check_formulario_solicitudes_id', '=', 'check_formulario_solicitudes.id')
            ->join('api_solicitudes', 'api_solicitudes.id', '=', 'asignacion_solicitudes.api_solicitudes_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('api_solicitudes.id', '=', $id)
            ->get();

        $tabla = "";

        foreach ($historial as $key => $dato) {
            $tabla .= '<tr>';
            $tabla .= '<td>' . ($key + 1) . '</td>';
            $tabla .= '<td>' . $dato->nombre_uno . ' ' . $dato->apellido_uno . '</td>';
            $tabla .= '<td>' . $dato->sSerie . '</td>';
            $tabla .= '<td>' . $dato->sSC . '</td>';

            $tabla .= '<td>' . $dato->Smarca . '</td>';

            $tabla .= '<td>' . $dato->sModelo . '</td>';
            $tabla .= '<td>' . $dato->sDireccion . '</td>';
            $tabla .= '<td>' . $dato->sRegion . '</td>';
            $tabla .= '<td>' . $dato->sComuna . '</td>';
            $tabla .= '<td>' . $dato->sCliente . '</td>';
            $tabla .= '<td>' . Carbon::createFromDate($dato-> fecha_asignado)->format('d-m-Y'). '</td>';
            $tabla .= '<td>' . $dato->contador_bn . '</td>';
            $tabla .= '<td>' . $dato->contador_color . '</td>';
            $tabla .= '<td>' . $dato->observaciones . '</td>';
            $tabla .= '<td>' . $dato->estado_seleccionado . '</td>';

            $accesorios = DB::table('check_accesorios_servicios')
                ->select('accesorios.descripcion as nombre', 'check_accesorios_servicios.cantidad')
                ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_servicios.id_accesorio')
                ->where('check_accesorios_servicios.id_asig_servicio', '=', $dato->idasig)
                ->get();

            $accesorios_manuales = DB::table('accesorios_manuales_servicios')
                ->where('accesorios_manuales_servicios.id_checklist_instalacion', '=', $dato->idasig)
                ->get();

            $accesorios_equipamiento = DB::table('tipo_equipamientos')
                ->where('tipo_equipamientos.id_asig', '=', $dato->idasig)
                ->get();

            $tabla .= '<td>';
            foreach ($accesorios as $key => $partes) {
                $tabla .= ($key + 1) . '-' . $partes->nombre . '(' . $partes->cantidad . ') <br> ';
            }
            foreach ($accesorios_manuales as $key => $partes) {
                $tabla .= ($key + 1) . '-' . $partes->nombre_parte . '(' . $partes->cantidad . ') <br> ';
            }
            foreach ($accesorios_equipamiento as $key => $partes) {
                $tabla .= ($key + 1) . '-' . $partes->opcion . '-' . $partes->descripcion . '(' . $partes->cantidad . ') <br> ';
            }
            $tabla .= '</td>';

            $tabla .= '</tr>';
        }

        return $tabla;
    }

    public function finaliza_manual_servicios($id_asignacion_)
    {



        try {
            $id_asignacion = Crypt::decryptString($id_asignacion_);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        $mi_asignacion = DB::table('asignacion_solicitudes')
            ->where('asignacion_solicitudes.id', '=', $id_asignacion)
            ->get();
        $id_trabajador = $mi_asignacion[0]->trabajadors_id;
        $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
        $trabajadors_id = $mi_asignacion[0]->trabajadors_id;
        //datos del usuario
        $datosTrabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.id', '=', $trabajadors_id)
            ->get();

        $apiSolicitud = DB::table('api_solicitudes')
            ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('api_solicitudes.id', '=', $idApiSolicitud)
            ->get();

        $asignacion_solicitudes     = DB::table('asignacion_solicitudes')
            ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
            ->select(
                'asignacion_solicitudes.id as idAsig',
                'check_formulario_solicitudes.sComuna',
                'asignacion_solicitudes.fecha',
                'asignacion_solicitudes.estado_externo',
                'asignacion_solicitudes.url_firma',
                'check_formulario_solicitudes.sSC',
                'check_formulario_solicitudes.sProveedor',
                'asignacion_solicitudes.estado_interno',
                'check_formulario_solicitudes.sDireccion',
                'check_formulario_solicitudes.sSerie',
                'check_formulario_solicitudes.sContacto',
                'check_formulario_solicitudes.sTelefono',
                'check_formulario_solicitudes.sModelo',
                'check_formulario_solicitudes.sDescripcion',
                'check_formulario_solicitudes.sCliente',
//cambio 4agosto
                'check_formulario_solicitudes.numero_ot',
                'check_formulario_solicitudes.contador_bn',
                'check_formulario_solicitudes.contador_color',
                'check_formulario_solicitudes.ip',
                'check_formulario_solicitudes.usb',
                'check_formulario_solicitudes.descripcion',
                'check_formulario_solicitudes.tipo_componente',
                'check_formulario_solicitudes.solicita_acessorios',
                'check_formulario_solicitudes.observaciones',
                'check_formulario_solicitudes.nombre_contacto_firma',
                'check_formulario_solicitudes.correo_contacto',
                'check_formulario_solicitudes.firma_contacto',
                'check_formulario_solicitudes.estado_seleccionado',
                'check_formulario_solicitudes.motivo_accesorio',
                'check_formulario_solicitudes.t_uno',
                'check_formulario_solicitudes.t_dos',
                'check_formulario_solicitudes.t_tres',
                'check_formulario_solicitudes.Smarca',
                'check_formulario_solicitudes.equipos',

                'check_formulario_solicitudes.dFecCre as fecha_check'
         /////cambio 4agosto

                )
            ->where("asignacion_solicitudes.id", "=", $id_asignacion)
            ->get();
        $cantidad_fotos = 0;
        $manual = "si";

//cambio 4agosto

        $instalacion_accesorios = DB::table('checklist_instalacion_accesorios_servicios')
        ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios_servicios.id_accesorio')
        ->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios_servicios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios_servicios.serie_parte')
        ->where('id_asig_servicio', '=', $id_asignacion)
        ->get();


        $instalacion_accesorios_manuales = DB::table('instalacion_accesorios_manuales_servicios')
        ->where('id_checklist_instalacion', '=', $id_asignacion)
        ->get();
        $acceDanos = DB::table('check_accesorios_danados_servicios')
        ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_danados_servicios.id_accesorio')
        ->where('check_accesorios_danados_servicios.id_asig_serv', '=', $id_asignacion)
        ->get();

         $acceSoli = DB::table('check_accesorios_servicios')
        ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_servicios.id_accesorio')

        ->where('check_accesorios_servicios.id_asig_servicio', '=', $id_asignacion)
        ->get();
           //estas son las tres imagenes
           $fotos_servicios_cheks = DB::table('fotos_servicios_cheks')
           ->where('fotos_servicios_cheks.checklist_asignacion_id', '=', $id_asignacion)
           ->get();

       $accesorios_manuales = DB::table('accesorios_manuales_servicios')
           ->where('id_checklist_instalacion', '=', $id_asignacion)
           ->get();
//////cambio 4agosto
        return view('solicitudes_servicios.iniciar_check_servicio', compact('accesorios_manuales','fotos_servicios_cheks','acceSoli','acceDanos','instalacion_accesorios_manuales','instalacion_accesorios','manual', 'apiSolicitud', 'asignacion_solicitudes', 'cantidad_fotos'));

        // return view('check.asignar_checklist',compact('trabajadores','tipos_visitas','proyectos','api_instalaciones','total_dias'));
      //  return view('solicitudes_servicios.iniciar_check_servicio', compact('manual', 'apiSolicitud', 'asignacion_solicitudes', 'cantidad_fotos'));
    }
    public function cambiodeserie(request $request)
    {

        $idAsignacion = $request->id_check_serie;
        $serieseleccionada = $request->serieseleccionada;

        $asignacion =  App\asignacion_solicitudes::where('id', '=', $idAsignacion)->first();

            $check_solicitud = App\check_formulario_solicitudes::findOrfail($asignacion->check_formulario_solicitudes_id);
            $check_solicitud->sSerie = $serieseleccionada;
            $check_solicitud->timestamps = false;
            $check_solicitud->save();


            $api_solicitudes = App\api_solicitudes::findOrfail($asignacion->api_solicitudes_id);
            $api_solicitudes->sSerie = $serieseleccionada;
            $api_solicitudes->timestamps = false;
            $api_solicitudes->save();




        // $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($idAsignacion);
        //         $asigSolicitudes->timestamps = false;

        // $asigSolicitudes->timestamps = false;
        // $asigSolicitudes->save();

        return "OK";
    }
    public function cambiodemarca(request $request)
    {

        $idAsignacion = $request->id_check_marca;
        $marcaseleccionada = $request->marcaseleccionada;

        $asignacion =  App\asignacion_solicitudes::where('id', '=', $idAsignacion)->first();

            $check_solicitud = App\check_formulario_solicitudes::findOrfail($asignacion->check_formulario_solicitudes_id);
            $check_solicitud->Smarca = $marcaseleccionada;
            $check_solicitud->timestamps = false;
            $check_solicitud->save();
        // $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($idAsignacion);
        //         $asigSolicitudes->timestamps = false;

        // $asigSolicitudes->timestamps = false;
        // $asigSolicitudes->save();

        return "OK";
    }


    public function cambiodefechafinsolicitudes(request $request)
    {

        $idAsignacion = $request->id_check;
        $fecha = $request->fecha;
        $opcionFecha = $request->opcionFecha;


        $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($idAsignacion);
        if ($opcionFecha == 1) {
            $asigSolicitudes->fecha_transito = $fecha;
        } else if ($opcionFecha == 2) {
            $asigSolicitudes->fecha_local = $fecha;
        } else if ($opcionFecha == 3) {
            $asigSolicitudes->fecha_inicio = $fecha;
        } else if ($opcionFecha == 4) {
            $asigSolicitudes->fecha_fin = $fecha;
        }


        $asigSolicitudes->timestamps = false;
        $asigSolicitudes->save();

        return $fecha;
    }

    public function cambiodecorreosolicitudes(request $request)
    {

        $idAsignacion = $request->id_check;
        $correo = str_replace(" ", "", $request->correo);

        $asigSolicitudes =  App\asignacion_solicitudes::findOrfail($idAsignacion);

        $check_solicitud = App\check_formulario_solicitudes::findOrfail($asigSolicitudes->check_formulario_solicitudes_id);
        $check_solicitud->correo_contacto = $correo;
        $check_solicitud->timestamps = false;
        $check_solicitud->save();

        return $correo;
    }

    public function finaliza_manual_servicios_home(request $request)
    {
        $id_asignacion = $request->id;

        $mi_asignacion = DB::table('asignacion_solicitudes')
            ->where('asignacion_solicitudes.id', '=', $id_asignacion)
            ->get();
        $id_trabajador = $mi_asignacion[0]->trabajadors_id;
        $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
        $trabajadors_id = $mi_asignacion[0]->trabajadors_id;
        //datos del usuario
        $datosTrabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.id', '=', $trabajadors_id)
            ->get();

        $apiSolicitud = DB::table('api_solicitudes')
            ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('api_solicitudes.id', '=', $idApiSolicitud)
            ->get();

        $asignacion_solicitudes     = DB::table('asignacion_solicitudes')
            ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
            ->select(
                'asignacion_solicitudes.id as idAsig',
                'check_formulario_solicitudes.sComuna',
                'asignacion_solicitudes.fecha',
                'asignacion_solicitudes.estado_externo',
                'asignacion_solicitudes.url_firma',
                'check_formulario_solicitudes.sSC',
                'check_formulario_solicitudes.Smarca',

                'check_formulario_solicitudes.sProveedor',
                'asignacion_solicitudes.estado_interno',
                'check_formulario_solicitudes.sDireccion',
                'check_formulario_solicitudes.sSerie',
                'check_formulario_solicitudes.sContacto',
                'check_formulario_solicitudes.sTelefono',
                'check_formulario_solicitudes.sModelo',
                'check_formulario_solicitudes.sDescripcion',
                'check_formulario_solicitudes.sCliente',
                 /////cambio 4agosto

                 'check_formulario_solicitudes.contador_bn',
                 'check_formulario_solicitudes.contador_color',
                 'check_formulario_solicitudes.ip',
                 'check_formulario_solicitudes.usb',
                 'check_formulario_solicitudes.t_uno',
                 'check_formulario_solicitudes.t_dos',
                 'check_formulario_solicitudes.t_tres',
                 'check_formulario_solicitudes.motivo_accesorio',

                 'check_formulario_solicitudes.nombre_contacto_firma',
                 'check_formulario_solicitudes.correo_contacto',
                 'check_formulario_solicitudes.firma_contacto',
                 'check_formulario_solicitudes.observaciones',
                 'check_formulario_solicitudes.solicita_acessorios'
            )
            ->where("asignacion_solicitudes.id", "=", $id_asignacion)
            ->get();


            $instalacion_accesorios = DB::table('checklist_instalacion_accesorios_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios_servicios.id_accesorio')
            ->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios_servicios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios_servicios.serie_parte')
            ->where('id_asig_servicio', '=', $id_asignacion)
            ->get();
            $instalacion_accesorios_manuales = DB::table('instalacion_accesorios_manuales_servicios')
            ->where('id_checklist_instalacion', '=', $id_asignacion)
            ->get();

            $acceDanos = DB::table('check_accesorios_danados_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_danados_servicios.id_accesorio')
            ->where('check_accesorios_danados_servicios.id_asig_serv', '=', $id_asignacion)
            ->get();
            $acceSoli = DB::table('check_accesorios_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_servicios.id_accesorio')

            ->where('check_accesorios_servicios.id_asig_servicio', '=', $id_asignacion)
            ->get();
               //estas son las tres imagenes
        $fotos_servicios_cheks = DB::table('fotos_servicios_cheks')
        ->where('fotos_servicios_cheks.checklist_asignacion_id', '=', $id_asignacion)
        ->get();

    $accesorios_manuales = DB::table('accesorios_manuales_servicios')
        ->where('id_checklist_instalacion', '=', $id_asignacion)
        ->get();
        $cantidad_fotos = 0;
        $manual = "si";
        // return view('check.asignar_checklist',compact('trabajadores','tipos_visitas','proyectos','api_instalaciones','total_dias'));
        return view('solicitudes_servicios.iniciar_check_servicio', compact('accesorios_manuales','fotos_servicios_cheks','acceSoli','acceDanos','instalacion_accesorios_manuales','instalacion_accesorios','manual', 'apiSolicitud', 'asignacion_solicitudes', 'cantidad_fotos'));
    }
    public function check_historial_servicio_home(Request $request)
    {
        $id = $request->id;

        $historial = DB::table('check_formulario_solicitudes')
            ->select(
                'check_formulario_solicitudes.id',
                'check_formulario_solicitudes.sSerie',
                'check_formulario_solicitudes.observaciones',
                'check_formulario_solicitudes.sDireccion',
                'check_formulario_solicitudes.sCliente',
                'check_formulario_solicitudes.contador_bn',
                'check_formulario_solicitudes.contador_color',
                'asignacion_solicitudes.fecha as fecha_asignado',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'check_formulario_solicitudes.sModelo',
                'check_formulario_solicitudes.sRegion',
                'check_formulario_solicitudes.sComuna',
                'check_formulario_solicitudes.estado_seleccionado',
                'check_formulario_solicitudes.sSC',
                'check_formulario_solicitudes.sProveedor',
                'check_formulario_solicitudes.Smarca'

            )
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.check_formulario_solicitudes_id', '=', 'check_formulario_solicitudes.id')
            ->join('api_solicitudes', 'api_solicitudes.id', '=', 'asignacion_solicitudes.api_solicitudes_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('api_solicitudes.id', '=', $id)
            ->get();

        $tabla = "";

        foreach ($historial as $key => $dato) {
            $fecha = Carbon::createFromDate($dato->fecha_asignado)->format('d-m-Y');
            $tabla .= '<tr>';
            $tabla .= '<td>' . ($key + 1) . '</td>';
            $tabla .= '<td>' . $dato->nombre_uno . ' ' . $dato->apellido_uno . '</td>';
            $tabla .= '<td>' . $dato->sSerie . '</td>';
            $tabla .= '<td>' . $dato->sSC . '</td>';
            $tabla .= '<td>' . $dato->Smarca . '</td>';

            $tabla .= '<td>' . $dato->sModelo . '</td>';
            $tabla .= '<td>' . $dato->sDireccion . '</td>';
            $tabla .= '<td>' . $dato->sRegion . '</td>';
            $tabla .= '<td>' . $dato->sComuna . '</td>';
            $tabla .= '<td>' . $dato->sCliente . '</td>';
            $tabla .= '<td>' . $fecha . '</td>';
            $tabla .= '<td>' . $dato->contador_bn . '</td>';
            $tabla .= '<td>' . $dato->contador_color . '</td>';
            $tabla .= '<td>' . $dato->observaciones . '</td>';
            $tabla .= '<td>' . $dato->estado_seleccionado . '</td>';

            $accesorios = DB::table('check_accesorios_servicios')
                ->select('accesorios.descripcion as nombre', 'check_accesorios_servicios.cantidad')
                ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_servicios.id_accesorio')
                ->where('check_accesorios_servicios.id_asig_servicio', '=', $dato->id)
                ->get();

            $tabla .= '<td>';
            foreach ($accesorios as $key => $partes) {
                $tabla .= ($key + 1) . '-' . $partes->nombre . '(' . $partes->cantidad . ') <br> ';
            }
            $tabla .= '</td>';

            $tabla .= '</tr>';
        }

        return $tabla;
    }
    public function firma_servicio($id)
    {

        try {
            $id_solicitud = Crypt::decryptString($id);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        $asignacion_solicitudes = DB::table('asignacion_solicitudes')
            ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
            ->select(
                'asignacion_solicitudes.id as idAsig',
                'check_formulario_solicitudes.sComuna',
                'asignacion_solicitudes.fecha',
                'asignacion_solicitudes.estado_externo',
                'asignacion_solicitudes.url_firma',
                'check_formulario_solicitudes.sSC',
                'check_formulario_solicitudes.sProveedor',
                'asignacion_solicitudes.estado_interno',
                'check_formulario_solicitudes.sDireccion',
                'check_formulario_solicitudes.sSerie',
                'check_formulario_solicitudes.sContacto',
                'check_formulario_solicitudes.sTelefono',
                'check_formulario_solicitudes.sModelo',
                'check_formulario_solicitudes.sDescripcion',
                'check_formulario_solicitudes.sCliente'
            )
            ->where("asignacion_solicitudes.id", "=", $id_solicitud)
            ->get();
        return view('solicitudes_servicios.firmaservicio', compact('asignacion_solicitudes'));
    }
    public function pdfcorreo(request $request)
    {
        Config::set('database.connections.mysql.database', strtoupper("SYNERGY"));
        DB::reconnect();
        $id_asignacion = $request->idasig;

        $mi_asignacion = DB::table('asignacion_solicitudes')
            ->where('asignacion_solicitudes.id', '=', $id_asignacion)
            ->get();
        $id_trabajador = $mi_asignacion[0]->trabajadors_id;
        $idApiSolicitud = $mi_asignacion[0]->api_solicitudes_id;
        $trabajadors_id = $mi_asignacion[0]->trabajadors_id;

        //datos del usuario
        $datosTrabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('trabajadors.id', '=', $trabajadors_id)
            ->get();
        // $firmatrabajador = DB::table('firma_clientes')
        //     ->where('firma_clientes.id_tecnico', '=', $datosTrabajador[0]->id)
        //     ->get();

        $firmatrabajador = DB::table('firma_clientes')
        ->where('firma_clientes.id_tecnico', '=', $trabajadors_id)
        ->get();
        //tracket proyecto_id
        $apiSolicitud = DB::table('api_solicitudes')
            ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->where('api_solicitudes.id', '=', $idApiSolicitud)
            ->get();

        // tipo_equipamientos
        $tipo_equipamientos_dvRevelado = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "DV - UN Revelado(s)")
            ->get();
        $tipo_equipamientos_dkCilindro = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "DK - UN Cilindro(s)")
            ->get();
        $tipo_equipamientos_detalleEquipamiento = DB::table('tipo_equipamientos')
            ->where('tipo_equipamientos.id_asig', '=', $id_asignacion)
            ->where('tipo_equipamientos.opcion', '=', "Detalle del equipamiento")
            ->get();
        $fotos = DB::table('fotos_checks_servicios')
            ->where('fotos_checks_servicios.id_servicios', '=', $id_asignacion)
            ->get();
        $acceDanos = DB::table('check_accesorios_danados_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_danados_servicios.id_accesorio')
            ->where('check_accesorios_danados_servicios.id_asig_serv', '=', $id_asignacion)
            ->get();
        $acceSoli = DB::table('check_accesorios_servicios')
            ->join('accesorios', 'accesorios.id', '=', 'check_accesorios_servicios.id_accesorio')
            ->where('check_accesorios_servicios.id_asig_servicio', '=', $id_asignacion)
            ->get();
        //estas son las tres imagenes
        $fotos_servicios_cheks = DB::table('fotos_servicios_cheks')
            ->where('fotos_servicios_cheks.checklist_asignacion_id', '=', $id_asignacion)
            ->get();
        $acceManu = DB::table('accesorios_manuales_servicios')
            ->where('accesorios_manuales_servicios.id_checklist_instalacion', '=', $id_asignacion)
            ->get();

        $asignacion_solicitudes = DB::table('asignacion_solicitudes')
            ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
            ->where('asignacion_solicitudes.id', '=', $id_asignacion)
            ->orderBy('asignacion_solicitudes.id', 'desc')
            ->select(
                'asignacion_solicitudes.id as idAsig',
                'check_formulario_solicitudes.sComuna',
                'asignacion_solicitudes.fecha',
                'asignacion_solicitudes.estado_externo',
                'asignacion_solicitudes.url_firma',
                'asignacion_solicitudes.fecha_inicio',
                'asignacion_solicitudes.fecha_local as fechadellocal',
                'asignacion_solicitudes.fecha_fin',
                'asignacion_solicitudes.estado_interno',
                'check_formulario_solicitudes.sRegion',
                'check_formulario_solicitudes.sDireccion',
                'check_formulario_solicitudes.sSerie',
                'check_formulario_solicitudes.sSC',
                'check_formulario_solicitudes.sProveedor',
                'check_formulario_solicitudes.sContacto',
                'check_formulario_solicitudes.sTelefono',
                'check_formulario_solicitudes.sModelo',
                'check_formulario_solicitudes.numero_ot',
                'check_formulario_solicitudes.contador_bn',
                'check_formulario_solicitudes.contador_color',
                'check_formulario_solicitudes.ip',
                'check_formulario_solicitudes.usb',
                'check_formulario_solicitudes.descripcion',
                'check_formulario_solicitudes.tipo_componente',
                'check_formulario_solicitudes.solicita_acessorios',
                'check_formulario_solicitudes.observaciones',
                'check_formulario_solicitudes.nombre_contacto_firma',
                'check_formulario_solicitudes.correo_contacto',
                'check_formulario_solicitudes.firma_contacto',
                'check_formulario_solicitudes.estado_seleccionado',
                'check_formulario_solicitudes.motivo_accesorio',
                'check_formulario_solicitudes.t_uno',
                'check_formulario_solicitudes.t_dos',
                'check_formulario_solicitudes.t_tres',
                'check_formulario_solicitudes.sCliente',
                'check_formulario_solicitudes.Smarca',
                'check_formulario_solicitudes.equipos',

                'check_formulario_solicitudes.dFecCre as fecha_check'
            )
            ->get();
 //SLA Y DEPARTAMENTO
 $getDataApisol = DB::table('api_solicitudes')
 ->select("departamento","tipo_of_sinergy")
 ->where('api_solicitudes.id', '=', $idApiSolicitud)

 ->get();
        $fecha_inicio = date_create($asignacion_solicitudes[0]->fecha_inicio);
        $fecha_inicio = date_format($fecha_inicio, "d-m-Y H:i:s");
        $fecha_fin = date_create($asignacion_solicitudes[0]->fecha_fin);
        $fecha_fin = date_format($fecha_fin, "d-m-Y H:i:s");


        $instalacion_accesorios = DB::table('checklist_instalacion_accesorios_servicios')
        ->join('accesorios', 'accesorios.id', '=', 'checklist_instalacion_accesorios_servicios.id_accesorio')
        ->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_instalacion_accesorios_servicios.cantidad', 'accesorios.id as ID', 'checklist_instalacion_accesorios_servicios.serie_parte')
        ->where('id_asig_servicio', '=', $id_asignacion)
        ->get();

        return \PDF::setOptions((['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true]))
            ->loadView('solicitudes_servicios/pdf.pdfSolicitudProveedor', compact('idApiSolicitud','getDataApisol','instalacion_accesorios','acceManu', 'firmatrabajador', 'fecha_fin', 'fecha_inicio', 'datosTrabajador', 'fotos_servicios_cheks', 'acceSoli', 'acceDanos', 'fotos', 'tipo_equipamientos_detalleEquipamiento', 'tipo_equipamientos_dkCilindro', 'tipo_equipamientos_dvRevelado', 'asignacion_solicitudes'))
            ->stream($asignacion_solicitudes[0]->sSC . '.pdf');
    }

    public function cambiodeobservacionservicio(request $req ){

        //
        $asignacion_solicitudes = DB::table('asignacion_solicitudes')

       ->where("asignacion_solicitudes.id","=",$req->id_asignacion_check)->get();

       $check_formulario_solicitudes =  App\check_formulario_solicitudes::findOrfail($asignacion_solicitudes[0]->check_formulario_solicitudes_id);

            if($req->opcion == "descripcion"){
                $check_formulario_solicitudes->descripcion = $req->observacion;
            }else{
                $check_formulario_solicitudes->observaciones = $req->observacion;

            }
            $check_formulario_solicitudes->timestamps = false;
            $check_formulario_solicitudes->save();



        return $req->observacion;
    }
}
