<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Carbon\Carbon;
use Auth;
use Crypt;
use DateTime;
use DateInterval;
use App;
use App\checklist_instalacions;
use App\solicitudes_remotas;
use App\sol_remota_rechazadas;

use App\banco_api_solicitudes;
use App\check_banco_api_solicitudes;
use Illuminate\Support\Facades\Redirect;
use App\asignacion_banco_api_solis;
use App\api_solicitudes;
use Illuminate\Support\Facades\Response;

use App\Http\Controllers\solicitudes\checkController;




use DatePeriod;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

     function conectarEliminarData($datos){


        $fields_string = http_build_query($datos);
        $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, "http://35.232.42.155/produccionespejo/rendicion/api/eliminar_solicitud_api_synergy?");
        curl_setopt($ch, CURLOPT_URL, "https://ayaingenieria.cl/aya/rendicion//api/eliminar_solicitud_api_synergy?");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string );
        $data = curl_exec($ch);
        curl_close($ch);
    //     echo $data;
    // return 1;
    return;
    }


    public function enviarsistemaaya(request $request){
        $idSolicitudRemota =  $request->issolicitudremota;





       $dataSolicitudRemota  =   App\solicitudes_remotas::select("banco_api_solicitudes.id as idbancoinformacion"
       ,"banco_api_solicitudes.zona_geoge"
       ,"asignacion_banco_api_solis.solucionado"
       ,"asignacion_banco_api_solis.observacion_tecnico as   observacionTecnico"
       ,"banco_api_solicitudes.*"
       ,"solicitudes_remotas.*"
       ,"solicitudes_remotas.estado as estado_solicitud_remota"
       
       ,"solicitudes_remotas.Ssc as nuevasc"
       ,"asuntos.descripcion as descripcion_asuntos")
        ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
        ->join("banco_api_solicitudes","banco_api_solicitudes.id","=","solicitudes_remotas.id_api_banco_solicitud")
        ->join("asignacion_banco_api_solis","asignacion_banco_api_solis.id_solicitud_remota","=","solicitudes_remotas.id")

        ->where('solicitudes_remotas.id', $idSolicitudRemota)
        ->get();


        //Verificamos si esta asignado aya para poder eliminarlo

        if (strtoupper($dataSolicitudRemota[0]->estado_solicitud_remota) == strtoupper("ASIGNADO AYA")) {
           
           
            $fields = array(
                "api_key" => "qrywgthj",

                "Ssc"=> $dataSolicitudRemota[0]->nuevasc,
            );


            $this->conectarEliminarData($fields);

        }

if ($request->has('zonareasignar')) {
    // El campo 'zonareasignar' está presente en la solicitud
    $zonaSeleccionada = $request->input('zonareasignar');
    // Aquí puedes continuar con el código que necesites
    // usando el valor de $zonareasignarValue
} else {
    $zonaSeleccionada  =  $dataSolicitudRemota[0]->zona_geoge;

}







if (strtoupper($zonaSeleccionada) == "NORTE" || strtoupper($zonaSeleccionada) == "CENTRO") {


    $banco_api_solicitudes = banco_api_solicitudes::find($dataSolicitudRemota[0]->idbancoinformacion); // Supongamos que el post con ID 1 es el que queremos duplicar
 
 


    $api_solicitudes = App\api_solicitudes::where('id_solicitudes_remotas', '=', $idSolicitudRemota)->first();
    $api_solicitudes->estado_interno = "POR ASIGNAR";
    $api_solicitudes->estado_externo = "POR ASIGNAR";
    $api_solicitudes->asignado_aya = "NO";
    $api_solicitudes->zona_geoge = strtoupper($zonaSeleccionada);
    $api_solicitudes->tipo_asignacion_interna = 0;   
    $api_solicitudes->timestamps = false;
    $api_solicitudes->save();


    // $this->envioCorreoAsignado($api_solicitudes);
    $resultado = app(checkController::class)->envioCorreoAsignado($api_solicitudes);



    // $getDataAsig = App\asignacion_solicitudes::where('id_solicitud_remota', $idSolicitudRemota)->first();


    
    // $get_check_solicitud = App\check_formulario_solicitudes::where('id', '=', $getDataAsig->check_formulario_solicitudes_id)->first();
    // $get_check_solicitud->zona_geoge = strtoupper($zonaSeleccionada);
    // $get_check_solicitud->tipo_asignacion_interna = 0;   
    // $get_check_solicitud->timestamps = false;
    // $get_check_solicitud->save();


    $asignacion_banco_api_solis = asignacion_banco_api_solis::where('id_solicitud_remota', '=', $idSolicitudRemota)->first();
    $asignacion_banco_api_solis->estado = "asignado a la zona: ".$zonaSeleccionada;
    $asignacion_banco_api_solis->timestamps = false;
    $asignacion_banco_api_solis->save();




    $solicitudes_remotas = solicitudes_remotas::where('id', '=', $idSolicitudRemota)->first();
    $solicitudes_remotas->estado ="asignado a la zona: ".$zonaSeleccionada;
    $solicitudes_remotas->timestamps = false;
    $solicitudes_remotas->save();

}else{



    $fechaActual = date('Y-m-d H:i:s');

                    $asignacion_banco_api_solis = asignacion_banco_api_solis::where('id_solicitud_remota', '=', $idSolicitudRemota)->first();
                    $asignacion_banco_api_solis->estado = "asignado aya";
                    $asignacion_banco_api_solis->timestamps = false;
                    $asignacion_banco_api_solis->save();

                    $solicitudes_remotas = solicitudes_remotas::where('id', '=', $idSolicitudRemota)->first();
                    $solicitudes_remotas->estado = "asignado aya";
                    $solicitudes_remotas->timestamps = false;
                    $solicitudes_remotas->save();




                    //para la insercion de los datos inetos

                    $getDataRemota = App\solicitudes_remotas::where('id', '=', $idSolicitudRemota)->first();


                    $Api_solicitudes = App\api_solicitudes::where('id_solicitudes_remotas', '=', $idSolicitudRemota)->first();

            //  $this->envioCorreoAsignado($api_solicitudes);
            $resultado = app(checkController::class)->envioCorreoAsignado($Api_solicitudes);



                    //insertamos los datos en api_solicitud y asignaciones y check
                    // $data = banco_api_solicitudes::find($dataSolicitudRemota[0]->idbancoinformacion); // Supongamos que el post con ID 1 es el que queremos duplicar
                
                    $data  =   App\solicitudes_remotas::select("asignacion_banco_api_solis.id_tecnico as id_user","solicitudes_remotas.id as idSolicitudRemota","asignacion_banco_api_solis.solucionado","asignacion_banco_api_solis.observacion_tecnico as   observacionTecnico","banco_api_solicitudes.*","solicitudes_remotas.*","asuntos.descripcion as descripcion_asuntos")
                    ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                    ->join("banco_api_solicitudes","banco_api_solicitudes.id","=","solicitudes_remotas.id_api_banco_solicitud")
                    ->join("asignacion_banco_api_solis","asignacion_banco_api_solis.id_solicitud_remota","=","solicitudes_remotas.id")
            
                    ->where('solicitudes_remotas.id', $idSolicitudRemota)
                    ->get();

                    $Api_solicitudes = App\api_solicitudes::where('id_solicitudes_remotas', '=', $idSolicitudRemota)->first();
                    $Api_solicitudes->estado_interno = "POR ASIGNAR";
                    $Api_solicitudes->estado_externo = "POR ASIGNAR";
                    $Api_solicitudes->tipo_asignacion_interna = 0;
                    $Api_solicitudes->asignado_aya = "SI";
                    $Api_solicitudes->timestamps = false;
                    $Api_solicitudes->save();




                    
                    $existeDato = App\asignacion_solicitudes::where('id_solicitud_remota', $idSolicitudRemota)->exists();
                    
                    
                    if ($existeDato) {
                        //SI EXISTE, NECESITAMOS ACTUALIZAR LA INFORMACION


                        $asignacion = App\asignacion_solicitudes::where('id_solicitud_remota', $idSolicitudRemota)->first();
                        $asignacion->fecha = $fechaActual;
                        $asignacion->id_solicitud_remota =  $idSolicitudRemota;
                        $asignacion->numero_visita = 1;
                        $asignacion->estado_interno = "POR ASIGNAR";
                        $asignacion->estado_externo = "POR ASIGNAR";
                        $asignacion->api_solicitudes_id = $Api_solicitudes->id;
                        $asignacion->fecha_asignacion = $fechaActual;
                        $asignacion->timestamps = false;
                        $asignacion->save();

    


                    }else{

                        $solicitud = DB::table('api_solicitudes')
                        ->where('api_solicitudes.id', '=', $Api_solicitudes->id)
                        ->get();
                    
                        //SI NO EXISTE TENEMOS QUE CREAR LOS REGISTROS

                        $check_solicitud = new App\check_formulario_solicitudes;
                        $check_solicitud->descripcion = $solicitud[0]->sDescripcion;
                        $check_solicitud->numero_ot = $solicitud[0]->sSC;
                        $check_solicitud->nId_OT = $solicitud[0]->nId_OT;
                        $check_solicitud->sSC = $solicitud[0]->sSC;
                        $check_solicitud->sProveedor = $solicitud[0]->sProveedor;
                        $check_solicitud->sPrioridad = $solicitud[0]->sPrioridad;
                        $check_solicitud->dFecha = $solicitud[0]->dFecha;
                        $check_solicitud->sCliente = $solicitud[0]->sCliente;
                        $check_solicitud->sTelefono = $solicitud[0]->sTelefono;
                        $check_solicitud->sContacto = $solicitud[0]->sContacto;
                        $check_solicitud->sDireccion = $solicitud[0]->sDireccion;
                        $check_solicitud->sComuna = $solicitud[0]->sComuna;
                        $check_solicitud->sRegion = $solicitud[0]->sRegion;
                        $check_solicitud->sTipoLlamada = $solicitud[0]->sTipoLlamada;
                        $check_solicitud->sDescripcion = $solicitud[0]->sDescripcion;
                        $check_solicitud->sQR = $solicitud[0]->sQR;
                        $check_solicitud->sSerie = $solicitud[0]->sSerie;
                        $check_solicitud->sModelo = $solicitud[0]->sModelo;
                        $check_solicitud->sUbicacion = $solicitud[0]->sUbicacion;
                        $check_solicitud->dFecCre = $solicitud[0]->dFecCre;
                        $check_solicitud->sTipoContrato = $solicitud[0]->sTipoContrato;
                        $check_solicitud->nId_EstadoOT = $solicitud[0]->nId_EstadoOT;
                        $check_solicitud->dFechaEstadoOT = $solicitud[0]->dFechaEstadoOT;
                        $check_solicitud->nId_Tecnico = $solicitud[0]->nId_Tecnico;
                        $check_solicitud->sObs = $solicitud[0]->sObs;
                        $check_solicitud->dFechaFab = $solicitud[0]->dFechaFab;
                        $check_solicitud->dFechaCreacion = $solicitud[0]->dFechaCreacion;
                        $check_solicitud->dFechaModif = $solicitud[0]->dFechaModif;
                        $check_solicitud->bDeleted = $solicitud[0]->bDeleted;
                        $check_solicitud->sUsuario = $solicitud[0]->sUsuario;
                        $check_solicitud->equipos = $solicitud[0]->equipos;
                        $check_solicitud->Smarca = $solicitud[0]->Smarca;
                        $check_solicitud->ip =  $solicitud[0]->sIP;
                        $check_solicitud->timestamps = false;
                        $check_solicitud->save();


                        $asignacion = new App\asignacion_solicitudes;
                        $asignacion->fecha = $fechaActual;
                        $asignacion->id_solicitud_remota =  $idSolicitudRemota;
                        $asignacion->numero_visita = 1;
                        $asignacion->estado_interno = "POR ASIGNAR";
                        $asignacion->estado_externo = "POR ASIGNAR";
                        $asignacion->api_solicitudes_id =  $solicitud[0]->id;
                        $asignacion->trabajadors_id = 1; //externoaya
                        $asignacion->check_formulario_solicitudes_id = $check_solicitud->id;
                        $asignacion->trabajadors_id_coordinadora = 1; //externoaya
                        $asignacion->fecha_asignacion = $fechaActual;
                        $asignacion->timestamps = false;
                        $asignacion->save();
    
           
                    }



                   


                        // get curl @toro
                    $fields = array(
                        "api_key" => "qrywgthj",

                        "nId_OT"=> $dataSolicitudRemota[0]->nId_OT,
                        "sSC"=> $dataSolicitudRemota[0]->nuevasc,
                        "sProveedor"=> $dataSolicitudRemota[0]->sProveedor,
                        "sPrioridad"=> $dataSolicitudRemota[0]->sPrioridad,
                        "dFecha"=> $dataSolicitudRemota[0]->dFecha,
                        "sCliente"=> $dataSolicitudRemota[0]->sCliente,
                        "sTelefono"=> $dataSolicitudRemota[0]->sTelefono,
                        "sContacto"=> $dataSolicitudRemota[0]->sContacto,
                        "sDireccion"=> $dataSolicitudRemota[0]->sDireccion,
                        "sComuna"=> $dataSolicitudRemota[0]->sComuna,
                        "sRegion"=> $dataSolicitudRemota[0]->sRegion,
                        "sTipoLlamada"=> $dataSolicitudRemota[0]->sTipoLlamada,
                        "sDescripcion"=> $dataSolicitudRemota[0]->sDescripcion.",...  Asunto: ".$dataSolicitudRemota[0]->descripcion_asuntos.", Observacion: " . $dataSolicitudRemota[0]->observaciones,
                        "sQR"=> $dataSolicitudRemota[0]->sQR,
                        "sSerie"=> $dataSolicitudRemota[0]->sSerie,
                        "sModelo"=> $dataSolicitudRemota[0]->sModelo,
                        "sUbicacion"=> $dataSolicitudRemota[0]->sUbicacion,
                        "sTelefono"=> $dataSolicitudRemota[0]->sTelefono,
                        "dFecCre"=> $dataSolicitudRemota[0]->dFecCre,
                        "sTipoContrato"=> $dataSolicitudRemota[0]->sTipoContrato,
                        "nId_EstadoOT"=> $dataSolicitudRemota[0]->nId_EstadoOT,
                        // "dFechaEstadoOT"=> $dataSolicitudRemota[0]->dFechaEstadoOT,
                        "nId_Tecnico"=> $dataSolicitudRemota[0]->nId_Tecnico,
                        "sObs"=> $dataSolicitudRemota[0]->sObs,
                        // "dFechaCreacion"=> $dataSolicitudRemota[0]->dFechaCreacion,
                        // "dFechaModif"=> $dataSolicitudRemota[0]->dFechaModif,
                        "bDeleted"=> $dataSolicitudRemota[0]->bDeleted,
                        // "dFechaFab"=> $dataSolicitudRemota[0]->sUsuario,
                        "sUsuario"=> null,
                        "proveedor_servicio"=> $dataSolicitudRemota[0]->proveedor_servicio,


                        "area"=> $dataSolicitudRemota[0]->area,
                        "Smarca"=> $dataSolicitudRemota[0]->Smarca,
                        "sIP"=> $dataSolicitudRemota[0]->sIP,
                        "estado_interno"=> $dataSolicitudRemota[0]->estado_interno,
                        "estado_externo"=> $dataSolicitudRemota[0]->estado_externo



                    );
                   $this->conectar($fields);
     return Redirect::to('/home');



        }


     return Redirect::to('/home');

    }

    function conectar($datos){


        $fields_string = http_build_query($datos);
        $ch = curl_init();
        // curl_setopt($ch, CURLOPT_URL, "http://35.232.42.155/produccionespejo/rendicion/api/crear_solicitud_api_synergy?");
        curl_setopt($ch, CURLOPT_URL, "https://ayaingenieria.cl/aya/rendicion/api/crear_solicitud_api_synergy?");
        
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string );
        $data = curl_exec($ch);
        curl_close($ch);
    //     echo $data;
    // return 1;
    return;
    }



    public function misasignaciones($idAsignacion){
        $dataSolicitudRemota = asignacion_banco_api_solis::join("check_banco_api_solicitudes","check_banco_api_solicitudes.id","=","asignacion_banco_api_solis.id_check_banco_info")
        ->join("solicitudes_remotas","solicitudes_remotas.id","=","asignacion_banco_api_solis.id_solicitud_remota")
         ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
        ->select("solicitudes_remotas.inc","asuntos.descripcion as descripcion_asuntos","solicitudes_remotas.observaciones as observacion_ingresada","solicitudes_remotas.comentario_coordinador","asignacion_banco_api_solis.*","check_banco_api_solicitudes.*","asignacion_banco_api_solis.id as idasignacion",
        "asignacion_banco_api_solis.fecha_asignado"
        )
        ->where("asignacion_banco_api_solis.id","=",$idAsignacion)->get();

        $reasignacion = "no";


        return view('solicitudes_servicios/remote/revisarasignacion',compact('reasignacion',"dataSolicitudRemota","idAsignacion"));

}
public function misasignacionesremotasfinalizadas(){


    $totalAsignadas = asignacion_banco_api_solis::join("check_banco_api_solicitudes","check_banco_api_solicitudes.id","=","asignacion_banco_api_solis.id_check_banco_info")

    ->select("asignacion_banco_api_solis.id_solicitud_remota as identificador","asignacion_banco_api_solis.*","check_banco_api_solicitudes.*","asignacion_banco_api_solis.id as idasignacion",
    "asignacion_banco_api_solis.fecha_asignado",
    "asignacion_banco_api_solis.fecha_respuesta"
    )
    ->where("asignacion_banco_api_solis.estado","=","finalizado")
    ->where("id_tecnico","=",Auth::user()->id)->get();


    // foreach ($totalAsignadas as $asignada) {
        foreach ($totalAsignadas as $indice => $asignada) {

        // Agregar los tres nuevos campos
        $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")->where('solicitudes_remotas.id', $totalAsignadas[$indice]->identificador)->get();
        $Ssc = App\solicitudes_remotas::select("solicitudes_remotas.Ssc")->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")->where('solicitudes_remotas.id', $totalAsignadas[$indice]->identificador)->get();
        $getapi_solicitudes = App\api_solicitudes::select("api_solicitudes.oficina")->where('id_solicitudes_remotas', $totalAsignadas[$indice]->identificador)->get();

        // public static function calcularSlaZonas($id_solicitud_remota,$fecha_fin = "no",$fecha_tecnico = "",$estado_interno = ""){


        $getDataSla = App\sla_zonas::calcularSlaZonas($identificador,"si", $asignada->fecha_respuesta,"FINALIZADO");
        
        $asignada->zona = $totalAsignadas[0]->zona_geoge;
        $asignada->minutosTotales =  $getDataSla["minutosTotales"];
        $asignada->tiempoTranscurrido =   $getDataSla["tiempoTranscurrido"];
        $asignada->minutos_restantes =  $getDataSla["minutos_restantes"];
        $asignada->porcentaje_transcurrido = $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]);

        $asignada->oficina =   $getapi_solicitudes[0]->oficina;



        $asignada->nuevaSc = $Ssc[0]->Ssc;

    }
    
    return $totalAsignadas;

}
    public function misasignacionesremotas(){


        $totalAsignadas = asignacion_banco_api_solis::join("check_banco_api_solicitudes","check_banco_api_solicitudes.id","=","asignacion_banco_api_solis.id_check_banco_info")
        ->select("asignacion_banco_api_solis.estado","asignacion_banco_api_solis.id_solicitud_remota as identificador","asignacion_banco_api_solis.*","check_banco_api_solicitudes.*","asignacion_banco_api_solis.id as idasignacion",
            "asignacion_banco_api_solis.fecha_asignado")
        ->where(function($query) {
            $query->where("asignacion_banco_api_solis.estado", "=", "asignado_remoto")
                  ->orWhere("asignacion_banco_api_solis.estado", "=", "Rechazada Remoto");
        })
        ->where("asignacion_banco_api_solis.id_tecnico","=",Auth::user()->id)
        ->get();


        // foreach ($totalAsignadas as $asignada) {
            foreach ($totalAsignadas as $indice => $asignada) {

            // Agregar los tres nuevos campos
            $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")->where('solicitudes_remotas.id', $totalAsignadas[$indice]->identificador)->get();
            $Ssc = App\solicitudes_remotas::select("solicitudes_remotas.Ssc")->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")->where('solicitudes_remotas.id', $totalAsignadas[$indice]->identificador)->get();


            $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);
            
            $asignada->zona = $totalAsignadas[0]->zona_geoge;
            $asignada->minutosTotales =  $getDataSla["minutosTotales"];
            $asignada->tiempoTranscurrido =   $getDataSla["tiempoTranscurrido"];
            $asignada->minutos_restantes =  $getDataSla["minutos_restantes"];
            $asignada->porcentaje_transcurrido = $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]);



            $asignada->nuevaSc = $Ssc[0]->Ssc;

        }
        
        return $totalAsignadas;

    }


    public function consultarpendienestesexterna(){


        $pageSize = isset($_GET['pageSize']) ? $_GET['pageSize'] : 10;
        $pendientes = App\banco_api_solicitudes::select("banco_api_solicitudes.*",'solicitudes_remotas.fecha_registrada as fechaRegistradaAsignacion')
            ->join("solicitudes_remotas", "solicitudes_remotas.id_api_banco_solicitud", "=", "banco_api_solicitudes.id")
            ->where("estado_atencion_remota", "=", "1")
         ->where('solicitudes_remotas.estado',"!=","FINALIZADO")

            ->orderBy('solicitudes_remotas.fecha_registrada', 'ASC')
            ->paginate($pageSize);

     //  $pendientes = App\banco_api_solicitudes::where("estado_atencion_remota", "=", "1")
     //                                    ->orderBy('id', 'desc')
     //                                    ->get();
     $proveedores= [];

     foreach ($pendientes as $pendiente) {
         $fregistrada = App\solicitudes_remotas::select("solicitudes_remotas.fecha_registrada","solicitudes_remotas.Ssc","solicitudes_remotas.inc")
         ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
         ->where('id_api_banco_solicitud', $pendiente->id)
         ->where('solicitudes_remotas.estado',"!=","FINALIZADO")
         
         ->get();
         $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
         ->where('solicitudes_remotas.estado',"!=","FINALIZADO")
         ->where('solicitudes_remotas.id_api_banco_solicitud', $pendiente->id)->get();
            $asunto = App\solicitudes_remotas::select("asuntos.descripcion as descripcion_asuntos")->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
         ->where('solicitudes_remotas.estado',"!=","FINALIZADO")
            ->where('id_api_banco_solicitud', $pendiente->id)->get();
         $estado = App\solicitudes_remotas::select("solicitudes_remotas.estado")->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
         ->where('solicitudes_remotas.estado',"!=","FINALIZADO")
         ->where('id_api_banco_solicitud', $pendiente->id)->get();
         $solucionado = App\asignacion_banco_api_solis::select("asignacion_banco_api_solis.solucionado")->where('id_solicitud_remota', $identificador[0]->id)->get();
         
         $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);

         $getData = App\api_solicitudes::select("*")->where('id_solicitudes_remotas',  $identificador[0]->id)->get();
         // Verificar si la consulta devuelve algún resultado
         if (!$getData->isEmpty()) {
             // Si trae datos, asignar el valor de asignado_aya a una variable
             $asignadoAya = $getData[0]->asignado_aya;
             $estadointerno = $getData[0]->estado_interno;
         } else {
             // Si no trae datos, asignar 'NO' a la variable
             $asignadoAya = 'NO';
             $estadointerno = "";

         }

         if($estadointerno == "GESTION REMOTA"){
            $estadointerno = "";

         }
                     

         // {"fechaRegistrada":"2024-03-07 09:54:40","minutosTotales":180,"tiempoTranscurrido":367,"minutos_restantes":-187}
         // return $getDataSla;

         $NombreTecnico ="";
         if($estado[0]->estado == "ASIGNADO AYA"){
             $NombreTecnico ="ASIGNADO AYA";


         }elseif($estado[0]->estado == "por asignar"){
             $NombreTecnico ="SIN ASIGNAR";
             // SING

         }else{

                 $datos_asignacion = DB::table('asignacion_solicitudes')
                 ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
                 ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                 ->where('asignacion_solicitudes.api_solicitudes_id', '=', $getData[0]->id)
                 ->select('asignacion_solicitudes.id', DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) AS nombre_completo"),
                  'asignacion_solicitudes.estado_interno', 'asignacion_solicitudes.fecha')
                 // ->orderBy('asignacion_solicitudes.id', 'desc')
                 ->get();





                 if (isset($datos_asignacion[0])) {

                         $totaldeAtenciones = count($datos_asignacion) - 1 ; //para que siempre quede en cero cuando sea necesario, ya que comienza en cero
                    
                    
                    $NombreTecnico = $datos_asignacion[$totaldeAtenciones]->nombre_completo;
                 
                
                } else {





                     // Hacer algo si no hay datos en $datos_asignacion
                     $NombreTecnico = "Sin nombre"; // Por ejemplo, asignar un valor predeterminado
                   $getDataInformacion = App\asignacion_banco_api_solis::where('id_solicitud_remota', '=', $identificador[0]->id)->first();
                   $getDataInformacionTrabajador = App\persona::select(DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) AS nombre_completo"))
                   ->join("trabajadors","trabajadors.id_persona","=","personas.id")
                   ->where("trabajadors.id_login","=",$getDataInformacion->id_tecnico)->get();



                   if (strpos(strtoupper($estado[0]->estado), 'ASIGNADO A LA ZONA:') !== false) {
                     $NombreTecnico = "ASIGNADO A ZONA";
                     } else {
                         $NombreTecnico =  $getDataInformacionTrabajador[0]->nombre_completo;
                         // $NombreTecnico =  $getDataInformacionTrabajador[0]->nombre_completo;
                     }
                                         //   $NombreTecnico =  $getDataInformacionTrabajador[0]->nombre_completo;


                     
                 }

         }


         $proveedores[] = [
             'sSC' =>  $fregistrada[0]->Ssc,
             'inc' =>  $fregistrada[0]->inc,
             'sIP' => $pendiente->sIP ?? '',
             'sSerie' => $pendiente->sSerie ?? '',
             'sDireccion' => $pendiente->sDireccion,
             'cod_of' => $pendiente->cod_of,
             'oficina' => $pendiente->oficina,
             'estadointerno' => $estadointerno,
             
             'sComuna' => $pendiente->sComuna,
             'zona' => $pendiente->zona_geoge,
             'asignadoAya' => $asignadoAya,
             'nombretecnico' => $NombreTecnico,

             'solucionado' => $solucionado[0]->solucionado ?? "por asignar",

            //  'fecha_registrada' =>  $fregistrada[0]->fecha_registrada,
            'fecha_registrada' =>  $pendiente->fechaRegistradaAsignacion,

             
             'identificador_solicitud_remota' => encrypt($identificador[0]->id),
             'identificadorRemoto' => $identificador[0]->id,

             'asunto' =>  $asunto[0]->descripcion_asuntos,


             'estado' =>  $estado[0]->estado,




             'minutosTotales' =>  $getDataSla["minutosTotales"],
             'tiempoTranscurrido' =>  $getDataSla["tiempoTranscurrido"],
             'minutos_restantes' =>  $getDataSla["minutos_restantes"],

             'porcentaje_transcurrido' =>  $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]),


             

             // Add more fields as needed
         ];


         }
        //  usort($proveedores, function($a, $b) {
        //      return $a['minutos_restantes'] - $b['minutos_restantes'];
        //  });
         // usort($proveedores, function($a, $b) {
         //     return $b['identificadorRemoto'] - $a['identificadorRemoto'];
         // });
 return response()->json([
     'data' => $proveedores, // Datos de las solicitudes
    //  'page' => $page, // Número de página actual
     'pageSize' => $pageSize, // Tamaño de página
     'total' => App\banco_api_solicitudes::where("estado_atencion_remota", "=", "1")->count(), // Total de registros (sin paginación)
 ]);

}

     public function consultarpendienestesexterna_OLD(){


           // Obtener el número de página y el tamaño de la página desde la solicitud
   
    // Obtener el número de página y el tamaño de la página desde la URL
    $page = isset($_GET['page']) ? $_GET['page'] : 1; // Página predeterminada: 1
    $pageSize = isset($_GET['pageSize']) ? $_GET['pageSize'] : 10; // Tamaño de página predeterminado: 10

    // Calcular el desplazamiento basado en el número de página y el tamaño de la página
    $offset = ($page - 1) * $pageSize;

    // Consulta modificada con límite y desplazamiento
    $pendientes = App\banco_api_solicitudes::select("banco_api_solicitudes.*")->join("solicitudes_remotas","solicitudes_remotas.id_api_banco_solicitud","=","banco_api_solicitudes.id")->where("estado_atencion_remota", "=", "1")
                                           ->orderBy('solicitudes_remotas.id', 'ASC')
                                           ->skip($offset)
                                        //    ->take($pageSize)
                                           ->get();

        //  $pendientes = App\banco_api_solicitudes::where("estado_atencion_remota", "=", "1")
        //                                    ->orderBy('id', 'desc')
        //                                    ->get();
        $proveedores= [];

        foreach ($pendientes as $pendiente) {
            $fregistrada = App\solicitudes_remotas::select("solicitudes_remotas.fecha_registrada","solicitudes_remotas.Ssc","solicitudes_remotas.inc")
            ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
            ->where('id_api_banco_solicitud', $pendiente->id)
            ->where('solicitudes_remotas.estado',"!=","FINALIZADO")
            
            ->get();
            $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
            ->where('solicitudes_remotas.estado',"!=","FINALIZADO")
            ->where('solicitudes_remotas.id_api_banco_solicitud', $pendiente->id)->get();
               $asunto = App\solicitudes_remotas::select("asuntos.descripcion as descripcion_asuntos")->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
            ->where('solicitudes_remotas.estado',"!=","FINALIZADO")
               ->where('id_api_banco_solicitud', $pendiente->id)->get();
            $estado = App\solicitudes_remotas::select("solicitudes_remotas.estado")->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
            ->where('solicitudes_remotas.estado',"!=","FINALIZADO")
            ->where('id_api_banco_solicitud', $pendiente->id)->get();
            $solucionado = App\asignacion_banco_api_solis::select("asignacion_banco_api_solis.solucionado")->where('id_solicitud_remota', $identificador[0]->id)->get();
            
            $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);

            $getData = App\api_solicitudes::select("*")->where('id_solicitudes_remotas',  $identificador[0]->id)->get();
            // Verificar si la consulta devuelve algún resultado
            if (!$getData->isEmpty()) {
                // Si trae datos, asignar el valor de asignado_aya a una variable
                $asignadoAya = $getData[0]->asignado_aya;
            } else {
                // Si no trae datos, asignar 'NO' a la variable
                $asignadoAya = 'NO';
            }
                        

            // {"fechaRegistrada":"2024-03-07 09:54:40","minutosTotales":180,"tiempoTranscurrido":367,"minutos_restantes":-187}
            // return $getDataSla;

            $NombreTecnico ="";
            if($estado[0]->estado == "ASIGNADO AYA"){
                $NombreTecnico ="ASIGNADO AYA";


            }elseif($estado[0]->estado == "por asignar"){
                $NombreTecnico ="SIN ASIGNAR";
                // SING

            }else{

                    $datos_asignacion = DB::table('asignacion_solicitudes')
                    ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
                    ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                    ->where('asignacion_solicitudes.api_solicitudes_id', '=', $getData[0]->id)
                    ->select('asignacion_solicitudes.id', DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) AS nombre_completo"), 'asignacion_solicitudes.estado_interno', 'asignacion_solicitudes.fecha')
                    // ->orderBy('asignacion_solicitudes.id', 'desc')
                    ->get();


                    if (isset($datos_asignacion[0])) {
                        $NombreTecnico = $datos_asignacion[0]->nombre_completo;
                    } else {





                        // Hacer algo si no hay datos en $datos_asignacion
                        $NombreTecnico = "Sin nombre"; // Por ejemplo, asignar un valor predeterminado
                      $getDataInformacion = App\asignacion_banco_api_solis::where('id_solicitud_remota', '=', $identificador[0]->id)->first();
                      $getDataInformacionTrabajador = App\persona::select(DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) AS nombre_completo"))
                      ->join("trabajadors","trabajadors.id_persona","=","personas.id")
                      ->where("trabajadors.id_login","=",$getDataInformacion->id_tecnico)->get();



                      if (strpos(strtoupper($estado[0]->estado), 'ASIGNADO A LA ZONA:') !== false) {
                        $NombreTecnico = "ASIGNADO A ZONA";
                        } else {
                            $NombreTecnico =  $getDataInformacionTrabajador[0]->nombre_completo;
                            // $NombreTecnico =  $getDataInformacionTrabajador[0]->nombre_completo;
                        }
                                            //   $NombreTecnico =  $getDataInformacionTrabajador[0]->nombre_completo;


                        
                    }

            }


            $proveedores[] = [
                'sSC' =>  $fregistrada[0]->Ssc,
                'inc' =>  $fregistrada[0]->inc,
                'sIP' => $pendiente->sIP ?? '',
                'sSerie' => $pendiente->sSerie ?? '',
                'sDireccion' => $pendiente->sDireccion,
                'cod_of' => $pendiente->cod_of,
                'oficina' => $pendiente->oficina,
                
                'sComuna' => $pendiente->sComuna,
                'zona' => $pendiente->zona_geoge,
                'asignadoAya' => $asignadoAya,
                'nombretecnico' => $NombreTecnico,

                'solucionado' => $solucionado[0]->solucionado ?? "por asignar",

                'fecha_registrada' =>  $fregistrada[0]->fecha_registrada,
                'identificador_solicitud_remota' => encrypt($identificador[0]->id),
                'identificadorRemoto' => $identificador[0]->id,

                'asunto' =>  $asunto[0]->descripcion_asuntos,


                'estado' =>  $estado[0]->estado,




                'minutosTotales' =>  $getDataSla["minutosTotales"],
                'tiempoTranscurrido' =>  $getDataSla["tiempoTranscurrido"],
                'minutos_restantes' =>  $getDataSla["minutos_restantes"],

                'porcentaje_transcurrido' =>  $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]),


                

                // Add more fields as needed
            ];


            }
            usort($proveedores, function($a, $b) {
                return $a['minutos_restantes'] - $b['minutos_restantes'];
            });
            // usort($proveedores, function($a, $b) {
            //     return $b['identificadorRemoto'] - $a['identificadorRemoto'];
            // });
    return response()->json([
        'data' => $proveedores, // Datos de las solicitudes
        'page' => $page, // Número de página actual
        'pageSize' => $pageSize, // Tamaño de página
        'total' => App\banco_api_solicitudes::where("estado_atencion_remota", "=", "1")->count(), // Total de registros (sin paginación)
    ]);

}
public function calcularPorcentajeTranscurrido($minutosTotales, $tiempoTranscurrido)
{
    // Calcular el porcentaje de los minutos transcurridos al total
    $porcentaje = ($tiempoTranscurrido / $minutosTotales) * 100;
    // verde #7BCC63 
    // amarillo #EAED0D 
    // rojo #FA4805 
    // negro (en realidad es como gris) #514E4D
  // Determinar el color según el porcentaje
  if ($porcentaje >= 0 && $porcentaje <= 14) {
    return "#7BCC63";
} elseif ($porcentaje > 14 && $porcentaje <= 49) {
    return "#EAED0D";
} elseif ($porcentaje > 49 && $porcentaje <= 75) {
    return "#FA4805";
} elseif ($porcentaje > 75) {
    return "negro";
} else {
    // En caso de que el porcentaje esté fuera de los rangos especificados
    return $porcentaje;

}
    
    return $porcentaje;
}
     public function desactivardiafestivo(){

        $idfestivo = $_GET["idfestivo"];


    //     App\config_usuarios::where('id', $sla_id)
    //    ->update([
    //        'sla' => $sla,
    //        'sla_santiago' => $slas_v
    //     ]);
    $update =  App\dias_festivos::findOrfail($idfestivo);



         $update->estado = 1;
         $update->timestamps = false;
         $update->save();

        return  "ok";
     }

     public function guardarfestivo(){

        $fecha_festiva = $_GET["fecha_festiva"];


    //     App\config_usuarios::where('id', $sla_id)
    //    ->update([
    //        'sla' => $sla,
    //        'sla_santiago' => $slas_v
    //     ]);
         $dias_festivos = new App\dias_festivos;



         $dias_festivos->fecha_festiva = $fecha_festiva;
         $dias_festivos->timestamps = false;
         $dias_festivos->save();

        return  "ok";
     }



     //SYNERGIATENCIONES REGISTROCIVIL

     public function atencionessinergy(request $request)
    {
        $getAllData = App\instalacions::getAllData("SYNERGY",$request->opciones,$request);
            return $getAllData;

        }
        public function editardatosremoto(request $request)
    {

        $solicitudRemota = App\solicitudes_remotas::findOrFail($request->idremoto);

        $idBancoInstalacion=  $solicitudRemota->id_api_banco_solicitud;

                // Buscar la solicitud remota por su ID y actualizar la observación
        $bancoSolicitud = App\banco_api_solicitudes::findOrFail($idBancoInstalacion);

        if($request->Global_tipoModificacion == "direccion"){
            $bancoSolicitud->sDireccion = $request->modificacionEditar ;

        }else if($request->Global_tipoModificacion == "telefono"){
            $bancoSolicitud->sTelefono = $request->modificacionEditar ;
            $bancoSolicitud->telefono_contacto = $request->modificacionEditar ;

        

        }else if($request->Global_tipoModificacion == "email"){
            $bancoSolicitud->email_contacto = $request->modificacionEditar ;

            
        }else if($request->Global_tipoModificacion == "serie"){
            $bancoSolicitud->sSerie = $request->modificacionEditar ;

            
        }
        // Guardar los cambios en la base de datos
        $bancoSolicitud->timestamps = false;

        $bancoSolicitud->save();
   
        return "ok";
    }

    public function comentariocoordinador(request $request)
    {

                // Buscar la solicitud remota por su ID y actualizar la observación
        $solicitudRemota = App\solicitudes_remotas::findOrFail($request->idremoto);

        // Asignar la nueva observación
        $solicitudRemota->comentario_coordinador = $request->muevaObservacion;

        // Guardar los cambios en la base de datos
        $solicitudRemota->timestamps = false;

        $solicitudRemota->save();
   
        return "ok";
    }
    


    public function motivorechazado(request $request)
    {

        if (isset($request->encriptado)) {
           
                $identificador = decrypt($request->idremoto);
          
        } else {
          $identificador = $request->idremoto;
        }
        return     $sol_remota_rechazadas = App\sol_remota_rechazadas::where('id_sol_remota', '=', $identificador)->first();

        return $request->idremoto;
    }


    public function rechazarremoto(request $request,$identificador)
    {

        try {
            $identificador = Crypt::decryptString($identificador);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();
       
        $solicitudes_remotas = App\solicitudes_remotas::where('id', '=', $identificador)->first();
        $solicitudes_remotas->estado = "Rechazada Remoto";
        // $solicitudes_remotas->fecha_finalizada = $FechaHoraActual;
        $solicitudes_remotas->timestamps = false;
        $solicitudes_remotas->save();


        $asignacion_banco_api_solis = App\asignacion_banco_api_solis::where('id_solicitud_remota', '=', $identificador)->first();
        $asignacion_banco_api_solis->estado = "Rechazada Remoto";
        $asignacion_banco_api_solis->timestamps = false;
        $asignacion_banco_api_solis->save();

        
        $sol_remota_rechazadas = new App\sol_remota_rechazadas;
        $sol_remota_rechazadas->id_sol_remota = $identificador;
         $sol_remota_rechazadas->fecha_rechazada = $FechaHoraActual;
         $sol_remota_rechazadas->descripcion = $request->motivorechazo;
        $sol_remota_rechazadas->timestamps = false;
        $sol_remota_rechazadas->save();

        // return back()->with('mensaje', 'Solicitud Rechazada');

        return Redirect::to('/home')->with('mensaje', 'Solicitud Rechazada');

    }

    
    public function revisarAtencionRemota( $idSolRemo)
    {

        $identificadorDescifrado = decrypt($idSolRemo);
        $dataSolicitudRemota  =   App\solicitudes_remotas::select("asignacion_banco_api_solis.solucionado","asignacion_banco_api_solis.observacion_tecnico as   observacionTecnico","banco_api_solicitudes.*","solicitudes_remotas.*","asuntos.descripcion as descripcion_asuntos")
     ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
     ->join("banco_api_solicitudes","banco_api_solicitudes.id","=","solicitudes_remotas.id_api_banco_solicitud")
     ->join("asignacion_banco_api_solis","asignacion_banco_api_solis.id_solicitud_remota","=","solicitudes_remotas.id")

     ->where('solicitudes_remotas.id', $identificadorDescifrado)
     ->get();
     $reasignacion = "no";
$estadoExternoZonas ="";
     return view('solicitudes_servicios/remote/revisar',compact('estadoExternoZonas',"reasignacion","dataSolicitudRemota","identificadorDescifrado"));

    }
    public function asignarAtencionessinergy( $idSolRemo)
    {
        $identificadorDescifrado = decrypt($idSolRemo);
        $dataSolicitudRemota  =   App\solicitudes_remotas::select("banco_api_solicitudes.*","solicitudes_remotas.*","solicitudes_remotas.id as idSolicitudRemota","asuntos.descripcion as descripcion_asuntos")
     ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
     ->join("banco_api_solicitudes","banco_api_solicitudes.id","=","solicitudes_remotas.id_api_banco_solicitud")
     ->where('solicitudes_remotas.id', $identificadorDescifrado)
     ->get();

     $trabajadoresRemotos = DB::table('personas')
     ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
     ->join('users', 'users.id', '=', 'trabajadors.id_login')
     ->where('trabajadors.estado', '=', '1')
     ->where(function ($query) {
         $query->where('users.remoto', '=', '1')
             ->orWhere('users.coord_is_remoto', '=', '1');
     })
     ->where(function ($query) {
         $query->where('users.tipo_usuario', '=', 'trabajador')
             ->orWhere('users.tipo_usuario', '=', 'externo');
     })
     ->select(
         DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) as nombre_completo"),
         'users.id'
     )
     ->get();
    

    //  $trabajadoresRemotos = DB::table('personas')
    //  ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
    //  ->join('users', 'users.id', '=', 'trabajadors.id_login')
    //  ->where('trabajadors.estado', '=', '1')
    //  ->where('users.tipo_usuario', '=', 'trabajador')
    //  ->where('users.remoto', '=', '1')
    //  ->select(
    //      DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) as nombre_completo"),
    //      'users.id'
    //  )
    //  ->get();


    //  PARA CALCULAR EL SLA

     $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")
     ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
     ->where('solicitudes_remotas.id', $identificadorDescifrado)->get();
     $solicitudes_remotas = solicitudes_remotas::where('id', '=', $identificadorDescifrado)->first();




     $getDataSla = App\sla_zonas::calcularSlaZonas($identificador,"si", $solicitudes_remotas->fecha_finalizada,$solicitudes_remotas->estado);
  $tiempoTransucurrido =    $getDataSla["tiempoTranscurrido"];
        $minutosTotales=  $getDataSla["minutosTotales"];

        $minutos_restantes =  $getDataSla["minutos_restantes"];


        return view('solicitudes_servicios/remote/asignar',compact("tiempoTransucurrido","minutosTotales","minutos_restantes","dataSolicitudRemota","trabajadoresRemotos","identificadorDescifrado"));

    }
    public function cambiartecnicoremoto($idSolRemo)
    {
        $trabajadoresRemotos = DB::table('personas')
        ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
        ->join('users', 'users.id', '=', 'trabajadors.id_login')
        ->where('trabajadors.estado', '=', '1')
        ->where(function ($query) {
            $query->where('users.remoto', '=', '1')
                ->orWhere('users.coord_is_remoto', '=', '1');
        })
        ->where(function ($query) {
            $query->where('users.tipo_usuario', '=', 'trabajador')
                ->orWhere('users.tipo_usuario', '=', 'externo');
        })
        ->select(
            DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) as nombre_completo"),
            'users.id'
        )
        ->get();
    //     $trabajadoresRemotos = DB::table('personas')
    //  ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
    //  ->join('users', 'users.id', '=', 'trabajadors.id_login')
    //  ->where('trabajadors.estado', '=', '1')
    //  ->where('users.tipo_usuario', '=', 'trabajador')
    //  ->where('users.remoto', '=', '1')
    //  ->select(
    //      DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) as nombre_completo"),
    //      'users.id'
    //  )
    //  ->get();

         return view('solicitudes_servicios/remote/reasignarremoto',compact("trabajadoresRemotos","idSolRemo"));

    }
    
        public function changetecnicoremoto(request  $req){

            try {
                $identificador = decrypt($req->idremoto);
            } catch (DecryptException $e) {
                //
                return "No Puede Realizar Esta Accion";
            }
            // return back()->with('mensaje', 'Solicitud Rechazada');

        
            $asignacion_banco_api_solis = App\asignacion_banco_api_solis::where('id_solicitud_remota', '=', $identificador)->first();
            $asignacion_banco_api_solis->id_tecnico =$req->id_trabajador;
            $asignacion_banco_api_solis->timestamps = false;
            $asignacion_banco_api_solis->save();
            return Redirect::to('/home')->with('mensaje', 'Solicitud Reasignada');
        }

        public function reasignarremotoPost( request $req)
        {

            

            $identificadorDescifrado = $req->id_solicitud_remota;
            $dataSolicitudRemota  =   App\solicitudes_remotas::select("asignacion_banco_api_solis.solucionado"
          ,"asignacion_banco_api_solis.observacion_tecnico as   observacionTecnico"
          ,"banco_api_solicitudes.*"
          ,"solicitudes_remotas.id as idSolicitudRemota"
          ,"solicitudes_remotas.*"
          ,"asuntos.descripcion as descripcion_asuntos")
         ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
         ->join("banco_api_solicitudes","banco_api_solicitudes.id","=","solicitudes_remotas.id_api_banco_solicitud")
         ->join("asignacion_banco_api_solis","asignacion_banco_api_solis.id_solicitud_remota","=","solicitudes_remotas.id")
    
         ->where('solicitudes_remotas.id', $identificadorDescifrado)
         ->get();
    
         $reasignacion = "si";
    

            $api_solicitudes = App\api_solicitudes::where('id_solicitudes_remotas', '=', $dataSolicitudRemota[0]->idSolicitudRemota)->first();

        $estadoExternoZonas = $api_solicitudes->estado_externo;
         return view('solicitudes_servicios/remote/revisar',compact("reasignacion","dataSolicitudRemota","identificadorDescifrado","estadoExternoZonas"));
    
        }
    
    
    public function reasignarremoto($idSolRemo)
    {


        $identificadorDescifrado = decrypt($idSolRemo);
        $dataSolicitudRemota  =   App\solicitudes_remotas::select("asignacion_banco_api_solis.solucionado"
      ,"asignacion_banco_api_solis.observacion_tecnico as   observacionTecnico"
      ,"banco_api_solicitudes.*"
      ,"solicitudes_remotas.*"
      ,"asuntos.descripcion as descripcion_asuntos")
     ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
     ->join("banco_api_solicitudes","banco_api_solicitudes.id","=","solicitudes_remotas.id_api_banco_solicitud")
     ->join("asignacion_banco_api_solis","asignacion_banco_api_solis.id_solicitud_remota","=","solicitudes_remotas.id")

     ->where('solicitudes_remotas.id', $identificadorDescifrado)
     ->get();

     $reasignacion = "si";

     return view('solicitudes_servicios/remote/revisar',compact("reasignacion","dataSolicitudRemota","identificadorDescifrado"));


        // $trabajadoresInternos =DB::table('personas')
        // ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
        // ->join('users', 'users.id', '=', 'trabajadors.id_login')
        // ->where('trabajadors.estado', '=', '1')
        // //  ->where('users.zona', '=', Auth::user()->zona)
        // ->where('users.tipo_usuario', '=', 'trabajador')
        // ->where('users.tipo', '=', 'interno')


        // ->select(DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) as nombre_completo"),'personas.nombre_uno', 'personas.apellido_uno', 'personas.apellido_dos', 'trabajadors.id')
        // ->get();

        // return view('solicitudes_servicios/remote/reasignar',compact("trabajadoresInternos"));

    }

    public function pdfremoto()
    {


        
        $idremoto =  $_GET["idremoto"];

        $idremoto = decrypt($idremoto);


        $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")
        ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
        ->where('solicitudes_remotas.id', $idremoto)->get();

    
        $solicitudes_remotas = solicitudes_remotas::where('id', '=', $idremoto)->first();
        $banco_api_solicitudes = banco_api_solicitudes::find($solicitudes_remotas->id_api_banco_solicitud);
        $asignacion_banco_api_solis = asignacion_banco_api_solis::where('id_solicitud_remota', '=', $idremoto)->first();


        $getDataZona =  App\sla_zonas::select('horas')
        ->join("sla_des_zonas","sla_des_zonas.id","=","sla_zonas.id_tipo_zona")
        ->where("sla_des_zonas.descripcion","=",$banco_api_solicitudes->zona_geoge)
        ->where("sla_zonas.tipo","=",$banco_api_solicitudes->tipo_of_sinergy )
        ->get();
        $getDataSla = App\sla_zonas::calcularSlaZonas($identificador,"si", $solicitudes_remotas->fecha_finalizada,$solicitudes_remotas->estado);
        $tiempoTransucurrido =    $getDataSla["tiempoTranscurrido"];
        $minutosTotales=  $getDataSla["minutosTotales"];

        $minutos_restantes =  $getDataSla["minutos_restantes"];

          $solicitudesremotas = "solicitudesremotas";
          return   \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
          ->loadView('solicitudes_servicios.remote.pdfSolicitudRemota', compact('getDataZona','minutosTotales','minutos_restantes','tiempoTransucurrido','banco_api_solicitudes',"solicitudes_remotas",'asignacion_banco_api_solis'))
          ->stream("remote∂" . '.pdf');
          return Redirect::to('/home');

    }


    public function createrespuestaRemota(request $request)
    {

        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();

        // $solicitudesremotas = "solicitudesremotas";
    
      
        //  $solicitudesremotas = "solicitudesremotas";
        //  return   \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
        //  ->loadView('solicitudes_servicios.remote.pdfSolicitudRemota', compact('solicitudesremotas'))
        //  ->download("remote∂" . '.pdf');
        //  return Redirect::to('/home');


        // return $request;

        $idAsignacion = $request->idAsignacion;

        $asignacion_banco_api_solis = asignacion_banco_api_solis::where('id', '=', $idAsignacion)->first();
         $asignacion_banco_api_solis->estado = "revisar";
         $asignacion_banco_api_solis->solucionado = $request->solucionado;
         $asignacion_banco_api_solis->observacion_tecnico =  $request->quesehizo;
         $asignacion_banco_api_solis->fecha_respuesta =  $FechaHoraActual;
        $asignacion_banco_api_solis->timestamps = false;
        $asignacion_banco_api_solis->save();


        $solicitudes_remotas = solicitudes_remotas::where('id', '=', $asignacion_banco_api_solis->id_solicitud_remota)->first();
        $solicitudes_remotas->estado = "revisar";
        $solicitudes_remotas->timestamps = false;
        $solicitudes_remotas->save();

        $api_solicitudes = App\api_solicitudes::where('id_solicitudes_remotas', '=', $asignacion_banco_api_solis->id_solicitud_remota)->first();
        $api_solicitudes->estado_interno = "REVISAR REMOTO";
        if(strtoupper($request->solucionado) === "SI" ){

        $api_solicitudes->fecha_finalizada_tecnico = $FechaHoraActual;
    }

        $api_solicitudes->estado_externo = "REVISAR REMOTO";
        $api_solicitudes->timestamps = false;
        $api_solicitudes->save();

        $datosAdicionales = [
            'idSolicitudRemota' => $asignacion_banco_api_solis->id_solicitud_remota,
            
        ];
        return redirect()->route('home')->with('redireccionar', encrypt($solicitudes_remotas->id));


        return Redirect::to('/home');


            return $request->idAsignacion;
    }

    public function createAtencionessinergy(request $request)
    {

        return DB::transaction(function () use ($request) {


        $FechaHoraActual  = Carbon::now();
        $FechaHoraActual = $FechaHoraActual->toDateTimeString();
        $id_tecnico_remoto = $request->id_tecnico_remoto;
        $identificadorDescifrado = $request->identificadorDescifrado;

           $solicitudes_remotas = solicitudes_remotas::where('id', '=', $identificadorDescifrado)->first();

           $id_api_banco_solicitud = $solicitudes_remotas->id_api_banco_solicitud;





            $banco_api_solicitudes = banco_api_solicitudes::find($id_api_banco_solicitud);

            $check_banco_api_solicitudes = new App\check_banco_api_solicitudes;
            $check_banco_api_solicitudes->nId_OT = $banco_api_solicitudes->nId_OT;
            $check_banco_api_solicitudes->sSC = $banco_api_solicitudes->sSC;
            $check_banco_api_solicitudes->sProveedor = $banco_api_solicitudes->sProveedor;
            $check_banco_api_solicitudes->sPrioridad = $banco_api_solicitudes->sPrioridad;
            $check_banco_api_solicitudes->dFecha = $banco_api_solicitudes->dFecha;
            $check_banco_api_solicitudes->sCliente = $banco_api_solicitudes->sCliente;
            $check_banco_api_solicitudes->sTelefono = $banco_api_solicitudes->sTelefono;
            $check_banco_api_solicitudes->sContacto = $banco_api_solicitudes->sContacto;
            $check_banco_api_solicitudes->sDireccion = $banco_api_solicitudes->sDireccion;
            $check_banco_api_solicitudes->sComuna = $banco_api_solicitudes->sComuna;
            $check_banco_api_solicitudes->sRegion = $banco_api_solicitudes->sRegion;
            $check_banco_api_solicitudes->sTipoLlamada = $banco_api_solicitudes->sTipoLlamada;
            $check_banco_api_solicitudes->sDescripcion = $banco_api_solicitudes->sDescripcion;
            $check_banco_api_solicitudes->sQR = $banco_api_solicitudes->sQR;
            $check_banco_api_solicitudes->sSerie = $banco_api_solicitudes->sSerie;
            $check_banco_api_solicitudes->sModelo = $banco_api_solicitudes->sModelo;
            $check_banco_api_solicitudes->sUbicacion = $banco_api_solicitudes->sUbicacion;
            $check_banco_api_solicitudes->sTelefono = $banco_api_solicitudes->sTelefono;
            $check_banco_api_solicitudes->sTipoContrato = $banco_api_solicitudes->sTipoContrato;
            $check_banco_api_solicitudes->nId_EstadoOT = $banco_api_solicitudes->nId_EstadoOT;
            $check_banco_api_solicitudes->dFechaEstadoOT = $banco_api_solicitudes->dFechaEstadoOT;
            $check_banco_api_solicitudes->nId_Tecnico = $banco_api_solicitudes->nId_Tecnico;
            $check_banco_api_solicitudes->sObs = $banco_api_solicitudes->sObs;
            $check_banco_api_solicitudes->bDeleted = $banco_api_solicitudes->bDeleted;
            $check_banco_api_solicitudes->sUsuario = $banco_api_solicitudes->sUsuario;
            $check_banco_api_solicitudes->proveedor_servicio = "SYNERGY";
            $check_banco_api_solicitudes->oficina = $banco_api_solicitudes->oficina;
            
            //NUEVOS DATOS
            $check_banco_api_solicitudes->correlativo= $banco_api_solicitudes->correlativo;
            $check_banco_api_solicitudes->zona_geoge= $banco_api_solicitudes->zona_geoge;
            $check_banco_api_solicitudes->area= $banco_api_solicitudes->area;
            $check_banco_api_solicitudes->cod_of= $banco_api_solicitudes->cod_of;
            $check_banco_api_solicitudes->num_guia_despacho= $banco_api_solicitudes->num_guia_despacho;
            $check_banco_api_solicitudes->departamento= $banco_api_solicitudes->departamento;
            $check_banco_api_solicitudes->tipo_of_sinergy= $banco_api_solicitudes->tipo_of_sinergy;
            $check_banco_api_solicitudes->sla_hrs= $banco_api_solicitudes->sla_hrs;
            $check_banco_api_solicitudes->Fdesp_r= $banco_api_solicitudes->Fdesp_r;
            $check_banco_api_solicitudes->Fhab_r= $banco_api_solicitudes->Fhab_r;
            $check_banco_api_solicitudes->telefono_contacto= $banco_api_solicitudes->telefono_contacto;
            $check_banco_api_solicitudes->email_contacto= $banco_api_solicitudes->email_contacto;
            $check_banco_api_solicitudes->sPiso= $banco_api_solicitudes->sPiso;
            $check_banco_api_solicitudes->sCiudad= $banco_api_solicitudes->sCiudad;
            $check_banco_api_solicitudes->sEstado_despacho= $banco_api_solicitudes->sEstado_despacho;
            $check_banco_api_solicitudes->Smarca= $banco_api_solicitudes->Smarca;
            $check_banco_api_solicitudes->sIP= $banco_api_solicitudes->sIP;
            $check_banco_api_solicitudes->timestamps = false;
            $check_banco_api_solicitudes->save();
      ////////

           $asignacion_banco_api_solis = new App\asignacion_banco_api_solis;
           $asignacion_banco_api_solis->fecha_asignado = $FechaHoraActual;
           $asignacion_banco_api_solis->id_tecnico = $id_tecnico_remoto;
           $asignacion_banco_api_solis->estado = "asignado_remoto";
        //    $asignacion_banco_api_solis->id_banco_informacion = $id_api_banco_solicitud;
           $asignacion_banco_api_solis->id_check_banco_info = $check_banco_api_solicitudes->id;
           $asignacion_banco_api_solis->id_solicitud_remota = $identificadorDescifrado;
           $asignacion_banco_api_solis->timestamps = false;
           $asignacion_banco_api_solis->save();


           $api_solicitudes = App\api_solicitudes::where('id_solicitudes_remotas', '=', $identificadorDescifrado)->first();
           $api_solicitudes->estado_interno = "ASIGNADO REMOTO";
           $api_solicitudes->estado_externo = "ASIGNADO REMOTO";
           $api_solicitudes->timestamps = false;
           $api_solicitudes->save();


           $solicitudes_remotas = solicitudes_remotas::where('id', '=', $identificadorDescifrado)->first();
           $solicitudes_remotas->estado = "asignado";

           $solicitudes_remotas->timestamps = false;
           $solicitudes_remotas->save();

        // asignacion_banco_api_solis
        // check_banco_api_solicitudes


        return Redirect::to('/home');

        return view('home');


       return "asignado";
    }, 5);

    }



//KYOCERA
public function filtro_porrevisar_kyocera(request $request)
{

    $cliente = $request->cliente;
    $tipo = $request->tipo_a;
    $tecnico = $request->tecnico;
    $proveedor_por_rev = $request->proveedor_por_rev;


    //$databases = $this->nombre_database();
            $databases = App\bd_proveedores::selectDB();


    $where  = 'asignacion_instalacions.estado_asignacion = ' . '"' . 'revisar' . '" and instalacions.sEstado_instalacion = ' . '"' . 'revisar' . '" ';
    $where_r  = 'asignacion_retiros.estado_asignacion = ' . '"' . 'revisar' . '"';

    if ($cliente != "" || $cliente != null) {
        $where = $where . ' and clientes.id = ' . $cliente;
        $where_r = $where_r . ' and clientes.id = ' . $cliente;
    }
    if ($tipo != "" || $tipo != null) {
        $where = $where . ' and asignacion_instalacions.tipo = ' . '"' . $tipo . '"';
        $where_r = $where_r . ' and asignacion_retiros.tipo = ' . '"' . $tipo . '"';
    }
    if ($tecnico != "" || $tecnico != null) {
        $where = $where . ' and  asignacion_instalacions.trabajadors_id = ' . $tecnico;
        $where_r = $where_r . ' and  asignacion_retiros.trabajadors_idtecnico = ' . $tecnico;
    }

    if ($proveedor_por_rev != "" || $proveedor_por_rev != null) {
        $where = $where . ' and  instalacions.proveedor_instalacion = ' . '"' . $proveedor_por_rev . '"';
        $where_r = $where_r . ' and  retiros.proveedor_retiro = ' . '"' . $proveedor_por_rev . '"';
    }

    $where = $where . ' and  checklist_instalacions.Cscliente = ' . '"' . "kyocera" . '"';
        $where_r = $where_r . ' and  checklist_retiros.Cscliente = ' . '"' . "kyocera" . '"';

    foreach ($databases as $los_datos) {
        $datos_asignacion[] = DB::connection(strtolower($los_datos->Database))->select(
            'SELECT
            checklist_retiros.csSerie as serie,
            checklist_retiros.fecha_inicio as fecha,
            checklist_retiros.csComuna as comuna,
            checklist_retiros.csRegion as region,
            checklist_retiros.Cscliente as cliente,
            asignacion_retiros.tipo,
            asignacion_retiros.id,
            retiros.proveedor_retiro as proveedor,
            personas.nombre_uno,
            personas.apellido_uno,
            asignacion_retiros.fecha_asignado,
            null as tipo_instalacion,
            null as razonSocial
        FROM
            asignacion_retiros
        INNER JOIN
            checklist_retiros on checklist_retiros.asignacion_retiros_id = asignacion_retiros.id
        INNER JOIN
            retiros on retiros.id = asignacion_retiros.retiros_id
        INNER JOIN
            trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
        INNER JOIN
            personas on personas.id = trabajadors.id_persona
        LEFT JOIN
            tracker on tracker.id = retiros.tracker_id
        LEFT JOIN
            proyectos on proyectos.id = tracker.proyecto_id
        LEFT JOIN
            clientes on clientes.id = proyectos.clientes_id
        WHERE ' . $where_r  .
                ' union ' .
                'SELECT
            checklist_instalacions.CsSerie as serie,
            checklist_instalacions.fecha_inicio as fecha,
            checklist_instalacions.Cscomuna as comuna,
            checklist_instalacions.Csregion as region,
            checklist_instalacions.Cscliente as cliente,
            asignacion_instalacions.tipo,
            asignacion_instalacions.id,
            instalacions.proveedor_instalacion as proveedor,
            personas.nombre_uno,
            personas.apellido_uno,
            asignacion_instalacions.fecha_asignado,
            instalacions.tipo as tipo_instalacion,
            instalacions.razonSocial
        FROM
            asignacion_instalacions
        INNER JOIN
            checklist_instalacions on checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id
        INNER JOIN
            instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
        INNER JOIN
            trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
        INNER JOIN
            personas on personas.id = trabajadors.id_persona
        LEFT JOIN
            tracker on tracker.id = instalacions.tracker_idtracker
        LEFT JOIN
            proyectos on proyectos.id = tracker.proyecto_id
        LEFT JOIN
            clientes on clientes.id = proyectos.clientes_id
        WHERE ' . $where
        );
    }
    $table = "";
    for ($i = 0; $i < count($datos_asignacion); $i++) {
        foreach ($datos_asignacion[$i] as $d1) {
            $fecha = Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s');
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $d1->tipo_instalacion . "</td>";

            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->razonSocial . "</td>";

            $table .= "<td>" . $d1->serie . "</td>";
                            $table .= "<td>" . $d1->proveedor . "</td>";

            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                    <div class="dropdown dropleft">
                        <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                            <span class="material-icons">more_vert</span>
                        </button>
                        <div class="dropdown-menu mostrar shadow">
                            <div class="d-flex justify-content-around">
                                <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                    <input type="hidden" value="' . $d1->id . '" name="id">
                                    <button class="btn">
                                        <span class="material-icons-round">
                                            visibility
                                        </span>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div
                </td>';
            } else {
                $table .=
                    '<td>
                    <div class="dropdown dropleft">
                        <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                            <span class="material-icons">more_vert</span>
                        </button>
                        <div class="dropdown-menu mostrar shadow">
                            <div class="d-flex justify-content-around">
                                <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                    <input type="hidden" value="' . $d1->id . '" name="id">
                                    <button class="btn">
                                        <span class="material-icons-round">
                                            visibility
                                        </span>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div
                </td>';
            }
            $table .= "</tr>";
        }
    }
    return $table;
}
public function revisar_porrevisar_coordinador_kyocera()
    {

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        //ESTADO ENCURSO
        foreach ($databases as $los_datos) {
            $retiros_encurso = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->select(
                    'checklist_retiros.csSerie as serie',
                    'checklist_retiros.fecha_inicio as fecha',
                    'checklist_retiros.csComuna as comuna',
                    'checklist_retiros.csRegion as region',
                    'checklist_retiros.Cscliente as cliente',
                    'asignacion_retiros.tipo',
                    'asignacion_retiros.id',
                    'retiros.proveedor_retiro as proveedor',
                    'retiros.id as id_historial',
                    'personas.nombre_uno',
                    'personas.apellido_uno',
                    'asignacion_retiros.fecha_asignado',
                    DB::raw('null as tipo_instalacion'),
                    DB::raw('null as razonSocial')
                )
                ->where('checklist_retiros.Cscliente', '=', 'kyocera')

                ->where('asignacion_retiros.estado_asignacion', '=', 'revisar');
            // ->where('checklist_retiros.estado_inicio', '=', 'revisar');
            $instalacion_encurso[]  = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->select(
                    'checklist_instalacions.CsSerie as serie',
                    'checklist_instalacions.fecha_inicio as fecha',
                    'checklist_instalacions.Cscomuna as comuna',
                    'checklist_instalacions.Csregion as region',
                    'checklist_instalacions.Cscliente as cliente',
                    'asignacion_instalacions.tipo',
                    'asignacion_instalacions.id',
                    'instalacions.proveedor_instalacion as proveedor',
                    'instalacions.id as id_historial',
                    'personas.nombre_uno',
                    'personas.apellido_uno',
                    'asignacion_instalacions.fecha_asignado',
                    'instalacions.tipo as tipo_instalacion',
                     'instalacions.razonSocial'
                )
                ->where('checklist_instalacions.Cscliente', '=', 'kyocera')

                ->where('asignacion_instalacions.estado_asignacion', '=', 'revisar')
                ->where('instalacions.sEstado_instalacion', '=', 'revisar')
                ->union($retiros_encurso)
                ->get();
        }
        $table = "";
        $num_r = "";
        $num_i = "";
        for ($i = 0; $i < count($instalacion_encurso); $i++) {
            foreach ($instalacion_encurso[$i]  as $d1) {
                // if ($d1->proveedor == "comtecglobal") {
                //     $num_i = 1;
                // }
                // if ($d1->proveedor == "kyocera") {
                //     $num_r = 1;
                //     $num_i = 2;
                // }
                // if ($d1->proveedor == "upgrade") {
                //     $num_i = 3;
                // }
                $num_i = $d1->proveedor;
                $num_r = $d1->proveedor;
                $fecha = Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s');
                $table .= "<tr>";
                $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
                $table .= "<td>" . $fecha . "</td>";
                $table .= "<td>" . $d1->tipo_instalacion . "</td>";
                $table .= "<td>" . $d1->cliente . "</td>";
                $table .= "<td>" . $d1->razonSocial . "</td>";
                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";


                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                    <a role="button" title="Historial" onclick="historial_retiro(' . $d1->id_historial . ',' ."'". $num_r . "'".');" class="btn ver_historial_instalacion_home">
                                        <span class="material-icons">history</span>
                                    </a>
                                </div>
                            </div>
                        </div
                    </td>';
                } else {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                    <a role="button" title="Historial" onclick="historial_instalacion(' . $d1->id_historial . ',' ."'". $num_i . "'".');" class="btn ver_historial_instalacion_home">
                                    <span class="material-icons">history</span>
                                </a>
                                </div>
                            </div>
                        </div
                    </td>';
                }
                $table .= "</tr>";
            }
        }
        return $table;
    }
public function filtro_porasignar_kyocera(request $request)
{
    //$databases = $this->nombre_database();
            $databases = App\bd_proveedores::selectDB();

    $cliente = $request->cliente;
    $tipo = $request->tipo_a;
    $proveedor_ap_asig = $request->proveedor_ap_asig;

    $where  = 'instalacions.sEstado_instalacion like ' . '"%' . 'Por asignar' . '%"';
    $where_r  = 'retiros.estado_retiro_Cord = ' . '"' . 'Por asignar' . '"';

    if ($cliente != "" || $cliente != null) {
        $where = $where . ' and instalacions.sCliente = ' . '"' . $cliente . '"';
        $where_r = $where_r . ' and retiros.sCliente = ' . '"' . $cliente . '"';
    }
    if ($tipo != "" || $tipo != null) {
        $where = $where . ' and tracker.tipo_tracker = ' . '"' . $tipo . '"';
        $where_r = $where_r . ' and tracker.tipo_tracker = ' . '"' . $tipo . '"';
    }
    if ($proveedor_ap_asig != "" || $proveedor_ap_asig != null) {
        $where = $where . ' and instalacions.proveedor_instalacion = ' . '"' . $proveedor_ap_asig . '"';
        $where_r = $where_r . ' and retiros.proveedor_retiro = ' . '"' . $proveedor_ap_asig . '"';
    }
    foreach ($databases as $los_datos) {
        $datos_asignacion[] = DB::connection(strtolower($los_datos->Database))->select(
            'SELECT
            retiros.proveedor_retiro as proveedor,
            tracker.tipo_tracker as tipo,
            retiros.sCliente as cliente,
            retiros.sRegion,
            retiros.sComuna,
            retiros.sSerie,
            retiros.id,
            null as tipo_instalacion,
            null as razonSocial

            FROM
                retiros
            INNER JOIN
                tracker on tracker.id = retiros.tracker_id
            WHERE ' . $where_r  .
                ' union ' .
                'SELECT
            instalacions.proveedor_instalacion as proveedor,
            tracker.tipo_tracker as tipo,
            instalacions.sCliente as cliente,
            instalacions.sRegion,
            instalacions.sComuna,
            instalacions.sSerie,
            instalacions.id,
            instalacions.tipo as tipo_instalacion,
            instalacions.razonSocial

            FROM
                instalacions
            INNER JOIN
                tracker on tracker.id = instalacions.tracker_idtracker
            WHERE ' . $where
        );
    }
    $table = "";
    for ($i = 0; $i < count($datos_asignacion); $i++) {
        foreach ($datos_asignacion[$i] as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $d1->proveedor . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "<td>" . $d1->tipo_instalacion . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->razonSocial . "</td>";
            $table .= "<td>" . $d1->sRegion . "</td>";
            $table .= "<td>" . $d1->sComuna . "</td>";
            $table .= "<td>" . $d1->sSerie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                    <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" class="btn">Asignar</button>
                    </form>
                </td>';
            } else {
                $table .=
                    '<td>
                <form action="' . route('go.asignar_check_home') . '" method="GET">
                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                    <input type="hidden" value="' . $d1->id . '" name="id">
                    <button type="submit" class="btn">Asignar</button>
                </form>
            </td>';
            }
            $table .= "</tr>";
        }
    }
    return $table;
}
public function revisar_porasignar_kyocera()
{
    $retiros_comtecglobal_pendientes = DB::connection('comtecglobal')->table('retiros')
        ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
        ->select(
            'retiros.proveedor_retiro as proveedor',
            'tracker.tipo_tracker as tipo',
            'retiros.sCliente as cliente',
            'retiros.sRegion',
            'retiros.sComuna',
            'retiros.sSerie',
            'retiros.id',
            DB::raw('null as tipo_instalacion'),
            DB::raw('null as razonSocial'),


        )
        ->where('retiros.sCliente', '=', 'kyocera')
        ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
    $instalacion_comtecglobal_pendientes = DB::connection('comtecglobal')->table('instalacions')
        ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
        ->select(
            'instalacions.proveedor_instalacion as proveedor',
            'tracker.tipo_tracker as tipo',
            'instalacions.sCliente as cliente',
            'instalacions.sRegion',
            'instalacions.sComuna',
            'instalacions.sSerie',
            'instalacions.id',
            'instalacions.tipo as tipo_instalacion',
            'instalacions.razonSocial'
        )
        ->where('instalacions.sCliente', '=', 'kyocera')

        ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
        ->union($retiros_comtecglobal_pendientes)
        ->get();
    $retiros_kyocera_pendientes = DB::connection('kyocera')->table('retiros')
        ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
        ->select(
            'retiros.proveedor_retiro as proveedor',
            'tracker.tipo_tracker as tipo',
            'retiros.sCliente as cliente',
            'retiros.sRegion',
            'retiros.sComuna',
            'retiros.sSerie',
            'retiros.id',
            DB::raw('null as tipo_instalacion'),
            DB::raw('null as razonSocial')
        )
        ->where('retiros.sCliente', '=', 'kyocera')

        ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
    $instalacion_kyocera_pendientes = DB::connection('kyocera')->table('instalacions')
        ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
        ->select(
            'instalacions.proveedor_instalacion as proveedor',
            'tracker.tipo_tracker as tipo',
            'instalacions.sCliente as cliente',
            'instalacions.sRegion',
            'instalacions.sComuna',
            'instalacions.sSerie',
            'instalacions.id',
            'instalacions.tipo as tipo_instalacion',
            'instalacions.razonSocial'

        )
        ->where('instalacions.sCliente', '=', 'kyocera')

        ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
        ->union($retiros_kyocera_pendientes)
        ->get();

    $retiros_upgrade_pendientes = DB::connection('upgrade')->table('retiros')
        ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
        ->select(
            'retiros.proveedor_retiro as proveedor',
            'tracker.tipo_tracker as tipo',
            'retiros.sCliente as cliente',
            'retiros.sRegion',
            'retiros.sComuna',
            'retiros.sSerie',
            'retiros.id',
            DB::raw('null as tipo_instalacion'),
            DB::raw('null as razonSocial'),
        )
        ->where('retiros.sCliente', '=', 'kyocera')

        ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
    $instalacion_upgrade_pendientes = DB::connection('upgrade')->table('instalacions')
        ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
        ->select(
            'instalacions.proveedor_instalacion as proveedor',
            'tracker.tipo_tracker as tipo',
            'instalacions.sCliente as cliente',
            'instalacions.sRegion',
            'instalacions.sComuna',
            'instalacions.sSerie',
            'instalacions.id',
            'instalacions.tipo as tipo_instalacion',
            'instalacions.razonSocial'
        )
        ->where('instalacions.sCliente', '=', 'kyocera')

        ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
        ->union($retiros_upgrade_pendientes)
        ->get();

    $table = "";
    foreach ($instalacion_comtecglobal_pendientes as $d1) {
        $table .= "<tr>";
        $table .= "<td>"  . $d1->proveedor . "</td>";
        $table .= "<td>"  . $d1->tipo . "</td>";
        $table .= "<td>"  . $d1->cliente . "</td>";
        $table .= "<td>"  . $d1->sRegion . "</td>";
        $table .= "<td>"  . $d1->sComuna . "</td>";
        $table .= "<td>"  . $d1->sSerie . "</td>";
        if ($d1->tipo == "retiro") {
            $table .=
                '<td>
                    <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" class="btn">Asignar</button>
                    </form>
                </td>';
        } else {
            $table .=
                '<td>
                <form action="' . route('go.asignar_check_home') . '" method="GET">
                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                    <input type="hidden" value="' . $d1->id . '" name="id">
                    <button type="submit" class="btn">Asignar</button>
                </form>
            </td>';
        }
        $table .= "</tr>";
    }
    foreach ($instalacion_kyocera_pendientes as $d1) {
        $table .= "<tr>";
        $table .= "<td>" . $d1->proveedor . "</td>";
        $table .= "<td>"  . $d1->tipo . "</td>";
        $table .= "<td>"  . $d1->tipo_instalacion . "</td>";
        $table .= "<td>"  . $d1->cliente . "</td>";
        $table .= "<td>"  . $d1->razonSocial . "</td>";
        $table .= "<td>"  . $d1->sRegion . "</td>";
        $table .= "<td>"  . $d1->sComuna . "</td>";
        $table .= "<td>"  . $d1->sSerie . "</td>";
        if ($d1->tipo == "retiro") {
            $table .=
                '<td>
                    <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" class="btn">Asignar</button>
                    </form>
                </td>';
        } else {
            $table .=
                '<td>
                <form action="' . route('go.asignar_check_home') . '" method="GET">
                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                    <input type="hidden" value="' . $d1->id . '" name="id">
                    <button type="submit" class="btn">Asignar</button>
                </form>
            </td>';
        }
        $table .= "</tr>";
    }
    foreach ($instalacion_upgrade_pendientes as $d1) {
        $table .= "<tr>";
        $table .= "<td>" . $d1->proveedor . "</td>";
        $table .= "<td>"  . $d1->tipo . "</td>";
        $table .= "<td>"  . $d1->cliente . "</td>";
        $table .= "<td>"  . $d1->sRegion . "</td>";
        $table .= "<td>"  . $d1->sComuna . "</td>";
        $table .= "<td>"  . $d1->sSerie . "</td>";
        if ($d1->tipo == "retiro") {
            $table .=
                '<td>
                    <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" class="btn">Asignar</button>
                    </form>
                </td>';
        } else {
            $table .=
                '<td>
                <form action="' . route('go.asignar_check_home') . '" method="GET">
                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                    <input type="hidden" value="' . $d1->id . '" name="id">
                    <button type="submit" class="btn">Asignar</button>
                </form>
            </td>';
        }
        $table .= "</tr>";
    }
    return $table;
}


public function revisar_pendientes_coordinador_kyocera()
{
    //$databases = $this->nombre_database();
            $databases = App\bd_proveedores::selectDB();


    foreach ($databases as $los_datos) {
        //ESTADO PENDIENTE PARA TECNICO
        $retiros_pendientes = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'retiros.id as id_historial',
                'retiros.fecha_retiroCord as fecha',
                'personas.nombre_uno',
                'personas.apellido_uno',
                DB::raw('null as tipo_instalacion'),
                DB::raw('null as razonSocial')

            )
            ->where('checklist_retiros.Cscliente', '=', 'kyocera')

            ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_retiros.estado_inicio', '=', null)->groupBy('checklist_retiros.CsSerie');
        $instalacion_pendientes[] = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'instalacions.id as id_historial',
                'instalacions.fecha_instalacion_coordinadora as fecha',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'instalacions.tipo as tipo_instalacion',
                'instalacions.razonSocial'

            )
            ->where('checklist_instalacions.Cscliente', '=', 'kyocera')

            ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
            ->where('checklist_instalacions.estado_inicio', '=', null)->groupBy('checklist_instalacions.CsSerie')

            ->union($retiros_pendientes)
            ->get();
    }
    $table = "";
    $num_r = "";
    $num_i = "";
    for ($i = 0; $i < count($instalacion_pendientes); $i++) {
        foreach ($instalacion_pendientes[$i] as $d1) {
            // if ($d1->proveedor == "comtecglobal" || $d1->proveedor == "COMTECGLOBAL") {
            //     $num_i = 1;
            // }
            // if ($d1->proveedor == "kyocera") {
            //     $num_r = 1;
            //     $num_i = 2;
            // }
            // if ($d1->proveedor == "upgrade") {
            //     $num_i = 3;
            // }

            $num_i = $d1->proveedor;
                $num_r = $d1->proveedor;
            if ($d1->fecha != "") {
                $fecha = Carbon::createFromDate($d1->fecha)->format('d-m-Y');
            } else {
                $fecha = "NO REGISTRA";
            }
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "<td>" . $d1->tipo_instalacion . "</td>";


            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->razonSocial . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            $table .= "<td>" . $d1->proveedor . "</td>";

            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                    <div class="dropdown dropleft">
                        <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                            <span class="material-icons">more_vert</span>
                        </button>
                        <div class="dropdown-menu mostrar shadow">
                            <div class="d-flex justify-content-around">
                                <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                    <input type="hidden" value="' . $d1->id . '" name="id">
                                    <button class="btn">
                                        <span class="material-icons-round">
                                            visibility
                                        </span>
                                    </button>
                                </form>
                                <a role="button" title="Historial" onclick="historial_retiro(' . $d1->id_historial . ',' ."'".$num_r . "'".');" class="btn ver_historial_instalacion_home">
                                    <span class="material-icons">history</span>
                                </a>
                            </div>
                        </div>
                    </div
                </td>';
            } else {
                $table .=
                    '<td>
                    <div class="dropdown dropleft">
                        <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                            <span class="material-icons">more_vert</span>
                        </button>
                        <div class="dropdown-menu mostrar shadow">
                            <div class="d-flex justify-content-around">
                                <form action="' . route('go.finalizamanual_home') . '" method="GET">
                                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                    <input type="hidden" value="' . $d1->id . '" name="id">
                                    <button class="btn">
                                        <span class="material-icons-round">
                                            check_circle_outline
                                        </span>
                                    </button>
                                </form>
                                <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                    <input type="hidden" value="' . $d1->id . '" name="id">
                                    <button class="btn">
                                        <span class="material-icons-round">
                                            visibility
                                        </span>
                                    </button>
                                </form>
                                <a role="button" title="Historial" onclick="historial_instalacion(' . $d1->id_historial . ',' ."'". $num_i . "'".');" class="btn ver_historial_instalacion_home">
                                    <span class="material-icons">history</span>
                                </a>
                            </div>
                        </div>
                    </div
                </td>';
            }
            $table .= "</tr>";
        }
    }
    return $table;
}

public function filtro_pendiente_kyocera(request $request)
{
    //$tables = DB::select('SHOW DATABASES');
    //return ($tables);
    $cliente = $request->cliente;
    $tipo = $request->tipo_a;
    $tecnico = $request->tecnico;
    $proveedor_ap = $request->proveedor_ap;

    $where  = 'asignacion_instalacions.estado_asignacion = ' . '"' . 'tarea_asignada' . '"';
     $where = $where . ' and instalacions.sEstado_instalacion = ' . '"' . 'asignado' . '"';

    $where_r  = 'asignacion_retiros.estado_asignacion = ' . '"' . 'tarea_asignada' . '"';
     $where_r = $where_r . ' and retiros.estado_retiro_Cord = ' . '"' . 'asignado' . '"';

    if ($cliente != "" || $cliente != null) {
        $where = $where . ' and clientes.id = ' . $cliente;
        $where_r = $where_r . ' and clientes.id = ' . $cliente;
    }
    if ($tipo != "" || $tipo != null) {
        $where = $where . ' and asignacion_instalacions.tipo = ' . '"' . $tipo . '"';
        $where_r = $where_r . ' and asignacion_retiros.tipo = ' . '"' . $tipo . '"';
    }
    if ($tecnico != "" || $tecnico != null) {
        $where = $where . ' and  asignacion_instalacions.trabajadors_id = ' . $tecnico;
        $where_r = $where_r . ' and  asignacion_retiros.trabajadors_idtecnico = ' . $tecnico;
    }
    if ($proveedor_ap != "" || $proveedor_ap != null) {
        $where = $where . ' and  instalacions.proveedor_instalacion = ' .'"' . $proveedor_ap . '"';
        $where_r = $where_r . ' and  retiros.proveedor_retiro = ' .'"' . $proveedor_ap . '"';
    }

    $where = $where . ' and  checklist_instalacions.Cscliente = ' .'"' . "kyocera" . '"';
    $where_r = $where_r . ' and  checklist_retiros.Cscliente = ' .'"' . "kyocera" . '"';

    //$databases = $this->nombre_database();
            $databases = App\bd_proveedores::selectDB();


    foreach ($databases as $los_datos) {
        $datos_asignacion[] = DB::connection(strtolower($los_datos->Database))->select(
            'SELECT
            checklist_retiros.csSerie as serie,
            checklist_retiros.csComuna as comuna,
            checklist_retiros.csRegion as region,
            checklist_retiros.Cscliente as cliente,
            asignacion_retiros.tipo,
            asignacion_retiros.id,
            retiros.proveedor_retiro as proveedor,
            retiros.id as id_historial,
            personas.nombre_uno,
            personas.apellido_uno,
            retiros.fecha_retiroCord as fecha,
            null as tipo_instalacion,
            null as razonSocial

        FROM
            asignacion_retiros
        INNER JOIN
            checklist_retiros on checklist_retiros.asignacion_retiros_id = asignacion_retiros.id
        INNER JOIN
            retiros on retiros.id = asignacion_retiros.retiros_id
        INNER JOIN
            trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
        INNER JOIN
            personas on personas.id = trabajadors.id_persona
        LEFT JOIN
            tracker on tracker.id = retiros.tracker_id
        LEFT JOIN
            proyectos on proyectos.id = tracker.proyecto_id
        LEFT JOIN
            clientes on clientes.id = proyectos.clientes_id
        WHERE ' . $where_r  .
                ' union ' .
                'SELECT
            checklist_instalacions.CsSerie as serie,
            checklist_instalacions.Cscomuna as comuna,
            checklist_instalacions.Csregion as region,
            checklist_instalacions.Cscliente as cliente,
            asignacion_instalacions.tipo,
            asignacion_instalacions.id,
            instalacions.proveedor_instalacion as proveedor,
            instalacions.id as id_historial,
            personas.nombre_uno,
            personas.apellido_uno,
            instalacions.fecha_instalacion_coordinadora as fecha,
            instalacions.tipo as tipo_instalacion,
            instalacions.razonSocial

        FROM
            asignacion_instalacions
        INNER JOIN
            checklist_instalacions on checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id
        INNER JOIN
            instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
        INNER JOIN
            trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
        INNER JOIN
            personas on personas.id = trabajadors.id_persona
        LEFT JOIN
            tracker on tracker.id = instalacions.tracker_idtracker
        LEFT JOIN
            proyectos on proyectos.id = tracker.proyecto_id
        LEFT JOIN
            clientes on clientes.id = proyectos.clientes_id
        WHERE ' . $where
        );
    }

    $table = "";
    $num_r = "";
    $num_i = "";
    for ($i = 0; $i < count($datos_asignacion); $i++) {
        foreach ($datos_asignacion[$i] as $d1) {
            // if ($d1->proveedor == "comtecglobal") {
            //     $num_i = 1;
            // }
            // if ($d1->proveedor == "kyocera") {
            //     $num_r = 1;
            //     $num_i = 2;
            // }
            // if ($d1->proveedor == "upgrade") {
            //     $num_i = 3;
            // }
            $num_i = $d1->proveedor;
                $num_r = $d1->proveedor;
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" .Carbon::createFromDate($d1->fecha)->format('d-m-Y'). "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
                $table .= "<td>" . $d1->tipo_instalacion . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
             $table .= "<td>" . $d1->razonSocial . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            $table .= "<td>" . $d1->proveedor . "</td>";

            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                    <div class="dropdown dropleft">
                        <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                            <span class="material-icons">more_vert</span>
                        </button>
                        <div class="dropdown-menu mostrar shadow">
                            <div class="d-flex justify-content-around">
                                <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                    <input type="hidden" value="' . $d1->id . '" name="id">
                                    <button class="btn">
                                        <span class="material-icons-round">
                                            visibility
                                        </span>
                                    </button>
                                </form>
                                <a role="button" title="Historial" onclick="historial_retiro(' . $d1->id_historial . ',' ."'". $num_r ."'". ');" class="btn ver_historial_instalacion_home">
                                    <span class="material-icons">history</span>
                                </a>
                            </div>
                        </div>
                    </div
                </td>';
            } else {
                $table .=
                    '<td>
                    <div class="dropdown dropleft">
                        <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                            <span class="material-icons">more_vert</span>
                        </button>
                        <div class="dropdown-menu mostrar shadow">
                            <div class="d-flex justify-content-around">
                                <form action="' . route('go.finalizamanual_home') . '" method="GET">
                                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                    <input type="hidden" value="' . $d1->id . '" name="id">
                                    <button class="btn">
                                        <span class="material-icons-round">
                                            check_circle_outline
                                        </span>
                                    </button>
                                </form>
                                <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                    <input type="hidden" value="' . $d1->id . '" name="id">
                                    <button class="btn">
                                        <span class="material-icons-round">
                                            visibility
                                        </span>
                                    </button>
                                </form>
                                <a role="button" title="Historial" onclick="historial_instalacion(' . $d1->id_historial . ',' . "'".$num_i ."'". ');" class="btn ver_historial_instalacion_home">
                                    <span class="material-icons">history</span>
                                </a>
                            </div>
                        </div>
                    </div
                </td>';
            }
            $table .= "</tr>";
        }
    }
    return $table;
}

//////////////////

     public function guardarsla(){

        $sla = $_GET["sla_v"];
        $slas_v = $_GET["slas_v"];
        $sla_id = $_GET["slaid"];



         $update =  App\config_usuarios::findOrfail($sla_id);
         $update->sla= $sla;
         $update->sla_santiago = $slas_v;
         $update->timestamps = false;
         $update->save();

        return  "ok";
     }

     
     public function actualizahomeremoto()
     {
        $totalAsignadas = asignacion_banco_api_solis::where("id_tecnico","=",Auth::user()->id)->where(function($query) {
            $query->where("asignacion_banco_api_solis.estado", "=", "asignado_remoto")
                  ->orWhere("asignacion_banco_api_solis.estado", "=", "Rechazada Remoto");
        })
        ->where("asignacion_banco_api_solis.id_tecnico","=",Auth::user()->id)
        ->count();;
        $totalFinalizadas = asignacion_banco_api_solis::where("id_tecnico","=",Auth::user()->id)->where("estado","=","finalizado")->count();


        $data['totalAsignadas'] = $totalAsignadas;
        $data['totalFinalizadas'] = $totalFinalizadas;

        return $data;
     }


     
     //funcion solo para coordinadores
     public function homeremote()
     {

        $usuario =  App\user::findOrfail(Auth::user()->id);
       

        $usuario->remoto = 1;
        $usuario->tipo = "remoto";
        $usuario->tipo_usuario = "trabajador";
        $usuario->timestamps = false;
        $usuario->save();
        // Redirigir a la siguiente URL
    return redirect('/home');

     }
     public function homeinterno()
     {

        $usuario =  App\user::findOrfail(Auth::user()->id);
       

        $usuario->remoto = 0;
        $usuario->tipo = "interno";
        $usuario->tipo_usuario = "trabajador";

        $usuario->timestamps = false;
        $usuario->save();
            // Redirigir a la siguiente URL
            return redirect('/home');
     }

     public function homecoordinador()
     {

        $usuario =  App\user::findOrfail(Auth::user()->id);
       

        $usuario->remoto = 0;
        $usuario->tipo = "interno";
        $usuario->tipo_usuario = "externo"; //externo, para que tome todo el menu del sistema.

        $usuario->timestamps = false;
        $usuario->save();
            // Redirigir a la siguiente URL
            return redirect('/home');
     }

     
     //fin menu solo coordinadores ///////////////////////

     public function index()
     {


//tecnico remoto
        if(Auth::user()->remoto == "1"){



          $totalAsignadas = asignacion_banco_api_solis::where("id_tecnico","=",Auth::user()->id)->where(function($query) {
            $query->where("asignacion_banco_api_solis.estado", "=", "asignado_remoto")
                  ->orWhere("asignacion_banco_api_solis.estado", "=", "Rechazada Remoto");
        })
        ->where("asignacion_banco_api_solis.id_tecnico","=",Auth::user()->id)
        ->count();

          $totalFinalizadas = asignacion_banco_api_solis::where("id_tecnico","=",Auth::user()->id)->where("estado","=","finalizado")->count();

          $asignacion_banco_api_solis = asignacion_banco_api_solis::where(function($query) {
            $query->where("asignacion_banco_api_solis.estado", "=", "asignado_remoto")
                  ->orWhere("asignacion_banco_api_solis.estado", "=", "Rechazada Remoto");
        })
        ->where("asignacion_banco_api_solis.id_tecnico","=",Auth::user()->id)
        ->get();



            return view('homeRemoto',compact("totalAsignadas","asignacion_banco_api_solis","totalFinalizadas"));

        }




         //SELECT TECNICOS
         $trabajadores = DB::table('personas')
             ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
             ->select(
                 'personas.nombre_uno',
                 'personas.apellido_uno',
                 'trabajadors.id'
             )
             ->where('trabajadors.estado', '=', '1')
             ->orderBy('personas.nombre_uno', 'ASC')
             ->get();

         $datos_trabajador = DB::table('trabajadors')
             ->where('trabajadors.id_login', '=', Auth::user()->id)
             ->get();

         if (count($datos_trabajador) != 0) {
             $id_trabajador = $datos_trabajador[0]->id;
         } else {
             $id_trabajador = 0;
         }

         //$databases = $this->nombre_database();
                 $databases = App\bd_proveedores::selectDB();

                 $datos_clientes_porasignar_servicios = array();
                 $datos_clientes_porasignar = array();
                 $datos_clientes = array();


$contadorkyoceraPendientes = 0;
         $contadorkyoceraAsignadas = 0;
         $contadorkyoceraRevisar = 0;


         /** SECCION INSTALACION - RETIRO */
         $count_pendienteCoordinador = 0;
         $count_porasignarCoordinador = 0;
         $count_cursoCoordinador = 0;
         $count_porreasignarCoordinador = 0;
         $count_porrevisarCoordinador = 0;
         $count_pendientes = 0;
         $count_curso = 0;
         $count_rechazado = 0;
         /** SECCION SERVICIO */
         $cont_pendienteCoordinador = 0;
         $cont_porasignarCoordinador = 0;
         $cont_encursoCoordinador = 0;
         $cont_porreasignarCoordinador = 0;
         $cont_porrevisarCoordinador = 0;
         $cont_instalarRepuestos = 0;

         $cont_soli_instalarRepuestos = 0;

         //SECCION PROVEEDOR
         $cont_asignadoProveedor = 0;
         $cont_asignadoservicioProveedor = 0;
         $cont_respuestoservicioProveedor = 0;
         $cont_respuestoservicioProveedorFinalizadas = 0;
         $cont_respuestoservicioProveedorAsignadas = 0;
         $finalizadas_tecnico_interno = 0;
         $rechazadas_tecnico_interno = 0;
         $finalizadas_coordinador = 0;

         $proveedor = Auth::user()->nombre_proveedor;

         //SECCION PROVEEDOR
         $cont_asignadoProveedor = 0;
         $cont_repuestosProveedor = 0;
         $cont_asignadoservicioProveedor = 0;
         $cont_respuestoservicioProveedor = 0;
         $proveedor = Auth::user()->nombre_proveedor;

// return Auth::user()->zona;

        //FINALIZADAS COORDINADOR   
        $finalizadas_coordinador   = DB::table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select('asignacion_solicitudes.id')->where("api_solicitudes.tipo_asignacion_interna","=","0")
            ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
                           ->where('api_solicitudes.estado_externo', '=', 'FINALIZADO')
                           ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
                           ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO')
                        //    ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)->count();
                        ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                            ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                        ->count();



                        //FINALIZADAS

                        if(Auth::user()->tipo == "interno"){
                            $finalizadas_tecnico_interno   = DB::table('api_solicitudes')
                            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                            ->select('asignacion_solicitudes.id')->where("api_solicitudes.tipo_asignacion_interna","=","1")
                            ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
                                        ->where('api_solicitudes.estado_externo', '=', 'FINALIZADO')
                                        ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
                                        ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO')
                                        ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)->count();

                        }else{
                            $finalizadas_tecnico_interno   = DB::table('api_solicitudes')
                            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                            ->select('asignacion_solicitudes.id')
                            ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                                ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])


                            ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
                                        ->where('api_solicitudes.estado_externo', '=', 'FINALIZADO')
                                        ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
                                        ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO')
                                        ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)->count();
                        }

        // FIN FINALIZADAS


        // RECHAZADAS

        if(Auth::user()->tipo == "interno"){
            $rechazadas_tecnico_interno   = DB::table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select('asignacion_solicitudes.id')->where("api_solicitudes.tipo_asignacion_interna","=","1")
            ->where('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                        ->where('api_solicitudes.estado_externo', '=', 'RECHAZADO')
                        ->where('asignacion_solicitudes.estado_interno', '=', 'RECHAZADO')
                        ->where('asignacion_solicitudes.estado_externo', '=', 'RECHAZADO')
                        ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)->count();

        }else{
            $rechazadas_tecnico_interno   = DB::table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select('asignacion_solicitudes.id')
            ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])


            ->where('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                        ->where('api_solicitudes.estado_externo', '=', 'RECHAZADO')
                        ->where('asignacion_solicitudes.estado_interno', '=', 'RECHAZADO')
                        ->where('asignacion_solicitudes.estado_externo', '=', 'RECHAZADO')
                        ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)->count();
        }

        // FIN RECHAZADAS

         
        //  cont_respuestoservicioProveedorAsignadas
         if ($proveedor != "") {
             $retiros_asignados_proveedor = DB::connection(strtolower($proveedor))->table('retiros')
                 ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
                 ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                 ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                 ->select('retiros.id')
                 ->where('clientes.id', '!=', 4);
             $instalacion_asignados_proveedor = DB::connection(strtolower($proveedor))->table('instalacions')
                 ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                 ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                 ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                 ->select('instalacions.id')
                 ->where('clientes.id', '!=', 4)
                 //->union($retiros_asignados_proveedor)
                 ->count();

             $cont_asignadoProveedor = $instalacion_asignados_proveedor;

             $instalacion_repuestos_proveedor = DB::connection(strtolower($proveedor))->table('instalacions')
                 ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                 ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                 ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                 ->select('clientes.razon_social as cliente', 'clientes.id as clientes_id')
                 //->where('checklist_instalacions.motivo', '!=', '')
                 ->where('instalacions.dFecha_instalacion', '=', 'repuestos')
                 ->count();

             $cont_repuestosProveedor = $instalacion_repuestos_proveedor;

             $servicio_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                //  ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->count();

             $cont_asignadoservicioProveedor = $servicio_proveedor;


        if(Auth::user()->tipo == "interno"){

            $serviciorepuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos')
                 ->where("api_solicitudes.tipo_asignacion_interna","=","1")

                 ->where('api_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
                 ->count();
         } else{

            $serviciorepuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
            ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos')
            ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

            ->where('api_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
            ->count();
         }

             

                 // ASIGNADAS EXTERNAS 
                 $serviciorepuestos_proveedor_asginada = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
             ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                 ->count();

                 // FINALIZADAS

                 $serviciorepuestos_proveedor_finalizadas = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO')
                 ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
                 ->count();

                

             $cont_respuestoservicioProveedor = $serviciorepuestos_proveedor;
             $cont_respuestoservicioProveedorFinalizadas = $serviciorepuestos_proveedor_finalizadas;
             $cont_respuestoservicioProveedorAsignadas = $serviciorepuestos_proveedor_asginada;
         }
         foreach ($databases as $los_datos) {
             /** SECCCION INSTALACION - RETIRO */
             //SELECT MODALS
             $datos_clientes[] = DB::connection(strtolower($los_datos->Database))->select('SELECT clientes.razon_social as cliente, clientes.id FROM clientes WHERE clientes.id != 4 ');
             $datos_clientes_porasignar[] = DB::connection(strtolower($los_datos->Database))->select('SELECT instalacions.sCliente FROM instalacions UNION SELECT retiros.sCliente FROM retiros');

             //ESTADO PENDIENTE PARA COORDINADOR
             $retiros_pendientes_coordinador = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                 ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                 ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                 ->select('asignacion_retiros.id')
                 ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                 ->where('retiros.scliente', '<>', "kyocera")

                 ->where('checklist_retiros.estado_inicio', '=', null);
             $instalacion_pendientes_coordinador = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                 ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                 ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                 ->select('asignacion_instalacions.id')
                 ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                 ->where('checklist_instalacions.estado_inicio', '=', null)
                 ->where('instalacions.scliente', '<>', "kyocera")

                 ->orderBy('fecha_visita', 'desc')
                 ->union($retiros_pendientes_coordinador)
                 ->count();

             $count_pendienteCoordinador += $instalacion_pendientes_coordinador;


                 // KYOCERA PENDIENTE

             $retiros_pendientes_coordinador_k = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                 ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                 ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                 ->select('asignacion_retiros.id')
                 ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                 ->where('checklist_retiros.Cscliente', '=', "kyocera")

                 ->where('checklist_retiros.estado_inicio', '=', null);
             $instalacion_pendientes_coordinador_k = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                 ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                 ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                 ->select('asignacion_instalacions.id')
                 ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                 ->where('checklist_instalacions.estado_inicio', '=', null)
                 ->where('checklist_instalacions.Cscliente', '=', "kyocera")

                 ->orderBy('fecha_visita', 'desc')
                 ->union($retiros_pendientes_coordinador_k)
                 ->count();

             $contadorkyoceraPendientes += $instalacion_pendientes_coordinador_k;


             //ESTADO POR ASIGNAR PARA COORDINADOR
             $retiros_porasignar_coordinador = DB::connection(strtolower($los_datos->Database))->table('retiros')
                 ->select('retiros.id')
                 ->where('retiros.sCliente', '<>', "kyocera")

                 ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
             $instalacion_porasignar_coordinador = DB::connection(strtolower($los_datos->Database))->table('instalacions')
                 ->select('instalacions.id')
                 ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
                 ->where('instalacions.sCliente', '<>', "kyocera")

                 ->union($retiros_porasignar_coordinador)
                 ->count();

             $count_porasignarCoordinador += $instalacion_porasignar_coordinador;


             //KYOCERA POR ASIGNAR

              //ESTADO POR ASIGNAR PARA COORDINADOR
              $retiros_porasignar_coordinador_k = DB::connection(strtolower($los_datos->Database))->table('retiros')
              ->select('retiros.id')
              ->where('retiros.sCliente', '=', "kyocera")

              ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
          $instalacion_porasignar_coordinador_k = DB::connection(strtolower($los_datos->Database))->table('instalacions')
              ->select('instalacions.id')
              ->where('instalacions.sCliente', '=', "kyocera")

              ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
              ->union($retiros_porasignar_coordinador_k)
                         ->count();

                     $contadorkyoceraAsignadas += $instalacion_porasignar_coordinador_k;

             //ESTADO EN CURSO PARA COORDIANDOR
             $retiros_curso_coordiandor =  DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                 ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                 ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                 ->select('asignacion_retiros.id')
                 ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                 ->where('checklist_retiros.estado_inicio', '=', 'activo');
             $instalacion_curso_coordiandor =  DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                 ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                 ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                 ->select('asignacion_instalacions.id')
                 ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                 ->where('checklist_instalacions.estado_inicio', '=', 'activo')
                 ->orderBy('fecha_visita', 'desc')
                 ->union($retiros_curso_coordiandor)
                 ->count();

             $count_cursoCoordinador += $instalacion_curso_coordiandor;

             //ESTADO POR REASIGNAR COORDINADOR PARA COORDIANDOR
             $retiros_porreasignar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                 ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                 ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                 ->select('asignacion_retiros.id')
                 ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');
             $instalacion_porreasignar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                 ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                 ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                 ->select('asignacion_instalacions.id')
                 ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
                 ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
                 ->union($retiros_porreasignar_coordiandor)
                 ->count();

             $count_porreasignarCoordinador += $instalacion_porreasignar_coordiandor;

             //ESTADO POR REASIGNAR COORDINADOR PARA COORDIANDOR
             $retiros_porrevisar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                 ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                 ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                 ->select('asignacion_retiros.id')
                 ->where('checklist_retiros.Cscliente', '<>', "kyocera")

                 ->where('asignacion_retiros.estado_asignacion', '=', 'revisar');
             $instalacion_porrevisar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                 ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                 ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                 ->select('asignacion_instalacions.id')
                 ->where('asignacion_instalacions.estado_asignacion', '=', 'revisar')
                 ->where('checklist_instalacions.Cscliente', '<>', "kyocera")

                 ->where('instalacions.sEstado_instalacion', '=', 'revisar')
                 ->union($retiros_porrevisar_coordiandor)
                 ->count();

             $count_porrevisarCoordinador += $instalacion_porrevisar_coordiandor;



             //ESTADO POR REASIGNAR COORDINADOR PARA COORDIANDOR KYCERA
             $retiros_porrevisar_coordiandor_k = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                 ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                 ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                 ->select('asignacion_retiros.id')
                 ->where('checklist_retiros.Cscliente', '=', "kyocera")

                 ->where('asignacion_retiros.estado_asignacion', '=', 'revisar');
             $instalacion_porrevisar_coordiandor_k = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                 ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                 ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                 ->select('asignacion_instalacions.id')
                 ->where('asignacion_instalacions.estado_asignacion', '=', 'revisar')
                 ->where('instalacions.sEstado_instalacion', '=', 'revisar')
                 ->where('checklist_instalacions.Cscliente', '=', "kyocera")

                 ->union($retiros_porrevisar_coordiandor_k)
                 ->count();

             $contadorkyoceraRevisar += $instalacion_porrevisar_coordiandor_k;

             //ESTADO PENDIENTE PARA TECNICO
             $retiros_pendientes = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                 ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                 ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                 ->select('asignacion_retiros.id')
                 ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                 ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada');
             $servicios_pendientes = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->select('asignacion_solicitudes.id');
                 if(Auth::user()->tipo == "interno"){
                    
                    $servicios_pendientes->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                    ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
                    ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                    ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                    ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
                    }else{
                        $servicios_pendientes->where("api_solicitudes.tipo_asignacion_interna","=","0")
                            ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                        ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                        ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
                        ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                        ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                        ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
                    }
                
                 //TRANSITO
                 $servicios_pendientes->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                 ->where('api_solicitudes.estado_externo', '=', 'EN TRANSITO')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'EN TRANSITO')
                 ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                 //EN ESPERA
                 ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                 ->where('api_solicitudes.estado_externo', '=', 'EN ESPERA')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'ESPERANDO')
                 ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
             $instalacion_pendientes = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                 ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                 ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                 ->select('asignacion_instalacions.id')
                 ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                 ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                 ->orderBy('fecha_visita', 'desc')
                 ->union($retiros_pendientes)
                 ->union($servicios_pendientes)
                 ->count();

             $count_pendientes += $instalacion_pendientes;

             //ESTADO EN CURSO PARA TECNICO
             $retiros_curso = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                 ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                 ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                 ->select(
                     'asignacion_retiros.id'
                 )
                 ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                 ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                 ->where('checklist_retiros.estado_inicio', '=', 'activo');
             $servicios_curso = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
                 ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                 ->select('asignacion_solicitudes.id');

                 if(Auth::user()->tipo == "interno"){
                 $servicios_curso->where('api_solicitudes.estado_interno', '=', 'INICIADO');

                }else{
                 
                 $servicios_curso->where("api_solicitudes.tipo_asignacion_interna","=","0")
                     ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                 ->where('api_solicitudes.estado_interno', '=', 'INICIADO');
                }
               
               
                 $servicios_curso->where('api_solicitudes.estado_externo', '=', 'INICIADO')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'INICIADO')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'INICIADO')
                 ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
             $instalacion_curso = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                 ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                 ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                 ->select(
                     'asignacion_instalacions.id'
                 )
                 ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                 ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                 ->where('checklist_instalacions.estado_inicio', '=', 'activo')
                 ->orderBy('fecha_visita', 'desc')
                 ->union($servicios_curso)
                 ->union($retiros_curso)
                 ->count();

             $count_curso += $instalacion_curso;

             //ESTADO EN RECHAZADOS PARA TECNICO
             $retiros_rechazado = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                 ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                 ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                 ->select(
                     'asignacion_retiros.id'
                 )
                 ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                 ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado');
             $servicios_rechazados = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->select('asignacion_solicitudes.id')
                 ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                     ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                 ->where('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                 ->where('api_solicitudes.estado_externo', '=', 'RECHAZADO')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'RECHAZADO')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'RECHAZADO')
                 ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
             $instalacion_rechazado = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                 ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                 ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                 ->select(
                     'asignacion_instalacions.id'
                 )
                 ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                 ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
                 //->orderBy('fecha_visita', 'desc')
                 ->union($servicios_rechazados)
                 ->union($retiros_rechazado)
                 ->count();

             $count_rechazado += $instalacion_rechazado;

             /** FIN SECCION INSTALACION/RETIRO */
             /** SECCION SERVICIO */
             $datos_clientes_servicios[] = DB::connection(strtolower($los_datos->Database))->select('SELECT clientes.razon_social as cliente, clientes.id FROM clientes WHERE clientes.id != 4');
             $datos_clientes_porasignar_servicios[] = DB::connection(strtolower($los_datos->Database))->select('SELECT DISTINCT api_solicitudes.sCliente FROM api_solicitudes');
             //SUMA PENDIENTE PARA COORINADOR
             $suma_pendientes_coordinador_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                     ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                 ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                 ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                 ->count();
             $cont_pendienteCoordinador += $suma_pendientes_coordinador_servicio;
             //SUMA POR ASIGNAR COORDINADOR
             $suma_porasignar_coordinador_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                 ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                     ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                 ->where('api_solicitudes.estado_interno', '=', 'POR ASIGNAR')
                 ->where('api_solicitudes.estado_externo', '=', 'POR ASIGNAR')
                 ->orwhere('api_solicitudes.estado_interno', '=', NULL)
                 ->where('api_solicitudes.estado_externo', '=', 'Sin asignar')
                 ->count();
             $cont_porasignarCoordinador += $suma_porasignar_coordinador_servicio;
             //SUMA EN CURSO COORDINADOR




             if(Auth::user()->tipo == "interno"){

             $suma_encursos_coordinador_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 //TRANSITO
                 ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                 ->where('api_solicitudes.estado_externo', '=', 'EN TRANSITO')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'EN TRANSITO')
                 //EN ESPERA
                 ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                 
                 ->where('api_solicitudes.estado_externo', '=', 'EN ESPERA')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'ESPERANDO')
                 //INICIADO
                 ->orwhere('api_solicitudes.estado_interno', '=', 'INICIADO')
                 ->where('api_solicitudes.estado_externo', '=', 'INICIADO')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'INICIADO')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'INICIADO')
                 ->count();
                 
             $cont_encursoCoordinador += $suma_encursos_coordinador_servicio;

            }else{

                $suma_encursos_coordinador_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                //TRANSITO
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'EN TRANSITO')
                //EN ESPERA
                ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_externo', '=', 'EN ESPERA')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ESPERANDO')
                //INICIADO
                ->orwhere('api_solicitudes.estado_interno', '=', 'INICIADO')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_externo', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_externo', '=', 'INICIADO')
                ->count();
                
            $cont_encursoCoordinador += $suma_encursos_coordinador_servicio;
            }

             $suma_porreasignars_coordiandor_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                 ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                     ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                 ->where('api_solicitudes.estado_interno', '=', 'REASIGNAR')
                 ->count();
             $cont_porreasignarCoordinador += $suma_porreasignars_coordiandor_servicio;

             if(Auth::user()->ver_todo_solicitud == 0){
                $suma_porrevisar_coordiandor_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'REVISAR')
                ->orwhere('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                ->count();
             }else{
                $suma_porrevisar_coordiandor_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->where('api_solicitudes.estado_interno', '=', 'REVISAR')
                ->orwhere('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                ->count();
             }
             $cont_porrevisarCoordinador += $suma_porrevisar_coordiandor_servicio;

             $suma_InstalarRespuestos = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                 ->where('api_solicitudes.estado_externo','=','Instalar repuesto')
                 ->where('api_solicitudes.estado_interno','=','Solicitar Repuestos')
                 ->orwhere('api_solicitudes.estado_externo','=','Instalar repuesto')
                 ->where('api_solicitudes.estado_interno','=',NULL)
                 //->where('api_solicitudes.estado_interno','!','FINALIZADO')
                 ->count();

                 $suma_InstalarRespuestos_solicitud = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos')
                 ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                     ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                 ->where('api_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
                 ->count();


             $cont_instalarRepuestos += $suma_InstalarRespuestos;
             $cont_soli_instalarRepuestos += $suma_InstalarRespuestos_solicitud;
         }
         /** SECCION INSTALACION - RETIRO */
         $suma_pendientes_coordinador = $count_pendienteCoordinador;
         $suma_pendientes_coordinador_k = $contadorkyoceraPendientes;
         $suma_asignada_coordinador_k = $contadorkyoceraAsignadas;
         $suma_revisar_coordinador_k = $contadorkyoceraRevisar;


         $suma_porasignar_coordinador = $count_porasignarCoordinador;
         $suma_encursos_coordiandor = $count_cursoCoordinador;
         $suma_porreasignars_coordiandor = $count_porreasignarCoordinador;
         $suma_porrevisar_coordiandor = $count_porrevisarCoordinador;
         //TECNICO
         $suma_pendientes = $count_pendientes;
         $suma_encursos = $count_curso;
         $suma_rechazado = $count_rechazado;
         /** SECCION SERVICIO */
         $suma_pendientes_coordinador_servicio = $cont_pendienteCoordinador;
         $suma_porasignar_coordinador_servicio = $cont_porasignarCoordinador;
         $suma_encursos_coordiandor_servicio = $cont_encursoCoordinador;
         $suma_porreasignar_coordiandor_servicio = $cont_porreasignarCoordinador;
         $suma_porrevisar_coordiandor_servicio = $cont_porrevisarCoordinador;
         $suma_estado_intalar_respuestos = $cont_instalarRepuestos;
         $suma_estado_solicitud_intalar_respuestos = $cont_soli_instalarRepuestos;

        //  $proveedores= [
        //      ['COMTECGLOBAL', 'COMTECGLOBAL'],
        //      ['DEIRA', 'DEIRA'],
        //      ['Kyocera', 'KYOCERA'],
        //     ['IMPRECORP', 'IMPRECORP'],

        //  ];

        $pro =App\bd_proveedores::selectDB();

        $proveedores= [];

        foreach($pro as $los_datos){
           // $los_datos->Database

           // $proveedores= [
           // ];
               array_push ($proveedores,[$los_datos->Database, $los_datos->Database]);

        }


        $regiones = App\regions::orderBy('num_r', 'asc')->get();
         // $datos_clientes = sort($datos_clientes);
         // return $cont_respuestoservicioProveedorFinalizadas;
         // $cont_respuestoservicioProveedorFinalizadas = $serviciorepuestos_proveedor_finalizadas;
         // $cont_respuestoservicioProveedorAsignadas = $serviciorepuestos_proveedor_asginada;
         return view('home', compact('regiones','suma_revisar_coordinador_k','suma_asignada_coordinador_k',
         'suma_pendientes_coordinador_k',
         'cont_respuestoservicioProveedorAsignadas',
         'cont_respuestoservicioProveedorFinalizadas',
         'proveedores',
         'suma_estado_intalar_respuestos',
         'suma_estado_solicitud_intalar_respuestos',
          'cont_repuestosProveedor',
          'cont_respuestoservicioProveedor',
          'cont_asignadoservicioProveedor',
          'cont_asignadoProveedor',
           'datos_clientes_porasignar_servicios',
           'suma_porreasignar_coordiandor_servicio',
           'suma_encursos_coordiandor_servicio',
           'suma_encursos_coordiandor_servicio',
           'suma_porasignar_coordinador_servicio',
            'suma_pendientes_coordinador_servicio',
            'suma_porreasignars_coordiandor',
            'trabajadores',
            'datos_clientes_porasignar',
            'datos_clientes',
            'suma_pendientes',
             'suma_encursos',
             'suma_rechazado',
             'suma_pendientes_coordinador',
             'suma_porasignar_coordinador',
             'suma_encursos_coordiandor',
             'suma_porrevisar_coordiandor_servicio',
             'suma_porrevisar_coordiandor',
             'finalizadas_tecnico_interno',
             'rechazadas_tecnico_interno',
             'finalizadas_coordinador'
            ));
     }

    public function index_old_09_02_23()
    {

        //SELECT TECNICOS
        $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->select(
                'personas.nombre_uno',
                'personas.apellido_uno',
                'trabajadors.id'
            )
            ->where('trabajadors.estado', '=', '1')
            ->orderBy('personas.nombre_uno', 'ASC')
            ->get();

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        if (count($datos_trabajador) != 0) {
            $id_trabajador = $datos_trabajador[0]->id;
        } else {
            $id_trabajador = 0;
        }

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        /** SECCION INSTALACION - RETIRO */
        $count_pendienteCoordinador = 0;
        $count_porasignarCoordinador = 0;
        $count_cursoCoordinador = 0;
        $count_porreasignarCoordinador = 0;
        $count_porrevisarCoordinador = 0;
        $count_pendientes = 0;
        $count_curso = 0;
        $count_rechazado = 0;
        /** SECCION SERVICIO */
        $cont_pendienteCoordinador = 0;
        $cont_porasignarCoordinador = 0;
        $cont_encursoCoordinador = 0;
        $cont_porreasignarCoordinador = 0;
        $cont_porrevisarCoordinador = 0;
        $cont_instalarRepuestos = 0;

        $cont_soli_instalarRepuestos = 0;

        //SECCION PROVEEDOR
        $cont_asignadoProveedor = 0;
        $cont_asignadoservicioProveedor = 0;
        $cont_respuestoservicioProveedor = 0;
        $cont_respuestoservicioProveedorFinalizadas = 0;
        $cont_respuestoservicioProveedorAsignadas = 0;

        $proveedor = Auth::user()->nombre_proveedor;

        //SECCION PROVEEDOR
        $cont_asignadoProveedor = 0;
        $cont_repuestosProveedor = 0;
        $cont_asignadoservicioProveedor = 0;
        $cont_respuestoservicioProveedor = 0;
        $proveedor = Auth::user()->nombre_proveedor;

        if ($proveedor != "") {
            $retiros_asignados_proveedor = DB::connection(strtolower($proveedor))->table('retiros')
                ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->select('retiros.id')
                ->where('clientes.id', '!=', 4);
            $instalacion_asignados_proveedor = DB::connection(strtolower($proveedor))->table('instalacions')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->select('instalacions.id')
                ->where('clientes.id', '!=', 4)
                //->union($retiros_asignados_proveedor)
                ->count();

            $cont_asignadoProveedor = $instalacion_asignados_proveedor;

            $instalacion_repuestos_proveedor = DB::connection(strtolower($proveedor))->table('instalacions')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->select('clientes.razon_social as cliente', 'clientes.id as clientes_id')
                //->where('checklist_instalacions.motivo', '!=', '')
                ->where('instalacions.dFecha_instalacion', '=', 'repuestos')
                ->count();

            $cont_repuestosProveedor = $instalacion_repuestos_proveedor;

            $servicio_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                // ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->count();

            $cont_asignadoservicioProveedor = $servicio_proveedor;


        if(Auth::user()->tipo == "interno"){

            $serviciorepuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos')
                 ->where("api_solicitudes.tipo_asignacion_interna","=","1")

                 ->where('api_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
                 ->count();
         } else{

            $serviciorepuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
            ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos')
            ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

            ->where('api_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
            ->count();
         }

            // $serviciorepuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            //     ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            //     ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
            //     ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos')
            //     ->where("api_solicitudes.tipo_asignacion_interna","=","0")
            //         ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

            //     ->where('api_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
            //     ->count();

                // ASIGNADAS
                $serviciorepuestos_proveedor_asginada = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->count();

                // FINALIZADAS

                $serviciorepuestos_proveedor_finalizadas = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
                ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO')
                ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
                ->count();

            $cont_respuestoservicioProveedor = $serviciorepuestos_proveedor;
            $cont_respuestoservicioProveedorFinalizadas = $serviciorepuestos_proveedor_finalizadas;
            $cont_respuestoservicioProveedorAsignadas = $serviciorepuestos_proveedor_asginada;
        }
        foreach ($databases as $los_datos) {
            /** SECCCION INSTALACION - RETIRO */
            //SELECT MODALS
            $datos_clientes[] = DB::connection(strtolower($los_datos->Database))->select('SELECT clientes.razon_social as cliente, clientes.id FROM clientes WHERE clientes.id != 4 ');
            $datos_clientes_porasignar[] = DB::connection(strtolower($los_datos->Database))->select('SELECT instalacions.sCliente FROM instalacions UNION SELECT retiros.sCliente FROM retiros');

            //ESTADO PENDIENTE PARA COORDINADOR
            $retiros_pendientes_coordinador = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select('asignacion_retiros.id')
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_inicio', '=', null);
            $instalacion_pendientes_coordinador = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select('asignacion_instalacions.id')
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '=', null)

                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_pendientes_coordinador)
                ->count();

            $count_pendienteCoordinador += $instalacion_pendientes_coordinador;

            //ESTADO POR ASIGNAR PARA COORDINADOR
            $retiros_porasignar_coordinador = DB::connection(strtolower($los_datos->Database))->table('retiros')
                ->select('retiros.id')
                ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
            $instalacion_porasignar_coordinador = DB::connection(strtolower($los_datos->Database))->table('instalacions')
                ->select('instalacions.id')
                ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
                ->union($retiros_porasignar_coordinador)
                ->count();

            $count_porasignarCoordinador += $instalacion_porasignar_coordinador;

            //ESTADO EN CURSO PARA COORDIANDOR
            $retiros_curso_coordiandor =  DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select('asignacion_retiros.id')
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_inicio', '=', 'activo');
            $instalacion_curso_coordiandor =  DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select('asignacion_instalacions.id')
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '=', 'activo')
                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_curso_coordiandor)
                ->count();

            $count_cursoCoordinador += $instalacion_curso_coordiandor;

            //ESTADO POR REASIGNAR COORDINADOR PARA COORDIANDOR
            $retiros_porreasignar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select('asignacion_retiros.id')
                ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');
            $instalacion_porreasignar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select('asignacion_instalacions.id')
                ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
                ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
                ->union($retiros_porreasignar_coordiandor)
                ->count();

            $count_porreasignarCoordinador += $instalacion_porreasignar_coordiandor;

            //ESTADO POR REASIGNAR COORDINADOR PARA COORDIANDOR
            $retiros_porrevisar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select('asignacion_retiros.id')
                ->where('asignacion_retiros.estado_asignacion', '=', 'revisar');
            $instalacion_porrevisar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select('asignacion_instalacions.id')
                ->where('asignacion_instalacions.estado_asignacion', '=', 'revisar')
                ->where('instalacions.sEstado_instalacion', '=', 'revisar')
                ->union($retiros_porrevisar_coordiandor)
                ->count();

            $count_porrevisarCoordinador += $instalacion_porrevisar_coordiandor;

            //ESTADO PENDIENTE PARA TECNICO
            $retiros_pendientes = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select('asignacion_retiros.id')
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada');
            $servicios_pendientes = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->select('asignacion_solicitudes.id')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                //TRANSITO
                ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                //EN ESPERA
                ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN ESPERA')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ESPERANDO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
            $instalacion_pendientes = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select('asignacion_instalacions.id')
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_pendientes)
                ->union($servicios_pendientes)
                ->count();

            $count_pendientes += $instalacion_pendientes;

            //ESTADO EN CURSO PARA TECNICO
            $retiros_curso = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'asignacion_retiros.id'
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_inicio', '=', 'activo');
            $servicios_curso = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
                ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                ->select('asignacion_solicitudes.id')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('api_solicitudes.estado_externo', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_externo', '=', 'INICIADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
            $instalacion_curso = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id'
                )
                ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '=', 'activo')
                ->orderBy('fecha_visita', 'desc')
                ->union($servicios_curso)
                ->union($retiros_curso)
                ->count();

            $count_curso += $instalacion_curso;

            //ESTADO EN RECHAZADOS PARA TECNICO
            $retiros_rechazado = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'asignacion_retiros.id'
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado');
            $servicios_rechazados = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->select('asignacion_solicitudes.id')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                ->where('api_solicitudes.estado_externo', '=', 'RECHAZADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'RECHAZADO')
                ->where('asignacion_solicitudes.estado_externo', '=', 'RECHAZADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
            $instalacion_rechazado = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id'
                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
                //->orderBy('fecha_visita', 'desc')
                ->union($servicios_rechazados)
                ->union($retiros_rechazado)
                ->count();

            $count_rechazado += $instalacion_rechazado;

            /** FIN SECCION INSTALACION/RETIRO */
            /** SECCION SERVICIO */
            $datos_clientes_servicios[] = DB::connection(strtolower($los_datos->Database))->select('SELECT clientes.razon_social as cliente, clientes.id FROM clientes WHERE clientes.id != 4');
            $datos_clientes_porasignar_servicios[] = DB::connection(strtolower($los_datos->Database))->select('SELECT DISTINCT api_solicitudes.sCliente FROM api_solicitudes');
            //SUMA PENDIENTE PARA COORINADOR
            $suma_pendientes_coordinador_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->count();
            $cont_pendienteCoordinador += $suma_pendientes_coordinador_servicio;
            //SUMA POR ASIGNAR COORDINADOR
            $suma_porasignar_coordinador_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'POR ASIGNAR')
                ->where('api_solicitudes.estado_externo', '=', 'POR ASIGNAR')
                ->orwhere('api_solicitudes.estado_interno', '=', NULL)
                ->where('api_solicitudes.estado_externo', '=', 'Sin asignar')
                ->count();
            $cont_porasignarCoordinador += $suma_porasignar_coordinador_servicio;
            //SUMA EN CURSO COORDINADOR
            $suma_encursos_coordinador_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                //TRANSITO
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'EN TRANSITO')
                //EN ESPERA
                ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN ESPERA')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ESPERANDO')
                //INICIADO
                ->orwhere('api_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('api_solicitudes.estado_externo', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_externo', '=', 'INICIADO')
                ->count();
            $cont_encursoCoordinador += $suma_encursos_coordinador_servicio;

            $suma_porreasignars_coordiandor_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'REASIGNAR')
                ->count();
            $cont_porreasignarCoordinador += $suma_porreasignars_coordiandor_servicio;

            if(Auth::user()->ver_todo_solicitud == 0){
                $suma_porrevisar_coordiandor_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'REVISAR')
                ->orwhere('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                ->count();
             }else{
                $suma_porrevisar_coordiandor_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->where('api_solicitudes.estado_interno', '=', 'REVISAR')
                ->orwhere('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                ->count();
             }
            // $suma_porrevisar_coordiandor_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
            //     ->where("api_solicitudes.tipo_asignacion_interna","=","0")
            //     ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

            // ->where('api_solicitudes.estado_interno', '=', 'REVISAR')
            //     ->orwhere('api_solicitudes.estado_interno', '=', 'RECHAZADO')
            //     ->count();
            $cont_porrevisarCoordinador += $suma_porrevisar_coordiandor_servicio;

            $suma_InstalarRespuestos = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->where('api_solicitudes.estado_externo','=','Instalar repuesto')
                ->where('api_solicitudes.estado_interno','=','Solicitar Repuestos')
                ->orwhere('api_solicitudes.estado_externo','=','Instalar repuesto')
                ->where('api_solicitudes.estado_interno','=',NULL)
                //->where('api_solicitudes.estado_interno','!','FINALIZADO')
                ->count();

                $suma_InstalarRespuestos_solicitud = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
                ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
                ->count();


            $cont_instalarRepuestos += $suma_InstalarRespuestos;
            $cont_soli_instalarRepuestos += $suma_InstalarRespuestos_solicitud;
        }
        /** SECCION INSTALACION - RETIRO */
        $suma_pendientes_coordinador = $count_pendienteCoordinador;
        $suma_porasignar_coordinador = $count_porasignarCoordinador;
        $suma_encursos_coordiandor = $count_cursoCoordinador;
        $suma_porreasignars_coordiandor = $count_porreasignarCoordinador;
        $suma_porrevisar_coordiandor = $count_porrevisarCoordinador;
        //TECNICO
        $suma_pendientes = $count_pendientes;
        $suma_encursos = $count_curso;
        $suma_rechazado = $count_rechazado;
        /** SECCION SERVICIO */
        $suma_pendientes_coordinador_servicio = $cont_pendienteCoordinador;
        $suma_porasignar_coordinador_servicio = $cont_porasignarCoordinador;
        $suma_encursos_coordiandor_servicio = $cont_encursoCoordinador;
        $suma_porreasignar_coordiandor_servicio = $cont_porreasignarCoordinador;
        $suma_porrevisar_coordiandor_servicio = $cont_porrevisarCoordinador;
        $suma_estado_intalar_respuestos = $cont_instalarRepuestos;
        $suma_estado_solicitud_intalar_respuestos = $cont_soli_instalarRepuestos;

        $proveedores= [
            ['COMTECGLOBAL', 'COMTECGLOBAL'],
            ['DEIRA', 'DEIRA'],
            ['Kyocera', 'KYOCERA'],
           ['IMPRECORP', 'IMPRECORP'],

        ];

        // $datos_clientes = sort($datos_clientes);
        // return $cont_respuestoservicioProveedorFinalizadas;
        // $cont_respuestoservicioProveedorFinalizadas = $serviciorepuestos_proveedor_finalizadas;
        // $cont_respuestoservicioProveedorAsignadas = $serviciorepuestos_proveedor_asginada;
        return view('home', compact('cont_respuestoservicioProveedorAsignadas','cont_respuestoservicioProveedorFinalizadas','proveedores','suma_estado_intalar_respuestos','suma_estado_solicitud_intalar_respuestos', 'cont_repuestosProveedor', 'cont_respuestoservicioProveedor', 'cont_asignadoservicioProveedor', 'cont_asignadoProveedor', 'datos_clientes_porasignar_servicios', 'suma_porreasignar_coordiandor_servicio', 'suma_encursos_coordiandor_servicio', 'suma_encursos_coordiandor_servicio', 'suma_porasignar_coordinador_servicio', 'suma_pendientes_coordinador_servicio', 'suma_porreasignars_coordiandor', 'trabajadores', 'datos_clientes_porasignar', 'datos_clientes', 'suma_pendientes', 'suma_encursos', 'suma_rechazado', 'suma_pendientes_coordinador', 'suma_porasignar_coordinador', 'suma_encursos_coordiandor', 'suma_porrevisar_coordiandor_servicio', 'suma_porrevisar_coordiandor'));
    }
    public function actualizar()
    {    

        //SELECT TECNICOS
        $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->select(
                'personas.nombre_uno',
                'personas.apellido_uno',
                'trabajadors.id'
            )
            ->where('trabajadors.estado', '=', '1')
            ->orderBy('trabajadors.id', 'desc')
            ->get();

        $datos_trabajador = DB::table('trabajadors')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        if (count($datos_trabajador) != 0) {
            $id_trabajador = $datos_trabajador[0]->id;
        } else {
            $id_trabajador = 0;
        }

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        /** SECCION INSTALACION - RETIRO */
        $count_pendienteCoordinador = 0;
        $count_porasignarCoordinador = 0;
        $count_cursoCoordinador = 0;
        $count_porreasignarCoordinador = 0;
        $count_porrevisarCoordinador = 0;
        $count_pendientes = 0;
        $count_curso = 0;
        $count_rechazado = 0;
        /** SECCION SERVICIO */
        $cont_pendienteCoordinador = 0;
        $cont_porasignarCoordinador = 0;
        $cont_encursoCoordinador = 0;
        $cont_porreasignarCoordinador = 0;
        $cont_porrevisarCoordinador = 0;
        $finalizadas_coordinador = 0;

        //SECCION PROVEEDOR
        $cont_asignadoProveedor = 0;
        $cont_repuestosProveedor = 0;
        $cont_asignadoservicioProveedor = 0;
        $cont_respuestoservicioProveedor = 0;
        $cont_respuestoservicioProveedorFinalizadas = 0;
        $cont_respuestoservicioProveedorAsignadas = 0;
        $proveedor = Auth::user()->nombre_proveedor;
        $finalizadas_tecnico_interno = 0;
        $rechazadas_tecnico_interno = 0;

        $finalizadas_coordinador   = DB::table('api_solicitudes')
        ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
        ->select('asignacion_solicitudes.id')->where("api_solicitudes.tipo_asignacion_interna","=","0")
        ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
                       ->where('api_solicitudes.estado_externo', '=', 'FINALIZADO')
                       ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
                       ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO')
                    //    ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)->count();
                    ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                        ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                    ->count();

        if(Auth::user()->tipo == "interno"){
            $finalizadas_tecnico_interno   = DB::table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select('asignacion_solicitudes.id')->where("api_solicitudes.tipo_asignacion_interna","=","1")
            ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
                           ->where('api_solicitudes.estado_externo', '=', 'FINALIZADO')
                           ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
                           ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO')
                           ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)->count();

         }else{
            $finalizadas_tecnico_interno   = DB::table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select('asignacion_solicitudes.id')
            ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])


            ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
                           ->where('api_solicitudes.estado_externo', '=', 'FINALIZADO')
                           ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
                           ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO')
                           ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)->count();
         }

               // RECHAZADAS

        if(Auth::user()->tipo == "interno"){
            $rechazadas_tecnico_interno   = DB::table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select('asignacion_solicitudes.id')->where("api_solicitudes.tipo_asignacion_interna","=","1")
            ->where('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                        ->where('api_solicitudes.estado_externo', '=', 'RECHAZADO')
                        ->where('asignacion_solicitudes.estado_interno', '=', 'RECHAZADO')
                        ->where('asignacion_solicitudes.estado_externo', '=', 'RECHAZADO')
                        ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)->count();

        }else{
            $rechazadas_tecnico_interno   = DB::table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select('asignacion_solicitudes.id')
            ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])


            ->where('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                        ->where('api_solicitudes.estado_externo', '=', 'RECHAZADO')
                        ->where('asignacion_solicitudes.estado_interno', '=', 'RECHAZADO')
                        ->where('asignacion_solicitudes.estado_externo', '=', 'RECHAZADO')
                        ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)->count();
        }

        // FIN RECHAZADAS



        if ($proveedor != "") {
            $retiros_asignados_proveedor = DB::connection(strtolower($proveedor))->table('retiros')
                ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->select('retiros.id')
                ->where('clientes.id', '!=', 4);
            $instalacion_asignados_proveedor = DB::connection(strtolower($proveedor))->table('instalacions')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->select('instalacions.id')
                ->where('clientes.id', '!=', 4)
                //->union($retiros_asignados_proveedor)
                ->count();

            $cont_asignadoProveedor = $instalacion_asignados_proveedor;
            $instalacion_repuestos_proveedor = DB::connection(strtolower($proveedor))->table('instalacions')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->select('clientes.razon_social as cliente', 'clientes.id as clientes_id')
                //->where('checklist_instalacions.motivo', '!=', '')
                ->where('instalacions.dFecha_instalacion', '=', 'repuestos')
                ->count();

            $cont_repuestosProveedor = $instalacion_repuestos_proveedor;

            $servicio_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                // ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->count();

            $cont_asignadoservicioProveedor = $servicio_proveedor;


        if(Auth::user()->tipo == "interno"){

            $serviciorepuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
                 ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos')
                 ->where("api_solicitudes.tipo_asignacion_interna","=","1")

                 ->where('api_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
                 ->count();
         } else{

            $serviciorepuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
            ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos')
            ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

            ->where('api_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
            ->count();
         }
            // $serviciorepuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            //     ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            //     ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
            //     ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos')
            //     ->where("api_solicitudes.tipo_asignacion_interna","=","0")
            //         ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

            //     ->where('api_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
            //     ->count();


                    // ASIGNADAS EXTERNO
                    $serviciorepuestos_proveedor_asginada = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                    ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                    ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                    ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                    ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                    ->count();

                    // FINALIZADAS

                    $serviciorepuestos_proveedor_finalizadas = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                    ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                    ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
                    ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO')
                    ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
                    ->count();

                $cont_respuestoservicioProveedor = $serviciorepuestos_proveedor;
                $cont_respuestoservicioProveedorFinalizadas = $serviciorepuestos_proveedor_finalizadas;
                $cont_respuestoservicioProveedorAsignadas = $serviciorepuestos_proveedor_asginada;

        }


        foreach ($databases as $los_datos) {
            /** SECCCION INSTALACION - RETIRO */
            //SELECT MODALS
            $datos_clientes[] = DB::connection(strtolower($los_datos->Database))->select('SELECT clientes.razon_social as cliente, clientes.id FROM clientes WHERE clientes.id != 4');
            $datos_clientes_porasignar[] = DB::connection(strtolower($los_datos->Database))->select('SELECT instalacions.sCliente FROM instalacions UNION SELECT retiros.sCliente FROM retiros');

            //ESTADO PENDIENTE PARA COORDINADOR
            $retiros_pendientes_coordinador = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select('asignacion_retiros.id')
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('retiros.scliente', '<>', "kyocera")

                ->where('checklist_retiros.estado_inicio', '=', null);
            $instalacion_pendientes_coordinador = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select('asignacion_instalacions.id')
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '=', null)
                ->where('instalacions.scliente', '<>', "kyocera")

                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_pendientes_coordinador)
                ->count();

            $count_pendienteCoordinador += $instalacion_pendientes_coordinador;

            //ESTADO POR ASIGNAR PARA COORDINADOR
            $retiros_porasignar_coordinador = DB::connection(strtolower($los_datos->Database))->table('retiros')
                ->select('retiros.id')
                ->where('retiros.scliente', '<>', "kyocera")

                ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
            $instalacion_porasignar_coordinador = DB::connection(strtolower($los_datos->Database))->table('instalacions')
                ->select('instalacions.id')
                ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
                ->where('instalacions.scliente', '<>', "kyocera")

                ->union($retiros_porasignar_coordinador)
                ->count();

            $count_porasignarCoordinador += $instalacion_porasignar_coordinador;

            //ESTADO EN CURSO PARA COORDIANDOR
            $retiros_curso_coordiandor =  DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select('asignacion_retiros.id')
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_inicio', '=', 'activo');
            $instalacion_curso_coordiandor =  DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select('asignacion_instalacions.id')
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '=', 'activo')
                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_curso_coordiandor)
                ->count();

            $count_cursoCoordinador += $instalacion_curso_coordiandor;

            //ESTADO POR REASIGNAR COORDINADOR PARA COORDIANDOR
            $retiros_porrevisar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select('asignacion_retiros.id')
                ->where('retiros.scliente', '<>', "kyocera")

                ->where('asignacion_retiros.estado_asignacion', '=', 'revisar');
            $instalacion_porrevisar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select('asignacion_instalacions.id')
                ->where('asignacion_instalacions.estado_asignacion', '=', 'revisar')
                ->where('instalacions.sEstado_instalacion', '=', 'revisar')
                ->where('instalacions.scliente', '<>', "kyocera")

                ->union($retiros_porrevisar_coordiandor)
                ->count();

            $count_porrevisarCoordinador += $instalacion_porrevisar_coordiandor;

            //ESTADO POR REVISAR COORDINADOR PARA COORDIANDOR
            $retiros_porreasignar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select('asignacion_retiros.id')
                ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');
            $instalacion_porreasignar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select('asignacion_instalacions.id')
                ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
                ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
                ->union($retiros_porreasignar_coordiandor)
                ->count();


            $count_porreasignarCoordinador += $instalacion_porreasignar_coordiandor;

            //ESTADO PENDIENTE PARA TECNICO
            $retiros_pendientes = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select('asignacion_retiros.id')
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada');
            $servicios_pendientes = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->select('asignacion_solicitudes.id');

                if(Auth::user()->tipo == "interno"){

                $servicios_pendientes->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
                
            }else{
                $servicios_pendientes->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
            }



                //TRANSITO
                $servicios_pendientes->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                //EN ESPERA
                ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN ESPERA')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ESPERANDO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
            $instalacion_pendientes = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select('asignacion_instalacions.id')
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->orderBy('fecha_visita', 'desc')
                ->union($retiros_pendientes)
                ->union($servicios_pendientes)
                ->count();

            $count_pendientes += $instalacion_pendientes;

            //ESTADO EN CURSO PARA TECNICO
            $retiros_curso = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'asignacion_retiros.id'
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_inicio', '=', 'activo');
            $servicios_curso = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
                ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                ->select('asignacion_solicitudes.id');
                
                
                // ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                //     ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                // ->where('api_solicitudes.estado_interno', '=', 'INICIADO')
                 if(Auth::user()->tipo == "interno"){
                 $servicios_curso->where('api_solicitudes.estado_interno', '=', 'INICIADO');

                }else{
                 
                 $servicios_curso->where("api_solicitudes.tipo_asignacion_interna","=","0")
                     ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                 ->where('api_solicitudes.estado_interno', '=', 'INICIADO');
                }
                
                
                $servicios_curso->where('api_solicitudes.estado_externo', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_externo', '=', 'INICIADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
            $instalacion_curso = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id'
                )
                ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '=', 'activo')
                ->orderBy('fecha_visita', 'desc')
                ->union($servicios_curso)
                ->union($retiros_curso)
                ->count();

            $count_curso += $instalacion_curso;

            //ESTADO EN RECHAZADOS PARA TECNICO
            $retiros_rechazado = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'asignacion_retiros.id'
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado');
            $servicios_rechazados = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->select('asignacion_solicitudes.id')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                ->where('api_solicitudes.estado_externo', '=', 'RECHAZADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'RECHAZADO')
                ->where('asignacion_solicitudes.estado_externo', '=', 'RECHAZADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
            $instalacion_rechazado = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'asignacion_instalacions.id'
                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
                //->orderBy('fecha_visita', 'desc')
                ->union($servicios_rechazados)
                ->union($retiros_rechazado)
                ->count();

            $count_rechazado += $instalacion_rechazado;

            /** FIN SECCION INSTALACION/RETIRO */
            /** SECCION SERVICIO */
            $datos_clientes_servicios[] = DB::connection(strtolower($los_datos->Database))->select('SELECT clientes.razon_social as cliente, clientes.id FROM clientes WHERE clientes.id != 4');
            $datos_clientes_porasignar_servicios[] = DB::connection(strtolower($los_datos->Database))->select('SELECT DISTINCT api_solicitudes.sCliente FROM api_solicitudes');
            //SUMA PENDIENTE PARA COORINADOR
            $suma_pendientes_coordinador_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->count();
            $cont_pendienteCoordinador += $suma_pendientes_coordinador_servicio;
            //SUMA POR ASIGNAR COORDINADOR
            $suma_porasignar_coordinador_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'POR ASIGNAR')
                ->where('api_solicitudes.estado_externo', '=', 'POR ASIGNAR')
                ->orwhere('api_solicitudes.estado_interno', '=', NULL)
                ->where('api_solicitudes.estado_externo', '=', 'Sin asignar')
                ->count();
            $cont_porasignarCoordinador += $suma_porasignar_coordinador_servicio;
            //SUMA EN CURSO COORDINADOR
            $suma_encursos_coordinador_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                //TRANSITO
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'EN TRANSITO')
                //EN ESPERA
                ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN ESPERA')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ESPERANDO')
                //INICIADO
                ->orwhere('api_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('api_solicitudes.estado_externo', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_externo', '=', 'INICIADO')
                ->count();
            $cont_encursoCoordinador += $suma_encursos_coordinador_servicio;

            $suma_porreasignars_coordiandor_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'REASIGNAR')
                ->count();
            $cont_porreasignarCoordinador += $suma_porreasignars_coordiandor_servicio;

            // $suma_porrevisar_coordiandor_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
            //     ->where("api_solicitudes.tipo_asignacion_interna","=","0")
            //     ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

            // ->where('api_solicitudes.estado_interno', '=', 'REVISAR')
            //     ->orwhere('api_solicitudes.estado_interno', '=', 'RECHAZADO')
            //     ->count();
            if(Auth::user()->ver_todo_solicitud == 0){
                $suma_porrevisar_coordiandor_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'REVISAR')
                ->orwhere('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                ->count();
             }else{
                $suma_porrevisar_coordiandor_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->where('api_solicitudes.estado_interno', '=', 'REVISAR')
                ->orwhere('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                ->count();
             }
            $cont_porrevisarCoordinador += $suma_porrevisar_coordiandor_servicio;
        }


        /** SECCION INSTALACION - RETIRO */
        $suma_pendientes_coordinador = $count_pendienteCoordinador;
        $suma_porasignar_coordinador = $count_porasignarCoordinador;
        $suma_encursos_coordiandor = $count_cursoCoordinador;
        $suma_porreasignars_coordiandor = $count_porreasignarCoordinador;
        $suma_porrevisar_coordiandor = $count_porrevisarCoordinador;
        //TECNICO
        $suma_pendientes = $count_pendientes;
        $suma_encursos = $count_curso;
        $suma_rechazado = $count_rechazado;
        /** SECCION SERVICIO */
        $suma_pendientes_coordinador_servicio = $cont_pendienteCoordinador;
        $suma_porasignar_coordinador_servicio = $cont_porasignarCoordinador;
        $suma_encursos_coordiandor_servicio = $cont_encursoCoordinador;
        $suma_porreasignar_coordiandor_servicio = $cont_porreasignarCoordinador;
        $suma_porrevisar_coordiandor_servicio = $cont_porrevisarCoordinador;

// cont_respuestoservicioProveedor
        // return $serviciorepuestos_proveedor;

        // $cont_respuestoservicioProveedor = $serviciorepuestos_proveedor;

        // $cont_respuestoservicioProveedorFinalizadas = $serviciorepuestos_proveedor_finalizadas;


        // $cont_respuestoservicioProveedorAsignadas = $serviciorepuestos_proveedor_asginada;

        //PROVEEDOR
        $data['cont_repuestosProveedor'] = $cont_repuestosProveedor;
        $data['cont_respuestoservicioProveedor'] = $cont_respuestoservicioProveedor;
        $data['cont_respuestoservicioProveedorFinalizadas'] = $cont_respuestoservicioProveedorFinalizadas;
        $data['cont_respuestoservicioProveedorAsignadas'] = $cont_respuestoservicioProveedorAsignadas;
        $data['finalizadas_tecnico_interno'] = $finalizadas_tecnico_interno;
        $data['rechazadas_tecnico_interno'] = $rechazadas_tecnico_interno;


        $data['finalizadas_coordinador'] = $finalizadas_coordinador;

        
        $data['cont_asignadoservicioProveedor'] = $cont_asignadoservicioProveedor;
        $data['cont_asignadoProveedor'] = $cont_asignadoProveedor;
        //TECNICO
        $data['suma_pendientes_tecnico'] = $suma_pendientes;
        $data['suma_encursos_tecnico'] = $suma_encursos;
        $data['suma_rechazado_tecnico'] = $suma_rechazado;
        //COORDINADOR
        $data['suma_porreasignars_coordiandor'] = $suma_porreasignars_coordiandor;
        $data['suma_pendientes_coordinador'] = $suma_pendientes_coordinador;
        $data['suma_porasignar_coordinador'] = $suma_porasignar_coordinador;
        $data['suma_encursos_coordiandor'] = $suma_encursos_coordiandor;
        $data['suma_porrevisar_coordiandor'] = $suma_porrevisar_coordiandor;
        $data['suma_pendientes_coordinador_servicio'] = $suma_pendientes_coordinador_servicio;
        $data['suma_porasignar_coordinador_servicio'] = $suma_porasignar_coordinador_servicio;
        $data['suma_encursos_coordiandor_servicio'] = $suma_encursos_coordiandor_servicio;
        $data['suma_porreasignar_coordiandor_servicio'] = $suma_porreasignar_coordiandor_servicio;
        $data['suma_porrevisar_coordiandor_servicio'] = $suma_porrevisar_coordiandor_servicio;
        $data['total_atenciones_remotas'] = \App\instalacions::getdataRemote('SYNERGY', 'pendientes');




        return $data;
    }
    public function index_ins_ret()
    { {
            //SELECT TECNICOS
            $trabajadores = DB::table('personas')
                ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
                ->select(
                    'personas.nombre_uno',
                    'personas.apellido_uno',
                    'trabajadors.id'
                )
                ->where('trabajadors.estado', '=', '1')
                ->orderBy('trabajadors.id', 'desc')
                ->get();

            $datos_trabajador = DB::table('trabajadors')
                ->where('trabajadors.id_login', '=', Auth::user()->id)
                ->get();

            if (count($datos_trabajador) != 0) {
                $id_trabajador = $datos_trabajador[0]->id;
            } else {
                $id_trabajador = 0;
            }

            //$databases = $this->nombre_database();
                    $databases = App\bd_proveedores::selectDB();


            /** SECCION INSTALACION - RETIRO */
            $count_pendienteCoordinador = 0;
            $count_porasignarCoordinador = 0;
            $count_cursoCoordinador = 0;
            $count_porreasignarCoordinador = 0;
            $count_pendientes = 0;
            $count_curso = 0;
            $count_rechazado = 0;
            foreach ($databases as $los_datos) {
                //SELECT MODALS
                $datos_clientes[] = DB::connection(strtolower($los_datos->Database))->select('SELECT  clientes.razon_social as cliente, clientes.id FROM clientes WHERE clientes.id != 4');
                $datos_clientes_porasignar[] = DB::connection(strtolower($los_datos->Database))->select('SELECT instalacions.sCliente FROM instalacions UNION SELECT retiros.sCliente FROM retiros');

                //ESTADO PENDIENTE PARA COORDINADOR
                $retiros_pendientes_coordinador = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                    ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                    ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                    ->select(
                        'asignacion_retiros.id'
                    )
                    ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                    ->where('checklist_retiros.estado_inicio', '=', null);
                $instalacion_pendientes_coordinador = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                    ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select(
                        'asignacion_instalacions.id'
                    )
                    ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                    ->where('checklist_instalacions.estado_inicio', '=', null)
                    ->orderBy('fecha_visita', 'desc')
                    ->union($retiros_pendientes_coordinador)
                    ->count();

                $count_pendienteCoordinador += $instalacion_pendientes_coordinador;

                //ESTADO POR ASIGNAR PARA COORDINADOR
                $retiros_porasignar_coordinador = DB::connection(strtolower($los_datos->Database))->table('retiros')
                    ->select('retiros.id')
                    ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
                $instalacion_porasignar_coordinador = DB::connection(strtolower($los_datos->Database))->table('instalacions')
                    ->select('instalacions.id')
                    ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
                    ->union($retiros_porasignar_coordinador)
                    ->count();

                $count_porasignarCoordinador += $instalacion_porasignar_coordinador;

                //ESTADO EN CURSO PARA COORDIANDOR
                $retiros_curso_coordiandor =  DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                    ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                    ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                    ->select('asignacion_retiros.id')
                    ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                    ->where('checklist_retiros.estado_inicio', '=', 'activo');
                $instalacion_curso_coordiandor =  DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                    ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id')
                    ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                    ->where('checklist_instalacions.estado_inicio', '=', 'activo')
                    ->orderBy('fecha_visita', 'desc')
                    ->union($retiros_curso_coordiandor)
                    ->count();

                $count_cursoCoordinador += $instalacion_curso_coordiandor;

                //ESTADO POR REASIGNAR COORDINADOR PARA COORDIANDOR
                $retiros_porreasignar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                    ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                    ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                    ->select('asignacion_retiros.id')
                    ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');
                $instalacion_porreasignar_coordiandor = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                    ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id')
                    ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
                    ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
                    ->union($retiros_porreasignar_coordiandor)
                    ->count();

                $count_porreasignarCoordinador += $instalacion_porreasignar_coordiandor;

                //ESTADO PENDIENTE PARA TECNICO
                $retiros_pendientes = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                    ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                    ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                    ->select('asignacion_retiros.id')
                    ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                    ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada');
                $instalacion_pendientes = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                    ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select('asignacion_instalacions.id')
                    ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                    ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                    ->orderBy('fecha_visita', 'desc')
                    ->union($retiros_pendientes)
                    ->count();

                $count_pendientes += $instalacion_pendientes;

                //ESTADO EN CURSO PARA TECNICO
                $retiros_curso = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                    ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                    ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                    ->select(
                        'asignacion_retiros.id'
                    )
                    ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                    ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                    ->where('checklist_retiros.estado_inicio', '=', 'activo');
                $instalacion_curso = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                    ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select(
                        'asignacion_instalacions.id'
                    )
                    ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                    ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                    ->where('checklist_instalacions.estado_inicio', '=', 'activo')
                    ->orderBy('fecha_visita', 'desc')
                    ->union($retiros_curso)
                    ->count();

                $count_curso += $instalacion_curso;

                //ESTADO EN RECHAZADOS PARA TECNICO
                $retiros_rechazado = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                    ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                    ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                    ->select(
                        'asignacion_retiros.id'
                    )
                    ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                    ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado');
                $servicios_rechazados = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                    ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                    ->select('asignacion_solicitudes.id')
                    ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                        ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                    ->where('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                    ->where('api_solicitudes.estado_externo', '=', 'RECHAZADO')
                    ->where('asignacion_solicitudes.estado_interno', '=', 'RECHAZADO')
                    ->where('asignacion_solicitudes.estado_externo', '=', 'RECHAZADO')
                    ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
                $instalacion_rechazado = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                    ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                    ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                    ->select(
                        'asignacion_instalacions.id'
                    )
                    ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                    ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
                    ->orderBy('fecha_visita', 'desc')
                    ->union($servicios_rechazados)
                    ->union($retiros_rechazado)
                    ->count();

                $count_rechazado += $instalacion_rechazado;
            }
            $suma_pendientes_coordinador = $count_pendienteCoordinador;
            $suma_porasignar_coordinador = $count_porasignarCoordinador;
            $suma_encursos_coordiandor = $count_cursoCoordinador;
            $suma_porreasignars_coordiandor = $count_porreasignarCoordinador;
            //TECNICO
            $suma_pendientes = $count_pendientes;
            $suma_encursos = $count_curso;
            $suma_rechazado = $count_rechazado;


            return view('home_instalacionretiro', compact('suma_porreasignars_coordiandor', 'trabajadores', 'datos_clientes_porasignar', 'datos_clientes', 'suma_pendientes', 'suma_encursos', 'suma_rechazado', 'suma_pendientes_coordinador', 'suma_porasignar_coordinador', 'suma_encursos_coordiandor'));
        }
    }
    public function establecer_proveedor(Request $request)
    {
        $nombre_proveedores = DB::table('config_usuarios')
            ->select('id', 'nombre_proveedor', 'name_bd')
            ->where('estado', '=', 1)
            ->get();

        $nombre_DB = DB::connection()->getDatabaseName();
        return "ok";
    }

    /** FUNCION PARA REVISAR ATENCIONES PENDIENTES TECNICOS  */
    /** FUNCION PARA REVISAR ATENCIONES PENDIENTES TECNICOS  */
    public function revisar_pendiente_tecnico()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();

        foreach ($databases as $los_datos) {
            $retiros_pendientes = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'checklist_retiros.csSerie as serie',
                    'retiros.nFolio as sc',
                    'checklist_retiros.csComuna as comuna',
                    'checklist_retiros.csRegion as region',
                    'checklist_retiros.Cscliente as cliente',
                    'asignacion_retiros.tipo',
                    'asignacion_retiros.id',
                    DB::raw("NULL as estado_externo"),
                    'retiros.proveedor_retiro as proveedor',
                    DB::raw("NULL as sDescripcion"),
                    DB::raw("NULL as id_instalacion"),
                    DB::raw('null as idSala'),
                    'asignacion_retiros.retiros_id as id_historial',
                    DB::raw('null as Csmarca'),
                    DB::raw('null as id_solicitudes_remotas'),
                    DB::raw('null as zona_geoge'),
                    DB::raw('null as oficina'),



                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada');
            $servicio_pendientes = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
                ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                ->select(
                    'check_formulario_solicitudes.sSerie as serie',
                    'check_formulario_solicitudes.sSC as sc',
                    'check_formulario_solicitudes.sComuna as comuna',
                    'check_formulario_solicitudes.sRegion as region',
                    'check_formulario_solicitudes.sCliente as cliente',
                    'tracker.tipo_tracker as tipo',
                    'asignacion_solicitudes.id',
                    'asignacion_solicitudes.estado_externo',
                    'api_solicitudes.proveedor_servicio as proveedor',
                    'api_solicitudes.sDescripcion as sDescripcion',
                    DB::raw("NULL as id_instalacion"),
                    DB::raw('null as idSala'),
                    'asignacion_solicitudes.api_solicitudes_id as id_historial',
                    'check_formulario_solicitudes.Smarca as Csmarca',
                    'api_solicitudes.id_solicitudes_remotas',
                    'api_solicitudes.zona_geoge',
                    'api_solicitudes.oficina',


                    


                );
                if(Auth::user()->tipo == "interno"){
                    $servicio_pendientes->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
                }else{
                    $servicio_pendientes->where("api_solicitudes.tipo_asignacion_interna","=","0")
                        ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                    ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
                }
                
                //TRANSITO
                $servicio_pendientes->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                //EN ESPERA
                ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN ESPERA')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ESPERANDO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
                //INICIADO
                // ->orwhere('api_solicitudes.estado_interno', '=', 'INICIADO')
                // ->where('api_solicitudes.estado_externo', '=', 'INICIADO')
                // ->where('asignacion_solicitudes.estado_interno', '=', 'INICIADO')
                // ->where('asignacion_solicitudes.estado_externo', '=', 'INICIADO')
                // ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
            $instalacion_pendientes[] = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'checklist_instalacions.CsSerie as serie',
                    'checklist_instalacions.CsSc as sc',
                    'checklist_instalacions.Cscomuna as comuna',
                    'checklist_instalacions.Csregion as region',
                    'checklist_instalacions.Cscliente as cliente',
                    'asignacion_instalacions.tipo',
                    'asignacion_instalacions.id',

                    DB::raw("NULL as estado_externo"),
                    'instalacions.proveedor_instalacion as proveedor',
                    DB::raw("NULL as sDescripcion"),
                    'asignacion_instalacions.lista_instalacion_id as id_instalacion',
                    'checklist_instalacions.idSala',
                    'asignacion_instalacions.lista_instalacion_id as id_historial',
                    'checklist_instalacions.Csmarca',
                    DB::raw('null as id_solicitudes_remotas'),
                    DB::raw('null as zona_geoge'),
                    DB::raw('null as oficina'),



                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->union($servicio_pendientes)
                ->union($retiros_pendientes)
                ->get();
        }


        

        
        $table = "";
        for ($i = 0; $i < count($instalacion_pendientes); $i++) {
            foreach ($instalacion_pendientes[$i] as $d1) {

                $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")
                ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                ->where('solicitudes_remotas.id', $d1->id_solicitudes_remotas)->get();
                $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);

                    $color = $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]) ;

                if($color == "negro"){

                    $table .= "<tr style='color:white; background:#514E4D'>";

                }else{

                    $table .= "<tr style='background:$color '>";

                }




                $table .= "<td>" . $d1->zona_geoge  . "</td>";
                $table .= "<td>" . $getDataSla["minutosTotales"]  . "</td>";
                $table .= "<td>" . $getDataSla["tiempoTranscurrido"] . "</td>";
                $table .= "<td>" . $getDataSla["minutos_restantes"]  . "</td>";

                $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";

                if($d1->cliente == "KYOCERA"){
                     $razonSocial = "";
                     $tipo = "";
                    //  $instalacion_kyocera_pendientes = DB::connection('kyocera')->table('instalacions')

                    //  $razonsocialTipo =DB::connection($d1->proveedor)->table('instalacions')
                   $razonsocialTipo =DB::connection('kyocera')->table('instalacions')

                      ->select('razonSocial','tipo')
                      ->where('instalacions.id', '=', $d1->id_instalacion)
                    //  ////->where('softwares.id','!=',1)
                      ->get();

                     if( count($razonsocialTipo) != 0){
                         $razonSocial = $razonsocialTipo[0]->razonSocial;
                         $tipo = $razonsocialTipo[0]->tipo;
                     }else{
                        $tipo ="nanana";
                     }
                    $table .= "<td>" . strtoupper($tipo)  . "</td>";
                }else{
                    $table .= "<td>" . strtoupper($d1->tipo) . "</td>";
                }


                if($d1->cliente == "KYOCERA"){
                    $table .= "<td>" . strtoupper($razonSocial)  . "</td>";

                }else{
                    $table .= "<td>" . $d1->cliente . "</td>";

                }
                $table .= "<td>" . $d1->region . "</td>";
                $table .= "<td>" . $d1->comuna . "</td>";
                // $table .= "<td>" . $d1->idSala . "</td>";
                $table .= "<td>" . $d1->oficina . "</td>";
                
                $table .= "<td>" . $d1->Csmarca . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                // $table .= "<td> </td>";

                if ($d1->tipo == "retiro") {
                    $table .= "<td>NO REGISTRA </td>";
                } else {
                    if ($d1->sc == "") {
                        $table .= "<td>NO REGISTRA </td>";
                    } else {
                        $table .= "<td>" . $d1->sc . "</td>";
                    }
                }

                if ($d1->sDescripcion == "") {
                    $table .= "<td>NO REGISTRA </td>";
                } else {
                    $table .= "<td>" . $d1->sDescripcion . "</td>";
                }




                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                    <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" title="Editar" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                    </form>
                </td>';
                } else if ($d1->tipo == "instalacion") {
                    $table .=
                        '<td>
                    <form action="' . route('go.completando_check') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" title="Editar" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                    </form>
                </td>';
                } else if ($d1->tipo == "servicios") {
                    if ($d1->estado_externo == "ASIGNADO") {
                        $table .=
                            '<td>
                    <form action="' . route('iniciando.checklist.servicios_en_transito') . '" method="GET">
                        <input type="hidden" name="proveedor" value="' . $d1->proveedor . '">
                        <input type="hidden" name="idAsig" value="' . Crypt::encryptString($d1->id) . '">
                        <button class="btn"><span class="material-icons-round">local_shipping</span></button>
                    </form>
                    </td>';
                    } else if ($d1->estado_externo == "EN TRANSITO") {
                        $table .=
                            '<td><form action="' . route('iniciando.checklist.servicios_en_espera') . '" method="GET">
                        <input type="hidden" name="proveedor" value="' . $d1->proveedor . '">
                        <input type="hidden" name="idAsig" value="' . Crypt::encryptString($d1->id) . '">
                        <button class="btn"><span class="material-icons-round">factory</span></button>
                    </form>
                    </td>';
                    } else if ($d1->estado_externo == "ESPERANDO" || $d1->estado_externo == "INICIADO") {
                        $table .=
                            '<td><form action="' . route('go.iniciarchecservicio') . '" method="GET">
                        <input type="hidden" name="proveedor" value="' . $d1->proveedor . '">
                        <input type="hidden" name="idAsig" value="' . Crypt::encryptString($d1->id) . '">
                        <button class="btn"><span class="material-icons-round">play_arrow</span></button>
                    </form>
                    </td>';


                    }
                }
                //HISTORIAL

                if ($d1->tipo == "retiro") {
                    $table .='<td>
                    <a role="button" title="Historial" onclick="historial_retiro(' . $d1->id_historial . ',' . "'".$d1->proveedor ."'". ');" class="btn ver_historial_instalacion_home">
                        <span class="material-icons">history</span>
                      </a>
                        </td>';
                } else if ($d1->tipo == "instalacion") {
                    $table .='<td>
                    <a role="button" title="Historial" onclick="historial_instalacion(' . $d1->id_historial . ',' . "'".$d1->proveedor ."'". ');" class="btn ver_historial_instalacion_home">
                        <span class="material-icons">history</span>
                      </a>
                        </td>';
                } else if ($d1->tipo == "servicios") {
                    $table .='<td>
                    <a role="button" title="Historial" onclick="hola(' ."'" .$d1->id_historial."'," ."'".$d1->proveedor."'". ')" class="btn ver_historial_servicio_home">
                                        <img src="' . asset("Botones/Botones/Historial.png") . '" alt="" style="margin: 2px 0px" />
                                    </a>
                        </td>';
                 }


                $table .= "</tr>";
            }
        }

        return $table;
    }
    public function revisar_pendiente_tecnico_old_22_02_23()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();

        foreach ($databases as $los_datos) {
            $retiros_pendientes = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'checklist_retiros.csSerie as serie',
                    'retiros.nFolio as sc',
                    'checklist_retiros.csComuna as comuna',
                    'checklist_retiros.csRegion as region',
                    'checklist_retiros.Cscliente as cliente',
                    'asignacion_retiros.tipo',
                    'asignacion_retiros.id',
                    DB::raw("NULL as estado_externo"),
                    'retiros.proveedor_retiro as proveedor',
                    DB::raw("NULL as sDescripcion"),
                    DB::raw("NULL as id_instalacion"),
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada');
            $servicio_pendientes = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
                ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                ->select(
                    'check_formulario_solicitudes.sSerie as serie',
                    'check_formulario_solicitudes.sSC as sc',
                    'check_formulario_solicitudes.sComuna as comuna',
                    'check_formulario_solicitudes.sRegion as region',
                    'check_formulario_solicitudes.sCliente as cliente',
                    'tracker.tipo_tracker as tipo',
                    'asignacion_solicitudes.id',
                    'asignacion_solicitudes.estado_externo',
                    'api_solicitudes.proveedor_servicio as proveedor',
                    'api_solicitudes.sDescripcion as sDescripcion',
                    DB::raw("NULL as id_instalacion"),

                )
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                //TRANSITO
                ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                //EN ESPERA
                ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN ESPERA')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ESPERANDO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                //INICIADO
                ->orwhere('api_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('api_solicitudes.estado_externo', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_externo', '=', 'INICIADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
            $instalacion_pendientes[] = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'checklist_instalacions.CsSerie as serie',
                    'checklist_instalacions.CsSc as sc',
                    'checklist_instalacions.Cscomuna as comuna',
                    'checklist_instalacions.Csregion as region',
                    'checklist_instalacions.Cscliente as cliente',
                    'asignacion_instalacions.tipo',
                    'asignacion_instalacions.id',

                    DB::raw("NULL as estado_externo"),
                    'instalacions.proveedor_instalacion as proveedor',
                    DB::raw("NULL as sDescripcion"),
                    'asignacion_instalacions.lista_instalacion_id as id_instalacion',


                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->union($servicio_pendientes)
                ->union($retiros_pendientes)
                ->get();
        }
        $table = "";
        for ($i = 0; $i < count($instalacion_pendientes); $i++) {
            foreach ($instalacion_pendientes[$i] as $d1) {
                $table .= "<tr>";
                $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";

                if($d1->cliente == "KYOCERA"){
                     $razonSocial = "";
                     $tipo = "";
                    //  $instalacion_kyocera_pendientes = DB::connection('kyocera')->table('instalacions')

                    // $razonsocialTipo =DB::connection($d1->proveedor)->table('instalacions')
                    $razonsocialTipo =DB::connection("kyocera")->table('instalacions')
                    // $razonsocialTipo =DB::connection($d1->proveedor)->table('instalacions')

                    ->select('razonSocial','tipo')
                      ->where('instalacions.id', '=', $d1->id_instalacion)
                    //  ////->where('softwares.id','!=',1)
                      ->get();

                     if( count($razonsocialTipo) != 0){
                         $razonSocial = $razonsocialTipo[0]->razonSocial;
                         $tipo = $razonsocialTipo[0]->tipo;
                     }else{
                        $tipo ="nanana";
                     }
                    $table .= "<td>" . strtoupper($tipo)  . "</td>";
                }else{
                    $table .= "<td>" . strtoupper($d1->tipo) . "</td>";
                }


                if($d1->cliente == "KYOCERA"){
                    $table .= "<td>" . strtoupper($razonSocial)  . "</td>";

                }else{
                    $table .= "<td>" . $d1->cliente . "</td>";

                }
                $table .= "<td>" . $d1->region . "</td>";
                $table .= "<td>" . $d1->comuna . "</td>";
                $table .= "<td>" . $d1->serie . "</td>";
                // $table .= "<td> </td>";

                if ($d1->tipo == "retiro") {
                    $table .= "<td>NO REGISTRA </td>";
                } else {
                    if ($d1->sc == "") {
                        $table .= "<td>NO REGISTRA </td>";
                    } else {
                        $table .= "<td>" . $d1->sc . "</td>";
                    }
                }

                if ($d1->sDescripcion == "") {
                    $table .= "<td>NO REGISTRA </td>";
                } else {
                    $table .= "<td>" . $d1->sDescripcion . "</td>";
                }




                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                    <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" title="Editar" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                    </form>
                </td>';
                } else if ($d1->tipo == "instalacion") {
                    $table .=
                        '<td>
                    <form action="' . route('go.completando_check') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" title="Editar" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                    </form>
                </td>';
                } else if ($d1->tipo == "servicios") {
                    if ($d1->estado_externo == "ASIGNADO") {
                        $table .=
                            '<td>
                    <form action="' . route('iniciando.checklist.servicios_en_transito') . '" method="GET">
                        <input type="hidden" name="proveedor" value="' . $d1->proveedor . '">
                        <input type="hidden" name="idAsig" value="' . Crypt::encryptString($d1->id) . '">
                        <button class="btn"><span class="material-icons-round">local_shipping</span></button>
                    </form>
                    </td>';
                    } else if ($d1->estado_externo == "EN TRANSITO") {
                        $table .=
                            '<td><form action="' . route('iniciando.checklist.servicios_en_espera') . '" method="GET">
                        <input type="hidden" name="proveedor" value="' . $d1->proveedor . '">
                        <input type="hidden" name="idAsig" value="' . Crypt::encryptString($d1->id) . '">
                        <button class="btn"><span class="material-icons-round">factory</span></button>
                    </form>
                    </td>';
                    } else if ($d1->estado_externo == "ESPERANDO" || $d1->estado_externo == "INICIADO") {
                        $table .=
                            '<td><form action="' . route('go.iniciarchecservicio') . '" method="GET">
                        <input type="hidden" name="proveedor" value="' . $d1->proveedor . '">
                        <input type="hidden" name="idAsig" value="' . Crypt::encryptString($d1->id) . '">
                        <button class="btn"><span class="material-icons-round">play_arrow</span></button>
                    </form>
                    </td>';
                    }
                }
                $table .= "</tr>";
            }
        }

        return $table;
    }

    public function revisar_pendiente_tecnico_old()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();

        foreach ($databases as $los_datos) {
            $retiros_pendientes = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'checklist_retiros.csSerie as serie',
                    'retiros.nFolio as sc',
                    'checklist_retiros.csComuna as comuna',
                    'checklist_retiros.csRegion as region',
                    'checklist_retiros.Cscliente as cliente',
                    'asignacion_retiros.tipo',
                    'asignacion_retiros.id',
                    DB::raw("NULL as estado_externo"),
                    'retiros.proveedor_retiro as proveedor',
                    DB::raw("NULL as sDescripcion"),
                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada');
            $servicio_pendientes = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
                ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                ->select(
                    'check_formulario_solicitudes.sSerie as serie',
                    'check_formulario_solicitudes.sSC as sc',
                    'check_formulario_solicitudes.sComuna as comuna',
                    'check_formulario_solicitudes.sRegion as region',
                    'check_formulario_solicitudes.sCliente as cliente',
                    'tracker.tipo_tracker as tipo',
                    'asignacion_solicitudes.id',
                    'asignacion_solicitudes.estado_externo',
                    'api_solicitudes.proveedor_servicio as proveedor',
                    'api_solicitudes.sDescripcion as sDescripcion'

                )
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                //TRANSITO
                ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                //EN ESPERA
                ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN ESPERA')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ESPERANDO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador)
                //INICIADO
                ->orwhere('api_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('api_solicitudes.estado_externo', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_externo', '=', 'INICIADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
            $instalacion_pendientes[] = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'checklist_instalacions.CsSerie as serie',
                    'checklist_instalacions.CsSc as sc',
                    'checklist_instalacions.Cscomuna as comuna',
                    'checklist_instalacions.Csregion as region',
                    'checklist_instalacions.Cscliente as cliente',
                    'asignacion_instalacions.tipo',
                    'asignacion_instalacions.id',
                    DB::raw("NULL as estado_externo"),
                    'instalacions.proveedor_instalacion as proveedor',
                    DB::raw("NULL as sDescripcion"),
                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->union($servicio_pendientes)
                ->union($retiros_pendientes)
                ->get();
        }
        $table = "";
        for ($i = 0; $i < count($instalacion_pendientes); $i++) {
            foreach ($instalacion_pendientes[$i] as $d1) {
                $table .= "<tr>";
                $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
                $table .= "<td>" . $d1->tipo . "</td>";
                $table .= "<td>" . $d1->cliente . "</td>";
                $table .= "<td>" . $d1->region . "</td>";
                $table .= "<td>" . $d1->comuna . "</td>";
                $table .= "<td>" . $d1->serie . "</td>";
                // $table .= "<td>" . "". "</td>";
                if ($d1->tipo == "retiro") {
                    $table .= "<td>NO REGISTRA </td>";
                } else {
                    if ($d1->sc == "") {
                        $table .= "<td>NO REGISTRA </td>";
                    } else {
                        $table .= "<td>" . $d1->sc . "</td>";
                    }
                }
                $table .= "<td>" . $d1->sDescripcion . "</td>";
                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                    <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" title="Editar" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                    </form>
                </td>';
                } else if ($d1->tipo == "instalacion") {
                    $table .=
                        '<td>
                    <form action="' . route('go.completando_check') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" title="Editar" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                    </form>
                </td>';
                } else if ($d1->tipo == "servicios") {
                    if ($d1->estado_externo == "ASIGNADO") {
                        $table .=
                            '<td>
                    <form action="' . route('iniciando.checklist.servicios_en_transito') . '" method="GET">
                        <input type="hidden" name="proveedor" value="' . $d1->proveedor . '">
                        <input type="hidden" name="idAsig" value="' . Crypt::encryptString($d1->id) . '">
                        <button class="btn"><span class="material-icons-round">local_shipping</span></button>
                    </form>
                    </td>';
                    } else if ($d1->estado_externo == "EN TRANSITO") {
                        $table .=
                            '<td><form action="' . route('iniciando.checklist.servicios_en_espera') . '" method="GET">
                        <input type="hidden" name="proveedor" value="' . $d1->proveedor . '">
                        <input type="hidden" name="idAsig" value="' . Crypt::encryptString($d1->id) . '">
                        <button class="btn"><span class="material-icons-round">factory</span></button>
                    </form>
                    </td>';
                    } else if ($d1->estado_externo == "ESPERANDO" || $d1->estado_externo == "INICIADO") {
                        $table .=
                            '<td><form action="' . route('go.iniciarchecservicio') . '" method="GET">
                        <input type="hidden" name="proveedor" value="' . $d1->proveedor . '">
                        <input type="hidden" name="idAsig" value="' . Crypt::encryptString($d1->id) . '">
                        <button class="btn"><span class="material-icons-round">play_arrow</span></button>
                    </form>
                    </td>';
                    }
                }
                $table .= "</tr>";
            }
        }

        return $table;
    }
     /** FUNCION PARA REVISAR ATENCIONES EN CURSO TECNICO */
     public function revisar_finalizadas_coordinador()
     {
        $datos_trabajador = DB::table('trabajadors')
        ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
        ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
        ->where('trabajadors.id_login', '=', Auth::user()->id)
        ->get();

        $servicio_encurso = DB::table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
                 ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                 ->select(
                     'check_formulario_solicitudes.sSerie as serie',
                     'check_formulario_solicitudes.sSC as sc',
                     'check_formulario_solicitudes.sComuna as comuna',
                     'check_formulario_solicitudes.sRegion as region',
                     'check_formulario_solicitudes.sCliente as cliente',
                     'tracker.tipo_tracker as tipo',
                     'asignacion_solicitudes.id',
                     'api_solicitudes.proveedor_servicio as proveedor',
                     'api_solicitudes.sDescripcion as sDescripcion',
                     'asignacion_solicitudes.api_solicitudes_id as id_historial',
                     'check_formulario_solicitudes.Smarca as Csmarca',
                     'check_formulario_solicitudes.observaciones as observacionestecnico',
 
 
                 );

                 $servicio_encurso->where("api_solicitudes.tipo_asignacion_interna","=","0")
                 ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

             ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
             ->where('api_solicitudes.estado_externo', '=', 'FINALIZADO')
             ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
             ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO');

             $dataEnCurso =   $servicio_encurso->get();

             $table = "";
            //  for ($i = 0; $i < count($dataEnCurso); $i++) {
                 foreach ($dataEnCurso as $d1) {
                     $table .= "<tr>";
                     $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
                     $table .= "<td>" . $d1->tipo . "</td>";
                     $table .= "<td>" . $d1->cliente . "</td>";
                     $table .= "<td>" . $d1->Csmarca . "</td>";
     
                     $table .= "<td>" . $d1->serie . "</td>";
                     if ($d1->tipo == "retiro") {
                         $table .= "<td>NO REGISTRA </td>";
                     } else {
                         if ($d1->sc == "") {
                             $table .= "<td>NO REGISTRA </td>";
                         } else {
                             $table .= "<td>" . $d1->sc . "</td>";
                         }
                     }
                     $table .= "<td>" . $d1->sDescripcion . "</td>";
                     $table .= "<td>" . $d1->observacionestecnico . "</td>";
                     $table .= "<td>" .    "<a target='_blank' href='" . route('generar.pdfProveedorServicios', Crypt::encryptString($d1->id)) . "' role='button' title='PDF'>";
                     $table .= "<span class='material-icons-round'>picture_as_pdf</span>";
                     $table .= "</a>" . "</td>";
     
                   
     
           
                     $table .= "</tr>";
                 }
            //  }
     
             return $table;
            //  ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
    }

     public function revisar_finalizadas_tecnico_interno()
     {
         $datos_trabajador = DB::table('trabajadors')
             ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
             ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
             ->where('trabajadors.id_login', '=', Auth::user()->id)
             ->get();
 
         $id_trabajador = $datos_trabajador[0]->id;
 
         //$databases = $this->nombre_database();
                 $databases = App\bd_proveedores::selectDB();
 
 
         //ESTADO ENCURSO TECNICO
         foreach ($databases as $los_datos) {
             $retiros_encurso = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                 ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                 ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                 ->select(
                     'checklist_retiros.csSerie as serie',
                     'retiros.nFolio as sc',
                     'checklist_retiros.csComuna as comuna',
                     'checklist_retiros.csRegion as region',
                     'checklist_retiros.Cscliente as cliente',
                     'asignacion_retiros.tipo',
                     'asignacion_retiros.id',
                     'retiros.proveedor_retiro as proveedor',
                     DB::raw("NULL as sDescripcion"),
                     'asignacion_retiros.retiros_id as id_historial',
                     DB::raw("NULL as Csmarca"),
                     DB::raw("NULL as observacionestecnico"),

 
                 )
                 ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                 ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                 ->where('checklist_retiros.estado_inicio', '=', 'activo');
             $servicio_encurso = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
                 ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                 ->select(
                     'check_formulario_solicitudes.sSerie as serie',
                     'check_formulario_solicitudes.sSC as sc',
                     'check_formulario_solicitudes.sComuna as comuna',
                     'check_formulario_solicitudes.sRegion as region',
                     'check_formulario_solicitudes.sCliente as cliente',
                     'tracker.tipo_tracker as tipo',
                     'asignacion_solicitudes.id',
                     'api_solicitudes.proveedor_servicio as proveedor',
                     'api_solicitudes.sDescripcion as sDescripcion',
                     'asignacion_solicitudes.api_solicitudes_id as id_historial',
                     'check_formulario_solicitudes.Smarca as Csmarca',
                     'check_formulario_solicitudes.observaciones as observacionestecnico',
 
 
                 );
                 //TRANSITO
                 if(Auth::user()->tipo == "interno"){
                     $servicio_encurso->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
                     ->where('api_solicitudes.estado_externo', '=', 'FINALIZADO')
                     ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
                     ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO')
                     ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
                  }else{
                     $servicio_encurso->where("api_solicitudes.tipo_asignacion_interna","=","0")
                         ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                     ->where('api_solicitudes.estado_interno', '=', 'FINALIZADO')
                     ->where('api_solicitudes.estado_externo', '=', 'FINALIZADO')
                     ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
                     ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO')
                     ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
                  }
                
 
 
 
 
 
             $instalacion_encurso[]  = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                 ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                 ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                 ->select(
                     'checklist_instalacions.CsSerie as serie',
                     'checklist_instalacions.CsSc as sc',
                     'checklist_instalacions.Cscomuna as comuna',
                     'checklist_instalacions.Csregion as region',
                     'checklist_instalacions.Cscliente as cliente',
                     'asignacion_instalacions.tipo',
                     'asignacion_instalacions.id',
                     'instalacions.proveedor_instalacion as proveedor',
                     DB::raw("NULL as sDescripcion"),
                     'asignacion_instalacions.lista_instalacion_id as id_historial',
                     'checklist_instalacions.Csmarca',
                     DB::raw("NULL as observacionestecnico"),
                     
 
                 )
                 ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                 ->where('asignacion_instalacions.estado_asignacion', '=', 'FINALIZADO')
                 ->where('checklist_instalacions.estado_inicio', '=', 'FINALIZADO')
                 ->union($servicio_encurso)
                 ->union($retiros_encurso)
                 ->get();
         }
         $table = "";
         for ($i = 0; $i < count($instalacion_encurso); $i++) {
             foreach ($instalacion_encurso[$i] as $d1) {
                 $table .= "<tr>";
                 $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
                 $table .= "<td>" . $d1->tipo . "</td>";
                 $table .= "<td>" . $d1->cliente . "</td>";
                 $table .= "<td>" . $d1->Csmarca . "</td>";
 
                 $table .= "<td>" . $d1->serie . "</td>";
                 if ($d1->tipo == "retiro") {
                     $table .= "<td>NO REGISTRA </td>";
                 } else {
                     if ($d1->sc == "") {
                         $table .= "<td>NO REGISTRA </td>";
                     } else {
                         $table .= "<td>" . $d1->sc . "</td>";
                     }
                 }
                 $table .= "<td>" . $d1->sDescripcion . "</td>";
                 $table .= "<td>" . $d1->observacionestecnico . "</td>";
                 $table .= "<td>" .    "<a target='_blank' href='" . route('generar.pdfProveedorServicios', Crypt::encryptString($d1->id)) . "' role='button' title='PDF'>";
                 $table .= "<span class='material-icons-round'>picture_as_pdf</span>";
                 $table .= "</a>" . "</td>";
 
               
 
       
                 $table .= "</tr>";
             }
         }
 
         return $table;
     }

     public function revisar_rechazadas_tecnico_interno()
     {
         $datos_trabajador = DB::table('trabajadors')
             ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
             ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
             ->where('trabajadors.id_login', '=', Auth::user()->id)
             ->get();
 
         $id_trabajador = $datos_trabajador[0]->id;
 
         //$databases = $this->nombre_database();
                 $databases = App\bd_proveedores::selectDB();
 
 
         //ESTADO ENCURSO TECNICO
         foreach ($databases as $los_datos) {
             $retiros_encurso = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                 ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                 ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                 ->select(
                     DB::raw("NULL as motivo_rechazo"),

                     'checklist_retiros.csSerie as serie',
                     'retiros.nFolio as sc',
                     'checklist_retiros.csComuna as comuna',
                     'checklist_retiros.csRegion as region',
                     'checklist_retiros.Cscliente as cliente',
                     'asignacion_retiros.tipo',
                     'asignacion_retiros.id',
                     'retiros.proveedor_retiro as proveedor',
                     DB::raw("NULL as sDescripcion"),
                     'asignacion_retiros.retiros_id as id_historial',
                     DB::raw("NULL as Csmarca"),
                     DB::raw("NULL as observacionestecnico"),

 
                 )
                 ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                 ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                 ->where('checklist_retiros.estado_inicio', '=', 'activo');
             $servicio_encurso = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                 ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                 ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
                 ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                 ->select(
                    'asignacion_solicitudes.motivo_rechazo',

                     'check_formulario_solicitudes.sSerie as serie',
                     'check_formulario_solicitudes.sSC as sc',
                     'check_formulario_solicitudes.sComuna as comuna',
                     'check_formulario_solicitudes.sRegion as region',
                     'check_formulario_solicitudes.sCliente as cliente',
                     'tracker.tipo_tracker as tipo',
                     'asignacion_solicitudes.id',
                     'api_solicitudes.proveedor_servicio as proveedor',
                     'api_solicitudes.sDescripcion as sDescripcion',
                     'asignacion_solicitudes.api_solicitudes_id as id_historial',
                     'check_formulario_solicitudes.Smarca as Csmarca',
                     'check_formulario_solicitudes.observaciones as observacionestecnico',
 
 
                 );
                 //TRANSITO
                 if(Auth::user()->tipo == "interno"){
                     $servicio_encurso->where('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                     ->where('api_solicitudes.estado_externo', '=', 'RECHAZADO')
                     ->where('asignacion_solicitudes.estado_interno', '=', 'RECHAZADO')
                     ->where('asignacion_solicitudes.estado_externo', '=', 'RECHAZADO')
                     ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
                  }else{
                     $servicio_encurso->where("api_solicitudes.tipo_asignacion_interna","=","0")
                         ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                     ->where('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                     ->where('api_solicitudes.estado_externo', '=', 'RECHAZADO')
                     ->where('asignacion_solicitudes.estado_interno', '=', 'RECHAZADO')
                     ->where('asignacion_solicitudes.estado_externo', '=', 'RECHAZADO')
                     ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
                  }
                
 
 
 
 
 
             $instalacion_encurso[]  = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                 ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                 ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                 ->select(
                    DB::raw("NULL as motivo_rechazo"),

                     'checklist_instalacions.CsSerie as serie',
                     'checklist_instalacions.CsSc as sc',
                     'checklist_instalacions.Cscomuna as comuna',
                     'checklist_instalacions.Csregion as region',
                     'checklist_instalacions.Cscliente as cliente',
                     'asignacion_instalacions.tipo',
                     'asignacion_instalacions.id',
                     
                     'instalacions.proveedor_instalacion as proveedor',
                     DB::raw("NULL as sDescripcion"),
                     'asignacion_instalacions.lista_instalacion_id as id_historial',
                     'checklist_instalacions.Csmarca',
                     DB::raw("NULL as observacionestecnico"),
                     
 
                 )
                 ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                 ->where('asignacion_instalacions.estado_asignacion', '=', 'RECHAZADO')
                 ->where('checklist_instalacions.estado_inicio', '=', 'RECHAZADO')
                 ->union($servicio_encurso)
                 ->union($retiros_encurso)
                 ->get();
         }
         $table = "";
         for ($i = 0; $i < count($instalacion_encurso); $i++) {
             foreach ($instalacion_encurso[$i] as $d1) {
                 $table .= "<tr>";
                 $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
                 $table .= "<td>" . $d1->tipo . "</td>";
                 $table .= "<td>" . $d1->cliente . "</td>";
                 $table .= "<td>" . $d1->Csmarca . "</td>";
 
                 $table .= "<td>" . $d1->serie . "</td>";
                 if ($d1->tipo == "retiro") {
                     $table .= "<td>NO REGISTRA </td>";
                 } else {
                     if ($d1->sc == "") {
                         $table .= "<td>NO REGISTRA </td>";
                     } else {
                         $table .= "<td>" . $d1->sc . "</td>";
                     }
                 }
                 $table .= "<td>" . $d1->sDescripcion . "</td>";
                 $table .= "<td>" . $d1->observacionestecnico . "</td>";
                 $table .= "<td>" . $d1->motivo_rechazo . "</td>";

                 $table .= '<td>';
                 $table .= '<form action="' . route('go.iniciarchecservicio') . '" method="GET">';
                 $table .= '<input type="hidden" name="proveedor" value="' . htmlspecialchars($d1->proveedor) . '">';
                 $table .= '<input type="hidden" name="idAsig" value="' . htmlspecialchars(Crypt::encryptString($d1->id)) . '">';
                 $table .= '<button type="submit" class="btn"><span title="Iniciar" class="material-icons-round">play_arrow</span></button>';
                 $table .= '</form>';
                 $table .= '</td>';
 
       
                 $table .= "</tr>";
             }
         }
 
         return $table;
     }
    /** FUNCION PARA REVISAR ATENCIONES EN CURSO TECNICO */
    public function revisar_encurso_tecnico()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        //ESTADO ENCURSO TECNICO
        foreach ($databases as $los_datos) {
            $retiros_encurso = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'checklist_retiros.csSerie as serie',
                    'retiros.nFolio as sc',
                    'checklist_retiros.csComuna as comuna',
                    'checklist_retiros.csRegion as region',
                    'checklist_retiros.Cscliente as cliente',
                    'asignacion_retiros.tipo',
                    'asignacion_retiros.id',
                    'retiros.proveedor_retiro as proveedor',
                    DB::raw("NULL as sDescripcion"),
                    'asignacion_retiros.retiros_id as id_historial',
                    DB::raw("NULL as Csmarca"),

                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_inicio', '=', 'activo');
            $servicio_encurso = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
                ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                ->select(
                    'check_formulario_solicitudes.sSerie as serie',
                    'check_formulario_solicitudes.sSC as sc',
                    'check_formulario_solicitudes.sComuna as comuna',
                    'check_formulario_solicitudes.sRegion as region',
                    'check_formulario_solicitudes.sCliente as cliente',
                    'tracker.tipo_tracker as tipo',
                    'asignacion_solicitudes.id',
                    'api_solicitudes.proveedor_servicio as proveedor',
                    'api_solicitudes.sDescripcion as sDescripcion',
                    'asignacion_solicitudes.api_solicitudes_id as id_historial',
                    'check_formulario_solicitudes.Smarca as Csmarca',


                );
                //TRANSITO
                if(Auth::user()->tipo == "interno"){
                    $servicio_encurso->where('api_solicitudes.estado_interno', '=', 'INICIADO')
                    ->where('api_solicitudes.estado_externo', '=', 'INICIADO')
                    ->where('asignacion_solicitudes.estado_interno', '=', 'INICIADO')
                    ->where('asignacion_solicitudes.estado_externo', '=', 'INICIADO')
                    ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
                 }else{
                    $servicio_encurso->where("api_solicitudes.tipo_asignacion_interna","=","0")
                        ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                    ->where('api_solicitudes.estado_interno', '=', 'INICIADO')
                    ->where('api_solicitudes.estado_externo', '=', 'INICIADO')
                    ->where('asignacion_solicitudes.estado_interno', '=', 'INICIADO')
                    ->where('asignacion_solicitudes.estado_externo', '=', 'INICIADO')
                    ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
                 }
               





            $instalacion_encurso[]  = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'checklist_instalacions.CsSerie as serie',
                    'checklist_instalacions.CsSc as sc',
                    'checklist_instalacions.Cscomuna as comuna',
                    'checklist_instalacions.Csregion as region',
                    'checklist_instalacions.Cscliente as cliente',
                    'asignacion_instalacions.tipo',
                    'asignacion_instalacions.id',
                    'instalacions.proveedor_instalacion as proveedor',
                    DB::raw("NULL as sDescripcion"),
                    'asignacion_instalacions.lista_instalacion_id as id_historial',
                    'checklist_instalacions.Csmarca',

                )
                ->where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '=', 'activo')
                ->union($servicio_encurso)
                ->union($retiros_encurso)
                ->get();
        }
        $table = "";
        for ($i = 0; $i < count($instalacion_encurso); $i++) {
            foreach ($instalacion_encurso[$i] as $d1) {
                $table .= "<tr>";
                $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
                $table .= "<td>" . $d1->tipo . "</td>";
                $table .= "<td>" . $d1->cliente . "</td>";
                $table .= "<td>" . $d1->Csmarca . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                if ($d1->tipo == "retiro") {
                    $table .= "<td>NO REGISTRA </td>";
                } else {
                    if ($d1->sc == "") {
                        $table .= "<td>NO REGISTRA </td>";
                    } else {
                        $table .= "<td>" . $d1->sc . "</td>";
                    }
                }
                $table .= "<td>" . $d1->sDescripcion . "</td>";

                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                        <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" title="Editar" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
                } else if ($d1->tipo == "instalacion") {
                    $table .=
                        '<td>
                        <form action="' . route('go.completando_check') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" title="Editar" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
                } else if ($d1->tipo == "servicios") {
                    $table .=
                        '<td>
                        <form action="' . route('go.iniciarchecservicio') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . Crypt::encryptString($d1->id) . '" name="idAsig">
                            <button type="submit" title="Editar" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
                }

       //HISTORIAL
                if ($d1->tipo == "retiro") {
                    $table .='<td>
                    <a role="button" title="Historial" onclick="historial_retiro(' . $d1->id_historial . ',' . "'".$d1->proveedor ."'". ');" class="btn ver_historial_instalacion_home">
                        <span class="material-icons">history</span>
                      </a>
                        </td>';
                } else if ($d1->tipo == "instalacion") {
                    $table .='<td>
                    <a role="button" title="Historial" onclick="historial_instalacion(' . $d1->id_historial . ',' . "'".$d1->proveedor ."'". ');" class="btn ver_historial_instalacion_home">
                        <span class="material-icons">history</span>
                      </a>
                        </td>';
                } else if ($d1->tipo == "servicios") {
                    $table .='<td>
                    <a role="button" title="Historial" onclick="hola(' ."'" .$d1->id_historial."'," ."'".$d1->proveedor."'". ')" class="btn ver_historial_servicio_home">
                                        <img src="' . asset("Botones/Botones/Historial.png") . '" alt="" style="margin: 2px 0px" />
                                    </a>
                        </td>';
                 }
                $table .= "</tr>";
            }
        }

        return $table;
    }
    /** FUNCION PARA REVISAR ATENCIONES RECHAZADAS TECNICO */
    public function revisar_rechazados_tecnico()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();

        foreach ($databases as $los_datos) {

            //ESTADO PENDIENTE PARA TECNICO
            $retiros_rechazados = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->select(
                    'checklist_retiros.csSerie as serie',
                    'retiros.nFolio as sc',
                    'checklist_retiros.csComuna as comuna',
                    'checklist_retiros.csRegion as region',
                    'checklist_retiros.Cscliente as cliente',
                    'asignacion_retiros.tipo',
                    'asignacion_retiros.id',
                    'retiros.proveedor_retiro as proveedor',
                    DB::raw("NULL as sDescripcion"),
                    'asignacion_retiros.retiros_id as id_historial',
                    DB::raw("NULL as Csmarca"),


                )
                ->where('asignacion_retiros.trabajadors_idtecnico', '=', $id_trabajador)
                ->where('asignacion_retiros.estado_asignacion', '=', 'rechazado');
            $servicio_rechazados = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->join('check_formulario_solicitudes', 'check_formulario_solicitudes.id', '=', 'asignacion_solicitudes.check_formulario_solicitudes_id')
                ->join('tracker', 'tracker.id', '=', 'api_solicitudes.tracker_idtracker')
                ->select(
                    'check_formulario_solicitudes.sSerie as serie',
                    'check_formulario_solicitudes.sSC as sc',
                    'check_formulario_solicitudes.sComuna as comuna',
                    'check_formulario_solicitudes.sRegion as region',
                    'check_formulario_solicitudes.sCliente as cliente',
                    'tracker.tipo_tracker as tipo',
                    'asignacion_solicitudes.id',
                    'api_solicitudes.proveedor_servicio as proveedor',
                    'api_solicitudes.sDescripcion as sDescripcion',
                    'asignacion_solicitudes.api_solicitudes_id as id_historial',
                    'check_formulario_solicitudes.Smarca as Csmarca',


                )
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'RECHAZADO')
                ->where('api_solicitudes.estado_externo', '=', 'RECHAZADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'RECHAZADO')
                ->where('asignacion_solicitudes.estado_externo', '=', 'RECHAZADO')
                ->where('asignacion_solicitudes.trabajadors_id', '=', $id_trabajador);
            $instalacion_rechazados[] = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->select(
                    'checklist_instalacions.CsSerie as serie',
                    'checklist_instalacions.CsSc as sc',
                    'checklist_instalacions.Cscomuna as comuna',
                    'checklist_instalacions.Csregion as region',
                    'checklist_instalacions.Cscliente as cliente',
                    'asignacion_instalacions.tipo',
                    'asignacion_instalacions.id',
                    'instalacions.proveedor_instalacion as proveedor',
                    DB::raw("NULL as sDescripcion"),
                    // 'asignacion_instalacions.api_solicitudes_id as id_historial',
                    'asignacion_instalacions.lista_instalacion_id as id_historial',
                    'checklist_instalacions.Csmarca',


                )
                ->Where('asignacion_instalacions.trabajadors_id', '=', $id_trabajador)
                ->where('asignacion_instalacions.estado_asignacion', '=', 'rechazado')
                ->union($retiros_rechazados)
                ->union($servicio_rechazados)
                ->get();
        }

        $table = "";
        for ($i = 0; $i < count($instalacion_rechazados); $i++) {
            foreach ($instalacion_rechazados[$i] as $d1) {
                $table .= "<tr>";
                $table .= "<td>" . $datos_trabajador[0]->nombre_uno . "" . $datos_trabajador[0]->apellido_uno . "</td>";
                $table .= "<td>" . $d1->tipo . "</td>";
                $table .= "<td>" . $d1->cliente . "</td>";
                $table .= "<td>" . $d1->region . "</td>";
                $table .= "<td>" . $d1->Csmarca . "</td>";

                $table .= "<td>" . $d1->comuna . "</td>";
                $table .= "<td>" . $d1->serie . "</td>";
                if ($d1->tipo == "retiro") {
                    $table .= "<td>NO REGISTRA </td>";
                } else {
                    if ($d1->sc == "") {
                        $table .= "<td>NO REGISTRA </td>";
                    } else {
                        $table .= "<td>" . $d1->sc . "</td>";
                    }
                }
                $table .= "<td>" . $d1->sDescripcion . "</td>";

                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                        <form action="' . route('go.ChecklistRetiros') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" title="Editar" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
                } else if ($d1->tipo == "instalacion") {
                    $table .=
                        '<td>
                        <form action="' . route('go.completando_check') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit"  title="Editar" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
                } else {
                    $table .=
                        '<td>
                        <form action="' . route('go.iniciarchecservicio') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . Crypt::encryptString($d1->id) . '" name="idAsig">
                            <button type="submit"  title="Editar" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
                }



                if ($d1->tipo == "retiro") {
                    $table .='<td>
                    <a role="button" title="Historial" onclick="historial_retiro(' . $d1->id_historial . ',' . "'".$d1->proveedor ."'". ');" class="btn ver_historial_instalacion_home">
                        <span class="material-icons">history</span>
                      </a>
                        </td>';
                } else if ($d1->tipo == "instalacion") {
                    $table .='<td>
                    <a role="button" title="Historial" onclick="historial_instalacion(' . $d1->id_historial . ',' . "'".$d1->proveedor ."'". ');" class="btn ver_historial_instalacion_home">
                        <span class="material-icons">history</span>
                      </a>
                        </td>';
                } else if ($d1->tipo == "servicios") {
                    $table .='<td>
                    <a role="button" title="Historial" onclick="hola(' ."'" .$d1->id_historial."'," ."'".$d1->proveedor."'". ')" class="btn ver_historial_servicio_home">
                                        <img src="' . asset("Botones/Botones/Historial.png") . '" alt="" style="margin: 2px 0px" />
                                    </a>
                        </td>';
                 }
                $table .= "</tr>";
            }
        }

        return $table;
    }
    /** FUNCION PARA REVISAR ATENCIONES POR ASIGNAR COORDINADOR  */
    public function revisar_porasignar()
    {


                        $databases = App\bd_proveedores::selectDB();

        foreach ($databases as $los_datos) {

        $retiros_comtecglobal_pendientes = DB::connection(strtolower($los_datos->Database))->table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->select(
                'retiros.proveedor_retiro as proveedor',
                'tracker.tipo_tracker as tipo',
                'retiros.sCliente as cliente',
                'retiros.sRegion',
                'retiros.sComuna',
                'retiros.sSerie',
                'retiros.id',
                DB::raw('null as idSala'),
                DB::raw('null as Csmarca')


            )
            ->where('retiros.sCliente', '<>', 'kyocera')

            ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
        $instalacion_comtecglobal_pendientes[] = DB::connection(strtolower($los_datos->Database))->table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->select(
                'instalacions.proveedor_instalacion as proveedor',
                'tracker.tipo_tracker as tipo',
                'instalacions.sCliente as cliente',
                'instalacions.sRegion',
                'instalacions.sComuna',
                'instalacions.sSerie',
                'instalacions.id',
                'instalacions.idSala',
                'instalacions.smarca as Csmarca'

            )
            ->where('instalacions.sCliente', '<>', 'kyocera')

            ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
            ->union($retiros_comtecglobal_pendientes)
            ->get();


 }



        $table = "";
       for ($i = 0; $i < count($instalacion_comtecglobal_pendientes); $i++) {
            foreach ($instalacion_comtecglobal_pendientes[$i] as $d1) {
            $table .= "<tr>";
            $table .= "<td>"  . $d1->proveedor . "</td>";
            $table .= "<td>"  . $d1->tipo . "</td>";
            $table .= "<td>"  . $d1->cliente . "</td>";
            $table .= "<td>"  . $d1->sRegion . "</td>";
            $table .= "<td>"  . $d1->sComuna . "</td>";
            $table .= "<td>"  . $d1->idSala . "</td>";
            $table .= "<td>"  . $d1->Csmarca . "</td>";


            $table .= "<td>"  . $d1->sSerie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn">Asignar</button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                    <form action="' . route('go.asignar_check_home') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" class="btn">Asignar</button>
                    </form>
                </td>';
            }
            $table .= "</tr>";
           }
        }


        return $table;
    }
    public function revisar_porasignar_22_02_23()
    {
        $retiros_comtecglobal_pendientes = DB::connection('comtecglobal')->table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->select(
                'retiros.proveedor_retiro as proveedor',
                'tracker.tipo_tracker as tipo',
                'retiros.sCliente as cliente',
                'retiros.sRegion',
                'retiros.sComuna',
                'retiros.sSerie',
                'retiros.id'
            )
            ->where('retiros.sCliente', '<>', 'kyocera')

            ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
        $instalacion_comtecglobal_pendientes = DB::connection('comtecglobal')->table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->select(
                'instalacions.proveedor_instalacion as proveedor',
                'tracker.tipo_tracker as tipo',
                'instalacions.sCliente as cliente',
                'instalacions.sRegion',
                'instalacions.sComuna',
                'instalacions.sSerie',
                'instalacions.id'
            )
            ->where('instalacions.sCliente', '<>', 'kyocera')

            ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
            ->union($retiros_comtecglobal_pendientes)
            ->get();
        $retiros_kyocera_pendientes = DB::connection('kyocera')->table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->select(
                'retiros.proveedor_retiro as proveedor',
                'tracker.tipo_tracker as tipo',
                'retiros.sCliente as cliente',
                'retiros.sRegion',
                'retiros.sComuna',
                'retiros.sSerie',
                'retiros.id'
            )
            ->where('retiros.sCliente', '<>', 'kyocera')

            ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
        $instalacion_kyocera_pendientes = DB::connection('kyocera')->table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->select(
                'instalacions.proveedor_instalacion as proveedor',
                'tracker.tipo_tracker as tipo',
                'instalacions.sCliente as cliente',
                'instalacions.sRegion',
                'instalacions.sComuna',
                'instalacions.sSerie',
                'instalacions.id'
            )
            ->where('instalacions.sCliente', '<>', 'kyocera')

            ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
            ->union($retiros_kyocera_pendientes)
            ->get();

        $retiros_upgrade_pendientes = DB::connection('upgrade')->table('retiros')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->select(
                'retiros.proveedor_retiro as proveedor',
                'tracker.tipo_tracker as tipo',
                'retiros.sCliente as cliente',
                'retiros.sRegion',
                'retiros.sComuna',
                'retiros.sSerie',
                'retiros.id'
            )
            ->where('retiros.sCliente', '<>', 'kyocera')

            ->where('retiros.estado_retiro_Cord', '=', 'Por Asignar');
        $instalacion_upgrade_pendientes = DB::connection('upgrade')->table('instalacions')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->select(
                'instalacions.proveedor_instalacion as proveedor',
                'tracker.tipo_tracker as tipo',
                'instalacions.sCliente as cliente',
                'instalacions.sRegion',
                'instalacions.sComuna',
                'instalacions.sSerie',
                'instalacions.id'
            )
            ->where('instalacions.sCliente', '<>', 'kyocera')

            ->where('instalacions.sEstado_instalacion', 'like', '%Por Asignar%')
            ->union($retiros_upgrade_pendientes)
            ->get();

        $table = "";
        foreach ($instalacion_comtecglobal_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>"  . $d1->proveedor . "</td>";
            $table .= "<td>"  . $d1->tipo . "</td>";
            $table .= "<td>"  . $d1->cliente . "</td>";
            $table .= "<td>"  . $d1->sRegion . "</td>";
            $table .= "<td>"  . $d1->sComuna . "</td>";
            $table .= "<td>"  . $d1->sSerie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn">Asignar</button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                    <form action="' . route('go.asignar_check_home') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" class="btn">Asignar</button>
                    </form>
                </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_kyocera_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $d1->proveedor . "</td>";
            $table .= "<td>"  . $d1->tipo . "</td>";
            $table .= "<td>"  . $d1->cliente . "</td>";
            $table .= "<td>"  . $d1->sRegion . "</td>";
            $table .= "<td>"  . $d1->sComuna . "</td>";
            $table .= "<td>"  . $d1->sSerie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn">Asignar</button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                    <form action="' . route('go.asignar_check_home') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" class="btn">Asignar</button>
                    </form>
                </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_upgrade_pendientes as $d1) {
            $table .= "<tr>";
            $table .= "<td>" . $d1->proveedor . "</td>";
            $table .= "<td>"  . $d1->tipo . "</td>";
            $table .= "<td>"  . $d1->cliente . "</td>";
            $table .= "<td>"  . $d1->sRegion . "</td>";
            $table .= "<td>"  . $d1->sComuna . "</td>";
            $table .= "<td>"  . $d1->sSerie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn">Asignar</button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                    <form action="' . route('go.asignar_check_home') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" class="btn">Asignar</button>
                    </form>
                </td>';
            }
            $table .= "</tr>";
        }
        return $table;
    }

    public function revisar_pendientes_coordinador()
    {
        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        foreach ($databases as $los_datos) {
            //ESTADO PENDIENTE PARA TECNICO
            $retiros_pendientes = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->select(
                    'checklist_retiros.csSerie as serie',
                    'checklist_retiros.csComuna as comuna',
                    'checklist_retiros.csRegion as region',
                    'checklist_retiros.Cscliente as cliente',
                DB::raw("NULL as Csmarca"),


                    'asignacion_retiros.tipo',
                    'asignacion_retiros.id',
                    'retiros.proveedor_retiro as proveedor',
                    'retiros.id as id_historial',
                    'retiros.fecha_retiroCord as fecha',
                    'personas.nombre_uno',
                    'personas.apellido_uno'
                )
                ->where('checklist_retiros.Cscliente', '<>', 'kyocera')

                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_inicio', '=', null)->groupBy('checklist_retiros.CsSerie');
            $instalacion_pendientes[] = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->select(
                    'checklist_instalacions.CsSerie as serie',
                    'checklist_instalacions.Cscomuna as comuna',
                    'checklist_instalacions.Csregion as region',
                    'checklist_instalacions.Cscliente as cliente',
                    'checklist_instalacions.Csmarca',

                    'asignacion_instalacions.tipo',
                    'asignacion_instalacions.id',
                    'instalacions.proveedor_instalacion as proveedor',
                    'instalacions.id as id_historial',
                    'instalacions.fecha_instalacion_coordinadora as fecha',
                    'personas.nombre_uno',
                    'personas.apellido_uno'
                )
                ->where('checklist_instalacions.Cscliente', '<>', 'kyocera')

                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '=', null)->groupBy('checklist_instalacions.CsSerie')

                ->union($retiros_pendientes)
                ->get();
        }
        $table = "";
        $num_r = "";
        $num_i = "";
        for ($i = 0; $i < count($instalacion_pendientes); $i++) {
            foreach ($instalacion_pendientes[$i] as $d1) {
                // if ($d1->proveedor == "comtecglobal" || $d1->proveedor == "COMTECGLOBAL") {
                //     $num_i = 1;
                // }
                // if ($d1->proveedor == "kyocera") {
                //     $num_r = 1;
                //     $num_i = 2;
                // }
                // if ($d1->proveedor == "upgrade") {
                //     $num_i = 3;
                // }

                $num_i = $d1->proveedor;
                $num_r = $d1->proveedor;

                if ($d1->fecha != "") {
                    $fecha = Carbon::createFromDate($d1->fecha)->format('d-m-Y');
                } else {
                    $fecha = "NO REGISTRA";
                }
                $table .= "<tr>";
                $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
                $table .= "<td>" . $fecha . "</td>";
                $table .= "<td>" . $d1->tipo . "</td>";
                $table .= "<td>" . $d1->cliente . "</td>";
                $table .= "<td>" . $d1->region . "</td>";
                $table .= "<td>" . $d1->comuna . "</td>";
                $table .= "<td>" . $d1->Csmarca . "</td>";
                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";

                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                    <a role="button" title="Historial" onclick="historial_retiro(' . $d1->id_historial . ',' . "'".$num_r ."'". ');" class="btn ver_historial_instalacion_home">
                                        <span class="material-icons">history</span>
                                    </a>
                                </div>
                            </div>
                        </div
                    </td>';
                } else {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.finalizamanual_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                check_circle_outline
                                            </span>
                                        </button>
                                    </form>
                                    <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                    <a role="button" title="Historial" onclick="historial_instalacion(' . $d1->id_historial . ',' . "'".$num_i . "'".');" class="btn ver_historial_instalacion_home">
                                        <span class="material-icons">history</span>
                                    </a>
                                </div>
                            </div>
                        </div
                    </td>';
                }
                $table .= "</tr>";
            }
        }
        return $table;
    }
    public function revisar_encurso_coordinador()
    {
        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        //ESTADO ENCURSO
        foreach ($databases as $los_datos) {
            $retiros_encurso = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->select(
                    'checklist_retiros.csSerie as serie',
                    'checklist_retiros.fecha_inicio as fecha',
                    'checklist_retiros.csComuna as comuna',
                    'checklist_retiros.csRegion as region',
                    'checklist_retiros.Cscliente as cliente',
                    'asignacion_retiros.tipo',
                    'asignacion_retiros.id',
                    'retiros.proveedor_retiro as proveedor',
                    'retiros.id as id_historial',
                    'personas.nombre_uno',
                    'personas.apellido_uno',
                    'asignacion_retiros.fecha_asignado',
                DB::raw("NULL as Csmarca")
                )
                ->where('asignacion_retiros.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_retiros.estado_inicio', '=', 'activo');
            $instalacion_encurso[]  = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->select(
                    'checklist_instalacions.CsSerie as serie',
                    'checklist_instalacions.fecha_inicio as fecha',
                    'checklist_instalacions.Cscomuna as comuna',
                    'checklist_instalacions.Csregion as region',
                    'checklist_instalacions.Cscliente as cliente',
                    'asignacion_instalacions.tipo',
                    'asignacion_instalacions.id',
                    'instalacions.proveedor_instalacion as proveedor',
                    'instalacions.id as id_historial',
                    'personas.nombre_uno',
                    'personas.apellido_uno',
                    'asignacion_instalacions.fecha_asignado',
                    'checklist_instalacions.Csmarca'

                )
                ->where('asignacion_instalacions.estado_asignacion', '=', 'tarea_asignada')
                ->where('checklist_instalacions.estado_inicio', '=', 'activo')
                ->union($retiros_encurso)
                ->get();
        }
        $table = "";
        $num_r = "";
        $num_i = "";
        for ($i = 0; $i < count($instalacion_encurso); $i++) {
            foreach ($instalacion_encurso[$i]  as $d1) {

                $num_i = $d1->proveedor;
                $num_r = $d1->proveedor;
                // if ($d1->proveedor == "comtecglobal") {
                //     $num_i = 1;
                // }
                // if ($d1->proveedor == "kyocera") {
                //     $num_r = 1;
                //     $num_i = 2;
                // }
                // if ($d1->proveedor == "upgrade") {
                //     $num_i = 3;
                // }
                $fecha = Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s');
                $table .= "<tr>";
                $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
                $table .= "<td>" . $fecha . "</td>";
                $table .= "<td>" . $d1->cliente . "</td>";
                $table .= "<td>" . $d1->Csmarca . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";

                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                    <a role="button" title="Historial" onclick="historial_retiro(' . $d1->id_historial . ',' ."'". $num_r ."'". ');" class="btn ver_historial_instalacion_home">
                                        <span class="material-icons">history</span>
                                    </a>
                                </div>
                            </div>
                        </div
                    </td>';
                } else {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.finalizamanual_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                check_circle_outline
                                            </span>
                                        </button>
                                    </form>
                                    <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                    <a role="button" title="Historial" onclick="historial_instalacion(' . $d1->id_historial . ',' ."'".$num_i ."'" . ');" class="btn ver_historial_instalacion_home">
                                    <span class="material-icons">history</span>
                                </a>
                                </div>
                            </div>
                        </div
                    </td>';
                }
                $table .= "</tr>";
            }
        }
        return $table;
    }
    public function revisar_porreasignar_coordinador()
    {
        $databases = App\bd_proveedores::selectDB();
        foreach ($databases as $los_datos) {

            //ESTADO PORREASIGNAR PARA COORDINADOR
            $retiros_comtecglobal_encurso = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
                DB::raw("NULL as Csmarca")
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');







            $instalacion_comtecglobal_encurso[]  = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
                'checklist_instalacions.Csmarca'

            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
            ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
            ->union($retiros_comtecglobal_encurso)
            ->get();





            //fin del foreach

        }


          $table = "";

          for ($i = 0; $i < count($instalacion_comtecglobal_encurso); $i++) {


        foreach ($instalacion_comtecglobal_encurso[$i]  as $d1) {
            $fecha = Carbon::createFromDate($d1->fecha_asignado)->format('d-m-y');
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $d1->cliente  . "</td>";
            $table .= "<td>" . $d1->Csmarca . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            $table .= "<td>" . $d1->proveedor . "</td>";

            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" title="Editar"   class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit"  title="Editar"  class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }


        }
        return $table;



    }
    public function revisar_porreasignar_coordinador_old()
    {
        $datos_trabajador = DB::table('trabajadors')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select('trabajadors.id', 'personas.nombre_uno', 'personas.apellido_uno')
            ->where('trabajadors.id_login', '=', Auth::user()->id)
            ->get();

        $id_trabajador = $datos_trabajador[0]->id;

        //ESTADO PORREASIGNAR PARA COORDINADOR
        $retiros_comtecglobal_encurso = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');
        $instalacion_comtecglobal_encurso  = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
            ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
            ->union($retiros_comtecglobal_encurso)
            ->get();
        $retiros_kyocera_encurso  = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');
        $instalacion_kyocera_encurso  = DB::connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
            ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
            ->union($retiros_kyocera_encurso)
            ->get();

        $retiros_upgrade_encurso  = DB::connection('synergy')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
            )
            ->where('asignacion_retiros.estado_asignacion', '=', 'reasignar');
        $instalacion_upgrade_encurso  = DB::connection('synergy')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
            )
            ->where('asignacion_instalacions.estado_asignacion', '=', 'reasignar')
            ->where('instalacions.sEstado_instalacion', '=', 'reasignar')
            ->union($retiros_upgrade_encurso)
            ->get();

        $table = "";
        foreach ($instalacion_comtecglobal_encurso  as $d1) {
            $fecha = Carbon::createFromDate($d1->fecha_asignado)->format('d-m-y');
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $d1->cliente  . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit"  title="Editar"  class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit"   title="Editar" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_kyocera_encurso  as $d1) {
            $fecha = Carbon::createFromDate($d1->fecha_asignado)->format('d-m-y');
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            $table .= "<td>" . $d1->proveedor . "</td>";

            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" title="Editar"  class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" title="Editar"  class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        foreach ($instalacion_upgrade_encurso  as $d1) {
            $fecha = Carbon::createFromDate($d1->fecha_asignado)->format('d-m-y');
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            if ($d1->tipo == "retiro") {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" title="Editar"  class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            } else {
                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" title="Editar"  class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
            }
            $table .= "</tr>";
        }
        return $table;
    }
    public function revisar_porrevisar_coordinador()
    {

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        //ESTADO ENCURSO
        foreach ($databases as $los_datos) {
            $retiros_encurso = DB::connection(strtolower($los_datos->Database))->table('asignacion_retiros')
                ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
                ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
                ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->select(
                    'checklist_retiros.csSerie as serie',
                    'checklist_retiros.fecha_inicio as fecha',
                    'checklist_retiros.csComuna as comuna',
                    'checklist_retiros.csRegion as region',
                    'checklist_retiros.Cscliente as cliente',
                    'asignacion_retiros.tipo',
                    'asignacion_retiros.id',
                    'retiros.proveedor_retiro as proveedor',
                    'retiros.id as id_historial',
                    'personas.nombre_uno',
                    'personas.apellido_uno',
                    'asignacion_retiros.fecha_asignado',
                DB::raw("NULL as Csmarca"),

                )
                ->where('checklist_retiros.Cscliente', '<>', 'kyocera')

                ->where('asignacion_retiros.estado_asignacion', '=', 'revisar');
            // ->where('checklist_retiros.estado_inicio', '=', 'revisar');
            $instalacion_encurso[]  = DB::connection(strtolower($los_datos->Database))->table('asignacion_instalacions')
                ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
                ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
                ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->select(
                    'checklist_instalacions.CsSerie as serie',
                    'checklist_instalacions.fecha_inicio as fecha',
                    'checklist_instalacions.Cscomuna as comuna',
                    'checklist_instalacions.Csregion as region',
                    'checklist_instalacions.Cscliente as cliente',
                    'asignacion_instalacions.tipo',
                    'asignacion_instalacions.id',
                    'instalacions.proveedor_instalacion as proveedor',
                    'instalacions.id as id_historial',
                    'personas.nombre_uno',
                    'personas.apellido_uno',
                    'asignacion_instalacions.fecha_asignado',
                    'checklist_instalacions.Csmarca',

                )
                ->where('checklist_instalacions.Cscliente', '<>', 'kyocera')

                ->where('asignacion_instalacions.estado_asignacion', '=', 'revisar')
                ->where('instalacions.sEstado_instalacion', '=', 'revisar')
                ->union($retiros_encurso)
                ->get();
        }
        $table = "";
        $num_r = "";
        $num_i = "";
        for ($i = 0; $i < count($instalacion_encurso); $i++) {
            foreach ($instalacion_encurso[$i]  as $d1) {
                // if ($d1->proveedor == "comtecglobal") {
                //     $num_i = 1;
                // }
                // if ($d1->proveedor == "kyocera") {
                //     $num_r = 1;
                //     $num_i = 2;
                // }
                // if ($d1->proveedor == "upgrade") {
                //     $num_i = 3;
                // }
                $num_i = $d1->proveedor;
                $num_r = $d1->proveedor;


                $fecha = Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s');
                $table .= "<tr>";
                $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
                $table .= "<td>" . $fecha . "</td>";
                $table .= "<td>" . $d1->cliente . "</td>";
                $table .= "<td>" . $d1->Csmarca . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";


                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                    <a role="button" title="Historial" onclick="historial_retiro(' . $d1->id_historial . ',' ."'". $num_r ."'" .');" class="btn ver_historial_instalacion_home">
                                        <span class="material-icons">history</span>
                                    </a>
                                </div>
                            </div>
                        </div
                    </td>';
                } else {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                    <a role="button" title="Historial" onclick="historial_instalacion(' . $d1->id_historial . ',' ."'". $num_i ."'". ');" class="btn ver_historial_instalacion_home">
                                    <span class="material-icons">history</span>
                                </a>
                                </div>
                            </div>
                        </div
                    </td>';
                }
                $table .= "</tr>";
            }
        }
        return $table;
    }
    public function seguimiento(request $request)
    {
        $serie = $request->serie;

        $retiros_comtecglobal_seguimiento = DB::connection('comtecglobal')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
                'retiros.sEstado as estado',
                'checklist_retiros.estado_inicio'
            )
            ->where('checklist_retiros.csSerie', '=', $serie);
        $instalacion_comtecglobal_seguimiento  = DB::connection('comtecglobal')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
                'instalacions.sEstado_instalacion as estado',
                'checklist_instalacions.estado_inicio'
            )
            ->where('checklist_instalacions.CsSerie', '=', $serie)
            ->orwhere('checklist_instalacions.CsSerie_es', '=', $serie)
            ->union($retiros_comtecglobal_seguimiento)
            ->orderBy('id', 'desc')
            ->get();
        $retiros_kyocera_seguimiento  = DB::connection('kyocera')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
                'retiros.sEstado as estado',
                'checklist_retiros.estado_inicio'
            )
            ->where('checklist_retiros.csSerie', '=', $serie);
        $instalacion_kyocera_seguimiento  = DB::connection('kyocera')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
                'instalacions.sEstado_instalacion as estado',
                'checklist_instalacions.estado_inicio'
            )
            ->where('checklist_instalacions.CsSerie', '=', $serie)
            ->orwhere('checklist_instalacions.CsSerie_es', '=', $serie)
            ->union($retiros_kyocera_seguimiento)
            ->orderBy('id', 'desc')
            ->take(1)
            ->get();

        $retiros_upgrade_seguimiento  = DB::connection('upgrade')->table('asignacion_retiros')
            ->join('checklist_retiros', 'checklist_retiros.asignacion_retiros_id', '=', 'asignacion_retiros.id')
            ->join('retiros', 'retiros.id', '=', 'asignacion_retiros.retiros_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_retiros.trabajadors_idtecnico')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_retiros.csSerie as serie',
                'checklist_retiros.csComuna as comuna',
                'checklist_retiros.csRegion as region',
                'checklist_retiros.Cscliente as cliente',
                'asignacion_retiros.tipo',
                'asignacion_retiros.id',
                'retiros.proveedor_retiro as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_retiros.fecha_asignado',
                'retiros.sEstado as estado',
                'checklist_retiros.estado_inicio'
            )
            ->where('checklist_retiros.csSerie', '=', $serie);
        $instalacion_upgrade_seguimiento  = DB::connection('upgrade')->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'checklist_instalacions.CsSerie as serie',
                'checklist_instalacions.Cscomuna as comuna',
                'checklist_instalacions.Csregion as region',
                'checklist_instalacions.Cscliente as cliente',
                'asignacion_instalacions.tipo',
                'asignacion_instalacions.id',
                'instalacions.proveedor_instalacion as proveedor',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
                'instalacions.sEstado_instalacion as estado',
                'checklist_instalacions.estado_inicio'
            )
            ->where('checklist_instalacions.CsSerie', '=', $serie)
            ->orwhere('checklist_instalacions.CsSerie_es', '=', $serie)
            ->union($retiros_upgrade_seguimiento)
            ->take(1)
            ->orderBy('id', 'desc')
            ->get();

        $table = "";
        foreach ($instalacion_comtecglobal_seguimiento as $d1) {
            $estado = $d1->estado;
            $estado_inicio = $d1->estado_inicio;
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $d1->fecha_asignado . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "</tr>";
        }
        foreach ($instalacion_kyocera_seguimiento  as $d1) {
            $estado = $d1->estado;
            $estado_inicio = $d1->estado_inicio;
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $d1->fecha_asignado . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "</tr>";
        }
        foreach ($instalacion_upgrade_seguimiento  as $d1) {
            $estado = $d1->estado;
            $estado_inicio = $d1->estado_inicio;
            $table .= "<tr>";
            $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
            $table .= "<td>" . $d1->fecha_asignado . "</td>";
            $table .= "<td>" . $d1->cliente . "</td>";
            $table .= "<td>" . $d1->region . "</td>";
            $table .= "<td>" . $d1->comuna . "</td>";
            $table .= "<td>" . $d1->serie . "</td>";
            $table .= "<td>" . $d1->tipo . "</td>";
            $table .= "</tr>";
        }

        $array_[] = array(
            "table" => $table,
            "estado" => $estado,
            "estado_inicio" => $estado_inicio
        );
        return $array_;
    }
    public function filtro_pendiente(request $request)
    {
        //$tables = DB::select('SHOW DATABASES');
        //return ($tables);
        $cliente = $request->cliente;
        $tipo = $request->tipo_a;
        $tecnico = $request->tecnico;
        $proveedor_ap = $request->proveedor_ap;

        $where  = 'asignacion_instalacions.estado_asignacion = ' . '"' . 'tarea_asignada' . '"';
         $where = $where . ' and instalacions.sEstado_instalacion = ' . '"' . 'asignado' . '"';

        $where_r  = 'asignacion_retiros.estado_asignacion = ' . '"' . 'tarea_asignada' . '"';
         $where_r = $where_r . ' and retiros.estado_retiro_Cord = ' . '"' . 'asignado' . '"';

        if ($cliente != "" || $cliente != null) {
            $where = $where . ' and clientes.id = ' . $cliente;
            $where_r = $where_r . ' and clientes.id = ' . $cliente;
        }
        if ($tipo != "" || $tipo != null) {
            $where = $where . ' and asignacion_instalacions.tipo = ' . '"' . $tipo . '"';
            $where_r = $where_r . ' and asignacion_retiros.tipo = ' . '"' . $tipo . '"';
        }
        if ($tecnico != "" || $tecnico != null) {
            $where = $where . ' and  asignacion_instalacions.trabajadors_id = ' . $tecnico;
            $where_r = $where_r . ' and  asignacion_retiros.trabajadors_idtecnico = ' . $tecnico;
        }
        if ($proveedor_ap != "" || $proveedor_ap != null) {
            $where = $where . ' and  instalacions.proveedor_instalacion = ' .'"' . $proveedor_ap . '"';
            $where_r = $where_r . ' and  retiros.proveedor_retiro = ' .'"' . $proveedor_ap . '"';
        }
        $where = $where . ' and  checklist_instalacions.Cscliente <> ' .'"' . "kyocera" . '"';
        $where_r = $where_r . ' and  checklist_retiros.Cscliente <> ' .'"' . "kyocera" . '"';

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        foreach ($databases as $los_datos) {
            $datos_asignacion[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                checklist_retiros.csSerie as serie,
                checklist_retiros.csComuna as comuna,
                checklist_retiros.csRegion as region,
                checklist_retiros.Cscliente as cliente,
                asignacion_retiros.tipo,
                asignacion_retiros.id,
                retiros.proveedor_retiro as proveedor,
                retiros.id as id_historial,
                personas.nombre_uno,
                personas.apellido_uno,
                retiros.fecha_retiroCord as fecha,
                null as Csmarca

            FROM
                asignacion_retiros
            INNER JOIN
                checklist_retiros on checklist_retiros.asignacion_retiros_id = asignacion_retiros.id
            INNER JOIN
                retiros on retiros.id = asignacion_retiros.retiros_id
            INNER JOIN
                trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
            INNER JOIN
                personas on personas.id = trabajadors.id_persona
            LEFT JOIN
                tracker on tracker.id = retiros.tracker_id
            LEFT JOIN
                proyectos on proyectos.id = tracker.proyecto_id
            LEFT JOIN
                clientes on clientes.id = proyectos.clientes_id
            WHERE ' . $where_r  .
                    ' union ' .
                    'SELECT
                checklist_instalacions.CsSerie as serie,
                checklist_instalacions.Cscomuna as comuna,
                checklist_instalacions.Csregion as region,
                checklist_instalacions.Cscliente as cliente,
                asignacion_instalacions.tipo,
                asignacion_instalacions.id,
                instalacions.proveedor_instalacion as proveedor,
                instalacions.id as id_historial,
                personas.nombre_uno,
                personas.apellido_uno,
                instalacions.fecha_instalacion_coordinadora as fecha,
                checklist_instalacions.Csmarca


            FROM
                asignacion_instalacions
            INNER JOIN
                checklist_instalacions on checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id
            INNER JOIN
                instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
            INNER JOIN
                trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
            INNER JOIN
                personas on personas.id = trabajadors.id_persona
            LEFT JOIN
                tracker on tracker.id = instalacions.tracker_idtracker
            LEFT JOIN
                proyectos on proyectos.id = tracker.proyecto_id
            LEFT JOIN
                clientes on clientes.id = proyectos.clientes_id
            WHERE ' . $where
            );
        }

        $table = "";
        $num_r = "";
        $num_i = "";
        for ($i = 0; $i < count($datos_asignacion); $i++) {
            foreach ($datos_asignacion[$i] as $d1) {
                // if ($d1->proveedor == "comtecglobal") {
                //     $num_i = 1;
                // }
                // if ($d1->proveedor == "kyocera") {
                //     $num_r = 1;
                //     $num_i = 2;
                // }
                // if ($d1->proveedor == "upgrade") {
                //     $num_i = 3;
                // }
                $num_i = $d1->proveedor;
                $num_r = $d1->proveedor;
                $table .= "<tr>";
                $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
                $table .= "<td>" .Carbon::createFromDate($d1->fecha)->format('d-m-Y'). "</td>";
                $table .= "<td>" . $d1->tipo . "</td>";
                $table .= "<td>" . $d1->cliente . "</td>";
                $table .= "<td>" . $d1->region . "</td>";
                $table .= "<td>" . $d1->comuna . "</td>";
                $table .= "<td>" . $d1->Csmarca . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";

                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                    <a role="button" title="Historial" onclick="historial_retiro(' . $d1->id_historial . ',' . "'".$num_r . "'".');" class="btn ver_historial_instalacion_home">
                                        <span class="material-icons">history</span>
                                    </a>
                                </div>
                            </div>
                        </div
                    </td>';
                } else {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.finalizamanual_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                check_circle_outline
                                            </span>
                                        </button>
                                    </form>
                                    <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                    <a role="button" title="Historial" onclick="historial_instalacion(' . $d1->id_historial . ',' . "'".$num_i ."'". ');" class="btn ver_historial_instalacion_home">
                                        <span class="material-icons">history</span>
                                    </a>
                                </div>
                            </div>
                        </div
                    </td>';
                }
                $table .= "</tr>";
            }
        }
        return $table;
    }
    private function nombre_database()
    {
        $tables = DB::select('SHOW DATABASES WHERE `Database` NOT LIKE ' . '"' . '%max%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%aya%' . '"' . '  AND  `Database` NOT LIKE ' . '"' . '%rutagas%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%schema%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%php%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%prueba%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%admin%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%fusion%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%sql%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%probando%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%soporte%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%sys%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%13octubre%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%nueva%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%rendicion%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%test%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%web%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%ofimundo%' . '"');
        return $tables;
    }
    //FILTRO POR ASIGNAR COORDINADOR
    public function filtro_porasignar(request $request)
    {
        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();

        $cliente = $request->cliente;
        $tipo = $request->tipo_a;
        $proveedor_ap_asig = $request->proveedor_ap_asig;

        $where  = 'instalacions.sEstado_instalacion like ' . '"%' . 'Por asignar' . '%"';
        $where_r  = 'retiros.estado_retiro_Cord = ' . '"' . 'Por asignar' . '"';

        if ($cliente != "" || $cliente != null) {
            $where = $where . ' and instalacions.sCliente = ' . '"' . $cliente . '"';
            $where_r = $where_r . ' and retiros.sCliente = ' . '"' . $cliente . '"';
        }
        if ($tipo != "" || $tipo != null) {
            $where = $where . ' and tracker.tipo_tracker = ' . '"' . $tipo . '"';
            $where_r = $where_r . ' and tracker.tipo_tracker = ' . '"' . $tipo . '"';
        }
        if ($proveedor_ap_asig != "" || $proveedor_ap_asig != null) {
            $where = $where . ' and instalacions.proveedor_instalacion = ' . '"' . $proveedor_ap_asig . '"';
            $where_r = $where_r . ' and retiros.proveedor_retiro = ' . '"' . $proveedor_ap_asig . '"';
        }
        foreach ($databases as $los_datos) {
            $datos_asignacion[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                retiros.proveedor_retiro as proveedor,
                tracker.tipo_tracker as tipo,
                retiros.sCliente as cliente,
                retiros.sRegion,
                retiros.sComuna,
                retiros.sSerie,
                retiros.id,
            null as Csmarca,
            null as idSala


                FROM
                    retiros
                INNER JOIN
                    tracker on tracker.id = retiros.tracker_id
                WHERE ' . $where_r  .
                    ' union ' .
                    'SELECT
                instalacions.proveedor_instalacion as proveedor,
                tracker.tipo_tracker as tipo,
                instalacions.sCliente as cliente,
                instalacions.sRegion,
                instalacions.sComuna,
                instalacions.sSerie,
                instalacions.id,
                instalacions.smarca as Csmarca,
                instalacions.idSala



                FROM
                    instalacions
                INNER JOIN
                    tracker on tracker.id = instalacions.tracker_idtracker
                WHERE ' . $where
            );
        }
        $table = "";
        for ($i = 0; $i < count($datos_asignacion); $i++) {
            foreach ($datos_asignacion[$i] as $d1) {
                $table .= "<tr>";
                $table .= "<td>" . $d1->proveedor . "</td>";
                $table .= "<td>" . $d1->tipo . "</td>";
                $table .= "<td>" . $d1->cliente . "</td>";
                $table .= "<td>" . $d1->sRegion . "</td>";
                $table .= "<td>" . $d1->sComuna . "</td>";
                $table .= "<td>" . $d1->idSala . "</td>";

                $table .= "<td>" . $d1->Csmarca . "</td>";

                $table .= "<td>" . $d1->sSerie . "</td>";
                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn">Asignar</button>
                        </form>
                    </td>';
                } else {
                    $table .=
                        '<td>
                    <form action="' . route('go.asignar_check_home') . '" method="GET">
                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                        <input type="hidden" value="' . $d1->id . '" name="id">
                        <button type="submit" class="btn">Asignar</button>
                    </form>
                </td>';
                }
                $table .= "</tr>";
            }
        }
        return $table;
    }
    public function filtro_encurso(request $request)
    {
        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();

        $cliente = $request->cliente;
        $tipo = $request->tipo_a;
        $tecnico = $request->tecnico;
        $proveedor_encurso = $request->proveedor_encurso;

        $where  = 'asignacion_instalacions.estado_asignacion = ' . '"' . 'Tarea_asignada' . '" and checklist_instalacions.estado_inicio = ' . '"' . 'activo' . '" ';
        $where_r  = 'asignacion_retiros.estado_asignacion = ' . '"' . 'Tarea_asignada' . '" and checklist_retiros.estado_inicio = ' . '"' . 'activo' . '" ';

        if ($cliente != "" || $cliente != null) {
            $where = $where . ' and clientes.id = ' . $cliente;
            $where_r = $where_r . ' and clientes.id = ' . $cliente;
        }
        if ($tipo != "" || $tipo != null) {
            $where = $where . ' and asignacion_instalacions.tipo = ' . '"' . $tipo . '"';
            $where_r = $where_r . ' and asignacion_retiros.tipo = ' . '"' . $tipo . '"';
        }
        if ($tecnico != "" || $tecnico != null) {
            $where = $where . ' and  asignacion_instalacions.trabajadors_id = ' . $tecnico;
            $where_r = $where_r . ' and  asignacion_retiros.trabajadors_idtecnico = ' . $tecnico;
        }
        if ($proveedor_encurso != "" || $proveedor_encurso != null) {
            $where = $where . ' and  instalacions.proveedor_instalacion  = ' . '"' . $proveedor_encurso . '"';
            $where_r = $where_r . ' and  retiros.proveedor_retiro = ' . '"' . $proveedor_encurso . '"';
        }


        foreach ($databases as $los_datos) {
            $datos_asignacion[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                checklist_retiros.csSerie as serie,
                checklist_retiros.fecha_inicio as fecha,
                checklist_retiros.csComuna as comuna,
                checklist_retiros.csRegion as region,
                checklist_retiros.Cscliente as cliente,
                asignacion_retiros.tipo,
                asignacion_retiros.id,
                retiros.proveedor_retiro as proveedor,
                personas.nombre_uno,
                personas.apellido_uno,
                asignacion_retiros.fecha_asignado,
                null as Csmarca

            FROM
                asignacion_retiros
            INNER JOIN
                checklist_retiros on checklist_retiros.asignacion_retiros_id = asignacion_retiros.id
            INNER JOIN
                retiros on retiros.id = asignacion_retiros.retiros_id
            INNER JOIN
                trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
            INNER JOIN
                personas on personas.id = trabajadors.id_persona
            LEFT JOIN
                tracker on tracker.id = retiros.tracker_id
            LEFT JOIN
                proyectos on proyectos.id = tracker.proyecto_id
            LEFT JOIN
                clientes on clientes.id = proyectos.clientes_id
            WHERE ' . $where_r  .
                    ' union ' .
                    'SELECT
                checklist_instalacions.CsSerie as serie,
                checklist_instalacions.fecha_inicio as fecha,
                checklist_instalacions.Cscomuna as comuna,
                checklist_instalacions.Csregion as region,
                checklist_instalacions.Cscliente as cliente,
                asignacion_instalacions.tipo,
                asignacion_instalacions.id,
                instalacions.proveedor_instalacion as proveedor,
                personas.nombre_uno,
                personas.apellido_uno,
                asignacion_instalacions.fecha_asignado,
                checklist_instalacions.Csmarca

            FROM
                asignacion_instalacions
            INNER JOIN
                checklist_instalacions on checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id
            INNER JOIN
                instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
            INNER JOIN
                trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
            INNER JOIN
                personas on personas.id = trabajadors.id_persona
            LEFT JOIN
                tracker on tracker.id = instalacions.tracker_idtracker
            LEFT JOIN
                proyectos on proyectos.id = tracker.proyecto_id
            LEFT JOIN
                clientes on clientes.id = proyectos.clientes_id
            WHERE ' . $where
            );
        }
        $table = "";
        for ($i = 0; $i < count($datos_asignacion); $i++) {
            foreach ($datos_asignacion[$i] as $d1) {
                $fecha = Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s');
                $table .= "<tr>";
                $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
                $table .= "<td>" . $fecha . "</td>";
                $table .= "<td>" . $d1->cliente . "</td>";
                $table .= "<td>" . $d1->Csmarca . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";

                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
                } else {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.finalizamanual_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                check_circle_outline
                                            </span>
                                        </button>
                                    </form>
                                    <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
                }
                $table .= "</tr>";
            }
        }
        return $table;
    }
    public function filtro_porrevisar(request $request)
    {
        $cliente = $request->cliente;
        $tipo = $request->tipo_a;
        $tecnico = $request->tecnico;
        $proveedor_por_rev = $request->proveedor_por_rev;


        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        $where  = 'asignacion_instalacions.estado_asignacion = ' . '"' . 'revisar' . '" and instalacions.sEstado_instalacion = ' . '"' . 'revisar' . '" ';
        $where_r  = 'asignacion_retiros.estado_asignacion = ' . '"' . 'revisar' . '"';

        if ($cliente != "" || $cliente != null) {
            $where = $where . ' and clientes.id = ' . $cliente;
            $where_r = $where_r . ' and clientes.id = ' . $cliente;
        }
        if ($tipo != "" || $tipo != null) {
            $where = $where . ' and asignacion_instalacions.tipo = ' . '"' . $tipo . '"';
            $where_r = $where_r . ' and asignacion_retiros.tipo = ' . '"' . $tipo . '"';
        }
        if ($tecnico != "" || $tecnico != null) {
            $where = $where . ' and  asignacion_instalacions.trabajadors_id = ' . $tecnico;
            $where_r = $where_r . ' and  asignacion_retiros.trabajadors_idtecnico = ' . $tecnico;
        }

        if ($proveedor_por_rev != "" || $proveedor_por_rev != null) {
            $where = $where . ' and  instalacions.proveedor_instalacion = ' . '"' . $proveedor_por_rev . '"';
            $where_r = $where_r . ' and  retiros.proveedor_retiro = ' . '"' . $proveedor_por_rev . '"';
        }

        $where = $where . ' and  checklist_instalacions.Cscliente <> ' . '"' . "kyocera" . '"';
        $where_r = $where_r . ' and  checklist_retiros.Cscliente <> ' . '"' . "kyocera" . '"';
        foreach ($databases as $los_datos) {
            $datos_asignacion[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                checklist_retiros.csSerie as serie,
                checklist_retiros.fecha_inicio as fecha,
                checklist_retiros.csComuna as comuna,
                checklist_retiros.csRegion as region,
                checklist_retiros.Cscliente as cliente,
                asignacion_retiros.tipo,
                asignacion_retiros.id,
                retiros.proveedor_retiro as proveedor,
                personas.nombre_uno,
                personas.apellido_uno,
                asignacion_retiros.fecha_asignado,
                null as Csmarca
            FROM
                asignacion_retiros
            INNER JOIN
                checklist_retiros on checklist_retiros.asignacion_retiros_id = asignacion_retiros.id
            INNER JOIN
                retiros on retiros.id = asignacion_retiros.retiros_id
            INNER JOIN
                trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
            INNER JOIN
                personas on personas.id = trabajadors.id_persona
            LEFT JOIN
                tracker on tracker.id = retiros.tracker_id
            LEFT JOIN
                proyectos on proyectos.id = tracker.proyecto_id
            LEFT JOIN
                clientes on clientes.id = proyectos.clientes_id
            WHERE ' . $where_r  .
                    ' union ' .
                    'SELECT
                checklist_instalacions.CsSerie as serie,
                checklist_instalacions.fecha_inicio as fecha,
                checklist_instalacions.Cscomuna as comuna,
                checklist_instalacions.Csregion as region,
                checklist_instalacions.Cscliente as cliente,
                asignacion_instalacions.tipo,
                asignacion_instalacions.id,
                instalacions.proveedor_instalacion as proveedor,
                personas.nombre_uno,
                personas.apellido_uno,
                asignacion_instalacions.fecha_asignado,
                checklist_instalacions.Cscliente as Csmarca

            FROM
                asignacion_instalacions
            INNER JOIN
                checklist_instalacions on checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id
            INNER JOIN
                instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
            INNER JOIN
                trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
            INNER JOIN
                personas on personas.id = trabajadors.id_persona
            LEFT JOIN
                tracker on tracker.id = instalacions.tracker_idtracker
            LEFT JOIN
                proyectos on proyectos.id = tracker.proyecto_id
            LEFT JOIN
                clientes on clientes.id = proyectos.clientes_id
            WHERE ' . $where
            );
        }
        $table = "";
        for ($i = 0; $i < count($datos_asignacion); $i++) {
            foreach ($datos_asignacion[$i] as $d1) {
                $fecha = Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s');
                $table .= "<tr>";
                $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
                $table .= "<td>" . $fecha . "</td>";
                $table .= "<td>" . $d1->cliente . "</td>";
                $table .= "<td>" . $d1->Csmarca . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                                $table .= "<td>" . $d1->proveedor . "</td>";

                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_retirocordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
                } else {
                    $table .=
                        '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_cordinadora2') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button class="btn">
                                            <span class="material-icons-round">
                                                visibility
                                            </span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div
                    </td>';
                }
                $table .= "</tr>";
            }
        }
        return $table;
    }
    public function filtro_porreasignar(request $request)
    {
        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();

        $cliente = $request->cliente;
        $tipo = strtolower($request->tipo_a);
        $tecnico = $request->tecnico;
        $proveedor_p_reasignar = $request->proveedor_p_reasignar;


        $where  = 'asignacion_instalacions.estado_asignacion = ' . '"' . 'reasignar' . '" and instalacions.sEstado_instalacion = ' . '"' . 'reasignar' . '" ';
        $where_r  = 'asignacion_retiros.estado_asignacion = ' . '"' . 'reasignar' . '"';

        if ($cliente != "" || $cliente != null) {
            $where = $where . ' and clientes.id = ' . $cliente;
            $where_r = $where_r . ' and clientes.id = ' . $cliente;
        }
        if ($tipo != "" || $tipo != null) {
            $where = $where . ' and asignacion_instalacions.tipo = ' . '"' . $tipo . '"';
            $where_r = $where_r . ' and asignacion_retiros.tipo = ' . '"' . $tipo . '"';
        }
        if ($tecnico != "" || $tecnico != null) {
            $where = $where . ' and  asignacion_instalacions.trabajadors_id = ' . $tecnico;
            $where_r = $where_r . ' and  asignacion_retiros.trabajadors_idtecnico = ' . $tecnico;
        }
        if ($proveedor_p_reasignar != "" || $proveedor_p_reasignar != null) {
            $where = $where . ' and  instalacions.proveedor_instalacion = '. '"' . $proveedor_p_reasignar . '"';
            $where_r = $where_r . ' and  retiros.proveedor_retiro = ' . '"' . $proveedor_p_reasignar . '"';
        }

        foreach ($databases as $los_datos) {
            $datos_asignacion[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                checklist_retiros.csSerie as serie,
                checklist_retiros.csComuna as comuna,
                checklist_retiros.csRegion as region,
                checklist_retiros.Cscliente as cliente,
                asignacion_retiros.tipo,
                asignacion_retiros.id,
                retiros.proveedor_retiro as proveedor,
                personas.nombre_uno,
                personas.apellido_uno,
                asignacion_retiros.fecha_asignado,
                NULL as Csmarca

            FROM
                asignacion_retiros
            INNER JOIN
                checklist_retiros on checklist_retiros.asignacion_retiros_id = asignacion_retiros.id
            INNER JOIN
                retiros on retiros.id = asignacion_retiros.retiros_id
            INNER JOIN
                trabajadors on trabajadors.id = asignacion_retiros.trabajadors_idtecnico
            INNER JOIN
                personas on personas.id = trabajadors.id_persona
            LEFT JOIN
                tracker on tracker.id = retiros.tracker_id
            LEFT JOIN
                proyectos on proyectos.id = tracker.proyecto_id
            LEFT JOIN
                clientes on clientes.id = proyectos.clientes_id
            WHERE ' . $where_r  .
                    ' union ' .
                    'SELECT
                checklist_instalacions.CsSerie as serie,
                checklist_instalacions.Cscomuna as comuna,
                checklist_instalacions.Csregion as region,
                checklist_instalacions.Cscliente as cliente,
                asignacion_instalacions.tipo,
                asignacion_instalacions.id,
                instalacions.proveedor_instalacion as proveedor,
                personas.nombre_uno,
                personas.apellido_uno,
                asignacion_instalacions.fecha_asignado,
                checklist_instalacions.Csmarca

            FROM
                asignacion_instalacions
            INNER JOIN
                checklist_instalacions on checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id
            INNER JOIN
                instalacions on instalacions.id = asignacion_instalacions.lista_instalacion_id
            INNER JOIN
                trabajadors on trabajadors.id = asignacion_instalacions.trabajadors_id
            INNER JOIN
                personas on personas.id = trabajadors.id_persona
            LEFT JOIN
                tracker on tracker.id = instalacions.tracker_idtracker
            LEFT JOIN
                proyectos on proyectos.id = tracker.proyecto_id
            LEFT JOIN
                clientes on clientes.id = proyectos.clientes_id
            WHERE ' . $where
            );
        }
        $table = "";
        for ($i = 0; $i < count($datos_asignacion); $i++) {
            foreach ($datos_asignacion[$i] as $d1) {
                $fecha = Carbon::createFromDate($d1->fecha_asignado)->format('d-m-y');
                $table .= "<tr>";
                $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
                $table .= "<td>" . $fecha . "</td>";
                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->Csmarca  . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";
                if ($d1->tipo == "retiro") {
                    $table .=
                        '<td>
                        <form action="' . route('go.asignar_check_retiro_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
                } else {
                    $table .=
                        '<td>
                        <form action="' . route('go.asignar_check_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Editar.png") . '" alt="" style="margin: 2px 0px" /></button>
                        </form>
                    </td>';
                }
                $table .= "</tr>";
            }
        }
        return $table;
    }
    public function index_servicio()
    {
        //SELECT TRABAJADORES
        $trabajadores = DB::table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'trabajadors.id')
            ->where('trabajadors.estado', '=', '1')
            ->orderBy('trabajadors.id', 'desc')
            ->get();

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        /** COORDINADOR */
        $cont_pendienteCoordinador = 0;
        $cont_porasignarCoordinador = 0;
        $cont_encursoCoordinador = 0;
        $cont_porreasignarCoordinador = 0;
        foreach ($databases as $los_datos) {
            $datos_clientes[] = DB::connection(strtolower($los_datos->Database))->select('SELECT clientes.razon_social as cliente, clientes.id FROM clientes WHERE clientes.id != 4');
            $datos_clientes_porasignar[] = DB::connection(strtolower($los_datos->Database))->select('SELECT DISTINCT api_solicitudes.sCliente FROM api_solicitudes');
            //SUMA PENDIENTE PARA COORINADOR
            $suma_pendientes_coordinador_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                ->count();
            $cont_pendienteCoordinador += $suma_pendientes_coordinador_servicio;
            //SUMA POR ASIGNAR COORDINADOR
            $suma_porasignar_coordinador_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'POR ASIGNAR')
                ->where('api_solicitudes.estado_externo', '=', 'POR ASIGNAR')
                ->orwhere('api_solicitudes.estado_interno', '=', NULL)
                ->where('api_solicitudes.estado_externo', '=', 'Sin asignar')
                ->count();
            $cont_porasignarCoordinador += $suma_porasignar_coordinador_servicio;
            //SUMA EN CURSO COORDINADOR
            $suma_encursos_coordinador_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                //TRANSITO
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN TRANSITO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'EN TRANSITO')
                //EN ESPERA
                ->orwhere('api_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('api_solicitudes.estado_externo', '=', 'EN ESPERA')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                ->where('asignacion_solicitudes.estado_externo', '=', 'ESPERANDO')
                //INICIADO
                ->orwhere('api_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('api_solicitudes.estado_externo', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_interno', '=', 'INICIADO')
                ->where('asignacion_solicitudes.estado_externo', '=', 'INICIADO')
                ->count();
            $cont_encursoCoordinador += $suma_encursos_coordinador_servicio;

            $suma_porreasignars_coordiandor_servicio = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', 'REASIGNAR')
                ->count();
            $cont_porreasignarCoordinador += $suma_porreasignars_coordiandor_servicio;
        }
        $suma_pendientes_coordinador = $cont_pendienteCoordinador;
        $suma_porasignar_coordinador = $cont_porasignarCoordinador;
        $suma_encursos_coordiandor = $cont_encursoCoordinador;
        $contador_porreasignar_coordinador = $cont_porreasignarCoordinador;
        /** FIN COORDINADOR */
        return view('home_servicio', compact('suma_pendientes_coordinador', 'suma_porasignar_coordinador', 'suma_encursos_coordiandor', 'contador_porreasignar_coordinador', 'trabajadores', 'datos_clientes', 'datos_clientes_porasignar'));
    }
    public function revisar_pendientes_coordinador_servicio()
    {
        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        foreach ($databases as $los_datos) {

            $pendientes_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                    api_solicitudes.sCliente as cliente,
                    api_solicitudes.sRegion as region,
                    api_solicitudes.sComuna as comuna,
                    api_solicitudes.sSc as serie,
                    api_solicitudes.fecha_asignado as fecha,
                    api_solicitudes.id as id_soli,
                    api_solicitudes.dFechaCreacion,

                    api_solicitudes.proveedor_servicio as proveedor,
                    asignacion_solicitudes.id,
                    personas.nombre_uno,
                    personas.apellido_uno,
                    api_solicitudes.sDescripcion,
                    api_solicitudes.Smarca,
                    api_solicitudes.id_solicitudes_remotas,
                    api_solicitudes.zona_geoge




                FROM
                    api_solicitudes
                INNER JOIN
                    asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                INNER JOIN
                    trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                INNER JOIN
                    personas on personas.id = trabajadors.id_persona
                WHERE
                api_solicitudes.tipo_asignacion_interna = 0 and  api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "tarea_asignada" and api_solicitudes.estado_externo = "ASIGNADO"
                and
                    asignacion_solicitudes.estado_interno = "tarea_asignada" and asignacion_solicitudes.estado_externo = "ASIGNADO"'
            );

            
        }
        $table = "";
        for ($i = 0; $i < count($pendientes_coordinador); $i++) {
            foreach ($pendientes_coordinador[$i] as $d1) {
                if ($d1->fecha != "") {
                    $fecha = Carbon::createFromDate($d1->fecha)->format('d-m-Y');
                } else {
                    $fecha = "NO REGISTRA";
                }
                $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")
                     ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                     ->where('solicitudes_remotas.id', $d1->id_solicitudes_remotas)->get();
                     $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);
     
                         $color = $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]) ;
     
                     if($color == "negro"){
     
                         $table .= "<tr style='color:white; background:#514E4D'>";
     
                     }else{
     
                         $table .= "<tr style='background:$color '>";
     
                     }

                     $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";

                    
                $table .= "<td>" . $d1->zona_geoge  . "</td>";
                $table .= "<td>" . $getDataSla["minutosTotales"]  . "</td>";
                $table .= "<td>" . $getDataSla["tiempoTranscurrido"] . "</td>";
                $table .= "<td>" . $getDataSla["minutos_restantes"]  . "</td>";
     
     
                    //   if( $datas[0] > 14 ||  $datas[0] < 0 ){
                    //       $table .= "<td style='background:red;color:white'>" . "Tiempo Superado" . "<br>"."</td>";

                    //  }elseif(($datas[0] >= 12 && $datas[0] <= 14)){
                    //     // $table .= "<td>" . $datas[1] . "<br>"."</td>";
                    //     $table .= "<td style='background:red;color:white'>" .$datas[1]  . "<br>"."</td>";


                    // }
                    //  elseif($datas[0] >= 0 && $datas[0] <= 8){
                    //      $table .= "<td>" . $datas[1] . "<br>"."</td>";

                    //  }elseif($datas[0] >= 9 &&  $datas[0] <= 11){
                    //      $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                    //  }else{
                    //      $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                    // }

                $table .= "<td>" . strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                $table .= "<td>" . $fecha  . "</td>";
                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . $d1->comuna  . "</td>";
                $table .= "<td>" . $d1->Smarca  . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->sDescripcion . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";

                $table .=

                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_solicitud_cordinadora_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button type="submit" class="btn"><img src="' . asset("Botones/Botones/revisar_m.png") . '" alt="" style="margin: 2px 0px" /></button>
                                    </form>
                                    <form action="' . route('go.finalizamanualservicios_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Finalizar_manual.png") . '" alt="" style="margin: 2px 0px" /></button>
                                    </form>
                                    <a role="button" title="Historial" onclick="hola(' ."'" .$d1->id_soli."'," ."'".$d1->proveedor."'". ')" class="btn ver_historial_servicio_home">
                                        <img src="' . asset("Botones/Botones/Historial.png") . '" alt="" style="margin: 2px 0px" />
                                    </a>
                                </div>
                            </div>
                        </div>
                    </td>';
                $table .= "</tr>";
            }
        }
        return $table;
    }


    // COORDINADOR 
    public function revisar_porasignar_servicio()
    {

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        foreach ($databases as $los_datos) {
            $porasignar_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                    api_solicitudes.sCliente as cliente,
                    api_solicitudes.sRegion as region,
                    api_solicitudes.sComuna as comuna,
                    api_solicitudes.sSc as serie,
                    api_solicitudes.proveedor_servicio as proveedor,
                    api_solicitudes.id,
                    api_solicitudes.dFechaCreacion,
                    api_solicitudes.Smarca,
                    api_solicitudes.id_solicitudes_remotas,
                    api_solicitudes.zona_geoge,

                    api_solicitudes.sDescripcion
                FROM
                    api_solicitudes
                WHERE
                --  api_solicitudes.tipo_asignacion_interna = 0 and

                api_solicitudes.tipo_asignacion_interna = 0  and    api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "POR ASIGNAR"
                    and api_solicitudes.estado_externo = "POR ASIGNAR"
                    or api_solicitudes.estado_externo = "Sin Asignar"  and   api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "POR ASIGNAR"
                    or api_solicitudes.estado_externo = "Sin Asignar" and  api_solicitudes.estado_interno  is null

                ORDER BY cliente'
            );
        }
        $table = "";
        for ($i = 0; $i < count($porasignar_coordinador); $i++) {
            foreach ($porasignar_coordinador[$i] as $d1) {



                $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")
                ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                ->where('solicitudes_remotas.id', $d1->id_solicitudes_remotas)->get();
                $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);

                    $color = $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]) ;

                    if($color == "negro"){

                        $table .= "<tr style='color:white; background:#514E4D'>";
    
                    }else{
    
                        $table .= "<tr style='background:$color '>";
    
                    }


                // $datas = $this->calcularHoraDos($d1->dFechaCreacion,$d1->proveedor,$d1->region);

                //   $table .= "<td >" .$datas[0] ."</td>";
                     $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";
                     $table .= "<td>" . $d1->zona_geoge  . "</td>";
                     $table .= "<td>" . $getDataSla["minutosTotales"]  . "</td>";
                     $table .= "<td>" . $getDataSla["tiempoTranscurrido"] . "</td>";
                     $table .= "<td>" . $getDataSla["minutos_restantes"]  . "</td>";
     

                    //   if( $datas[0] > 14 ||  $datas[0] < 0){
                    //       $table .= "<td style='background:red;color:white'>" . "Tiempo Superado" . "<br>"."</td>";

                    //  }elseif(($datas[0] >= 12 && $datas[0] <= 14)){
                    //     // $table .= "<td>" . $datas[1] . "<br>"."</td>";
                    //     $table .= "<td style='background:red;color:white'>" .$datas[1]  . "<br>"."</td>";


                    // }
                    //  elseif($datas[0] >= 0 && $datas[0] <= 8){
                    //      $table .= "<td>" . $datas[1] . "<br>"."</td>";

                    //  }elseif($datas[0] >= 9 &&  $datas[0] <= 11){
                    //      $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                    //  }else{
                    //      $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                    // }
                $table .= "<td>" . strtoupper($d1->proveedor) . "</td>";
                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . strtoupper($d1->comuna)  . "</td>";
                $table .= "<td>" . $d1->Smarca . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->sDescripcion . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";


                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_servicios_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn btn-prim px sm-4" id="btnview">Asignar</button>
                        </form>
                    </td>';
                $table .= "</tr>";
            }
        }
        return $table;
    }
    public function revisar_encurso_coordinador_servicio()
    {
        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        foreach ($databases as $los_datos) {
            $pendientes_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                    api_solicitudes.sCliente as cliente,
                    api_solicitudes.sRegion as region,
                    api_solicitudes.sComuna as comuna,
                    api_solicitudes.sSc as serie,
                    api_solicitudes.proveedor_servicio as proveedor,
                    api_solicitudes.id as id_soli,
                    asignacion_solicitudes.id as id,
                    asignacion_solicitudes.fecha_inicio as fecha,
                    personas.nombre_uno,
                    api_solicitudes.dFechaCreacion,
                    api_solicitudes.Smarca,

                    personas.apellido_uno,
                    api_solicitudes.sDescripcion,
                    api_solicitudes.id_solicitudes_remotas,
                    api_solicitudes.zona_geoge
                FROM
                    api_solicitudes
                INNER JOIN
                    asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                INNER JOIN
                    trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                INNER JOIN
                    personas on personas.id = trabajadors.id_persona
                WHERE
                api_solicitudes.tipo_asignacion_interna = 0 and  api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "tarea_asignada"
                    and api_solicitudes.estado_externo = "EN TRANSITO"
                    and asignacion_solicitudes.estado_interno = "tarea_asignada"
                    and asignacion_solicitudes.estado_externo = "EN TRANSITO"
                    or api_solicitudes.tipo_asignacion_interna = 0 and   api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "tarea_asignada"
                    and api_solicitudes.estado_externo = "EN ESPERA"
                    and asignacion_solicitudes.estado_interno = "tarea_asignada"
                    and asignacion_solicitudes.estado_externo = "ESPERANDO"
                    or  api_solicitudes.tipo_asignacion_interna = 0 and   api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "INICIADO"
                    and api_solicitudes.estado_externo = "INICIADO"
                    and asignacion_solicitudes.estado_interno = "INICIADO"
                    and asignacion_solicitudes.estado_externo = "INICIADO"'
            );
        }
        $table = "";
        for ($i = 0; $i < count($pendientes_coordinador); $i++) {
            foreach ($pendientes_coordinador[$i] as $d1) {
                if ($d1->fecha != "") {
                    $fecha = Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s');
                } else {
                    $fecha = "NO REGISTRA";
                }
                $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")
                ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                ->where('solicitudes_remotas.id', $d1->id_solicitudes_remotas)->get();
                $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);

                    $color = $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]) ;

                if($color == "negro"){

                    $table .= "<tr style='color:white; background:#514E4D'>";

                }else{

                    $table .= "<tr style='background:$color '>";

                }



                $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";
                $table .= "<td>" . $d1->zona_geoge  . "</td>";
                $table .= "<td>" . $getDataSla["minutosTotales"]  . "</td>";
                $table .= "<td>" . $getDataSla["tiempoTranscurrido"] . "</td>";
                $table .= "<td>" . $getDataSla["minutos_restantes"]  . "</td>";
                // $datas = $this->calcularHoraDos($d1->dFechaCreacion,$d1->proveedor,$d1->region);

                // //   $table .= "<td >" .$datas[0] ."</td>";
                //      $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";


                //       if( $datas[0] > 14 ||  $datas[0] < 0 ){
                //           $table .= "<td style='background:red;color:white'>" . "Tiempo Superado" . "<br>"."</td>";

                //      }elseif(($datas[0] >= 12 && $datas[0] <= 14)){
                //         // $table .= "<td>" . $datas[1] . "<br>"."</td>";
                //         $table .= "<td style='background:red;color:white'>" .$datas[1]  . "<br>"."</td>";


                //     }
                //      elseif($datas[0] >= 0 && $datas[0] <= 8){
                //          $table .= "<td>" . $datas[1] . "<br>"."</td>";

                //      }elseif($datas[0] >= 9 &&  $datas[0] <= 11){
                //          $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                //      }else{
                //          $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                //     }
                $table .= "<td>" . strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                $table .= "<td>" . $fecha  . "</td>";
                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . $d1->Smarca . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->sDescripcion . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";

                $table .=
                    '<td>
                        <div class="dropdown dropleft">
                            <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                                <span class="material-icons">more_vert</span>
                            </button>
                            <div class="dropdown-menu mostrar shadow">
                                <div class="d-flex justify-content-around">
                                    <form action="' . route('go.ver_check_solicitud_cordinadora_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button type="submit" class="btn"><img src="' . asset("Botones/Botones/revisar_m.png") . '" alt="" style="margin: 2px 0px" /></button>
                                    </form>
                                    <form action="' . route('go.finalizamanualservicios_home') . '" method="GET">
                                        <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                        <input type="hidden" value="' . $d1->id . '" name="id">
                                        <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Finalizar_manual.png") . '" alt="" style="margin: 2px 0px" /></button>
                                    </form>
                                    <a role="button" title="Historial" onclick="hola(' ."'" .$d1->id_soli."'," ."'".$d1->proveedor."'". ')" class="btn ver_historial_servicio_home">
                                        <img src="' . asset("Botones/Botones/Historial.png") . '" alt="" style="margin: 2px 0px" />
                                    </a>
                                </div>
                            </div>
                        </div>
                    </td>';
                $table .= "</tr>";
            }
        }
        return $table;
    }
    public function revisar_porreasignar_coordinador_servicio()
    {

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        foreach ($databases as $los_datos) {
            $pendientes_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                    api_solicitudes.sCliente as cliente,
                    api_solicitudes.sRegion as region,
                    api_solicitudes.sComuna as comuna,
                    api_solicitudes.sSc as serie,
                    api_solicitudes.proveedor_servicio as proveedor,
                    api_solicitudes.id as id,
                    asignacion_solicitudes.fecha_inicio as fecha,
                    api_solicitudes.Smarca,

                    personas.nombre_uno,
                    personas.apellido_uno
                FROM
                    api_solicitudes
                INNER JOIN
                    asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                INNER JOIN
                    trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                INNER JOIN
                    personas on personas.id = trabajadors.id_persona
                WHERE
                api_solicitudes.tipo_asignacion_interna = 0 and    api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "REASIGNAR" and asignacion_solicitudes.estado_interno = "REASIGNAR"'
            );
        }
        $table = "";
        for ($i = 0; $i < count($pendientes_coordinador); $i++) {
            foreach ($pendientes_coordinador[$i] as $d1) {
                $table .= "<tr>";
                $table .= "<td>" . strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                $table .= "<td>" .Carbon::createFromDate($d1->fecha)->format('d-m-Y') . "</td>";
                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . $d1->Smarca  . "</td>";


                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";


                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_servicios_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn btn-prim px sm-4" id="btnview">Asignar</button>
                        </form>
                    </td>';
                $table .= "</tr>";
            }
        }
        return $table;
    }



    public function revisar_porrevisar_coordinador_servicio_filtro(request $request)
    {
        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


                $tecnico = $request->tecnico;
                $region = $request->region_revisar_servicio;
                $proveedor_ap_serv = $request->proveedor_ap_serv;

                $where = "";

                if ($proveedor_ap_serv != "") {
                    $where .= ' and api_solicitudes.proveedor_servicio = '  . '"' . $proveedor_ap_serv . '"';
                }
                     if ($request->tecnico != "") {
            $where .= ' and asignacion_solicitudes.trabajadors_id = ' . $request->tecnico;
              }
                if ($request->region != "") {
                    $where .= ' and api_solicitudes.sRegion = '  . '"' . $request->region . '"';
                }

        foreach ($databases as $los_datos) {
            $pendientes_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                    api_solicitudes.sCliente as cliente,
                    api_solicitudes.sRegion as region,
                    api_solicitudes.sComuna as comuna,
                    api_solicitudes.sSc as serie,
                    api_solicitudes.estado_interno,
                    api_solicitudes.proveedor_servicio as proveedor,
                    api_solicitudes.id as id,
                    asignacion_solicitudes.fecha_inicio as fecha,
                    asignacion_solicitudes.id as id_asig,
                    api_solicitudes.dFechaCreacion,
                    api_solicitudes.Smarca,

                    personas.nombre_uno,
                    personas.apellido_uno,
                    api_solicitudes.id_solicitudes_remotas,
                    api_solicitudes.zona_geoge
                FROM
                    api_solicitudes
                INNER JOIN
                    asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                INNER JOIN
                    trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                INNER JOIN
                    personas on personas.id = trabajadors.id_persona
                WHERE
                api_solicitudes.tipo_asignacion_interna = 0 and   api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "REVISAR"
                AND
                    asignacion_solicitudes.estado_interno = "REVISAR"
                OR
                api_solicitudes.tipo_asignacion_interna = 0 and   api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "RECHAZADO" and asignacion_solicitudes.estado_interno = "RECHAZADO"' . $where
            );
        }
        $table = "";
        for ($i = 0; $i < count($pendientes_coordinador); $i++) {
            foreach ($pendientes_coordinador[$i] as $d1) {
                // $table .= "<tr>";

                // $datas = $this->calcularHoraDos($d1->dFechaCreacion,$d1->proveedor,$d1->region);

                // //   $table .= "<td >" .$datas[0] ."</td>";
                //      $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";


                //       if( $datas[0] > 14 ||  $datas[0] < 0 ){
                //           $table .= "<td style='background:red;color:white'>" . "Tiempo Superado" . "<br>"."</td>";

                //      }elseif(($datas[0] >= 12 && $datas[0] <= 14)){
                //         // $table .= "<td>" . $datas[1] . "<br>"."</td>";
                //         $table .= "<td style='background:red;color:white'>" .$datas[1]  . "<br>"."</td>";


                //     }
                //      elseif($datas[0] >= 0 && $datas[0] <= 8){
                //          $table .= "<td>" . $datas[1] . "<br>"."</td>";

                //      }elseif($datas[0] >= 9 &&  $datas[0] <= 11){
                //          $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                //      }else{
                //          $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                //     }
                $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")
                ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                ->where('solicitudes_remotas.id', $d1->id_solicitudes_remotas)->get();
                $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);

                    $color = $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]) ;

                if($color == "negro"){

                    $table .= "<tr style='color:white; background:#514E4D'>";

                }else{

                    $table .= "<tr style='background:$color '>";

                }
            $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";

                $table .= "<td>" . $d1->zona_geoge  . "</td>";
                $table .= "<td>" . $getDataSla["minutosTotales"]  . "</td>";
                $table .= "<td>" . $getDataSla["tiempoTranscurrido"] . "</td>";
                $table .= "<td>" . $getDataSla["minutos_restantes"]  . "</td>";

                $table .= "<td>" . strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                $table .= "<td>" . Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s')  . "</td>";
                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . $d1->Smarca  . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->estado_interno . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";



                $table .=
                    '<td>
                        <form action="' . route('go.ver_check_solicitud_cordinadora_home') . '" method="GET" target="_blank">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id_asig . '" name="id">
                            <button type="submit" class="btn btn-prim px sm-4" id="btnview">Revisar</button>
                        </form>
                    </td>';
                $table .= "</tr>";
            }
        }

        return $table;
    }
    // SYNERGY
    public function revisar_porrevisar_repuestos_coordinador_servicio_synergy()
    {

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        foreach ($databases as $los_datos) {

            if(Auth::user()->ver_todo_solicitud == 0){
                        $pendientes_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                            'SELECT
                                api_solicitudes.sCliente as cliente,
                                api_solicitudes.sRegion as region,
                                api_solicitudes.sComuna as comuna,
                                api_solicitudes.sSc as serie,
                                api_solicitudes.estado_interno,
                                api_solicitudes.proveedor_servicio as proveedor,
                                api_solicitudes.id as id,
                                asignacion_solicitudes.fecha_inicio as fecha,
                                asignacion_solicitudes.id as id_asig,
                                api_solicitudes.dFechaCreacion,
                                api_solicitudes.Smarca,
                                api_solicitudes.tipo_asignacion_interna,

                                personas.nombre_uno,
                                api_solicitudes.id_solicitudes_remotas,
                                api_solicitudes.zona_geoge,
                                personas.apellido_uno
                            FROM
                                api_solicitudes
                            INNER JOIN
                                asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                            INNER JOIN
                                trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                            INNER JOIN
                                personas on personas.id = trabajadors.id_persona
                            WHERE
                               api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "REVISAR"
                            AND
                                asignacion_solicitudes.estado_interno = "Solicitar Repuestos"
                            OR
                             api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "RECHAZADO" and asignacion_solicitudes.estado_interno = "RECHAZADO"'
                        );
            } else{
                $pendientes_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                    'SELECT
                        api_solicitudes.sCliente as cliente,
                        api_solicitudes.sRegion as region,
                        api_solicitudes.sComuna as comuna,
                        api_solicitudes.sSc as serie,
                        api_solicitudes.estado_interno,
                        api_solicitudes.proveedor_servicio as proveedor,
                        api_solicitudes.id as id,
                        asignacion_solicitudes.fecha_inicio as fecha,
                        asignacion_solicitudes.id as id_asig,
                        api_solicitudes.dFechaCreacion,
                        api_solicitudes.Smarca,
                        api_solicitudes.tipo_asignacion_interna,

                        personas.nombre_uno,
                        api_solicitudes.id_solicitudes_remotas,
                        api_solicitudes.zona_geoge,
                        personas.apellido_uno
                    FROM
                        api_solicitudes
                    INNER JOIN
                        asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                    INNER JOIN
                        trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                    INNER JOIN
                        personas on personas.id = trabajadors.id_persona
                    WHERE
                         api_solicitudes.estado_interno = "Solicitar Repuestos"
                    AND
                        asignacion_solicitudes.estado_interno = "Solicitar Repuestos"
                '
                );
        
            }       
        }
        $table = "";
        for ($i = 0; $i < count($pendientes_coordinador); $i++) {
            foreach ($pendientes_coordinador[$i] as $d1) {
            

                $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")
                ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                ->where('solicitudes_remotas.id', $d1->id_solicitudes_remotas)->get();
                $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);

                    $color = $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]) ;

                if($color == "negro"){

                    $table .= "<tr style='color:white; background:#514E4D'>";

                }else{

                    $table .= "<tr style='background:$color '>";

                }

                if($d1->tipo_asignacion_interna == "0"){
                
                           $table .= "<td >" . "REVISIÓN EXTERNA"."</td>";
                   
                }else{

                    $table .= "<td >" . "REVISIÓN INTERNA"."</td>";

                }
                

                
                $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";

                $table .= "<td>" . $d1->zona_geoge  . "</td>";
                $table .= "<td>" . $getDataSla["minutosTotales"]  . "</td>";
                $table .= "<td>" . $getDataSla["tiempoTranscurrido"] . "</td>";
                $table .= "<td>" . $getDataSla["minutos_restantes"]  . "</td>";

                $table .= "<td>" . strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                $table .= "<td>" . Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s')  . "</td>";
                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . $d1->Smarca  . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->estado_interno . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";
                $table .= '<td>
                <div class="dropdown">
                    <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        Opciones
                    </button>
                    <div class="dropdown-menu mostrar shadow" aria-labelledby="dropdownMenuButton">
                        <div class="d-flex justify-content-around">
                            <a role="button" class="btn-icon btn-icon-d ver_historial" onclick="verhistorialrepuestos(\'' . Crypt::encryptString($d1->id) . '\')" title="Historial" data-id="' . Crypt::encryptString($los_datos->id ?? '') . '">
                                <span class="material-icons">history</span>
                            </a>
                            <a role="button" class="btn-icon btn-icon-d ver_historial" onclick="verhistorialrepuestosDos(\'' . Crypt::encryptString($d1->id) . '\')" title="Historial" data-id="' . Crypt::encryptString($los_datos->id ?? '') . '">
                                <span class="material-icons">info</span>
                            </a>
                        </div>
                    </div>
                </div>
            </td>';

                if($d1->tipo_asignacion_interna == "1"){

                // $table .=
                //     '<td>
                //         <form action="' . route('go.ver_check_solicitud_cordinadora_home') . '" method="GET" target="_blank">
                //             <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                //             <input type="hidden" value="' . $d1->id_asig . '" name="id">
                //             <button type="submit" class="btn btn-prim px sm-4" id="btnview">Revisar</button>
                //         </form>
                //     </td>';


                 }else{
                $table .= "<td>" . "". "</td>";

                 }
                $table .= "</tr>";
            }
        }
        return $table;
    }

// SYNERGY
    public function revisar_porrevisar_coordinador_servicio_synergy()
    {

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        foreach ($databases as $los_datos) {

            if(Auth::user()->ver_todo_solicitud == 0){
                        $pendientes_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                            'SELECT
                                api_solicitudes.sCliente as cliente,
                                api_solicitudes.sRegion as region,
                                api_solicitudes.sComuna as comuna,
                                api_solicitudes.sSc as serie,
                                api_solicitudes.estado_interno,
                                api_solicitudes.proveedor_servicio as proveedor,
                                api_solicitudes.id as id,
                                asignacion_solicitudes.fecha_inicio as fecha,
                                asignacion_solicitudes.id as id_asig,
                                api_solicitudes.dFechaCreacion,
                                api_solicitudes.Smarca,
                                api_solicitudes.tipo_asignacion_interna,

                                personas.nombre_uno,
                                api_solicitudes.id_solicitudes_remotas,
                                api_solicitudes.zona_geoge,
                                personas.apellido_uno
                            FROM
                                api_solicitudes
                            INNER JOIN
                                asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                            INNER JOIN
                                trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                            INNER JOIN
                                personas on personas.id = trabajadors.id_persona
                            WHERE
                               api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "REVISAR"
                            AND
                                asignacion_solicitudes.estado_interno = "REVISAR"
                            OR
                             api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "RECHAZADO" and asignacion_solicitudes.estado_interno = "RECHAZADO"'
                        );
            } else{
                $pendientes_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                    'SELECT
                        api_solicitudes.sCliente as cliente,
                        api_solicitudes.sRegion as region,
                        api_solicitudes.sComuna as comuna,
                        api_solicitudes.sSc as serie,
                        api_solicitudes.estado_interno,
                        api_solicitudes.proveedor_servicio as proveedor,
                        api_solicitudes.id as id,
                        asignacion_solicitudes.fecha_inicio as fecha,
                        asignacion_solicitudes.id as id_asig,
                        api_solicitudes.dFechaCreacion,
                        api_solicitudes.Smarca,
                        api_solicitudes.tipo_asignacion_interna,

                        personas.nombre_uno,
                        api_solicitudes.id_solicitudes_remotas,
                        api_solicitudes.zona_geoge,
                        personas.apellido_uno
                    FROM
                        api_solicitudes
                    INNER JOIN
                        asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                    INNER JOIN
                        trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                    INNER JOIN
                        personas on personas.id = trabajadors.id_persona
                    WHERE
                         api_solicitudes.estado_interno = "REVISAR"
                    AND
                        asignacion_solicitudes.estado_interno = "REVISAR"
                    OR
                         api_solicitudes.estado_interno = "RECHAZADO" and asignacion_solicitudes.estado_interno = "RECHAZADO"'
                );
        
            }       
        }
        $table = "";
        for ($i = 0; $i < count($pendientes_coordinador); $i++) {
            foreach ($pendientes_coordinador[$i] as $d1) {
            

                $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")
                ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                ->where('solicitudes_remotas.id', $d1->id_solicitudes_remotas)->get();
                $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);

                    $color = $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]) ;

                if($color == "negro"){

                    $table .= "<tr style='color:white; background:#514E4D'>";

                }else{

                    $table .= "<tr style='background:$color '>";

                }

                if($d1->tipo_asignacion_interna == "0"){
                
                           $table .= "<td >" . "REVISIÓN EXTERNA"."</td>";
                   
                }else{

                    $table .= "<td >" . "REVISIÓN INTERNA"."</td>";

                }
                

                
                $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";

                $table .= "<td>" . $d1->zona_geoge  . "</td>";
                $table .= "<td>" . $getDataSla["minutosTotales"]  . "</td>";
                $table .= "<td>" . $getDataSla["tiempoTranscurrido"] . "</td>";
                $table .= "<td>" . $getDataSla["minutos_restantes"]  . "</td>";

                $table .= "<td>" . strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                $table .= "<td>" . Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s')  . "</td>";
                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . $d1->Smarca  . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->estado_interno . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";


                if($d1->tipo_asignacion_interna == "1"){

                $table .=
                    '<td>
                        <form action="' . route('go.ver_check_solicitud_cordinadora_home') . '" method="GET" target="_blank">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id_asig . '" name="id">
                            <button type="submit" class="btn btn-prim px sm-4" id="btnview">Revisar</button>
                        </form>
                    </td>';


                 }else{
                $table .= "<td>" . "". "</td>";

                 }
                $table .= "</tr>";
            }
        }
        return $table;
    }

    public function revisar_porrevisar_coordinador_servicio()
    {

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        foreach ($databases as $los_datos) {

            if(Auth::user()->ver_todo_solicitud == 0){
                        $pendientes_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                            'SELECT
                                api_solicitudes.sCliente as cliente,
                                api_solicitudes.sRegion as region,
                                api_solicitudes.sComuna as comuna,
                                api_solicitudes.sSc as serie,
                                api_solicitudes.estado_interno,
                                api_solicitudes.proveedor_servicio as proveedor,
                                api_solicitudes.id as id,
                                asignacion_solicitudes.fecha_inicio as fecha,
                                asignacion_solicitudes.id as id_asig,
                                api_solicitudes.dFechaCreacion,
                                api_solicitudes.Smarca,

                                personas.nombre_uno,
                                api_solicitudes.id_solicitudes_remotas,
                                api_solicitudes.zona_geoge,
                                personas.apellido_uno
                            FROM
                                api_solicitudes
                            INNER JOIN
                                asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                            INNER JOIN
                                trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                            INNER JOIN
                                personas on personas.id = trabajadors.id_persona
                            WHERE
                            api_solicitudes.tipo_asignacion_interna = 0 and     api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "REVISAR"
                            AND
                                asignacion_solicitudes.estado_interno = "REVISAR"
                            OR
                            api_solicitudes.tipo_asignacion_interna = 0 and   api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "RECHAZADO" and asignacion_solicitudes.estado_interno = "RECHAZADO"'
                        );
            } else{
                $pendientes_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                    'SELECT
                        api_solicitudes.sCliente as cliente,
                        api_solicitudes.sRegion as region,
                        api_solicitudes.sComuna as comuna,
                        api_solicitudes.sSc as serie,
                        api_solicitudes.estado_interno,
                        api_solicitudes.proveedor_servicio as proveedor,
                        api_solicitudes.id as id,
                        asignacion_solicitudes.fecha_inicio as fecha,
                        asignacion_solicitudes.id as id_asig,
                        api_solicitudes.dFechaCreacion,
                        api_solicitudes.Smarca,

                        personas.nombre_uno,
                        api_solicitudes.id_solicitudes_remotas,
                        api_solicitudes.zona_geoge,
                        personas.apellido_uno
                    FROM
                        api_solicitudes
                    INNER JOIN
                        asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                    INNER JOIN
                        trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                    INNER JOIN
                        personas on personas.id = trabajadors.id_persona
                    WHERE
                         api_solicitudes.estado_interno = "REVISAR"
                    AND
                        asignacion_solicitudes.estado_interno = "REVISAR"
                    OR
                         api_solicitudes.estado_interno = "RECHAZADO" and asignacion_solicitudes.estado_interno = "RECHAZADO"'
                );
        
            }       
        }
        $table = "";
        for ($i = 0; $i < count($pendientes_coordinador); $i++) {
            foreach ($pendientes_coordinador[$i] as $d1) {
                // $table .= "<tr>";

                // $datas = $this->calcularHoraDos($d1->dFechaCreacion,$d1->proveedor,$d1->region);

                // //   $table .= "<td >" .$datas[0] ."</td>";
                //      $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";


                //       if( $datas[0] > 14 ||  $datas[0] < 0 ){
                //           $table .= "<td style='background:red;color:white'>" . "Tiempo Superado" . "<br>"."</td>";

                //      }elseif(($datas[0] >= 12 && $datas[0] <= 14)){
                //         // $table .= "<td>" . $datas[1] . "<br>"."</td>";
                //         $table .= "<td style='background:red;color:white'>" .$datas[1]  . "<br>"."</td>";


                //     }
                //      elseif($datas[0] >= 0 && $datas[0] <= 8){
                //          $table .= "<td>" . $datas[1] . "<br>"."</td>";

                //      }elseif($datas[0] >= 9 &&  $datas[0] <= 11){
                //          $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                //      }else{
                //          $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                //     }

                $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")
                ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                ->where('solicitudes_remotas.id', $d1->id_solicitudes_remotas)->get();
                $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);

                    $color = $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]) ;

                if($color == "negro"){

                    $table .= "<tr style='color:white; background:#514E4D'>";

                }else{

                    $table .= "<tr style='background:$color '>";

                }
                
                $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";

                $table .= "<td>" . $d1->zona_geoge  . "</td>";
                $table .= "<td>" . $getDataSla["minutosTotales"]  . "</td>";
                $table .= "<td>" . $getDataSla["tiempoTranscurrido"] . "</td>";
                $table .= "<td>" . $getDataSla["minutos_restantes"]  . "</td>";

                $table .= "<td>" . strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                $table .= "<td>" . Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s')  . "</td>";
                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . $d1->Smarca  . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->estado_interno . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";



                $table .=
                    '<td>
                        <form action="' . route('go.ver_check_solicitud_cordinadora_home') . '" method="GET" target="_blank">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id_asig . '" name="id">
                            <button type="submit" class="btn btn-prim px sm-4" id="btnview">Revisar</button>
                        </form>
                    </td>';
                $table .= "</tr>";
            }
        }
        return $table;
    }

    public function obtenerclientesproveedor(request $request)
    {
        // $clientes_proveedor = DB::connection(strtolower($request->proveedor_ap))->table('api_solicitudes')
        // ->select('api_solicitudes.sCliente','api_solicitudes.id')
        // ->where('api_solicitudes.proveedor_servicio', '=', $request->proveedor_ap)
        // // ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
        // // ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
        // ->where("api_solicitudes.tipo_asignacion_interna","=","0")
        //     ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

        // ->where('api_solicitudes.estado_interno', '=', $request->estado)
        // ->groupby('sCliente')->distinct()
        // ->get();

        // if($request->opcionSelect == 0){
        //     $clientes_proveedor = DB::connection(strtolower($request->proveedor_ap))->table('clientes')
        //     ->select('clientes.razon_social','clientes.id')
        //     ->where('clientes.proveedor_nombre', '=', $request->proveedor_ap)
        //      ->where('clientes.id', '!=', 4)
        //      ->orderBy('clientes.razon_social', 'ASC')
        //     ->get();

        // }else{

        //     $clientes_proveedor = DB::connection(strtolower($request->proveedor_ap))->table('api_solicitudes')
        //     ->select('sCliente as id','sCliente as razon_social')
        //     ->where('api_solicitudes.proveedor_servicio', '=', $request->proveedor_ap)
        //      ->orderBy('sCliente', 'ASC')
        //      ->groupby('sCliente')->distinct()
        //     ->get();


        // }




        if($request->opcionSelect == 0){
            $clientes_proveedor = DB::connection(strtolower($request->proveedor_ap))->table('instalacions')
            ->select('instalacions.sCliente','clientes.id')
            ->where('instalacions.proveedor_instalacion', '=', $request->proveedor_ap)
             ->where('instalacions.id', '!=', 4)
             ->orderBy('instalacions.sCliente', 'ASC')
            ->get();

        }else{

            $clientes_proveedor = DB::connection(strtolower($request->proveedor_ap))->table('instalacions')
            ->select('sCliente as id','sCliente as razon_social')
            ->where('instalacions.proveedor_instalacion', '=', $request->proveedor_ap)
             ->orderBy('sCliente', 'ASC')
             ->groupby('sCliente')

             ->distinct()
            ->get();


        }



        $opciones = "";

        if (count($clientes_proveedor) >= 1) {

            $opciones .= "<option value= '" . "'>" . "Seleccionar". "</option>";

            for ($j = 0; $j < count($clientes_proveedor); $j++) {
                for ($i = 0; $i < 1; $i++) {

                    if($clientes_proveedor[$j]->id == $request->idClienteSelecionado){
                        $opciones .= "<option selected value= '" . $clientes_proveedor[$j]->id. "'>" . $clientes_proveedor[$j]->razon_social . "</option>";

                    }else{

                        $opciones .= "<option value= '" . $clientes_proveedor[$j]->id. "'>" . $clientes_proveedor[$j]->razon_social . "</option>";

                    }

                }
            }

            return $opciones;
        } else {

            return "<option value= '" . "'>" . "Seleccionar". "</option>";
        }
   }

    public function filtro_pendiente_servicio(request $request)
    {




        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();

      $proveedor_ap_serv=   $request->proveedor_ap_serv ;
        $where = "";
        if ($request->cliente != "") {
            $where .= ' and api_solicitudes.sCliente = ' . '"' . $request->cliente . '"';
        }
        if ($request->tecnico != "") {
            $where .= ' and asignacion_solicitudes.trabajadors_id = ' . $request->tecnico;
        }
        if ($proveedor_ap_serv != "") {
            $where .= ' and api_solicitudes.proveedor_servicio = '  . '"' . $proveedor_ap_serv . '"';
        }
        if ($request->region != "") {
            $where .= ' and api_solicitudes.sRegion = '  . '"' . $request->region . '"';
        }
        foreach ($databases as $los_datos) {
            $pendientes_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                    api_solicitudes.sCliente as cliente,
                    api_solicitudes.sRegion as region,
                    api_solicitudes.sComuna as comuna,
                    api_solicitudes.sSc as serie,
                    api_solicitudes.proveedor_servicio as proveedor,
                    api_solicitudes.id as id_soli,
                    asignacion_solicitudes.id as id,
                    personas.nombre_uno,
                    api_solicitudes.dFechaCreacion,

                    personas.apellido_uno,
                    api_solicitudes.sDescripcion,
                    api_solicitudes.fecha_asignado as fecha,
                    api_solicitudes.Smarca,
                    api_solicitudes.id_solicitudes_remotas,
                    api_solicitudes.zona_geoge


                FROM
                    api_solicitudes
                INNER JOIN
                    asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                INNER JOIN
                    trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                INNER JOIN
                    personas on personas.id = trabajadors.id_persona
                WHERE
                     api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "tarea_asignada" and api_solicitudes.estado_externo = "ASIGNADO"
                    and asignacion_solicitudes.estado_interno = "tarea_asignada" and asignacion_solicitudes.estado_externo = "ASIGNADO"' . $where
            );
        }
        $table = "";
        for ($i = 0; $i < count($pendientes_coordinador); $i++) {
            foreach ($pendientes_coordinador[$i] as $d1) {
                $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")
                ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                ->where('solicitudes_remotas.id', $d1->id_solicitudes_remotas)->get();
                $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);

                    $color = $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]) ;

                if($color == "negro"){

                    $table .= "<tr style='color:white; background:#514E4D'>";

                }else{

                    $table .= "<tr style='background:$color '>";

                }

                $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";

               
           $table .= "<td>" . $d1->zona_geoge  . "</td>";
           $table .= "<td>" . $getDataSla["minutosTotales"]  . "</td>";
           $table .= "<td>" . $getDataSla["tiempoTranscurrido"] . "</td>";
           $table .= "<td>" . $getDataSla["minutos_restantes"]  . "</td>";

                $table .= "<td>" . strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                $table .= "<td>" .Carbon::createFromDate($d1->fecha)->format('d-m-Y'). "</td>";
                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . $d1->comuna  . "</td>";
                $table .= "<td>" . $d1->Smarca . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->sDescripcion . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";

                $table .=
                    '<td>
                    <div class="dropdown dropleft">
                        <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                            <span class="material-icons">more_vert</span>
                        </button>
                        <div class="dropdown-menu mostrar shadow">
                            <div class="d-flex justify-content-around">
                                <form action="' . route('go.ver_check_solicitud_cordinadora_home') . '" method="GET">
                                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                    <input type="hidden" value="' . $d1->id . '" name="id">
                                    <button type="submit" class="btn"><img src="' . asset("Botones/Botones/revisar_m.png") . '" alt="" style="margin: 2px 0px" /></button>
                                </form>
                                <form action="' . route('go.finalizamanualservicios_home') . '" method="GET">
                                    <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                    <input type="hidden" value="' . $d1->id . '" name="id">
                                    <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Finalizar_manual.png") . '" alt="" style="margin: 2px 0px" /></button>
                                </form>
                                <a role="button" title="Historial" onclick="hola(' ."'" .$d1->id_soli."'," ."'".$d1->proveedor."'". ')" class="btn ver_historial_servicio_home">
                                        <img src="' . asset("Botones/Botones/Historial.png") . '" alt="" style="margin: 2px 0px" />
                                    </a>
                            </div>
                        </div>
                    </div
                </td>';
                $table .= "</tr>";
            }
        }
        return $table;
    }
    public function filtro_porasignar_servicio(request $request)
    {
        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        $where = "";
        if ($request->cliente != "") {
            $where .= ' and api_solicitudes.sCliente = ' . '"' . $request->cliente . '" ';
        }
        if ($request->proveedor_por_as_ser != "") {
            $where .= ' and  api_solicitudes.proveedor_servicio  = ' . '"' . $request->proveedor_por_as_ser . '" ';
        }
        if ($request->region_por_as_ser != "") {
            $where .= ' and  api_solicitudes.sRegion  = ' . '"' . $request->region_por_as_ser . '" ';
        }
        foreach ($databases as $los_datos) {
            $porasignar_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                api_solicitudes.sCliente as cliente,
                api_solicitudes.sRegion as region,
                api_solicitudes.sComuna as comuna,
                api_solicitudes.sSc as serie,
                api_solicitudes.proveedor_servicio as proveedor,
                api_solicitudes.id,
                                    api_solicitudes.dFechaCreacion,
api_solicitudes.Smarca,

api_solicitudes.id_solicitudes_remotas,
                    api_solicitudes.zona_geoge,
                api_solicitudes.sDescripcion
            FROM
                api_solicitudes
            WHERE
                 api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "POR ASIGNAR"
                and api_solicitudes.estado_externo = "POR ASIGNAR"' . $where . '
                or api_solicitudes.estado_externo = "Sin Asignar"  and   api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "POR ASIGNAR"'  . $where . '
                or api_solicitudes.estado_externo = "Sin Asignar" and  api_solicitudes.estado_interno is NULL'  . $where . '

            ORDER BY cliente'
            );
        }
        $table = "";
        for ($i = 0; $i < count($porasignar_coordinador); $i++) {
            foreach ($porasignar_coordinador[$i] as $d1) {




                $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")
                ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                ->where('solicitudes_remotas.id', $d1->id_solicitudes_remotas)->get();
                $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);

                    $color = $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]) ;

                    if($color == "negro"){

                        $table .= "<tr style='color:white; background:#514E4D'>";
    
                    }else{
    
                        $table .= "<tr style='background:$color '>";
    
                    }


                // $datas = $this->calcularHoraDos($d1->dFechaCreacion,$d1->proveedor,$d1->region);

                //   $table .= "<td >" .$datas[0] ."</td>";
                     $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";
                     $table .= "<td>" . $d1->zona_geoge  . "</td>";
                     $table .= "<td>" . $getDataSla["minutosTotales"]  . "</td>";
                     $table .= "<td>" . $getDataSla["tiempoTranscurrido"] . "</td>";
                     $table .= "<td>" . $getDataSla["minutos_restantes"]  . "</td>";
                // $table .= "<tr>";
                // // $table .= "<td>" . strtoupper($d1->proveedor) . "</td>";
                // $datas = $this->calcularHoraDos($d1->dFechaCreacion,$d1->proveedor,$d1->region);

                // //   $table .= "<td >" .$datas[0] ."</td>";
                //      $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";


                //       if( $datas[0] > 14 ||  $datas[0] < 0){
                //           $table .= "<td style='background:red;color:white'>" . "Tiempo Superado" . "<br>"."</td>";

                //      }elseif(($datas[0] >= 12 && $datas[0] <= 14)){
                //         // $table .= "<td>" . $datas[1] . "<br>"."</td>";
                //         $table .= "<td style='background:red;color:white'>" .$datas[1]  . "<br>"."</td>";


                //     }
                //      elseif($datas[0] >= 0 && $datas[0] <= 8){
                //          $table .= "<td>" . $datas[1] . "<br>"."</td>";

                //      }elseif($datas[0] >= 9 &&  $datas[0] <= 11){
                //          $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                //      }else{
                //          $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                //     }
                $table .= "<td>" . $d1->proveedor . "</td>";

                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . strtoupper($d1->comuna)  . "</td>";
                $table .= "<td>" . "". "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->sDescripcion . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";


                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_servicios_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn btn-prim px sm-4" id="btnview">Asignar</button>
                        </form>
                    </td>';
                $table .= "</tr>";
            }
        }
        return $table;
    }
    public function filtro_encurso_servicio(request $request)
    {

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();

        //return $request;
        $where = "";
        if ($request->cliente != "") {
            $where .= ' and api_solicitudes.sCliente = ' . '"' . $request->cliente . '" ';
        }

        if ($request->tecnico != "") {
            $where .= ' and asignacion_solicitudes.trabajadors_id = ' . $request->tecnico;
        }
        if ($request->proveedor_en_curso_serv != "") {
            $where .= ' and api_solicitudes.proveedor_servicio = '  . '"' . $request->proveedor_en_curso_serv . '" ';
        }

        if ($request->region_en_curso_serv != "") {
            $where .= ' and api_solicitudes.sRegion = '  . '"' . $request->region_en_curso_serv . '" ';
        }


        foreach ($databases as $los_datos) {
            $encurso_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                    api_solicitudes.sCliente as cliente,
                    api_solicitudes.sRegion as region,
                    api_solicitudes.sComuna as comuna,
                    api_solicitudes.sSc as serie,
                    api_solicitudes.proveedor_servicio as proveedor,
                    api_solicitudes.id as id_soli,
                    asignacion_solicitudes.id as id,
                    asignacion_solicitudes.fecha_inicio as fecha,
                    personas.nombre_uno,
                    personas.apellido_uno,
                    api_solicitudes.dFechaCreacion,
                    api_solicitudes.Smarca,
                    api_solicitudes.id_solicitudes_remotas,
                    api_solicitudes.zona_geoge,
                    api_solicitudes.sDescripcion

                FROM
                    api_solicitudes
                INNER JOIN
                    asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                INNER JOIN
                    trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                INNER JOIN
                    personas on personas.id = trabajadors.id_persona
                WHERE
                     api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "tarea_asignada"
                    and api_solicitudes.estado_externo = "EN TRANSITO"
                    and asignacion_solicitudes.estado_interno = "tarea_asignada"
                    and asignacion_solicitudes.estado_externo = "EN TRANSITO"' . $where . '
                    or   api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "tarea_asignada"
                    and api_solicitudes.estado_externo = "EN ESPERA"
                    and asignacion_solicitudes.estado_interno = "tarea_asignada"
                    and asignacion_solicitudes.estado_externo = "ESPERANDO"' . $where . '
                    or   api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "INICIADO"
                    and api_solicitudes.estado_externo = "INICIADO"
                    and asignacion_solicitudes.estado_interno = "INICIADO"
                    and asignacion_solicitudes.estado_externo = "INICIADO"' . $where
            );
        }
        $table = "";
        for ($i = 0; $i < count($encurso_coordinador); $i++) {
            foreach ($encurso_coordinador[$i] as $d1) {
                // $table .= "<tr>";

                // $datas = $this->calcularHoraDos($d1->dFechaCreacion,$d1->proveedor,$d1->region);

                // //   $table .= "<td >" .$datas[0] ."</td>";
                //      $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";


                //       if( $datas[0] > 14 ||  $datas[0] < 0 ){
                //           $table .= "<td style='background:red;color:white'>" . "Tiempo Superado" . "<br>"."</td>";

                //      }elseif(($datas[0] >= 12 && $datas[0] <= 14)){
                //         // $table .= "<td>" . $datas[1] . "<br>"."</td>";
                //         $table .= "<td style='background:red;color:white'>" .$datas[1]  . "<br>"."</td>";


                //     }
                //      elseif($datas[0] >= 0 && $datas[0] <= 8){
                //          $table .= "<td>" . $datas[1] . "<br>"."</td>";

                //      }elseif($datas[0] >= 9 &&  $datas[0] <= 11){
                //          $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                //      }else{
                //          $table .= "<td style='background:orange'>" . $datas[1] . "<br>"."</td>";

                //     }


                

                $identificador = App\solicitudes_remotas::select("solicitudes_remotas.id")
                ->join("asuntos","asuntos.id","=","solicitudes_remotas.id_asunto")
                ->where('solicitudes_remotas.id', $d1->id_solicitudes_remotas)->get();
                $getDataSla = App\sla_zonas::calcularSlaZonas($identificador);

                    $color = $this->calcularPorcentajeTranscurrido( $getDataSla["minutosTotales"], $getDataSla["tiempoTranscurrido"]) ;

                if($color == "negro"){

                    $table .= "<tr style='color:white; background:#514E4D'>";

                }else{

                    $table .= "<tr style='background:$color '>";

                }

            

                $table .= "<td >" . Carbon::parse($d1->dFechaCreacion)->format('d/m/Y H:i:s') . "<br>"."</td>";
                $table .= "<td>" . $d1->zona_geoge  . "</td>";
                $table .= "<td>" . $getDataSla["minutosTotales"]  . "</td>";
                $table .= "<td>" . $getDataSla["tiempoTranscurrido"] . "</td>";
                $table .= "<td>" . $getDataSla["minutos_restantes"]  . "</td>";

                $table .= "<td>" . strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                if ($d1->fecha == "") {
                    $table .= "<td>NO REGISTRA</td>";
                } else {
                    $table .= "<td>" . Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s')  . "</td>";
                }


                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . $d1->Smarca  . "</td>";


                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->sDescripcion . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";


                $table .=
                    '<td>
                    <div class="dropdown dropleft">
                    <button type="button" class="btn-dropdown" data-toggle="dropdown" aria-expanded="false">
                        <span class="material-icons">more_vert</span>
                    </button>
                    <div class="dropdown-menu mostrar shadow">
                        <div class="d-flex justify-content-around">
                            <form action="' . route('go.ver_check_solicitud_cordinadora_home') . '" method="GET">
                                <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                <input type="hidden" value="' . $d1->id . '" name="id">
                                <button type="submit" class="btn"><img src="' . asset("Botones/Botones/revisar_m.png") . '" alt="" style="margin: 2px 0px" /></button>
                            </form>
                            <form action="' . route('go.finalizamanualservicios_home') . '" method="GET">
                                <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                <input type="hidden" value="' . $d1->id . '" name="id">
                                <button type="submit" class="btn"><img src="' . asset("Botones/Botones/Finalizar_manual.png") . '" alt="" style="margin: 2px 0px" /></button>
                            </form>
                            <a role="button" title="Historial" onclick="hola(' ."'" .$d1->id_soli."'," ."'".$d1->proveedor."'". ')" class="btn ver_historial_servicio_home">
                                <img src="' . asset("Botones/Botones/Historial.png") . '" alt="" style="margin: 2px 0px" />
                            </a>
                        </div>
                    </div>
                </div
                    </td>';
                $table .= "</tr>";
            }
        }
        return $table;
    }
    public function filtro_porreasignar_servicio(request $request)
    {
        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        $where = "";
        if ($request->cliente != "") {
            $where .= ' and api_solicitudes.sCliente = ' . '"' . $request->cliente . '" ';
        }
        if ($request->tecnico != "") {
            $where .= ' and asignacion_solicitudes.trabajadors_id = ' . $request->tecnico;
        }
        if ($request->proveedor_p_reasignar_ser != "") {
            $where .= ' and api_solicitudes.proveedor_servicio  = ' . '"' . $request->proveedor_p_reasignar_ser . '" ';
        }
        if ($request->region_p_reasignar_ser != "") {
            $where .= ' and api_solicitudes.sRegion  = ' . '"' . $request->region_p_reasignar_ser . '" ';
        }
        foreach ($databases as $los_datos) {
            $porreasignar_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                    api_solicitudes.sCliente as cliente,
                    api_solicitudes.sRegion as region,
                    api_solicitudes.sComuna as comuna,
                    api_solicitudes.sSc as serie,
                    api_solicitudes.proveedor_servicio as proveedor,
                    api_solicitudes.id as id,
                    asignacion_solicitudes.fecha_inicio as fecha,
                    api_solicitudes.Smarca,

                    personas.nombre_uno,
                    personas.apellido_uno
                FROM
                    api_solicitudes
                INNER JOIN
                    asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                INNER JOIN
                    trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                INNER JOIN
                    personas on personas.id = trabajadors.id_persona
                WHERE
                     api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "REASIGNAR" and asignacion_solicitudes.estado_interno = "REASIGNAR"' . $where
            );
        }
        $table = "";
        for ($i = 0; $i < count($porreasignar_coordinador); $i++) {
            foreach ($porreasignar_coordinador[$i] as $d1) {
                $table .= "<tr>";
                $table .= "<td>" . strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                $table .= "<td>" . $d1->fecha  . "</td>";
                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . $d1->Smarca  . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td>" . $d1->proveedor . "</td>";


                $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_servicios_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn btn-prim px sm-4" id="btnview">Asignar</button>
                        </form>
                    </td>';
                $table .= "</tr>";
            }
        }
        return $table;
    }

    public function filtro_solicitud_repuesto_servicio(request $request)
    {
        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        $where = "";
        if ($request->cliente != "") {
            $where .= ' and api_solicitudes.sCliente = ' . '"' . $request->cliente . '" ';
        }
        if ($request->tecnico != "") {
            $where .= ' and asignacion_solicitudes.trabajadors_id = ' . $request->tecnico;
        }
        if ($request->proveedor_instalacion_respuestos != "") {
            $where .= ' and api_solicitudes.proveedor_servicio  = ' . '"' . $request->proveedor_instalacion_respuestos . '" ';
        }
        if ($request->region_repuesto_servicio != "") {
            $where .= ' and api_solicitudes.sRegion  = ' . '"' . $request->region_repuesto_servicio . '" ';
        }
        foreach ($databases as $los_datos) {
            $repuesto_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                    api_solicitudes.sCliente as cliente,
                    api_solicitudes.sRegion as region,
                    api_solicitudes.sComuna as comuna,
                    api_solicitudes.sSc as serie,
                    api_solicitudes.estado_interno,
                    api_solicitudes.estado_externo,
                    api_solicitudes.proveedor_servicio as proveedor,
                    api_solicitudes.id as id,
                    asignacion_solicitudes.fecha_inicio as fecha,
                    asignacion_solicitudes.id as id_asig,
                    personas.nombre_uno,
                    api_solicitudes.Smarca,

                    personas.apellido_uno,
                    api_solicitudes.sDescripcion

                FROM
                    api_solicitudes
                LEFT JOIN
                    asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                LEFT JOIN
                    trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                LEFT JOIN
                    personas on personas.id = trabajadors.id_persona
                WHERE
                 api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "Solicitar Repuestos" and asignacion_solicitudes.estado_interno = "Solicitar Repuestos" and asignacion_solicitudes.estado_externo = "Solicitar Repuestos" ' . $where
            );
        }
        $table = "";
        for ($i = 0; $i < count($repuesto_coordinador); $i++) {
            foreach ($repuesto_coordinador[$i] as $d1) {
                $table .= "<tr>";
                $table .= "<td>" . strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                $table .= "<td>" . Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s')  . "</td>";
                $table .= "<td>" . $d1->cliente  . "</td>";

                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . $d1->Smarca  . "</td>";
                $table .= "<td>" . $d1->serie . "</td>";
                // $table .= "<td>" . $d1->proveedor . "</td>";

                $table .= "<td>" . $d1->estado_externo . "</td>";
                $table .= "<td>" . $d1->sDescripcion . "</td>"; ;
                               $table .= "<td>" . $d1->proveedor . "</td>";

                if($d1->estado_interno == ""){
                    $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_servicios_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn btn-prim px sm-4" id="btnview">Asignar</button>
                        </form>
                    </td>';
                }elseif($d1->estado_interno == "Solicitar Repuestos"){
                    $table .=
                    '<td>
                        <form action="' . route('go.ver_check_solicitud_cordinadora_home') . '" method="GET" target="_blank">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id_asig . '" name="id">
                            <button type="submit" class="btn btn-prim px sm-4" id="btnview">Revisar</button>
                        </form>
                    </td>';
                }
                $table .= "</tr>";
            }
        }
        return $table;
    }

    public function filtro_repuesto_servicio(request $request)
    {
        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        $where = "";
        if ($request->cliente != "") {
            $where .= ' and api_solicitudes.sCliente = ' . '"' . $request->cliente . '" ';
        }
        if ($request->tecnico != "") {
            $where .= ' and asignacion_solicitudes.trabajadors_id = ' . $request->tecnico;
        }
        if ($request->proveedor_instalacion_respuestos != "") {
            $where .= ' and api_solicitudes.proveedor_servicio  = ' . '"' . $request->proveedor_instalacion_respuestos . '" ';
        }
        if ($request->region_instalacion_respuestos != "") {
            $where .= ' and api_solicitudes.region  = ' . '"' . $request->region_instalacion_respuestos . '" ';
        }
        foreach ($databases as $los_datos) {
            $repuesto_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                    api_solicitudes.sCliente as cliente,
                    api_solicitudes.sRegion as region,
                    api_solicitudes.sComuna as comuna,
                    api_solicitudes.sSc as serie,
                    api_solicitudes.estado_interno,
                    api_solicitudes.estado_externo,
                    api_solicitudes.proveedor_servicio as proveedor,
                    api_solicitudes.id as id,
                    asignacion_solicitudes.fecha_inicio as fecha,
                    asignacion_solicitudes.id as id_asig,
                    personas.nombre_uno,
                    personas.apellido_uno,
                    api_solicitudes.Smarca,

                    api_solicitudes.sDescripcion

                FROM
                    api_solicitudes
                LEFT JOIN
                    asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                LEFT JOIN
                    trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                LEFT JOIN
                    personas on personas.id = trabajadors.id_persona
                WHERE
                    api_solicitudes.estado_externo = "Instalar repuesto"' . $where
            );
        }
        $table = "";
        for ($i = 0; $i < count($repuesto_coordinador); $i++) {
            foreach ($repuesto_coordinador[$i] as $d1) {
                $table .= "<tr>";
                $table .= "<td>" . strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                $table .= "<td>" . Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s')  . "</td>";
                $table .= "<td>" . $d1->cliente  . "</td>";
                $table .= "<td>" . $d1->region  . "</td>";
                $table .= "<td>" . $d1->Smarca  . "</td>";

                $table .= "<td>" . $d1->serie . "</td>";
                // $table .= "<td>" . $d1->proveedor . "</td>";

                $table .= "<td>" . $d1->estado_externo . "</td>";
                $table .= "<td>" . $d1->sDescripcion . "</td>"; ;
                               $table .= "<td>" . $d1->proveedor . "</td>";

                if($d1->estado_interno == ""){
                    $table .=
                    '<td>
                        <form action="' . route('go.asignar_check_servicios_home') . '" method="GET">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id . '" name="id">
                            <button type="submit" class="btn btn-prim px sm-4" id="btnview">Asignar</button>
                        </form>
                    </td>';
                }elseif($d1->estado_interno == "Solicitar Repuestos"){
                    $table .=
                    '<td>
                        <form action="' . route('go.ver_check_solicitud_cordinadora_home') . '" method="GET" target="_blank">
                            <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                            <input type="hidden" value="' . $d1->id_asig . '" name="id">
                            <button type="submit" class="btn btn-prim px sm-4" id="btnview">Revisar</button>
                        </form>
                    </td>';
                }
                $table .= "</tr>";
            }
        }
        return $table;
    }
    public function seguimiento_servicio(request $request)
    {
        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        $serie = $request->serie;

        foreach ($databases as $los_datos) {
            $seguimiento_servicio[] = DB::connection(strtolower($los_datos->Database))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
                ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                ->select(
                    'api_solicitudes.sCliente as cliente',
                    'api_solicitudes.sRegion as region',
                    'api_solicitudes.sComuna as comuna',
                    'api_solicitudes.sSc as serie',
                    'api_solicitudes.proveedor_servicio as proveedor',
                    'asignacion_solicitudes.estado_interno as estado',
                    'asignacion_solicitudes.estado_externo as estado_externo',
                    'asignacion_solicitudes.id as id',
                    'api_solicitudes.fecha_asignado',
                    'personas.nombre_uno',
                    'personas.apellido_uno'
                )
                ->where('api_solicitudes.sSc', '=', $serie)
                ->get();
        }
        $table = "";
        for ($i = 0; $i < count($seguimiento_servicio); $i++) {
            foreach ($seguimiento_servicio[$i] as $d1) {
                $fecha = Carbon::createFromDate($d1->fecha_asignado)->format('d-m-Y');
                $estado = $d1->estado;
                $estado_externo = $d1->estado_externo;
                $table .= "<tr>";
                $table .= "<td>" . $d1->nombre_uno . " " . $d1->apellido_uno . "</td>";
                $table .= "<td>" . $fecha . "</td>";
                $table .= "<td>" . $d1->cliente . "</td>";
                $table .= "<td>" . $d1->region . "</td>";
                $table .= "<td>" . $d1->comuna . "</td>";
                $table .= "<td>" . $d1->serie . "</td>";
                $table .= "<td> SERVICIO </td>";
                $table .= "</tr>";
            }
        }

        $array_[] = array(
            "table" => $table,
            "estado" => $estado,
            'estado_externo' => $estado_externo
        );
        return $array_;
    }

    public function index_proveedor($seccion)
    {
        
        try {
            $seccion = Crypt::decryptString($seccion);
        } catch (DecryptException $e) {
            return "No Puede Realizar Esta Accion";
        }
        $proveedor = Auth::user()->nombre_proveedor;

        $trabajadores = DB::connection(strtolower($proveedor))->table('personas')
            ->join('trabajadors', 'trabajadors.id_persona', '=', 'personas.id')
            ->select('personas.nombre_uno', 'personas.apellido_uno', 'trabajadors.id')
            ->where('trabajadors.estado', '=', '1')
            ->orderBy('personas.nombre_uno', 'ASC')
            ->get();

        $estado = DB::connection(strtolower($proveedor))->table('asignacion_solicitudes')
            ->select('asignacion_solicitudes.estado_externo as estado');
        //$estado_r = DB::connection(strtolower($proveedor))->table('asignacion_retiros')
        // ->select('asignacion_retiros.estado_asignacion as estado');
        $estado_i = DB::connection(strtolower($proveedor))->table('asignacion_instalacions')
            ->select('asignacion_instalacions.estado_asignacion as estado')
            ->union($estado)
            //->union($estado_r)
            ->distinct()
            ->get();

        $tables = "";

        if ($seccion == "asignados_ir") {

            $titulo = "Atenciones asignadas instalacion";

            $instalacion_asignados_proveedor = DB::connection(strtolower($proveedor))->table('instalacions')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->select('clientes.id', 'clientes.razon_social')
                ->where('clientes.id', '!=', 4)
                ->distinct('razon_social')
                ->get();

            foreach ($instalacion_asignados_proveedor as $datos) {
                $tables .= '<tr onclick="revisarCliente(' . $datos->id . ')">';
                $tables .= '<td>' . strtoupper($datos->razon_social) . '</td>';

                //CONSULTA DE CONTADOR
                $instalacion_asignados_proveedor = DB::connection(strtolower($proveedor))->table('instalacions')
                    ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                    ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                    ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                    ->select('instalacions.id as cliente')
                    ->where('clientes.id', '=', $datos->id)
                    ->count();

                $cont_clientes = $instalacion_asignados_proveedor;

                $tables .= '<td>' . $cont_clientes . '</td>';
                $tables .= '<td> <span class="material-icons " style="cursor:pointer">playlist_add_check_circle</span> </td>';
                $tables .= '</tr>';
            }
        } else if ($seccion == "repuestos_ir") {

            $titulo = "Atenciones pendientes repuestos instalacion";

            $instalacion_repuestos_proveedor = DB::connection(strtolower($proveedor))->table('instalacions')
                ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                ->select('clientes.razon_social as cliente', 'clientes.id as clientes_id')
                ->where('clientes.id', '=', '000')
                ->get();

            foreach ($instalacion_repuestos_proveedor as $datos) {
                $tables .= '<tr>';
                $tables .= '<td>' . strtoupper($datos->cliente) . '</td>';

                //CONSULTA DE CONTADOR

                $cont_repuestos_proveedor = DB::connection(strtolower($proveedor))->table('instalacions')
                    ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
                    ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
                    ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
                    ->select('instalacions.id as cliente')
                    ->where('clientes.id', '=', $datos->clientes_id)
                    //->where('checklist_instalacions.motivo', '!=', '')
                    ->count();

                $cont_clientes = $cont_repuestos_proveedor;

                $tables .= '<td>' . $cont_clientes . '</td>';
                $tables .= '<td onclick="revisarCliente(' . $datos->clientes_id . ')"> REVISAR </td>';
                $tables .= '</tr>';
            }
        } else if ($seccion == "asignados_servicio") {
            $titulo = "Total de atenciones";

            $servicio_asignados_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                // ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->select('api_solicitudes.sCliente as cliente')
                ->orderby('cliente', 'asc')
                ->distinct('cliente')
                ->get();

            foreach ($servicio_asignados_proveedor as $datos) {
                //CONSULTA DE CONTADOR
                $cont_asignados_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                    // ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                    ->select('api_solicitudes.id')
                    ->where('api_solicitudes.sCliente', '=', $datos->cliente)
                    ->get();

                $cont_clientes = count($cont_asignados_proveedor);
                $tables .= '<tr onclick="revisarCliente(' . $cont_asignados_proveedor[0]->id . ')">';
                $tables .= '<td>' . strtoupper($datos->cliente) . '</td>';
                $tables .= '<td>' . $cont_clientes . '</td>';
                $tables .= '<td> <span class="material-icons" style="cursor:pointer">playlist_add_check_circle</span> </td>';
                $tables .= '</tr>';
            }
        } else if ($seccion == "repuestos_servicio") {
            $titulo = "Atenciones pendientes de repuestos servicio";

            $servicio_repuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->select('api_solicitudes.sCliente as cliente')
                ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
                ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos')
                ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                    ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                ->where('api_solicitudes.estado_interno', '=', "Solicitar Repuestos")
                ->orderby('cliente', 'asc')
                ->distinct('cliente')
                ->get();

            foreach ($servicio_repuestos_proveedor as $datos) {
                //CONSULTA DE CONTADOR
                $cont_repuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                    ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                    ->where('api_solicitudes.sCliente', '=', $datos->cliente)
                    ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
                    ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos')
                    ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                        ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

                    ->where('api_solicitudes.estado_interno', '=', "Solicitar Repuestos")
                    ->select('api_solicitudes.id')
                    ->groupBy('id')
                    ->get();

                $cont_clientes = count($cont_repuestos_proveedor);

                $tables .= '<tr onclick="revisarCliente(' . $cont_repuestos_proveedor[0]->id . ')">';
                $tables .= '<td>' . strtoupper($datos->cliente) . '</td>';
                $tables .= '<td>' . $cont_clientes . '</td>';
                $tables .= '<td> <span class="material-icons" style="cursor:pointer">playlist_add_check_circle</span> </td>';
                $tables .= '</tr>';
            }
        }
        else if ($seccion == "asignadas") {
            $titulo = "Atenciones asignadas";

            $servicio_repuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->select('api_solicitudes.sCliente as cliente')
                ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                    ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                    ->where('api_solicitudes.estado_interno', '=', "tarea_asignada")
                ->orderby('cliente', 'asc')
                ->distinct('cliente')
                ->get();

            foreach ($servicio_repuestos_proveedor as $datos) {
                //CONSULTA DE CONTADOR
                $cont_repuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                    ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                    ->where('api_solicitudes.sCliente', '=', $datos->cliente)
                    ->where('asignacion_solicitudes.estado_interno', '=', 'tarea_asignada')
                    ->where('asignacion_solicitudes.estado_externo', '=', 'ASIGNADO')
                    ->where('api_solicitudes.estado_interno', '=', "tarea_asignada")
                    ->select('api_solicitudes.id')
                    ->groupBy('id')
                    ->get();

                $cont_clientes = count($cont_repuestos_proveedor);

                $tables .= '<tr onclick="revisarCliente(' . $cont_repuestos_proveedor[0]->id . ')">';
                $tables .= '<td>' . strtoupper($datos->cliente) . '</td>';
                $tables .= '<td>' . $cont_clientes . '</td>';
                $tables .= '<td> <span class="material-icons" style="cursor:pointer">playlist_add_check_circle</span> </td>';
                $tables .= '</tr>';
            }
        } else if ($seccion == "finalizadas") {
            $titulo = "Atenciones finalizadas";


            $servicio_repuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                ->select('api_solicitudes.sCliente as cliente')
                ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
                    ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO')
                   ->where('api_solicitudes.estado_interno', '=', "FINALIZADO")
                ->orderby('cliente', 'asc')
                ->distinct('cliente')
                ->get();
            foreach ($servicio_repuestos_proveedor as $datos) {
                //CONSULTA DE CONTADOR
                $cont_repuestos_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
                    ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
                    ->where('api_solicitudes.sCliente', '=', $datos->cliente)
                    ->where('asignacion_solicitudes.estado_interno', '=', 'FINALIZADO')
                    ->where('asignacion_solicitudes.estado_externo', '=', 'FINALIZADO')
                   ->where('api_solicitudes.estado_interno', '=', "FINALIZADO")
                    ->select('api_solicitudes.id')
                    ->groupBy('id')
                    ->get();

                $cont_clientes = count($cont_repuestos_proveedor);

                $tables .= '<tr onclick="revisarClientes(' . $cont_repuestos_proveedor[0]->id . ')">';
                $tables .= '<td>' . strtoupper($datos->cliente) . '</td>';
                $tables .= '<td>' . $cont_clientes . '</td>';
                $tables .= '<td> <span class="material-icons" style="cursor:pointer">playlist_add_check_circle</span> </td>';
                $tables .= '</tr>';
            }
        }



        return view('home_proveedor', compact('seccion', 'titulo', 'tables', 'trabajadores', 'estado_i'));
    }
    public function revisarClienteProveedor(request $request)
    {


        $id = $request->id;
        $proveedor = Auth::user()->nombre_proveedor;

        $instalacion_asignados_proveedor = DB::connection(strtolower($proveedor))->table('instalacions')
            ->join('asignacion_instalacions', 'asignacion_instalacions.lista_instalacion_id', '=', 'instalacions.id')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select(
                'clientes.razon_social as cliente',
                'asignacion_instalacions.fecha_asignado',
                'instalacions.sSc as sc',
                'instalacions.sSerie as serie',
                'asignacion_instalacions.estado_asignacion',
                'instalacions.id',
                'instalacions.smarca as Csmarca'

            )
            ->where('clientes.id', '=', $id)
            ->groupBy('serie')
            ->orderBy('fecha_asignado', 'desc')
            ->get();




        $table = "";

        foreach ($instalacion_asignados_proveedor as $datos) {
            $fecha = Carbon::createFromDate($datos->fecha_asignado)->format('d-m-Y H:s');
            $table .= "<tr>";
            $table .= "<td>" . strtoupper($datos->cliente) . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $datos->sc . "</td>";
            $table .= "<td>" . checklist_instalacions::getMarc($datos->id,strtolower($proveedor)). "</td>";

            $table .= "<td>" . strtoupper($datos->serie) . "</td>";
            $table .= "<td>" . strtoupper($datos->estado_asignacion) . "</td>";
            $table .= '<td>
                            <a role="button" class="btn-icon btn-icon-dd" title="Historial" onclick="historial_ins(' . $datos->id . ')">
                            <span class="material-icons">history</span>
                            </a>
                    </td>';
            $table .= "</tr>";
        }

        return $table;
    }
    public function revisarrepuestosClienteProveedor(request $request)
    {
        $id = $request->id;
        $proveedor = Auth::user()->nombre_proveedor;

        $instalacion_asignados_proveedor = DB::connection(strtolower($proveedor))->table('instalacions')
            ->join('asignacion_instalacions', 'asignacion_instalacions.lista_instalacion_id', '=', 'instalacions.id')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select(
                'clientes.razon_social as cliente',
                'asignacion_instalacions.fecha_asignado',
                'instalacions.sSc as sc',
                'instalacions.sSerie as serie',
                'asignacion_instalacions.estado_asignacion',
                'instalacions.smarca as Csmarca'

            )
            ->where('clientes.id', '=', 0000)
            ->where('asignacion_instalacions.estado_asignacion', '=', 'repuestos')
            ->grupBy('serie')
            ->get();

        $table = "";

        foreach ($instalacion_asignados_proveedor as $datos) {
            $fecha = Carbon::createFromDate($datos->fecha_asignado)->format('d-m-Y H:s');
            $table .= "<tr>";
            $table .= "<td>" . strtoupper($datos->cliente) . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $datos->sc . "</td>";
            $table .= "<td>" . strtoupper($datos->serie) . "</td>";

            $table .= "<td>" . strtoupper($datos->Csmarca) . "</td>";
            $table .= "<td>" . strtoupper($datos->estado_asignacion) . "</td>";
            $table .= "<td>PDF</td>";
            $table .= "</tr>";
        }

        return $table;
    }

    public function revisarserviciosClienteProveedorasignadas(request $request)
    {

        // return "hh";

        // $id = $request->id;
        // $cliente_proveedor = $request->cliente;
// captura los id de los giltros
        if ($request->id == "" || $request->id == null){
            $id = $request->cliente;
        }else{

            $id = $request->id;
        }




        $proveedor = Auth::user()->nombre_proveedor;

        $cliente = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->where('api_solicitudes.id', '=', $id)
            ->select('api_solicitudes.sCliente as cliente')
            ->get();

        $dataquery = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select(
                'api_solicitudes.sCliente as cliente',
                'api_solicitudes.fecha_asignado as fecha',
                'api_solicitudes.sSC as sc',
                'api_solicitudes.sSerie as serie',
                'api_solicitudes.id',
                'api_solicitudes.estado_interno',
                'api_solicitudes.tipo_asignacion_interna',
                // 'api_solicitudes.estado_externo as estado_asignacion'
                'api_solicitudes.estado_interno as estado_asignacion',
                'api_solicitudes.Smarca as Csmarca',


            )
            ->where('api_solicitudes.sCliente', '=', $cliente[0]->cliente)
            ->where('api_solicitudes.estado_externo', '=', 'ASIGNADO')
            ->where('api_solicitudes.estado_interno', '=','tarea_asignada');

            if($request->fecha1 != "" || $request->fecha1 != null){
                $dataquery->where('api_solicitudes.fecha_asignado', 'like', '%' . $request->fecha1 . '%');
            }





            $instalacion_asignados_proveedor = $dataquery->groupBy('sc')
            ->orderBy('fecha_asignado', 'desc')
            ->get();

        $table = "";

        foreach ($instalacion_asignados_proveedor as $datos) {
            $fecha = Carbon::createFromDate($datos->fecha)->format('d-m-Y');
            $table .= "<tr>";

            if($datos->tipo_asignacion_interna == 0){
                $table .= "<td>" . "TECNICO EXTERNO" . "</td>";

            }else{
                $table .= "<td>" . "TECNICO INTERNO" . "</td>";

            }



            $datos_asignacion = DB::table('asignacion_solicitudes')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_solicitudes.api_solicitudes_id', '=', $datos->id)
            ->select('asignacion_solicitudes.id', DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) AS nombre_completo"), 'asignacion_solicitudes.estado_interno', 'asignacion_solicitudes.fecha')
            ->orderBy('asignacion_solicitudes.id', 'desc')
            ->get();



            $table .= "<td>" .strtoupper($datos_asignacion[0]->nombre_completo). "</td>";

            $table .= "<td>" . strtoupper($datos->cliente) . "</td>";
            $table .= "<td>" . $fecha . "</td>";

            
            $table .= "<td>" . $datos->sc . "</td>";
            $table .= "<td>" . strtoupper($datos->Csmarca) . "</td>";

            $table .= "<td>" . strtoupper($datos->serie) . "</td>";
            $table .= "<td>" . strtoupper($datos->estado_asignacion) . "</td>";
            
            $table .= '<td>
                        <a role="button" class="btn-icon btn-icon-dd ver_historial" title="Historial" onclick="historial_asignadas(' . $datos->id . ')" data-estado="' . $datos->estado_interno . '">
                            <span class="material-icons">history</span>
                        </a>
                        </td>';
            $table .= "</tr>";
        }

        return $table;
    }

    public function revisarserviciosClienteProveedorfinalizadas(request $request)
    {

        if ($request->id == "" || $request->id == null){
            $id = $request->cliente;
        }else{

            $id = $request->id;
        }



        $proveedor = Auth::user()->nombre_proveedor;

        $cliente = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->where('api_solicitudes.id', '=', $id)
            ->select('api_solicitudes.sCliente as cliente')
            ->get();

        $dataquery = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select(
                'api_solicitudes.sCliente as cliente',
                'api_solicitudes.fecha_asignado as fecha',
                'api_solicitudes.sSC as sc',
                'api_solicitudes.sSerie as serie',
                'api_solicitudes.id',
                'api_solicitudes.estado_interno',
                'api_solicitudes.tipo_asignacion_interna',
                // 'api_solicitudes.estado_externo as estado_asignacion'
                'api_solicitudes.estado_interno as estado_asignacion',
                'api_solicitudes.Smarca as Csmarca',

            )
            ->where('api_solicitudes.sCliente', '=', $cliente[0]->cliente)
            // ->where('api_solicitudes.estado_externo', '=', 'FINALIZADO')
           ->where('api_solicitudes.estado_interno', '=','FINALIZADO');

            if($request->fecha1 != "" || $request->fecha1 != null){
                $dataquery->where('api_solicitudes.fecha_asignado', 'like', '%' . $request->fecha1 . '%');
            }

            $instalacion_asignados_proveedor = $dataquery->groupBy('sc')
            ->orderBy('fecha_asignado', 'desc')
            ->get();
        $table = "";

        foreach ($instalacion_asignados_proveedor as $datos) {
            $fecha = Carbon::createFromDate($datos->fecha)->format('d-m-Y');
            $table .= "<tr>";

            if($datos->tipo_asignacion_interna == 0){
                $table .= "<td>" . "TECNICO EXTERNO" . "</td>";

            }else{
                $table .= "<td>" . "TECNICO INTERNO" . "</td>";

            }

              // ****TECNICO******


              $datos_asignacion = DB::table('asignacion_solicitudes')
              ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
              ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
              ->where('asignacion_solicitudes.api_solicitudes_id', '=', $datos->id)
              ->select('asignacion_solicitudes.id', DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) AS nombre_completo"), 'asignacion_solicitudes.estado_interno', 'asignacion_solicitudes.fecha')
              ->orderBy('asignacion_solicitudes.id', 'desc')
              ->get();

              if ($datos_asignacion->isEmpty()) {

                  if(strtoupper($datos->estado_asignacion)  == "ASIGNADO REMOTO"){
                      $getDataInformacion = App\asignacion_banco_api_solis::where('id_solicitud_remota', '=', $datos->id_solicitudes_remotas)->first();
                      $getDataInformacionTrabajador = App\persona::select(DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) AS nombre_completo"))
                      ->join("trabajadors","trabajadors.id_persona","=","personas.id")
                      ->where("trabajadors.id_login","=",$getDataInformacion->id_tecnico)->get();
                      $table .= "<td>" .strtoupper($getDataInformacionTrabajador[0]->nombre_completo ?? ''). "</td>";

                  }else{
                      $table .= "<td>" ."No Asignado". "</td>";

                  }

              } else {
                  $table .= "<td>" .strtoupper($datos_asignacion[0]->nombre_completo ?? ''). "</td>";

              }

            $table .= "<td>" . strtoupper($datos->cliente) . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $datos->sc . "</td>";
            $table .= "<td>" . strtoupper($datos->Csmarca) . "</td>";

            $table .= "<td>" . strtoupper($datos->serie) . "</td>";
            $table .= "<td>" . strtoupper($datos->estado_asignacion) . "</td>";
            $table .= '<td>
                        <a role="button" class="btn-icon btn-icon-dd ver_historial" title="Historial" onclick="historial(' . $datos->id . ')" data-estado="' . $datos->estado_interno . '">
                            <span class="material-icons">history</span>
                        </a>
                        </td>';
            $table .= "</tr>";
        }

        return $table;
    }

    public function revisarClienteProveedorServicio(request $request)
    {
        $id = $request->id;
        $proveedor = Auth::user()->nombre_proveedor;

        $cliente = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->where('api_solicitudes.id', '=', $id)
            ->select('api_solicitudes.sCliente as cliente','id_solicitudes_remotas')
            ->get();

        $instalacion_asignados_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            // ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select(
                'api_solicitudes.sCliente as cliente',
                'api_solicitudes.fecha_asignado as fecha',
                'api_solicitudes.sSC as sc',
                'api_solicitudes.sSerie as serie',
                'api_solicitudes.id',
                'api_solicitudes.id_solicitudes_remotas',
                'api_solicitudes.estado_interno',
                'api_solicitudes.tipo_asignacion_interna',
'api_solicitudes.Smarca as Csmarca',

                'api_solicitudes.estado_externo as estado_asignacion'
            )
            ->where('api_solicitudes.sCliente', '=', $cliente[0]->cliente)
            ->groupBy('sc')
            ->orderBy('fecha_asignado', 'desc')
            ->get();

        $table = "";

        foreach ($instalacion_asignados_proveedor as $datos) {
            $fecha = Carbon::createFromDate($datos->fecha)->format('d-m-Y');
            $table .= "<tr>";
            if($datos->tipo_asignacion_interna == 0){
                $table .= "<td>" . "TECNICO EXTERNO" . "</td>";

            }else{
                $table .= "<td>" . "TECNICO INTERNO" . "</td>";

            }


                            // ****TECNICO******


                            $datos_asignacion = DB::table('asignacion_solicitudes')
                            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
                            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
                            ->where('asignacion_solicitudes.api_solicitudes_id', '=', $datos->id)
                            ->select('asignacion_solicitudes.id', DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) AS nombre_completo"), 'asignacion_solicitudes.estado_interno', 'asignacion_solicitudes.fecha')
                            ->orderBy('asignacion_solicitudes.id', 'desc')
                            ->get();

                            if ($datos_asignacion->isEmpty()) {

                                if(strtoupper($datos->estado_asignacion)  == "ASIGNADO REMOTO"){
                                    $getDataInformacion = App\asignacion_banco_api_solis::where('id_solicitud_remota', '=', $datos->id_solicitudes_remotas)->first();
                                    $getDataInformacionTrabajador = App\persona::select(DB::raw("CONCAT(personas.nombre_uno, ' ', personas.apellido_uno, ' ', personas.apellido_dos) AS nombre_completo"))
                                    ->join("trabajadors","trabajadors.id_persona","=","personas.id")
                                    ->where("trabajadors.id_login","=",$getDataInformacion->id_tecnico)->get();
                                    $table .= "<td>" .strtoupper($getDataInformacionTrabajador[0]->nombre_completo ?? ''). "</td>";

                                }else{
                                    $table .= "<td>" ."No Asignado". "</td>";

                                }

                            } else {
                                $table .= "<td>" .strtoupper($datos_asignacion[0]->nombre_completo ?? ''). "</td>";

                            }




                            // *********

            $table .= "<td>" . strtoupper($datos->cliente) . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $datos->sc . "</td>";
            $table .= "<td>" . strtoupper($datos->Csmarca) . "</td>";

            $table .= "<td>" . strtoupper($datos->serie) . "</td>";
            $table .= "<td>" . strtoupper($datos->estado_asignacion) . "</td>";
            $table .= '<td>
                        <a role="button" class="btn-icon btn-icon-dd ver_historial" title="Historial" onclick="historial(' . $datos->id . ')" data-estado="' . $datos->estado_interno . '">
                            <span class="material-icons">history</span>
                        </a>
                        </td>';
            $table .= "</tr>";
        }

        return $table;
    }
    public function revisarClienteProveedorServicioRepuestos(request $request)
    {
        $id = $request->id;
        $proveedor = Auth::user()->nombre_proveedor;

        $cliente = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->where('api_solicitudes.id', '=', $id)
            ->select('api_solicitudes.sCliente as cliente')
            ->get();

        $instalacion_asignados_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select(
                'api_solicitudes.sCliente as cliente',
                'asignacion_solicitudes.fecha',
                'api_solicitudes.sSC as sc',
                'api_solicitudes.sSerie as serie',
                'asignacion_solicitudes.estado_externo as estado_asignacion',
                'api_solicitudes.id',
'api_solicitudes.Smarca as Csmarca',

                'api_solicitudes.estado_interno'
            )
            ->where('api_solicitudes.sCliente', '=', $cliente[0]->cliente)
            ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
            ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos')
            ->where("api_solicitudes.tipo_asignacion_interna","=","0")
                ->whereRaw('UPPER(api_solicitudes.zona_geoge) = ?', [strtoupper(Auth::user()->zona)])

            ->where('api_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
            ->groupBy('sc')
            ->orderBy('fecha', 'desc')
            ->get();

        $table = "";

        foreach ($instalacion_asignados_proveedor as $datos) {
            $fecha = Carbon::createFromDate($datos->fecha)->format('d-m-Y');
            $table .= "<tr>";
            $table .= "<td>" . strtoupper($datos->cliente) . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $datos->sc . "</td>";
            $table .= "<td>" . strtoupper($datos->Csmarca) . "</td>";

            $table .= "<td>" . strtoupper($datos->serie) . "</td>";
            $table .= "<td>" . strtoupper($datos->estado_asignacion) . "</td>";
            $table .= '<td>
                <a role="button" class="btn-icon btn-icon-dd ver_historial" title="Historial" onclick="historial(' . $datos->id . ')" data-estado="' . $datos->estado_interno . '">
                    <span class="material-icons">history</span>
                </a>
            </td>';
            $table .= "</tr>";
        }

        return $table;
    }
    public function filtro_repuestoServicio(request $request)
    {
        $cliente_proveedor = $request->cliente;
        $tecnico = $request->tecnico;
        $fecha1 = $request->fecha1;
        $fecha2 = $request->fecha2;
        $estado = $request->estado;
        $proveedor = Auth::user()->nombre_proveedor;

        $cliente = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->where('api_solicitudes.id', '=', $cliente_proveedor)
            ->select('api_solicitudes.sCliente as cliente')
            ->get();

        $instalacion_asignados_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select(
                'api_solicitudes.sCliente as cliente',
                'asignacion_solicitudes.fecha',
                'api_solicitudes.sSC as sc',
                'api_solicitudes.sSerie as serie',
                'api_solicitudes.Smarca as Csmarca',

                'asignacion_solicitudes.estado_externo as estado_asignacion',
                'api_solicitudes.id',
                'asignacion_solicitudes.estado_interno'
            )
            ->where('api_solicitudes.sCliente', '=', $cliente[0]->cliente)
            ->where('asignacion_solicitudes.estado_interno', '=', 'Solicitar Repuestos')
            ->where('asignacion_solicitudes.estado_externo', '=', 'Solicitar Repuestos');

        if ($tecnico != "") {
            $instalacion_asignados_proveedor->where('asignacion_solicitudes.trabajadors_id', '=', $tecnico);
        }
        if ($estado != "") {
            $instalacion_asignados_proveedor->where('asignacion_solicitudes.estado_externo', '=', $estado);
        }
        if ($fecha1 != "") {
            $instalacion_asignados_proveedor->where('asignacion_solicitudes.fecha', 'like', '%' . $fecha1 . '%');
        }
        if ($fecha2 != "") {
            $instalacion_asignados_proveedor->where('asignacion_solicitudes.fecha_fin', 'like', '%' . $fecha2 . '%');
        }
        $instalacion_asignados_proveedor->groupBy('sc');
        $instalacion_asignados_proveedor->orderBy('fecha', 'desc');
        $acumulador = $instalacion_asignados_proveedor->get();
        $table = "";

        foreach ($acumulador as $datos) {
            $fecha = Carbon::createFromDate($datos->fecha)->format('d-m-Y');
            $table .= "<tr>";
            $table .= "<td>" . strtoupper($datos->cliente) . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $datos->sc . "</td>";
            $table .= "<td>" . strtoupper($datos->Csmarca) . "</td>";

            $table .= "<td>" . strtoupper($datos->serie) . "</td>";
            $table .= "<td>" . strtoupper($datos->estado_asignacion) . "</td>";
            $table .= '<td>
                        <a role="button" class="btn-icon btn-icon-dd ver_historial" title="Historial" onclick="historial(' . $datos->id . ')" data-estado="' . $datos->estado_interno . '">
                            <span class="material-icons">history</span>
                        </a>
                        </td>';
            $table .= "</tr>";
        }

        return $table;
    }
    public function filtro_asignadoServicio(request $request)
    {
        $cliente_proveedor = $request->cliente;
        $tecnico = $request->tecnico;
        $fecha1 = $request->fecha1;
        $fecha2 = $request->fecha2;
        $estado = $request->estado;
        $proveedor = Auth::user()->nombre_proveedor;

        $cliente = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->where('api_solicitudes.id', '=', $cliente_proveedor)
            ->select('api_solicitudes.sCliente as cliente')
            ->get();

        $instalacion_asignados_proveedor = DB::connection(strtolower($proveedor))->table('api_solicitudes')
            ->join('asignacion_solicitudes', 'asignacion_solicitudes.api_solicitudes_id', '=', 'api_solicitudes.id')
            ->select(
                'api_solicitudes.sCliente as cliente',
                'asignacion_solicitudes.fecha',
                'api_solicitudes.sSC as sc',
                'api_solicitudes.sSerie as serie',
                'asignacion_solicitudes.estado_externo as estado_asignacion',
                'api_solicitudes.id',
                'api_solicitudes.estado_interno',
'api_solicitudes.Smarca as Csmarca',

            )
            ->where('api_solicitudes.sCliente', '=', $cliente[0]->cliente);

        if ($estado != "") {
            $instalacion_asignados_proveedor->where('asignacion_solicitudes.estado_externo', '=', $estado);
        }
        if ($fecha1 != "") {
            $instalacion_asignados_proveedor->where('asignacion_solicitudes.fecha', 'like', '%' . $fecha1 . '%');
        }
        if ($fecha2 != "") {
            $instalacion_asignados_proveedor->where('asignacion_solicitudes.fecha_fin', 'like', '%' . $fecha2 . '%');
        }
        $instalacion_asignados_proveedor->groupBy('sc');
        $instalacion_asignados_proveedor->orderBy('fecha', 'desc');
        $acumulador = $instalacion_asignados_proveedor->get();

        $table = "";
        foreach ($acumulador as $datos) {
            $fecha = Carbon::createFromDate($datos->fecha)->format('d-m-Y');
            $table .= "<tr>";
            $table .= "<td>" . strtoupper($datos->cliente) . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $datos->sc . "</td>";
            $table .= "<td>" . strtoupper($datos->Csmarca) . "</td>";

            $table .= "<td>" . strtoupper($datos->serie) . "</td>";
            $table .= "<td>" . strtoupper($datos->estado_asignacion) . "</td>";
            $table .= '<td>
            <a role="button" class="btn-icon btn-icon-dd ver_historial" title="Historial" onclick="historial(' . $datos->id . ')" data-estado="' . $datos->estado_interno . '">
                <span class="material-icons">history</span>
            </a>
            </td>';
            $table .= "</tr>";
        }

        return $table;
    }
    public function filtro_asignadoins_ret(request $request)
    {
        $cliente_proveedor = $request->cliente;
        $tecnico = $request->tecnico;
        $fecha1 = $request->fecha1;
        $fecha2 = $request->fecha2;
        $estado = $request->estado;
        $proveedor = Auth::user()->nombre_proveedor;

        $retiros_asignados_proveedor = DB::connection(strtolower($proveedor))->table('retiros')
            ->join('asignacion_retiros', 'asignacion_retiros.retiros_id', '=', 'retiros.id')
            ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select(
                'clientes.razon_social as cliente',
                'asignacion_retiros.fecha_asignado',
                DB::raw("NULL as sc"),
                'retiros.sSerie as serie',
                'asignacion_retiros.estado_asignacion',
                'retiros.id'
            )
            ->where('clientes.id', '=', $cliente_proveedor);
        $instalacion_asignados_proveedor = DB::connection(strtolower($proveedor))->table('instalacions')
            ->join('asignacion_instalacions', 'asignacion_instalacions.lista_instalacion_id', '=', 'instalacions.id')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select(
                'clientes.razon_social as cliente',
                'asignacion_instalacions.fecha_asignado',
                'instalacions.sSc as sc',
                'instalacions.sSerie as serie',
                'asignacion_instalacions.estado_asignacion',
                'instalacions.id',
                'instalacions.smarca as Csmarca'

            )
            ->where('clientes.id', '=', $cliente_proveedor);
        if ($tecnico != "") {
            $retiros_asignados_proveedor->where('asignacion_retiros.trabajadors_idtecnico', '=', $tecnico);
            $instalacion_asignados_proveedor->where('asignacion_instalacions.trabajadors_id', '=', $tecnico);
        }
        if ($estado != "") {
            $retiros_asignados_proveedor->where('asignacion_retiros.estado_asignacion', '=', $estado);
            $instalacion_asignados_proveedor->where('asignacion_instalacions.estado_asignacion', '=', $estado);
        }
        if ($fecha1 != "") {
            $retiros_asignados_proveedor->where('asignacion_retiros.fecha_asignado', 'like', '%' . $fecha1 . '%');
            $instalacion_asignados_proveedor->where('asignacion_instalacions.fecha_asignado', 'like', '%' . $fecha1 . '%');
        }
        if ($fecha2 != "") {
            $retiros_asignados_proveedor->where('asignacion_retiros.fecha_termino', 'like', '%' . $fecha2) . '%';
            $instalacion_asignados_proveedor->where('asignacion_instalacions.fecha_termino', '=', '%' . $fecha2 . '%');
        }
        $instalacion_asignados_proveedor->union($retiros_asignados_proveedor);
        $instalacion_asignados_proveedor->orderBy('fecha_asignado', 'desc');
        $acumulador = $instalacion_asignados_proveedor->get();

        $table = "";

        foreach ($acumulador as $datos) {
            $fecha = Carbon::createFromDate($datos->fecha_asignado)->format('d-m-Y H:s');
            $table .= "<tr>";
            $table .= "<td>" . strtoupper($datos->cliente) . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $datos->sc . "</td>";
            $table .= "<td>" . strtoupper($datos->Csmarca) . "</td>";

            $table .= "<td>" . strtoupper($datos->serie) . "</td>";
            $table .= "<td>" . strtoupper($datos->estado_asignacion) . "</td>";
            $table .= '<td>
                            <a role="button" class="btn-icon btn-icon-dd" title="Historial" onclick="historial_ins(' . $datos->id . ')">
                            <span class="material-icons">history</span>
                            </a>
                    </td>';
            $table .= "</tr>";
        }

        return $table;
    }
    public function filtro_repuestoins_ret(request $request)
    {
        $cliente_proveedor = $request->cliente;
        $tecnico = $request->tecnico;
        $fecha1 = $request->fecha1;
        $fecha2 = $request->fecha2;
        $estado = $request->estado;
        $proveedor = Auth::user()->nombre_proveedor;

        $instalacion_asignados_proveedor = DB::connection(strtolower($proveedor))->table('asignacion_instalacions')
            ->join('checklist_instalacions', 'checklist_instalacions.asignacion_instalacion_retiro_id', '=', 'asignacion_instalacions.id')
            ->join('instalacions', 'instalacions.id', '=', 'asignacion_instalacions.lista_instalacion_id')
            ->join('tracker', 'tracker.id', '=', 'instalacions.tracker_idtracker')
            ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->select(
                'clientes.razon_social as cliente',
                'personas.nombre_uno',
                'personas.apellido_uno',
                'asignacion_instalacions.fecha_asignado',
                'checklist_instalacions.CsSC as sc',
                'checklist_instalacions.CsSerie as serie',
                'asignacion_instalacions.estado_asignacion',
                    'checklist_instalacions.Csmarca',

            )
            ->where('clientes.id', '=', $cliente_proveedor)
            ->where('checklist_instalacions.motivo', '=', '');
        if ($tecnico != "") {
            $instalacion_asignados_proveedor->where('asignacion_instalacions.trabajadors_id', '=', $tecnico);
        }
        if ($estado != "") {
            $instalacion_asignados_proveedor->where('asignacion_instalacions.estado_asignacion', '=', $estado);
        }
        if ($fecha1 != "") {
            $instalacion_asignados_proveedor->where('asignacion_instalacions.fecha_asignado', 'like', '%' . $fecha1 . '%');
        }
        if ($fecha2 != "") {
            $instalacion_asignados_proveedor->where('asignacion_instalacions.fecha_termino', 'like', '%' . $fecha2 . '%');
        }
        $acumulador = $instalacion_asignados_proveedor->get();

        $table = "";

        foreach ($acumulador as $datos) {
            $fecha = Carbon::createFromDate($datos->fecha_asignado)->format('d-m-Y H:s');
            $table .= "<tr>";
            $table .= "<td>" . strtoupper($datos->cliente) . "</td>";
            $table .= "<td>" . $fecha . "</td>";
            $table .= "<td>" . $datos->sc . "</td>";
            $table .= "<td>" . strtoupper($datos->Csmarca) . "</td>";

            $table .= "<td>" . strtoupper($datos->serie) . "</td>";
            $table .= "<td>" . strtoupper($datos->nombre_uno) . " " . strtoupper($datos->apellido_uno) . "</td>";
            $table .= "<td>" . strtoupper($datos->estado_asignacion) . "</td>";
            $table .= "<td>PDF</td>";
            $table .= "</tr>";
        }

        return $table;
    }
    public function solicitudes_asociados_proveedors(Request $r)
    {
        $proveedor = Auth::user()->nombre_proveedor;

        $idSolicitudServicio = $r->id_solicitud;

        $datos_asignacion =  DB::connection(strtolower($proveedor))->table('asignacion_solicitudes')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_solicitudes.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_solicitudes.api_solicitudes_id', '=', $idSolicitudServicio)
            ->select('asignacion_solicitudes.finalizado_remoto','asignacion_solicitudes.id_solicitud_remota','asignacion_solicitudes.id', 'personas.nombre_uno', 'personas.apellido_uno', 'asignacion_solicitudes.estado_interno', 'asignacion_solicitudes.fecha')
            ->orderBy('asignacion_solicitudes.id', 'desc')
            ->get();

            $GetDataSolicitud =  DB::connection(strtolower($proveedor))->table('api_solicitudes')->where("id","=",$idSolicitudServicio)->get();

        $tbody = "";
        $i = 1;
        $totoal = count($datos_asignacion);
        $totoal = $totoal + 1;
        if (count($datos_asignacion) > 0) {
            foreach ($datos_asignacion as $row) {

                $j = $i++;

                $tbody .= "<tr>";
                $tbody .= "<td>" . $idSolicitudServicio . "</td>";
                $tbody .= "<td>" . ($totoal - $j) . "</td>";
                $tbody .= "<td> " . $row->nombre_uno . " " . $row->apellido_uno . "</td>";
                if ($row->estado_interno == "PENDIENTE" || $row->estado_interno == "PENDIENTE") {
                    $tbody .= '<td class="PENDIENTE">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "CANCELADO" || $row->estado_interno == "CANCELADO") {
                    $tbody .= '<td class="CANCELADO">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "REASIGNAR" || $row->estado_interno == "REASIGNAR") {
                    $tbody .= '<td class="CANCELADO">' . "REASIGNAR" . "</td>";
                } else if ($row->estado_interno == "FINALIZADO" || $row->estado_interno == "FINALIZADO") {
                    $tbody .= '<td class="FINALIZADO">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "ASIGNADO" || $row->estado_interno == "ASIGNADO") {
                    $tbody .= '<td class="ASIGNADO">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "REVISAR" || $row->estado_interno == "revisar") {
                    $tbody .= '<td class="revisado">' . "REVISAR" . "</td>";
                } else if ($row->estado_interno == "RECHAZADO" || $row->estado_interno == "RECHAZADO") {
                    $tbody .= '<td class="RECHAZADO">' . $row->estado_interno . "</td>";
                } else if ($row->estado_interno == "tarea_asignada" || $row->estado_interno == "Tarea_asignada") {
                    $tbody .= '<td class="PENDIENTE">' . "Tarea Asignada" . "</td>";
                } else {
                    $tbody .= '<td class="PENDIENTE">' . $row->estado_interno . "</td>";
                }

                //boton editar
                $tbody .= "<td>";
                $tbody .= '<a href="#" role="button" title="Editar">';
                $tbody .= "</a>";

                //boton historial para la coordinadora

                // <a class="btn-icon btn-icon-dd" href="{{ route('generar.pdfProveedorServicios',Crypt::encryptString($los_datos->idAsignacion ?? '')) }}"><span class="material-icons-round">picture_as_pdf</span></a>

                // if ($row->estado_interno != "REVISAR" && $row->estado_interno != "revisar" && $row->estado_interno != "FINALIZADO" && $row->estado_interno && "FINALIZADO") {
                //boton finalizar
                
                    if($GetDataSolicitud[0]->asignado_aya == "NO"){
                        if($row->finalizado_remoto == 0){
                            $tbody .= "<a target='_blank' href='" . route('generar.pdfProveedorServicios', Crypt::encryptString($row->id)) . "' role='button' title='PDF'>";
                            $tbody .= "<span class='material-icons-round'>picture_as_pdf</span>";
                            $tbody .= "</a>";
                        }else{
                            $tbody .= "<a target='_blank' href='" . route('go.pdfremoto', ['idremoto' => encrypt($row->id_solicitud_remota)]) . "' role='button' title='PDF'>";
                            $tbody .= "<span class='material-icons-round'>picture_as_pdf</span>";
                            $tbody .= "</a>";
                            // finalizado_remoto
        
                        }
                    }else{
                                                // https://www.suivi.cl/sistema/sistemacaja/storage/app/public/pdfs_aya/230420243servicio.pdf
                                                //www.suivi.cl/sistema/rendicion/../public/storage/pdfs_aya/230420244servicio.pdf

                        $publicPath = asset('../sistemacaja/storage/app/public/'.$GetDataSolicitud[0]->url_pdf);
                        $tbody .= "<a target='_blank'  href=".$publicPath." role='button' title='PDF'>";
                        $tbody .= "<span class='material-icons-round'>picture_as_pdf</span>";
                        $tbody .= "</a>";
                    }
               
                // }

                $tbody .= "</td>";
                $tbody .= "</tr>";
            }
        } else {
            $tbody .= "<tr>";
            $tbody .= "<td>Sin Datos</td>";
            $tbody .= "</tr>";
        }

        return $tbody;
    }
    public function check_asociados_proveedors(Request $request)
    {
        $id_instalacion = $request->id_instalacion;
        $proveedor = Auth::user()->nombre_proveedor;

        $datos_asignacion = DB::connection(strtolower($proveedor))->table('asignacion_instalacions')
            ->join('trabajadors', 'trabajadors.id', '=', 'asignacion_instalacions.trabajadors_id')
            ->join('personas', 'personas.id', '=', 'trabajadors.id_persona')
            ->where('asignacion_instalacions.lista_instalacion_id', '=', $id_instalacion)
            ->select('asignacion_instalacions.id', 'personas.nombre_uno', 'personas.apellido_uno', 'asignacion_instalacions.estado_asignacion', 'asignacion_instalacions.fecha_instalacion')
            ->orderBy('asignacion_instalacions.id', 'desc')
            ->get();
        $i = 1;
        $totoal = count($datos_asignacion);
        $totoal = $totoal + 1;
        $tbody = "";

        if (count($datos_asignacion) > 0) {
            foreach ($datos_asignacion as $row) {
                $j = $i++;
                $tbody .= "<tr>";
                $tbody .= "<td>" . $id_instalacion . "</td>";
                $tbody .= "<td>" . ($totoal - $j) . "</td>";
                $tbody .= "<td> " . $row->nombre_uno . " " . $row->apellido_uno . "</td>";
                if ($row->estado_asignacion == "pendiente" || $row->estado_asignacion == "Pendiente") {
                    $tbody .= '<td class="pendiente">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "cancelado" || $row->estado_asignacion == "Cancelado") {
                    $tbody .= '<td class="cancelado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "reasignar" || $row->estado_asignacion == "Reasignar") {
                    $tbody .= '<td class="cancelado">' . "Reasignar" . "</td>";
                } else if ($row->estado_asignacion == "finalizado" || $row->estado_asignacion == "Finalizado") {
                    $tbody .= '<td class="finalizado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "asignado" || $row->estado_asignacion == "Asignado") {
                    $tbody .= '<td class="asignado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "revisar" || $row->estado_asignacion == "revisar") {
                    $tbody .= '<td class="revisado">' . "Revisar" . "</td>";
                } else if ($row->estado_asignacion == "rechazado" || $row->estado_asignacion == "Rechazado") {
                    $tbody .= '<td class="rechazado">' . $row->estado_asignacion . "</td>";
                } else if ($row->estado_asignacion == "tarea_asignada" || $row->estado_asignacion == "Tarea_asignada") {
                    $tbody .= '<td class="pendiente">' . "Tarea Asignada" . "</td>";
                }
                //boton editar
                $tbody .= "<td>";
                //boton finalizar
                $tbody .= "<a target='_blank' href='" . route('generar.pdfCordinadoraInstalacion', Crypt::encryptString($row->id)) . "' role='button' title='Ver PDF'>";
                $tbody .= "<span class='material-icons-round'>picture_as_pdf</span>";
                $tbody .= "</a>";
                $tbody .= "</td>";
                $tbody .= "</tr>";
            }
        } else {
            $tbody .= "<tr>";
            $tbody .= "<td>Sin Datos</td>";
            $tbody .= "</tr>";
        }
        return $tbody;
    }


    public function solicitud_repuestos()
    {

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        foreach ($databases as $los_datos) {
            $pendientes_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                    api_solicitudes.sCliente as cliente,
                    api_solicitudes.sRegion as region,
                    api_solicitudes.sComuna as comuna,
                    api_solicitudes.sSc as serie,
                    api_solicitudes.estado_interno,
                    api_solicitudes.estado_externo,
                    api_solicitudes.proveedor_servicio as proveedor,
                    api_solicitudes.id as id,
                    asignacion_solicitudes.fecha_inicio as fecha,
                    asignacion_solicitudes.id as id_asig,
                    personas.nombre_uno,
                    api_solicitudes.Smarca,

                    personas.apellido_uno,
                    api_solicitudes.sDescripcion

                FROM
                    api_solicitudes
                LEFT JOIN
                    asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                LEFT JOIN
                    trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                LEFT JOIN
                    personas on personas.id = trabajadors.id_persona
                WHERE
                api_solicitudes.tipo_asignacion_interna = 0 and  api_solicitudes.zona_geoge = '."'".Auth::user()->zona."'".' and api_solicitudes.estado_interno = "Solicitar Repuestos" and asignacion_solicitudes.estado_interno = "Solicitar Repuestos" and asignacion_solicitudes.estado_externo = "Solicitar Repuestos" ');
        }
        // api_solicitudes.estado_externo = "Solicitar Repuestos" and asignacion_solicitudes.estado_interno = "Solicitar Repuestos" ');

        $table = "";
        for ($i = 0; $i < count($pendientes_coordinador); $i++) {
            foreach ($pendientes_coordinador[$i] as $d1) {
                if($d1->estado_interno != "FINALIZADO"){
                    $table .= "<tr>";
                    $table .= "<td>" .strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                    $table .= "<td>" . Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s')  . "</td>";
                    $table .= "<td>" . $d1->cliente  . "</td>";
                    $table .= "<td>" . $d1->region  . "</td>";
                    $table .= "<td>" . $d1->Smarca  . "</td>";

                    $table .= "<td>" . $d1->serie . "</td>";
                    $table .= "<td>" . $d1->estado_externo . "</td>";
                    $table .= "<td>" . $d1->sDescripcion . "</td>";
                    $table .= "<td>" . $d1->proveedor . "</td>";


                    if($d1->estado_interno == ""){
                        $table .=
                        '<td>
                            <form action="' . route('go.asignar_check_servicios_home') . '" method="GET">
                                <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                <input type="hidden" value="' . $d1->id . '" name="id">
                                <button type="submit" class="btn btn-prim px sm-4" id="btnview">Asignar</button>
                            </form>
                        </td>';
                    }elseif($d1->estado_interno == "Solicitar Repuestos"){
                        $table .=
                        '<td>
                            <form action="' . route('go.ver_check_solicitud_cordinadora_home') . '" method="GET" target="_blank">
                                <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                <input type="hidden" value="' . $d1->id_asig . '" name="id">
                                <button type="submit" class="btn btn-prim px sm-4" id="btnview">Revisar</button>
                            </form>
                        </td>';
                    }
                    $table .= "</tr>";
                }
            }
        }
        return $table;
    }





    public function estado_intalar_repuestos()
    {

        //$databases = $this->nombre_database();
                $databases = App\bd_proveedores::selectDB();


        foreach ($databases as $los_datos) {
            $pendientes_coordinador[] = DB::connection(strtolower($los_datos->Database))->select(
                'SELECT
                    api_solicitudes.sCliente as cliente,
                    api_solicitudes.sRegion as region,
                    api_solicitudes.sComuna as comuna,
                    api_solicitudes.sSc as serie,
                    api_solicitudes.estado_interno,
                    api_solicitudes.estado_externo,
                    api_solicitudes.proveedor_servicio as proveedor,
                    api_solicitudes.id as id,
                    asignacion_solicitudes.fecha_inicio as fecha,
                    asignacion_solicitudes.id as id_asig,
                    personas.nombre_uno,
                    personas.apellido_uno,
                    api_solicitudes.Smarca,

                    api_solicitudes.sDescripcion

                FROM
                    api_solicitudes
                LEFT JOIN
                    asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id
                LEFT JOIN
                    trabajadors on trabajadors.id = asignacion_solicitudes.trabajadors_id
                LEFT JOIN
                    personas on personas.id = trabajadors.id_persona
                WHERE
                api_solicitudes.tipo_asignacion_interna = 0 and    api_solicitudes.estado_externo = "Instalar repuesto"');
        }
        $table = "";
        for ($i = 0; $i < count($pendientes_coordinador); $i++) {
            foreach ($pendientes_coordinador[$i] as $d1) {
                if($d1->estado_interno != "FINALIZADO"){
                    $table .= "<tr>";
                    $table .= "<td>" .strtoupper($d1->nombre_uno) . " " . strtoupper($d1->apellido_uno) . "</td>";
                    $table .= "<td>" . Carbon::createFromDate($d1->fecha)->format('d-m-Y H:s')  . "</td>";
                    $table .= "<td>" . $d1->cliente  . "</td>";
                    $table .= "<td>" . $d1->region  . "</td>";
                    $table .= "<td>" . $d1->Smarca  . "</td>";

                    $table .= "<td>" . $d1->serie . "</td>";
                    $table .= "<td>" . $d1->estado_externo . "</td>";
                    $table .= "<td>" . $d1->sDescripcion . "</td>";
                    $table .= "<td>" . $d1->proveedor . "</td>";


                    if($d1->estado_interno == ""){
                        $table .=
                        '<td>
                            <form action="' . route('go.asignar_check_servicios_home') . '" method="GET">
                                <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                <input type="hidden" value="' . $d1->id . '" name="id">
                                <button type="submit" class="btn btn-prim px sm-4" id="btnview">Asignar</button>
                            </form>
                        </td>';
                    }elseif($d1->estado_interno == "Solicitar Repuestos"){
                        $table .=
                        '<td>
                            <form action="' . route('go.ver_check_solicitud_cordinadora_home') . '" method="GET" target="_blank">
                                <input type="hidden" value="' . $d1->proveedor . '" name="proveedor">
                                <input type="hidden" value="' . $d1->id_asig . '" name="id">
                                <button type="submit" class="btn btn-prim px sm-4" id="btnview">Revisar</button>
                            </form>
                        </td>';
                    }
                    $table .= "</tr>";
                }
            }
        }
        return $table;
    }

    public function calcularHoraDos($fechaIngreso,$proveedor ="",$region = ""){


              //  return "aksdlkñlsadksakdskñl";
if($region == "RM" || $region== "Metropolitana" || $region == "METROPOLITANA" || $region == "rm" || $region == "rm" || $region == "13" || $region == "XIII" || $region == "XIII" ){
    $dataSla = DB::table('config_usuarios')->select("sla_santiago")->where('nombre_proveedor', $proveedor)->where("estado","=",1)->first();

    $cantidadHorasSla = $dataSla->sla_santiago;

}else{
    $dataSla = DB::table('config_usuarios')->select("sla")->where('nombre_proveedor', $proveedor)->where("estado","=",1)->first();

       $cantidadHorasSla = $dataSla->sla;


}


        $fechaIngreso = new Carbon($fechaIngreso);
        $dateIngreso =        $fechaIngreso->format('Y/m/d')."";
        $horaIngreso = $fechaIngreso->format('H:i:s');
        $horaIngresoEntero = $fechaIngreso->format('Hi');
        $minutoIngresoEntero = $fechaIngreso->format('i');
        //HORA ACTUAL
       $fechaActual=  Carbon::now();
       $dateActual =        $fechaActual->format('Y/m/d')."";
       $horaActual = $fechaActual->format('H:i:s');
       $horaActualEntero = $fechaActual->format('Hi');
       $minutoActualEntero = $fechaActual->format('i');

        //HORAS DE COLACIOM
        $horaColacionInicio = 1300;
        $horaColacionFinal =1400;
        $totalDeHoras =1;
      //  $cantidadHorasSla = 14;

        //HORAS DE LA JORNADA
        $HoraInicioJornada = '08:00:00';
        $HoraFinJornada = '18:00:00';
        $HoraFinJornadaActualEntero = 1800;
        // return $horaIngreso ;
        // Fecha de inicio
        //$start_date = new Carbon('2023:01:09');
        $start_date = new Carbon($dateIngreso);
        // Fecha de finalización
        //$end_date = new Carbon('2023:01:10');
        $end_date = new Carbon($dateActual);

        // Horas trabajadas totales
        $total_hours = 0;
        $diasTrans = 0;


        // Recorre cada día entre las dos fechas
        while ($start_date->lte($end_date)) {

            $dte =  $start_date->format('Y-m-d');
            $diasFestivos = DB::table('dias_festivos')->where('fecha_festiva', $dte)->where("estado","=",0)->exists();


            // Si el día es hábil (lunes a viernes)
            if ($start_date->dayOfWeekIso <= 5 && $diasFestivos < 1) {


                if($diasTrans == 0){
                    // Hora de inicio
                    // $start_time = new Carbon($start_date->format('Y-m-d') . ' 15:00:00');
                    $start_time = new Carbon($start_date->format('Y-m-d') .' '.$horaIngreso);

                    // Hora de finalización
                    // $end_time = new Carbon($start_date->format('Y-m-d') . ' 18:00:00');
                    $end_time = new Carbon($start_date->format('Y-m-d') .' '. $HoraFinJornada);
                    if($horaIngresoEntero >=$horaColacionFinal){
                        $work_duration = $start_time->diffInHours($end_time);

                    }else{
                        $work_duration = $start_time->diffInHours($end_time)-1;

                    }
            }else{
                //     // Hora de inicio
                //  $start_time = new Carbon($start_date->format('Y-m-d') . ' 08:00:00');
                $start_time = new Carbon($start_date->format('Y-m-d') . $HoraInicioJornada);

                // // Hora de finalización
                //  $end_time = new Carbon($start_date->format('Y-m-d') . ' 18:00:00');
                $end_time = new Carbon($start_date->format('Y-m-d') .' '.$HoraFinJornada);

                $work_duration = $start_time->diffInHours($end_time)-1;

                }

                // Duración del trabajo
            // $work_duration = $start_time->diffInHours($end_time);

                // Resta 30 minutos (0.5 horas) de pausa para colación a la duración del trabajo
            // $work_duration -= 1;

                // Añade la duración del trabajo a las horas trabajadas totales
                $total_hours += $work_duration;

                $diasTrans = 1;
            }




            // Avanza al siguiente día
            $start_date->addDay();
        }


        // $horaActual = new Carbon('0000-00-00 17:00:00');
        $horaActual = new Carbon('0000-00-00 ' .' '.$horaActual);
        //calculamos las horas ranscurridas
        // $dif ="0000-00-00 18:00:00";
        $dif ="0000-00-00  ".$HoraFinJornada;
        $dif_ = new \Carbon\Carbon($horaActual);
        $dif2_ = new \Carbon\Carbon($dif);

        $horasDif=   $dif_->diffInHours($dif2_, true);

        if($horaActualEntero>$HoraFinJornadaActualEntero){


            $difMinuto = $minutoIngresoEntero -$minutoActualEntero;

           if($difMinuto <= 0){
               $total=  $cantidadHorasSla - $total_hours+1 ;
               $difMinuto = 60 + $difMinuto;
           }else{
               $total=  $cantidadHorasSla - $total_hours ;

           }

           $formatos= abs((abs($total)-$cantidadHorasSla+1))."Hrs ".$difMinuto." Min";
           return [$total_hours, $formatos];
           // return $total_hours;

        }else{
             $difMinuto = $minutoIngresoEntero -$minutoActualEntero;

           if($difMinuto <= 0){
               $total=  $total_hours - $horasDif+1+1 ;
               $difMinuto = 60 + $difMinuto;
           }else{
               $total=  $total_hours - $horasDif +1 ;

           }
           // $total=  $total_hours - $horasDif ;
           $formatos= abs((abs($total)-$cantidadHorasSla))."Hrs ".$difMinuto." Min";
           return [$total, $formatos];
        }

        // if($horaActualEntero>$HoraFinJornadaActualEntero){


        //     $difMinuto = abs($minutoIngresoEntero -$minutoActualEntero);
        //     $total=  $cantidadHorasSla - $total_hours ;
        //     $formatos= abs((abs($total)-$cantidadHorasSla+1))."Hrs ".$difMinuto." Min";
        //     return [$total_hours, $formatos];
        //     // return $total_hours;

        // }else{
        //     $difMinuto = abs($minutoIngresoEntero -$minutoActualEntero);
        //     $total=  $total_hours - $horasDif ;
        //     $formatos= abs((abs($total)-$cantidadHorasSla+1))."Hrs ".$difMinuto." Min";
        //     return [$total, $formatos];
        // }


        // echo "Horas trabajadas totales: $total_hours";

    }
}