@extends('menu/menu')
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>
<script src="https://html2canvas.hertzen.com/dist/html2canvas.js"></script>
@section('content')
<style>
    canvas {
        width: 250px;
        height: 250px;
        background-color: #fff;
    }

    @media screen and (max-width: 768px) {
        canvas {
            width: 250px;
            height: 250px;
            z-index: 99999;
            float: center;
            background-color: #fff;
        }
    }
    select:-internal-list-box option:checked {
        background-color: green !important;
        color: orange;
    }
</style>
@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

<div class="container mt-5">
    <div class="title-vista mt-4">Capacitación</div>
</div>

<form action="{{ route('create.addcapacitacion')}} " method="POST" enctype="multipart/form-data">
    @csrf
    <div class="container mt-4">
        <!-- BARRA DE BUSQUEDA -->
        <div class="seccion-filtro">Datos de la sucursal</div>
        <hr class="separador">
        <div class="row">
            <!-- Fila 1 ------------------------------------------------------>
            <div class="col-sm-3 form-group">
                <label for="email">CUI o Código Sucursal</label>
                <input type=""  class="form-control mayuscula" id="dcui" value="{{$cambioestado[0]->sCui ?? ''}}" placeholder="CUI o Código sucursal" name="dcui">
                <input type="hidden" required class="form-control" id="id_asignacion" value="{{$capas[0]->id ?? ''}}" placeholder="CIUDAD" name="id_asignacion">
            </div>
            <div class="col-sm-3 form-group">
                <label for="email">Cliente</label>
                <input type="" required class="form-control mayuscula" id="cliente" value="{{$cambioestado[0]->sCliente ?? ''}}" placeholder="Cliente" name="cliente">
            </div>
            <div class="col-sm-3 form-group">
                <label for="">Proyecto asociado</label>
                <select id="proyectos" name="proyectos" class="custom-select mayuscula col-mb-3">
                    <option value="" selected>SELECCIONE</option>
                    @if(!empty($proyectos))
                    @foreach ($proyectos as $los_datos3)
                    @if ($los_datos3->id_proyecto != null)
                    @if(empty($proyecto_asociado[0]->id))
                    <option value="{{$los_datos3->id_proyecto}}">{{$los_datos3->nombre." (".$los_datos3->razon_social.")" }} </option>
                    @elseif($los_datos3->id_proyecto == $proyecto_asociado[0]->id)
                    <option value="{{$los_datos3->id_proyecto}}" selected>{{$los_datos3->nombre." (".$los_datos3->razon_social.")" }} </option>
                    @endif
                    @endif
                    @endforeach
                    @endif
                </select>
            </div>
            <div class="col-sm-3 form-group">
                <label for="email">Técnico</label>
                <input type="" required class="form-control mayuscula" id="" placeholder="Técnico" name="" value="{{ $datos_tecnico[0]->nombre_uno." ". $datos_tecnico[0]->apellido_uno }}">
            </div>
            <!-- Fila 2 ------------------------------------------------------>
            <div class="col-sm-6 form-group">
                <label for="email">Dirección</label>
                <input type="" required class="form-control mayuscula" id="direccion" placeholder="Dirección" name="direccion" value="{{$cambioestado[0]->sDireccion ?? ''}}">
            </div>
            <div class="col-sm-3 form-group">
                <label for="email">Comuna</label>
                <input type="" required class="form-control mayuscula" id="comuna" placeholder="Comuna" name="comuna" value="{{$cambioestado[0]->sComuna ?? ''}}">
            </div>
            <div class="col-sm-3 form-group">
                <label for="email">Ciudad</label>
                <input type="" required class="form-control mayuscula" id="ciudad" placeholder="Ciudad" name="ciudad" value="{{$cambioestado[0]->sCiudad ?? ''}}">
                <input type="hidden" required class="form-control mayuscula" id="idtecnico" value="{{$firma_datos[0]->id_tecnico}}" placeholder="Ciudad" name="idtecnico">
            </div>
        </div>
        <!--NUEVO MODAL IMAGENES-->
        <div class="seccion-filtro mt-2">Imágenes</div>
        <hr class="separador">
        <div class="row">
            <div class="col-sm-12 form-group">
                <label class="d-block" for="">Subir imágenes</label>
                <div class="text-center modo-escritorio">
                    <button class="btn btn-secundario asignarimagen col-sm-3" type="button">Imágenes</button>
                    <!--<button type="button" class="btn btn-secundario col-sm-3" data-toggle="modal" data-target="#modal_fotos_android">Android</button>
					<button type="button" class="btn btn-secundario col-sm-3" data-toggle="modal" data-target="#modal_fotos_email">Email</button>-->
                </div>
                <div class="text-center modo-mobil">
                    <button class="btn btn-secundario asignarimagen btn-block" type="button">Imágenes</button>
                    <!--<button type="button" class="btn btn-secundario btn-block" data-toggle="modal" data-target="#modal_fotos_android">Android</button>
					<button type="button" class="btn btn-secundario btn-block" data-toggle="modal" data-target="#modal_fotos_email">Email</button>-->
                </div>
            </div>
        </div>
        <!-- Fila 3 ------------------------------------------------------>
        <div class="seccion-filtro">Asignación</div>
        <hr class="separador">
        <div class="row">
            <!-- CARGA DE IMAGEN
            <div class="col-sm-4 form-group">
                <label for="email">Adjunte una imagen de la capacitación</label>
                <input type="file" class="custom-file mayuscula" id="cargafoto1" name="cargafoto1">
                <SE OCULTA BOTON APLICACION
                <button type="button" style="display:none" class="btn btn-secundario w-25 mt-3" data-toggle="modal" data-target="#modal_fotos_android">Android</button>
            </div>-->
            <div class="col-sm-6 form-group">
                <label for="email">Área sucursal capacitacion</label>
                <input type="text" required class="form-control mayuscula" value="" name="area_sucursal">
            </div>
            <div class="col-sm-6 form-group">
                <label for="email">Nº de personas capacitadas</label>
                <input type="number" required class="form-control mayuscula" id="nupersonas" onKeyPress="return soloNumeros(event)" placeholder="0" name="nupersonas">
            </div>
        </div>
        <div class="seccion-filtro">Personas</div>
        <hr class="separador">
        <div class="row">
            <div class="col-sm-6 form-group">
                <div class="overflow-auto">
                    <label for="">Personas Capacitadas</label>
                    <div class="input-group mb-3">
                        <input type="" class="form-control mayuscula" id="scontacto_old" placeholder="Datos del contacto" name="scontacto">
                        <span class="input-group-text btn-prim-input btn" id="agregar">Agregar</span>
                    </div>
                    <div class="" id="listaarrow_old"></div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="form-group" id="multiselect">
                    <select multiple name="selecionados[]" size="3" class="form-control" id="mi_select_2"></select>
                </div>
            </div>
            <div class="col-sm-12 form-group">
                <label for="observacion">Observación</label>
                <textarea class="form-control" id="observacion" required value="" rows="3" name="observacion"></textarea>
            </div>
        </div>

        <div class="row">
            <!-- FIRMAS CONTRAPARTES -->
            <div class="col-sm-6">
                <div class="row">
                    <div class="col-sm-12 form-group">
                        <label for="email">Datos del Técnico</label>
                        <input type="" required class="form-control" id="" style="pointer-events: none" readonly="readonly" placeholder="Datos del técnico" name="" value="{{ $datos_tecnico[0]->nombre_uno." ". $datos_tecnico[0]->apellido_uno }}">
                    </div>
                    <div class="col-sm-12 form-group">
                        <label for="email">Firma técnico</label>
                        <img src="{{ asset ("fotos/".$firma_datos[0]->url_firma)}}" alt="">
                    </div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="row">
                    <div class="col-sm-12 form-group">
                        <label for="email">Datos de contacto</label>
                        <input type="" required class="form-control" id="scontacto" placeholder="Datos del contacto" name="scontacto">
                    </div>
                    <div class="col-sm-12 form-group">
                        <label for="rut">Rut de contacto</label>
                        <input type="" required class="form-control" id="rut" placeholder="Datos del contacto" name="rut_contacto">
                    </div>
                    <!--FIRMA ANTIGUA
                <div class="col-sm-12 form-group">
                    <label for="email">Firma contacto</label>
                    <div class="row">
                        <div class="col-sm-12">
                            <table class="mx-auto">
                                <tr>
                                    <td>
                                        <canvas class="rounded-lg" required id="pizarra" name="img_firma"></canvas>
                                    </td>
                                </tr>
                            </table>
                            <input type="text" style="display:none " id="imagen_firma" value="" name="imagen_firma">
                            <div id="contenedor"></div>

                            <div class="mt-2 text-center">
                                <button class="btn btn-prim col-sm-5 form-group" type='button' id="firmasave">Generar firma</button>
                                <button class="btn btn-secundario col-sm-5 form-group" type='button' id="borrars" onclick="borrar()">Borrar</button>
                                <input type='hidden' name='imagen' id='imagen'>
                            </div>
                        </div>
                    </div>
                </div> -->
                    <div class="col-sm-12 form-group">
                        <a href="{{route('firmaCapacitacion',Crypt::encryptString($capas[0]->id)) ?? ''}}" target="_blank" style="text-decoration: none;">
                            <button type="button" id="contenido" class="btn btn-outline-primary w-100">FIRMA CLIENTE</button>
                        </a>
                        <input type='hidden' name='imagen' id='imagen' />
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container text-center my-5">
        <button class="btn btn-prim w-25" type="submit">Guardar</button>
    </div>
    </div>
</form>

<!--MODAL FOTOS NUEVO-->
<!-- MODAL IMAGENES -->
<div class="modal fade" id="modal_historial_retiros" role="dialog" data-backdrop="static">
    <div class="modal-dialog  modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <div class="seccion-modal">Ingresar el siguiente ID en la Aplicacción</div>
                <button type="button" class="cancel_image close">&times;</button>
            </div>
            <hr class="separador ml-4 mr-4">

            <div class="modal-body">
                <div class="container">
                    <!-- CARGA DE IMÁGENES DE INSTALACIÓN -->
                    <div class="seccion-filtro mt-2">Adjunte las imágenes que se solicita a continuación</div>
                    <div class="row">
                        <input type="text" style="display:none" name="idCheck" id="" value="{{$capas[0]->id ?? ''}}">
                        <div class="col-sm-12">
                            <label style="color:red" id="mensaje-text" for="" class="mensaje_validacion"></label>
                        </div>
                        <!-- 1 -->
                        <div id="carouselExampleControls2" class="carousel slide  w-100" data-interval="false">
                            <div class="carousel-inner">
                                <div class="carousel-item active">
                                    <form enctype="multipart/form-data" class="formuploadajax" method="post">
                                        @csrf
                                        <div class="col-sm-12 form-group">
                                            <input type="text" style="display:none" name="idCheck" id="" value="{{$capas[0]->id ?? ''}}">
                                            <img src="{{ asset('img/p1.png') }}" width="30" height="30" class="espacio_carga_img" alt="" />
                                            <label for="cargafoto1" class="espacio_carga_img">Fotografía de la página de estado</label>
                                            <input type="file" required id="cargafoto1" name="cargafoto1" accept="image/*">
                                            <button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
                                        </div>
                                    </form>
                                </div>
                                <div class="carousel-item">
                                    <form enctype="multipart/form-data" class="formuploadajax" method="post">
                                        @csrf
                                        <div class="col-sm-12 form-group">
                                            <input type="text" style="display:none" name="idCheck" id="" value="{{$capas[0]->id ?? ''}}">
                                            <img src="{{ asset('img/p2.png') }}" width="30" height="30" class="espacio_carga_img" alt="" />
                                            <label for="cargafoto2" class="espacio_carga_img">Fotografía del panel de la máquina</label>
                                            <input type="file" required id="cargafoto2" name="cargafoto2" accept="image/*">
                                            <button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
                                        </div>
                                    </form>
                                </div>
                                <div class="carousel-item">
                                    <form enctype="multipart/form-data" id="formuploadajax3" class="formuploadajax" method="post">
                                        @csrf
                                        <div class="col-sm-12 form-group">
                                            <input type="text" style="display:none" name="idCheck" id="" value="{{$capas[0]->id ?? ''}}">
                                            <img src="{{ asset('img/p3.png') }}" width="30" height="30" class="espacio_carga_img" alt="" />
                                            <label for="cargafoto3" class="espacio_carga_img">Fotografía a 2 metros del equipo</label>
                                            <input type="file" required id="cargafoto3" name="cargafoto3" accept="image/*">
                                            <button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
                                        </div>
                                    </form>
                                </div>
                                <div class="carousel-item">
                                    <form enctype="multipart/form-data" id="formuploadajax4" class="formuploadajax" method="post">
                                        @csrf
                                        <div class="col-sm-12 form-group">
                                            <input type="text" style="display:none" name="idCheck" id="" value="{{$capas[0]->id ?? ''}}">
                                            <label for="cargafoto4" class="espacio_carga_img">Fotografía 4 </label>
                                            <input type="file" required id="cargafoto4" name="cargafoto4" accept="image/*">
                                            <button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
                                        </div>
                                    </form>
                                </div>
                                <div class="carousel-item">
                                    <form enctype="multipart/form-data" id="formuploadajax5" class="formuploadajax" method="post">
                                        @csrf
                                        <div class="col-sm-12 form-group">
                                            <input type="text" style="display:none" name="idCheck" id="" value="{{$capas[0]->id ?? ''}}">
                                            <label for="cargafoto5" class="espacio_carga_img">Fotografía 5 </label>
                                            <input type="file" required id="cargafoto5" name="cargafoto5" accept="image/*">
                                            <button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
                                        </div>
                                    </form>
                                </div>
                                <div class="carousel-item">
                                    <form enctype="multipart/form-data" id="formuploadajax6" class="formuploadajax" method="post">
                                        @csrf
                                        <div class="col-sm-12 form-group">
                                            <input type="text" style="display:none" name="idCheck" id="" value="{{$capas[0]->id ?? ''}}">
                                            <label for="cargafoto6" class="espacio_carga_img">Fotografía 6 </label>
                                            <input type="file" required id="cargafoto6" name="cargafoto6" accept="image/*">
                                            <button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
                                        </div>
                                    </form>
                                </div>
                                <div class="carousel-item">
                                    <form enctype="multipart/form-data" id="formuploadajax7" class="formuploadajax" method="post">
                                        @csrf
                                        <div class="col-sm-12 form-group">
                                            <input type="text" style="display:none" name="idCheck" id="" value="{{$capas[0]->id ?? ''}}">
                                            <label for="cargafoto7" class="espacio_carga_img">Fotografía 7 </label>
                                            <input type="file" required id="cargafoto7" name="cargafoto7" accept="image/*">
                                            <button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
                                        </div>
                                    </form>
                                </div>
                                <div class="carousel-item">
                                    <form enctype="multipart/form-data" id="formuploadajax8" class="formuploadajax" method="post">
                                        @csrf
                                        <div class="col-sm-12 form-group">
                                            <input type="text" style="display:none" name="idCheck" id="" value="{{$capas[0]->id ?? ''}}">
                                            <label for="cargafoto8" class="espacio_carga_img">Fotografía 8 </label>
                                            <input type="file" required id="cargafoto8" name="cargafoto8" accept="image/*">
                                            <button class="btn btn-prim d-block mx-auto mt-2" type="submit">Subir imágen</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="container text-center mb-2">
                            <a class="carousel-control-prev previus_carrusel2" style="display:none" href="#carouselExampleControls2" role="button" data-slide="prev">
                                <span class="material-icons" style="color:black">
                                    arrow_back_ios
                                </span>
                            </a>
                        </div>
                        <div class="container wrapper mt-5" style="display: none">
                            <div class="progress progress_wrapper">
                                <div class="progress-bar progress-bar-striped bg-info progress-bar-animated progress_bar" role="progressbar" style="width: 0%">
                                    0%
                                </div>
                            </div>
                        </div>
                        <div class="container form-group text-center my-4">
                            <button class="btn btn-secundario cancel_image" type="button">Cancelar</button>
                            <button class="btn btn-prim save_image" type="button">Guardar</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--FIN MODAL FOTOS-->
    <div class="modal fade" id="modal_fotos_android" role="dialog">
        <div class="modal-dialog  modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 style="margin-top: 50px">Ingresar el siguiente ID en la Aplicacción</h1>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="container-fluid">
                        <div class="container rounded-lg">
                            <!-- CARGA DE IMÁGENES DE INSTALACIÓN -->
                            <div style="text-align: center; border-style: solid; background: #E8F5FE; border-radius: 5px;border-color: #BAC5D8">
                                <h1>ID = {{$capas[0]->id_capa ?? ''}}</h1>
                            </div>
                        </div>
                        <div class="container form-group">
                            <br>
                            <button class="btn btn-cancelar float-sm-right guardar" type="button" data-dismiss="modal">CANCELAR</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
<script>
    $(document).ready(() => {
        $(".save_image").click(function() {
            $("#modal_historial_retiros").modal('hide');
        });
        $(".cancel_image").click(function() {
            id = $('#idchecklist').val();
            $("#modal_historial_retiros").modal('hide');
        });
        $('.asignarimagen').click(function() {
            $("#modal_historial_retiros").modal('show');
        });
        $(".previus_carrusel").click(function() {
            if ($("#carouselExampleControls").carousel(1)) {
                $(".previus_carrusel").css("display", "")
            } else {
                $(".previus_carrusel").css("display", "none")
            }
        });
        $(".previus_carrusel2").click(function() {
            if ($("#carouselExampleControls2").carousel(1)) {
                $(".previus_carrusel2").css("display", "")
            } else {
                $(".previus_carrusel2").css("display", "none")
            }
        });
        $(".formuploadajax").on("submit", function(e) {
            e.preventDefault();
            let form = $(this),
                wrapper = $('.wrapper'),
                progress_bar = $('.progress-bar'),
                data = new FormData(form.get(0));
            progress_bar.removeClass('bg-success bg-danger').addClass('bg-info')
            progress_bar.css('width', '0%');
            progress_bar.html('Preparando...');
            wrapper.fadeIn();

            $.ajax({
                xhr: function() {
                    let xhr = new window.XMLHttpRequest();
                    xhr.upload.addEventListener("progress", function(e) {
                        if (e.lengthComputable) {
                            let percentComplete = Math.floor((e.loaded / e.total) * 100);
                            progress_bar.css('width', percentComplete + '%');
                            progress_bar.html(percentComplete + '%');
                        }
                    }, false);
                    return xhr;
                },
                url: "{{ route('save.imageCapacitacion') }}",
                type: "post",
                dataType: "json",
                data: data,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: () => {
                    $("button", form).attr('disabled', true);
                }
            }).done(res => {
                if (res.status === 200) {
                    progress_bar.removeClass('bg-info').addClass('bg-success');
                    progress_bar.html('Subida exitosa!');
                    setTimeout(() => {
                        wrapper.fadeOut;
                        progress_bar.removeClass('bg-success bg-danger').addClass('bg-info');
                        progress_bar.css('width', '0%');
                    }, 1500);
                    setTimeout(() => {
                        $("#carouselExampleControls2").carousel("next");
                        $(".previus_carrusel2").css("display", "")
                    }, 2000);
                } else {
                    console.log(res);
                    progress_bar.css('width', '100%');
                    progress_bar.html(res.msg);
                }
            }).fail(err => {
                progress_bar.removeClass('bg-success bg-info').addClass('bg-danger');
                progress_bar.html('Hubo un error!');
            }).always(() => {
                $('button', form).attr('disabled', false);
            })
        });
    })
</script>
<script type="text/javascript">
    function cambio(nombre) {
        $('#mi_select_2').append(opciones);
        $('#listaarrow').fadeOut();
    }
    $(document).ready(function() {
        $("#propi").keyup(function() {
            _this = this;
            // Show only matching TR, hide rest of them
            $.each($("#mi_select option"), function() {
                if ($(this).text().toLowerCase().indexOf($(_this).val().toLowerCase()) === -1)
                    $(this).hide();
                else
                    $(this).show();
            });
        });
        $("#mi_select").change(function() {
            var id_nombre = $('select[id=mi_select]').val();
            var opciones = '<option><input required type="checkbox"  checked id="' + id_nombre + '" name="selecionados[]" value="' + id_nombre + '">' + id_nombre + '</option> ';
            $('#mi_select_2').append(opciones);
        });
        $(document).on('change', 'input[type="checkbox"]', function(e) {
            if (this.checked == false) {
                $('checkbox[value="' + this.value + '"]').remove();
            }
        });
    });
</script>
<script type="text/javascript">
    $(document).ready(function() {
        $('#scontacto').keyup(function() {
            var query = $(this).val();
            var _token = $('input[name="_token"]').val();
            $.ajax({
                url: "{{ route('autocomplete.fetchnombrecontacto') }}",
                method: "POST",
                data: {
                    query: query,
                    _token: _token
                },
                success: function(data) {
                    console.log(data);
                    $('#listaarrow').fadeIn();
                    $('#listaarrow').html(data);
                }
            });
        });
        $("#agregar").click(function() {
            //$("#multiselect").css("display", "");
            var nombre = $('#scontacto_old').val();
            if (nombre != "") {
                var opciones = '<option selected value="' + nombre + '">' + nombre + '</option> ';
                $('#mi_select_2').append(opciones);
                $('#scontacto_old').val("");
                console.log(opciones);
            }
        });
        //   $( "#buscando" ).click(function() {
        $("#buscando").click(function() {
            var dcui = $("#dcui").val();
            var _token = $('input[name="_token"]').val();
            $.ajax({
                method: "POST",
                url: "{{ route('go.auto_complete_cui') }}",
                data: {
                    'scui': dcui,
                    _token: _token
                },
                success: function(data) {
                    if (data != "") {
                        console.log(data);
                        $.each(data, function(i, item) {
                            $("#cliente").val(item.sCliente);
                            $("#proyectos").val(item.id_proyecto);
                            $("#direccion").val(item.sDireccion);
                            $("#comuna").val(item.sComuna);
                            $("#ciudad").val(item.sCiudad);
                        });
                    } else {
                        $("#cliente").val("");
                        $("#proyectos").val("");
                        $("#direccion").val("");
                        $("#comuna").val("");
                        $("#ciudad").val("");
                        alert("sin Datos");
                    }
                }
            });
        });
    });
</script>

<!--Este script se encarga de verificar si un rut ya esta asociado a una organización-->
<script type="text/javascript">
    $(document).ready(function() {
        $("#buscando").click(function() {
            var dcui = $("#dcui").val();
            var _token = $('input[name="_token"]').val();
            $.ajax({
                method: "POST",
                url: "{{ route('go.auto_complete_cui') }}",
                data: {
                    'scui': dcui,
                    _token: _token
                },
                success: function(data) {
                    if (data != "") {
                        console.log(data);
                        $.each(data, function(i, item) {
                            $("#cliente").val(item.sCliente);
                            $("#proyectos").val(item.id_proyecto);
                            $("#direccion").val(item.sDireccion);
                            $("#comuna").val(item.sComuna);
                            $("#ciudad").val(item.sCiudad);
                        });
                    } else {
                        $("#cliente").val("");
                        $("#proyectos").val("");
                        $("#direccion").val("");
                        $("#comuna").val("");
                        $("#ciudad").val("");
                        alert("sin Datos");
                    }
                }
            });
        });
    });
</script>
<script>
    function soloNumeros(e) {
        var key = window.Event ? e.which : e.keyCode
        return (key >= 48 && key <= 57)
    }
</script>