@extends('menu/menu')
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js%22%3E</script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>
{{-- <link  href="{{ asset('css/a&a_style.css') }}" href="a&a_style.css" rel="stylesheet" type="text/css"> --}}

<button class="mt-1" onclick="topFunction()" id="myBtn" title="Go to top">
  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-arrow-up-circle-fill" viewBox="0 0 16 16">
    <path d="M16 8A8 8 0 1 0 0 8a8 8 0 0 0 16 0zm-7.5 3.5a.5.5 0 0 1-1 0V5.707L5.354 7.854a.5.5 0 1 1-.708-.708l3-3a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L8.5 5.707V11.5z"/>
  </svg>
</button>

@section('content')


@if ( session('mensaje') )
    <div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

<div class="container mt-5">
  <div class="title-vista mt-4">Instalación</div>
</div>

<form action="{{route('filtros_instalacion_kyocera')}}" method="GET">
  <div class="container mt-4">
    <div class="seccion-filtro">Datos del cliente</div> 
    <hr class="separador">

    <!-- BARRA DE BUSQUEDA -->
    <div class="row">
      <div class="col-sm-3 form-group">
        <label for="datepicker">Fecha inicio</label>
        <input type="date" class="form-control mayuscula" id="datepicker" name="datepicker">
      </div>

      <div class="col-sm-3 form-group " >
          <label for="datepicker2">Fecha fin</label>
          <input type="date" class="form-control mayuscula" id="datepicker2" name="datepicker2">
      </div>

      <!--AQUI SE CARGA EL SELECT DE ESTADO-->
      <div class="col-sm-3 form-group" >
        <label for="estado">Estado Instalación</label>
        <select  id="estado" name="estado" class="custom-select mayuscula">
          <option  selected value="">seleccionar</option>
            @if (!empty($carga_selectEstado))
              @foreach ($carga_selectEstado as $estado)
              @if ($estado->sEstado_instalacion != null)
                <option  value="{{ $estado->sEstado_instalacion }}">{{ucfirst(strtolower($estado->sEstado_instalacion))}}
                </option>
              @endif      
            @endforeach
          @endif
        </select>
      </div>

      <!--FIN SELECT DE ESTADO-->
      <div class="col-sm-3 form-group" >
        <label for="serie">Nº de Serie</label>
        <input type="" class="form-control mayuscula" value="{{$serie ?? ''}}" id="serie" name="serie" placeholder="Nº de Serie">
      </div>

      
      <!--AQUI SE CARGA EL SELECT DE CLIENTE-->
      <div class="container col-sm-3 form-group" >
        <label for="clientes">Cliente</label>
        {{--$clientes--}}
        <select  class="custom-select mb-3 opcionesSele" id="clientes" name="clientes">
        <option  selected value="">seleccionar</option>
        @if (!empty($carga_selectClientes))
          @foreach ($carga_selectClientes as $datos)      
          @if ($datos->sCliente != null)     
          @if  ($datos->sCliente == "MUNICIPALIDAD DE OSORNO")  
          <option  value="IM OSORNO">{{ucfirst(strtolower($datos->sCliente ))}}
          @else      
            @if($datos->sCliente == $clientes) 
              <option  selected value="{{ $datos->sCliente }}">{{ucfirst(strtolower($datos->sCliente ))}}
            @else
              <option   value="{{ $datos->sCliente }}">{{ucfirst(strtolower($datos->sCliente ))}}
            @endif
          @endif
              @endif
            </option> 
          @endforeach
          @endif
        </select>
      </div>

      <!--AQUI SE CARGA EL PROYECTO-->
      <div class="col-sm-3 form-group">
        <label for="clientes">Proyecto</label>
        <select class="custom-select mayuscula" id="proyectos" name="proyectos">
          <option selected value="" >seleccionar</option>
          @if (!empty($carga_selectProyectos))
          @foreach ($carga_selectProyectos as $datos)      
          @if ($datos->nombre != null)                      
            @if($datos->id == $proyectos) 
              <option selected value="{{ $datos->id }}">{{ucfirst(strtolower($datos->nombre ))}}
            @else
              <option value="{{ $datos->id }}">{{ucfirst(strtolower($datos->nombre ))}}
            @endif
          @endif        
          </option> 
          @endforeach
          @endif
        </select>
      </div>

      <!--AQUI SE CARGA EL SELECT DE REGION-->
      <div class="col-sm-3 form-group" >
        <label for="region">Región</label>
        <div class="input-group d-flex">
          <select id="region" name="region" class="custom-select mayuscula">
            <option  selected value="">seleccionar</option>
            @if (!empty($carga_selectRegion))
              @foreach ($carga_selectRegion as $datos1)
                @if ($datos1->sRegion != null)
                  @if($datos1->sRegion == $region)
                    <option  selected value="{{ $datos1->sRegion }}">{{ucfirst(strtolower($datos1->sRegion))}} </option>
                  @else
                    <option  value="{{ $datos1->sRegion }}">{{ucfirst(strtolower($datos1->sRegion))}} </option>
                  @endif
                @endif
              @endforeach
            @endif
          </select>
          <div class="input-group-append">
            <a onclick="actualizar_regiones()" class="btn app-color">
              <span class="material-icons-round">refresh</span>
            </a>
          </div>
        </div>
      </div>

      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-3 form-group">
        <label for="comuna">Comuna</label>
        <select id="comuna" name="comuna" class="custom-select mayuscula">
          <option  selected value="">seleccionar</option>
          @if (!empty($carga_selectComuna))
            @foreach ($carga_selectComuna as $datos2)
              @if ($datos2->sComuna != null)                    
                @if( $datos2->sComuna === $comuna)
                  <option  selected value="{{ $datos2->sComuna }}">{{ucfirst(strtolower($datos2->sComuna))}}
                @else
                  <option   value="{{ $datos2->sComuna }}">{{ucfirst(strtolower($datos2->sComuna))}} </option>
                @endif
              @endif
            @endforeach
          @endif
        </select>
      </div>

      <div class="col-sm-3 form-group">
        <label for="sc">SC</label>
        <input type="" class="form-control mayuscula" id="sc" placeholder="SC" name="sc">
      </div>
    </div>
  </div>
  <!-- FIN BARRA DE BUSQUEDA -->
  <div class="container text-center mt-4">
    <button type="buscar" class="btn btn-prim px-sm-5">Buscar</button>
  </div>
</form>

{{ session(['url_proveedor' => url()->full()]) }}
<div class="container mt-5 p-0">
  <ul class="nav bg-export">
    <li class="clas-item">
      <a class="btn btn-ter" target="_blank" href="{{route('go.excel_instalacion',Crypt::encryptString(url()->full())) ?? ''}}"> Exportar excel
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16" class="bi bi-file-earmark-excel-fill">
          <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM5.884 6.68 8 9.219l2.116-2.54a.5.5 0 1 1 .768.641L8.651 10l2.233 2.68a.5.5 0 0 1-.768.64L8 10.781l-2.116 2.54a.5.5 0 0 1-.768-.641L7.349 10 5.116 7.32a.5.5 0 1 1 .768-.64z"></path>
        </svg>
      </a>
    </li>
    <li class="clas-item">
    <a class="btn btn-ter" target="_blank" href="{{route('go.excel_instalacion_check',Crypt::encryptString(url()->full())) ?? ''}}"> 
          Exportar Excel con Checklist
          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-excel" viewBox="0 0 16 16">
            <path d="M5.884 6.68a.5.5 0 1 0-.768.64L7.349 10l-2.233 2.68a.5.5 0 0 0 .768.64L8 10.781l2.116 2.54a.5.5 0 0 0 .768-.641L8.651 10l2.233-2.68a.5.5 0 0 0-.768-.64L8 9.219l-2.116-2.54z" />
            <path d="M14 14V4.5L9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2zM9.5 3A1.5 1.5 0 0 0 11 4.5h2V14a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h5.5v2z" />
          </svg>
        </a>
      </li>

    <li>
      <button class="btn btn-ter" style="">
        @if(!empty($mostrarMenu))
          @if($mostrarMenu == "si")
            <a href="{{route('go.getalldownload',$urls ?? '')}}">
              <span class="material-icons-round">file_download</span> 
              Descargar
            </a>
          @endif
        @endif
    </button>
    </li>
  </ul>

  <!-- chcklist -->
  
</div>

<!-- TABLA DE RESULTADOS DE BUSQUEDA --> 

  <div class="container table-responsive p-sm-0">
    <div class="container table-responsive p-sm-0">
      <!-- {{$totalInstalaciones ?? '0'}} <label for="">Registros</label> -->
    </div>
    <table class="table table-striped table-hover" id="gridData">  
      <thead class="color-head">
        <tr>
          <th class="th-head border-th separador-v" colspan="1">Fecha de Recepción</th>
          <th class="th-head border-th separador-v" colspan="1">Fecha Instalación</th>
          <th class="th-head border-th separador-v" colspan="1">Estado Instalación</th>
          <th class="th-head border-th separador-v" colspan="1">Cliente</th>
          <th class="th-head border-th separador-v" colspan="1">Proyecto</th>
          <th class="th-head border-th separador-v" colspan="1">Región</th>
          <th class="th-head border-th separador-v" colspan="1">Comuna</th>
          <th class="th-head border-th separador-v" colspan="1">Dirección | CUI</th><?php /*?>Agregue una nueva columna  - FITO<?php */?>
          <th class="th-head border-th separador-v" colspan="1">Nº de serie</th>
          <th class="th-head border-th separador-v" colspan="1"><span class="material-icons">settings</span></th>
        </tr>
      </thead>
      
      <!-- RESULTADOS -->
      <tbody id="myTable">
        @if(!empty($instalaciones))
          @foreach ($instalaciones   as $los_datos)
            <tr>
              <td class="td-val">{{Carbon\Carbon::createFromDate($los_datos->fecha_registrado)->format('d-m-Y')}}</td>
              <td class="td-val">{{Carbon\Carbon::createFromDate($los_datos->fecha_instalacion_coordinadora )->format('d-m-Y')}}</td>
              <td class="td-val" style="text-transform: uppercase"> {{ucfirst($los_datos->sEstado_instalacion ?? '')}}</td>
              <td class="td-val">{{$los_datos->sCliente ?? ''}}</td> 
              @if($los_datos->nombre == "Global")
              <td class="td-val">No Asociado</td> 
             @else
              <td class="td-val">{{$los_datos->nombre ?? ''}}</td> 
              @endif
              <td class="td-val">{{$los_datos->sRegion ?? ''}}</td>       
              <td class="td-val">{{$los_datos->sComuna ?? ''}}</td>
					    <td class="td-val">{{$los_datos->sDireccion ?? ''}}</td>
              @if($los_datos->Csserie_remplazo != "" || $los_datos->Csserie_remplazo != null)
                <td class="td-val">{{$los_datos->Csserie_remplazo ?? ''}}</td>
              @else
                <td class="td-val">{{$los_datos->sSerie ?? ''}}</td>
              @endif
              <td>      
                
              <a role="button" class="btn-icon btn-icon-dd ver_historial" title="Historial" data-id="{{Crypt::encryptString($los_datos->id ?? '')}}" data-estado="{{$los_datos->estado_interno?? ''}}">
                <span class="material-icons">history</span>
              </a>
            
            </td>
              {{-- @if($los_datos->url_pdf != "" )
                <td class="td-val" style="text-align: center">
                  @if($los_datos->Csserie_es != "" || $los_datos->Csserie_es != null)
                    <a class="btn-icon btn-icon-dd" href="{{route('go.donwloader',$los_datos->url_pdf."mitad".$los_datos->Csserie_es ?? 'sinserie')}}"><span class="material-icons-round">picture_as_pdf</span></a>
                  @elseif($los_datos->Csserie_remplazo != "" || $los_datos->Csserie_remplazo != null)
                    <a class="btn-icon btn-icon-dd" href="{{route('go.donwloader',$los_datos->url_pdf."mitad".$los_datos->Csserie_remplazo ?? 'sinserie')}}"><span class="material-icons-round">picture_as_pdf</span></a>
                  @else
                    <a class="btn-icon btn-icon-dd" href="{{route('go.donwloader',$los_datos->url_pdf."mitad".$los_datos->sSerie ?? 'sinserie')}}"><span class="material-icons-round">picture_as_pdf</span></a>
                  @endif
                </td>
              @else 
                <td class="td-val">
                  <span class="material-icons-round" style="color:#cacbd0; pointer-events:none;">picture_as_pdf</span>
                </td>
              @endif               --}}
            </tr>
          @endforeach
        @endif
      </tbody>
      <!-- FIN RESULTADOS -->
    </table>
  </div>

  <!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->
  </div>


{{-- /////////////////////////MODALLLL//////////// --}}
  <div class="modal fade" id="modal_historial_instalacion" role="dialog">
    <div class="modal-dialog  modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h1 style="margin-top: 50px">Historial de Checklist</h1>
          <button type="button" class="close" data-dismiss="modal">&times;</button>   
        </div>
        <div class="modal-body">  
          <div class="container"><!-- sombra de separación con el fondo -->
            <div class="container">
              
            </div>
            
            <div class="container">
           
            </div>
            
            
            <!-- FIN TABLA DE RESULTADOS DE BUSQUEDA --></div>

                  <!-- TABLA DE RESULTADOS DE BUSQUEDA --> 
                  <div class="container reex" style="margin-top: 10px">
                    <div class="conteiner row rein table-responsive-lg" style="border: 5px solid #e8f5fe">
                      <table class="table table-sm table-bordered table-responsive-md table-striped table-hover" style="margin: 0" id="dataGrid">
                        <!-- ENCABEZADO -->
                        <thead>
                          <tr>
                            <th class="container-2"><h3>Código</h3></th>
                            <th class="container-2"><h3>Número Visita</h3></th>
                            <th class="container-2"><h3>Técnico</h3></th>
                            <th class="container-2"><h3>Estado</h3></th>
                            <th class="container-2"><h3>Acciones</h3></th>
                          </tr>
                        </thead>
                        <!-- FIN ENCABEZADO -->
                        
                        <!-- RESULTADOS -->
                        <tbody id="cuerpo_tabla">
          
                        
                     
                     
                        </tbody>
                        <!-- FIN RESULTADOS -->
                        </table>
                      </div>
                  </div>
          
        
        </div>
      </div>
    </div>
  </div>
  

  <div class="modal fade" id="modal_historial_detalle" role="dialog">
    <div class="modal-dialog  modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h1 style="margin-top: 50px">DETALLE DE INSTALACIÓN DE EQUIPOS</h1>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <form>
        <div class="modal-body">
          <div class="container"><!-- sombra de separación con el fondo -->
            <div class="container">
              <div class="row reex">

                             <!-- Fila 1 ------------------------------------------------------>

                             <div class="container col-sm-3 form-group">
                                 <label for="email"><h2>Folio</h2></label>
                                 <input type="text" readonly="readonly" class="form-control locked textito" id="folioretiro" placeholder="FOLIO" name="folioretiro">
                             </div>
                             <div class="container col-sm-3 form-group">
                                 <label for="email"><h2>Guía</h2></label>
                                 <input type="" readonly="readonly" class="form-control locked textito" id="guiaretiro" placeholder="GUÍA" name="guiaretiro">
                             </div>
                             <div class="container col-sm-6 form-group"></div>

                             <div class="container"><hr class="linea"></div>

                             <!-- Detalle del Cliente -->
                             <div class="container col-12" style="margin-top: 10px">
                                 <h2><strong>Detalle del Cliente</strong></h2>
                             </div>
                             <!-- Fila 2 ------------------------------------------------------>
                             <div class="container col-sm-3 form-group">
                                 <label for="email"><h2>Cliente</h2></label>
                                 <input type="" readonly="readonly" class="form-control locked textito" id="clienteretiro" placeholder="CLIENTE" name="clienteretiro">
                                  </div>
                             <div class="container col-sm-3 form-group">
                                 <label for="email"><h2>Rut</h2></label>
                                 <input type="" readonly="readonly" class="form-control locked textito" id="rutretiro" placeholder="RUT" name="rutretiro">
                                          </div>
                             <div class="container col-sm-3 form-group">
                                 <label for="email"><h2>Región</h2></label>
                                 <input type="" readonly="readonly" class="form-control locked textito" id="regionretiro" placeholder="REGIÓN" name="regionretiro">
                                    </div>
                             <div class="container col-sm-3 form-group">
                                 <label for="email"><h2>Ciudad</h2></label>
                                 <input type="" readonly="readonly" class="form-control locked textito" id="ciudadretiro" placeholder="HORA DE TERMINO" name="ciudadretiro">
                                    </div>
                             <!-- Fila 3 ------------------------------------------------------>
                             <div class="container col-sm-6 form-group">
                                 <label for="email"><h2>Dirección</h2></label>
                                 <input type="" readonly="readonly" class="form-control locked textito" id="direccionretiro" placeholder="DIRECCIÓN" name="direccionretiro">
                              </div>
                             <div class="container col-sm-3 form-group">
                                 <label for="email"><h2>Comuna</h2></label>
                                 <input type="" readonly="readonly" class="form-control locked textito" id="comunaretiro" placeholder="COMUNA" name="comunaretiro">
                                    </div>
                             <div class="container col-sm-3 form-group" style="margin-top:-20px;textito">
                                 <label for="email" ><h2>CUI o Cod Sucursal</h2></label>
                                 <input type="" readonly="readonly" class="form-control locked textito" id="codigoretiro" placeholder="CUI O CÓDIGO SUCURSAL" name="codigoretiro">

                             </div>

                             <div class="container"><hr class="linea"></div><br>

                             <!-- Detalle de Equipamiento -->
                             <div class="container col-12" style="margin-top: 10px">
                                 <h2><strong>Detalle de Equipamiento</strong></h2>
                             </div>
                             <!-- Fila 4 ------------------------------------------------------>
                             <div class="container col-sm-3 form-group">
                                 <label for="email"><h2>Serie</h2></label>
                                 <input type="" readonly="readonly" class="form-control locked textito" id="serieretiro" placeholder="SERIE" name="serieretiro">
                                      </div>
                             <div class="container col-sm-3 form-group">
                                 <label for="email"><h2>Modelo</h2></label>
                                 <input type="" readonly="readonly" class="form-control locked textito" id="modeloretiro" placeholder="MODELO" name="modeloretiro">
                                    </div>
                             <div class="container col-sm-3 form-group">
                                 <label for="email"><h2>Contador B/N</h2></label>
                                <input type="" readonly="readonly" class="form-control locked textito" id="contadorretiro" placeholder="CONTADOR B/N" name="contadorretiro">
                                 </div>
                             <div class="container col-sm-3 form-group">
                                 <label for="email"><h2>Contador color</h2></label>
                                  <input type="" readonly="readonly" class="form-control locked textito" id="colorcontadorretiro" placeholder="CONTADOR COLOR" name="colorcontadorretiro">                         </div>
                             <!-- Fila 5 ------------------------------------------------------>

                             <div class="container"><hr class="linea"></div>

                             <div class="container col-sm-12 form-group checkbox">
                                 <label for="cambio"> <h3>Observaciones</h3></label>
                                 <textarea readonly="readonly" class="form-control locked textito" id="obs" name="obsercaviones" rows="4" ></textarea>
                                                            </div>

                             <div class="container"><hr class="linea"></div>
                             <!-- Fila 6 ------------------------------------------------------>
                             <div class="container col-sm-6 form-group">
                                 <label for="email"><h2>Estado</h2></label>
                                 <input type="" readonly="readonly" class="form-control locked textito" id="" placeholder="ESTADO" name="">
                             </div>
                             <div class="container col-sm-6 form-group"></div>
                       </div>
            </div>
        </div>
      </form>
      </div>
    </div>
  </div>





@endsection

<script>
  $(document).ready(function(){
  
      $('.ver_historial').click(function() {    
            var id_instalacion = $(this).attr("data-id");
           $("#m_id_instalacion").val(id_instalacion)
  
  
            var _token = $('input[name="_token"]').val();
  
  
          $.ajax({
  
  
              method:"POST",
  
              url:"{{ route('checklist.asociados_proveedor') }}",
  
              data: { 'id_instalacion': id_instalacion,  _token:_token},
  
        success: function(data) {
          console.log(data);
     
          $(cuerpo_tabla).empty();
          $(cuerpo_tabla).append(data);
          $("#modal_historial_instalacion").modal('show');
                  //validacion del boton
                  var  toma2 = "";
                  //estado con boton
                  var cancel = "cancelado";
  
                  //estados sin boton
                  var pend = "pendiente";
                  var revis = "revisado";
                  var asigna = "asignado";
                  var fina = "finalizado";
                  var recha = "rechazado";
  
                  //funcion para botener el estado de la primera fila
                  $.each($("#dataGrid:eq(0)"), function() {
                      toma2 = $(this).find('td').eq(3).html();
                      console.log(toma2);
  
  
                      //estados sin boton
                      if(toma2 == 'cancelado' || toma2 == "Cancelado"){
                          $('#btnview').show();
                      }else  if(toma2 == pend || toma2 == "Pendiente"){
                          $('#btnview').show();
                      }else  if(toma2 == fina || toma2 == "Finalizado" ){
                          $('#btnview').hide();
                      }else  if(toma2 == asigna ||  toma2 == "Asignado"){
                          $('#btnview').hide();
                      }else  if(toma2 == revis || toma2 == "Revisado"){
                          $('#btnview').hide();
                      }else  if(toma2 == recha || toma2 == "Rechazado" ){
                          $('#btnview').hide();           
                      }else  if(toma2 == "revisar" || toma2 == "Revisar" ){
                          $('#btnview').hide();           
                      }else  if(toma2 == "tarea_asignada" || toma2 == "Tarea_asignada" || toma2 == "Tarea Asignada" ){
                          $('#btnview').hide();           
                      }else if (data == '<tr><td>Sin Datos</td></tr>'){
                          $('#btnview').show();
                      }
  
  
                    });
  
  
        },
  
        error: function(xhr, status) {
            alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
  
        });
  
          })
    })
      
      $('.ver_historial_instalacion').click(function() {
             // var descripcion_pago = $(this).attr("data-descripcion_pago");
             // $("#mi_descripcion").text(descripcion_pago)
             $("#modal_historial_detalle").modal('show');
  
        });
    </script>
  
  
  
  
  
  <script>
    $(document).ready(function(){
  
        $('.ver_historial_instalacion').click(function() {
              var id_instalacion = $(this).attr("data-id");
             $("#m_id_instalacion").val(id_instalacion)
  
  
              var _token = $('input[name="_token"]').val();
              $("#modal_historial_detalle").modal('show');
            $.ajax({
                    method:"POST",
  
                    url:"{{ route('datos_instalacion') }}",
  
                    data: { 'id_instalacion': id_instalacion,  _token:_token},
  
                success: function(data) {
                    console.log(data);
                    $.each(data, function(i, item) {
  
                    $("#folioretiro").val(item.nFolio);
                    $("#guiaretiro").val(item.nGuia);
                    $("#clienteretiro").val(item.sCliente);
                    $("#rutretiro").val(item.sRut);
                    $("#regionretiro").val(item.sRegion);
                    $("#ciudadretiro").val(item.sCiudad);
                    $("#direccionretiro").val(item.sDireccion);
                    $("#comunaretiro").val(item.sComuna);
                    $("#codigoretiro").val(item.sCui);
                    $("#comunaretiro").val(item.sComuna);
                    $("#serieretiro").val(item.sSerie);
                    $("#modeloretiro").val(item.sModelo);
                    $("#contadorretiro").val(item.nContador);
                    $("#colorcontadorretiro").val(item.nContador_color);
                    $("#obs").val(item.sObservacion);
                    });
  
            },
  
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
            }
  
            });
  
  
            });
      });
  
      </script>
  
  <script>
    $(document).ready(function(){
      $("#serie").on("keyup", function() {
      var value = $(this).val().toLowerCase();
      $("#myTable tr").filter(function() {
        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
      });
      });
    });
    </script>
  
  
  <script>
  
  
    function actualizar_regiones(){
               var _token = $('input[name="_token"]').val();
    
               $.ajax({
                      method:"GET",
    
                      url:"{{ route('go.actualizarregiones') }}",
    
                      data: {   _token:_token},
    
                  success: function(data) {
                        alert("proceso Completado");
                        location.reload();
    
                    },
    
                  error: function(xhr, status) {
                      alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                   }
    
              });
    
    }
    
    
      
      $(document).ready(function(){
  
  
        $("#clientes").change(function(){
          
        
        
          cliente = $('select[id=clientes]').val();
            var _token = $('input[name="_token"]').val();
       
        $.ajax({
           method:"POST",
  
              url:"{{ route('buscarRegionClientes') }}",
  
              data: {  _token:_token,'cliente':cliente},
  
          success: function(data) {
            console.log(data);
            $("#comuna").empty();
            $("#direccion").empty();
            $("#sucursal").empty();
            $("#region").empty();
            
  
            $("#comuna").append('<option value="">Seleccionar</option>');
            $("#direccion").append('<option value="">Seleccionar</option>');
            $("#sucursal").append('<option value="">Seleccionar</option>');
            $("#region").append('<option value="">Seleccionar</option>');
  
            // $('#comuna').prop('disabled', true);
            // $('#direccion').prop('disabled', true);
            // $('#sucursal').prop('disabled', true);
  
  
            $(data).each(function(i, v){ // indice, valor
              //if(v.sComuna != null || v.sComuna != "null"  ){ 
                  $("#region").append('<option value="' + v.sRegion + '">' + v.sRegion + '</option>');
                    })
              // }
              $('#region').prop('disabled', false);
  
         },
  
       error: function(xhr, status) {
           alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
  
   });
  
  });
        $(".opcionesSele").change(function(e) { 
              var idClientes = $(this).val();
              var _token = $('input[name="_token"]').val();
              $.ajax({
                headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
                url:"{{ route('obtenerProyectosAsociados2') }}",
                type: "post",
                data: {'idClientes': idClientes},
                success: function(response) {
                  $("#proyectos").empty();
                  $("#proyectos").append("<option value=''>" + "Seleccionar"+ "</option>");
                  $.each(response, function( index, value ) {             
                    $("#proyectos").append("<option value="+value.id+">" + value.nombre+ "</option>");
                  });
                },
                error: function(xhr, status) {
                  alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                }
              })
            })    
          
        $("#region").change(function(){
    
        
               region = $('select[id=region]').val();
               var _token = $('input[name="_token"]').val();
    
               $.ajax({
                      method:"POST",
    
                      url:"{{ route('buscarComunas') }}",
    
                      data: { 'region': region,  _token:_token,'cliente':$("#clientes").val()},
    
                  success: function(data) {
                    $("#comuna").empty();
                    $("#direccion").empty();
                    $("#sucursal").empty();
                   
                    $("#comuna").append('<option value="">Seleccionar</option>');
                    $("#direccion").append('<option value="">Seleccionar</option>');
                    $("#sucursal").append('<option value="">Seleccionar</option>');
                    $(data).each(function(i, v){ // indice, valor
                      //if(v.sComuna != null || v.sComuna != "null"  ){ 
                          $("#comuna").append('<option value="' + v.sComuna + '">' + v.sComuna + '</option>');
                            })
                     // }
                     $('#comuna').prop('disabled', false);
  
                    },
    
                  error: function(xhr, status) {
                      alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                   }
    
              });
      });
      $("#comuna").change(function(){
        comuna = $('select[id=comuna]').val();
               var _token = $('input[name="_token"]').val();
    
    
    
               $.ajax({
                      method:"POST",
    
                      url:"{{ route('buscardirecciones') }}",
    
                      data: { 'comuna': comuna,  _token:_token, 'cliente':$("#clientes").val()},
    
                  success: function(data) {
                    $("#direccion").empty();
                    $("#sucursal").empty();
                    $("#direccion").append('<option value="">Seleccionar</option>');
                    $("#sucursal").append('<option value="">Seleccionar</option>');
    
                    $(data).each(function(i, v){ // indice, valor
                      //if(v.sdireccion != null || v.sdireccion != "null"  ){ 
                          $("#direccion").append('<option value="' + v.sDireccion + '">' + v.sDireccion + '</option>');
                            })
                     // }
                     $('#direccion').prop('disabled', false);
                    },
                   
  
                  error: function(xhr, status) {
                      alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                   }
    
              });
      });
    
      $("#direccion").change(function(){
        direccion = $('select[id=direccion]').val();
               var _token = $('input[name="_token"]').val();
    
    
               $.ajax({
                      method:"POST",
    
                      url:"{{ route('buscarsucursales') }}",
    
                      data: { 'direccion': direccion,  _token:_token, 'cliente':$("#clientes").val()},
    
                  success: function(data) {
                    $("#sucursal").empty();
                    $("#sucursal").append('<option value="">Seleccionar</option>');
    
                    $(data).each(function(i, v){ // indice, valor
                      //if(v.ssucursal != null || v.ssucursal != "null"  ){ 
                          $("#sucursal").append('<option value="' + v.sTipo_sucursal + '">' + v.sTipo_sucursal + '</option>');
                            })
                     // }
                     $('#sucursal').prop('disabled', false);
                    },
                   
  
    
                  error: function(xhr, status) {
                      alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                   }
    
              });
      });
    
        });
    
        </script>