@extends('menu/menu')
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js"></script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>



 {{-- {{$trabajadores}} --}}

@section('content') 

@if ( session('mensaje') )
    <div class="alert alert-success">{{ session('mensaje') }}</div>
    <a class="dropdown-item text-right" href="{{route('go_see_traba')}}">
      <button class="btn btn-prim w-25">Trabajadores</button>
    </a> 
@endif

<div class="container mt-5">
  <div class="title-vista mt-4">Editar usuario</div>
</div>


<div class="container">
  <form action="{{route('actualizar.trabajador',Crypt::encryptString($trabajadores[0]->id_persona))}}" method="POST">
  @csrf

    <div class="seccion-filtro">Datos personales</div> 
    <hr class="separador">
    
    <div class="row"> 
      <div class="col-sm-3 form-group" >
          <label for="primer_nombre">Primer nombre</label>
          <input type="text" class="form-control mayuscula" name="primer_nombre" id="primer_nombre" value="{{$trabajadores[0]->nombre_uno}}"   placeholder="Primer Nombre">
          @error('primer_nombre')
            <div class="alert alert-danger">{{ $message }}</div>
          @enderror
      </div>
      <div class="col-sm-3 form-group">
        <label for="segundo_nombre">Segundo nombre</label>
        <input type="text" class="form-control mayuscula" name="segundo_nombre" id="segundo_nombre" value="{{$trabajadores[0]->nombre_dos}}"   placeholder="Segundo Nombre">
        @error('segundo_nombre')
          <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>  

      <div class="col-sm-3 form-group">
        <label for="apellido_paterno">Apellido paterno</label>
        <input type="text" class="form-control mayuscula" value="{{$trabajadores[0]->apellido_uno}}"   name="apellido_paterno"  id="apellido_paterno" placeholder="Apellido Paterno">
        @error('apellido_paterno')
        <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
      <div class="col-sm-3 form-group">
          <label for="apellido_materno">Apellido materno</label>
          <input type="text" class="form-control mayuscula" value="{{$trabajadores[0]->apellido_dos}}"  id="apellido_materno"  name="apellido_materno"  placeholder="Apellido Materno">
          @error('apellido_materno')
          <div class="alert alert-danger">{{ $message }}</div>
          @enderror
      </div>
      <div class="col-sm-3 form-group">
        <label for="rut">Rut</label>
        <input type="text"  style="pointer-events: none;" name="rut" id="rut" class="form-control mayuscula" maxlength="10" value="{{$trabajadores[0]->rut}}"  change="guion,v_rut"  placeholder="Rut">
        @error('rut')
        <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
    </div>

    <div class="seccion-filtro">Datos contacto</div> 
    <hr class="separador">
        
    <div class="row">
      <div class="col-sm-3 form-group">
        <label for="telefono">Teléfono</label>
        <input type="tel" class="form-control mayuscula" value="{{$trabajadores[0]->telefono1}}" id="telefono"  name="telefono"  placeholder="Telefono">
        @error('telefono')
        <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
      <div class="col-sm-3 form-group">
        <label for="telefono_opcional">Segundo teléfono (Opcional)</label>
        <input type="tel" class="form-control mayuscula" value="{{$trabajadores[0]->telefono2}}"   name="telefono_opcional"  id="telefono_opcional" placeholder="Telefono Opcional">
        @error('telefono_opcional')
        <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
      <div class="col-sm-3 form-group">
        <label for="correo">Correo</label>
        <input type="email" class="form-control mayuscula" name="correo" id="correo" value="{{$trabajadores[0]->correo1}}"   change="correo"  placeholder="Correo">
        @error('correo')
        <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
      <div class="col-sm-3 form-group">
        <label for="correo_opcional">Segundo correo (Opcional)</label>
        <input type="text" class="form-control mayuscula" name="correo_opcional" id="correo_opcional" value="{{$trabajadores[0]->correo2}}"  change="correo_opcional"  placeholder="Correo Opcional">
        @error('correo_opcional')
        <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
    </div>  
          
    <div class="seccion-filtro">Dirección</div> 
    <hr class="separador"> 
        
    <div class="row">
      <div class="col-sm-3 form-group">
        <label for="">Región</label>
        <select class="custom-select mayuscula" name="region" id="region_usuario">
          @foreach($regiones as $region)
            @if($region->id == $trabajadores[0]->id_region)
              <option selected value="{{$region->id}}" {{(old('region')==$region->id)? 'selected':''}}>{{$region->des_region}}</option>
            @else
              <option value="{{$region->id}}" {{(old('region')==$region->id)? 'selected':''}}>{{$region->des_region}}</option>
            @endif               
          @endforeach
        </select>
          @error('region')
            <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>
      <div class="col-sm-3 form-group">
        <label for="">Comuna</label>
        <select class="custom-select mayuscula" name="comuna" id="comuna_usuarios">
          @foreach($comunas as $comuna)
            @if($comuna->id ==$trabajadores[0]->id_comuna ) 
              <option selected value="{{$comuna->id}}" {{(old('comuna')==$comuna->id)? 'selected':''}}>{{$comuna->des_comuna}}</option>
            @else
              <option value="{{$comuna->id}}" {{(old('comuna')==$comuna->id)? 'selected':''}}>{{$comuna->des_comuna}}</option>
            @endif
          @endforeach            
        </select>
        @error('comuna')
          <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
      <div class="col-sm-6 form-group">
        <label for="">Calle</label>
        <input type="text" name="calle" class="form-control mayuscula" value="{{$trabajadores[0]->descripcion_direccion}}" placeholder="Calle">
        @error('calle')
          <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
    </div>   
    
    <div class="seccion-filtro">Login</div> 
    <hr class="separador">
        
    <div class="row">
      <div class="col-sm-3 form-group" style="display:">
        <label for="">Tipo Usuario</label>
        <select class="custom-select mayuscula" name="tipo_usu" id="tipos_usuarios">
          @if($trabajadores[0]->tipo_usuario == "trabajador")
            <option selected value="Comun" {{(old('tipo_usu')=="trabajador")? 'selected':''}}>Tecnico</option>
            <option value="Coordinador">Coodinador</option>
          @else
            <option value="coordinador" {{(old('tipo_usu')=="coordinador")? 'selected':''}}>Coordinador</option>
            <option value="Comun">Tecnico</option>
          @endif 
        </select>
          @error('tipo_usu')
            <div class="alert alert-danger">{{ $message }}</div>
          @enderror           
      </div>
    </div>

    <div class="row">
      <div class="col-sm-3 form-group">
        <label for="">Usuario</label>
        <input type="text" class="form-control mayuscula" value="{{$trabajadores[0]->usuario}}"   name="usuario" placeholder="Usuario">
        @error('usuario')
          <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
      <div class="col-sm-3 form-group">
        <label for="">Password</label>
        <input type="password" class="form-control" value="{{@old('password')}}"   name="password"  placeholder="Password">
        @error('password')
          <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
      <div class="col-sm-3 form-group">
        <label for="">Password</label>
        <input type="password" class="form-control" value="{{@old('password_2')}}"  name="password_2" placeholder="Password">
        @error('password_2')
          <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>       
      <div class="col-sm-3 form-group">
        @if( $trabajadores[0]->tipo_usuario == "trabajador")
          <div style="display:" id="div_comunas_trabajador">
            @elseif($trabajadores[0]->tipo_usuario == "coordinador")
            <div style="display:none" id="div_comunas_trabajador">
              @endif    
                <label for="">Región trabajador</label>
                <select class="custom-select mayuscula " name="region_trabajo" id="region_trabajo" >
                  <option value="">Seleccionar</option>
                  @foreach($regiones_clientes as $regiones_clientes_)
                      <option value="{{$regiones_clientes_->id}}" {{(old('region_trabajo')==$regiones_clientes_->id)? 'selected':''}}>{{$regiones_clientes_->des_region}}</option>
                  @endforeach
                </select>
                <span id="opciones_dos">
                  @error('selecionados')
                    <div class="alert alert-danger">{{ $message }}</div>
                  @enderror
                  @foreach ($mis_trabajador_sucursals as $item)
                    <input type="checkbox" checked name="selecionados[]" id="{{$item->id}}" value="{{$item->id}}">
                    <label id="{{$item->id."-".$item->id}}">{{$item->des_region}}</label><br>
                  @endforeach
                    <input type="text" class="form-control" value="" name="" id="opcionuno_otro" style="display: none;">
                  @error('region_trabajo')
                    <div class="alert alert-danger">{{ $message }}</div>
                  @enderror
            </div>          
          </div>
      </div>

      <div class="row">
        <div class="col-sm-12 mt-5 text-center">
            <button type="submit" class="btn btn-prim w-25">Guardar</button>  
        </div>
      </div>
  </form>
</div>
    
@endsection
<script>
         $(function(){
           $('#region_trabajo').on('change',function(){
                                   var valor =  $('#region_trabajo option:selected').val();
                              
                                   var texto = $('#region_trabajo option:selected').text();
                                   var texto = '<label id='+valor+"-"+valor+'>'+texto+'</label>';
             $('#opciones_dos').append('<input type="checkbox"  checked id="'+valor+'" name="selecionados[]" value="'+valor+'">' +texto+'<br> ');
             console.log(valor, texto);
             $("#region_trabajo").find("option[value='"+valor+"']").remove();
           });


           $(document).on('change','input[type="checkbox"]',function(e){

              
              if(this.checked == false){


                // $('#region_trabajo').append('<option value="'+this.value+'" >'+ $("#"+this.value+"-"+this.value+"").text()+'</option>');


                // $("#"+this.value+"").remove();
                // $("#"+this.value+"-"+this.value+"").text("");
                //   $('checkbox[value="'+this.value+'"]').remove();
                

              }

          });
        });
</script>
<script>

$(function(){
           $('#tipos_usuarios').on('change',function(){
                          var valor =  $('#tipos_usuarios option:selected').val();
                          (valor);


                          if(valor == "Comun"){
                            $('#div_comunas_trabajador').css('display','');
                      //      $('#label_region').css('display','');

                          }else{
                            $('#div_comunas_trabajador').css('display','none');
                         //   $('#label_region').css('display','none');

                          }

          });
      });

  $(document).ready(function(){



    $('#region_usuario').change(function() {    
         buscar_comuna($("#region_usuario option:selected").val(),"#comuna_usuarios","../");  
        // alert("hols");
     })
// ************************RUT*****************************************
    //validar rut  
    $("#rut").change(function(){
      checkRut( $("#rut").val());
    });
    //agregar digito al rut
    $('#rut').on('input', function() {
      var valor = $("#rut").val().replace('.','');
     valor = valor.replace('-','');
     cuerpo = valor.slice(0,-1);
     dv = valor.slice(-1).toUpperCase();
     rut= cuerpo + '-'+ dv;
     $("#rut").val(rut);
     });

     
     $('#correo').change(function() {
    
      validarEmail($("#correo").val());
     });
  
  });

  function validarEmail(valor) {
  if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3,4})+$/.test(valor)){
  //  alert("La dirección de email " + valor + " es correcta.");
  console.log("listo");
  } else {
  //  alert("La dirección de email es incorrecta." + valor);
  //  $("#correo").val("");
  }
}

  function checkRut(rut) {
    // Despejar Puntos
    var valor = rut.replace('.','');
    // Despejar Guión
    valor = valor.replace('-','');
    
    // Aislar Cuerpo y Dígito Verificador
    cuerpo = valor.slice(0,-1);
    dv = valor.slice(-1).toUpperCase();
    
    // Formatear RUN
    rut.value = cuerpo + '-'+ dv
    
    // Si no cumple con el mínimo ej. (n.nnn.nnn)
    if(cuerpo.length < 7) { 
        alert("Rut Incorrecto");
        $("#rut").val('');
      }else{
    
    // Calcular Dígito Verificador
    suma = 0;
    multiplo = 2;
    
    // Para cada dígito del Cuerpo
    for(i=1;i<=cuerpo.length;i++) {
    
        // Obtener su Producto con el Múltiplo Correspondiente
        index = multiplo * valor.charAt(cuerpo.length - i);
        
        // Sumar al Contador General
        suma = suma + index;
        
        // Consolidar Múltiplo dentro del rango [2,7]
        if(multiplo < 7) { multiplo = multiplo + 1; } else { multiplo = 2; }
  
    }
    
    // Calcular Dígito Verificador en base al Módulo 11
    dvEsperado = 11 - (suma % 11);
    
    // Casos Especiales (0 y K)
    dv = (dv == 'K')?10:dv;
    dv = (dv == 0)?11:dv;
    
    // Validar que el Cuerpo coincide con su Dígito Verificador
    if(dvEsperado != dv) {
      alert("Rut incorrecto");
      $("#rut").val('');
    }
  }
  
}
  </script>
