@extends('menu/menu')

<style>
  #myBtn {
    display: none;
    position: fixed;
    bottom: 20px;
    right: 30px;
    z-index: 99;
    border: none;
    outline: none;
    background-color: #2d2f6f;
    color: white;
    cursor: pointer;
    padding: 15px;
    border-radius: 35px;
  }

  #myBtn:hover {
    background-color: #bf4e2b;
  }
</style>

<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>

<button class="mt-1" onclick="topFunction()" id="myBtn" title="Go to top">
  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-arrow-up-circle-fill" viewBox="0 0 16 16">
    <path d="M16 8A8 8 0 1 0 0 8a8 8 0 0 0 16 0zm-7.5 3.5a.5.5 0 0 1-1 0V5.707L5.354 7.854a.5.5 0 1 1-.708-.708l3-3a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L8.5 5.707V11.5z" />
  </svg>
</button>
@section('content')

@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

<div class="container mt-5">
  <div class="title-vista mt-4">API RETIRO</div>
</div>

<form action="{{route('filtros_retiro')}}" method="GET">
  <div class="container mt-5">
    <div class="seccion-filtro">Firltrar por</div>
    <hr class="separador">
    <div class="row">
      <!--AQUI SE CARGA EL SELECT DE CLIENTE-->
      <div class="col-sm-4 form-group">
        <label for="clientes">Cliente</label>
        <select class="custom-select mayuscula" id="clientes" name="clientes">
          <option selected value="">Seleccionar</option>
          @foreach ($carga_selectClientes2 as $cliente)
          @if($cliente->sCliente == $clientes and $cliente->sCliente != "" and $cliente->sCliente != null )
          <option selected value="{{ $cliente->sCliente }}">{{ ucfirst(strtolower($cliente->sCliente)) }}</option>
          @elseif($cliente->sCliente != "" || $cliente->sCliente != null )
          <option value="{{ $cliente->sCliente }}">{{ ucfirst(strtolower($cliente->sCliente)) }}
            @endif
          </option>
          @endforeach
        </select>
      </div>
      <!--AQUI SE CARGA LA FECHA-->
      <div class="col-sm-4 form-group">
        <label for="fecha">Fecha de Retiro</label>
        <div class="input-group d-flex">
          <input type="date" class="form-control mayuscula" id="fecha" value="{{$fecha1 ?? ''}}" name="fecha">
          <div class="input-group-append">
            <button type="button" class="btn app-color" id="vaciar" title="Borrar">
              <span class="material-icons-round">cancel</span>
            </button>
          </div>
        </div>
      </div>
      <!--AQUI SE CARGA EL SELECT DE ESTADO-->
      <div class="col-sm-4 form-group">
        <label for="estado">Estado</label>
        <select id="estado" name="estado" class="custom-select mayuscula">
          <option selected value="">seleccionar</option>
          @foreach ($carga_selectEstado2 as $estados)
          @if($estados->estado_retiro_Cord == $estado)
          <option selected value="{{ $estados->estado_retiro_Cord }}">{{ ucfirst(strtolower($estados->estado_retiro_Cord)) }}</option>
          @else
          <option value="{{ $estados->estado_retiro_Cord }}">{{ ucfirst(strtolower($estados->estado_retiro_Cord)) }}</option>
          @endif
          @endforeach
        </select>
      </div>
    </div>

    <div class="row bg-seccion-filtro rounded">
      <!--AQUI SE CARGA EL SELECT DE REGION-->
      <div class="col-sm-4 form-group">
        <label for="region">Región</label>
        <select id="region" name="region" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          <option selected value="">Todos</option>
          @if (!empty($carga_selectRegion))
          @foreach ($carga_selectRegion as $regiones)
          @if ($regiones->sRegion != null)
          @if($regiones->sRegion == $region)
          <option selected value="{{ $regiones->sRegion }}">{{ucfirst(strtolower($regiones->sRegion))}} </option>
          @else
          <option value="{{ $regiones->sRegion }}">{{ucfirst(strtolower($regiones->sRegion))}} </option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-4 form-group">
        <label for="comuna">Comuna</label>
        <select id="comuna" name="comuna" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          <option selected value="">Todos</option>
          @foreach ($carga_selectComuna2 as $comunas)
          @if($comunas->sComuna == $comuna)
          <option selected value="{{ $comunas->sComuna }}">{{ ucfirst(strtolower($comunas->sComuna)) }}</option>
          @else
          <option value="{{ $comunas->sComuna }}">{{ ucfirst(strtolower($comunas->sComuna)) }}</option>
          @endif
          @endforeach
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE DIRECCIÓN-->
      <div class="col-sm-4 form-group">
        <label for="Direccion">Dirección</label>
        <select id="direccion" name="direccion" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          <option selected value="">Todos</option>
          @if (!empty($direccionTemporal))
          @foreach ($direccionTemporal as $direcciones)
          @if ($direcciones->descripcion_direccion != null)
          @if($direcciones->descripcion_direccion == $direccion)
          <option selected value="{{$direcciones->descripcion_direccion}}">{{$direcciones->descripcion_direccion}}</option>
          @else
          <option value="{{$direcciones->descripcion_direccion}}">{{$direcciones->descripcion_direccion}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <div class="container">
        <a href="" onclick="actualizar_regiones()" class="btn btn-ter float-sm-right">
          <span class="material-icons-round">update</span>
          Actualizar datos de Región
        </a>
      </div>
    </div>

    <div class="row mt-2">
      <!--AQUI SE CARGA EL SELECT DE Nº DE SERIE-->
      <div class="col-sm-4 form-group">
        <label for="serie">Nº de Serie</label>
        <input type="" class="form-control mayuscula" id="serie" value="{{$serie ?? ''}}" name="serie" placeholder="Nº de Serie">
      </div>
      <!--AQUI SE CARGA EL SELECT DE TÉCNICO-->
      <div class="col-sm-4 form-group">
        <label for="tecnicos">Técnico</label>
        <select id="tecnicos" name="tecnicos" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          @if (!empty($tecnico))
          @foreach ($tecnico as $tecnicos)
          @if ($tecnicos->nombre_uno != null)
          @if($tecnicos->id == $id_persona)
          <option selected value="{{ $tecnicos->id }}">{{ucfirst(strtolower($tecnicos->nombre_uno))}} {{ucfirst(strtolower($tecnicos->apellido_uno))}}
            @else
          <option value="{{ $tecnicos->id }}">{{ucfirst(strtolower($tecnicos->nombre_uno))}} {{ucfirst(strtolower($tecnicos->apellido_uno))}}
            @endif
            @endif
            @endforeach
            @endif
        </select>
      </div>
    </div>
  </div>

  {{-- BOTON BUSCAR --}}
  <div class="text-center mb-5 mt-5">
    <button type="buscar" class="btn btn-pill btn-prim w-25">Buscar</button>
  </div>
  {{ session(['url_retiro' => url()->full()])     }}
  <div class="container mt-5">
    {{-- EXPORTAR --}}
    <ul class="nav bg-export">
      <li class="clas-item">
        <a class="btn btn-ter" target="_blank" href="{{route('ir_vista_excel',Crypt::encryptString(url()->full()))}})}}">
          Exportar excel
          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-excel-fill" viewBox="0 0 16 16">
            <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM5.884 6.68 8 9.219l2.116-2.54a.5.5 0 1 1 .768.641L8.651 10l2.233 2.68a.5.5 0 0 1-.768.64L8 10.781l-2.116 2.54a.5.5 0 0 1-.768-.641L7.349 10 5.116 7.32a.5.5 0 1 1 .768-.64z" />
          </svg>
        </a>
      </li>
      <li class="clas-item">
        <button type="button" class="btn btn-ter" data-toggle="modal" data-target="#modalretiroTemporal">
          Crear retiro temporal
        </button>
      </li>
      <li class="m-auto">
        <i>Para ver toda la información, deslice a la derecha</i>
        <span class="material-icons-round icon-midle">trending_flat</span>
      </li>
    </ul>
  </div>

  <div class="container table-responsive mb-5">
    {{-- TABLA RESULTADO --}}
    <div>
      <table class="table table-striped table-hover" id="mitable">
        <thead class="color-head">
          <tr>
            <th class="th-head border-th separador-v" colspan="2">FECHAS DE RETIRO</th>
            <th class="th-head border-th separador-v" colspan="1">ESTADO (KYOCERA)</th>
            <th class="th-head border-th separador-v" colspan="1">ESTADO RETIRO</th>
            <th class="th-head border-th separador-v" colspan="1">CLIENTE</th>
            <th class="th-head border-th separador-v" colspan="1">REGION</th>
            <th class="th-head border-th separador-v" colspan="1">COMUNA</th>
            <th class="th-head border-th separador-v" colspan="1">DIRECCION</th>
            <th class="th-head border-th separador-v" colspan="2">CUI</th>
            <th class="th-head border-th separador-v" colspan="1">N° DE SERIE</th>
            <th class="th-head border-th"><span class="material-icons">
                settings
              </span></th>
          </tr>
        </thead>
        <tbody>
          @if(!empty($retiros))
          @foreach ($retiros as $los_datos)
          <tr>
            <td class="td-val" colspan="2">
              @if($los_datos->fecha_retiroCord != null and $los_datos->fecha_retiroCord != "0000-00-00")
              {{Carbon\Carbon::createFromDate($los_datos->fecha_retiroCord)->format('d-m-Y')}}
              @else
              Sin Fecha
              @endif
            </td>
            <td class="td-val">
              {{$los_datos->sEstado}}<br>
              @if($los_datos->instalador != null)
              ({{$los_datos->instalador}})
              @else
              @endif
            </td>
            <td class="td-val"> {{$los_datos->estado_retiro_Cord}} </td>
            <td class="td-val"> {{$los_datos->sCliente}} </td>
            <td class="td-val">{{$los_datos->sRegion}}</< /td>
              @if($los_datos->sComuna != "REVISAR CHECK" and $los_datos->sComuna != "revisar check" and $los_datos->sComuna != "Revisar Check")
            <td class="td-val">{{$los_datos->sComuna}}</td>
            @else
            <td class="td-val"></td>
            @endif
            <td class="td-val"> {{$los_datos->sDireccion}} </td>
            @if($los_datos->sCui != "undefined")
            <td class="td-val" colspan="2">{{$los_datos->sCui}}</td>
            @else
            <td class="td-val" colspan="2">
              @endif
            </td>
            @if($los_datos->sSerie != "REVISAR CHECK" and $los_datos->sSerie != "revisar check" and $los_datos->sSerie != "Revisar Check")
            <td class="td-val">{{$los_datos->sSerie}}</td>
            @else
            <td class="td-val"></td>
            @endif
            <td class="td-val">
              <div class="dropdown dropleft" style="text-align: center;">

                <button type="button" class="btn-dropdown" data-toggle="dropdown">
                  <span class="material-icons">more_vert</span>
                </button>
                <div class="dropdown-menu mostrar shadow">
                  <div class="d-flex justify-content-around">
                    <a role="button" class="btn-icon btn-icon-dd verdetalle" title="Ver Detalle" data-id="{{Crypt::encryptString($los_datos->id)}}">
                      <span class="material-icons">visibility</span>
                    </a>
                    <a role="button" class="btn-icon btn-icon-dd ver_historial_retiros" title="Historial" data-id="{{Crypt::encryptString($los_datos->id)}}" data-estado="">
                      <span class="material-icons">history</span>
                    </a>
                    <a role="button" class="btn-icon btn-icon-dd historial_check" title="Historial_check" data-id="{{Crypt::encryptString($los_datos->id)}}" data-estado="">
                      <span class="material-icons">manage_history</span>
                    </a>
                  </div>
                </div>
              </div>
            </td>
          </tr>
          @endforeach
          @endif
        </tbody>
      </table>
    </div>
    <div class="container mt-4">
      <div class=" d-flex justify-content-center ">
        @if(Route::current()->getName()=='go.api_retiros')
        {{$retiros->links()}}
        @endif
      </div>
    </div>
  </div>
</form>





{{-- /////////////////////////MODALLLL////////////  --}}
<div class="modal fade" id="modal_historial_retiros" role="dialog">
  <div class="modal-dialog  modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <div class="seccion-modal">Historial de Checklist</div>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador ml-4 mr-4">

      <div class="modal-body">
        <div class="container text-center">
          <form action="{{route('go.asignar_check_retiro')}}" method="GET">
            <button type="submit" class="btn btn-prim px-sm-4" id="btnview">
              <input type="text" value="" id="m_id_retiros" name="idretiros" style="display:none">
              Asignar
            </button>
          </form>
        </div>
      </div>

      <div class="container">
        <!-- TABLA DE RESULTADOS DE BUSQUEDA -->
        <table class="table table-sm table-bordered table-responsive-md table-striped table-hover my-4" id="dataGrid">
          <!-- ENCABEZADO -->
          <thead class="color-head">
            <tr>
              <th class="th-head border-th separador-v" colspan="1">CODIGO</th>
              <th class="th-head border-th separador-v" colspan="1">FECHA ASIGNACION</th>
              <th class="th-head border-th separador-v" colspan="1">TECNICO</th>
              <th class="th-head border-th separador-v" colspan="1">ESTADO</th>
              <th class="th-head border-th">
                <span class="material-icons">settings</span>
              </th>
            </tr>
          </thead>
          <!-- FIN ENCABEZADO -->

          <!-- RESULTADOS -->
          <tbody id="cuerpo_tabla"></tbody>
          <!-- FIN RESULTADOS -->
        </table>
      </div>
    </div>
  </div>
</div>



<!-- MODAL DETALLE DE RETIRO DE EQUIPOS -->
<div class="modal fade" id="modal_detalle_retiro" role="dialog">
  <div class="modal-dialog  modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <div class="seccion-modal">DETALLE DE RETIRO DE EQUIPOS</div>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador ml-4 mr-4">

      <form>
        <div class="modal-body">
          <div class="container">
            <!-- sombra de separación con el fondo -->
            <div class="row">

              <!-- Fila 1 ------------------------------------------------------>
              <div class="col-sm-3 form-group ">
                <label for="email">Folio</label>
                <input type="text" readonly="readonly" class="form-control locked tex-modal-input" id="folioretiro" placeholder="FOLIO" name="folioretiro">
              </div>
              <div class="col-sm-3 form-group">
                <label for="email">Guía</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="guiaretiro" placeholder="GUÍA" name="guiaretiro">
              </div>

              <div class="container">
                <hr class="linea">
              </div>

              <!-- Detalle del Cliente -->
              <div class="col-sm-12 ">
                <div class="seccion-filtro">Detalle del cliente</div>
                <hr class="separador">
              </div>
              <!-- Fila 2 ------------------------------------------------------>
              <div class="col-sm-6 form-group">
                <label for="email">Cliente</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="clienteretiro" placeholder="CLIENTE" name="clienteretiro">
              </div>
              <!--<div class="col-sm-3 form-group">
                  <label for="email">Rut</label>
                  <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="rutretiro" placeholder="RUT" name="rutretiro">
              </div>-->
              <div class="col-sm-3 form-group">
                <label for="email">Región</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="regionretiro" placeholder="REGIÓN" name="regionretiro">
              </div>
              <div class="col-sm-3 form-group">
                <label for="email">Ciudad</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="ciudadretiro" placeholder="HORA DE TERMINO" name="ciudadretiro">
              </div>
              <!-- Fila 3 ------------------------------------------------------>
              <div class="col-sm-6 form-group">
                <label for="email">Dirección</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="direccionretiro" placeholder="DIRECCIÓN" name="direccionretiro">
              </div>
              <div class="col-sm-3 form-group">
                <label for="email">Comuna</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="comunaretiro" placeholder="COMUNA" name="comunaretiro">
              </div>
              <div class="col-sm-3 form-group">
                <label for="email">CUI o Cod Sucursal</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="codigoretiro" placeholder="CUI O CÓDIGO SUCURSAL" name="codigoretiro">
              </div>

              <div class="container">
                <hr class="linea">
              </div><br>

              <!-- Detalle de Equipamiento -->
              <div class="col-12">
                <div class="seccion-filtro">Detalle de equipamiento</div>
                <hr class="separador">
              </div>
              <!-- Fila 4 ------------------------------------------------------>
              <div class="col-sm-3 form-group">
                <label for="email">Serie</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="serieretiro" placeholder="SERIE" name="serieretiro">
              </div>
              <div class="col-sm-3 form-group">
                <label for="email">Modelo</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="modeloretiro" placeholder="MODELO" name="modeloretiro">
              </div>
              <div class="col-sm-3 form-group">
                <label for="email">Contador B/N</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="contadorretiro" placeholder="CONTADOR B/N" name="contadorretiro">
              </div>
              <div class="col-sm-3 form-group">
                <label for="email">Contador color</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="colorcontadorretiro" placeholder="CONTADOR COLOR" name="colorcontadorretiro">
              </div>
              <!-- Fila 5 ------------------------------------------------------>
              <div class="container">
                <hr class="linea">
              </div>

              <div class="col-sm-12 form-group checkbox">
                <label for="cambio">Observaciones</label>
                <textarea readonly="readonly" class="form-control locked tex-modal-input" id="obs" name="obsercaviones" rows="4"></textarea>
              </div>

              <div class="container">
                <hr class="linea">
              </div>
              <!-- Fila 6 ------------------------------------------------------>
              <div class="col-sm-6 form-group">
                <label for="email">Estado</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="estadoretiro" placeholder="ESTADO" name="estadoretiro">
              </div>
              <div class="col-sm-6 form-group"></div>
            </div>
          </div>
        </div>
      </form>

    </div>
  </div>
</div>

<!--Modal Historial-->
<div class="modal" id="modalHistorial">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title"> Historial</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <table class="table table-bordered table-responsive-lg table-striped">
          <thead>
            <th scope="col">N° de serie</th>
            <th scope="col">Direccion</th>
            <th scope="col">Cliente</th>
            <th scope="col">Fecha</th>
            <th scope="col">Contador B/N</th>
            <th scope="col">Contador Color</th>
            <th scope="col">Observaciones</th>
          </thead>
          <tbody id="agregar_historial_retiro"></tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<!-- Modal  crear retiro temportal-->
<div class="modal fade" id="modalretiroTemporal" role="dialog" tabindex="-1" aria-labelledby="modalretiroTemporalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <div class="seccion-modal">CREAR RETIRO TEMPORAL</div>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador ml-4 mr-4">

      <form action="{{route('crear.retiroTemporal')}}" method="POST">
        @csrf
        <div class="modal-body">
          <div class="container">
            <div class="seccion-filtro">Datos del técnico</div>
            <hr class="separador">

            <div class="row">
              <!--FILA 1-->
              <div class="col-sm-4 form-group">
                <label for="tecnic">Técnico</label>
                <select name="tecnicoTemporal" class="custom-select mayuscula" id="">
                  <option value="" selected>Seleccione</option>
                  @if(!empty($tecnicoTemporal))
                  @foreach ($tecnicoTemporal as $tTemporal)
                  <option value="{{$tTemporal->id}}">{{$tTemporal->nombre_uno. " ".$tTemporal->apellido_uno. " ".$tTemporal->apellido_dos}}</option>
                  @endforeach
                  @endif
                </select>
              </div>

              <div class="col-sm-4 form-group">
                <label for="email">N° de visita</label>
                <input type="number" class="form-control mayuscula" value="" readonly="readonly" placeholder="1" name="numero_visitas">
              </div>

              <div class="col-sm-4 form-group">
                <label for="">Proyecto Asociado</label>
                <select name="proyectos" class="custom-select mayuscula">
                  <option value="" selected>Seleccione</option>
                  @if(!empty($proyectosTemporal))
                  @foreach ($proyectosTemporal as $pTemporal)
                  <option value="{{$pTemporal->id_proyecto}}">{{$pTemporal->nombre." (".$pTemporal->razon_social.")" }} </option>
                  @endforeach
                  @endif
                </select>
              </div>
            </div>


            <div class="seccion-filtro">Datos del cliente</div>
            <hr class="separador">

            <div class="row">
              <div class="col-sm-6 form-group">
                <label for="">Cliente Asociado</label>
                <select class="custom-select mayuscula" required id="clientes_modal" name="clientes_modal">
                  <option selected value="">seleccione</option>
                  @foreach ($carga_selectClientes2 as $cliente)
                  @if($cliente->sCliente == $clientes)
                  <option value="{{ $cliente->sCliente }}">{{ ucfirst(strtolower($cliente->sCliente)) }}</option>
                  @else
                  <option value="{{ $cliente->sCliente }}">{{ ucfirst(strtolower($cliente->sCliente)) }}
                    @endif
                  </option>
                  @endforeach
                </select>
              </div>

              <div class="col-sm-4 form-group">
                <label for="">Fecha Retiro Temporal</label>
                <input type="date" class="form-control mayuscula" id="" placeholder="Fecha" name="fecha_retiro_temporal" value="">
              </div>

              <div class="col-sm-4 form-group">
                <label for="">Direccion</label>
                <select name="sDireccion" class="custom-select mayuscula">
                  <option value="" selected>Seleccione</option>
                  @if(!empty($direccionTemporal))
                  @foreach ($direccionTemporal as $dTemporal)
                  <option value="{{$dTemporal->descripcion_direccion}}">{{$dTemporal->descripcion_direccion }} </option>
                  @endforeach
                  @endif
                </select>
              </div>

              <div class="col-sm-4 form-group">
                <label for="">Cantidad de equipos</label>
                <input type="number" class="form-control" value="" placeholder="" name="cantidad_equipos">
              </div>
            </div>

            <div class="container form-group mt-4 text-center">
              <button class="btn btn-prim px-sm-5" type="submit">Guardar</button>
            </div>
      </form>
    </div>
  </div>
</div>

<script>
  $(document).ready(function() {
    $("#serie").on("keyup", function() {
      var value = $(this).val().toLowerCase();
      $("#myTable tr").filter(function() {
        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
      });
    });
  });
</script>


@endsection



<script>
  $(document).ready(function() {
    $('.historial_check').click(function() {
      id = $(this).attr("data-id");
      $.ajax({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        type: 'POST',
        url: "{{ route('go.historial_check_retiro') }}",
        data: {
          'id': id
        },
        success: function(data) {
          $("#modalHistorial").modal('show');
          $('#agregar_historial_retiro').empty();
          $('#agregar_historial_retiro').append(data);
        },
        error: function(xhr, status) {
          alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
        }
      })
    })
    $('.verdetalle').click(function() {
      var id_retiros = $(this).attr("data-id");
      $("#m_id_retiros").val(id_retiros);
      var _token = $('input[name="_token"]').val();
      $("#modal_detalle_retiro").modal('show');
      $.ajax({
        method: "POST",
        url: "{{ route('go.datosretiro') }}",
        data: {
          'id_retiros': id_retiros,
          _token: _token
        },
        success: function(data) {
          console.log(data);
          $.each(data, function(i, item) {
            $("#folioretiro").val(item.nFolio);
            $("#guiaretiro").val(item.nGuia);
            $("#clienteretiro").val(item.sCliente);
            $("#rutretiro").val(item.sRut);
            $("#regionretiro").val(item.sRegion);
            $("#ciudadretiro").val(item.sCiudad);
            $("#direccionretiro").val(item.sDireccion);
            $("#comunaretiro").val(item.sComuna);
            $("#codigoretiro").val(item.sCui);
            $("#comunaretiro").val(item.sComuna);
            $("#serieretiro").val(item.sSerie);
            $("#modeloretiro").val(item.sModelo);
            $("#contadorretiro").val(item.nContador);
            $("#colorcontadorretiro").val(item.nContador_color);
            $("#obs").val(item.sObservacion);
            $("#estadoretiro").val(item.sEstado);
          });
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      })
    })
  })
</script>

<script>
  $(document).ready(function() {

    $('.ver_historial_retiros').click(function() {
      var id_retiros = $(this).attr("data-id");
      $("#m_id_retiros").val(id_retiros)


      var _token = $('input[name="_token"]').val();


      $.ajax({

        // headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },

        method: "POST",

        url: "{{route('checklist.retiros')}}",

        data: {
          'id_retiros': id_retiros,
          _token: _token
        },

        success: function(data) {
          console.log(data);

          $(cuerpo_tabla).empty();
          $(cuerpo_tabla).append(data);
          $("#modal_historial_retiros").modal('show');

          //validacion del boton
          var toma2 = "";
          //estado con boton
          var cancel = "cancelado";

          //estados sin boton
          var pend = "pendiente";
          var revis = "revisado";
          var asigna = "asignado";
          var fina = "finalizado";
          var recha = "rechazado";


          //funcion para botener el estado de la primera fila
          $.each($("#dataGrid:eq(0)"), function() {
            toma2 = $(this).find('td').eq(3).html();
            console.log(toma2);


            //estados sin boton
            if (toma2 == 'cancelado' || toma2 == "Cancelado") {
              $('#btnview').show();
            } else if (toma2 == pend || toma2 == "Pendiente") {
              $('#btnview').show();
            } else if (toma2 == fina || toma2 == "Finalizado") {
              $('#btnview').hide();
            } else if (toma2 == asigna || toma2 == "Asignado") {
              $('#btnview').hide();
            } else if (toma2 == revis || toma2 == "Revisado") {
              $('#btnview').hide();
            } else if (toma2 == recha || toma2 == "Rechazado") {
              $('#btnview').show();
            } else if (toma2 == "revisar" || toma2 == "Revisar") {
              $('#btnview').hide();
            } else if (toma2 == "tarea_asignada" || toma2 == "Tarea_asignada" || toma2 == "Tarea Asignada") {
              $('#btnview').hide();
            } else if (data == '<tr><td>Sin Datos</td></tr>') {
              $('#btnview').show();
            }


          });



        },

        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });

    })
  })

  $('.ver_historial_instalacion').click(function() {
    // var descripcion_pago = $(this).attr("data-descripcion_pago");
    // $("#mi_descripcion").text(descripcion_pago)
    $("#modal_historial_detalle").modal('show');

  });
</script>

<script>
  //Get the button
  var mybutton = document.getElementById("myBtn");

  // When the user scrolls down 20px from the top of the document, show the button
  window.onscroll = function() {
    scrollFunction()
  };

  function scrollFunction() {
    if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
      mybutton.style.display = "block";
    } else {
      mybutton.style.display = "none";
    }
  }

  // When the user clicks on the button, scroll to the top of the document
  function topFunction() {
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;
  }
</script>
<script>
  $(document).ready(function() {
    $('#vaciar').click(function() {
      $('#fecha').val("");
    });
  });
</script>

<script>
  $(document).ready(function() {


    $("#region").change(function() {
      region = $('select[id=region]').val();
      var _token = $('input[name="_token"]').val();

      $.ajax({
        method: "POST",

        url: "{{ route('buscarComunasRetiros') }}",

        data: {
          'region': region,
          _token: _token
        },

        success: function(data) {
          $("#comuna").empty();
          $("#direccion").empty();
          $("#sucursal").empty();
          $("#comuna").append('<option value="">Seleccionar</option>');
          $("#direccion").append('<option value="">Seleccionar</option>');
          $("#sucursal").append('<option value="">Seleccionar</option>');
          $(data).each(function(i, v) { // indice, valor
            //if(v.sComuna != null || v.sComuna != "null"  ){ 
            $("#comuna").append('<option value="' + v.sComuna + '">' + v.sComuna + '</option>');
          })
          // }

        },

        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });
    });
    $("#comuna").change(function() {
      comuna = $('select[id=comuna]').val();
      var _token = $('input[name="_token"]').val();



      $.ajax({
        method: "POST",

        url: "{{ route('buscardireccionesRetiro') }}",

        data: {
          'comuna': comuna,
          _token: _token
        },

        success: function(data) {
          $("#direccion").empty();
          $("#sucursal").empty();
          $("#direccion").append('<option value="">Seleccionar</option>');
          $("#sucursal").append('<option value="">Seleccionar</option>');

          $(data).each(function(i, v) { // indice, valor
            //if(v.sdireccion != null || v.sdireccion != "null"  ){ 
            $("#direccion").append('<option value="' + v.sDireccion + '">' + v.sDireccion + '</option>');
          })
          // }

        },

        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });
    });

    $("#direccion").change(function() {
      direccion = $('select[id=direccion]').val();
      var _token = $('input[name="_token"]').val();


      $.ajax({
        method: "POST",

        url: "{{ route('buscarsucursales') }}",

        data: {
          'direccion': direccion,
          _token: _token
        },

        success: function(data) {
          $("#sucursal").empty();
          $("#sucursal").append('<option value="">Seleccionar</option>');

          $(data).each(function(i, v) { // indice, valor
            //if(v.ssucursal != null || v.ssucursal != "null"  ){ 
            $("#sucursal").append('<option value="' + v.sTipo_sucursal + '">' + v.sTipo_sucursal + '</option>');
          })
          // }

        },

        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });
    });


  });

  function actualizar_regiones() {
    var _token = $('input[name="_token"]').val();

    $.ajax({
      method: "GET",

      url: "{{ route('go.actualizarregiones') }}",

      data: {
        _token: _token
      },

      success: function(data) {
        alert("proceso Completado");
        location.reload();

      },

      error: function(xhr, status) {
        alert('Disculpe, ha ocurrido un problema, intente mas tarde');
      }

    });

  }
</script>