@extends('menu/menu')
<style>
  #myBtn {
    display: none;
    position: fixed;
    bottom: 20px;
    right: 30px;
    z-index: 99;
    border: none;
    outline: none;
    background-color: #2d2f6f;
    color: white;
    cursor: pointer;
    padding: 15px;
    border-radius: 35px;
  }

  #myBtn:hover {
    background-color: #bf4e2b;
  }
</style>
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>

<button class="mt-1" onclick="topFunction()" id="myBtn" title="Go to top"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-arrow-up-circle-fill" viewBox="0 0 16 16">
    <path d="M16 8A8 8 0 1 0 0 8a8 8 0 0 0 16 0zm-7.5 3.5a.5.5 0 0 1-1 0V5.707L5.354 7.854a.5.5 0 1 1-.708-.708l3-3a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L8.5 5.707V11.5z" />
  </svg></button>

@section('content')


@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

<div class="container mt-5">
  <div class="title-vista mt-4">API INSTALACIÓN</div>
</div>


<form action="{{route('filtros_instalacion')}}" method="GET">
  <div class="container mt-5">
    <div class="seccion-filtro">Firltrar por</div>
    <hr class="separador">

    <div class="row">
      <!--AQUI SE CARGA EL SELECT DE FECHA INICIO-->
      <div class="col-sm-3 form-group">
        <label for="datepicker">Fecha de inicio</label>
        <div class="input-group d-flex">
          <input type="date" class="form-control mayuscula" id="datepicker" value="{{$fecha ?? ''}}" name="datepicker">
          <div class="input-group-append">
            <button type="button" class="btn app-color" id="vaciar_fecha1" title="Borrar">
              <span class="material-icons-round">cancel</span>
            </button>
          </div>
        </div>
      </div>
      <!--AQUI SE CARGA EL SELECT DE FECHA FINAL-->
      <div class="col-sm-3 form-group">
        <label for="datepicker2">Fecha final</label>
        <div class="input-group d-flex">
          <input type="date" class="form-control mayuscula" id="datepicker2" value="{{$fecha2 ?? ''}}" name="datepicker2">
          <div class="input-group-append">
            <button type="button" class="btn app-color" id="vaciar_fecha1" title="Borrar">
              <span class="material-icons-round">cancel</span>
            </button>
          </div>
        </div>
      </div>
      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-3 form-group">
        <label for="tecnicos">Técnico</label>
        <select id="tecnicos" name="tecnicos" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          @if (!empty($tecnico))
          @foreach ($tecnico as $tecnicos)
          @if ($tecnicos->nombre_uno != null)
          @if($tecnicos->id == $id_persona )
          <option selected value="{{ $tecnicos->id }}">{{ucfirst(strtolower($tecnicos->nombre_uno))}} {{ucfirst(strtolower($tecnicos->apellido_uno))}}
            @else
          <option value="{{ $tecnicos->id }}">{{ucfirst(strtolower($tecnicos->nombre_uno))}} {{ucfirst(strtolower($tecnicos->apellido_uno))}}
            @endif
            @endif
            @endforeach
            @endif
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE ESTADO-->
      <div class="col-sm-3 form-group">
        <label for="estado">Estado de instalación</label>
        <select id="estado" name="estado" class="custom-select mayuscula">
          <option selected value="">seleccionar</option>
          @if (!empty($carga_selectEstado))
          @foreach ($carga_selectEstado as $estados)
          @if ($estados->sEstado_instalacion != null)
          @if ($estados->sEstado_instalacion == $estado)
          <option selected value="{{ $estados->sEstado_instalacion }}">{{ucfirst(strtolower($estados->sEstado_instalacion))}}</option>
          @else
          <option value="{{ $estados->sEstado_instalacion }}">{{ucfirst(strtolower($estados->sEstado_instalacion))}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
    </div>

    <div class="row">
      <!--AQUI SE CARGA EL SELECT DE CLIENTE-->
      <div class="col-sm-3 form-group">
        <label for="clientes">Cliente</label>
        <div class="input-group d-flex">
          <select class="custom-select mayuscula" id="clientes" name="clientes" style="pointer-events: none" readonly="readonly">
            @if (!empty($carga_selectClientes))
            @foreach ($carga_selectClientes as $clientes)
            @if($clientes->sCliente != null)
            @if ($clientes->sCliente == $cliente_seleccionado)
            <option selected value="{{ $clientes->sCliente }}">{{ucfirst(strtolower($clientes->sCliente ))}}
              @endif
              @endif
              @endforeach
              @endif
          </select>
          <div class="input-group-append">
            <a href="{{route('go.api_instalacion')}}" class="btn app-color" title="Cambiar cliente">
              <span class="material-icons-round">people</span>
            </a>
          </div>
        </div>
      </div>
      <!--AQUI SE CARGA EL SELECT DE PROYECTO-->
      <div class="col-sm-3 form-group">
        <label for="clientes">Proyecto</label>
        <select class="custom-select mayuscula" id="proyectos" name="proyectos">
          <option selected value="">seleccionar</option>
          <option value="1">Sin asociar</option>
          @if (!empty($carga_selectProyecto))
          @foreach ($carga_selectProyecto as $proyectos)
          @if($proyectos->nombre != null)
          @if ($proyectos->id == $proyectoseleccionado)
          <option selected value="{{ $proyectos->id }}">{{ucfirst(strtolower($proyectos->nombre ))}}
            @else
          <option value="{{ $proyectos->id }}">{{ucfirst(strtolower($proyectos->nombre ))}}
            @endif
            @endif
            @endforeach
            @endif
        </select>
      </div>
      <!--AQUI SE INGRESA LA SERIE-->
      <div class="col-sm-3 form-group">
        <label for="serie">Nº de Serie</label>
        <input type="" class="form-control mayuscula" id="serie" name="serie" value="{{$serie ?? ''}}" placeholder="Nº de Serie">
      </div>
      <!--AQUI SE INGRESA EL SC-->
      <div class="col-sm-3 form-group">
        <label for="sc">SC</label>
        <input type="" class="form-control mayuscula" id="sc" placeholder="SC" value="{{$sc ?? ''}}" name="sc">
      </div>
    </div>

    <div class="row bg-seccion-filtro rounded">
      <!--AQUI SE CARGA EL SELECT DE REGION-->
      <div class="col-sm-3 form-group">
        <label for="region">Región</label>
        <select id="region" name="region" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          <option value="">Todos</option>
          @if (!empty($carga_selectRegion))
          @foreach ($carga_selectRegion as $regiones)
          @if ($regiones->sRegion != null)
          @if($regiones->sRegion == $region)
          <option selected value="{{ $regiones->sRegion }}">{{ucfirst(strtolower($regiones->sRegion))}} </option>
          @else
          <option value="{{ $regiones->sRegion }}">{{ucfirst(strtolower($regiones->sRegion))}} </option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-3 form-group">
        <label for="comuna">Comuna</label>
        <select id="comuna" name="comuna" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          <option value="">Todos</option>
          @if (!empty($carga_selectComuna))
          @foreach ($carga_selectComuna as $comunas)
          @if ($comunas->sComuna != null)
          @if($comunas->sComuna == $comuna)
          <option selected value="{{ $comunas->sComuna }}">{{ucfirst(strtolower($comunas->sComuna))}}</option>
          @else
          <option value="{{ $comunas->sComuna }}">{{ucfirst(strtolower($comunas->sComuna))}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE DIRECCION-->
      <div class="col-sm-3 form-group">
        <label for="direccion">Dirección</label>
        <select id="direccion" name="direccion" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          <option value="">Todos</option>
          @if (!empty($direccionTemporal))
          @foreach ($direccionTemporal as $direcciones)
          @if ($direcciones->descripcion_direccion != null)
          @if ($direcciones->descripcion_direccion == $direccion)
          <option selected value="{{ $direcciones->descripcion_direccion }}">{{ucfirst(strtolower($direcciones->descripcion_direccion))}}</option>
          @else
          <option value="{{ $direcciones->descripcion_direccion }}">{{ucfirst(strtolower($direcciones->descripcion_direccion))}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE SUCURSAL-->
      <div class="col-sm-3 form-group">
        <label for="sucursal">Sucursal</label>
        <select id="sucursal" name="sucursal" class="custom-select mayuscula">
          <option selected value="">seleccionar</option>
          @if (!empty($carga_selectSucursal))
          @foreach ($carga_selectSucursal as $sucursales)
          <option value="">Todos</option>
          @if ($sucursales->sTipo_sucursal != null)
          @if($sucursales->sTipo_sucursal == $sucursal)
          <option selected value="{{ $sucursales->sTipo_sucursal }}">{{ucfirst(strtolower($sucursales->sTipo_sucursal))}}</option>
          @else
          <option value="{{ $sucursales->sTipo_sucursal }}">{{ucfirst(strtolower($sucursales->sTipo_sucursal))}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <div class="container">
        <a href="" onclick="actualizar_regiones()" class="btn btn-ter float-sm-right">
          <span class="material-icons-round">update</span>
          Actualizar datos de Región
        </a>
      </div>
    </div>
  </div>

  {{-- BOTON BUSCAR --}}
  <div class="text-center mb-5 mt-5">
    <button type="buscar" class="btn btn-pill btn-prim w-25">Buscar</button>
  </div>

  {{ session(['url_cordinadora' => url()->full()])     }}

  <div class="container mt-5 p-0">
    {{-- EXPORTAR --}}
    <ul class="nav bg-export">
      <li class="clas-item">
        <a class="btn btn-ter" target="_blank" href="{{route('go.excel_instalacionCordinadora',Crypt::encryptString(url()->full()))}}">
          Exportar excel
          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-excel-fill" viewBox="0 0 16 16">
            <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM5.884 6.68 8 9.219l2.116-2.54a.5.5 0 1 1 .768.641L8.651 10l2.233 2.68a.5.5 0 0 1-.768.64L8 10.781l-2.116 2.54a.5.5 0 0 1-.768-.641L7.349 10 5.116 7.32a.5.5 0 1 1 .768-.64z" />
          </svg>
        </a>
      </li>
      <li class="clas-item">
        <a class="btn btn-ter " target="_blank" href="{{route('exportar_instalacionchecklist',$cliente_seleccionado)}}">
          Exportar Excel con Checklist
          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-excel" viewBox="0 0 16 16">
            <path d="M5.884 6.68a.5.5 0 1 0-.768.64L7.349 10l-2.233 2.68a.5.5 0 0 0 .768.64L8 10.781l2.116 2.54a.5.5 0 0 0 .768-.641L8.651 10l2.233-2.68a.5.5 0 0 0-.768-.64L8 9.219l-2.116-2.54z" />
            <path d="M14 14V4.5L9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2zM9.5 3A1.5 1.5 0 0 0 11 4.5h2V14a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h5.5v2z" />
          </svg>
        </a>
      </li>
      <li class="m-auto">
        <i>Para ver toda la información, deslice a la derecha</i>
        <span class="material-icons-round icon-midle">trending_flat</span>
      </li>
    </ul>
  </div>

  {{-- TABLA RESULTADO --}}
  <div class="container table-responsive mb-5 p-sm-0">
    <table class="table table-striped table-hover" id="mitable">
      <thead class="color-head">
        <tr>

  

          <th class="th-head border-th separador-v" colspan="1">FECHA RECEPCION</th>
            <!-- BY ARIEL- Solo para el proyecto KYOCERA -->
    @if(strtoupper($cliente_seleccionado) == "KYOCERA"  || $con_razonSocial == "si")
          <th class="th-head border-th separador-v" colspan="1">RAZON SOCIAL</th>
          <th class="th-head border-th separador-v" colspan="1">TIPO</th>
        @endif
          <th class="th-head border-th separador-v" colspan="1">ASIGNACION CORDINADORA</th>
          <th class="th-head border-th separador-v" colspan="1">FECHA INICIO</th>
          <th class="th-head border-th separador-v" colspan="1">FECHA CIERRE</th>
          <th class="th-head border-th separador-v" colspan="1">ESTADO DESPACHO</th>
          <th class="th-head border-th separador-v" colspan="1">ESTADO INSTALACION</th>
          <th class="th-head border-th separador-v" colspan="1">ESTADO OPCION</th>
          <th class="th-head border-th separador-v" colspan="1">CLIENTE</th>
          <th class="th-head border-th separador-v" colspan="1">PROYECTO</th>
          <th class="th-head border-th separador-v" colspan="1">REGION</th>
          <th class="th-head border-th separador-v" colspan="1">COMUNA</th>
          <th class="th-head border-th separador-v" colspan="1">DIRECCION | CUI</th>
          <th class="th-head border-th separador-v" colspan="1">ID SALA</th>

          <th class="th-head border-th separador-v" colspan="1">N° DE SERIE</th>
          <th class="th-head border-th"><span class="material-icons">settings</span></th>
        </tr>
      </thead>
      <tbody>
        @foreach ($instalaciones as $los_datos)
        <tr>
          <td class="td-val">
            {{Carbon\Carbon::createFromDate($los_datos->fecha_registrado)->format('d-m-Y')}}
          </td>
          @if(strtoupper($cliente_seleccionado) == "KYOCERA" || $con_razonSocial == "si")
              <td class="td-val">
                {{$los_datos->razonSocial ?? ''}}
              </td>
              <td class="td-val">
                {{$los_datos->tipo ?? ''}}
              </td>
              @endif
          <td class="td-val">
            @if($los_datos->fecha_instalacion_coordinadora != "" || $los_datos->fecha_instalacion_coordinadora != null )
            {{Carbon\Carbon::createFromDate($los_datos->fecha_instalacion_coordinadora )->format('d-m-Y')}}
            @else
            @endif
          </td>
          @php
          $fechas = DB::table('asignacion_instalacions')
          ->join("checklist_instalacions","checklist_instalacions.asignacion_instalacion_retiro_id","=","asignacion_instalacions.id")
          ->select('checklist_instalacions.fecha_inicio','checklist_instalacions.fecha_fin')
          ->where('asignacion_instalacions.lista_instalacion_id','=',$los_datos->id)
          ->orderBy('checklist_instalacions.id', 'desc')
          ->get();

          $fecha_inicio = "";
          $fecha_fin = "";
          if(count($fechas) != 0){
          if($fechas[0]->fecha_inicio != "" || $fechas[0]->fecha_fin != "" ){
          $fecha_inicio = Carbon\Carbon::createFromDate($fechas[0]->fecha_inicio)->format('d-m-Y H:i:s');
          $fecha_fin = Carbon\Carbon::createFromDate($fechas[0]->fecha_fin)->format('d-m-Y H:i:s');
          }
          }
          @endphp
          <td>{{$fecha_inicio}}</td>
          <td>{{$fecha_fin}}</td>
          <td class="td-val">
            {{ucfirst($los_datos->sEstado_despacho ?? '')}} <br> Ins. : {{ucfirst($los_datos->instalador ?? '')}}
          </td>
          @if ($los_datos->sEstado_instalacion == "revisar")
          <td style="text-transform: uppercase" class="revisado td-val"> {{ucfirst($los_datos->sEstado_instalacion ?? '')}}</td>
          @else
          <td style="text-transform: uppercase" class="td-val"> {{ucfirst($los_datos->sEstado_instalacion ?? '')}}</td>
          @endif
          <td class="td-val">{{$los_datos->i_opcion_estado_instalacion ?? ''}}</td>
          <td class="td-val">{{$los_datos->sCliente ?? ''}}</td>
          @if($los_datos->nombre == "Global")
          <td class="td-val">Sin asociar</td>
          @else
          <td class="td-val">{{$los_datos->nombre ?? ''}}</td>
          @endif
          <td class="td-val">{{$los_datos->sRegion ?? ''}}</td>
          <td class="td-val">{{$los_datos->sComuna ?? ''}}</td>
          <td class="td-val">{{$los_datos->sDireccion ?? ''}} <br>
            CUI : {{$los_datos->sCui ?? ''}}
          </td>
          <td class="td-val">{{$los_datos->idSala ?? ''}}</td>

          @if($los_datos->Csserie_remplazo != null || $los_datos->Csserie_remplazo != "")
          <td class="td-val">{{$los_datos->Csserie_remplazo ?? ''}}</td>
          @else
          {{-- Este metodo permite ir y busca una serie de remplazo, si esque tubiera --}}
          @php
          $cssSerie = "";
          $consulta = DB::table('asignacion_instalacions')
          ->JOIN("checklist_instalacions","checklist_instalacions.asignacion_instalacion_retiro_id","=","asignacion_instalacions.id")
          ->select('checklist_instalacions.Csserie_remplazo')
          ->where('asignacion_instalacions.lista_instalacion_id','=',$los_datos->id)
          ->orderBy('checklist_instalacions.id', 'desc')
          ->LIMIT(1)
          ->get();
          if(count($consulta) > 0){
          if($consulta[0]->Csserie_remplazo != "" || $consulta[0]->Csserie_remplazo != null) {
          $cssSerie = $consulta[0]->Csserie_remplazo;
          }else{
          $cssSerie = $los_datos->sSerie;
          }
          }else{
          $cssSerie = $los_datos->sSerie;
          }
          @endphp
          <td class="td-val">{{$cssSerie}}</td>
          @endif
          {{-- ACCIONES --}}
          <td class="td-val">
            <div class="dropdown dropleft" style="text-align: center;">

              <button type="button" class="btn-dropdown" data-toggle="dropdown">
                <span class="material-icons">more_vert</span>
              </button>
              <div class="dropdown-menu mostrar shadow">
                <div class="d-flex justify-content-around">
                  <a role="button" class="btn-icon btn-icon-dd ver_historial_instalacion" title="Ver Detalle" data-id="{{Crypt::encryptString($los_datos->id)}}">
                    <span class="material-icons">visibility</span>
                  </a>
                  <a role="button" class="btn-icon btn-icon-dd ver_historial" title="Revisar" data-id="{{Crypt::encryptString($los_datos->id)}}" data-estado="{{$los_datos->sEstado_despacho}}">
                    <span class="material-icons">history</span>
                  </a>
                  <a role="button" title="Historial" data-id="{{Crypt::encryptString($los_datos->id)}}" class="ver_historial_check">
                    <span class="material-icons-round">
                      info
                    </span>
                  </a>
                </div>
              </div>
            </div>
          </td>
        </tr>
        @endforeach
      </tbody>
    </table>
  </div>

</form>






{{-- /////////////////////////MODALLLL//////////// --}}
<!--Modal Historial instalacion-->
<div class="modal" id="modalver_historial_check">
  <div class="modal-dialog modal-xl modal-3xl modal-dialog-scrollable modal-dialog-centered" >
    <div class="modal-content">
      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title"> Historial</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <div class="container">
          <table class="table table-bordered table-responsive table-striped">
            <thead>
              <th scope="col">N° de atencion</th>
              <th scope="col">Tecnico</th>
              <th scope="col">Estado opción</th>
              <th scope="col">N° de serie</th>
              <th scope="col">Marca </th>

              <th scope="col">Modelo </th>
              <th scope="col">Direccion</th>
              <th scope="col">Region</th>
              <th scope="col">Comuna</th>
              <th scope="col">Cliente</th>
              <th scope="col">Fecha</th>
              <th scope="col">Contador B/N</th>
              <th scope="col">Contador Color</th>
              <th scope="col">Tipo Visita</th>
              <th scope="col">Observaciones</th>
              <th scope="col">Accesorios</th>
            </thead>
            <tbody id="agregar_historial_instalacion"></tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modal_historial_instalacion" role="dialog">
  <div class="modal-dialog  modal-lg modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <div class="seccion-modal">Historial de Checklist</div>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador ml-4 mr-4">

      <div class="modal-body">
        <div class="container text-center">
          <form action="{{route('go.asignar_check')}}" method="get">
            <input type="hidden" style="display: none" name="url_filtro" value="{{url()->full()}}">
            <button type="submit" class="btn btn-prim px-sm-4" id="btnview">
              <input type="text" value="" id="m_id_instalacion" name="idintalacion" style="display:none">
              Asignar</h3>
            </button>
          </form>
        </div>
      </div>
      <!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->

      <!-- TABLA DE RESULTADOS DE BUSQUEDA -->
      <div class="container mb-4">
        <table class="table table-sm table-bordered table-responsive-md table-striped table-hover mt-4" style="margin: 0" id="dataGrid">
          <!-- ENCABEZADO -->
          <thead class="color-head">
            <tr>
              <th class="th-head border-th separador-v" colspan="1">CODIGO</th>
              <th class="th-head border-th separador-v" colspan="1">FECHA ASIGNADA</th>
              <th class="th-head border-th separador-v" colspan="1">TECNICO</th>
              <th class="th-head border-th separador-v" colspan="1">ESTADO</th>
              <th class="th-head border-th">
                <span class="material-icons">settings</span>
              </th>
            </tr>
          </thead>
          <!-- FIN ENCABEZADO -->
          <!-- RESULTADOS -->
          <tbody id="cuerpo_tabla">
          </tbody>
          <!-- FIN RESULTADOS -->
        </table>
      </div>




    </div>
  </div>
</div>

<!-- MODAL DETALLE DE INSTALACIÓN DE EQUIPOS -->
<div class="modal fade" id="modal_historial_detalle" role="dialog">
  <div class="modal-dialog  modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <div class="seccion-modal">DETALLE DE INSTALACIÓN DE EQUIPOS</div>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador ml-4 mr-4">

      <form>
        <div class="modal-body">
          <div class="container">
            <!-- sombra de separación con el fondo -->
            <div class="row ">

              <!-- Fila 1 ------------------------------------------------------>
              <div class="col-sm-3 form-group">
                <label for="email">Folio</label>
                <input type="text" readonly="readonly" class="form-control locked tex-modal-input" id="folioretiro" placeholder="FOLIO" name="folioretiro">
              </div>
              <div class="col-sm-3 form-group">
                <label for="email">Guía</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="guiaretiro" placeholder="GUÍA" name="guiaretiro">
              </div>

              <div class="container">
                <hr class="linea">
              </div>

              <!-- Detalle del Cliente -->
              <div class="col-sm-12 ">
                <div class="seccion-filtro">Detalle del cliente</div>
                <hr class="separador">
              </div>
              <!-- Fila 2 ------------------------------------------------------>
              <div class=" col-sm-3 form-group">
                <label for="email">Cliente</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="clienteretiro" placeholder="CLIENTE" name="clienteretiro">
              </div>
              <div class=" col-sm-3 form-group">
                <label for="email">Rut</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="rutretiro" placeholder="RUT" name="rutretiro">
              </div>
              <div class=" col-sm-3 form-group">
                <label for="email">Región</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="regionretiro" placeholder="REGIÓN" name="regionretiro">
              </div>
              <div class=" col-sm-3 form-group">
                <label for="email">Ciudad</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="ciudadretiro" placeholder="HORA DE TERMINO" name="ciudadretiro">
              </div>
              <!-- Fila 3 ------------------------------------------------------>
              <div class=" col-sm-6 form-group">
                <label for="email">Dirección</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="direccionretiro" placeholder="DIRECCIÓN" name="direccionretiro">
              </div>
              <div class=" col-sm-3 form-group">
                <label for="email">Comuna</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="comunaretiro" placeholder="COMUNA" name="comunaretiro">
              </div>
              <div class=" col-sm-3 form-group">
                <label for="email">CUI o Cod Sucursal</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="codigoretiro" placeholder="CUI O CÓDIGO SUCURSAL" name="codigoretiro">
              </div>

              <div class="container">
                <hr class="linea">
              </div><br>

              <!-- Detalle de Equipamiento -->
              <div class="col-12">
                <div class="seccion-filtro">Detalle de equipamiento</div>
                <hr class="separador">
              </div>
              <!-- Fila 4 ------------------------------------------------------>
              <div class=" col-sm-3 form-group">
                <label for="email">Serie</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="serieretiro" placeholder="SERIE" name="serieretiro">
              </div>
              <div class=" col-sm-3 form-group">
                <label for="email">Modelo</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="modeloretiro" placeholder="MODELO" name="modeloretiro">
              </div>
              <div class=" col-sm-3 form-group">
                <label for="email">Contador B/N</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="contadorretiro" placeholder="CONTADOR B/N" name="contadorretiro">
              </div>
              <div class=" col-sm-3 form-group">
                <label for="email">Contador color</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="colorcontadorretiro" placeholder="CONTADOR COLOR" name="colorcontadorretiro">
              </div>
              <!-- Fila 5 ------------------------------------------------------>
              <div class="container">
                <hr class="linea">
              </div>

              <div class=" col-sm-12 form-group checkbox">
                <label for="cambio">Observaciones</label>
                <textarea readonly="readonly" class="form-control locked tex-modal-input" id="obs" name="obsercaviones" rows="4"></textarea>
              </div>

              <div class="container">
                <hr class="linea">
              </div>
              <!-- Fila 6 ------------------------------------------------------>
              <div class=" col-sm-6 form-group">
                <label for="email">Estado</label>
                <input type="" readonly="readonly" class="form-control locked tex-modal-input" id="" placeholder="ESTADO" name="">
              </div>
              <div class=" col-sm-6 form-group"></div>

            </div>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>





@endsection

<script>
  $(document).ready(function() {
    $('.ver_historial_check').click(function() {
      id = $(this).attr("data-id");
      $.ajax({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        type: 'POST',
        url: "{{ route('go.historial_check_instalacions') }}",
        data: {
          'id': id
        },
        success: function(data) {
          console.log(data);
          $('#agregar_historial_instalacion').empty();
          $("#modalver_historial_check").modal('show');
          $('#agregar_historial_instalacion').append(data)
        },
        error: function(xhr, status) {
          alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
        }
      })
    })
    $('.ver_historial').click(function() {
      var id_instalacion = $(this).attr("data-id");
      $("#m_id_instalacion").val(id_instalacion)


      var _token = $('input[name="_token"]').val();


      $.ajax({


        method: "POST",

        url: "{{ route('checklist.asociados') }}",

        data: {
          'id_instalacion': id_instalacion,
          _token: _token
        },

        success: function(data) {
          console.log(data);

          $(cuerpo_tabla).empty();
          $(cuerpo_tabla).append(data);
          $("#modal_historial_instalacion").modal('show');
          //validacion del boton
          var toma2 = "";
          //estado con boton
          var cancel = "cancelado";

          //estados sin boton
          var pend = "pendiente";
          var revis = "revisado";
          var asigna = "asignado";
          var fina = "finalizado";
          var recha = "rechazado";

          //funcion para botener el estado de la primera fila
          $.each($("#dataGrid:eq(0)"), function() {
            toma2 = $(this).find('td').eq(3).html();
            console.log(toma2);


            //estados sin boton
            if (toma2 == 'cancelado' || toma2 == "Cancelado") {
              $('#btnview').show();
            } else if (toma2 == pend || toma2 == "Pendiente") {
              $('#btnview').show();
            } else if (toma2 == fina || toma2 == "Finalizado") {
              $('#btnview').hide();
            } else if (toma2 == asigna || toma2 == "Asignado") {
              $('#btnview').hide();
            } else if (toma2 == revis || toma2 == "Revisado") {
              $('#btnview').hide();
            } else if (toma2 == recha || toma2 == "Rechazado") {
              $('#btnview').hide();
            } else if (toma2 == "revisar" || toma2 == "Revisar") {
              $('#btnview').hide();
            } else if (toma2 == "tarea_asignada" || toma2 == "Tarea_asignada" || toma2 == "Tarea Asignada") {
              $('#btnview').hide();
            } else if (data == '<tr><td>Sin Datos</td></tr>') {
              $('#btnview').show();
            }


          });


        },

        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });

    })
  })

  $('.ver_historial_instalacion').click(function() {
    // var descripcion_pago = $(this).attr("data-descripcion_pago");
    // $("#mi_descripcion").text(descripcion_pago)
    $("#modal_historial_detalle").modal('show');

  });
</script>





<script>
  $(document).ready(function() {


    $("#region").change(function() {


      region = $('select[id=region]').val();
      var _token = $('input[name="_token"]').val();

      $.ajax({
        method: "POST",

        url: "{{ route('buscarComunas') }}",

        data: {
          'region': region,
          _token: _token,
          'cliente': $("#clientes").val()
        },

        success: function(data) {
          $("#comuna").empty();
          $("#direccion").empty();
          $("#sucursal").empty();

          $("#comuna").append('<option value="">Seleccionar</option>');
          $("#direccion").append('<option value="">Seleccionar</option>');
          $("#sucursal").append('<option value="">Seleccionar</option>');
          $(data).each(function(i, v) { // indice, valor
            //if(v.sComuna != null || v.sComuna != "null"  ){ 
            $("#comuna").append('<option value="' + v.sComuna + '">' + v.sComuna + '</option>');
          })
          // }

        },

        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });
    });
    $("#comuna").change(function() {
      comuna = $('select[id=comuna]').val();
      var _token = $('input[name="_token"]').val();



      $.ajax({
        method: "POST",

        url: "{{ route('buscardirecciones') }}",

        data: {
          'comuna': comuna,
          _token: _token,
          'cliente': $("#clientes").val()
        },

        success: function(data) {
          $("#direccion").empty();
          $("#sucursal").empty();
          $("#direccion").append('<option value="">Seleccionar</option>');
          $("#sucursal").append('<option value="">Seleccionar</option>');

          $(data).each(function(i, v) { // indice, valor
            //if(v.sdireccion != null || v.sdireccion != "null"  ){ 
            $("#direccion").append('<option value="' + v.sDireccion + '">' + v.sDireccion + '</option>');
          })
          // }

        },

        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });
    });

    $("#direccion").change(function() {
      direccion = $('select[id=direccion]').val();
      var _token = $('input[name="_token"]').val();


      $.ajax({
        method: "POST",

        url: "{{ route('buscarsucursales') }}",

        data: {
          'direccion': direccion,
          _token: _token,
          'cliente': $("#clientes").val()
        },

        success: function(data) {
          $("#sucursal").empty();
          $("#sucursal").append('<option value="">Seleccionar</option>');

          $(data).each(function(i, v) { // indice, valor
            //if(v.ssucursal != null || v.ssucursal != "null"  ){ 
            $("#sucursal").append('<option value="' + v.sTipo_sucursal + '">' + v.sTipo_sucursal + '</option>');
          })
          // }

        },

        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });
    });

    $('.ver_historial_instalacion').click(function() {
      var id_instalacion = $(this).attr("data-id");
      $("#m_id_instalacion").val(id_instalacion)


      var _token = $('input[name="_token"]').val();
      $("#modal_historial_detalle").modal('show');
      $.ajax({
        method: "POST",

        url: "{{ route('datos_instalacion') }}",

        data: {
          'id_instalacion': id_instalacion,
          _token: _token
        },

        success: function(data) {
          console.log(data);
          $.each(data, function(i, item) {

            $("#folioretiro").val(item.nFolio);
            $("#guiaretiro").val(item.nGuia);
            $("#clienteretiro").val(item.sCliente);
            $("#rutretiro").val(item.sRut);
            $("#regionretiro").val(item.sRegion);
            $("#ciudadretiro").val(item.sCiudad);
            $("#direccionretiro").val(item.sDireccion);
            $("#comunaretiro").val(item.sComuna);
            $("#codigoretiro").val(item.sCui);
            $("#comunaretiro").val(item.sComuna);
            $("#serieretiro").val(item.sSerie);
            $("#modeloretiro").val(item.sModelo);
            $("#contadorretiro").val(item.nContador);
            $("#colorcontadorretiro").val(item.nContador_color);
            $("#obs").val(item.sObservacion);
          });

        },

        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });


    });
  });
</script>

<script>
  //Get the button
  var mybutton = document.getElementById("myBtn");

  // When the user scrolls down 20px from the top of the document, show the button
  window.onscroll = function() {
    scrollFunction()
  };

  function scrollFunction() {
    if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
      mybutton.style.display = "block";
    } else {
      mybutton.style.display = "none";
    }
  }

  // When the user clicks on the button, scroll to the top of the document
  function topFunction() {
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;
  }
</script>
<script>
  $(document).ready(function() {
    $('#vaciar_fecha1').click(function() {
      $('#datepicker').val("");
    });
    $('#vaciar_fecha2').click(function() {
      $('#datepicker2').val("");
    });
  });
</script>

<script>
  function actualizar_regiones() {
    var _token = $('input[name="_token"]').val();

    $.ajax({
      method: "GET",

      url: "{{ route('go.actualizarregiones') }}",

      data: {
        _token: _token
      },

      success: function(data) {
        alert("proceso Completado");
        location.reload();

      },

      error: function(xhr, status) {
        alert('Disculpe, ha ocurrido un problema, intente mas tarde');
      }

    });

  }
</script>

<style>
.modal-3xl{
        max-width: 1900 !important;
  
}
</style>