<?php

namespace App\Http\Controllers\gastosreembolsos;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
use Crypt;
use Auth;
use App\User;
use App;
use DB;
use Carbon\Carbon;


use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class solicitudes_acep_recha extends Controller
{
    public function __construct()

    {

        $this->middleware('auth');

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        
   




       

        if($request->opcion == 1){   //aceptado
            $porciones = explode("!--!", $request->cuenta_);
            $id_sucursal = $porciones[0];
         


            if($request->cuenta_ == "Sin Registros, Ingrese Un Sucursal" || $request->cuenta_ == "Seleccionar" || $request->cuenta_ == "" || $request->cuenta_ == null){
                return back()->with('mensaje_error', 'Compruebe Datos Ingresados'); 
            }
            $id_banco = $porciones[1];
    
        }
    
        if($request->descripcion_gasto == "" || $request->descripcion_gasto == null){
            return back()->with('mensaje_error', 'Ingrese Todos Los Datos Solicitados'); 
        }

      
        

  

        //obteniendo la fecha actual
             $fecha_actual_ = Carbon::now();
             $fecha_actual =$fecha_actual_->format('Y-m-d');
        // ***************************************************************

        // Obtener los datos del administrador que esta ejecutando la accion
            $datos_administrador = DB::table('administradors')        
            ->where('administradors.id_login','=',Auth::user()->id)
            ->get();
             $id_admi = $datos_administrador[0]->id;
        // ************************************************************
 
         //opcion uno es aceptado, opcion 2 es rechazado
        if($request->opcion == 1){  


            $estado_selecionado = 1; //solicitud aceptada
            $fecha_depositado = $request->fecha_depositado;
            $estado_vista_usuario = 3; // 3 aceptado
            $derscripcion_giro ="aceptado";
            $total_reembolsar = $request->total_reem;


           

                // return "uno";
        }else{

            $estado_selecionado = 2;//solicitud rechazada
            $fecha_depositado =  $fecha_actual;  // noce pudo colocar 0000-00-00
            $estado_vista_usuario = 4; // 4 rechazado
            $derscripcion_giro ="rechazada";
            $total_reembolsar = 0;
            // return "dos";
        }



 
        //guardamos en la tabla, estado final de las solicitudes
             $estado_soli = new App\estado_final_solicitudes;
             $estado_soli->descripcion = $request->descripcion_gasto." Total Reembolso: ".$request->total_reem;
             $estado_soli->fecha_respondido = $fecha_actual;
             $estado_soli->fecha_depositado = $fecha_depositado;       
             $estado_soli->estado_actual = $estado_selecionado;
             $estado_soli->id_administrado = $id_admi;
             $estado_soli->id_solicitud_reembolsos = $request->id_solicitud_reembolso;
             $estado_soli->timestamps = false; 
             $estado_soli->save();
        // **********************************************************************
          
        //obtenemos los datos de la solicitud, para obtener la id, del trabajador y le damos un ok a la tabla de solicitudes recibidas
             $datos_solicitud =  App\solicitudes_reembolsos::findOrfail($request->id_solicitud_reembolso);
             $id_trabajador = $datos_solicitud->id_trabajador;                                    
             $datos_solicitud->estado_solicitud = 2; //2 significa que la solicitud, ya fue respondida
             $datos_solicitud->timestamps = false; 
             $datos_solicitud->save();
        
         //le damos ok, las solicitudes vistas por el usuario
            $gastos_historial =  App\gastos_historial::findOrfail($datos_solicitud->gasto_historial);
            $gastos_historial->estado = $estado_vista_usuario;//
            $gastos_historial->timestamps = false; 
            $gastos_historial->save();

            // $total_reembolsar = $gastos_historial->total;
            
            $datos_trabajadores = App\trabajador::findOrfail($id_trabajador);
            $id_billetera =   $datos_trabajadores->id_billetera;

            if($request->opcion == 1){  
                $billetera_virtual =  App\billetera_virtual::findOrfail($id_billetera);
                $billetera_virtual->total_acumulado = $billetera_virtual->total_acumulado + $total_reembolsar;
                $billetera_virtual->fecha_actualizado_acumulado = Carbon::now();
                $billetera_virtual->timestamps = false; 
                $billetera_virtual->save();

                $deposito_mensuals = new App\deposito_mensual;
                $deposito_mensuals->titulo_deposito = "reembolso";
                $deposito_mensuals->descripcion_deposito= "reembolso";
                $deposito_mensuals->fecha_realizado = $fecha_depositado;
                $deposito_mensuals->id_administrado = $id_admi;
                $deposito_mensuals->total = $request->total_reem;
                $deposito_mensuals->id_tipo_cuenta = $id_sucursal;   
                $deposito_mensuals->id_banco= $id_banco;  
                $deposito_mensuals->id_billetera =$id_billetera;
                $deposito_mensuals->timestamps = false;  
                $deposito_mensuals->save();

                //reembolsando lo pendiente
                $total_a_reembolso = $request->total_reem;
                $total_reembolso = $request->total_reem_noborrar;
                
        
                if($total_a_reembolso < $total_reembolso  ){


                        //si viene chekeado
                    if(!empty($request->opciones_checked)){

                        $resultado = $total_reembolso - $total_a_reembolso;

                        $billetera_virtual =  App\billetera_virtual::findOrfail($id_billetera);
                        $billetera_virtual->total_acumulado = $billetera_virtual->total_acumulado + $resultado;
                        $billetera_virtual->fecha_actualizado_acumulado = Carbon::now();
                        $billetera_virtual->timestamps = false; 
                        $billetera_virtual->save();
        
                        $deposito_mensuals = new App\deposito_mensual;
                        $deposito_mensuals->titulo_deposito = "Reajuste";
                        $deposito_mensuals->descripcion_deposito= "Reajuste";
                        $deposito_mensuals->fecha_realizado = $fecha_depositado;
                        $deposito_mensuals->id_administrado = $id_admi;
                        $deposito_mensuals->total = $resultado;
                        $deposito_mensuals->id_tipo_cuenta = $id_sucursal;   
                        $deposito_mensuals->id_banco= $id_banco;  
                        $deposito_mensuals->id_billetera =$id_billetera;
                        $deposito_mensuals->timestamps = false;  
                        $deposito_mensuals->save();
                }
              
                   
                }



            }else{
                $billetera_virtual =  App\billetera_virtual::findOrfail($id_billetera);
                $billetera_virtual->total_gastos = $billetera_virtual->total_gastos + 0;
                $billetera_virtual->fecha_actualizado_gasto = Carbon::now();
                $billetera_virtual->timestamps = false; 
                $billetera_virtual->save();
            }
      
            $giro = new App\giros;
            $giro->derscripcion = $derscripcion_giro;
            $giro->fecha_realizado = $fecha_actual;
            $giro->total = $total_reembolsar;
            $giro->id_administrado = $id_admi;
            $giro->id_solicitud_reembolsos = $request->id_solicitud_reembolso;
            $giro->id_billetera = $id_billetera;
            $giro->timestamps = false; 
            $giro->save();

            $total_a_reembolso = $request->total_reem;
            $total_reembolso = $request->total_reem_noborrar;
    
            if($total_a_reembolso < $total_reembolso  ){
                //si viene chekeado
                if(!empty($request->opciones_checked)){

                    $resultado = $total_reembolso - $total_a_reembolso;
                    $giro = new App\giros;
                    $giro->derscripcion = "Reajuste";
                    $giro->fecha_realizado = $fecha_actual;
                    $giro->total = $resultado;
                    $giro->id_administrado = $id_admi;
                    $giro->id_solicitud_reembolsos = $request->id_solicitud_reembolso;
                    $giro->id_billetera = $id_billetera;
                    $giro->timestamps = false; 
                    $giro->save();

                }

              
       }
              
// return $giros;
            return back()->with('mensaje', 'Accion terminada con Exito'); 


        // return $estado_soli;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function aceptando_sin_reembolso($id)
    {

        $porciones = explode("<->", $id);
        $id_reembolso = $porciones[0];
        $id_trabajador = $porciones[1];


        //obteniendo la fecha actual
        $fecha_actual_ = Carbon::now();
        $fecha_actual =$fecha_actual_->format('Y-m-d');
   // ***************************************************************

   // Obtener los datos del administrador que esta ejecutando la accion
       $datos_administrador = DB::table('administradors')        
       ->where('administradors.id_login','=',Auth::user()->id)
       ->get();
        $id_admi = $datos_administrador[0]->id;
   // ************************************************************
        $estado_selecionado = 3; //solicitud aceptada/noreembolsada
        $fecha_depositado = $fecha_actual;
        $estado_vista_usuario = 5; // 5 aceptado/noreembolsado
        $derscripcion_giro ="aceptado";


        $estado_soli = new App\estado_final_solicitudes;
        $estado_soli->descripcion = "sin Reembolso";
        $estado_soli->fecha_respondido = $fecha_actual;
        $estado_soli->fecha_depositado = $fecha_actual;       
        $estado_soli->estado_actual = $estado_selecionado;
        $estado_soli->id_administrado = $id_admi;
        $estado_soli->id_solicitud_reembolsos = $id_reembolso;
        $estado_soli->timestamps = false; 
        $estado_soli->save();

                //obtenemos los datos de la solicitud, para obtener la id, del trabajador y le damos un ok a la tabla de solicitudes recibidas
                $datos_solicitud =  App\solicitudes_reembolsos::findOrfail($id_reembolso);
                $id_trabajador = $datos_solicitud->id_trabajador;                                    
                $datos_solicitud->estado_solicitud = 2; //2 significa que la solicitud, ya fue respondida
                $datos_solicitud->timestamps = false; 
                $datos_solicitud->save();
           
            //le damos ok, las solicitudes vistas por el usuario
               $gastos_historial =  App\gastos_historial::findOrfail($datos_solicitud->gasto_historial);
               $gastos_historial->estado = $estado_vista_usuario;//
               $gastos_historial->timestamps = false; 
               $gastos_historial->save();

               $datos_trabajadores = App\trabajador::findOrfail($id_trabajador);
               $id_billetera =   $datos_trabajadores->id_billetera;

               $giro = new App\giros;
               $giro->derscripcion = "aceptado/noreembolso";
               $giro->fecha_realizado = $fecha_actual;
               $giro->total = 0;
               $giro->id_administrado = $id_admi;
               $giro->id_solicitud_reembolsos = $id_reembolso;
               $giro->id_billetera = $id_billetera;
               $giro->timestamps = false; 
               $giro->save();
   

               return back()->with('mensaje', 'Solicitud Aceptada Agregada'); 


    }
}
