<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <?php
    if (config('gain.installed') && DB::table('settings')->where('setting_name', '=', 'app_name')->exists()) {
        $app_name = DB::table('settings')->where('setting_name', 'app_name')->select('setting_value')->first()->setting_value;
    } else {
        $app_name = "";
    }

    ?>

    <?php if(!$app_name): ?>
        <title><?php echo $__env->yieldContent('title'); ?></title>
    <?php else: ?>
        <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e($app_name); ?></title>
<?php endif; ?>

<!-- Styles -->
<?php
$appDetails = config('gain');
$cssLinks = [
    [
        'comment' => '<!--Import favicon-->',
        'assets' => asset('images/favicon/favicon.png'),
        'rel' => 'shortcut icon',
        'media' => '',
    ],
    [
        'comment' => '<!--Import bootstrap.css-->',
        'assets' => asset('bootstrap/css/bootstrap.css'),
        'rel' => 'stylesheet',
        'media' => "screen,projection"
    ],
    [
        'comment' => '<!--Import style.css-->',
        'assets' => asset('scss/style.css'),
        'rel' => 'stylesheet',
        'media' => '',
    ],
    [
        'comment' => '<!--summernote-lite.css-->',
        'assets' => asset('summernote-0.8.9/summernote-lite.css'),
        'rel' => 'stylesheet',
        'media' => '',
    ],
    [
        'comment' => '<!--animate.css-->',
        'assets' => asset('css/animate.css'),
        'rel' => 'stylesheet',
        'media' => '',
    ],

];
foreach ($cssLinks as $cssLink) {
    if ($cssLink['comment']) {
        echo $cssLink['comment'] . "\n";
    }

    if ($cssLink['media']) {
        echo "<link href='" . $cssLink['assets'] . '?app_version=' . $appDetails['app_version'] . "' rel='" . $cssLink['rel'] . "' media='" . $cssLink['media'] . "'>\n";
    } else {
        echo "<link href='" . $cssLink['assets'] . '?app_version=' . $appDetails['app_version'] . "' rel='" . $cssLink['rel'] . "'>\n";
    }

}
?>

<!--Let browser know website is optimized for mobile-->
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>

</head>
<?php /**PATH /home/rmaxcl/public_html/demo/repuestos/resources/views/layouts/include/head.blade.php ENDPATH**/ ?>