<?php

namespace App\Http\Controllers\Retailmax;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\OrderItems;
use Config;
use App\Models\CustomUser;
use App\Models\Product;

use App\Models\Supplier;
use App\Models\Order;
use App\Models\Payments;
use App\Models\folios_boleta;
use App\Models\folios_factura;
use App\Models\folios_nota_cred;
use App\Models\ProductVariant;
use App\Models\product_packs;
use App\Models\price_apps;
use App\Models\pedido_web_products;
use App\Models\product_pedidos;
use App\Models\ProductAttribute;
use App\Models\ProductAttributeValue;






use DB;
//use App\User;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use App\Libraries\imageHandler;
use App\Models\Setting;
use Carbon\Carbon;


class ReFuncionesController extends Controller
{
   
    public function buscar_rut_proveedor( $rut_empresa)
    {

      
       return  Supplier::where('rut_empresa', $rut_empresa)->exists();

      

    }
    public function buscar_rut_cliente( $rut_cliente)
    {

       return  Customer::where('rut', $rut_cliente)->exists();

      
    }

    public function eliminarVentasCanceladas( $idOrders)
    {

      $Order = Order::find($idOrders);
      $Order->delete();

      $OrderItems = OrderItems::where('order_id', $idOrders)->delete();
  
return $idOrders."asd";
      //  return  Customer::where('rut', $rut_cliente)->exists();

      
    }
    public function getRestaurantes(){

      $carpeta = DB::table('app_config')->get();
      $opcion = "no";
      foreach ($carpeta as $carpet) {
  
                 if($carpet->key == "isRestaurant"){
                     $opcion = $carpet->value;
                 }
  
       }   
  
       return $opcion;
     }
    public function identificacionUsuarios()
    {
      return view('identificacion/identificacion');
    }

    public function identificacionUsuariosDemo()
    {
      return view('identificacion/identificaciondemo');
    }
   
   
    public function identificacion_confirmacion(request $re)
    {
      return redirect('/login');
    }
    public function identificacion_confirmaciondemo(request $re)
    {
      return redirect('/logindemo');
    } 
    public function pruebalogo(request $re)
    {
      $logo = Setting::select('setting_value')->where('setting_name', "app_logos")->get();
      if(count($logo)>0){
        return $logo[0]->setting_value;
      }else{
        return "";
      }
           
    }
      public function buscar_productos( $re)
      {

        $productos = "";
        if($re != "" and $re != null){

          $productos = Product::select('product_variants.purchase_price','product_variants.selling_price','title','product_variants.id','product_variants.variant_title')
          ->join("product_variants","product_variants.product_id","=","products.id")->where('pack','=',1)
          ->where('title','LIKE','%'.$re.'%')->limit(5)->get();

          //   $productos = ProductVariant::select('title','id')->where('pack','=',1)->where('title','LIKE','%'.$re.'%')->limit(3)
          // ->union($productosVariantes)->get();
        }else{
          $productos = "";
        }
        return $productos;
   
    }
    public function get_productos_editar( $re)
    {

      
     

      $productos = product_packs::select('product_variants.purchase_price','product_variants.selling_price','products.title','product_variants.variant_title','product_packs.cantidad','product_variants.id')
       ->join("product_variants","product_variants.id","=","product_packs.id_product")
       ->join("products","products.id","=","product_variants.product_id")
      // ->where('pack','=',1)
       ->where('product_packs.id_product_group','=',$re)
      ->get();

   //   SELECT products.title, product_packs.cantidad, product_packs.id FROM products INNER JOIN product_packs on products.id = product_packs.id_product WHERE product_packs.id_product_group = "129"
      // $productos = Product::select('products.title','product_variants.id','product_packs.cantidad','product_variants.variant_title')
      // ->join("product_variants","product_variants.product_id","=","products.id")
      // ->join("product_packs","product_packs.id_product","=","products.id")
      // ->where('pack','=',1)
      // ->where('product_packs.id_product_group','=',$re)->get();

      return $productos;
      $productos = "";
      if($re != "" and $re != null){
        $productos = Product::select('title','id')->where('pack','=',1)->where('title','LIKE','%'.$re.'%')->limit(5)
        ->get();
      }else{
        $productos = "";
      }
      return $productos;
 
  }

  public function obtenerNameCarpeta(){

     $carpeta = DB::table('app_config')->get();
     $name = "";
     foreach ($carpeta as $carpet) {

                if($carpet->key == "carpetaDte"){
                    $name = $carpet->value;
                }

      }   

      return $name;
    }

    public function datosVenta($idOrder){

      $cliente ="";
      $rutCliente ="";
      $cliente = Order::select('customer_id')->find($idOrder);
      $cambio ="";
      $totalCambio ="";
    

      //Obtener rut del cliente
      if($cliente->customer_id == ""){
        $rutCliente = "";
      }else{
        $cliente = Customer::select('rut')->find($cliente->customer_id );
        $rutCliente = $cliente->rut;
      }

//Obtener cambio
    $cambio = Payments::select('exchange')->where("order_id","=",$idOrder)->where("exchange","!=","0.00")->get();

    

    if(count($cambio) == 0){
      $totalCambio = 0;
     
    }else{
      $totalCambio = $cambio[0]->exchange;
    }


        $Data = array(
          'rutCliente' => $rutCliente,
          'cambio' => $totalCambio,
          'irOrder' => $idOrder,
          'bd' => base64_encode(session('nameBd89')),
          'carpeta' => $this->obtenerNameCarpeta(),
        );
      return $Data;
  
     }

     public function datosDte($idOrder){


      //Boletas
      $foliosBoleta = folios_boleta::select('numero','fecha','venta')->where("venta","=",$idOrder)->where("nulo","=","NO")->get();
      $tieneBoleta = 0;
      $fechaBoleta = 0;
      $numeroBoleta = 0;
      //https://www.rmax.cl/crucesspa/emision_dte/boletas/examples/vista_boleta_pdf.php?archivo=235&carpeta=23092021
        if(count($foliosBoleta) == 0 ){
          $tieneBoleta = false;
          $fechaBoleta = 0;
        }else{
          $tieneBoleta = true;
          $fechaBoleta = $foliosBoleta[0]->fecha;
           $fechaBoleta = Carbon::parse($fechaBoleta)->format('dmY');
           $numeroBoleta = $foliosBoleta[0]->venta;
        }

      //Facturas
      $foliosFactura = folios_factura::select('numero','fecha','venta')->where("venta","=",$idOrder)->where("nulo","=","NO")->get();
      $tieneFactura = 0;
      $fechaFactura = 0;
      $numeroFactura = 0;
        if(count($foliosFactura) == 0 ){
          $tieneFactura = false;
        }else{
          $tieneFactura = true;
          $fechaFactura = $foliosFactura[0]->fecha;
          $fechaFactura = Carbon::parse($fechaFactura)->format('dmY');
          $numeroFactura = $foliosFactura[0]->venta;
        }

        $notasDeCreditoBoleta = false;
        $notasDeCreditoFactura = false;

        $ncBoleta = folios_nota_cred::select('venta')->where("venta","=",$idOrder)->where("boleta","!=","")->where("boleta","!=",null)->get();
        $ncFactura= folios_nota_cred::select('venta')->where("venta","=",$idOrder)->where("factura","!=","")->where("factura","!=",null)->get();

        if(count($ncBoleta) != 0){
          $notasDeCreditoBoleta = true;
        }

        if(count($ncFactura) != 0){
          $notasDeCreditoFactura = true;
        }
        
        $Data = array(
          'tieneBoleta' => $tieneBoleta,
          'fechaBoleta' => $fechaBoleta,
          'tieneFactura' => $tieneFactura,
          'fechaFactura' => $fechaFactura,
          'carpeta' => $this->obtenerNameCarpeta(),
          'numeroFactura' => $numeroFactura,
          'numeroBoleta' => $numeroBoleta,
          'notasDeCreditoBoleta'=>$notasDeCreditoBoleta,
          'notasDeCreditoFactura'=>$notasDeCreditoFactura,
        );
          return    $Data;
      }


      public function priceApp(){
        $price_apps = price_apps::where("nombre","!=","precios_mayorista_especiales")->where("nombre","!=","precios_app")->where("nombre","!=","precio_web")->get();
        return $price_apps;
      }
      public function priceAppAll(){
        $price_apps = price_apps::get();
        return $price_apps;
      }
      public function desactivarPriceApp( $id){

        $price_apps = price_apps::where('id', '=', $id)->first();
        
       if($price_apps->estado == 1){ 
        $price_apps->estado = 0;
       }else{
        $price_apps->estado = 1;
       }
        $price_apps->timestamps = false;
        $price_apps->save();
        return $price_apps;

      }
      public function modificarNombrePrecio( request $value){

        // $price_apps = price_apps::where('id', '=', $id)->first();
         $price_apps = price_apps::where('id', '=', $value->id)->first();
         $price_apps->descripcion = $value->descripcion ;
         $price_apps->timestamps = false;
         $price_apps->save();
         return $price_apps;
        
    

      }
      public function getpedidos(){
        $pedido_web_products = pedido_web_products::where("pedido_web_products.estado","=","EN PROCESO")->get();
       // $pedido_web_products = pedido_web_products::join("product_pedidos","product_pedidos.id_pedido_web_products","=","pedido_web_products.id")
       // ->where("pedido_web_products.estado","=","EN PROCESO")
       // ->get();

       return $pedido_web_products;
     }
     public function getproductspedidos($id){
       // attributeName: Array(2)
       // category_id: (...)
       // productID: (...)
       // productImage: (...)
       // taxPercentage: (...)
       // tax_id: (...)
       // tax_type: (...)
       // taxable: (...)
       // title: (...)
       // variants: (...)


       // pedido_web_products
       // $product_pedidos = product_pedidos::where("id_pedido_web_products","=",$id)->get();
       $product_pedidos = pedido_web_products::join("product_pedidos","product_pedidos.id_pedido_web_products","=","pedido_web_products.id")
       ->where("pedido_web_products.id","=",$id)->where("pedido_web_products.estado","=","EN PROCESO")
       ->get();

       
       foreach ($product_pedidos as $data  => $valor) {
       
         $produVariante = ProductVariant::where("id","=",$valor->id_product_variants)->get();

      
         $ProductAttribute = ProductAttribute::select("product_attributes.name")
         ->join("product_attribute_values","product_attribute_values.attribute_id","=","product_attributes.id")
         ->where("product_attribute_values.product_id","=",$produVariante[0]->product_id)->get();

         $Product = Product::where("id","=",$produVariante[0]->product_id)->get();

         $allProductVariant = ProductVariant::select('product_variants.*','product_variants.standar_precio_web as price' )->where("product_id","=",$produVariante[0]->product_id)->get();

         // echo $ProductAttribute;
        // print_r( $produVariante[0]->product_id);
       //   $pedido_web_products = pedido_web_products::where("id","=",$id)->get();
       // $product_pedidos = product_pedidos::where("id_pedido_web_products","=",$id)->get();
       
       $datitos[$data] = array(
         'attributeName' => $ProductAttribute,
         'category_id' =>  $Product[0]->category_id,
         'productID' =>  $produVariante[0]->product_id,
         'productImage' =>  $produVariante[0]->imageURL,
         'taxPercentage' =>  15.966386554621849,
         'tax_id' =>  $Product[0]->tax_id,
         'tax_type' =>  $Product[0]->tax_type,
         'taxable' =>  $Product[0]->taxable,
         'title' =>  $Product[0]->title,
         'ventaOnline' => "si",
         'idVariant' => $valor->id_product_variants,
         'cantidad'=>$valor->cantidad,
         'idPedido'=>$id,
         'variants' =>  $allProductVariant,
         'product_pedidos' =>  $product_pedidos,
         
         
       );
       
        
       }  
       return    $datitos;
      
     }


     public function verPedido($id){

       $pedido_web_products = pedido_web_products::where("id","=",$id)->get();
       $product_pedidos = product_pedidos::where("id_pedido_web_products","=",$id)->get();
       $datos1[] =
       [ 
               "datosCliente"=> $pedido_web_products,
               "productos"=> $product_pedidos,                              
       ];

       return response()->json($datos1, 200, []);
       

   }


   public function eliminarproductspedidos($id){

    $pedido_web_products = pedido_web_products::where('id', '=', $id)->first();
    $pedido_web_products->estado = "ELIMINADO" ;
    $pedido_web_products->timestamps = false;
    $pedido_web_products->save();

    return "OK";
    

}


public function  buscar_clientes_rut($re){

  $clientes = "";
  if($re != "" and $re != null){

    $clientes =      Customer::where('rut','LIKE','%'.$re.'%')->get();


    //   $productos = ProductVariant::select('title','id')->where('pack','=',1)->where('title','LIKE','%'.$re.'%')->limit(3)
    // ->union($productosVariantes)->get();
  }else{
    $clientes = "No Encontrado";
  }
  return $clientes;

}

public function updateVentaCliente(Request $request)
{
    // orders
    $orders = order::where('id', '=', $request->idOrder)->first();
    $orders->customer_id = $request->idCliente ;
     $orders->timestamps = false;
     $orders->save();

return $orders;
}
      
 }