<?php

namespace App\Http\Controllers\Apis;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer;
use App\Models\OrderItems;
use Config;
use App\Models\CustomUser;
use App\Models\Product;
use App\Models\pedido_web_products;
use App\Models\product_pedidos;

use App\Models\ShippingArea;

use App\Models\Supplier;
use App\Models\Order;
use App\Models\Payments;
use App\Models\folios_boleta;
use App\Models\folios_factura;
use App\Models\folios_nota_cred;
use App\Models\ProductBrand;
use App\Models\ProductCategory;
use App\Models\ProductVariant;
use App\Models\product_tags;
use App\Models\product_images;
use App\Models\product_collecions;
use Illuminate\Support\Facades\Crypt;


use DB;
//use App\User;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Lang;
use App\Libraries\imageHandler;
use App\Models\Setting;
use Carbon\Carbon;

class listaCotroller extends Controller
{
    public function getProductosLista(){

        
        $productos = Product::select('products.*','product_variants.id as idVariante','product_variants.standar_precio_web as standar_precio_web')->join("product_variants","product_variants.product_id","=","products.id")->where("product_variants.se_vende_web","=",1)->get();
        foreach ($productos as $prod) {

            $brand ="";
            $categoria="";
            $productoVariante="";
            $idVariant="";
        
            $brands = ProductBrand::select('name')->where("id","=",$prod->brand_id)->get();
            if(count($brands)!= 0){
                $brand = $brands[0]->name;
            }            
            $categorias = ProductCategory::select('name')->where("id","=",$prod->category_id)->get();
            if(count($categorias)!= 0){
                $categoria = $categorias[0]->name;
            } 
            $produVariante = ProductVariant::select('standar_precio_web','id')->where("product_id","=",$prod->id)->get();
            if(count($produVariante)!= 0){
                $productoVariante = $produVariante[0]->standar_precio_web;
                $idVariant = $produVariante[0]->id;
            }



            $datos1[] =
            [ 
                    "id"=> $prod->idVariante,
                    "title"=> $prod->title,
                    "description"=> $prod->description,
                    "type"=> $prod->type,
                    "brand"=> $brand,
                    "category"=> $categoria,
                    "price"=> $prod->standar_precio_web,
                    "discount"=> "0",
                    "stock"=> 5,
                    "img"=> $prod->imageURL,
                    "quantity"=> 0,
                    "activoCarrito"=>0,
                          
                                            
            ];
           
        }
        return response()->json($datos1, 200, []);
    }
    
    public function filtroGetProductosLista(){

        $palabras = $_GET['palabras'];
        $productos = Product::select('products.*')->join("product_variants","product_variants.product_id","=","products.id")
        ->where("product_variants.se_vende_web","=",1)
        ->where("products.title","LIKE",'%'.$palabras.'%')
        ->get();

        if(count($productos) == 0){

                return "sinresultado";


        }
        foreach ($productos as $prod) {

            $brand ="";
            $categoria="";
            $productoVariante="";
            $idVariant="";
        
            $brands = ProductBrand::select('name')->where("id","=",$prod->brand_id)->get();
            if(count($brands)!= 0){
                $brand = $brands[0]->name;
            }            
            $categorias = ProductCategory::select('name')->where("id","=",$prod->category_id)->get();
            if(count($categorias)!= 0){
                $categoria = $categorias[0]->name;
            } 
            $produVariante = ProductVariant::select('standar_precio_web','id')->where("product_id","=",$prod->id)->get();
            if(count($produVariante)!= 0){
                $productoVariante = $produVariante[0]->standar_precio_web;
                $idVariant = $produVariante[0]->id;
            }



            $datos1[] =
            [ 
                    "id"=> $idVariant,
                    "title"=> $prod->title,
                    "description"=> $prod->description,
                    "type"=> $prod->type,
                    "brand"=> $brand,
                    "category"=> $categoria,
                    "price"=> $productoVariante,
                    "discount"=> "0",
                    "stock"=> 5,
                    "img"=> $prod->imageURL,
                    "quantity"=> 0,
                    "activoCarrito"=>0,
                          
                                            
            ];
           
        }
        return response()->json($datos1, 200, []);
}
    
    public function createPedido(Request $request){

        $nombre ="";
        $correo="";
        $telefono="";
        $direccion="";
        $total="";

        

        return DB::transaction(function() use($request)
        { 


            $nombre = $request->datosPersonasles["nombre"];
            $correo= $request->datosPersonasles["correo"];
            $telefono= $request->datosPersonasles["telefono"]; 
            $direccion= $request->datosPersonasles["direccion"];
            $total= $request->datosPersonasles["total"];
            $valorDespacho= $request->datosPersonasles["valorDespacho"];
            $opcionRetiro= $request->datosPersonasles["opcionRetiro"];
            $ultimoNumero = pedido_web_products::max('numero_pedido');
           
            $pedido_web_products = new pedido_web_products();
            $pedido_web_products->total = $total;
            $pedido_web_products->cliente = $nombre;
            $pedido_web_products->direccion = $direccion;
            $pedido_web_products->telefono = $telefono;
            $pedido_web_products->correo = $correo;
            $pedido_web_products->numero_pedido  = $ultimoNumero+1;
            $pedido_web_products->estado  = "PENDIENTE DE PAGO";
            $pedido_web_products->fecha_registrado  = Carbon::now('America/Santiago');
            
            $pedido_web_products->timestamps = false;
            $pedido_web_products->opcion_retiro = $opcionRetiro;
            $pedido_web_products->valor_despacho = $valorDespacho;
            $pedido_web_products->save();
              
                foreach ($request->cart as $data) {
                   
                    $product_pedidos = new product_pedidos();
                    $product_pedidos->id_product_variants = $data['id'];
                    $product_pedidos->cantidad = $data['quantity'];
                    $product_pedidos->id_pedido_web_products = $pedido_web_products->id;
                    $product_pedidos->name = $data['title'];
                    $product_pedidos->timestamps = false;
                    $product_pedidos->save();
                
                }

                $datos1[] =
                [ 
                        "preceso"=> true,
                        "pedido"=> Crypt::encrypt($pedido_web_products->id),
                        "numeroPedido"=>  $pedido_web_products->numero_pedido,
                        "pedidoId"=>  $pedido_web_products->id,
                              
                                                
                ];

                return response()->json($datos1, 200, []);

                // return "Su Pedido esta Siendo Procesado, Numero: ". $pedido_web_products->id;
            }, 5);
       

        

    }


    public function getPedido(){
        // product_pedidos
        // pedido_web_products

        $id = Crypt::decrypt($_GET['codigo']);
        $pedido_web_products = pedido_web_products::where("id","=",$id)->get();
        $product_pedidos = product_pedidos::where("id_pedido_web_products","=",$id)->get();
        $datos1[] =
        [ 
                "datosCliente"=> $pedido_web_products,
                "productos"=> $product_pedidos,       
                                    
        ];

        return response()->json($datos1, 200, []);
    }

  //todo medio de pago
    public function setPedidoOk(request $req){
        $pedido_web_products = pedido_web_products::where("id","=",$req->codigo)->get();
        $product_pedidos = product_pedidos::where("id_pedido_web_products","=",$req->codigo)->get();
        $datos1[] =
        [ 
                "datosCliente"=> $pedido_web_products,
                "productos"=> $product_pedidos,        
                "pedido"=> Crypt::encrypt($req->codigo),                        
        ];

        return response()->json($datos1, 200, []);
     
       
    }
    public function getComunasyValores(){
        $ShippingArea = ShippingArea::get();
        
       return $ShippingArea;
    }
 
}
