<?php

use Illuminate\Http\Request;
use App\Http\Controllers\Retailmax\ReFuncionesController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|   
*/

//auth protected route
Route::group([ 'prefix' => 'v1', 'middleware' => 'auth:api'], function(){
    Route::post('details', 'API\UserController@details');
    Route::post('logout','API\UserController@logoutApi'); 
    
    Route::get('users', 'API\UserController@allusers');
    Route::get('user/{id}', 'API\UserController@views');
    Route::post('user/{id}', 'API\UserController@delete');
    Route::put('user/{id}', 'API\UserController@updates');

    Route::resource('roles', 'API\RoleController');

    Route::resource('permissions', 'API\PermissionController');

    Route::resource('emailtemplates', 'API\EmailTemplateController');


    Route::get('emailtemplates', 'API\EmailTemplateController@showlist');
    Route::get('templatelist', 'API\EmailTemplateController@templatelist');

    Route::post('invite', 'API\InviteController@process');


    Route::post('roleassign', 'API\RoleAssignController@update');

    Route::resource('profile', 'API\ProfileController');

    Route::post('/offdaysetting', 'API\SettingController@offdays');
    Route::get('/offdaysdata', 'API\SettingController@offdaysData');

});

Route::group(['prefix' => 'v1'], function() {
    //User Auth Route
    Route::post('login', 'API\UserController@login');
    Route::post('register', 'API\UserController@register');
    // Password Recover Route
    Route::post('recover', 'AuthController@recover');

    Route::post('accept/{token}', 'API\InviteController@invitedRegistration');

    Route::get('templatelist', 'API\EmailTemplateController@templatelist');

    Route::get('login', 'API\UserController@login');
});

Route::get('identificacion', 'Retailmax\ReFuncionesController@identificacionUsuarios');
Route::get('demo', 'Retailmax\ReFuncionesController@identificacionUsuariosDemo');

Route::get('clientes', 'Retailmax\ApiFuncionesController@index');
Route::post('add/clientes', 'Retailmax\ApiFuncionesController@add');
Route::get('block/clientes', 'Retailmax\ApiFuncionesController@block');
Route::post('update/clientes', 'Retailmax\ApiFuncionesController@update');
Route::get('delete/clientes', 'Retailmax\ApiFuncionesController@delete');
//rutas para la appEcomerce
Route::group(['middleware' => ['setbdweb']], function () {
    Route::get('get/productos', 'Apis\EcommerceCotroller@getProductos');
    Route::get('get/productossingle/{id}', 'Apis\EcommerceCotroller@getProductosSingle');


    //PRODUCTOS PARA LA LISTA
    Route::get('get/productoslista', 'Apis\listaCotroller@getProductosLista');
    Route::get('get/filtroproductoslista', 'Apis\listaCotroller@filtroGetProductosLista');

    Route::match(array('GET','POST'),'post/createproduct', 'Apis\listaCotroller@createPedido');
    Route::get('get/getproductsingle', 'Apis\listaCotroller@getPedido');

    //para todo medio de pago
     Route::match(array('GET','POST'),'get/setpedidook', 'Apis\listaCotroller@setPedidoOk');

    //Route::get('get/setpedidook/{codigo}', 'Apis\listaCotroller@setPedidoOk');
    Route::get('get/comunasyvalores', 'Apis\listaCotroller@getComunasyValores');

});
